; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s

define <vscale x 1 x i64> @vwadd_vv_nxv1i64(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb) {
; CHECK-LABEL: vwadd_vv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwadd.vv v10, v8, v9
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
  %vc = sext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %vd = sext <vscale x 1 x i32> %vb to <vscale x 1 x i64>
  %ve = add <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwaddu_vv_nxv1i64(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb) {
; CHECK-LABEL: vwaddu_vv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwaddu.vv v10, v8, v9
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
  %vc = zext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %vd = zext <vscale x 1 x i32> %vb to <vscale x 1 x i64>
  %ve = add <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwadd_vx_nxv1i64(<vscale x 1 x i32> %va, i32 %b) {
; CHECK-LABEL: vwadd_vx_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwadd.vx v9, v8, a0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %vc = sext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %vd = sext <vscale x 1 x i32> %splat to <vscale x 1 x i64>
  %ve = add <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwaddu_vx_nxv1i64(<vscale x 1 x i32> %va, i32 %b) {
; CHECK-LABEL: vwaddu_vx_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwaddu.vx v9, v8, a0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %vc = zext <vscale x 1 x i32> %va to <vscale x 1 x i64>
  %vd = zext <vscale x 1 x i32> %splat to <vscale x 1 x i64>
  %ve = add <vscale x 1 x i64> %vc, %vd
  ret <vscale x 1 x i64> %ve
}

define <vscale x 1 x i64> @vwadd_wv_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i32> %vb) {
; CHECK-LABEL: vwadd_wv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwadd.wv v8, v8, v9
; CHECK-NEXT:    ret
  %vc = sext <vscale x 1 x i32> %vb to <vscale x 1 x i64>
  %vd = add <vscale x 1 x i64> %va, %vc
  ret <vscale x 1 x i64> %vd
}

define <vscale x 1 x i64> @vwaddu_wv_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i32> %vb) {
; CHECK-LABEL: vwaddu_wv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwaddu.wv v8, v8, v9
; CHECK-NEXT:    ret
  %vc = zext <vscale x 1 x i32> %vb to <vscale x 1 x i64>
  %vd = add <vscale x 1 x i64> %va, %vc
  ret <vscale x 1 x i64> %vd
}

define <vscale x 1 x i64> @vwadd_wx_nxv1i64(<vscale x 1 x i64> %va, i32 %b) {
; CHECK-LABEL: vwadd_wx_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwadd.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %vb = sext <vscale x 1 x i32> %splat to <vscale x 1 x i64>
  %vc = add <vscale x 1 x i64> %va, %vb
  ret <vscale x 1 x i64> %vc
}

define <vscale x 1 x i64> @vwaddu_wx_nxv1i64(<vscale x 1 x i64> %va, i32 %b) {
; CHECK-LABEL: vwaddu_wx_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vwaddu.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %vb = zext <vscale x 1 x i32> %splat to <vscale x 1 x i64>
  %vc = add <vscale x 1 x i64> %va, %vb
  ret <vscale x 1 x i64> %vc
}

define <vscale x 2 x i64> @vwadd_vv_nxv2i64(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb) {
; CHECK-LABEL: vwadd_vv_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwadd.vv v10, v8, v9
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %vc = sext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %vd = sext <vscale x 2 x i32> %vb to <vscale x 2 x i64>
  %ve = add <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwaddu_vv_nxv2i64(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb) {
; CHECK-LABEL: vwaddu_vv_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwaddu.vv v10, v8, v9
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %vc = zext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %vd = zext <vscale x 2 x i32> %vb to <vscale x 2 x i64>
  %ve = add <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwadd_vx_nxv2i64(<vscale x 2 x i32> %va, i32 %b) {
; CHECK-LABEL: vwadd_vx_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwadd.vx v10, v8, a0
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %vc = sext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %vd = sext <vscale x 2 x i32> %splat to <vscale x 2 x i64>
  %ve = add <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwaddu_vx_nxv2i64(<vscale x 2 x i32> %va, i32 %b) {
; CHECK-LABEL: vwaddu_vx_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwaddu.vx v10, v8, a0
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %vc = zext <vscale x 2 x i32> %va to <vscale x 2 x i64>
  %vd = zext <vscale x 2 x i32> %splat to <vscale x 2 x i64>
  %ve = add <vscale x 2 x i64> %vc, %vd
  ret <vscale x 2 x i64> %ve
}

define <vscale x 2 x i64> @vwadd_wv_nxv2i64(<vscale x 2 x i64> %va, <vscale x 2 x i32> %vb) {
; CHECK-LABEL: vwadd_wv_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwadd.wv v8, v8, v10
; CHECK-NEXT:    ret
  %vc = sext <vscale x 2 x i32> %vb to <vscale x 2 x i64>
  %vd = add <vscale x 2 x i64> %va, %vc
  ret <vscale x 2 x i64> %vd
}

define <vscale x 2 x i64> @vwaddu_wv_nxv2i64(<vscale x 2 x i64> %va, <vscale x 2 x i32> %vb) {
; CHECK-LABEL: vwaddu_wv_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwaddu.wv v8, v8, v10
; CHECK-NEXT:    ret
  %vc = zext <vscale x 2 x i32> %vb to <vscale x 2 x i64>
  %vd = add <vscale x 2 x i64> %va, %vc
  ret <vscale x 2 x i64> %vd
}

define <vscale x 2 x i64> @vwadd_wx_nxv2i64(<vscale x 2 x i64> %va, i32 %b) {
; CHECK-LABEL: vwadd_wx_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwadd.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %vb = sext <vscale x 2 x i32> %splat to <vscale x 2 x i64>
  %vc = add <vscale x 2 x i64> %va, %vb
  ret <vscale x 2 x i64> %vc
}

define <vscale x 2 x i64> @vwaddu_wx_nxv2i64(<vscale x 2 x i64> %va, i32 %b) {
; CHECK-LABEL: vwaddu_wx_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vwaddu.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %vb = zext <vscale x 2 x i32> %splat to <vscale x 2 x i64>
  %vc = add <vscale x 2 x i64> %va, %vb
  ret <vscale x 2 x i64> %vc
}

define <vscale x 4 x i64> @vwadd_vv_nxv4i64(<vscale x 4 x i32> %va, <vscale x 4 x i32> %vb) {
; CHECK-LABEL: vwadd_vv_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwadd.vv v12, v8, v10
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %vc = sext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %vd = sext <vscale x 4 x i32> %vb to <vscale x 4 x i64>
  %ve = add <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwaddu_vv_nxv4i64(<vscale x 4 x i32> %va, <vscale x 4 x i32> %vb) {
; CHECK-LABEL: vwaddu_vv_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwaddu.vv v12, v8, v10
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %vc = zext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %vd = zext <vscale x 4 x i32> %vb to <vscale x 4 x i64>
  %ve = add <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwadd_vx_nxv4i64(<vscale x 4 x i32> %va, i32 %b) {
; CHECK-LABEL: vwadd_vx_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwadd.vx v12, v8, a0
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %vc = sext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %vd = sext <vscale x 4 x i32> %splat to <vscale x 4 x i64>
  %ve = add <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwaddu_vx_nxv4i64(<vscale x 4 x i32> %va, i32 %b) {
; CHECK-LABEL: vwaddu_vx_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwaddu.vx v12, v8, a0
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %vc = zext <vscale x 4 x i32> %va to <vscale x 4 x i64>
  %vd = zext <vscale x 4 x i32> %splat to <vscale x 4 x i64>
  %ve = add <vscale x 4 x i64> %vc, %vd
  ret <vscale x 4 x i64> %ve
}

define <vscale x 4 x i64> @vwadd_wv_nxv4i64(<vscale x 4 x i64> %va, <vscale x 4 x i32> %vb) {
; CHECK-LABEL: vwadd_wv_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwadd.wv v8, v8, v12
; CHECK-NEXT:    ret
  %vc = sext <vscale x 4 x i32> %vb to <vscale x 4 x i64>
  %vd = add <vscale x 4 x i64> %va, %vc
  ret <vscale x 4 x i64> %vd
}

define <vscale x 4 x i64> @vwaddu_wv_nxv4i64(<vscale x 4 x i64> %va, <vscale x 4 x i32> %vb) {
; CHECK-LABEL: vwaddu_wv_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwaddu.wv v8, v8, v12
; CHECK-NEXT:    ret
  %vc = zext <vscale x 4 x i32> %vb to <vscale x 4 x i64>
  %vd = add <vscale x 4 x i64> %va, %vc
  ret <vscale x 4 x i64> %vd
}

define <vscale x 4 x i64> @vwadd_wx_nxv4i64(<vscale x 4 x i64> %va, i32 %b) {
; CHECK-LABEL: vwadd_wx_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwadd.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %vb = sext <vscale x 4 x i32> %splat to <vscale x 4 x i64>
  %vc = add <vscale x 4 x i64> %va, %vb
  ret <vscale x 4 x i64> %vc
}

define <vscale x 4 x i64> @vwaddu_wx_nxv4i64(<vscale x 4 x i64> %va, i32 %b) {
; CHECK-LABEL: vwaddu_wx_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vwaddu.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %vb = zext <vscale x 4 x i32> %splat to <vscale x 4 x i64>
  %vc = add <vscale x 4 x i64> %va, %vb
  ret <vscale x 4 x i64> %vc
}

define <vscale x 8 x i64> @vwadd_vv_nxv8i64(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: vwadd_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwadd.vv v16, v8, v12
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %vc = sext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %vd = sext <vscale x 8 x i32> %vb to <vscale x 8 x i64>
  %ve = add <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwaddu_vv_nxv8i64(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: vwaddu_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwaddu.vv v16, v8, v12
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %vc = zext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %vd = zext <vscale x 8 x i32> %vb to <vscale x 8 x i64>
  %ve = add <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwadd_vx_nxv8i64(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: vwadd_vx_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwadd.vx v16, v8, a0
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = sext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %vd = sext <vscale x 8 x i32> %splat to <vscale x 8 x i64>
  %ve = add <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwaddu_vx_nxv8i64(<vscale x 8 x i32> %va, i32 %b) {
; CHECK-LABEL: vwaddu_vx_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwaddu.vx v16, v8, a0
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = zext <vscale x 8 x i32> %va to <vscale x 8 x i64>
  %vd = zext <vscale x 8 x i32> %splat to <vscale x 8 x i64>
  %ve = add <vscale x 8 x i64> %vc, %vd
  ret <vscale x 8 x i64> %ve
}

define <vscale x 8 x i64> @vwadd_wv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: vwadd_wv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwadd.wv v8, v8, v16
; CHECK-NEXT:    ret
  %vc = sext <vscale x 8 x i32> %vb to <vscale x 8 x i64>
  %vd = add <vscale x 8 x i64> %va, %vc
  ret <vscale x 8 x i64> %vd
}

define <vscale x 8 x i64> @vwaddu_wv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: vwaddu_wv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwaddu.wv v8, v8, v16
; CHECK-NEXT:    ret
  %vc = zext <vscale x 8 x i32> %vb to <vscale x 8 x i64>
  %vd = add <vscale x 8 x i64> %va, %vc
  ret <vscale x 8 x i64> %vd
}

define <vscale x 8 x i64> @vwadd_wx_nxv8i64(<vscale x 8 x i64> %va, i32 %b) {
; CHECK-LABEL: vwadd_wx_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwadd.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vb = sext <vscale x 8 x i32> %splat to <vscale x 8 x i64>
  %vc = add <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i64> %vc
}

define <vscale x 8 x i64> @vwaddu_wx_nxv8i64(<vscale x 8 x i64> %va, i32 %b) {
; CHECK-LABEL: vwaddu_wx_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vwaddu.wx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vb = zext <vscale x 8 x i32> %splat to <vscale x 8 x i64>
  %vc = add <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i64> %vc
}
