; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn -verify-machineinstrs < %s | FileCheck -check-prefix=GFX6-NOHSA %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=kaveri -verify-machineinstrs < %s | FileCheck -check-prefix=GFX7-HSA %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -verify-machineinstrs < %s | FileCheck -check-prefix=GFX8-NOHSA %s
; RUN: llc -mtriple=r600 -mcpu=redwood < %s | FileCheck -check-prefix=EG %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefix=GFX9-HSA %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx908 -verify-machineinstrs < %s | FileCheck -check-prefix=GFX9-HSA %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -verify-machineinstrs < %s | FileCheck -check-prefix=GFX12 %s

define amdgpu_kernel void @constant_load_i32(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_load_i32:
; GFX6-NOHSA:       ; %bb.0: ; %entry
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dword s4, s[2:3], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s2, -1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_load_i32:
; GFX7-HSA:       ; %bb.0: ; %entry
; GFX7-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-HSA-NEXT:    flat_store_dword v[0:1], v2
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_load_i32:
; GFX8-NOHSA:       ; %bb.0: ; %entry
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NOHSA-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 1, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_load_i32:
; GFX9-HSA:       ; %bb.0: ; %entry
; GFX9-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-HSA-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_load_i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX12-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ld = load i32, ptr addrspace(4) %in
  store i32 %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v2i32(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_load_v2i32:
; GFX6-NOHSA:       ; %bb.0: ; %entry
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s2, -1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_load_v2i32:
; GFX7-HSA:       ; %bb.0: ; %entry
; GFX7-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-HSA-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_load_v2i32:
; GFX8-NOHSA:       ; %bb.0: ; %entry
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NOHSA-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v2i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 1, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_load_v2i32:
; GFX9-HSA:       ; %bb.0: ; %entry
; GFX9-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-HSA-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_load_v2i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ld = load <2 x i32>, ptr addrspace(4) %in
  store <2 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v3i32(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_load_v3i32:
; GFX6-NOHSA:       ; %bb.0: ; %entry
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s2, -1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NOHSA-NEXT:    buffer_store_dword v0, off, s[0:3], 0 offset:8
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_load_v3i32:
; GFX7-HSA:       ; %bb.0: ; %entry
; GFX7-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-HSA-NEXT:    flat_store_dwordx3 v[3:4], v[0:2]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_load_v3i32:
; GFX8-NOHSA:       ; %bb.0: ; %entry
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NOHSA-NEXT:    flat_store_dwordx3 v[3:4], v[0:2]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v3i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 6, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.X, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR T1.X, KC0[2].Y, literal.x,
; EG-NEXT:     MOV * T2.X, T0.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR * T3.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_load_v3i32:
; GFX9-HSA:       ; %bb.0: ; %entry
; GFX9-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-HSA-NEXT:    global_store_dwordx3 v3, v[0:2], s[0:1]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_load_v3i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b96 s[4:6], s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_mov_b32 v0, s4
; GFX12-NEXT:    v_dual_mov_b32 v1, s5 :: v_dual_mov_b32 v2, s6
; GFX12-NEXT:    global_store_b96 v3, v[0:2], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ld = load <3 x i32>, ptr addrspace(4) %in
  store <3 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v4i32(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_load_v4i32:
; GFX6-NOHSA:       ; %bb.0: ; %entry
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s2, -1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_load_v4i32:
; GFX7-HSA:       ; %bb.0: ; %entry
; GFX7-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_load_v4i32:
; GFX8-NOHSA:       ; %bb.0: ; %entry
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v4i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 1, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_load_v4i32:
; GFX9-HSA:       ; %bb.0: ; %entry
; GFX9-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_load_v4i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v3, s7
; GFX12-NEXT:    v_dual_mov_b32 v1, s5 :: v_dual_mov_b32 v2, s6
; GFX12-NEXT:    global_store_b128 v4, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ld = load <4 x i32>, ptr addrspace(4) %in
  store <4 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v8i32(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_load_v8i32:
; GFX6-NOHSA:       ; %bb.0: ; %entry
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s11, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s10, -1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_load_v8i32:
; GFX7-HSA:       ; %bb.0: ; %entry
; GFX7-HSA-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX7-HSA-NEXT:    s_add_u32 s10, s8, 16
; GFX7-HSA-NEXT:    s_addc_u32 s11, s9, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v6, s10
; GFX7-HSA-NEXT:    v_mov_b32_e32 v7, s11
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[6:7], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v6, s2
; GFX7-HSA-NEXT:    v_mov_b32_e32 v7, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s9
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_load_v8i32:
; GFX8-NOHSA:       ; %bb.0: ; %entry
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX8-NOHSA-NEXT:    s_add_u32 s10, s8, 16
; GFX8-NOHSA-NEXT:    s_addc_u32 s11, s9, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v6, s10
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v7, s11
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[6:7], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v6, s2
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v7, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v8i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 4, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     LSHR T2.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T2.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR * T3.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_load_v8i32:
; GFX9-HSA:       ; %bb.0: ; %entry
; GFX9-HSA-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v5, s1
; GFX9-HSA-NEXT:    v_mov_b32_e32 v6, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v7, s3
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[8:9] offset:16
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[4:7], s[8:9]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_load_v8i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[8:11], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b256 s[0:7], s[10:11], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v8, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v3, s7
; GFX12-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v5, s1
; GFX12-NEXT:    v_dual_mov_b32 v4, s0 :: v_dual_mov_b32 v7, s3
; GFX12-NEXT:    v_mov_b32_e32 v6, s2
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v8, v[0:3], s[8:9] offset:16
; GFX12-NEXT:    global_store_b128 v8, v[4:7], s[8:9]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ld = load <8 x i32>, ptr addrspace(4) %in
  store <8 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v9i32(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_load_v9i32:
; GFX6-NOHSA:       ; %bb.0: ; %entry
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dword s12, s[10:11], 0x8
; GFX6-NOHSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s11, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s10, -1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX6-NOHSA-NEXT:    buffer_store_dword v0, off, s[8:11], 0 offset:32
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_load_v9i32:
; GFX7-HSA:       ; %bb.0: ; %entry
; GFX7-HSA-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dword s12, s[10:11], 0x8
; GFX7-HSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX7-HSA-NEXT:    s_add_u32 s10, s8, 32
; GFX7-HSA-NEXT:    s_addc_u32 s11, s9, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s10
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s11
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v6, s12
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    s_add_u32 s4, s8, 16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-HSA-NEXT:    flat_store_dword v[4:5], v6
; GFX7-HSA-NEXT:    s_addc_u32 s5, s9, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_load_v9i32:
; GFX8-NOHSA:       ; %bb.0: ; %entry
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dword s12, s[10:11], 0x20
; GFX8-NOHSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX8-NOHSA-NEXT:    s_add_u32 s10, s8, 32
; GFX8-NOHSA-NEXT:    s_addc_u32 s11, s9, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s10
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s11
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v6, s12
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    s_add_u32 s4, s8, 16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NOHSA-NEXT:    flat_store_dword v[4:5], v6
; GFX8-NOHSA-NEXT:    s_addc_u32 s5, s9, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v9i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 2 @8
; EG-NEXT:    ALU 7, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T4.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T3.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T0.X, 0, #1
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 32, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     LSHR T3.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T4.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR * T5.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_load_v9i32:
; GFX9-HSA:       ; %bb.0: ; %entry
; GFX9-HSA-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dword s12, s[10:11], 0x20
; GFX9-HSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v5, s12
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s0
; GFX9-HSA-NEXT:    global_store_dword v8, v5, s[8:9] offset:32
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[8:9] offset:16
; GFX9-HSA-NEXT:    v_mov_b32_e32 v5, s1
; GFX9-HSA-NEXT:    v_mov_b32_e32 v6, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v7, s3
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[4:7], s[8:9]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_load_v9i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[8:11], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b32 s12, s[10:11], 0x20
; GFX12-NEXT:    s_load_b256 s[0:7], s[10:11], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v8, 0 :: v_dual_mov_b32 v9, s12
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s7
; GFX12-NEXT:    v_dual_mov_b32 v4, s0 :: v_dual_mov_b32 v5, s1
; GFX12-NEXT:    v_dual_mov_b32 v6, s2 :: v_dual_mov_b32 v7, s3
; GFX12-NEXT:    s_clause 0x2
; GFX12-NEXT:    global_store_b32 v8, v9, s[8:9] offset:32
; GFX12-NEXT:    global_store_b128 v8, v[0:3], s[8:9] offset:16
; GFX12-NEXT:    global_store_b128 v8, v[4:7], s[8:9]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ld = load <9 x i32>, ptr addrspace(4) %in
  store <9 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v10i32(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_load_v10i32:
; GFX6-NOHSA:       ; %bb.0: ; %entry
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx2 s[12:13], s[10:11], 0x8
; GFX6-NOHSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s11, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s10, -1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX6-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0 offset:32
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_load_v10i32:
; GFX7-HSA:       ; %bb.0: ; %entry
; GFX7-HSA-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx2 s[12:13], s[10:11], 0x8
; GFX7-HSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX7-HSA-NEXT:    s_add_u32 s10, s8, 32
; GFX7-HSA-NEXT:    s_addc_u32 s11, s9, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s10
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v6, s12
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s11
; GFX7-HSA-NEXT:    v_mov_b32_e32 v7, s13
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    s_add_u32 s4, s8, 16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-HSA-NEXT:    flat_store_dwordx2 v[4:5], v[6:7]
; GFX7-HSA-NEXT:    s_addc_u32 s5, s9, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_load_v10i32:
; GFX8-NOHSA:       ; %bb.0: ; %entry
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx2 s[12:13], s[10:11], 0x20
; GFX8-NOHSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX8-NOHSA-NEXT:    s_add_u32 s10, s8, 32
; GFX8-NOHSA-NEXT:    s_addc_u32 s11, s9, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s10
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v6, s12
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s11
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v7, s13
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    s_add_u32 s4, s8, 16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NOHSA-NEXT:    flat_store_dwordx2 v[4:5], v[6:7]
; GFX8-NOHSA-NEXT:    s_addc_u32 s5, s9, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v10i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 2 @8
; EG-NEXT:    ALU 8, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T4.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T3.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T0.X, 0, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 32, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T4.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR * T5.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_load_v10i32:
; GFX9-HSA:       ; %bb.0: ; %entry
; GFX9-HSA-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx2 s[12:13], s[10:11], 0x20
; GFX9-HSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v5, s12
; GFX9-HSA-NEXT:    v_mov_b32_e32 v6, s13
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s0
; GFX9-HSA-NEXT:    global_store_dwordx2 v8, v[5:6], s[8:9] offset:32
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[8:9] offset:16
; GFX9-HSA-NEXT:    v_mov_b32_e32 v5, s1
; GFX9-HSA-NEXT:    v_mov_b32_e32 v6, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v7, s3
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[4:7], s[8:9]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_load_v10i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[8:11], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[12:13], s[10:11], 0x20
; GFX12-NEXT:    s_load_b256 s[0:7], s[10:11], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v10, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v8, s12 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_dual_mov_b32 v9, s13 :: v_dual_mov_b32 v0, s4
; GFX12-NEXT:    v_dual_mov_b32 v3, s7 :: v_dual_mov_b32 v2, s6
; GFX12-NEXT:    v_dual_mov_b32 v5, s1 :: v_dual_mov_b32 v4, s0
; GFX12-NEXT:    v_dual_mov_b32 v7, s3 :: v_dual_mov_b32 v6, s2
; GFX12-NEXT:    s_clause 0x2
; GFX12-NEXT:    global_store_b64 v10, v[8:9], s[8:9] offset:32
; GFX12-NEXT:    global_store_b128 v10, v[0:3], s[8:9] offset:16
; GFX12-NEXT:    global_store_b128 v10, v[4:7], s[8:9]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ld = load <10 x i32>, ptr addrspace(4) %in
  store <10 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v11i32(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_load_v11i32:
; GFX6-NOHSA:       ; %bb.0: ; %entry
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[12:15], s[10:11], 0x8
; GFX6-NOHSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s11, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s10, -1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX6-NOHSA-NEXT:    buffer_store_dword v0, off, s[8:11], 0 offset:40
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX6-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0 offset:32
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_load_v11i32:
; GFX7-HSA:       ; %bb.0: ; %entry
; GFX7-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx4 s[12:15], s[2:3], 0x8
; GFX7-HSA-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x0
; GFX7-HSA-NEXT:    s_add_u32 s2, s0, 16
; GFX7-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v8, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v7, s2
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s9
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s10
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s11
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[7:8], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v8, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-HSA-NEXT:    v_mov_b32_e32 v7, s0
; GFX7-HSA-NEXT:    s_add_u32 s0, s0, 32
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[7:8], v[0:3]
; GFX7-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s13
; GFX7-HSA-NEXT:    v_mov_b32_e32 v6, s14
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-HSA-NEXT:    flat_store_dwordx3 v[0:1], v[4:6]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_load_v11i32:
; GFX8-NOHSA:       ; %bb.0: ; %entry
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[12:15], s[2:3], 0x20
; GFX8-NOHSA-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x0
; GFX8-NOHSA-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NOHSA-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v8, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v7, s2
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s10
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s11
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[7:8], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v8, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v7, s0
; GFX8-NOHSA-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[7:8], v[0:3]
; GFX8-NOHSA-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s13
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v6, s14
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NOHSA-NEXT:    flat_store_dwordx3 v[0:1], v[4:6]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v11i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 2 @8
; EG-NEXT:    ALU 13, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T7.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T6.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.X, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T3.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T0.X, 0, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 32, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     MOV * T4.X, T0.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    40(5.605194e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T5.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T6.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR * T7.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_load_v11i32:
; GFX9-HSA:       ; %bb.0: ; %entry
; GFX9-HSA-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx4 s[12:15], s[10:11], 0x20
; GFX9-HSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-HSA-NEXT:    global_store_dwordx4 v7, v[0:3], s[8:9] offset:16
; GFX9-HSA-NEXT:    v_mov_b32_e32 v5, s13
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-HSA-NEXT:    v_mov_b32_e32 v6, s14
; GFX9-HSA-NEXT:    global_store_dwordx4 v7, v[0:3], s[8:9]
; GFX9-HSA-NEXT:    global_store_dwordx3 v7, v[4:6], s[8:9] offset:32
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_load_v11i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[8:11], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b96 s[12:14], s[10:11], 0x20
; GFX12-NEXT:    s_load_b256 s[0:7], s[10:11], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v11, 0 :: v_dual_mov_b32 v8, s12
; GFX12-NEXT:    v_dual_mov_b32 v9, s13 :: v_dual_mov_b32 v10, s14
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s7
; GFX12-NEXT:    v_dual_mov_b32 v4, s0 :: v_dual_mov_b32 v5, s1
; GFX12-NEXT:    v_dual_mov_b32 v6, s2 :: v_dual_mov_b32 v7, s3
; GFX12-NEXT:    s_clause 0x2
; GFX12-NEXT:    global_store_b96 v11, v[8:10], s[8:9] offset:32
; GFX12-NEXT:    global_store_b128 v11, v[0:3], s[8:9] offset:16
; GFX12-NEXT:    global_store_b128 v11, v[4:7], s[8:9]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ld = load <11 x i32>, ptr addrspace(4) %in
  store <11 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v12i32(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_load_v12i32:
; GFX6-NOHSA:       ; %bb.0: ; %entry
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[12:15], s[10:11], 0x8
; GFX6-NOHSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s11, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s10, -1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s14
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s15
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0 offset:32
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_load_v12i32:
; GFX7-HSA:       ; %bb.0: ; %entry
; GFX7-HSA-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx4 s[12:15], s[10:11], 0x8
; GFX7-HSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX7-HSA-NEXT:    s_add_u32 s10, s8, 32
; GFX7-HSA-NEXT:    s_addc_u32 s11, s9, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v8, s10
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX7-HSA-NEXT:    v_mov_b32_e32 v9, s11
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s14
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s15
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX7-HSA-NEXT:    s_add_u32 s4, s8, 16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX7-HSA-NEXT:    s_addc_u32 s5, s9, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v6, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v7, s7
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_load_v12i32:
; GFX8-NOHSA:       ; %bb.0: ; %entry
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[12:15], s[10:11], 0x20
; GFX8-NOHSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX8-NOHSA-NEXT:    s_add_u32 s10, s8, 32
; GFX8-NOHSA-NEXT:    s_addc_u32 s11, s9, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v8, s10
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v9, s11
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s14
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s15
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NOHSA-NEXT:    s_add_u32 s4, s8, 16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GFX8-NOHSA-NEXT:    s_addc_u32 s5, s9, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v6, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v7, s7
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v12i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 7, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 2 @8
; EG-NEXT:    ALU 1, @22, KC0[], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XYZW, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_128 T3.XYZW, T2.X, 32, #1
; EG-NEXT:     VTX_READ_128 T4.XYZW, T2.X, 16, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T2.X, 0, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T1.X, PV.W, literal.x,
; EG-NEXT:     MOV * T2.X, KC0[2].Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 22:
; EG-NEXT:     LSHR * T5.X, T0.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_load_v12i32:
; GFX9-HSA:       ; %bb.0: ; %entry
; GFX9-HSA-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx4 s[12:15], s[10:11], 0x20
; GFX9-HSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s14
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s15
; GFX9-HSA-NEXT:    v_mov_b32_e32 v8, s0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v9, s1
; GFX9-HSA-NEXT:    v_mov_b32_e32 v10, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v11, s3
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX9-HSA-NEXT:    v_mov_b32_e32 v6, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v7, s7
; GFX9-HSA-NEXT:    global_store_dwordx4 v12, v[0:3], s[8:9] offset:32
; GFX9-HSA-NEXT:    global_store_dwordx4 v12, v[4:7], s[8:9] offset:16
; GFX9-HSA-NEXT:    global_store_dwordx4 v12, v[8:11], s[8:9]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_load_v12i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[8:11], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[12:15], s[10:11], 0x20
; GFX12-NEXT:    s_load_b256 s[0:7], s[10:11], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v12, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v3, s15
; GFX12-NEXT:    v_dual_mov_b32 v1, s13 :: v_dual_mov_b32 v2, s14
; GFX12-NEXT:    v_dual_mov_b32 v5, s5 :: v_dual_mov_b32 v4, s4
; GFX12-NEXT:    v_dual_mov_b32 v7, s7 :: v_dual_mov_b32 v6, s6
; GFX12-NEXT:    v_dual_mov_b32 v9, s1 :: v_dual_mov_b32 v8, s0
; GFX12-NEXT:    v_dual_mov_b32 v11, s3 :: v_dual_mov_b32 v10, s2
; GFX12-NEXT:    s_clause 0x2
; GFX12-NEXT:    global_store_b128 v12, v[0:3], s[8:9] offset:32
; GFX12-NEXT:    global_store_b128 v12, v[4:7], s[8:9] offset:16
; GFX12-NEXT:    global_store_b128 v12, v[8:11], s[8:9]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ld = load <12 x i32>, ptr addrspace(4) %in
  store <12 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v16i32(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_load_v16i32:
; GFX6-NOHSA:       ; %bb.0: ; %entry
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[16:19], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s19, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s18, -1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s14
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s15
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0 offset:48
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s9
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s10
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s11
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0 offset:32
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0 offset:16
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_load_v16i32:
; GFX7-HSA:       ; %bb.0: ; %entry
; GFX7-HSA-NEXT:    s_load_dwordx4 s[16:19], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; GFX7-HSA-NEXT:    s_add_u32 s18, s16, 48
; GFX7-HSA-NEXT:    s_addc_u32 s19, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v6, s18
; GFX7-HSA-NEXT:    v_mov_b32_e32 v7, s19
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s14
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s15
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX7-HSA-NEXT:    s_add_u32 s8, s16, 32
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[6:7], v[0:3]
; GFX7-HSA-NEXT:    s_addc_u32 s9, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v6, s10
; GFX7-HSA-NEXT:    v_mov_b32_e32 v7, s11
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s9
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    s_add_u32 s4, s16, 16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-HSA-NEXT:    s_addc_u32 s5, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s17
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_load_v16i32:
; GFX8-NOHSA:       ; %bb.0: ; %entry
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[16:19], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; GFX8-NOHSA-NEXT:    s_add_u32 s18, s16, 48
; GFX8-NOHSA-NEXT:    s_addc_u32 s19, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v6, s18
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v7, s19
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s14
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s15
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NOHSA-NEXT:    s_add_u32 s8, s16, 32
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[6:7], v[0:3]
; GFX8-NOHSA-NEXT:    s_addc_u32 s9, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v6, s10
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v7, s11
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    s_add_u32 s4, s16, 16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NOHSA-NEXT:    s_addc_u32 s5, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s17
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v16i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 10, @16, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 3 @8
; EG-NEXT:    ALU 1, @27, KC0[], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T7.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T5.XYZW, T2.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T6.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_128 T4.XYZW, T3.X, 48, #1
; EG-NEXT:     VTX_READ_128 T5.XYZW, T3.X, 32, #1
; EG-NEXT:     VTX_READ_128 T6.XYZW, T3.X, 16, #1
; EG-NEXT:     VTX_READ_128 T3.XYZW, T3.X, 0, #1
; EG-NEXT:    ALU clause starting at 16:
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T1.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T2.X, PV.W, literal.x,
; EG-NEXT:     MOV * T3.X, KC0[2].Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    48(6.726233e-44), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 27:
; EG-NEXT:     LSHR * T7.X, T0.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_load_v16i32:
; GFX9-HSA:       ; %bb.0: ; %entry
; GFX9-HSA-NEXT:    s_load_dwordx4 s[16:19], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s14
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s15
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX9-HSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX9-HSA-NEXT:    v_mov_b32_e32 v6, s10
; GFX9-HSA-NEXT:    v_mov_b32_e32 v7, s11
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17] offset:48
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17] offset:32
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17] offset:16
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_load_v16i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[16:19], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b512 s[0:15], s[18:19], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v16, 0 :: v_dual_mov_b32 v1, s13
; GFX12-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v3, s15
; GFX12-NEXT:    v_dual_mov_b32 v2, s14 :: v_dual_mov_b32 v5, s9
; GFX12-NEXT:    v_dual_mov_b32 v4, s8 :: v_dual_mov_b32 v7, s11
; GFX12-NEXT:    v_dual_mov_b32 v6, s10 :: v_dual_mov_b32 v9, s5
; GFX12-NEXT:    v_dual_mov_b32 v8, s4 :: v_dual_mov_b32 v11, s7
; GFX12-NEXT:    v_dual_mov_b32 v10, s6 :: v_dual_mov_b32 v13, s1
; GFX12-NEXT:    v_dual_mov_b32 v12, s0 :: v_dual_mov_b32 v15, s3
; GFX12-NEXT:    v_mov_b32_e32 v14, s2
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    global_store_b128 v16, v[0:3], s[16:17] offset:48
; GFX12-NEXT:    global_store_b128 v16, v[4:7], s[16:17] offset:32
; GFX12-NEXT:    global_store_b128 v16, v[8:11], s[16:17] offset:16
; GFX12-NEXT:    global_store_b128 v16, v[12:15], s[16:17]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ld = load <16 x i32>, ptr addrspace(4) %in
  store <16 x i32> %ld, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_i32_to_i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_zextload_i32_to_i64:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dword s4, s[2:3], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s2, -1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_zextload_i32_to_i64:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, 0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-HSA-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_zextload_i32_to_i64:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NOHSA-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_i32_to_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MOV * T0.Y, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_zextload_i32_to_i64:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-HSA-NEXT:    global_store_dwordx2 v1, v[0:1], s[0:1]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_zextload_i32_to_i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX12-NEXT:    global_store_b64 v1, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load i32, ptr addrspace(4) %in
  %ext = zext i32 %ld to i64
  store i64 %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_i32_to_i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_sextload_i32_to_i64:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dword s4, s[2:3], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_ashr_i32 s5, s4, 31
; GFX6-NOHSA-NEXT:    s_mov_b32 s2, -1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_sextload_i32_to_i64:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_ashr_i32 s0, s2, 31
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s0
; GFX7-HSA-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_sextload_i32_to_i64:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_ashr_i32 s0, s2, 31
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s0
; GFX8-NOHSA-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_i32_to_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR T1.X, KC0[2].Y, literal.x,
; EG-NEXT:     ASHR * T0.Y, T0.X, literal.y,
; EG-NEXT:    2(2.802597e-45), 31(4.344025e-44)
;
; GFX9-HSA-LABEL: constant_sextload_i32_to_i64:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_ashr_i32 s3, s2, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-HSA-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_sextload_i32_to_i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_ashr_i32 s3, s2, 31
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load i32, ptr addrspace(4) %in
  %ext = sext i32 %ld to i64
  store i64 %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v1i32_to_v1i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_zextload_v1i32_to_v1i64:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dword s4, s[2:3], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s2, -1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_zextload_v1i32_to_v1i64:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, 0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-HSA-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_zextload_v1i32_to_v1i64:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NOHSA-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v1i32_to_v1i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MOV * T0.Y, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_zextload_v1i32_to_v1i64:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-HSA-NEXT:    global_store_dwordx2 v1, v[0:1], s[0:1]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_zextload_v1i32_to_v1i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX12-NEXT:    global_store_b64 v1, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load <1 x i32>, ptr addrspace(4) %in
  %ext = zext <1 x i32> %ld to <1 x i64>
  store <1 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v1i32_to_v1i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_sextload_v1i32_to_v1i64:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dword s4, s[2:3], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_ashr_i32 s5, s4, 31
; GFX6-NOHSA-NEXT:    s_mov_b32 s2, -1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_sextload_v1i32_to_v1i64:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_ashr_i32 s0, s2, 31
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s0
; GFX7-HSA-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_sextload_v1i32_to_v1i64:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_ashr_i32 s0, s2, 31
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s0
; GFX8-NOHSA-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v1i32_to_v1i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR T1.X, KC0[2].Y, literal.x,
; EG-NEXT:     ASHR * T0.Y, T0.X, literal.y,
; EG-NEXT:    2(2.802597e-45), 31(4.344025e-44)
;
; GFX9-HSA-LABEL: constant_sextload_v1i32_to_v1i64:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_ashr_i32 s3, s2, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-HSA-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_sextload_v1i32_to_v1i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_ashr_i32 s3, s2, 31
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load <1 x i32>, ptr addrspace(4) %in
  %ext = sext <1 x i32> %ld to <1 x i64>
  store <1 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v2i32_to_v2i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_zextload_v2i32_to_v2i64:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NOHSA-NEXT:    s_mov_b32 s2, -1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_zextload_v2i32_to_v2i64:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_zextload_v2i32_to_v2i64:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v2i32_to_v2i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 5, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MOV T1.X, T0.X,
; EG-NEXT:     MOV T1.Y, 0.0,
; EG-NEXT:     MOV T1.Z, T0.Y,
; EG-NEXT:     MOV T1.W, 0.0,
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_zextload_v2i32_to_v2i64:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_zextload_v2i32_to_v2i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v2, s3 :: v_dual_mov_b32 v3, v1
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load <2 x i32>, ptr addrspace(4) %in
  %ext = zext <2 x i32> %ld to <2 x i64>
  store <2 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v2i32_to_v2i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_sextload_v2i32_to_v2i64:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_ashr_i32 s6, s5, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s7, s4, 31
; GFX6-NOHSA-NEXT:    s_mov_b32 s2, -1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s7
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s6
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_sextload_v2i32_to_v2i64:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_ashr_i32 s0, s3, 31
; GFX7-HSA-NEXT:    s_mov_b32 s1, s3
; GFX7-HSA-NEXT:    s_ashr_i32 s3, s2, 31
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s0
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_sextload_v2i32_to_v2i64:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_ashr_i32 s0, s3, 31
; GFX8-NOHSA-NEXT:    s_mov_b32 s1, s3
; GFX8-NOHSA-NEXT:    s_ashr_i32 s3, s2, 31
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s0
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v2i32_to_v2i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 7, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     ASHR * T1.W, T0.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR * T1.Y, T0.X, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T1.X, T0.X,
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MOV * T1.Z, T0.Y,
;
; GFX9-HSA-LABEL: constant_sextload_v2i32_to_v2i64:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_ashr_i32 s4, s3, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s5, s2, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_sextload_v2i32_to_v2i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_ashr_i32 s4, s3, 31
; GFX12-NEXT:    s_ashr_i32 s5, s2, 31
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v3, s4
; GFX12-NEXT:    v_mov_b32_e32 v2, s3
; GFX12-NEXT:    global_store_b128 v4, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load <2 x i32>, ptr addrspace(4) %in
  %ext = sext <2 x i32> %ld to <2 x i64>
  store <2 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v4i32_to_v4i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_zextload_v4i32_to_v4i64:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NOHSA-NEXT:    s_mov_b32 s2, -1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_zextload_v4i32_to_v4i64:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX7-HSA-NEXT:    s_add_u32 s2, s0, 16
; GFX7-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s0
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_zextload_v4i32_to_v4i64:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX8-NOHSA-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NOHSA-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v4i32_to_v4i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 12, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MOV T1.X, T0.Z,
; EG-NEXT:     MOV T1.Y, 0.0,
; EG-NEXT:     MOV * T2.X, T0.X,
; EG-NEXT:     MOV T2.Y, 0.0,
; EG-NEXT:     MOV T1.Z, T0.W,
; EG-NEXT:     MOV T1.W, 0.0,
; EG-NEXT:     MOV * T2.Z, T0.Y,
; EG-NEXT:     MOV * T2.W, 0.0,
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR * T3.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_zextload_v4i32_to_v4i64:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1] offset:16
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_zextload_v4i32_to_v4i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s6
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, s7
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1] offset:16
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    v_mov_b32_e32 v2, s5
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load <4 x i32>, ptr addrspace(4) %in
  %ext = zext <4 x i32> %ld to <4 x i64>
  store <4 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v4i32_to_v4i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_sextload_v4i32_to_v4i64:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s2, -1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_ashr_i32 s8, s5, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s9, s7, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s10, s6, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s11, s4, 31
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v6, s5
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s10
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s9
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v5, s11
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v7, s8
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_sextload_v4i32_to_v4i64:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_ashr_i32 s8, s5, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s9, s4, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s2, s7, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s3, s6, 31
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s2
; GFX7-HSA-NEXT:    s_add_u32 s2, s0, 16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v6, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s2
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[5:6], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX7-HSA-NEXT:    v_mov_b32_e32 v6, s5
; GFX7-HSA-NEXT:    v_mov_b32_e32 v7, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_sextload_v4i32_to_v4i64:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_ashr_i32 s8, s5, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s9, s4, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s2, s7, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s3, s6, 31
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s2
; GFX8-NOHSA-NEXT:    s_add_u32 s2, s0, 16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NOHSA-NEXT:    s_addc_u32 s3, s1, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v6, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s2
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[5:6], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v6, s5
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v7, s8
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v4i32_to_v4i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 15, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XYZW, T0.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     ASHR * T1.W, T0.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T2.X, KC0[2].Y, literal.x,
; EG-NEXT:     ASHR T1.Y, T0.X, literal.y,
; EG-NEXT:     ASHR T3.W, T0.W, literal.y,
; EG-NEXT:     MOV * T1.X, T0.X,
; EG-NEXT:    2(2.802597e-45), 31(4.344025e-44)
; EG-NEXT:     ASHR * T3.Y, T0.Z, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T3.X, T0.Z,
; EG-NEXT:     MOV T1.Z, T0.Y,
; EG-NEXT:     ADD_INT * T2.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PV.W, literal.x,
; EG-NEXT:     MOV * T3.Z, T0.W,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_sextload_v4i32_to_v4i64:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_ashr_i32 s2, s5, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s3, s4, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s8, s7, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s9, s6, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s8
; GFX9-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX9-HSA-NEXT:    v_mov_b32_e32 v6, s5
; GFX9-HSA-NEXT:    v_mov_b32_e32 v7, s2
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] offset:16
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_sextload_v4i32_to_v4i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_ashr_i32 s8, s7, 31
; GFX12-NEXT:    s_ashr_i32 s9, s6, 31
; GFX12-NEXT:    s_ashr_i32 s2, s5, 31
; GFX12-NEXT:    s_ashr_i32 s3, s4, 31
; GFX12-NEXT:    v_dual_mov_b32 v8, 0 :: v_dual_mov_b32 v1, s9
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v3, s8
; GFX12-NEXT:    v_dual_mov_b32 v2, s7 :: v_dual_mov_b32 v5, s3
; GFX12-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v7, s2
; GFX12-NEXT:    v_mov_b32_e32 v6, s5
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v8, v[0:3], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v8, v[4:7], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load <4 x i32>, ptr addrspace(4) %in
  %ext = sext <4 x i32> %ld to <4 x i64>
  store <4 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v8i32_to_v8i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_zextload_v8i32_to_v8i64:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s11, 0xf000
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NOHSA-NEXT:    s_mov_b32 s10, -1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0 offset:48
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0 offset:32
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_zextload_v8i32_to_v8i64:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x0
; GFX7-HSA-NEXT:    s_add_u32 s2, s0, 48
; GFX7-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX7-HSA-NEXT:    s_add_u32 s2, s0, 32
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX7-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX7-HSA-NEXT:    s_add_u32 s2, s0, 16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX7-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s0
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_zextload_v8i32_to_v8i64:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX8-NOHSA-NEXT:    s_add_u32 s10, s8, 48
; GFX8-NOHSA-NEXT:    s_addc_u32 s11, s9, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s10
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s11
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    s_add_u32 s4, s8, 32
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NOHSA-NEXT:    s_addc_u32 s5, s9, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NOHSA-NEXT:    s_add_u32 s2, s8, 16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NOHSA-NEXT:    s_addc_u32 s3, s9, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v8i32_to_v8i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @8
; EG-NEXT:    ALU 26, @13, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T7.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XYZW, T6.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T5.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 13:
; EG-NEXT:     MOV T2.X, T1.Z,
; EG-NEXT:     MOV T2.Y, 0.0,
; EG-NEXT:     MOV * T3.X, T1.X,
; EG-NEXT:     MOV * T3.Y, 0.0,
; EG-NEXT:     MOV T4.X, T0.Z,
; EG-NEXT:     MOV T4.Y, 0.0,
; EG-NEXT:     MOV * T5.X, T0.X,
; EG-NEXT:     MOV T5.Y, 0.0,
; EG-NEXT:     MOV T2.Z, T1.W,
; EG-NEXT:     MOV T2.W, 0.0,
; EG-NEXT:     MOV * T3.Z, T1.Y,
; EG-NEXT:     MOV * T3.W, 0.0,
; EG-NEXT:     MOV T4.Z, T0.W,
; EG-NEXT:     MOV T4.W, 0.0,
; EG-NEXT:     MOV * T5.Z, T0.Y,
; EG-NEXT:     MOV * T5.W, 0.0,
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T1.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T6.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR * T7.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_zextload_v8i32_to_v8i64:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[8:9] offset:48
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[8:9] offset:32
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[8:9] offset:16
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[8:9]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_zextload_v8i32_to_v8i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[8:11], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b256 s[0:7], s[10:11], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s6
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, s7
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[8:9] offset:48
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    v_mov_b32_e32 v2, s5
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[8:9] offset:32
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    v_mov_b32_e32 v2, s3
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[8:9] offset:16
; GFX12-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[8:9]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load <8 x i32>, ptr addrspace(4) %in
  %ext = zext <8 x i32> %ld to <8 x i64>
  store <8 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v8i32_to_v8i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_sextload_v8i32_to_v8i64:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s11, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s10, -1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_ashr_i32 s12, s1, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s13, s0, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s14, s3, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s15, s2, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s16, s5, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s17, s7, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s18, s6, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s19, s4, 31
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v6, s5
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v8, s2
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v10, s3
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v12, s0
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v14, s1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s18
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s17
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0 offset:48
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v5, s19
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v7, s16
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[8:11], 0 offset:32
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v9, s15
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v11, s14
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[8:11], 0 offset:16
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v13, s13
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v15, s12
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[12:15], off, s[8:11], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_sextload_v8i32_to_v8i64:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_ashr_i32 s10, s1, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s11, s0, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s12, s3, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s13, s2, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s14, s5, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s15, s4, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s16, s7, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s17, s6, 31
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-HSA-NEXT:    s_add_u32 s6, s8, 48
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX7-HSA-NEXT:    s_addc_u32 s7, s9, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s17
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s7
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    s_add_u32 s4, s8, 32
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-HSA-NEXT:    s_addc_u32 s5, s9, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s15
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s14
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-HSA-NEXT:    s_add_u32 s2, s8, 16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX7-HSA-NEXT:    s_addc_u32 s3, s9, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s12
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s11
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s10
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_sextload_v8i32_to_v8i64:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_ashr_i32 s10, s1, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s11, s0, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s12, s3, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s13, s2, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s14, s5, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s15, s4, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s16, s7, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s17, s6, 31
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NOHSA-NEXT:    s_add_u32 s6, s8, 48
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX8-NOHSA-NEXT:    s_addc_u32 s7, s9, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s17
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s7
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    s_add_u32 s4, s8, 32
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NOHSA-NEXT:    s_addc_u32 s5, s9, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s15
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s14
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NOHSA-NEXT:    s_add_u32 s2, s8, 16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NOHSA-NEXT:    s_addc_u32 s3, s9, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s12
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s11
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s10
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v8i32_to_v8i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @8
; EG-NEXT:    ALU 31, @13, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T8.XYZW, T0.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T6.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 13:
; EG-NEXT:     LSHR T2.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T2.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT T2.W, KC0[2].Y, literal.y,
; EG-NEXT:     ASHR * T4.W, T0.Y, literal.z,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T5.X, PV.W, literal.x,
; EG-NEXT:     ASHR T4.Y, T0.X, literal.y,
; EG-NEXT:     ASHR T6.W, T0.W, literal.y,
; EG-NEXT:     MOV * T4.X, T0.X,
; EG-NEXT:    2(2.802597e-45), 31(4.344025e-44)
; EG-NEXT:     ASHR T6.Y, T0.Z, literal.x,
; EG-NEXT:     ASHR * T7.W, T1.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T6.X, T0.Z,
; EG-NEXT:     ASHR T7.Y, T1.X, literal.x,
; EG-NEXT:     MOV T4.Z, T0.Y,
; EG-NEXT:     ASHR T8.W, T1.W, literal.x,
; EG-NEXT:     MOV * T7.X, T1.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T8.Y, T1.Z, literal.x,
; EG-NEXT:     MOV * T6.Z, T0.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T8.X, T1.Z,
; EG-NEXT:     MOV T7.Z, T1.Y,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    48(6.726233e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PV.W, literal.x,
; EG-NEXT:     MOV * T8.Z, T1.W,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_sextload_v8i32_to_v8i64:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_ashr_i32 s16, s11, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s17, s10, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s14, s9, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s15, s8, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s16
; GFX9-HSA-NEXT:    s_ashr_i32 s12, s7, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s13, s6, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:48
; GFX9-HSA-NEXT:    s_ashr_i32 s2, s5, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s15
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s14
; GFX9-HSA-NEXT:    s_ashr_i32 s3, s4, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:32
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s12
; GFX9-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:16
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s2
; GFX9-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_sextload_v8i32_to_v8i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b256 s[4:11], s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_ashr_i32 s16, s11, 31
; GFX12-NEXT:    s_ashr_i32 s17, s10, 31
; GFX12-NEXT:    s_ashr_i32 s14, s9, 31
; GFX12-NEXT:    s_ashr_i32 s15, s8, 31
; GFX12-NEXT:    v_dual_mov_b32 v16, 0 :: v_dual_mov_b32 v1, s17
; GFX12-NEXT:    s_ashr_i32 s12, s7, 31
; GFX12-NEXT:    s_ashr_i32 s13, s6, 31
; GFX12-NEXT:    v_dual_mov_b32 v0, s10 :: v_dual_mov_b32 v3, s16
; GFX12-NEXT:    v_dual_mov_b32 v2, s11 :: v_dual_mov_b32 v5, s15
; GFX12-NEXT:    s_ashr_i32 s2, s5, 31
; GFX12-NEXT:    s_ashr_i32 s3, s4, 31
; GFX12-NEXT:    v_dual_mov_b32 v4, s8 :: v_dual_mov_b32 v7, s14
; GFX12-NEXT:    v_dual_mov_b32 v6, s9 :: v_dual_mov_b32 v9, s13
; GFX12-NEXT:    v_dual_mov_b32 v8, s6 :: v_dual_mov_b32 v11, s12
; GFX12-NEXT:    v_dual_mov_b32 v10, s7 :: v_dual_mov_b32 v13, s3
; GFX12-NEXT:    v_dual_mov_b32 v12, s4 :: v_dual_mov_b32 v15, s2
; GFX12-NEXT:    v_mov_b32_e32 v14, s5
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    global_store_b128 v16, v[0:3], s[0:1] offset:48
; GFX12-NEXT:    global_store_b128 v16, v[4:7], s[0:1] offset:32
; GFX12-NEXT:    global_store_b128 v16, v[8:11], s[0:1] offset:16
; GFX12-NEXT:    global_store_b128 v16, v[12:15], s[0:1]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load <8 x i32>, ptr addrspace(4) %in
  %ext = sext <8 x i32> %ld to <8 x i64>
  store <8 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v16i32_to_v16i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_sextload_v16i32_to_v16i64:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[16:19], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s19, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s18, -1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_ashr_i32 s20, s1, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s21, s0, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s22, s3, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s23, s2, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s24, s5, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s25, s4, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s26, s7, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s27, s6, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s28, s9, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s29, s8, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s30, s11, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s31, s10, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s33, s13, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s34, s15, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s35, s14, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s36, s12, 31
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v6, s13
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v8, s10
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v10, s11
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v12, s8
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v14, s9
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v16, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v18, s7
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v20, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v22, s5
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v24, s2
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v26, s3
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s35
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s34
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0 offset:112
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v5, s36
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v7, s33
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[16:19], 0 offset:96
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v9, s31
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v11, s30
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[16:19], 0 offset:80
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v13, s29
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v15, s28
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[12:15], off, s[16:19], 0 offset:64
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v17, s27
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v19, s26
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[16:19], 0 offset:48
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v21, s25
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v23, s24
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[20:23], off, s[16:19], 0 offset:32
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v25, s23
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v27, s22
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[24:27], off, s[16:19], 0 offset:16
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s21
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s20
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_sextload_v16i32_to_v16i64:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[16:19], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_ashr_i32 s18, s1, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s19, s0, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s20, s3, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s21, s2, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s22, s5, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s23, s4, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s24, s7, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s25, s6, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s26, s9, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s27, s8, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s28, s11, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s29, s10, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s30, s13, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s31, s12, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s33, s15, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s34, s14, 31
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX7-HSA-NEXT:    s_add_u32 s14, s16, 0x70
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX7-HSA-NEXT:    s_addc_u32 s15, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s14
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s34
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s33
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s15
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX7-HSA-NEXT:    s_add_u32 s12, s16, 0x60
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s13
; GFX7-HSA-NEXT:    s_addc_u32 s13, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s31
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s30
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s13
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX7-HSA-NEXT:    s_add_u32 s10, s16, 0x50
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX7-HSA-NEXT:    s_addc_u32 s11, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s10
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s29
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s28
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s11
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX7-HSA-NEXT:    s_add_u32 s8, s16, 64
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX7-HSA-NEXT:    s_addc_u32 s9, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s27
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s26
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-HSA-NEXT:    s_add_u32 s6, s16, 48
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX7-HSA-NEXT:    s_addc_u32 s7, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s25
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s24
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s7
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    s_add_u32 s4, s16, 32
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-HSA-NEXT:    s_addc_u32 s5, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s23
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s22
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-HSA-NEXT:    s_add_u32 s2, s16, 16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX7-HSA-NEXT:    s_addc_u32 s3, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s21
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s20
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s19
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s18
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s17
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_sextload_v16i32_to_v16i64:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[16:19], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_ashr_i32 s18, s1, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s19, s0, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s20, s3, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s21, s2, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s22, s5, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s23, s4, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s24, s7, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s25, s6, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s26, s9, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s27, s8, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s28, s11, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s29, s10, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s30, s13, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s31, s12, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s33, s15, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s34, s14, 31
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX8-NOHSA-NEXT:    s_add_u32 s14, s16, 0x70
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX8-NOHSA-NEXT:    s_addc_u32 s15, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s14
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s34
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s33
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s15
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX8-NOHSA-NEXT:    s_add_u32 s12, s16, 0x60
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s13
; GFX8-NOHSA-NEXT:    s_addc_u32 s13, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s31
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s30
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s13
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX8-NOHSA-NEXT:    s_add_u32 s10, s16, 0x50
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX8-NOHSA-NEXT:    s_addc_u32 s11, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s10
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s29
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s28
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s11
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NOHSA-NEXT:    s_add_u32 s8, s16, 64
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX8-NOHSA-NEXT:    s_addc_u32 s9, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s27
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s26
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NOHSA-NEXT:    s_add_u32 s6, s16, 48
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX8-NOHSA-NEXT:    s_addc_u32 s7, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s25
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s24
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s7
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    s_add_u32 s4, s16, 32
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NOHSA-NEXT:    s_addc_u32 s5, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s23
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s22
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NOHSA-NEXT:    s_add_u32 s2, s16, 16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NOHSA-NEXT:    s_addc_u32 s3, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s21
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s20
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s19
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s18
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s17
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v16i32_to_v16i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @20, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 3 @12
; EG-NEXT:    ALU 63, @21, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T16.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XYZW, T11.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T15.XYZW, T9.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T8.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T14.XYZW, T7.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T13.XYZW, T6.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T12.XYZW, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T10.XYZW, T4.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 12:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 48, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T0.X, 32, #1
; EG-NEXT:     VTX_READ_128 T3.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 20:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 21:
; EG-NEXT:     LSHR T4.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T4.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T5.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T4.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T6.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T4.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR T7.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T4.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T8.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T4.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T9.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT T4.W, KC0[2].Y, literal.y,
; EG-NEXT:     ASHR * T10.W, T0.Y, literal.z,
; EG-NEXT:    2(2.802597e-45), 96(1.345247e-43)
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T11.X, PV.W, literal.x,
; EG-NEXT:     ASHR T10.Y, T0.X, literal.y,
; EG-NEXT:     ASHR T12.W, T0.W, literal.y,
; EG-NEXT:     MOV * T10.X, T0.X,
; EG-NEXT:    2(2.802597e-45), 31(4.344025e-44)
; EG-NEXT:     ASHR T12.Y, T0.Z, literal.x,
; EG-NEXT:     ASHR * T13.W, T3.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T12.X, T0.Z,
; EG-NEXT:     ASHR T13.Y, T3.X, literal.x,
; EG-NEXT:     MOV T10.Z, T0.Y,
; EG-NEXT:     ASHR T14.W, T3.W, literal.x,
; EG-NEXT:     MOV * T13.X, T3.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T14.Y, T3.Z, literal.x,
; EG-NEXT:     MOV T12.Z, T0.W,
; EG-NEXT:     ASHR * T0.W, T2.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T14.X, T3.Z,
; EG-NEXT:     ASHR T0.Y, T2.X, literal.x,
; EG-NEXT:     MOV T13.Z, T3.Y,
; EG-NEXT:     ASHR T15.W, T2.W, literal.x,
; EG-NEXT:     MOV * T0.X, T2.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T15.Y, T2.Z, literal.x,
; EG-NEXT:     MOV T14.Z, T3.W,
; EG-NEXT:     ASHR * T3.W, T1.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T15.X, T2.Z,
; EG-NEXT:     ASHR T3.Y, T1.X, literal.x,
; EG-NEXT:     MOV T0.Z, T2.Y,
; EG-NEXT:     ASHR T16.W, T1.W, literal.x,
; EG-NEXT:     MOV * T3.X, T1.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T16.Y, T1.Z, literal.x,
; EG-NEXT:     MOV * T15.Z, T2.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T16.X, T1.Z,
; EG-NEXT:     MOV T3.Z, T1.Y,
; EG-NEXT:     ADD_INT * T2.W, KC0[2].Y, literal.x,
; EG-NEXT:    112(1.569454e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T1.X, PV.W, literal.x,
; EG-NEXT:     MOV * T16.Z, T1.W,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_sextload_v16i32_to_v16i64:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[16:19], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_ashr_i32 s33, s15, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s34, s14, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s30, s13, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s31, s12, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s34
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s33
; GFX9-HSA-NEXT:    s_ashr_i32 s28, s11, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s29, s10, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17] offset:112
; GFX9-HSA-NEXT:    s_ashr_i32 s26, s9, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s13
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s30
; GFX9-HSA-NEXT:    s_ashr_i32 s27, s8, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17] offset:96
; GFX9-HSA-NEXT:    s_ashr_i32 s24, s7, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s29
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s28
; GFX9-HSA-NEXT:    s_ashr_i32 s25, s6, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17] offset:80
; GFX9-HSA-NEXT:    s_ashr_i32 s22, s5, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s27
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s26
; GFX9-HSA-NEXT:    s_ashr_i32 s23, s4, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17] offset:64
; GFX9-HSA-NEXT:    s_ashr_i32 s20, s3, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s25
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s24
; GFX9-HSA-NEXT:    s_ashr_i32 s21, s2, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17] offset:48
; GFX9-HSA-NEXT:    s_ashr_i32 s18, s1, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s23
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s22
; GFX9-HSA-NEXT:    s_ashr_i32 s19, s0, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17] offset:32
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s21
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s20
; GFX9-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17] offset:16
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s19
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s18
; GFX9-HSA-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_sextload_v16i32_to_v16i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[16:19], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b512 s[0:15], s[18:19], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_ashr_i32 s28, s11, 31
; GFX12-NEXT:    s_ashr_i32 s29, s10, 31
; GFX12-NEXT:    s_ashr_i32 s33, s15, 31
; GFX12-NEXT:    s_ashr_i32 s34, s14, 31
; GFX12-NEXT:    s_ashr_i32 s26, s9, 31
; GFX12-NEXT:    s_ashr_i32 s27, s8, 31
; GFX12-NEXT:    s_ashr_i32 s30, s13, 31
; GFX12-NEXT:    s_ashr_i32 s31, s12, 31
; GFX12-NEXT:    v_dual_mov_b32 v28, 0 :: v_dual_mov_b32 v1, s34
; GFX12-NEXT:    s_ashr_i32 s24, s7, 31
; GFX12-NEXT:    s_ashr_i32 s25, s6, 31
; GFX12-NEXT:    v_dual_mov_b32 v0, s14 :: v_dual_mov_b32 v3, s33
; GFX12-NEXT:    v_dual_mov_b32 v2, s15 :: v_dual_mov_b32 v5, s31
; GFX12-NEXT:    v_dual_mov_b32 v6, s13 :: v_dual_mov_b32 v9, s29
; GFX12-NEXT:    v_dual_mov_b32 v8, s10 :: v_dual_mov_b32 v11, s28
; GFX12-NEXT:    v_dual_mov_b32 v10, s11 :: v_dual_mov_b32 v13, s27
; GFX12-NEXT:    s_ashr_i32 s22, s5, 31
; GFX12-NEXT:    s_ashr_i32 s23, s4, 31
; GFX12-NEXT:    v_dual_mov_b32 v4, s12 :: v_dual_mov_b32 v7, s30
; GFX12-NEXT:    v_dual_mov_b32 v12, s8 :: v_dual_mov_b32 v15, s26
; GFX12-NEXT:    v_dual_mov_b32 v14, s9 :: v_dual_mov_b32 v17, s25
; GFX12-NEXT:    s_ashr_i32 s20, s3, 31
; GFX12-NEXT:    s_ashr_i32 s21, s2, 31
; GFX12-NEXT:    v_dual_mov_b32 v16, s6 :: v_dual_mov_b32 v19, s24
; GFX12-NEXT:    v_dual_mov_b32 v18, s7 :: v_dual_mov_b32 v21, s23
; GFX12-NEXT:    s_ashr_i32 s18, s1, 31
; GFX12-NEXT:    s_ashr_i32 s19, s0, 31
; GFX12-NEXT:    v_dual_mov_b32 v20, s4 :: v_dual_mov_b32 v23, s22
; GFX12-NEXT:    v_dual_mov_b32 v22, s5 :: v_dual_mov_b32 v25, s21
; GFX12-NEXT:    v_dual_mov_b32 v24, s2 :: v_dual_mov_b32 v27, s20
; GFX12-NEXT:    v_mov_b32_e32 v26, s3
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_store_b128 v28, v[0:3], s[16:17] offset:112
; GFX12-NEXT:    global_store_b128 v28, v[4:7], s[16:17] offset:96
; GFX12-NEXT:    v_dual_mov_b32 v1, s19 :: v_dual_mov_b32 v0, s0
; GFX12-NEXT:    v_dual_mov_b32 v3, s18 :: v_dual_mov_b32 v2, s1
; GFX12-NEXT:    s_clause 0x5
; GFX12-NEXT:    global_store_b128 v28, v[8:11], s[16:17] offset:80
; GFX12-NEXT:    global_store_b128 v28, v[12:15], s[16:17] offset:64
; GFX12-NEXT:    global_store_b128 v28, v[16:19], s[16:17] offset:48
; GFX12-NEXT:    global_store_b128 v28, v[20:23], s[16:17] offset:32
; GFX12-NEXT:    global_store_b128 v28, v[24:27], s[16:17] offset:16
; GFX12-NEXT:    global_store_b128 v28, v[0:3], s[16:17]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load <16 x i32>, ptr addrspace(4) %in
  %ext = sext <16 x i32> %ld to <16 x i64>
  store <16 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v16i32_to_v16i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_zextload_v16i32_to_v16i64:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[16:19], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s19, 0xf000
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NOHSA-NEXT:    s_mov_b32 s18, -1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0 offset:112
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s13
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0 offset:96
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0 offset:80
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0 offset:64
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0 offset:48
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0 offset:32
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0 offset:16
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_zextload_v16i32_to_v16i64:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[16:19], s[4:5], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; GFX7-HSA-NEXT:    s_add_u32 s18, s16, 0x70
; GFX7-HSA-NEXT:    s_addc_u32 s19, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s18
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s19
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX7-HSA-NEXT:    s_add_u32 s12, s16, 0x60
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s13
; GFX7-HSA-NEXT:    s_addc_u32 s13, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s13
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX7-HSA-NEXT:    s_add_u32 s10, s16, 0x50
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX7-HSA-NEXT:    s_addc_u32 s11, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s10
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s11
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX7-HSA-NEXT:    s_add_u32 s8, s16, 64
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX7-HSA-NEXT:    s_addc_u32 s9, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-HSA-NEXT:    s_add_u32 s6, s16, 48
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX7-HSA-NEXT:    s_addc_u32 s7, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s7
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    s_add_u32 s4, s16, 32
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-HSA-NEXT:    s_addc_u32 s5, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-HSA-NEXT:    s_add_u32 s2, s16, 16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX7-HSA-NEXT:    s_addc_u32 s3, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s17
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_zextload_v16i32_to_v16i64:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[16:19], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; GFX8-NOHSA-NEXT:    s_add_u32 s18, s16, 0x70
; GFX8-NOHSA-NEXT:    s_addc_u32 s19, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s18
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s19
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX8-NOHSA-NEXT:    s_add_u32 s12, s16, 0x60
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s13
; GFX8-NOHSA-NEXT:    s_addc_u32 s13, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s13
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX8-NOHSA-NEXT:    s_add_u32 s10, s16, 0x50
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX8-NOHSA-NEXT:    s_addc_u32 s11, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s10
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s11
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NOHSA-NEXT:    s_add_u32 s8, s16, 64
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX8-NOHSA-NEXT:    s_addc_u32 s9, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NOHSA-NEXT:    s_add_u32 s6, s16, 48
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX8-NOHSA-NEXT:    s_addc_u32 s7, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s7
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    s_add_u32 s4, s16, 32
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NOHSA-NEXT:    s_addc_u32 s5, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NOHSA-NEXT:    s_add_u32 s2, s16, 16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NOHSA-NEXT:    s_addc_u32 s3, s17, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s17
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v16i32_to_v16i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @20, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 3 @12
; EG-NEXT:    ALU 54, @21, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T15.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T5.XYZW, T14.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T6.XYZW, T13.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T12.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T8.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T9.XYZW, T2.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T10.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T11.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 12:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 48, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T0.X, 0, #1
; EG-NEXT:     VTX_READ_128 T3.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 32, #1
; EG-NEXT:    ALU clause starting at 20:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 21:
; EG-NEXT:     MOV T4.X, T1.Z,
; EG-NEXT:     MOV T4.Y, 0.0,
; EG-NEXT:     MOV * T5.X, T1.X,
; EG-NEXT:     MOV * T5.Y, 0.0,
; EG-NEXT:     MOV T6.X, T0.Z,
; EG-NEXT:     MOV T6.Y, 0.0,
; EG-NEXT:     MOV * T7.X, T0.X,
; EG-NEXT:     MOV * T7.Y, 0.0,
; EG-NEXT:     MOV T8.X, T3.Z,
; EG-NEXT:     MOV T8.Y, 0.0,
; EG-NEXT:     MOV * T9.X, T3.X,
; EG-NEXT:     MOV * T9.Y, 0.0,
; EG-NEXT:     MOV T10.X, T2.Z,
; EG-NEXT:     MOV T10.Y, 0.0,
; EG-NEXT:     MOV * T11.X, T2.X,
; EG-NEXT:     MOV T11.Y, 0.0,
; EG-NEXT:     MOV T4.Z, T1.W,
; EG-NEXT:     MOV T4.W, 0.0,
; EG-NEXT:     MOV * T5.Z, T1.Y,
; EG-NEXT:     MOV * T5.W, 0.0,
; EG-NEXT:     MOV T6.Z, T0.W,
; EG-NEXT:     MOV T6.W, 0.0,
; EG-NEXT:     MOV * T7.Z, T0.Y,
; EG-NEXT:     MOV * T7.W, 0.0,
; EG-NEXT:     MOV T8.Z, T3.W,
; EG-NEXT:     MOV T8.W, 0.0,
; EG-NEXT:     MOV * T9.Z, T3.Y,
; EG-NEXT:     MOV * T9.W, 0.0,
; EG-NEXT:     MOV T10.Z, T2.W,
; EG-NEXT:     MOV T10.W, 0.0,
; EG-NEXT:     MOV * T11.Z, T2.Y,
; EG-NEXT:     MOV * T11.W, 0.0,
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T1.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T2.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T12.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T13.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 96(1.345247e-43)
; EG-NEXT:     LSHR T14.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 112(1.569454e-43)
; EG-NEXT:     LSHR * T15.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_zextload_v16i32_to_v16i64:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[16:19], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[16:17] offset:112
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s13
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[16:17] offset:96
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[16:17] offset:80
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[16:17] offset:64
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[16:17] offset:48
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[16:17] offset:32
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[16:17] offset:16
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[16:17]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_zextload_v16i32_to_v16i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[16:19], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b512 s[0:15], s[18:19], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s14
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, s15
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[16:17] offset:112
; GFX12-NEXT:    v_mov_b32_e32 v0, s12
; GFX12-NEXT:    v_mov_b32_e32 v2, s13
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[16:17] offset:96
; GFX12-NEXT:    v_mov_b32_e32 v0, s10
; GFX12-NEXT:    v_mov_b32_e32 v2, s11
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[16:17] offset:80
; GFX12-NEXT:    v_mov_b32_e32 v0, s8
; GFX12-NEXT:    v_mov_b32_e32 v2, s9
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[16:17] offset:64
; GFX12-NEXT:    v_mov_b32_e32 v0, s6
; GFX12-NEXT:    v_mov_b32_e32 v2, s7
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[16:17] offset:48
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    v_mov_b32_e32 v2, s5
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[16:17] offset:32
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    v_mov_b32_e32 v2, s3
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[16:17] offset:16
; GFX12-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[16:17]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load <16 x i32>, ptr addrspace(4) %in
  %ext = zext <16 x i32> %ld to <16 x i64>
  store <16 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_sextload_v32i32_to_v32i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_sextload_v32i32_to_v32i64:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[16:19], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; GFX6-NOHSA-NEXT:    s_mov_b32 s39, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s38, -1
; GFX6-NOHSA-NEXT:    s_mov_b32 s36, s16
; GFX6-NOHSA-NEXT:    s_mov_b32 s37, s17
; GFX6-NOHSA-NEXT:    s_load_dwordx16 s[16:31], s[18:19], 0x10
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_ashr_i32 s33, s1, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s34, s0, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s35, s3, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s40, s2, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s41, s5, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s42, s4, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s43, s7, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s44, s6, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s45, s17, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s46, s16, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s47, s19, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s48, s18, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s49, s21, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s50, s20, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s51, s23, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s52, s30, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s53, s31, 31
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s52
; GFX6-NOHSA-NEXT:    s_ashr_i32 s52, s28, 31
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s53
; GFX6-NOHSA-NEXT:    s_ashr_i32 s53, s29, 31
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v5, s52
; GFX6-NOHSA-NEXT:    s_ashr_i32 s52, s26, 31
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v7, s53
; GFX6-NOHSA-NEXT:    s_ashr_i32 s53, s27, 31
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v9, s52
; GFX6-NOHSA-NEXT:    s_ashr_i32 s52, s22, 31
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v11, s53
; GFX6-NOHSA-NEXT:    s_ashr_i32 s53, s25, 31
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s30
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s31
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v4, s28
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v6, s29
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v8, s26
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v10, s27
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v12, s24
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v14, s25
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v16, s22
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v18, s23
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:240
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s20
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s21
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[36:39], 0 offset:224
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v4, s18
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v6, s19
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[36:39], 0 offset:208
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v8, s16
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v10, s17
; GFX6-NOHSA-NEXT:    s_ashr_i32 s16, s24, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s17, s9, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s18, s8, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s19, s11, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s20, s10, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s21, s13, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s22, s12, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s23, s15, 31
; GFX6-NOHSA-NEXT:    s_ashr_i32 s24, s14, 31
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v13, s16
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v15, s53
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[12:15], off, s[36:39], 0 offset:192
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v12, s14
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v14, s15
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v17, s52
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v19, s51
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[36:39], 0 offset:176
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v16, s12
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v18, s13
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s50
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s49
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:160
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v5, s48
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v7, s47
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[36:39], 0 offset:144
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v6, s9
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v9, s46
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v11, s45
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[36:39], 0 offset:128
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v8, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v10, s7
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v13, s24
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v15, s23
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[12:15], off, s[36:39], 0 offset:112
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v12, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v14, s5
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v17, s22
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v19, s21
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[36:39], 0 offset:96
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v16, s2
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v18, s3
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s20
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s19
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:80
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v5, s18
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v7, s17
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[36:39], 0 offset:64
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v9, s44
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v11, s43
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[36:39], 0 offset:48
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v13, s42
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v15, s41
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[12:15], off, s[36:39], 0 offset:32
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v17, s40
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v19, s35
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[16:19], off, s[36:39], 0 offset:16
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s34
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s33
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_sextload_v32i32_to_v32i64:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[16:19], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x10
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_ashr_i32 s20, s1, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s21, s0, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s22, s3, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s23, s2, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s24, s5, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s25, s4, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s26, s7, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s27, s6, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s28, s9, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s29, s8, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s30, s11, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s31, s10, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s33, s13, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s34, s12, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s35, s15, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s36, s14, 31
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX7-HSA-NEXT:    v_mov_b32_e32 v6, s13
; GFX7-HSA-NEXT:    v_mov_b32_e32 v8, s10
; GFX7-HSA-NEXT:    v_mov_b32_e32 v10, s11
; GFX7-HSA-NEXT:    v_mov_b32_e32 v12, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v14, s9
; GFX7-HSA-NEXT:    v_mov_b32_e32 v16, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v18, s7
; GFX7-HSA-NEXT:    v_mov_b32_e32 v20, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v22, s5
; GFX7-HSA-NEXT:    v_mov_b32_e32 v24, s2
; GFX7-HSA-NEXT:    v_mov_b32_e32 v26, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v28, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v30, s1
; GFX7-HSA-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s36
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s35
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s34
; GFX7-HSA-NEXT:    v_mov_b32_e32 v7, s33
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_ashr_i32 s37, s1, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s38, s0, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s39, s3, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s40, s2, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s41, s5, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s42, s4, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s43, s7, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s44, s6, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s45, s9, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s46, s8, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s47, s11, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s48, s10, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s49, s13, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s50, s12, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s51, s15, 31
; GFX7-HSA-NEXT:    s_ashr_i32 s52, s14, 31
; GFX7-HSA-NEXT:    s_add_u32 s18, s16, 0xf0
; GFX7-HSA-NEXT:    s_addc_u32 s19, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v32, s19
; GFX7-HSA-NEXT:    v_mov_b32_e32 v31, s18
; GFX7-HSA-NEXT:    s_add_u32 s18, s16, 0xe0
; GFX7-HSA-NEXT:    s_addc_u32 s19, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v34, s19
; GFX7-HSA-NEXT:    v_mov_b32_e32 v33, s18
; GFX7-HSA-NEXT:    s_add_u32 s18, s16, 0xd0
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[31:32], v[0:3]
; GFX7-HSA-NEXT:    s_addc_u32 s19, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s18
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s19
; GFX7-HSA-NEXT:    s_add_u32 s18, s16, 0xc0
; GFX7-HSA-NEXT:    s_addc_u32 s19, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s18
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s19
; GFX7-HSA-NEXT:    s_add_u32 s18, s16, 0xb0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v9, s31
; GFX7-HSA-NEXT:    v_mov_b32_e32 v11, s30
; GFX7-HSA-NEXT:    v_mov_b32_e32 v13, s29
; GFX7-HSA-NEXT:    v_mov_b32_e32 v15, s28
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[33:34], v[4:7]
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[8:11]
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[2:3], v[12:15]
; GFX7-HSA-NEXT:    s_addc_u32 s19, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s18
; GFX7-HSA-NEXT:    v_mov_b32_e32 v17, s27
; GFX7-HSA-NEXT:    v_mov_b32_e32 v19, s26
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s19
; GFX7-HSA-NEXT:    s_add_u32 s18, s16, 0xa0
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[16:19]
; GFX7-HSA-NEXT:    s_addc_u32 s19, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s18
; GFX7-HSA-NEXT:    v_mov_b32_e32 v21, s25
; GFX7-HSA-NEXT:    v_mov_b32_e32 v23, s24
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s19
; GFX7-HSA-NEXT:    s_add_u32 s18, s16, 0x90
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[20:23]
; GFX7-HSA-NEXT:    s_addc_u32 s19, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s18
; GFX7-HSA-NEXT:    v_mov_b32_e32 v25, s23
; GFX7-HSA-NEXT:    v_mov_b32_e32 v27, s22
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s19
; GFX7-HSA-NEXT:    s_add_u32 s18, s16, 0x80
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[24:27]
; GFX7-HSA-NEXT:    s_addc_u32 s19, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s18
; GFX7-HSA-NEXT:    v_mov_b32_e32 v29, s21
; GFX7-HSA-NEXT:    v_mov_b32_e32 v31, s20
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s19
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[28:31]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX7-HSA-NEXT:    s_add_u32 s14, s16, 0x70
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX7-HSA-NEXT:    s_addc_u32 s15, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s14
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s52
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s51
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s15
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX7-HSA-NEXT:    s_add_u32 s12, s16, 0x60
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s13
; GFX7-HSA-NEXT:    s_addc_u32 s13, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s50
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s49
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s13
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX7-HSA-NEXT:    s_add_u32 s10, s16, 0x50
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX7-HSA-NEXT:    s_addc_u32 s11, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s10
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s48
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s47
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s11
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX7-HSA-NEXT:    s_add_u32 s8, s16, 64
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX7-HSA-NEXT:    s_addc_u32 s9, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s46
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s45
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-HSA-NEXT:    s_add_u32 s6, s16, 48
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX7-HSA-NEXT:    s_addc_u32 s7, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s44
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s43
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s7
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    s_add_u32 s4, s16, 32
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-HSA-NEXT:    s_addc_u32 s5, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s42
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s41
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-HSA-NEXT:    s_add_u32 s2, s16, 16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX7-HSA-NEXT:    s_addc_u32 s3, s17, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s40
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s39
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s38
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s37
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s17
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_sextload_v32i32_to_v32i64:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[36:39], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx16 s[0:15], s[38:39], 0x0
; GFX8-NOHSA-NEXT:    s_load_dwordx16 s[16:31], s[38:39], 0x40
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_ashr_i32 s33, s1, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s34, s0, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s35, s3, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s38, s2, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s39, s5, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s40, s4, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s41, s7, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s42, s6, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s43, s9, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s44, s8, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s45, s11, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s46, s10, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s47, s13, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s48, s12, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s49, s15, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s50, s14, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s51, s17, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s52, s16, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s53, s19, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s54, s18, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s55, s21, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s56, s20, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s57, s23, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s58, s22, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s59, s25, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s60, s24, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s61, s27, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s62, s26, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s63, s29, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s64, s28, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s65, s31, 31
; GFX8-NOHSA-NEXT:    s_ashr_i32 s66, s30, 31
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s30
; GFX8-NOHSA-NEXT:    s_add_u32 s30, s36, 0xf0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s31
; GFX8-NOHSA-NEXT:    s_addc_u32 s31, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s30
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s66
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s65
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s31
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s28
; GFX8-NOHSA-NEXT:    s_add_u32 s28, s36, 0xe0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s29
; GFX8-NOHSA-NEXT:    s_addc_u32 s29, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s28
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s64
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s63
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s29
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s26
; GFX8-NOHSA-NEXT:    s_add_u32 s26, s36, 0xd0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s27
; GFX8-NOHSA-NEXT:    s_addc_u32 s27, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s26
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s62
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s61
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s27
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s24
; GFX8-NOHSA-NEXT:    s_add_u32 s24, s36, 0xc0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s25
; GFX8-NOHSA-NEXT:    s_addc_u32 s25, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s24
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s60
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s59
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s25
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s22
; GFX8-NOHSA-NEXT:    s_add_u32 s22, s36, 0xb0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s23
; GFX8-NOHSA-NEXT:    s_addc_u32 s23, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s22
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s58
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s57
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s23
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s20
; GFX8-NOHSA-NEXT:    s_add_u32 s20, s36, 0xa0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s21
; GFX8-NOHSA-NEXT:    s_addc_u32 s21, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s20
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s56
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s55
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s21
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s18
; GFX8-NOHSA-NEXT:    s_add_u32 s18, s36, 0x90
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s19
; GFX8-NOHSA-NEXT:    s_addc_u32 s19, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s18
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s54
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s53
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s19
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s16
; GFX8-NOHSA-NEXT:    s_add_u32 s16, s36, 0x80
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s17
; GFX8-NOHSA-NEXT:    s_addc_u32 s17, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s52
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s51
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s17
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX8-NOHSA-NEXT:    s_add_u32 s14, s36, 0x70
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX8-NOHSA-NEXT:    s_addc_u32 s15, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s14
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s50
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s49
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s15
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX8-NOHSA-NEXT:    s_add_u32 s12, s36, 0x60
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s13
; GFX8-NOHSA-NEXT:    s_addc_u32 s13, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s48
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s47
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s13
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX8-NOHSA-NEXT:    s_add_u32 s10, s36, 0x50
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX8-NOHSA-NEXT:    s_addc_u32 s11, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s10
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s46
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s45
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s11
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NOHSA-NEXT:    s_add_u32 s8, s36, 64
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX8-NOHSA-NEXT:    s_addc_u32 s9, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s44
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s43
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NOHSA-NEXT:    s_add_u32 s6, s36, 48
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX8-NOHSA-NEXT:    s_addc_u32 s7, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s42
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s41
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s7
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    s_add_u32 s4, s36, 32
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NOHSA-NEXT:    s_addc_u32 s5, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s40
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s39
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NOHSA-NEXT:    s_add_u32 s2, s36, 16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NOHSA-NEXT:    s_addc_u32 s3, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s38
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s35
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s36
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s34
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s33
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s37
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_sextload_v32i32_to_v32i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 32, @36, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 7 @20
; EG-NEXT:    ALU 96, @69, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T32.XYZW, T12.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T14.XYZW, T23.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T31.XYZW, T21.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T15.XYZW, T20.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T30.XYZW, T19.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T16.XYZW, T10.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T29.XYZW, T9.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T17.XYZW, T8.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T28.XYZW, T7.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T18.XYZW, T6.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T27.XYZW, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T11.XYZW, T4.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T26.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T25.XYZW, T2.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T24.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T22.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 20:
; EG-NEXT:     VTX_READ_128 T12.XYZW, T11.X, 112, #1
; EG-NEXT:     VTX_READ_128 T13.XYZW, T11.X, 96, #1
; EG-NEXT:     VTX_READ_128 T14.XYZW, T11.X, 80, #1
; EG-NEXT:     VTX_READ_128 T15.XYZW, T11.X, 64, #1
; EG-NEXT:     VTX_READ_128 T16.XYZW, T11.X, 48, #1
; EG-NEXT:     VTX_READ_128 T17.XYZW, T11.X, 32, #1
; EG-NEXT:     VTX_READ_128 T18.XYZW, T11.X, 16, #1
; EG-NEXT:     VTX_READ_128 T11.XYZW, T11.X, 0, #1
; EG-NEXT:    ALU clause starting at 36:
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T1.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T2.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T4.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T5.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 96(1.345247e-43)
; EG-NEXT:     LSHR T6.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 112(1.569454e-43)
; EG-NEXT:     LSHR T7.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 128(1.793662e-43)
; EG-NEXT:     LSHR T8.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 144(2.017870e-43)
; EG-NEXT:     LSHR T9.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 160(2.242078e-43)
; EG-NEXT:     LSHR T10.X, PV.W, literal.x,
; EG-NEXT:     MOV * T11.X, KC0[2].Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 69:
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    176(2.466285e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T19.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 192(2.690493e-43)
; EG-NEXT:     LSHR T20.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 208(2.914701e-43)
; EG-NEXT:     LSHR T21.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT T0.W, KC0[2].Y, literal.y,
; EG-NEXT:     ASHR * T22.W, T11.Y, literal.z,
; EG-NEXT:    2(2.802597e-45), 224(3.138909e-43)
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T23.X, PV.W, literal.x,
; EG-NEXT:     ASHR T22.Y, T11.X, literal.y,
; EG-NEXT:     ASHR T24.W, T11.W, literal.y,
; EG-NEXT:     MOV * T22.X, T11.X,
; EG-NEXT:    2(2.802597e-45), 31(4.344025e-44)
; EG-NEXT:     ASHR T24.Y, T11.Z, literal.x,
; EG-NEXT:     ASHR * T25.W, T18.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T24.X, T11.Z,
; EG-NEXT:     ASHR T25.Y, T18.X, literal.x,
; EG-NEXT:     MOV T22.Z, T11.Y,
; EG-NEXT:     ASHR T26.W, T18.W, literal.x,
; EG-NEXT:     MOV * T25.X, T18.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T26.Y, T18.Z, literal.x,
; EG-NEXT:     MOV T24.Z, T11.W,
; EG-NEXT:     ASHR * T11.W, T17.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T26.X, T18.Z,
; EG-NEXT:     ASHR T11.Y, T17.X, literal.x,
; EG-NEXT:     MOV T25.Z, T18.Y,
; EG-NEXT:     ASHR T27.W, T17.W, literal.x,
; EG-NEXT:     MOV * T11.X, T17.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T27.Y, T17.Z, literal.x,
; EG-NEXT:     MOV T26.Z, T18.W,
; EG-NEXT:     ASHR * T18.W, T16.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T27.X, T17.Z,
; EG-NEXT:     ASHR T18.Y, T16.X, literal.x,
; EG-NEXT:     MOV T11.Z, T17.Y,
; EG-NEXT:     ASHR T28.W, T16.W, literal.x,
; EG-NEXT:     MOV * T18.X, T16.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T28.Y, T16.Z, literal.x,
; EG-NEXT:     MOV T27.Z, T17.W,
; EG-NEXT:     ASHR * T17.W, T15.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T28.X, T16.Z,
; EG-NEXT:     ASHR T17.Y, T15.X, literal.x,
; EG-NEXT:     MOV T18.Z, T16.Y,
; EG-NEXT:     ASHR T29.W, T15.W, literal.x,
; EG-NEXT:     MOV * T17.X, T15.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T29.Y, T15.Z, literal.x,
; EG-NEXT:     MOV T28.Z, T16.W,
; EG-NEXT:     ASHR * T16.W, T14.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T29.X, T15.Z,
; EG-NEXT:     ASHR T16.Y, T14.X, literal.x,
; EG-NEXT:     MOV T17.Z, T15.Y,
; EG-NEXT:     ASHR T30.W, T14.W, literal.x,
; EG-NEXT:     MOV * T16.X, T14.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T30.Y, T14.Z, literal.x,
; EG-NEXT:     MOV T29.Z, T15.W,
; EG-NEXT:     ASHR * T15.W, T13.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T30.X, T14.Z,
; EG-NEXT:     ASHR T15.Y, T13.X, literal.x,
; EG-NEXT:     MOV T16.Z, T14.Y,
; EG-NEXT:     ASHR T31.W, T13.W, literal.x,
; EG-NEXT:     MOV * T15.X, T13.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T31.Y, T13.Z, literal.x,
; EG-NEXT:     MOV T30.Z, T14.W,
; EG-NEXT:     ASHR * T14.W, T12.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T31.X, T13.Z,
; EG-NEXT:     ASHR T14.Y, T12.X, literal.x,
; EG-NEXT:     MOV T15.Z, T13.Y,
; EG-NEXT:     ASHR T32.W, T12.W, literal.x,
; EG-NEXT:     MOV * T14.X, T12.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T32.Y, T12.Z, literal.x,
; EG-NEXT:     MOV * T31.Z, T13.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     MOV T32.X, T12.Z,
; EG-NEXT:     MOV T14.Z, T12.Y,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    240(3.363116e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T12.X, PV.W, literal.x,
; EG-NEXT:     MOV * T32.Z, T12.W,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_sextload_v32i32_to_v32i64:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[36:39], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx16 s[16:31], s[38:39], 0x40
; GFX9-HSA-NEXT:    s_load_dwordx16 s[0:15], s[38:39], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_ashr_i32 s65, s31, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s66, s30, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s63, s29, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s64, s28, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s30
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s66
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s65
; GFX9-HSA-NEXT:    s_ashr_i32 s61, s27, 31
; GFX9-HSA-NEXT:    s_ashr_i32 s62, s26, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:240
; GFX9-HSA-NEXT:    s_ashr_i32 s59, s25, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s28
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s64
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s29
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s63
; GFX9-HSA-NEXT:    s_ashr_i32 s60, s24, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:224
; GFX9-HSA-NEXT:    s_ashr_i32 s57, s23, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s26
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s62
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s27
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s61
; GFX9-HSA-NEXT:    s_ashr_i32 s58, s22, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:208
; GFX9-HSA-NEXT:    s_ashr_i32 s55, s21, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s24
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s60
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s25
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s59
; GFX9-HSA-NEXT:    s_ashr_i32 s56, s20, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:192
; GFX9-HSA-NEXT:    s_ashr_i32 s53, s19, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s22
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s58
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s23
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s57
; GFX9-HSA-NEXT:    s_ashr_i32 s54, s18, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:176
; GFX9-HSA-NEXT:    s_ashr_i32 s51, s17, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s20
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s56
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s21
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s55
; GFX9-HSA-NEXT:    s_ashr_i32 s52, s16, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:160
; GFX9-HSA-NEXT:    s_ashr_i32 s49, s15, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s18
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s54
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s53
; GFX9-HSA-NEXT:    s_ashr_i32 s50, s14, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:144
; GFX9-HSA-NEXT:    s_ashr_i32 s47, s13, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s16
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s52
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s17
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s51
; GFX9-HSA-NEXT:    s_ashr_i32 s48, s12, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:128
; GFX9-HSA-NEXT:    s_ashr_i32 s45, s11, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s14
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s50
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s15
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s49
; GFX9-HSA-NEXT:    s_ashr_i32 s46, s10, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:112
; GFX9-HSA-NEXT:    s_ashr_i32 s43, s9, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s12
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s48
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s13
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s47
; GFX9-HSA-NEXT:    s_ashr_i32 s44, s8, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:96
; GFX9-HSA-NEXT:    s_ashr_i32 s41, s7, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s10
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s46
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s11
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s45
; GFX9-HSA-NEXT:    s_ashr_i32 s42, s6, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:80
; GFX9-HSA-NEXT:    s_ashr_i32 s39, s5, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s44
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s43
; GFX9-HSA-NEXT:    s_ashr_i32 s40, s4, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:64
; GFX9-HSA-NEXT:    s_ashr_i32 s35, s3, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s42
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s41
; GFX9-HSA-NEXT:    s_ashr_i32 s38, s2, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:48
; GFX9-HSA-NEXT:    s_ashr_i32 s33, s1, 31
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s40
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s39
; GFX9-HSA-NEXT:    s_ashr_i32 s34, s0, 31
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:32
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s38
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s35
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37] offset:16
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s34
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s33
; GFX9-HSA-NEXT:    global_store_dwordx4 v0, v[1:4], s[36:37]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_sextload_v32i32_to_v32i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[36:39], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b512 s[0:15], s[38:39], 0x0
; GFX12-NEXT:    s_load_b512 s[16:31], s[38:39], 0x40
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_ashr_i32 s49, s15, 31
; GFX12-NEXT:    s_ashr_i32 s64, s31, 31
; GFX12-NEXT:    s_ashr_i32 s65, s30, 31
; GFX12-NEXT:    s_ashr_i32 s62, s29, 31
; GFX12-NEXT:    s_ashr_i32 s63, s28, 31
; GFX12-NEXT:    v_dual_mov_b32 v24, 0 :: v_dual_mov_b32 v1, s65
; GFX12-NEXT:    s_ashr_i32 s60, s27, 31
; GFX12-NEXT:    s_ashr_i32 s61, s26, 31
; GFX12-NEXT:    v_dual_mov_b32 v0, s30 :: v_dual_mov_b32 v3, s64
; GFX12-NEXT:    v_dual_mov_b32 v2, s31 :: v_dual_mov_b32 v5, s63
; GFX12-NEXT:    s_ashr_i32 s58, s25, 31
; GFX12-NEXT:    s_ashr_i32 s59, s24, 31
; GFX12-NEXT:    v_dual_mov_b32 v4, s28 :: v_dual_mov_b32 v7, s62
; GFX12-NEXT:    v_dual_mov_b32 v6, s29 :: v_dual_mov_b32 v9, s61
; GFX12-NEXT:    v_dual_mov_b32 v8, s26 :: v_dual_mov_b32 v11, s60
; GFX12-NEXT:    v_dual_mov_b32 v10, s27 :: v_dual_mov_b32 v13, s59
; GFX12-NEXT:    s_ashr_i32 s57, s23, 31
; GFX12-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s58
; GFX12-NEXT:    s_ashr_i32 s24, s22, 31
; GFX12-NEXT:    v_mov_b32_e32 v14, s25
; GFX12-NEXT:    s_ashr_i32 s55, s21, 31
; GFX12-NEXT:    s_ashr_i32 s56, s20, 31
; GFX12-NEXT:    s_ashr_i32 s53, s19, 31
; GFX12-NEXT:    s_ashr_i32 s54, s18, 31
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    global_store_b128 v24, v[0:3], s[36:37] offset:240
; GFX12-NEXT:    global_store_b128 v24, v[4:7], s[36:37] offset:224
; GFX12-NEXT:    global_store_b128 v24, v[8:11], s[36:37] offset:208
; GFX12-NEXT:    global_store_b128 v24, v[12:15], s[36:37] offset:192
; GFX12-NEXT:    v_dual_mov_b32 v1, s24 :: v_dual_mov_b32 v0, s22
; GFX12-NEXT:    v_dual_mov_b32 v3, s57 :: v_dual_mov_b32 v2, s23
; GFX12-NEXT:    v_mov_b32_e32 v5, s56
; GFX12-NEXT:    s_ashr_i32 s51, s17, 31
; GFX12-NEXT:    s_ashr_i32 s52, s16, 31
; GFX12-NEXT:    v_dual_mov_b32 v4, s20 :: v_dual_mov_b32 v7, s55
; GFX12-NEXT:    v_dual_mov_b32 v6, s21 :: v_dual_mov_b32 v9, s54
; GFX12-NEXT:    s_ashr_i32 s50, s14, 31
; GFX12-NEXT:    v_dual_mov_b32 v8, s18 :: v_dual_mov_b32 v11, s53
; GFX12-NEXT:    v_dual_mov_b32 v10, s19 :: v_dual_mov_b32 v13, s52
; GFX12-NEXT:    s_ashr_i32 s45, s11, 31
; GFX12-NEXT:    s_ashr_i32 s46, s10, 31
; GFX12-NEXT:    s_ashr_i32 s47, s13, 31
; GFX12-NEXT:    s_ashr_i32 s48, s12, 31
; GFX12-NEXT:    v_dual_mov_b32 v12, s16 :: v_dual_mov_b32 v15, s51
; GFX12-NEXT:    v_dual_mov_b32 v14, s17 :: v_dual_mov_b32 v17, s50
; GFX12-NEXT:    s_ashr_i32 s43, s9, 31
; GFX12-NEXT:    s_ashr_i32 s44, s8, 31
; GFX12-NEXT:    v_dual_mov_b32 v16, s14 :: v_dual_mov_b32 v19, s49
; GFX12-NEXT:    v_dual_mov_b32 v18, s15 :: v_dual_mov_b32 v21, s48
; GFX12-NEXT:    s_ashr_i32 s41, s7, 31
; GFX12-NEXT:    s_ashr_i32 s42, s6, 31
; GFX12-NEXT:    v_dual_mov_b32 v20, s12 :: v_dual_mov_b32 v23, s47
; GFX12-NEXT:    v_mov_b32_e32 v22, s13
; GFX12-NEXT:    s_clause 0x5
; GFX12-NEXT:    global_store_b128 v24, v[0:3], s[36:37] offset:176
; GFX12-NEXT:    global_store_b128 v24, v[4:7], s[36:37] offset:160
; GFX12-NEXT:    global_store_b128 v24, v[8:11], s[36:37] offset:144
; GFX12-NEXT:    global_store_b128 v24, v[12:15], s[36:37] offset:128
; GFX12-NEXT:    global_store_b128 v24, v[16:19], s[36:37] offset:112
; GFX12-NEXT:    global_store_b128 v24, v[20:23], s[36:37] offset:96
; GFX12-NEXT:    v_dual_mov_b32 v1, s46 :: v_dual_mov_b32 v0, s10
; GFX12-NEXT:    v_dual_mov_b32 v3, s45 :: v_dual_mov_b32 v2, s11
; GFX12-NEXT:    v_mov_b32_e32 v5, s44
; GFX12-NEXT:    s_ashr_i32 s39, s5, 31
; GFX12-NEXT:    s_ashr_i32 s40, s4, 31
; GFX12-NEXT:    v_dual_mov_b32 v4, s8 :: v_dual_mov_b32 v7, s43
; GFX12-NEXT:    v_dual_mov_b32 v6, s9 :: v_dual_mov_b32 v9, s42
; GFX12-NEXT:    s_ashr_i32 s35, s3, 31
; GFX12-NEXT:    s_ashr_i32 s38, s2, 31
; GFX12-NEXT:    v_dual_mov_b32 v8, s6 :: v_dual_mov_b32 v11, s41
; GFX12-NEXT:    v_dual_mov_b32 v10, s7 :: v_dual_mov_b32 v13, s40
; GFX12-NEXT:    s_ashr_i32 s33, s1, 31
; GFX12-NEXT:    s_ashr_i32 s34, s0, 31
; GFX12-NEXT:    v_dual_mov_b32 v12, s4 :: v_dual_mov_b32 v15, s39
; GFX12-NEXT:    v_dual_mov_b32 v14, s5 :: v_dual_mov_b32 v17, s38
; GFX12-NEXT:    v_dual_mov_b32 v16, s2 :: v_dual_mov_b32 v19, s35
; GFX12-NEXT:    v_dual_mov_b32 v18, s3 :: v_dual_mov_b32 v21, s34
; GFX12-NEXT:    v_dual_mov_b32 v20, s0 :: v_dual_mov_b32 v23, s33
; GFX12-NEXT:    v_mov_b32_e32 v22, s1
; GFX12-NEXT:    s_clause 0x5
; GFX12-NEXT:    global_store_b128 v24, v[0:3], s[36:37] offset:80
; GFX12-NEXT:    global_store_b128 v24, v[4:7], s[36:37] offset:64
; GFX12-NEXT:    global_store_b128 v24, v[8:11], s[36:37] offset:48
; GFX12-NEXT:    global_store_b128 v24, v[12:15], s[36:37] offset:32
; GFX12-NEXT:    global_store_b128 v24, v[16:19], s[36:37] offset:16
; GFX12-NEXT:    global_store_b128 v24, v[20:23], s[36:37]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load <32 x i32>, ptr addrspace(4) %in
  %ext = sext <32 x i32> %ld to <32 x i64>
  store <32 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_zextload_v32i32_to_v32i64(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_zextload_v32i32_to_v32i64:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx16 s[16:31], s[2:3], 0x10
; GFX6-NOHSA-NEXT:    s_mov_b32 s39, 0xf000
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX6-NOHSA-NEXT:    s_mov_b32 s38, -1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NOHSA-NEXT:    s_mov_b32 s36, s0
; GFX6-NOHSA-NEXT:    s_mov_b32 s37, s1
; GFX6-NOHSA-NEXT:    s_load_dwordx16 s[0:15], s[2:3], 0x0
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s30
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s31
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:240
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s28
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s29
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:224
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s26
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s27
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:208
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s24
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s25
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:192
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s22
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s23
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:176
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s20
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s21
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:160
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s18
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s19
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:144
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s16
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s17
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:128
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:112
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s13
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:96
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:80
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:64
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:48
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:32
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:16
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_zextload_v32i32_to_v32i64:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[36:39], s[4:5], 0x0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx16 s[16:31], s[38:39], 0x10
; GFX7-HSA-NEXT:    s_load_dwordx16 s[0:15], s[38:39], 0x0
; GFX7-HSA-NEXT:    s_add_u32 s34, s36, 0xf0
; GFX7-HSA-NEXT:    s_addc_u32 s35, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s34
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s35
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s30
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s31
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s28
; GFX7-HSA-NEXT:    s_add_u32 s28, s36, 0xe0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s29
; GFX7-HSA-NEXT:    s_addc_u32 s29, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s28
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s29
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s26
; GFX7-HSA-NEXT:    s_add_u32 s26, s36, 0xd0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s27
; GFX7-HSA-NEXT:    s_addc_u32 s27, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s26
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s27
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s24
; GFX7-HSA-NEXT:    s_add_u32 s24, s36, 0xc0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s25
; GFX7-HSA-NEXT:    s_addc_u32 s25, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s24
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s25
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s22
; GFX7-HSA-NEXT:    s_add_u32 s22, s36, 0xb0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s23
; GFX7-HSA-NEXT:    s_addc_u32 s23, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s22
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s23
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s20
; GFX7-HSA-NEXT:    s_add_u32 s20, s36, 0xa0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s21
; GFX7-HSA-NEXT:    s_addc_u32 s21, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s20
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s21
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s18
; GFX7-HSA-NEXT:    s_add_u32 s18, s36, 0x90
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s19
; GFX7-HSA-NEXT:    s_addc_u32 s19, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s18
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s19
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s16
; GFX7-HSA-NEXT:    s_add_u32 s16, s36, 0x80
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s17
; GFX7-HSA-NEXT:    s_addc_u32 s17, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s17
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX7-HSA-NEXT:    s_add_u32 s14, s36, 0x70
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX7-HSA-NEXT:    s_addc_u32 s15, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s14
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s15
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX7-HSA-NEXT:    s_add_u32 s12, s36, 0x60
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s13
; GFX7-HSA-NEXT:    s_addc_u32 s13, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s13
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX7-HSA-NEXT:    s_add_u32 s10, s36, 0x50
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX7-HSA-NEXT:    s_addc_u32 s11, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s10
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s11
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX7-HSA-NEXT:    s_add_u32 s8, s36, 64
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX7-HSA-NEXT:    s_addc_u32 s9, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-HSA-NEXT:    s_add_u32 s6, s36, 48
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX7-HSA-NEXT:    s_addc_u32 s7, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s7
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    s_add_u32 s4, s36, 32
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-HSA-NEXT:    s_addc_u32 s5, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-HSA-NEXT:    s_add_u32 s2, s36, 16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX7-HSA-NEXT:    s_addc_u32 s3, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s36
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s37
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_zextload_v32i32_to_v32i64:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[36:39], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx16 s[16:31], s[38:39], 0x40
; GFX8-NOHSA-NEXT:    s_load_dwordx16 s[0:15], s[38:39], 0x0
; GFX8-NOHSA-NEXT:    s_add_u32 s34, s36, 0xf0
; GFX8-NOHSA-NEXT:    s_addc_u32 s35, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s34
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s35
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s30
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s31
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s28
; GFX8-NOHSA-NEXT:    s_add_u32 s28, s36, 0xe0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s29
; GFX8-NOHSA-NEXT:    s_addc_u32 s29, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s28
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s29
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s26
; GFX8-NOHSA-NEXT:    s_add_u32 s26, s36, 0xd0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s27
; GFX8-NOHSA-NEXT:    s_addc_u32 s27, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s26
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s27
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s24
; GFX8-NOHSA-NEXT:    s_add_u32 s24, s36, 0xc0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s25
; GFX8-NOHSA-NEXT:    s_addc_u32 s25, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s24
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s25
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s22
; GFX8-NOHSA-NEXT:    s_add_u32 s22, s36, 0xb0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s23
; GFX8-NOHSA-NEXT:    s_addc_u32 s23, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s22
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s23
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s20
; GFX8-NOHSA-NEXT:    s_add_u32 s20, s36, 0xa0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s21
; GFX8-NOHSA-NEXT:    s_addc_u32 s21, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s20
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s21
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s18
; GFX8-NOHSA-NEXT:    s_add_u32 s18, s36, 0x90
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s19
; GFX8-NOHSA-NEXT:    s_addc_u32 s19, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s18
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s19
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s16
; GFX8-NOHSA-NEXT:    s_add_u32 s16, s36, 0x80
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s17
; GFX8-NOHSA-NEXT:    s_addc_u32 s17, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s17
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX8-NOHSA-NEXT:    s_add_u32 s14, s36, 0x70
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX8-NOHSA-NEXT:    s_addc_u32 s15, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s14
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s15
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX8-NOHSA-NEXT:    s_add_u32 s12, s36, 0x60
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s13
; GFX8-NOHSA-NEXT:    s_addc_u32 s13, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s13
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX8-NOHSA-NEXT:    s_add_u32 s10, s36, 0x50
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX8-NOHSA-NEXT:    s_addc_u32 s11, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s10
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s11
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NOHSA-NEXT:    s_add_u32 s8, s36, 64
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX8-NOHSA-NEXT:    s_addc_u32 s9, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NOHSA-NEXT:    s_add_u32 s6, s36, 48
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX8-NOHSA-NEXT:    s_addc_u32 s7, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s7
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    s_add_u32 s4, s36, 32
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NOHSA-NEXT:    s_addc_u32 s5, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NOHSA-NEXT:    s_add_u32 s2, s36, 16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NOHSA-NEXT:    s_addc_u32 s3, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s36
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s37
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_zextload_v32i32_to_v32i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @38, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 2 @22
; EG-NEXT:    ALU 10, @39, KC0[], KC1[]
; EG-NEXT:    TEX 4 @28
; EG-NEXT:    ALU 99, @50, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T31.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T5.XYZW, T30.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T6.XYZW, T29.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T28.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T8.XYZW, T27.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T9.XYZW, T26.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T14.XYZW, T25.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T15.XYZW, T24.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T16.XYZW, T13.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T17.XYZW, T12.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T18.XYZW, T11.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T19.XYZW, T10.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T20.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T21.XYZW, T2.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T22.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T23.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 22:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 112, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T0.X, 80, #1
; EG-NEXT:     VTX_READ_128 T3.XYZW, T0.X, 96, #1
; EG-NEXT:    Fetch clause starting at 28:
; EG-NEXT:     VTX_READ_128 T10.XYZW, T0.X, 0, #1
; EG-NEXT:     VTX_READ_128 T11.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T12.XYZW, T0.X, 32, #1
; EG-NEXT:     VTX_READ_128 T13.XYZW, T0.X, 48, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 64, #1
; EG-NEXT:    ALU clause starting at 38:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 39:
; EG-NEXT:     MOV T4.X, T1.Z,
; EG-NEXT:     MOV T4.Y, 0.0,
; EG-NEXT:     MOV * T5.X, T1.X,
; EG-NEXT:     MOV * T5.Y, 0.0,
; EG-NEXT:     MOV T6.X, T3.Z,
; EG-NEXT:     MOV T6.Y, 0.0,
; EG-NEXT:     MOV * T7.X, T3.X,
; EG-NEXT:     MOV * T7.Y, 0.0,
; EG-NEXT:     MOV T8.X, T2.Z,
; EG-NEXT:     MOV T8.Y, 0.0,
; EG-NEXT:     MOV * T9.X, T2.X,
; EG-NEXT:    ALU clause starting at 50:
; EG-NEXT:     MOV * T9.Y, 0.0,
; EG-NEXT:     MOV T14.X, T0.Z,
; EG-NEXT:     MOV T14.Y, 0.0,
; EG-NEXT:     MOV * T15.X, T0.X,
; EG-NEXT:     MOV * T15.Y, 0.0,
; EG-NEXT:     MOV T16.X, T13.Z,
; EG-NEXT:     MOV T16.Y, 0.0,
; EG-NEXT:     MOV * T17.X, T13.X,
; EG-NEXT:     MOV * T17.Y, 0.0,
; EG-NEXT:     MOV T18.X, T12.Z,
; EG-NEXT:     MOV T18.Y, 0.0,
; EG-NEXT:     MOV * T19.X, T12.X,
; EG-NEXT:     MOV * T19.Y, 0.0,
; EG-NEXT:     MOV T20.X, T11.Z,
; EG-NEXT:     MOV T20.Y, 0.0,
; EG-NEXT:     MOV * T21.X, T11.X,
; EG-NEXT:     MOV * T21.Y, 0.0,
; EG-NEXT:     MOV T22.X, T10.Z,
; EG-NEXT:     MOV T22.Y, 0.0,
; EG-NEXT:     MOV * T23.X, T10.X,
; EG-NEXT:     MOV T23.Y, 0.0,
; EG-NEXT:     MOV T4.Z, T1.W,
; EG-NEXT:     MOV T4.W, 0.0,
; EG-NEXT:     MOV * T5.Z, T1.Y,
; EG-NEXT:     MOV * T5.W, 0.0,
; EG-NEXT:     MOV T6.Z, T3.W,
; EG-NEXT:     MOV T6.W, 0.0,
; EG-NEXT:     MOV * T7.Z, T3.Y,
; EG-NEXT:     MOV * T7.W, 0.0,
; EG-NEXT:     MOV T8.Z, T2.W,
; EG-NEXT:     MOV T8.W, 0.0,
; EG-NEXT:     MOV * T9.Z, T2.Y,
; EG-NEXT:     MOV * T9.W, 0.0,
; EG-NEXT:     MOV T14.Z, T0.W,
; EG-NEXT:     MOV T14.W, 0.0,
; EG-NEXT:     MOV * T15.Z, T0.Y,
; EG-NEXT:     MOV * T15.W, 0.0,
; EG-NEXT:     MOV T16.Z, T13.W,
; EG-NEXT:     MOV T16.W, 0.0,
; EG-NEXT:     MOV * T17.Z, T13.Y,
; EG-NEXT:     MOV * T17.W, 0.0,
; EG-NEXT:     MOV T18.Z, T12.W,
; EG-NEXT:     MOV T18.W, 0.0,
; EG-NEXT:     MOV * T19.Z, T12.Y,
; EG-NEXT:     MOV * T19.W, 0.0,
; EG-NEXT:     MOV T20.Z, T11.W,
; EG-NEXT:     MOV T20.W, 0.0,
; EG-NEXT:     MOV * T21.Z, T11.Y,
; EG-NEXT:     MOV * T21.W, 0.0,
; EG-NEXT:     MOV T22.Z, T10.W,
; EG-NEXT:     MOV T22.W, 0.0,
; EG-NEXT:     MOV * T23.Z, T10.Y,
; EG-NEXT:     MOV * T23.W, 0.0,
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T1.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T2.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T10.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T11.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 96(1.345247e-43)
; EG-NEXT:     LSHR T12.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 112(1.569454e-43)
; EG-NEXT:     LSHR T13.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 128(1.793662e-43)
; EG-NEXT:     LSHR T24.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 144(2.017870e-43)
; EG-NEXT:     LSHR T25.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 160(2.242078e-43)
; EG-NEXT:     LSHR T26.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 176(2.466285e-43)
; EG-NEXT:     LSHR T27.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 192(2.690493e-43)
; EG-NEXT:     LSHR T28.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 208(2.914701e-43)
; EG-NEXT:     LSHR T29.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 224(3.138909e-43)
; EG-NEXT:     LSHR T30.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 240(3.363116e-43)
; EG-NEXT:     LSHR * T31.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_zextload_v32i32_to_v32i64:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[36:39], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx16 s[16:31], s[38:39], 0x40
; GFX9-HSA-NEXT:    s_load_dwordx16 s[0:15], s[38:39], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s30
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s31
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:240
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s28
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s29
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:224
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s26
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s27
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:208
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s24
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s25
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:192
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s22
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s23
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:176
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s20
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s21
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:160
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s18
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s19
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:144
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s17
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:128
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s14
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s15
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:112
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s13
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:96
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s10
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s11
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:80
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s9
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:64
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:48
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:32
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37] offset:16
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-HSA-NEXT:    global_store_dwordx4 v1, v[0:3], s[36:37]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_zextload_v32i32_to_v32i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[36:39], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b512 s[16:31], s[38:39], 0x40
; GFX12-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-NEXT:    s_load_b512 s[0:15], s[38:39], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v0, s30 :: v_dual_mov_b32 v3, v1
; GFX12-NEXT:    v_mov_b32_e32 v2, s31
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:240
; GFX12-NEXT:    v_mov_b32_e32 v0, s28
; GFX12-NEXT:    v_mov_b32_e32 v2, s29
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:224
; GFX12-NEXT:    v_mov_b32_e32 v0, s26
; GFX12-NEXT:    v_mov_b32_e32 v2, s27
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:208
; GFX12-NEXT:    v_mov_b32_e32 v0, s24
; GFX12-NEXT:    v_mov_b32_e32 v2, s25
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:192
; GFX12-NEXT:    v_mov_b32_e32 v0, s22
; GFX12-NEXT:    v_mov_b32_e32 v2, s23
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:176
; GFX12-NEXT:    v_mov_b32_e32 v0, s20
; GFX12-NEXT:    v_mov_b32_e32 v2, s21
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:160
; GFX12-NEXT:    v_mov_b32_e32 v0, s18
; GFX12-NEXT:    v_mov_b32_e32 v2, s19
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:144
; GFX12-NEXT:    v_mov_b32_e32 v0, s16
; GFX12-NEXT:    v_mov_b32_e32 v2, s17
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:128
; GFX12-NEXT:    v_mov_b32_e32 v0, s14
; GFX12-NEXT:    v_mov_b32_e32 v2, s15
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:112
; GFX12-NEXT:    v_mov_b32_e32 v0, s12
; GFX12-NEXT:    v_mov_b32_e32 v2, s13
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:96
; GFX12-NEXT:    v_mov_b32_e32 v0, s10
; GFX12-NEXT:    v_mov_b32_e32 v2, s11
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:80
; GFX12-NEXT:    v_mov_b32_e32 v0, s8
; GFX12-NEXT:    v_mov_b32_e32 v2, s9
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:64
; GFX12-NEXT:    v_mov_b32_e32 v0, s6
; GFX12-NEXT:    v_mov_b32_e32 v2, s7
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:48
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    v_mov_b32_e32 v2, s5
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:32
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    v_mov_b32_e32 v2, s3
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37] offset:16
; GFX12-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-NEXT:    global_store_b128 v1, v[0:3], s[36:37]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load <32 x i32>, ptr addrspace(4) %in
  %ext = zext <32 x i32> %ld to <32 x i64>
  store <32 x i64> %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @constant_load_v32i32(ptr addrspace(1) %out, ptr addrspace(4) %in) #0 {
; GFX6-NOHSA-LABEL: constant_load_v32i32:
; GFX6-NOHSA:       ; %bb.0:
; GFX6-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    s_load_dwordx16 s[16:31], s[2:3], 0x10
; GFX6-NOHSA-NEXT:    s_mov_b32 s39, 0xf000
; GFX6-NOHSA-NEXT:    s_mov_b32 s38, -1
; GFX6-NOHSA-NEXT:    s_mov_b32 s36, s0
; GFX6-NOHSA-NEXT:    s_mov_b32 s37, s1
; GFX6-NOHSA-NEXT:    s_load_dwordx16 s[0:15], s[2:3], 0x0
; GFX6-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s28
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s29
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s30
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s31
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:112
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s24
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s25
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s26
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s27
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:96
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s20
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s21
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s22
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s23
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:80
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s16
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s17
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s18
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s19
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:64
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s14
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s15
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:48
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s9
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s10
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s11
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:32
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0 offset:16
; GFX6-NOHSA-NEXT:    s_waitcnt expcnt(0)
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX6-NOHSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[36:39], 0
; GFX6-NOHSA-NEXT:    s_endpgm
;
; GFX7-HSA-LABEL: constant_load_v32i32:
; GFX7-HSA:       ; %bb.0:
; GFX7-HSA-NEXT:    s_load_dwordx4 s[36:39], s[4:5], 0x0
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    s_load_dwordx16 s[16:31], s[38:39], 0x10
; GFX7-HSA-NEXT:    s_load_dwordx16 s[0:15], s[38:39], 0x0
; GFX7-HSA-NEXT:    s_add_u32 s34, s36, 0x70
; GFX7-HSA-NEXT:    s_addc_u32 s35, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s34
; GFX7-HSA-NEXT:    v_mov_b32_e32 v6, s35
; GFX7-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s28
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s29
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s30
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s31
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s24
; GFX7-HSA-NEXT:    s_add_u32 s24, s36, 0x60
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[5:6], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s25
; GFX7-HSA-NEXT:    s_addc_u32 s25, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s24
; GFX7-HSA-NEXT:    v_mov_b32_e32 v6, s26
; GFX7-HSA-NEXT:    v_mov_b32_e32 v7, s27
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s25
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s20
; GFX7-HSA-NEXT:    s_add_u32 s20, s36, 0x50
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s21
; GFX7-HSA-NEXT:    s_addc_u32 s21, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s20
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s22
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s23
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s21
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s16
; GFX7-HSA-NEXT:    s_add_u32 s16, s36, 64
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s17
; GFX7-HSA-NEXT:    s_addc_u32 s17, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s18
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s19
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s17
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX7-HSA-NEXT:    s_add_u32 s12, s36, 48
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX7-HSA-NEXT:    s_addc_u32 s13, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s14
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s15
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s13
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX7-HSA-NEXT:    s_add_u32 s8, s36, 32
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s9
; GFX7-HSA-NEXT:    s_addc_u32 s9, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s10
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s11
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_nop 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-HSA-NEXT:    s_add_u32 s4, s36, 16
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-HSA-NEXT:    s_addc_u32 s5, s37, 0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    v_mov_b32_e32 v4, s36
; GFX7-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-HSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-HSA-NEXT:    v_mov_b32_e32 v5, s37
; GFX7-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX7-HSA-NEXT:    s_endpgm
;
; GFX8-NOHSA-LABEL: constant_load_v32i32:
; GFX8-NOHSA:       ; %bb.0:
; GFX8-NOHSA-NEXT:    s_load_dwordx4 s[36:39], s[0:1], 0x24
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    s_load_dwordx16 s[16:31], s[38:39], 0x40
; GFX8-NOHSA-NEXT:    s_load_dwordx16 s[0:15], s[38:39], 0x0
; GFX8-NOHSA-NEXT:    s_add_u32 s34, s36, 0x70
; GFX8-NOHSA-NEXT:    s_addc_u32 s35, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s34
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v6, s35
; GFX8-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s28
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s29
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s30
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s31
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s24
; GFX8-NOHSA-NEXT:    s_add_u32 s24, s36, 0x60
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[5:6], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s25
; GFX8-NOHSA-NEXT:    s_addc_u32 s25, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s24
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v6, s26
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v7, s27
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s25
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s20
; GFX8-NOHSA-NEXT:    s_add_u32 s20, s36, 0x50
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s21
; GFX8-NOHSA-NEXT:    s_addc_u32 s21, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s20
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s22
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s23
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s21
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s16
; GFX8-NOHSA-NEXT:    s_add_u32 s16, s36, 64
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s17
; GFX8-NOHSA-NEXT:    s_addc_u32 s17, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s18
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s19
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s17
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX8-NOHSA-NEXT:    s_add_u32 s12, s36, 48
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX8-NOHSA-NEXT:    s_addc_u32 s13, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s12
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s14
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s15
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s13
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NOHSA-NEXT:    s_add_u32 s8, s36, 32
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NOHSA-NEXT:    s_addc_u32 s9, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s8
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s10
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s11
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s9
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_nop 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NOHSA-NEXT:    s_add_u32 s4, s36, 16
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NOHSA-NEXT:    s_addc_u32 s5, s37, 0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s5
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v4, s36
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NOHSA-NEXT:    v_mov_b32_e32 v5, s37
; GFX8-NOHSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NOHSA-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v32i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 22, @28, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 7 @12
; EG-NEXT:    ALU 1, @51, KC0[], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T8.XYZW, T15.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T9.XYZW, T6.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T10.XYZW, T5.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T11.XYZW, T4.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T12.XYZW, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T13.XYZW, T2.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T14.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 12:
; EG-NEXT:     VTX_READ_128 T8.XYZW, T7.X, 112, #1
; EG-NEXT:     VTX_READ_128 T9.XYZW, T7.X, 96, #1
; EG-NEXT:     VTX_READ_128 T10.XYZW, T7.X, 80, #1
; EG-NEXT:     VTX_READ_128 T11.XYZW, T7.X, 64, #1
; EG-NEXT:     VTX_READ_128 T12.XYZW, T7.X, 48, #1
; EG-NEXT:     VTX_READ_128 T13.XYZW, T7.X, 32, #1
; EG-NEXT:     VTX_READ_128 T14.XYZW, T7.X, 16, #1
; EG-NEXT:     VTX_READ_128 T7.XYZW, T7.X, 0, #1
; EG-NEXT:    ALU clause starting at 28:
; EG-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 16(2.242078e-44)
; EG-NEXT:     LSHR T1.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     LSHR T2.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 48(6.726233e-44)
; EG-NEXT:     LSHR T3.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 64(8.968310e-44)
; EG-NEXT:     LSHR T4.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
; EG-NEXT:     LSHR T5.X, PV.W, literal.x,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 96(1.345247e-43)
; EG-NEXT:     LSHR T6.X, PV.W, literal.x,
; EG-NEXT:     MOV * T7.X, KC0[2].Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, literal.x,
; EG-NEXT:    112(1.569454e-43), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 51:
; EG-NEXT:     LSHR * T15.X, T0.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX9-HSA-LABEL: constant_load_v32i32:
; GFX9-HSA:       ; %bb.0:
; GFX9-HSA-NEXT:    s_load_dwordx4 s[36:39], s[4:5], 0x0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    s_load_dwordx16 s[16:31], s[38:39], 0x40
; GFX9-HSA-NEXT:    s_load_dwordx16 s[0:15], s[38:39], 0x0
; GFX9-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s28
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s29
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s30
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s31
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[36:37] offset:112
; GFX9-HSA-NEXT:    v_mov_b32_e32 v4, s24
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s20
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s21
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s22
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s23
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[36:37] offset:80
; GFX9-HSA-NEXT:    v_mov_b32_e32 v5, s25
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[36:37] offset:64
; GFX9-HSA-NEXT:    v_mov_b32_e32 v6, s26
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s12
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s13
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s14
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s15
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[36:37] offset:48
; GFX9-HSA-NEXT:    v_mov_b32_e32 v7, s27
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s11
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[36:37] offset:32
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[4:7], s[36:37] offset:96
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[36:37] offset:16
; GFX9-HSA-NEXT:    s_nop 0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-HSA-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-HSA-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-HSA-NEXT:    global_store_dwordx4 v8, v[0:3], s[36:37]
; GFX9-HSA-NEXT:    s_endpgm
;
; GFX12-LABEL: constant_load_v32i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_load_b128 s[36:39], s[0:1], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b512 s[16:31], s[38:39], 0x40
; GFX12-NEXT:    s_load_b512 s[0:15], s[38:39], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v32, 0 :: v_dual_mov_b32 v1, s29
; GFX12-NEXT:    v_dual_mov_b32 v0, s28 :: v_dual_mov_b32 v3, s31
; GFX12-NEXT:    v_dual_mov_b32 v2, s30 :: v_dual_mov_b32 v5, s25
; GFX12-NEXT:    v_dual_mov_b32 v4, s24 :: v_dual_mov_b32 v7, s27
; GFX12-NEXT:    v_dual_mov_b32 v6, s26 :: v_dual_mov_b32 v9, s21
; GFX12-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX12-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s17
; GFX12-NEXT:    v_dual_mov_b32 v12, s16 :: v_dual_mov_b32 v15, s19
; GFX12-NEXT:    v_dual_mov_b32 v14, s18 :: v_dual_mov_b32 v17, s13
; GFX12-NEXT:    v_dual_mov_b32 v16, s12 :: v_dual_mov_b32 v19, s15
; GFX12-NEXT:    v_dual_mov_b32 v18, s14 :: v_dual_mov_b32 v21, s9
; GFX12-NEXT:    v_dual_mov_b32 v20, s8 :: v_dual_mov_b32 v23, s11
; GFX12-NEXT:    v_dual_mov_b32 v22, s10 :: v_dual_mov_b32 v25, s5
; GFX12-NEXT:    v_dual_mov_b32 v24, s4 :: v_dual_mov_b32 v27, s7
; GFX12-NEXT:    v_dual_mov_b32 v26, s6 :: v_dual_mov_b32 v29, s1
; GFX12-NEXT:    v_dual_mov_b32 v28, s0 :: v_dual_mov_b32 v31, s3
; GFX12-NEXT:    v_mov_b32_e32 v30, s2
; GFX12-NEXT:    s_clause 0x7
; GFX12-NEXT:    global_store_b128 v32, v[0:3], s[36:37] offset:112
; GFX12-NEXT:    global_store_b128 v32, v[4:7], s[36:37] offset:96
; GFX12-NEXT:    global_store_b128 v32, v[8:11], s[36:37] offset:80
; GFX12-NEXT:    global_store_b128 v32, v[12:15], s[36:37] offset:64
; GFX12-NEXT:    global_store_b128 v32, v[16:19], s[36:37] offset:48
; GFX12-NEXT:    global_store_b128 v32, v[20:23], s[36:37] offset:32
; GFX12-NEXT:    global_store_b128 v32, v[24:27], s[36:37] offset:16
; GFX12-NEXT:    global_store_b128 v32, v[28:31], s[36:37]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %ld = load <32 x i32>, ptr addrspace(4) %in
  store <32 x i32> %ld, ptr addrspace(1) %out
  ret void
}

attributes #0 = { nounwind }
