; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -verify-machineinstrs < %s | FileCheck -check-prefixes=GLOBAL-ISEL %s

define amdgpu_kernel void @test1_s_barrier_signal(ptr addrspace(1) %out) #0 {
; GCN-LABEL: test1_s_barrier_signal:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v1, v0, v0
; GCN-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v3, v2, s[0:1]
; GCN-NEXT:    s_barrier_signal -1
; GCN-NEXT:    s_barrier_wait -1
; GCN-NEXT:    global_store_b32 v3, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test1_s_barrier_signal:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_barrier_signal -1
; GLOBAL-ISEL-NEXT:    s_barrier_wait -1
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.barrier.signal(i32 -1)
  call void @llvm.amdgcn.s.barrier.wait(i16 -1)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test2_s_barrier_signal(ptr addrspace(1) %out) #0 {
; GCN-LABEL: test2_s_barrier_signal:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v1, v0, v0
; GCN-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v3, v2, s[0:1]
; GCN-NEXT:    s_barrier_signal 1
; GCN-NEXT:    s_barrier_wait 1
; GCN-NEXT:    global_store_b32 v3, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test2_s_barrier_signal:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_barrier_signal 1
; GLOBAL-ISEL-NEXT:    s_barrier_wait 1
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.barrier.signal(i32 1)
  call void @llvm.amdgcn.s.barrier.wait(i16 1)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test3_s_barrier_signal(ptr addrspace(1) %out) #0 {
; GCN-LABEL: test3_s_barrier_signal:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v1, v0, v0
; GCN-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v3, v2, s[0:1]
; GCN-NEXT:    s_barrier_signal 0
; GCN-NEXT:    s_barrier_wait 0
; GCN-NEXT:    global_store_b32 v3, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test3_s_barrier_signal:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_barrier_signal 0
; GLOBAL-ISEL-NEXT:    s_barrier_wait 0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.barrier.signal(i32 0)
  call void @llvm.amdgcn.s.barrier.wait(i16 0)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test1_s_barrier_signal_var(ptr addrspace(1) %out) #0 {
; GCN-LABEL: test1_s_barrier_signal_var:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v2, v0, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v3, 2, v0
; GCN-NEXT:    s_mov_b32 m0, 1
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v2, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v3, v1, s[0:1]
; GCN-NEXT:    s_barrier_signal m0
; GCN-NEXT:    s_barrier_wait 1
; GCN-NEXT:    global_store_b32 v3, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test1_s_barrier_signal_var:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_mov_b32 m0, 1
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_barrier_signal m0
; GLOBAL-ISEL-NEXT:    s_barrier_wait 1
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.barrier.signal.var(i32 1)
  call void @llvm.amdgcn.s.barrier.wait(i16 1)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define void @test2_s_barrier_signal_var(i32 %arg) {
; GCN-LABEL: test2_s_barrier_signal_var:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_wait_loadcnt_dscnt 0x0
; GCN-NEXT:    s_wait_expcnt 0x0
; GCN-NEXT:    s_wait_samplecnt 0x0
; GCN-NEXT:    s_wait_bvhcnt 0x0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    v_readfirstlane_b32 s0, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GCN-NEXT:    s_mov_b32 m0, s0
; GCN-NEXT:    s_barrier_signal m0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GLOBAL-ISEL-LABEL: test2_s_barrier_signal_var:
; GLOBAL-ISEL:       ; %bb.0:
; GLOBAL-ISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_expcnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_samplecnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_bvhcnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    v_readfirstlane_b32 m0, v0
; GLOBAL-ISEL-NEXT:    s_barrier_signal m0
; GLOBAL-ISEL-NEXT:    s_setpc_b64 s[30:31]
  call void @llvm.amdgcn.s.barrier.signal.var(i32 %arg)
  ret void
}

define amdgpu_kernel void @test1_s_barrier_signal_isfirst(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %out) #0 {
; GCN-LABEL: test1_s_barrier_signal_isfirst:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GCN-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v0, v1, s[6:7]
; GCN-NEXT:    s_barrier_signal_isfirst -1
; GCN-NEXT:    s_cselect_b32 s3, s3, s5
; GCN-NEXT:    s_cselect_b32 s2, s2, s4
; GCN-NEXT:    s_clause 0x1
; GCN-NEXT:    global_load_b32 v2, v1, s[0:1]
; GCN-NEXT:    global_load_b32 v1, v1, s[2:3]
; GCN-NEXT:    s_wait_loadcnt 0x0
; GCN-NEXT:    v_mul_lo_u32 v1, v1, v2
; GCN-NEXT:    global_store_b32 v0, v1, s[6:7]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test1_s_barrier_signal_isfirst:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[6:7]
; GLOBAL-ISEL-NEXT:    s_barrier_signal_isfirst -1
; GLOBAL-ISEL-NEXT:    s_cselect_b32 s8, 1, 0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GLOBAL-ISEL-NEXT:    s_and_b32 s8, s8, 1
; GLOBAL-ISEL-NEXT:    s_cmp_lg_u32 s8, 0
; GLOBAL-ISEL-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[4:5]
; GLOBAL-ISEL-NEXT:    s_clause 0x1
; GLOBAL-ISEL-NEXT:    global_load_b32 v2, v1, s[0:1]
; GLOBAL-ISEL-NEXT:    global_load_b32 v1, v1, s[2:3]
; GLOBAL-ISEL-NEXT:    s_wait_loadcnt 0x0
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v1, v2
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[6:7]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  %isfirst = call i1 @llvm.amdgcn.s.barrier.signal.isfirst(i32 -1)
  %0 = load i32, ptr addrspace(1) %a, align 4
  %b.c = select i1 %isfirst, ptr addrspace(1) %b, ptr addrspace(1) %c
  %1 = load i32, ptr addrspace(1) %b.c, align 4
  %mul1 = mul nsw i32 %1, %0
  store i32 %mul1, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test2_s_barrier_signal_isfirst(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %out) #0 {
; GCN-LABEL: test2_s_barrier_signal_isfirst:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GCN-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v0, v1, s[6:7]
; GCN-NEXT:    s_barrier_signal_isfirst 1
; GCN-NEXT:    s_cselect_b32 s3, s3, s5
; GCN-NEXT:    s_cselect_b32 s2, s2, s4
; GCN-NEXT:    s_clause 0x1
; GCN-NEXT:    global_load_b32 v2, v1, s[0:1]
; GCN-NEXT:    global_load_b32 v1, v1, s[2:3]
; GCN-NEXT:    s_wait_loadcnt 0x0
; GCN-NEXT:    v_mul_lo_u32 v1, v1, v2
; GCN-NEXT:    global_store_b32 v0, v1, s[6:7]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test2_s_barrier_signal_isfirst:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[6:7]
; GLOBAL-ISEL-NEXT:    s_barrier_signal_isfirst 1
; GLOBAL-ISEL-NEXT:    s_cselect_b32 s8, 1, 0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GLOBAL-ISEL-NEXT:    s_and_b32 s8, s8, 1
; GLOBAL-ISEL-NEXT:    s_cmp_lg_u32 s8, 0
; GLOBAL-ISEL-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[4:5]
; GLOBAL-ISEL-NEXT:    s_clause 0x1
; GLOBAL-ISEL-NEXT:    global_load_b32 v2, v1, s[0:1]
; GLOBAL-ISEL-NEXT:    global_load_b32 v1, v1, s[2:3]
; GLOBAL-ISEL-NEXT:    s_wait_loadcnt 0x0
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v1, v2
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[6:7]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  %isfirst = call i1 @llvm.amdgcn.s.barrier.signal.isfirst(i32 1)
  %0 = load i32, ptr addrspace(1) %a, align 4
  %b.c = select i1 %isfirst, ptr addrspace(1) %b, ptr addrspace(1) %c
  %1 = load i32, ptr addrspace(1) %b.c, align 4
  %mul1 = mul nsw i32 %1, %0
  store i32 %mul1, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test3_s_barrier_signal_isfirst(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %out) #0 {
; GCN-LABEL: test3_s_barrier_signal_isfirst:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GCN-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v0, v1, s[6:7]
; GCN-NEXT:    s_barrier_signal_isfirst 1
; GCN-NEXT:    s_cselect_b32 s3, s3, s5
; GCN-NEXT:    s_cselect_b32 s2, s2, s4
; GCN-NEXT:    s_clause 0x1
; GCN-NEXT:    global_load_b32 v2, v1, s[0:1]
; GCN-NEXT:    global_load_b32 v1, v1, s[2:3]
; GCN-NEXT:    s_wait_loadcnt 0x0
; GCN-NEXT:    v_mul_lo_u32 v1, v1, v2
; GCN-NEXT:    global_store_b32 v0, v1, s[6:7]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test3_s_barrier_signal_isfirst:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[6:7]
; GLOBAL-ISEL-NEXT:    s_barrier_signal_isfirst 1
; GLOBAL-ISEL-NEXT:    s_cselect_b32 s8, 1, 0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GLOBAL-ISEL-NEXT:    s_and_b32 s8, s8, 1
; GLOBAL-ISEL-NEXT:    s_cmp_lg_u32 s8, 0
; GLOBAL-ISEL-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[4:5]
; GLOBAL-ISEL-NEXT:    s_clause 0x1
; GLOBAL-ISEL-NEXT:    global_load_b32 v2, v1, s[0:1]
; GLOBAL-ISEL-NEXT:    global_load_b32 v1, v1, s[2:3]
; GLOBAL-ISEL-NEXT:    s_wait_loadcnt 0x0
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v1, v2
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[6:7]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  %isfirst = call i1 @llvm.amdgcn.s.barrier.signal.isfirst(i32 1)
  %0 = load i32, ptr addrspace(1) %a, align 4
  %b.c = select i1 %isfirst, ptr addrspace(1) %b, ptr addrspace(1) %c
  %1 = load i32, ptr addrspace(1) %b.c, align 4
  %mul1 = mul nsw i32 %1, %0
  store i32 %mul1, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test1_s_barrier_signal_isfirst_var(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %out) #0 {
; GCN-LABEL: test1_s_barrier_signal_isfirst_var:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GCN-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GCN-NEXT:    s_mov_b32 m0, 1
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v0, v1, s[6:7]
; GCN-NEXT:    s_barrier_signal_isfirst m0
; GCN-NEXT:    s_cselect_b32 s3, s3, s5
; GCN-NEXT:    s_cselect_b32 s2, s2, s4
; GCN-NEXT:    s_clause 0x1
; GCN-NEXT:    global_load_b32 v2, v1, s[0:1]
; GCN-NEXT:    global_load_b32 v1, v1, s[2:3]
; GCN-NEXT:    s_wait_loadcnt 0x0
; GCN-NEXT:    v_mul_lo_u32 v1, v1, v2
; GCN-NEXT:    global_store_b32 v0, v1, s[6:7]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test1_s_barrier_signal_isfirst_var:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GLOBAL-ISEL-NEXT:    s_mov_b32 m0, 1
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[6:7]
; GLOBAL-ISEL-NEXT:    s_barrier_signal_isfirst m0
; GLOBAL-ISEL-NEXT:    s_cselect_b32 s8, 1, 0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GLOBAL-ISEL-NEXT:    s_and_b32 s8, s8, 1
; GLOBAL-ISEL-NEXT:    s_cmp_lg_u32 s8, 0
; GLOBAL-ISEL-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[4:5]
; GLOBAL-ISEL-NEXT:    s_clause 0x1
; GLOBAL-ISEL-NEXT:    global_load_b32 v2, v1, s[0:1]
; GLOBAL-ISEL-NEXT:    global_load_b32 v1, v1, s[2:3]
; GLOBAL-ISEL-NEXT:    s_wait_loadcnt 0x0
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v1, v2
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[6:7]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  %isfirst = call i1 @llvm.amdgcn.s.barrier.signal.isfirst.var(i32 1)
  %0 = load i32, ptr addrspace(1) %a, align 4
  %b.c = select i1 %isfirst, ptr addrspace(1) %b, ptr addrspace(1) %c
  %1 = load i32, ptr addrspace(1) %b.c, align 4
  %mul1 = mul nsw i32 %1, %0
  store i32 %mul1, ptr addrspace(1) %tmp1
  ret void
}

define void @test2_s_barrier_signal_isfirst_var(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, i32 %arg, ptr addrspace(1) %out) {
; GCN-LABEL: test2_s_barrier_signal_isfirst_var:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_wait_loadcnt_dscnt 0x0
; GCN-NEXT:    s_wait_expcnt 0x0
; GCN-NEXT:    s_wait_samplecnt 0x0
; GCN-NEXT:    s_wait_bvhcnt 0x0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    v_dual_mov_b32 v10, 0 :: v_dual_and_b32 v9, 0x3ff, v31
; GCN-NEXT:    v_readfirstlane_b32 s0, v6
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GCN-NEXT:    v_lshlrev_b32_e32 v9, 2, v9
; GCN-NEXT:    s_mov_b32 m0, s0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GCN-NEXT:    v_add_co_u32 v7, vcc_lo, v7, v9
; GCN-NEXT:    v_add_co_ci_u32_e32 v8, vcc_lo, 0, v8, vcc_lo
; GCN-NEXT:    global_store_b32 v[7:8], v10, off
; GCN-NEXT:    s_barrier_signal_isfirst m0
; GCN-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GCN-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_cndmask_b32 v3, v5, v3
; GCN-NEXT:    global_load_b32 v0, v[0:1], off
; GCN-NEXT:    global_load_b32 v1, v[2:3], off
; GCN-NEXT:    s_wait_loadcnt 0x0
; GCN-NEXT:    v_mul_lo_u32 v0, v1, v0
; GCN-NEXT:    global_store_b32 v[7:8], v0, off
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GLOBAL-ISEL-LABEL: test2_s_barrier_signal_isfirst_var:
; GLOBAL-ISEL:       ; %bb.0:
; GLOBAL-ISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_expcnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_samplecnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_bvhcnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    v_and_b32_e32 v9, 0x3ff, v31
; GLOBAL-ISEL-NEXT:    v_readfirstlane_b32 m0, v6
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GLOBAL-ISEL-NEXT:    v_lshlrev_b32_e32 v9, 2, v9
; GLOBAL-ISEL-NEXT:    v_add_co_u32 v7, vcc_lo, v7, v9
; GLOBAL-ISEL-NEXT:    v_add_co_ci_u32_e32 v8, vcc_lo, 0, v8, vcc_lo
; GLOBAL-ISEL-NEXT:    v_mov_b32_e32 v9, 0
; GLOBAL-ISEL-NEXT:    global_store_b32 v[7:8], v9, off
; GLOBAL-ISEL-NEXT:    s_barrier_signal_isfirst m0
; GLOBAL-ISEL-NEXT:    s_cselect_b32 s0, 1, 0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GLOBAL-ISEL-NEXT:    s_and_b32 s0, 1, s0
; GLOBAL-ISEL-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s0
; GLOBAL-ISEL-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_cndmask_b32 v3, v5, v3
; GLOBAL-ISEL-NEXT:    global_load_b32 v0, v[0:1], off
; GLOBAL-ISEL-NEXT:    global_load_b32 v1, v[2:3], off
; GLOBAL-ISEL-NEXT:    s_wait_loadcnt 0x0
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    global_store_b32 v[7:8], v0, off
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    s_setpc_b64 s[30:31]
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  %isfirst = call i1 @llvm.amdgcn.s.barrier.signal.isfirst.var(i32 %arg)
  %1 = load i32, ptr addrspace(1) %a, align 4
  %b.c = select i1 %isfirst, ptr addrspace(1) %b, ptr addrspace(1) %c
  %2 = load i32, ptr addrspace(1) %b.c, align 4
  %mul1 = mul nsw i32 %2, %1
  store i32 %mul1, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test1_s_barrier_init(ptr addrspace(1) %out, i32 %mbrCnt) #0 {
; GCN-LABEL: test1_s_barrier_init:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b96 s[0:2], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v1, v0, v0
; GCN-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    s_lshl_b32 s2, s2, 16
; GCN-NEXT:    global_store_b32 v3, v2, s[0:1]
; GCN-NEXT:    s_mov_b32 m0, s2
; GCN-NEXT:    s_barrier_init -1
; GCN-NEXT:    global_store_b32 v3, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test1_s_barrier_init:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b96 s[0:2], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    s_lshl_b32 m0, 16, s2
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_barrier_init -1
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.barrier.init(i32 -1, i32 %mbrCnt)
  %tmp2 = mul i32 %tmp, %tmp
  %tmp3 = sub i32 %tmp2, %tmp
  store i32 %tmp3, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test2_s_barrier_init(ptr addrspace(1) %out, i32 %mbrCnt) #0 {
; GCN-LABEL: test2_s_barrier_init:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b96 s[0:2], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v1, v0, v0
; GCN-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    s_lshl_b32 s2, s2, 16
; GCN-NEXT:    global_store_b32 v3, v2, s[0:1]
; GCN-NEXT:    s_mov_b32 m0, s2
; GCN-NEXT:    s_barrier_init 1
; GCN-NEXT:    global_store_b32 v3, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test2_s_barrier_init:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b96 s[0:2], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    s_lshl_b32 m0, 16, s2
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_barrier_init 1
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.barrier.init(i32 1, i32 %mbrCnt)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test3_s_barrier_init(ptr addrspace(1) %out, i32 %mbrCnt) #0 {
; GCN-LABEL: test3_s_barrier_init:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b96 s[0:2], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v1, v0, v0
; GCN-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    s_lshl_b32 s2, s2, 16
; GCN-NEXT:    global_store_b32 v3, v2, s[0:1]
; GCN-NEXT:    s_mov_b32 m0, s2
; GCN-NEXT:    s_barrier_init 0
; GCN-NEXT:    global_store_b32 v3, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test3_s_barrier_init:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b96 s[0:2], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    s_lshl_b32 m0, 16, s2
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_barrier_init 0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.barrier.init(i32 0, i32 %mbrCnt)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test4_s_barrier_init(ptr addrspace(1) %out, i32 %bar, i32 %mbrCnt) #0 {
; GCN-LABEL: test4_s_barrier_init:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v1, v0, v0
; GCN-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    s_lshl_b32 s3, s3, 16
; GCN-NEXT:    global_store_b32 v3, v2, s[0:1]
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_mov_b32 m0, s2
; GCN-NEXT:    s_barrier_init m0
; GCN-NEXT:    global_store_b32 v3, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test4_s_barrier_init:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    s_lshl_b32 s3, 16, s3
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_or_b32 m0, s2, s3
; GLOBAL-ISEL-NEXT:    s_barrier_init m0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.barrier.init(i32 %bar, i32 %mbrCnt)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define void @test5_s_barrier_init_m0(i32 %arg1 ,i32 %arg2) {
; GCN-LABEL: test5_s_barrier_init_m0:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_wait_loadcnt_dscnt 0x0
; GCN-NEXT:    s_wait_expcnt 0x0
; GCN-NEXT:    s_wait_samplecnt 0x0
; GCN-NEXT:    s_wait_bvhcnt 0x0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GCN-NEXT:    v_or_b32_e32 v0, v0, v1
; GCN-NEXT:    v_readfirstlane_b32 s0, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GCN-NEXT:    s_mov_b32 m0, s0
; GCN-NEXT:    s_barrier_init m0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GLOBAL-ISEL-LABEL: test5_s_barrier_init_m0:
; GLOBAL-ISEL:       ; %bb.0:
; GLOBAL-ISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_expcnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_samplecnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_bvhcnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    v_readfirstlane_b32 s0, v1
; GLOBAL-ISEL-NEXT:    v_readfirstlane_b32 s1, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    s_lshl_b32 s0, 16, s0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GLOBAL-ISEL-NEXT:    s_or_b32 m0, s1, s0
; GLOBAL-ISEL-NEXT:    s_barrier_init m0
; GLOBAL-ISEL-NEXT:    s_setpc_b64 s[30:31]
  call void @llvm.amdgcn.s.barrier.init(i32 %arg1, i32 %arg2)
  ret void
}

define amdgpu_kernel void @test1_s_barrier_join(ptr addrspace(1) %out) #0 {
; GCN-LABEL: test1_s_barrier_join:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v1, v0, v0
; GCN-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GCN-NEXT:    s_barrier_join -1
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v2, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test1_s_barrier_join:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_barrier_join -1
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.barrier.join(i32 -1)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test2_s_barrier_join(ptr addrspace(1) %out) #0 {
; GCN-LABEL: test2_s_barrier_join:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v1, v0, v0
; GCN-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GCN-NEXT:    s_barrier_join 1
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v2, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test2_s_barrier_join:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_barrier_join 1
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.barrier.join(i32 1)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test3_s_barrier_join(ptr addrspace(1) %out) #0 {
; GCN-LABEL: test3_s_barrier_join:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v1, v0, v0
; GCN-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GCN-NEXT:    s_barrier_join 0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v2, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test3_s_barrier_join:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_barrier_join 0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.barrier.join(i32 0)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test4_s_barrier_join_m0(ptr addrspace(1) %out, i32 %bar) #0 {
; GCN-LABEL: test4_s_barrier_join_m0:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b96 s[0:2], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v2, v0, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v3, 2, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v2, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    s_mov_b32 m0, s2
; GCN-NEXT:    global_store_b32 v3, v1, s[0:1]
; GCN-NEXT:    s_barrier_join m0
; GCN-NEXT:    global_store_b32 v3, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test4_s_barrier_join_m0:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b96 s[0:2], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    s_mov_b32 m0, s2
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_barrier_join m0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.barrier.join(i32 %bar)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define void @test5_s_barrier_join_m0(i32 %arg) {
; GCN-LABEL: test5_s_barrier_join_m0:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_wait_loadcnt_dscnt 0x0
; GCN-NEXT:    s_wait_expcnt 0x0
; GCN-NEXT:    s_wait_samplecnt 0x0
; GCN-NEXT:    s_wait_bvhcnt 0x0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    v_readfirstlane_b32 s0, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GCN-NEXT:    s_mov_b32 m0, s0
; GCN-NEXT:    s_barrier_join m0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GLOBAL-ISEL-LABEL: test5_s_barrier_join_m0:
; GLOBAL-ISEL:       ; %bb.0:
; GLOBAL-ISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_expcnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_samplecnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_bvhcnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    v_readfirstlane_b32 m0, v0
; GLOBAL-ISEL-NEXT:    s_barrier_join m0
; GLOBAL-ISEL-NEXT:    s_setpc_b64 s[30:31]
  call void @llvm.amdgcn.s.barrier.join(i32 %arg)
  ret void
}

define amdgpu_kernel void @test1_s_barrier_leave(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %out) #0 {
; GCN-LABEL: test1_s_barrier_leave:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GCN-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v0, v1, s[6:7]
; GCN-NEXT:    s_barrier_leave
; GCN-NEXT:    s_cselect_b32 s3, s3, s5
; GCN-NEXT:    s_cselect_b32 s2, s2, s4
; GCN-NEXT:    s_clause 0x1
; GCN-NEXT:    global_load_b32 v2, v1, s[0:1]
; GCN-NEXT:    global_load_b32 v1, v1, s[2:3]
; GCN-NEXT:    s_wait_loadcnt 0x0
; GCN-NEXT:    v_mul_lo_u32 v1, v1, v2
; GCN-NEXT:    global_store_b32 v0, v1, s[6:7]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test1_s_barrier_leave:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[6:7]
; GLOBAL-ISEL-NEXT:    s_barrier_leave
; GLOBAL-ISEL-NEXT:    s_cselect_b32 s8, 1, 0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GLOBAL-ISEL-NEXT:    s_and_b32 s8, s8, 1
; GLOBAL-ISEL-NEXT:    s_cmp_lg_u32 s8, 0
; GLOBAL-ISEL-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[4:5]
; GLOBAL-ISEL-NEXT:    s_clause 0x1
; GLOBAL-ISEL-NEXT:    global_load_b32 v2, v1, s[0:1]
; GLOBAL-ISEL-NEXT:    global_load_b32 v1, v1, s[2:3]
; GLOBAL-ISEL-NEXT:    s_wait_loadcnt 0x0
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v1, v2
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[6:7]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  %0 = call i1 @llvm.amdgcn.s.barrier.leave()
  %1 = load i32, ptr addrspace(1) %a, align 4
  %b.c = select i1 %0, ptr addrspace(1) %b, ptr addrspace(1) %c
  %2 = load i32, ptr addrspace(1) %b.c, align 4
  %mul1 = mul nsw i32 %2, %1
  store i32 %mul1, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test1_s_wakeup_barrier(ptr addrspace(1) %out) #0 {
; GCN-LABEL: test1_s_wakeup_barrier:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v1, v0, v0
; GCN-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GCN-NEXT:    s_wakeup_barrier -1
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v2, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test1_s_wakeup_barrier:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_wakeup_barrier -1
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.wakeup.barrier(i32 -1)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test2_s_wakeup_barrier(ptr addrspace(1) %out) #0 {
; GCN-LABEL: test2_s_wakeup_barrier:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v1, v0, v0
; GCN-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GCN-NEXT:    s_wakeup_barrier 1
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v2, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test2_s_wakeup_barrier:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_wakeup_barrier 1
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.wakeup.barrier(i32 1)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test3_s_wakeup_barrier(ptr addrspace(1) %out) #0 {
; GCN-LABEL: test3_s_wakeup_barrier:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v1, v0, v0
; GCN-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GCN-NEXT:    s_wakeup_barrier 0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v2, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test3_s_wakeup_barrier:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_wakeup_barrier 0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.wakeup.barrier(i32 0)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test4_s_wakeup_barrier_m0(ptr addrspace(1) %out, i32 %bar) #0 {
; GCN-LABEL: test4_s_wakeup_barrier_m0:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b96 s[0:2], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v2, v0, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v3, 2, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v2, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    s_mov_b32 m0, s2
; GCN-NEXT:    global_store_b32 v3, v1, s[0:1]
; GCN-NEXT:    s_wakeup_barrier m0
; GCN-NEXT:    global_store_b32 v3, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test4_s_wakeup_barrier_m0:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b96 s[0:2], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    s_mov_b32 m0, s2
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_wakeup_barrier m0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.wakeup.barrier(i32 %bar)
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}

define void @test5_s_wakeup_barrier_m0(i32 %arg) {
; GCN-LABEL: test5_s_wakeup_barrier_m0:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_wait_loadcnt_dscnt 0x0
; GCN-NEXT:    s_wait_expcnt 0x0
; GCN-NEXT:    s_wait_samplecnt 0x0
; GCN-NEXT:    s_wait_bvhcnt 0x0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    v_readfirstlane_b32 s0, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GCN-NEXT:    s_mov_b32 m0, s0
; GCN-NEXT:    s_wakeup_barrier m0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GLOBAL-ISEL-LABEL: test5_s_wakeup_barrier_m0:
; GLOBAL-ISEL:       ; %bb.0:
; GLOBAL-ISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_expcnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_samplecnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_bvhcnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    v_readfirstlane_b32 m0, v0
; GLOBAL-ISEL-NEXT:    s_wakeup_barrier m0
; GLOBAL-ISEL-NEXT:    s_setpc_b64 s[30:31]
  call void @llvm.amdgcn.s.wakeup.barrier(i32 %arg)
  ret void
}

define amdgpu_kernel void @test1_s_get_barrier_state(ptr addrspace(1) %out) #0 {
; GCN-LABEL: test1_s_get_barrier_state:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_get_barrier_state s2, -1
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GCN-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_lshlrev_b32 v0, 2, v0
; GCN-NEXT:    global_store_b32 v0, v1, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test1_s_get_barrier_state:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GLOBAL-ISEL-NEXT:    s_get_barrier_state s2, -1
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_2)
; GLOBAL-ISEL-NEXT:    v_mov_b32_e32 v1, s2
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  %state = call i32 @llvm.amdgcn.s.get.barrier.state(i32 -1)
  store i32 %state, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test2_s_get_barrier_state(ptr addrspace(1) %out) #0 {
; GCN-LABEL: test2_s_get_barrier_state:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_get_barrier_state s2, 1
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GCN-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_lshlrev_b32 v0, 2, v0
; GCN-NEXT:    global_store_b32 v0, v1, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test2_s_get_barrier_state:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GLOBAL-ISEL-NEXT:    s_get_barrier_state s2, 1
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_2)
; GLOBAL-ISEL-NEXT:    v_mov_b32_e32 v1, s2
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  %state = call i32 @llvm.amdgcn.s.get.barrier.state(i32 1)
  store i32 %state, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test3_s_get_barrier_state(ptr addrspace(1) %out) #0 {
; GCN-LABEL: test3_s_get_barrier_state:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_get_barrier_state s2, 0
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GCN-NEXT:    v_dual_mov_b32 v1, s2 :: v_dual_lshlrev_b32 v0, 2, v0
; GCN-NEXT:    global_store_b32 v0, v1, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test3_s_get_barrier_state:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GLOBAL-ISEL-NEXT:    s_get_barrier_state s2, 0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_2)
; GLOBAL-ISEL-NEXT:    v_mov_b32_e32 v1, s2
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  %state = call i32 @llvm.amdgcn.s.get.barrier.state(i32 0)
  store i32 %state, ptr addrspace(1) %tmp1
  ret void
}

define amdgpu_kernel void @test4_s_get_barrier_state_m0(ptr addrspace(1) %out, i32 %bar) #0 {
; GCN-LABEL: test4_s_get_barrier_state_m0:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b96 s[0:2], s[0:1], 0x24
; GCN-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    s_mov_b32 m0, s2
; GCN-NEXT:    global_store_b32 v0, v1, s[0:1]
; GCN-NEXT:    s_get_barrier_state s2, m0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    s_delay_alu instid0(SALU_CYCLE_2)
; GCN-NEXT:    v_mov_b32_e32 v1, s2
; GCN-NEXT:    global_store_b32 v0, v1, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test4_s_get_barrier_state_m0:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b96 s[0:2], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    s_mov_b32 m0, s2
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GLOBAL-ISEL-NEXT:    s_get_barrier_state s2, m0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_2)
; GLOBAL-ISEL-NEXT:    v_mov_b32_e32 v1, s2
; GLOBAL-ISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  %state = call i32 @llvm.amdgcn.s.get.barrier.state(i32 %bar)
  store i32 %state, ptr addrspace(1) %tmp1
  ret void
}

define i32 @test5_s_get_barrier_state_m0(i32 %arg) {
; GCN-LABEL: test5_s_get_barrier_state_m0:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_wait_loadcnt_dscnt 0x0
; GCN-NEXT:    s_wait_expcnt 0x0
; GCN-NEXT:    s_wait_samplecnt 0x0
; GCN-NEXT:    s_wait_bvhcnt 0x0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    v_readfirstlane_b32 s0, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(SALU_CYCLE_2)
; GCN-NEXT:    s_mov_b32 m0, s0
; GCN-NEXT:    s_get_barrier_state s0, m0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GLOBAL-ISEL-LABEL: test5_s_get_barrier_state_m0:
; GLOBAL-ISEL:       ; %bb.0:
; GLOBAL-ISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_expcnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_samplecnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_bvhcnt 0x0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    v_readfirstlane_b32 m0, v0
; GLOBAL-ISEL-NEXT:    s_get_barrier_state s0, m0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_2)
; GLOBAL-ISEL-NEXT:    v_mov_b32_e32 v0, s0
; GLOBAL-ISEL-NEXT:    s_setpc_b64 s[30:31]
  %state = call i32 @llvm.amdgcn.s.get.barrier.state(i32 %arg)
  ret i32 %state
}

define amdgpu_kernel void @test_barrier_convert(ptr addrspace(1) %out) #0 {
; GCN-LABEL: test_barrier_convert:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GCN-NEXT:    v_mul_u32_u24_e32 v1, v0, v0
; GCN-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GCN-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GCN-NEXT:    s_wait_kmcnt 0x0
; GCN-NEXT:    global_store_b32 v3, v2, s[0:1]
; GCN-NEXT:    s_barrier_signal -1
; GCN-NEXT:    s_barrier_wait -1
; GCN-NEXT:    global_store_b32 v3, v0, s[0:1]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GCN-NEXT:    s_endpgm
;
; GLOBAL-ISEL-LABEL: test_barrier_convert:
; GLOBAL-ISEL:       ; %bb.0: ; %entry
; GLOBAL-ISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GLOBAL-ISEL-NEXT:    v_mul_lo_u32 v1, v0, v0
; GLOBAL-ISEL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v3, 2, v0
; GLOBAL-ISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GLOBAL-ISEL-NEXT:    v_sub_nc_u32_e32 v0, v1, v0
; GLOBAL-ISEL-NEXT:    s_wait_kmcnt 0x0
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v2, s[0:1]
; GLOBAL-ISEL-NEXT:    s_barrier_signal -1
; GLOBAL-ISEL-NEXT:    s_barrier_wait -1
; GLOBAL-ISEL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GLOBAL-ISEL-NEXT:    s_nop 0
; GLOBAL-ISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GLOBAL-ISEL-NEXT:    s_endpgm
entry:
  %tmp = call i32 @llvm.amdgcn.workitem.id.x()
  %tmp1 = getelementptr i32, ptr addrspace(1) %out, i32 %tmp
  store i32 0, ptr addrspace(1) %tmp1
  call void @llvm.amdgcn.s.barrier()
  %tmp3 = mul i32 %tmp, %tmp
  %tmp4 = sub i32 %tmp3, %tmp
  store i32 %tmp4, ptr addrspace(1) %tmp1
  ret void
}
declare void @llvm.amdgcn.s.barrier() #1
declare void @llvm.amdgcn.s.barrier.wait(i16) #1
declare void @llvm.amdgcn.s.barrier.signal(i32) #1
declare void @llvm.amdgcn.s.barrier.signal.var(i32) #1
declare i1 @llvm.amdgcn.s.barrier.signal.isfirst(i32) #1
declare i1 @llvm.amdgcn.s.barrier.signal.isfirst.var(i32) #1
declare void @llvm.amdgcn.s.barrier.init(i32, i32) #1
declare void @llvm.amdgcn.s.barrier.join(i32) #1
declare i1 @llvm.amdgcn.s.barrier.leave() #1
declare void @llvm.amdgcn.s.wakeup.barrier(i32) #1
declare i32 @llvm.amdgcn.s.get.barrier.state(i32) #1
declare i32 @llvm.amdgcn.s.get.barrier.state.var(i32) #1
declare i32 @llvm.amdgcn.workitem.id.x() #2

attributes #0 = { nounwind }
attributes #1 = { convergent nounwind }
attributes #2 = { nounwind readnone }
