; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=jump-threading -S < %s | FileCheck %s

declare void @f()
declare void @f2()
declare void @f3()

; br on cond.fr should be removed & ENTRY -> A -> B should be threaded
define i32 @simple(i1 %cond) {
; CHECK-LABEL: @simple(
; CHECK-NEXT:  ENTRY:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[B:%.*]], label [[EXIT:%.*]]
; CHECK:       B:
; CHECK-NEXT:    call void @f()
; CHECK-NEXT:    ret i32 1
; CHECK:       EXIT:
; CHECK-NEXT:    ret i32 0
;
ENTRY:
  %cond.fr = freeze i1 %cond
  br i1 %cond, label %A, label %EXIT
A:
  br i1 %cond.fr, label %B, label %EXIT
B:
  call void @f()
  ret i32 1
EXIT:
  ret i32 0
}

define void @switch(i32 %cond) {
; CHECK-LABEL: @switch(
; CHECK-NEXT:  ENTRY:
; CHECK-NEXT:    [[COND_FR:%.*]] = freeze i32 [[COND:%.*]]
; CHECK-NEXT:    switch i32 [[COND]], label [[DEFAULT:%.*]] [
; CHECK-NEXT:    i32 0, label [[A_TAKEN:%.*]]
; CHECK-NEXT:    i32 1, label [[B_TAKEN:%.*]]
; CHECK-NEXT:    ]
; CHECK:       DEFAULT:
; CHECK-NEXT:    switch i32 [[COND_FR]], label [[PRESERVED1:%.*]] [
; CHECK-NEXT:    i32 0, label [[PRESERVED2:%.*]]
; CHECK-NEXT:    ]
; CHECK:       PRESERVED1:
; CHECK-NEXT:    call void @f()
; CHECK-NEXT:    ret void
; CHECK:       PRESERVED2:
; CHECK-NEXT:    call void @f2()
; CHECK-NEXT:    ret void
; CHECK:       A_TAKEN:
; CHECK-NEXT:    call void @f()
; CHECK-NEXT:    ret void
; CHECK:       B_TAKEN:
; CHECK-NEXT:    call void @f()
; CHECK-NEXT:    ret void
;
ENTRY:
  %cond.fr = freeze i32 %cond
  switch i32 %cond, label %DEFAULT [
  i32 0, label %A
  i32 1, label %B
  ]
DEFAULT:
  switch i32 %cond.fr, label %PRESERVED1 [
  i32 0, label %PRESERVED2
  ]
PRESERVED1:
  call void @f()
  ret void
PRESERVED2:
  call void @f2()
  ret void

A:
  switch i32 %cond.fr, label %A_NOTTAKEN [
  i32 0, label %A_TAKEN
  ]
A_TAKEN:
  call void @f()
  ret void
A_NOTTAKEN:
  call void @f2()
  ret void

B:
  switch i32 %cond.fr, label %B_TAKEN [
  i32 0, label %B_NOTTAKEN
  ]
B_TAKEN:
  call void @f()
  ret void
B_NOTTAKEN:
  call void @f2()
  ret void
}
