; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mattr=+sse2      -mtriple=i686-apple-darwin -mcpu=core2 | FileCheck %s -check-prefix=SSE2-Darwin
; RUN: llc < %s -mattr=+sse2      -mtriple=i686-pc-mingw32 -mcpu=core2 | FileCheck %s -check-prefix=SSE2-Mingw32
; RUN: llc < %s -mattr=+sse,-sse2 -mtriple=i686-apple-darwin -mcpu=core2 | FileCheck %s -check-prefix=SSE1
; RUN: llc < %s -mattr=-sse       -mtriple=i686-apple-darwin -mcpu=core2 | FileCheck %s -check-prefix=NOSSE
; RUN: llc < %s                 -mtriple=x86_64-apple-darwin -mcpu=core2 | FileCheck %s -check-prefix=X86-64
; RUN: llc < %s                 -mtriple=x86_64-apple-darwin -mcpu=nehalem | FileCheck %s -check-prefix=NHM_64

@.str = internal constant [25 x i8] c"image\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00"
@.str2 = internal constant [30 x i8] c"xxxxxxxxxxxxxxxxxxxxxxxxxxxxx\00", align 4

define void @t1(i32 %argc, ptr %argv) nounwind  {
; SSE2-Darwin-LABEL: t1:
; SSE2-Darwin:       ## %bb.0: ## %entry
; SSE2-Darwin-NEXT:    subl $28, %esp
; SSE2-Darwin-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE2-Darwin-NEXT:    movsd %xmm0, {{[0-9]+}}(%esp)
; SSE2-Darwin-NEXT:    movaps _.str, %xmm0
; SSE2-Darwin-NEXT:    movaps %xmm0, (%esp)
; SSE2-Darwin-NEXT:    movb $0, {{[0-9]+}}(%esp)
; SSE2-Darwin-NEXT:    ud2
;
; SSE2-Mingw32-LABEL: t1:
; SSE2-Mingw32:       # %bb.0: # %entry
; SSE2-Mingw32-NEXT:    subl $28, %esp
; SSE2-Mingw32-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE2-Mingw32-NEXT:    movsd %xmm0, {{[0-9]+}}(%esp)
; SSE2-Mingw32-NEXT:    movaps _.str, %xmm0
; SSE2-Mingw32-NEXT:    movups %xmm0, (%esp)
; SSE2-Mingw32-NEXT:    movb $0, {{[0-9]+}}(%esp)
;
; SSE1-LABEL: t1:
; SSE1:       ## %bb.0: ## %entry
; SSE1-NEXT:    subl $28, %esp
; SSE1-NEXT:    movaps _.str, %xmm0
; SSE1-NEXT:    movaps %xmm0, (%esp)
; SSE1-NEXT:    movb $0, {{[0-9]+}}(%esp)
; SSE1-NEXT:    movl $0, {{[0-9]+}}(%esp)
; SSE1-NEXT:    movl $0, {{[0-9]+}}(%esp)
; SSE1-NEXT:    ud2
;
; NOSSE-LABEL: t1:
; NOSSE:       ## %bb.0: ## %entry
; NOSSE-NEXT:    subl $28, %esp
; NOSSE-NEXT:    movb $0, {{[0-9]+}}(%esp)
; NOSSE-NEXT:    movl $0, {{[0-9]+}}(%esp)
; NOSSE-NEXT:    movl $0, {{[0-9]+}}(%esp)
; NOSSE-NEXT:    movl $0, {{[0-9]+}}(%esp)
; NOSSE-NEXT:    movl $0, {{[0-9]+}}(%esp)
; NOSSE-NEXT:    movl $101, {{[0-9]+}}(%esp)
; NOSSE-NEXT:    movl $1734438249, (%esp) ## imm = 0x67616D69
; NOSSE-NEXT:    ud2
;
; X86-64-LABEL: t1:
; X86-64:       ## %bb.0: ## %entry
; X86-64-NEXT:    movaps _.str(%rip), %xmm0
; X86-64-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; X86-64-NEXT:    movb $0, -{{[0-9]+}}(%rsp)
; X86-64-NEXT:    movq $0, -{{[0-9]+}}(%rsp)
; X86-64-NEXT:    ud2
;
; NHM_64-LABEL: t1:
; NHM_64:       ## %bb.0: ## %entry
; NHM_64-NEXT:    movups _.str+9(%rip), %xmm0
; NHM_64-NEXT:    movups %xmm0, -{{[0-9]+}}(%rsp)
; NHM_64-NEXT:    movaps _.str(%rip), %xmm0
; NHM_64-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; NHM_64-NEXT:    ud2
entry:
  %tmp1 = alloca [25 x i8]
  call void @llvm.memcpy.p0.p0.i32(ptr align 1 %tmp1, ptr align 1 @.str, i32 25, i1 false)
  unreachable
}

;rdar://7774704
%struct.s0 = type { [2 x double] }

define void @t2(ptr nocapture %a, ptr nocapture %b) nounwind ssp {
; SSE2-Darwin-LABEL: t2:
; SSE2-Darwin:       ## %bb.0: ## %entry
; SSE2-Darwin-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2-Darwin-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SSE2-Darwin-NEXT:    movaps (%ecx), %xmm0
; SSE2-Darwin-NEXT:    movaps %xmm0, (%eax)
; SSE2-Darwin-NEXT:    retl
;
; SSE2-Mingw32-LABEL: t2:
; SSE2-Mingw32:       # %bb.0: # %entry
; SSE2-Mingw32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2-Mingw32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SSE2-Mingw32-NEXT:    movaps (%ecx), %xmm0
; SSE2-Mingw32-NEXT:    movaps %xmm0, (%eax)
; SSE2-Mingw32-NEXT:    retl
;
; SSE1-LABEL: t2:
; SSE1:       ## %bb.0: ## %entry
; SSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE1-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SSE1-NEXT:    movaps (%ecx), %xmm0
; SSE1-NEXT:    movaps %xmm0, (%eax)
; SSE1-NEXT:    retl
;
; NOSSE-LABEL: t2:
; NOSSE:       ## %bb.0: ## %entry
; NOSSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; NOSSE-NEXT:    movl 12(%ecx), %edx
; NOSSE-NEXT:    movl %edx, 12(%eax)
; NOSSE-NEXT:    movl 8(%ecx), %edx
; NOSSE-NEXT:    movl %edx, 8(%eax)
; NOSSE-NEXT:    movl (%ecx), %edx
; NOSSE-NEXT:    movl 4(%ecx), %ecx
; NOSSE-NEXT:    movl %ecx, 4(%eax)
; NOSSE-NEXT:    movl %edx, (%eax)
; NOSSE-NEXT:    retl
;
; X86-64-LABEL: t2:
; X86-64:       ## %bb.0: ## %entry
; X86-64-NEXT:    movaps (%rsi), %xmm0
; X86-64-NEXT:    movaps %xmm0, (%rdi)
; X86-64-NEXT:    retq
;
; NHM_64-LABEL: t2:
; NHM_64:       ## %bb.0: ## %entry
; NHM_64-NEXT:    movaps (%rsi), %xmm0
; NHM_64-NEXT:    movaps %xmm0, (%rdi)
; NHM_64-NEXT:    retq
entry:
  tail call void @llvm.memcpy.p0.p0.i32(ptr align 16 %a, ptr align 16 %b, i32 16, i1 false)
  ret void
}

define void @t3(ptr nocapture %a, ptr nocapture %b) nounwind ssp {
; SSE2-Darwin-LABEL: t3:
; SSE2-Darwin:       ## %bb.0: ## %entry
; SSE2-Darwin-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2-Darwin-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SSE2-Darwin-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE2-Darwin-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE2-Darwin-NEXT:    movsd %xmm1, 8(%eax)
; SSE2-Darwin-NEXT:    movsd %xmm0, (%eax)
; SSE2-Darwin-NEXT:    retl
;
; SSE2-Mingw32-LABEL: t3:
; SSE2-Mingw32:       # %bb.0: # %entry
; SSE2-Mingw32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE2-Mingw32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SSE2-Mingw32-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE2-Mingw32-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE2-Mingw32-NEXT:    movsd %xmm1, 8(%eax)
; SSE2-Mingw32-NEXT:    movsd %xmm0, (%eax)
; SSE2-Mingw32-NEXT:    retl
;
; SSE1-LABEL: t3:
; SSE1:       ## %bb.0: ## %entry
; SSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE1-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SSE1-NEXT:    movl 12(%ecx), %edx
; SSE1-NEXT:    movl %edx, 12(%eax)
; SSE1-NEXT:    movl 8(%ecx), %edx
; SSE1-NEXT:    movl %edx, 8(%eax)
; SSE1-NEXT:    movl (%ecx), %edx
; SSE1-NEXT:    movl 4(%ecx), %ecx
; SSE1-NEXT:    movl %ecx, 4(%eax)
; SSE1-NEXT:    movl %edx, (%eax)
; SSE1-NEXT:    retl
;
; NOSSE-LABEL: t3:
; NOSSE:       ## %bb.0: ## %entry
; NOSSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; NOSSE-NEXT:    movl 12(%ecx), %edx
; NOSSE-NEXT:    movl %edx, 12(%eax)
; NOSSE-NEXT:    movl 8(%ecx), %edx
; NOSSE-NEXT:    movl %edx, 8(%eax)
; NOSSE-NEXT:    movl (%ecx), %edx
; NOSSE-NEXT:    movl 4(%ecx), %ecx
; NOSSE-NEXT:    movl %ecx, 4(%eax)
; NOSSE-NEXT:    movl %edx, (%eax)
; NOSSE-NEXT:    retl
;
; X86-64-LABEL: t3:
; X86-64:       ## %bb.0: ## %entry
; X86-64-NEXT:    movq (%rsi), %rax
; X86-64-NEXT:    movq 8(%rsi), %rcx
; X86-64-NEXT:    movq %rcx, 8(%rdi)
; X86-64-NEXT:    movq %rax, (%rdi)
; X86-64-NEXT:    retq
;
; NHM_64-LABEL: t3:
; NHM_64:       ## %bb.0: ## %entry
; NHM_64-NEXT:    movups (%rsi), %xmm0
; NHM_64-NEXT:    movups %xmm0, (%rdi)
; NHM_64-NEXT:    retq
entry:
  tail call void @llvm.memcpy.p0.p0.i32(ptr align 8 %a, ptr align 8 %b, i32 16, i1 false)
  ret void
}

;;; TODO: (1) Some of the loads and stores are certainly unaligned and (2) the first load and first
;;; store overlap with the second load and second store respectively.
;;;
;;; Are any of the sequences ideal?
define void @t4() nounwind {
; SSE2-Darwin-LABEL: t4:
; SSE2-Darwin:       ## %bb.0: ## %entry
; SSE2-Darwin-NEXT:    subl $32, %esp
; SSE2-Darwin-NEXT:    movw $120, {{[0-9]+}}(%esp)
; SSE2-Darwin-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; SSE2-Darwin-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; SSE2-Darwin-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; SSE2-Darwin-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; SSE2-Darwin-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; SSE2-Darwin-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; SSE2-Darwin-NEXT:    movl $2021161080, (%esp) ## imm = 0x78787878
; SSE2-Darwin-NEXT:    ud2
;
; SSE2-Mingw32-LABEL: t4:
; SSE2-Mingw32:       # %bb.0: # %entry
; SSE2-Mingw32-NEXT:    subl $32, %esp
; SSE2-Mingw32-NEXT:    movw $120, {{[0-9]+}}(%esp)
; SSE2-Mingw32-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) # imm = 0x78787878
; SSE2-Mingw32-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) # imm = 0x78787878
; SSE2-Mingw32-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) # imm = 0x78787878
; SSE2-Mingw32-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) # imm = 0x78787878
; SSE2-Mingw32-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) # imm = 0x78787878
; SSE2-Mingw32-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) # imm = 0x78787878
; SSE2-Mingw32-NEXT:    movl $2021161080, (%esp) # imm = 0x78787878
;
; SSE1-LABEL: t4:
; SSE1:       ## %bb.0: ## %entry
; SSE1-NEXT:    subl $32, %esp
; SSE1-NEXT:    movw $120, {{[0-9]+}}(%esp)
; SSE1-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; SSE1-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; SSE1-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; SSE1-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; SSE1-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; SSE1-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; SSE1-NEXT:    movl $2021161080, (%esp) ## imm = 0x78787878
; SSE1-NEXT:    ud2
;
; NOSSE-LABEL: t4:
; NOSSE:       ## %bb.0: ## %entry
; NOSSE-NEXT:    subl $32, %esp
; NOSSE-NEXT:    movw $120, {{[0-9]+}}(%esp)
; NOSSE-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; NOSSE-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; NOSSE-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; NOSSE-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; NOSSE-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; NOSSE-NEXT:    movl $2021161080, {{[0-9]+}}(%esp) ## imm = 0x78787878
; NOSSE-NEXT:    movl $2021161080, (%esp) ## imm = 0x78787878
; NOSSE-NEXT:    ud2
;
; X86-64-LABEL: t4:
; X86-64:       ## %bb.0: ## %entry
; X86-64-NEXT:    movabsq $33909456017848440, %rax ## imm = 0x78787878787878
; X86-64-NEXT:    movq %rax, -{{[0-9]+}}(%rsp)
; X86-64-NEXT:    movabsq $8680820740569200760, %rax ## imm = 0x7878787878787878
; X86-64-NEXT:    movq %rax, -{{[0-9]+}}(%rsp)
; X86-64-NEXT:    movq %rax, -{{[0-9]+}}(%rsp)
; X86-64-NEXT:    movq %rax, -{{[0-9]+}}(%rsp)
; X86-64-NEXT:    ud2
;
; NHM_64-LABEL: t4:
; NHM_64:       ## %bb.0: ## %entry
; NHM_64-NEXT:    movups _.str2+14(%rip), %xmm0
; NHM_64-NEXT:    movups %xmm0, -{{[0-9]+}}(%rsp)
; NHM_64-NEXT:    movups _.str2(%rip), %xmm0
; NHM_64-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; NHM_64-NEXT:    ud2
entry:
  %tmp1 = alloca [30 x i8]
  call void @llvm.memcpy.p0.p0.i32(ptr align 1 %tmp1, ptr align 1 @.str2, i32 30, i1 false)
  unreachable
}

declare void @llvm.memcpy.p0.p0.i32(ptr nocapture, ptr nocapture, i32, i1) nounwind
