; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s | FileCheck %s

target datalayout = "E-m:a-p:32:32-i64:64-n32"
target triple = "powerpc-ibm-aix7.2.0.0"

%struct.USST = type { i16, i16 }
%struct.SST = type { i16, i16 }
%struct.CST = type { i8, i8 }
%struct.SCST = type { i8, i8 }
%struct.ST = type { i32, i32 }
%struct.UST = type { i32, i32 }

; Function Attrs: nounwind
define i32 @ustc1(ptr noundef byval(%struct.USST) align 4 %s) {
; CHECK-LABEL: ustc1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    srwi 3, 3, 24
; CHECK-NEXT:    stw 4, 24(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, ptr %s, align 4
  %conv = zext i16 %0 to i32
  %shr = ashr i32 %conv, 8
  ret i32 %shr
}

; Function Attrs: nounwind
define i32 @ustc2(ptr noundef byval(%struct.USST) align 4 %s) {
; CHECK-LABEL: ustc2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    srwi 3, 3, 16
; CHECK-NEXT:    stw 4, 24(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, ptr %s, align 4
  %conv = zext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nounwind
define i32 @stc1(ptr noundef byval(%struct.SST) align 4 %s) {
; CHECK-LABEL: stc1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    srawi 3, 3, 24
; CHECK-NEXT:    stw 4, 24(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, ptr %s, align 4
  %conv = sext i16 %0 to i32
  %shr = ashr i32 %conv, 8
  ret i32 %shr
}

; Function Attrs: nounwind
define i32 @stc2(ptr noundef byval(%struct.SST) align 4 %s) {
; CHECK-LABEL: stc2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    srawi 3, 3, 16
; CHECK-NEXT:    stw 4, 24(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, ptr %s, align 4
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

; Function Attrs: nounwind
define i32 @ctc(ptr noundef byval(%struct.CST) align 4 %s) {
; CHECK-LABEL: ctc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    srwi 3, 3, 24
; CHECK-NEXT:    stw 4, 24(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i8, ptr %s, align 4
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nounwind
define i32 @sctc(ptr noundef byval(%struct.SCST) align 4 %s) {
; CHECK-LABEL: sctc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mr 4, 3
; CHECK-NEXT:    srawi 3, 3, 24
; CHECK-NEXT:    stw 4, 24(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i8, ptr %s, align 4
  %conv = sext i8 %0 to i32
  ret i32 %conv
}

; Function Attrs: nounwind
define i32 @tc44(ptr noundef byval(%struct.ST) align 4 %s) {
; CHECK-LABEL: tc44:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw 3, 24(1)
; CHECK-NEXT:    stw 4, 28(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @tc41(ptr noundef byval(%struct.ST) align 4 %s) {
; CHECK-LABEL: tc41:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw 3, 24(1)
; CHECK-NEXT:    srawi 3, 3, 24
; CHECK-NEXT:    stw 4, 28(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 4
  %shr = ashr i32 %0, 24
  ret i32 %shr
}

; Function Attrs: nounwind
define i32 @tc42(ptr noundef byval(%struct.ST) align 4 %s) {
; CHECK-LABEL: tc42:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw 3, 24(1)
; CHECK-NEXT:    srawi 3, 3, 16
; CHECK-NEXT:    stw 4, 28(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 4
  %shr = ashr i32 %0, 16
  ret i32 %shr
}

; Function Attrs: nounwind
define i32 @tc43(ptr noundef byval(%struct.ST) align 4 %s) {
; CHECK-LABEL: tc43:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw 3, 24(1)
; CHECK-NEXT:    srawi 3, 3, 8
; CHECK-NEXT:    stw 4, 28(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 4
  %shr = ashr i32 %0, 8
  ret i32 %shr
}

; Function Attrs: nounwind
define i32 @utc44(ptr noundef byval(%struct.UST) align 4 %s) {
; CHECK-LABEL: utc44:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw 3, 24(1)
; CHECK-NEXT:    stw 4, 28(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @utc41(ptr noundef byval(%struct.UST) align 4 %s) {
; CHECK-LABEL: utc41:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw 3, 24(1)
; CHECK-NEXT:    srwi 3, 3, 24
; CHECK-NEXT:    stw 4, 28(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 4
  %shr = lshr i32 %0, 24
  ret i32 %shr
}

; Function Attrs: nounwind
define i32 @utc42(ptr noundef byval(%struct.UST) align 4 %s) {
; CHECK-LABEL: utc42:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw 3, 24(1)
; CHECK-NEXT:    srwi 3, 3, 16
; CHECK-NEXT:    stw 4, 28(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 4
  %shr = lshr i32 %0, 16
  ret i32 %shr
}

; Function Attrs: nounwind
define i32 @utc43(ptr noundef byval(%struct.UST) align 4 %s) {
; CHECK-LABEL: utc43:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw 3, 24(1)
; CHECK-NEXT:    srwi 3, 3, 8
; CHECK-NEXT:    stw 4, 28(1)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr %s, align 4
  %shr = lshr i32 %0, 8
  ret i32 %shr
}
