; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx908 -stop-after=amdgpu-remove-incompatible-functions\
; RUN:   -pass-remarks=amdgpu-remove-incompatible-functions %s -o - 2>%t | FileCheck -check-prefix=EXTIMG %s
; RUN: FileCheck -allow-empty --check-prefix=WARN-EXTIMG %s < %t
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s

; RUN: llc -mtriple=amdgcn -mcpu=gfx90a -stop-after=amdgpu-remove-incompatible-functions\
; RUN:   -pass-remarks=amdgpu-remove-incompatible-functions %s -o - 2>%t | FileCheck -check-prefix=NOEXTIMG %s
; RUN: FileCheck --check-prefix=WARN-NOEXTIMG %s < %t
; RUN: llc -mtriple=amdgcn -mcpu=gfx90a -verify-machineinstrs < %s

; Note: This test checks the IR, but also has a run line to codegen the file just to check we
; do not crash when trying to select those functions.

; WARN-EXTIMG-NOT: removing function 'needs_extimg':
; WARN-NOEXTIMG:   removing function 'needs_extimg': +extended-image-insts is not supported on the current target

; EXTIMG:       @GVRefs {{.*}} [ptr @needs_extimg]
; NOEXTIMG:     @GVRefs {{.*}} zeroinitializer
@GVRefs = internal global [1 x ptr] [
  ptr @needs_extimg
]

; EXTIMG:         @ConstantExpr = internal global i64 ptrtoint (ptr @needs_extimg to i64)
; NOEXTIMG:       @ConstantExpr = internal global i64 0

@ConstantExpr = internal global i64 ptrtoint (ptr @needs_extimg to i64)

; EXTIMG:         define <4 x float> @needs_extimg
; NOEXTIMG-NOT:   define <4 x float> @needs_extimg
define <4 x float> @needs_extimg(float noundef %0, float noundef %1, <8 x i32> noundef %2, <4 x i32> noundef %3) #0 {
  %5 = tail call <4 x float> @llvm.amdgcn.image.sample.lz.2d.v4f32.f32(i32 noundef 15, float %0, float %1, <8 x i32> %2, <4 x i32> %3, i1 noundef false, i32 noundef 0, i32 noundef 0)
  ret <4 x float> %5
}

; IR: define void @caller(
define void @caller(float noundef %0, float noundef %1, <8 x i32> noundef %2, <4 x i32> noundef %3) {
  ; EXTIMG: call void @needs_extimg(
  ; NOEXTIMG: call void null
  call void @needs_extimg(float %0, float %1, <8 x i32> %2, <4 x i32> %3)
  ; IR: ret void
  ret void
}

declare <4 x float> @llvm.amdgcn.image.sample.lz.2d.v4f32.f32(i32 immarg, float, float, <8 x i32>, <4 x i32>, i1 immarg, i32 immarg, i32 immarg)

attributes #0 = { "target-features"="+extended-image-insts" }
