///////////////////////////////////////////////////////////////////////////////
//
// XMLEscaper.cc
// -------------
// XML Escape character treatment
//
// Design and Implementation by Bjoern Lemke
//               
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: XMLEscaper
// 
// Description: XML escape character utility class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include "XMLEscaper.h"

XMLEscaper::XMLEscaper()
{
}
XMLEscaper::~XMLEscaper()
{
}

void XMLEscaper::escape(Chain& target)
{
    target.replaceAll(Chain("&"), Chain("&amp;"), target);
    target.replaceAll(Chain("<"), Chain("&lt;"), target);
    target.replaceAll(Chain(">"), Chain("&gt;"), target);
    target.replaceAll(Chain("'"), Chain("&apos;"), target);
    target.replaceAll(Chain("\""), Chain("&quot;"), target);
    target.replaceAll(Chain("\t"), Chain("&#x9;"), target);
    target.replaceAll(Chain("\n"), Chain("&#xA;"), target);
}

void XMLEscaper::descape(Chain& target)
{
    target.replaceAll(Chain("&lt;"), Chain("<"), target);
    target.replaceAll(Chain("&gt;"), Chain(">"),  target);
    target.replaceAll(Chain("&apos;"), Chain("'"), target);
    target.replaceAll(Chain("&quot;"), Chain("\""), target);
    target.replaceAll(Chain("&amp;"), Chain("&"), target);
    target.replaceAll(Chain("&#x9;"), Chain("\t"), target);
    target.replaceAll(Chain("&#xA;"), Chain("\n"), target);
    target.replaceAll(Chain("&#xD;"), Chain("\n"), target);
}
