#![feature(prelude_import)]
#![doc(html_root_url = "https://docs.rs/syn/1.0.97")]
#![allow(non_camel_case_types)]
#![allow(
    clippy::cast_lossless,
    clippy::cast_possible_truncation,
    clippy::default_trait_access,
    clippy::doc_markdown,
    clippy::expl_impl_clone_on_copy,
    clippy::if_not_else,
    clippy::inherent_to_string,
    clippy::large_enum_variant,
    clippy::let_underscore_drop,
    clippy::manual_assert,
    clippy::match_on_vec_items,
    clippy::match_same_arms,
    clippy::match_wildcard_for_single_variants,
    clippy::missing_errors_doc,
    clippy::missing_panics_doc,
    clippy::module_name_repetitions,
    clippy::must_use_candidate,
    clippy::needless_doctest_main,
    clippy::needless_pass_by_value,
    clippy::never_loop,
    clippy::redundant_else,
    clippy::return_self_not_must_use,
    clippy::similar_names,
    clippy::single_match_else,
    clippy::too_many_arguments,
    clippy::too_many_lines,
    clippy::trivially_copy_pass_by_ref,
    clippy::unnecessary_unwrap,
    clippy::used_underscore_binding,
    clippy::wildcard_imports
)]
#[prelude_import]
use std::prelude::rust_2018::*;
#[macro_use]
extern crate std;
#[cfg(
    all(
        not(all(target_arch = "wasm32", any(target_os = "unknown", target_os = "wasi"))),
        feature = "proc-macro"
    )
)]
extern crate proc_macro;
extern crate proc_macro2;
#[cfg(feature = "printing")]
extern crate quote;
#[macro_use]
mod macros {}
#[cfg(feature = "parsing")]
#[doc(hidden)]
#[macro_use]
pub mod group {
    use crate::error::Result;
    use crate::parse::ParseBuffer;
    use crate::token;
    use proc_macro2::{Delimiter, Span};
    #[doc(hidden)]
    pub struct Parens<'a> {
        pub token: token::Paren,
        pub content: ParseBuffer<'a>,
    }
    #[doc(hidden)]
    pub struct Braces<'a> {
        pub token: token::Brace,
        pub content: ParseBuffer<'a>,
    }
    #[doc(hidden)]
    pub struct Brackets<'a> {
        pub token: token::Bracket,
        pub content: ParseBuffer<'a>,
    }
    #[cfg(any(feature = "full", feature = "derive"))]
    #[doc(hidden)]
    pub struct Group<'a> {
        pub token: token::Group,
        pub content: ParseBuffer<'a>,
    }
    #[doc(hidden)]
    pub fn parse_parens<'a>(input: &ParseBuffer<'a>) -> Result<Parens<'a>> {
        parse_delimited(input, Delimiter::Parenthesis)
            .map(|(span, content)| Parens {
                token: token::Paren(span),
                content,
            })
    }
    #[doc(hidden)]
    pub fn parse_braces<'a>(input: &ParseBuffer<'a>) -> Result<Braces<'a>> {
        parse_delimited(input, Delimiter::Brace)
            .map(|(span, content)| Braces {
                token: token::Brace(span),
                content,
            })
    }
    #[doc(hidden)]
    pub fn parse_brackets<'a>(input: &ParseBuffer<'a>) -> Result<Brackets<'a>> {
        parse_delimited(input, Delimiter::Bracket)
            .map(|(span, content)| Brackets {
                token: token::Bracket(span),
                content,
            })
    }
    #[cfg(any(feature = "full", feature = "derive"))]
    pub(crate) fn parse_group<'a>(input: &ParseBuffer<'a>) -> Result<Group<'a>> {
        parse_delimited(input, Delimiter::None)
            .map(|(span, content)| Group {
                token: token::Group(span),
                content,
            })
    }
    fn parse_delimited<'a>(
        input: &ParseBuffer<'a>,
        delimiter: Delimiter,
    ) -> Result<(Span, ParseBuffer<'a>)> {
        input
            .step(|cursor| {
                if let Some((content, span, rest)) = cursor.group(delimiter) {
                    let scope = crate::buffer::close_span_of_group(*cursor);
                    let nested = crate::parse::advance_step_cursor(cursor, content);
                    let unexpected = crate::parse::get_unexpected(input);
                    let content = crate::parse::new_parse_buffer(
                        scope,
                        nested,
                        unexpected,
                    );
                    Ok(((span, content), rest))
                } else {
                    let message = match delimiter {
                        Delimiter::Parenthesis => "expected parentheses",
                        Delimiter::Brace => "expected curly braces",
                        Delimiter::Bracket => "expected square brackets",
                        Delimiter::None => "expected invisible group",
                    };
                    Err(cursor.error(message))
                }
            })
    }
}
#[macro_use]
pub mod token {
    use self::private::WithSpan;
    #[cfg(feature = "parsing")]
    use crate::buffer::Cursor;
    #[cfg(feature = "parsing")]
    use crate::error::Result;
    #[cfg(feature = "parsing")]
    use crate::lifetime::Lifetime;
    #[cfg(feature = "parsing")]
    use crate::lit::{
        Lit, LitBool, LitByte, LitByteStr, LitChar, LitFloat, LitInt, LitStr,
    };
    #[cfg(feature = "parsing")]
    use crate::lookahead;
    #[cfg(feature = "parsing")]
    use crate::parse::{Parse, ParseStream};
    use crate::span::IntoSpans;
    #[cfg(any(feature = "parsing", feature = "printing"))]
    use proc_macro2::Ident;
    use proc_macro2::Span;
    #[cfg(feature = "printing")]
    use proc_macro2::TokenStream;
    #[cfg(feature = "parsing")]
    use proc_macro2::{Delimiter, Literal, Punct, TokenTree};
    #[cfg(feature = "printing")]
    use quote::{ToTokens, TokenStreamExt};
    #[cfg(feature = "extra-traits")]
    use std::cmp;
    #[cfg(feature = "extra-traits")]
    use std::fmt::{self, Debug};
    #[cfg(feature = "extra-traits")]
    use std::hash::{Hash, Hasher};
    use std::ops::{Deref, DerefMut};
    #[cfg(feature = "parsing")]
    pub trait Token: private::Sealed {
        #[doc(hidden)]
        fn peek(cursor: Cursor) -> bool;
        #[doc(hidden)]
        fn display() -> &'static str;
    }
    mod private {
        use proc_macro2::Span;
        #[cfg(feature = "parsing")]
        pub trait Sealed {}
        #[repr(C)]
        pub struct WithSpan {
            pub span: Span,
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Ident {}
    #[cfg(feature = "parsing")]
    fn peek_impl(cursor: Cursor, peek: fn(ParseStream) -> bool) -> bool {
        use crate::parse::Unexpected;
        use std::cell::Cell;
        use std::rc::Rc;
        let scope = Span::call_site();
        let unexpected = Rc::new(Cell::new(Unexpected::None));
        let buffer = crate::parse::new_parse_buffer(scope, cursor, unexpected);
        peek(&buffer)
    }
    #[cfg(feature = "parsing")]
    impl Token for Lifetime {
        fn peek(cursor: Cursor) -> bool {
            fn peek(input: ParseStream) -> bool {
                <Lifetime as Parse>::parse(input).is_ok()
            }
            peek_impl(cursor, peek)
        }
        fn display() -> &'static str {
            "lifetime"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Lifetime {}
    #[cfg(feature = "parsing")]
    impl Token for Lit {
        fn peek(cursor: Cursor) -> bool {
            fn peek(input: ParseStream) -> bool {
                <Lit as Parse>::parse(input).is_ok()
            }
            peek_impl(cursor, peek)
        }
        fn display() -> &'static str {
            "literal"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Lit {}
    #[cfg(feature = "parsing")]
    impl Token for LitStr {
        fn peek(cursor: Cursor) -> bool {
            fn peek(input: ParseStream) -> bool {
                <LitStr as Parse>::parse(input).is_ok()
            }
            peek_impl(cursor, peek)
        }
        fn display() -> &'static str {
            "string literal"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for LitStr {}
    #[cfg(feature = "parsing")]
    impl Token for LitByteStr {
        fn peek(cursor: Cursor) -> bool {
            fn peek(input: ParseStream) -> bool {
                <LitByteStr as Parse>::parse(input).is_ok()
            }
            peek_impl(cursor, peek)
        }
        fn display() -> &'static str {
            "byte string literal"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for LitByteStr {}
    #[cfg(feature = "parsing")]
    impl Token for LitByte {
        fn peek(cursor: Cursor) -> bool {
            fn peek(input: ParseStream) -> bool {
                <LitByte as Parse>::parse(input).is_ok()
            }
            peek_impl(cursor, peek)
        }
        fn display() -> &'static str {
            "byte literal"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for LitByte {}
    #[cfg(feature = "parsing")]
    impl Token for LitChar {
        fn peek(cursor: Cursor) -> bool {
            fn peek(input: ParseStream) -> bool {
                <LitChar as Parse>::parse(input).is_ok()
            }
            peek_impl(cursor, peek)
        }
        fn display() -> &'static str {
            "character literal"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for LitChar {}
    #[cfg(feature = "parsing")]
    impl Token for LitInt {
        fn peek(cursor: Cursor) -> bool {
            fn peek(input: ParseStream) -> bool {
                <LitInt as Parse>::parse(input).is_ok()
            }
            peek_impl(cursor, peek)
        }
        fn display() -> &'static str {
            "integer literal"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for LitInt {}
    #[cfg(feature = "parsing")]
    impl Token for LitFloat {
        fn peek(cursor: Cursor) -> bool {
            fn peek(input: ParseStream) -> bool {
                <LitFloat as Parse>::parse(input).is_ok()
            }
            peek_impl(cursor, peek)
        }
        fn display() -> &'static str {
            "floating point literal"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for LitFloat {}
    #[cfg(feature = "parsing")]
    impl Token for LitBool {
        fn peek(cursor: Cursor) -> bool {
            fn peek(input: ParseStream) -> bool {
                <LitBool as Parse>::parse(input).is_ok()
            }
            peek_impl(cursor, peek)
        }
        fn display() -> &'static str {
            "boolean literal"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for LitBool {}
    #[cfg(feature = "parsing")]
    impl Token for proc_macro2::Group {
        fn peek(cursor: Cursor) -> bool {
            fn peek(input: ParseStream) -> bool {
                <proc_macro2::Group as Parse>::parse(input).is_ok()
            }
            peek_impl(cursor, peek)
        }
        fn display() -> &'static str {
            "group token"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for proc_macro2::Group {}
    #[cfg(feature = "parsing")]
    impl Token for Punct {
        fn peek(cursor: Cursor) -> bool {
            cursor.punct().is_some()
        }
        fn display() -> &'static str {
            "punctuation token"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Punct {}
    #[cfg(feature = "parsing")]
    impl Token for Literal {
        fn peek(cursor: Cursor) -> bool {
            cursor.literal().is_some()
        }
        fn display() -> &'static str {
            "literal"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Literal {}
    #[cfg(feature = "parsing")]
    impl Token for TokenTree {
        fn peek(cursor: Cursor) -> bool {
            cursor.token_tree().is_some()
        }
        fn display() -> &'static str {
            "token"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for TokenTree {}
    #[doc(hidden)]
    #[cfg(feature = "parsing")]
    pub trait CustomToken {
        fn peek(cursor: Cursor) -> bool;
        fn display() -> &'static str;
    }
    #[cfg(feature = "parsing")]
    impl<T: CustomToken> private::Sealed for T {}
    #[cfg(feature = "parsing")]
    impl<T: CustomToken> Token for T {
        fn peek(cursor: Cursor) -> bool {
            <Self as CustomToken>::peek(cursor)
        }
        fn display() -> &'static str {
            <Self as CustomToken>::display()
        }
    }
    #[repr(C)]
    pub struct Underscore {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Underscore<S: IntoSpans<[Span; 1]>>(spans: S) -> Underscore {
        Underscore {
            spans: spans.into_spans(),
        }
    }
    impl std::default::Default for Underscore {
        fn default() -> Self {
            Underscore {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Underscore {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Underscore {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Underscore {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Underscore")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Underscore {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Underscore {
        fn eq(&self, _other: &Underscore) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Underscore {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Underscore {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Underscore {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Underscore {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            tokens.append(Ident::new("_", self.span));
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Underscore {
        fn parse(input: ParseStream) -> Result<Self> {
            input
                .step(|cursor| {
                    if let Some((ident, rest)) = cursor.ident() {
                        if ident == "_" {
                            return Ok((Underscore(ident.span()), rest));
                        }
                    }
                    if let Some((punct, rest)) = cursor.punct() {
                        if punct.as_char() == '_' {
                            return Ok((Underscore(punct.span()), rest));
                        }
                    }
                    Err(cursor.error("expected `_`"))
                })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Underscore {
        fn peek(cursor: Cursor) -> bool {
            if let Some((ident, _rest)) = cursor.ident() {
                return ident == "_";
            }
            if let Some((punct, _rest)) = cursor.punct() {
                return punct.as_char() == '_';
            }
            false
        }
        fn display() -> &'static str {
            "`_`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Underscore {}
    #[cfg(feature = "parsing")]
    impl Token for Paren {
        fn peek(cursor: Cursor) -> bool {
            lookahead::is_delimiter(cursor, Delimiter::Parenthesis)
        }
        fn display() -> &'static str {
            "parentheses"
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Brace {
        fn peek(cursor: Cursor) -> bool {
            lookahead::is_delimiter(cursor, Delimiter::Brace)
        }
        fn display() -> &'static str {
            "curly braces"
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Bracket {
        fn peek(cursor: Cursor) -> bool {
            lookahead::is_delimiter(cursor, Delimiter::Bracket)
        }
        fn display() -> &'static str {
            "square brackets"
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Group {
        fn peek(cursor: Cursor) -> bool {
            lookahead::is_delimiter(cursor, Delimiter::None)
        }
        fn display() -> &'static str {
            "invisible group"
        }
    }
    pub struct Abstract {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Abstract<S: IntoSpans<[Span; 1]>>(span: S) -> Abstract {
        Abstract {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Abstract {
        fn default() -> Self {
            Abstract {
                span: Span::call_site(),
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Abstract {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Abstract {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Abstract {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Abstract")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Abstract {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Abstract {
        fn eq(&self, _other: &Abstract) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Abstract {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Abstract {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("abstract", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Abstract {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Abstract {
                span: parsing::keyword(input, "abstract")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Abstract {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "abstract")
        }
        fn display() -> &'static str {
            "`abstract`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Abstract {}
    pub struct As {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn As<S: IntoSpans<[Span; 1]>>(span: S) -> As {
        As { span: span.into_spans()[0] }
    }
    impl std::default::Default for As {
        fn default() -> Self {
            As { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for As {}
    #[cfg(feature = "clone-impls")]
    impl Clone for As {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for As {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("As")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for As {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for As {
        fn eq(&self, _other: &As) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for As {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for As {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("as", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for As {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(As {
                span: parsing::keyword(input, "as")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for As {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "as")
        }
        fn display() -> &'static str {
            "`as`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for As {}
    pub struct Async {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Async<S: IntoSpans<[Span; 1]>>(span: S) -> Async {
        Async {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Async {
        fn default() -> Self {
            Async { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Async {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Async {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Async {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Async")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Async {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Async {
        fn eq(&self, _other: &Async) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Async {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Async {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("async", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Async {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Async {
                span: parsing::keyword(input, "async")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Async {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "async")
        }
        fn display() -> &'static str {
            "`async`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Async {}
    pub struct Auto {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Auto<S: IntoSpans<[Span; 1]>>(span: S) -> Auto {
        Auto { span: span.into_spans()[0] }
    }
    impl std::default::Default for Auto {
        fn default() -> Self {
            Auto { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Auto {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Auto {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Auto {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Auto")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Auto {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Auto {
        fn eq(&self, _other: &Auto) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Auto {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Auto {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("auto", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Auto {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Auto {
                span: parsing::keyword(input, "auto")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Auto {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "auto")
        }
        fn display() -> &'static str {
            "`auto`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Auto {}
    pub struct Await {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Await<S: IntoSpans<[Span; 1]>>(span: S) -> Await {
        Await {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Await {
        fn default() -> Self {
            Await { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Await {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Await {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Await {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Await")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Await {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Await {
        fn eq(&self, _other: &Await) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Await {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Await {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("await", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Await {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Await {
                span: parsing::keyword(input, "await")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Await {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "await")
        }
        fn display() -> &'static str {
            "`await`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Await {}
    pub struct Become {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Become<S: IntoSpans<[Span; 1]>>(span: S) -> Become {
        Become {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Become {
        fn default() -> Self {
            Become { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Become {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Become {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Become {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Become")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Become {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Become {
        fn eq(&self, _other: &Become) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Become {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Become {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("become", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Become {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Become {
                span: parsing::keyword(input, "become")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Become {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "become")
        }
        fn display() -> &'static str {
            "`become`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Become {}
    pub struct Box {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Box<S: IntoSpans<[Span; 1]>>(span: S) -> Box {
        Box { span: span.into_spans()[0] }
    }
    impl std::default::Default for Box {
        fn default() -> Self {
            Box { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Box {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Box {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Box {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Box")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Box {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Box {
        fn eq(&self, _other: &Box) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Box {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Box {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("box", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Box {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Box {
                span: parsing::keyword(input, "box")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Box {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "box")
        }
        fn display() -> &'static str {
            "`box`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Box {}
    pub struct Break {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Break<S: IntoSpans<[Span; 1]>>(span: S) -> Break {
        Break {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Break {
        fn default() -> Self {
            Break { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Break {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Break {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Break {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Break")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Break {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Break {
        fn eq(&self, _other: &Break) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Break {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Break {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("break", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Break {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Break {
                span: parsing::keyword(input, "break")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Break {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "break")
        }
        fn display() -> &'static str {
            "`break`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Break {}
    pub struct Const {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Const<S: IntoSpans<[Span; 1]>>(span: S) -> Const {
        Const {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Const {
        fn default() -> Self {
            Const { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Const {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Const {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Const {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Const")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Const {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Const {
        fn eq(&self, _other: &Const) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Const {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Const {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("const", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Const {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Const {
                span: parsing::keyword(input, "const")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Const {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "const")
        }
        fn display() -> &'static str {
            "`const`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Const {}
    pub struct Continue {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Continue<S: IntoSpans<[Span; 1]>>(span: S) -> Continue {
        Continue {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Continue {
        fn default() -> Self {
            Continue {
                span: Span::call_site(),
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Continue {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Continue {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Continue {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Continue")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Continue {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Continue {
        fn eq(&self, _other: &Continue) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Continue {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Continue {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("continue", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Continue {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Continue {
                span: parsing::keyword(input, "continue")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Continue {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "continue")
        }
        fn display() -> &'static str {
            "`continue`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Continue {}
    pub struct Crate {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Crate<S: IntoSpans<[Span; 1]>>(span: S) -> Crate {
        Crate {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Crate {
        fn default() -> Self {
            Crate { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Crate {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Crate {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Crate {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Crate")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Crate {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Crate {
        fn eq(&self, _other: &Crate) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Crate {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Crate {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("crate", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Crate {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Crate {
                span: parsing::keyword(input, "crate")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Crate {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "crate")
        }
        fn display() -> &'static str {
            "`crate`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Crate {}
    pub struct Default {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Default<S: IntoSpans<[Span; 1]>>(span: S) -> Default {
        Default {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Default {
        fn default() -> Self {
            Default { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Default {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Default {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Default {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Default")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Default {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Default {
        fn eq(&self, _other: &Default) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Default {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Default {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("default", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Default {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Default {
                span: parsing::keyword(input, "default")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Default {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "default")
        }
        fn display() -> &'static str {
            "`default`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Default {}
    pub struct Do {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Do<S: IntoSpans<[Span; 1]>>(span: S) -> Do {
        Do { span: span.into_spans()[0] }
    }
    impl std::default::Default for Do {
        fn default() -> Self {
            Do { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Do {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Do {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Do {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Do")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Do {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Do {
        fn eq(&self, _other: &Do) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Do {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Do {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("do", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Do {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Do {
                span: parsing::keyword(input, "do")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Do {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "do")
        }
        fn display() -> &'static str {
            "`do`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Do {}
    pub struct Dyn {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Dyn<S: IntoSpans<[Span; 1]>>(span: S) -> Dyn {
        Dyn { span: span.into_spans()[0] }
    }
    impl std::default::Default for Dyn {
        fn default() -> Self {
            Dyn { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Dyn {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Dyn {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Dyn {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Dyn")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Dyn {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Dyn {
        fn eq(&self, _other: &Dyn) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Dyn {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Dyn {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("dyn", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Dyn {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Dyn {
                span: parsing::keyword(input, "dyn")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Dyn {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "dyn")
        }
        fn display() -> &'static str {
            "`dyn`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Dyn {}
    pub struct Else {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Else<S: IntoSpans<[Span; 1]>>(span: S) -> Else {
        Else { span: span.into_spans()[0] }
    }
    impl std::default::Default for Else {
        fn default() -> Self {
            Else { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Else {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Else {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Else {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Else")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Else {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Else {
        fn eq(&self, _other: &Else) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Else {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Else {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("else", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Else {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Else {
                span: parsing::keyword(input, "else")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Else {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "else")
        }
        fn display() -> &'static str {
            "`else`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Else {}
    pub struct Enum {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Enum<S: IntoSpans<[Span; 1]>>(span: S) -> Enum {
        Enum { span: span.into_spans()[0] }
    }
    impl std::default::Default for Enum {
        fn default() -> Self {
            Enum { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Enum {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Enum {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Enum {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Enum")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Enum {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Enum {
        fn eq(&self, _other: &Enum) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Enum {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Enum {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("enum", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Enum {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Enum {
                span: parsing::keyword(input, "enum")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Enum {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "enum")
        }
        fn display() -> &'static str {
            "`enum`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Enum {}
    pub struct Extern {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Extern<S: IntoSpans<[Span; 1]>>(span: S) -> Extern {
        Extern {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Extern {
        fn default() -> Self {
            Extern { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Extern {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Extern {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Extern {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Extern")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Extern {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Extern {
        fn eq(&self, _other: &Extern) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Extern {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Extern {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("extern", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Extern {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Extern {
                span: parsing::keyword(input, "extern")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Extern {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "extern")
        }
        fn display() -> &'static str {
            "`extern`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Extern {}
    pub struct Final {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Final<S: IntoSpans<[Span; 1]>>(span: S) -> Final {
        Final {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Final {
        fn default() -> Self {
            Final { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Final {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Final {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Final {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Final")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Final {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Final {
        fn eq(&self, _other: &Final) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Final {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Final {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("final", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Final {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Final {
                span: parsing::keyword(input, "final")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Final {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "final")
        }
        fn display() -> &'static str {
            "`final`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Final {}
    pub struct Fn {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Fn<S: IntoSpans<[Span; 1]>>(span: S) -> Fn {
        Fn { span: span.into_spans()[0] }
    }
    impl std::default::Default for Fn {
        fn default() -> Self {
            Fn { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Fn {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Fn {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Fn {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Fn")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Fn {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Fn {
        fn eq(&self, _other: &Fn) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Fn {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Fn {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("fn", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Fn {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Fn {
                span: parsing::keyword(input, "fn")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Fn {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "fn")
        }
        fn display() -> &'static str {
            "`fn`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Fn {}
    pub struct For {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn For<S: IntoSpans<[Span; 1]>>(span: S) -> For {
        For { span: span.into_spans()[0] }
    }
    impl std::default::Default for For {
        fn default() -> Self {
            For { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for For {}
    #[cfg(feature = "clone-impls")]
    impl Clone for For {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for For {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("For")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for For {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for For {
        fn eq(&self, _other: &For) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for For {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for For {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("for", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for For {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(For {
                span: parsing::keyword(input, "for")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for For {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "for")
        }
        fn display() -> &'static str {
            "`for`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for For {}
    pub struct If {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn If<S: IntoSpans<[Span; 1]>>(span: S) -> If {
        If { span: span.into_spans()[0] }
    }
    impl std::default::Default for If {
        fn default() -> Self {
            If { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for If {}
    #[cfg(feature = "clone-impls")]
    impl Clone for If {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for If {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("If")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for If {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for If {
        fn eq(&self, _other: &If) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for If {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for If {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("if", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for If {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(If {
                span: parsing::keyword(input, "if")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for If {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "if")
        }
        fn display() -> &'static str {
            "`if`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for If {}
    pub struct Impl {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Impl<S: IntoSpans<[Span; 1]>>(span: S) -> Impl {
        Impl { span: span.into_spans()[0] }
    }
    impl std::default::Default for Impl {
        fn default() -> Self {
            Impl { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Impl {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Impl {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Impl {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Impl")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Impl {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Impl {
        fn eq(&self, _other: &Impl) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Impl {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Impl {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("impl", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Impl {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Impl {
                span: parsing::keyword(input, "impl")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Impl {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "impl")
        }
        fn display() -> &'static str {
            "`impl`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Impl {}
    pub struct In {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn In<S: IntoSpans<[Span; 1]>>(span: S) -> In {
        In { span: span.into_spans()[0] }
    }
    impl std::default::Default for In {
        fn default() -> Self {
            In { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for In {}
    #[cfg(feature = "clone-impls")]
    impl Clone for In {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for In {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("In")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for In {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for In {
        fn eq(&self, _other: &In) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for In {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for In {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("in", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for In {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(In {
                span: parsing::keyword(input, "in")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for In {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "in")
        }
        fn display() -> &'static str {
            "`in`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for In {}
    pub struct Let {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Let<S: IntoSpans<[Span; 1]>>(span: S) -> Let {
        Let { span: span.into_spans()[0] }
    }
    impl std::default::Default for Let {
        fn default() -> Self {
            Let { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Let {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Let {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Let {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Let")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Let {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Let {
        fn eq(&self, _other: &Let) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Let {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Let {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("let", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Let {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Let {
                span: parsing::keyword(input, "let")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Let {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "let")
        }
        fn display() -> &'static str {
            "`let`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Let {}
    pub struct Loop {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Loop<S: IntoSpans<[Span; 1]>>(span: S) -> Loop {
        Loop { span: span.into_spans()[0] }
    }
    impl std::default::Default for Loop {
        fn default() -> Self {
            Loop { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Loop {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Loop {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Loop {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Loop")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Loop {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Loop {
        fn eq(&self, _other: &Loop) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Loop {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Loop {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("loop", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Loop {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Loop {
                span: parsing::keyword(input, "loop")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Loop {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "loop")
        }
        fn display() -> &'static str {
            "`loop`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Loop {}
    pub struct Macro {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Macro<S: IntoSpans<[Span; 1]>>(span: S) -> Macro {
        Macro {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Macro {
        fn default() -> Self {
            Macro { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Macro {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Macro {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Macro {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Macro")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Macro {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Macro {
        fn eq(&self, _other: &Macro) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Macro {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Macro {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("macro", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Macro {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Macro {
                span: parsing::keyword(input, "macro")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Macro {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "macro")
        }
        fn display() -> &'static str {
            "`macro`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Macro {}
    pub struct Match {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Match<S: IntoSpans<[Span; 1]>>(span: S) -> Match {
        Match {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Match {
        fn default() -> Self {
            Match { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Match {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Match {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Match {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Match")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Match {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Match {
        fn eq(&self, _other: &Match) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Match {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Match {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("match", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Match {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Match {
                span: parsing::keyword(input, "match")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Match {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "match")
        }
        fn display() -> &'static str {
            "`match`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Match {}
    pub struct Mod {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Mod<S: IntoSpans<[Span; 1]>>(span: S) -> Mod {
        Mod { span: span.into_spans()[0] }
    }
    impl std::default::Default for Mod {
        fn default() -> Self {
            Mod { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Mod {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Mod {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Mod {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Mod")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Mod {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Mod {
        fn eq(&self, _other: &Mod) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Mod {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Mod {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("mod", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Mod {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Mod {
                span: parsing::keyword(input, "mod")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Mod {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "mod")
        }
        fn display() -> &'static str {
            "`mod`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Mod {}
    pub struct Move {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Move<S: IntoSpans<[Span; 1]>>(span: S) -> Move {
        Move { span: span.into_spans()[0] }
    }
    impl std::default::Default for Move {
        fn default() -> Self {
            Move { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Move {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Move {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Move {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Move")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Move {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Move {
        fn eq(&self, _other: &Move) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Move {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Move {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("move", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Move {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Move {
                span: parsing::keyword(input, "move")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Move {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "move")
        }
        fn display() -> &'static str {
            "`move`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Move {}
    pub struct Mut {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Mut<S: IntoSpans<[Span; 1]>>(span: S) -> Mut {
        Mut { span: span.into_spans()[0] }
    }
    impl std::default::Default for Mut {
        fn default() -> Self {
            Mut { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Mut {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Mut {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Mut {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Mut")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Mut {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Mut {
        fn eq(&self, _other: &Mut) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Mut {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Mut {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("mut", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Mut {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Mut {
                span: parsing::keyword(input, "mut")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Mut {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "mut")
        }
        fn display() -> &'static str {
            "`mut`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Mut {}
    pub struct Override {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Override<S: IntoSpans<[Span; 1]>>(span: S) -> Override {
        Override {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Override {
        fn default() -> Self {
            Override {
                span: Span::call_site(),
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Override {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Override {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Override {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Override")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Override {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Override {
        fn eq(&self, _other: &Override) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Override {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Override {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("override", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Override {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Override {
                span: parsing::keyword(input, "override")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Override {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "override")
        }
        fn display() -> &'static str {
            "`override`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Override {}
    pub struct Priv {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Priv<S: IntoSpans<[Span; 1]>>(span: S) -> Priv {
        Priv { span: span.into_spans()[0] }
    }
    impl std::default::Default for Priv {
        fn default() -> Self {
            Priv { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Priv {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Priv {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Priv {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Priv")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Priv {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Priv {
        fn eq(&self, _other: &Priv) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Priv {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Priv {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("priv", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Priv {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Priv {
                span: parsing::keyword(input, "priv")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Priv {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "priv")
        }
        fn display() -> &'static str {
            "`priv`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Priv {}
    pub struct Pub {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Pub<S: IntoSpans<[Span; 1]>>(span: S) -> Pub {
        Pub { span: span.into_spans()[0] }
    }
    impl std::default::Default for Pub {
        fn default() -> Self {
            Pub { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Pub {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Pub {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Pub {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Pub")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Pub {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Pub {
        fn eq(&self, _other: &Pub) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Pub {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Pub {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("pub", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Pub {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Pub {
                span: parsing::keyword(input, "pub")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Pub {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "pub")
        }
        fn display() -> &'static str {
            "`pub`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Pub {}
    pub struct Ref {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Ref<S: IntoSpans<[Span; 1]>>(span: S) -> Ref {
        Ref { span: span.into_spans()[0] }
    }
    impl std::default::Default for Ref {
        fn default() -> Self {
            Ref { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Ref {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Ref {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Ref {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Ref")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Ref {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Ref {
        fn eq(&self, _other: &Ref) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Ref {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Ref {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("ref", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Ref {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Ref {
                span: parsing::keyword(input, "ref")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Ref {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "ref")
        }
        fn display() -> &'static str {
            "`ref`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Ref {}
    pub struct Return {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Return<S: IntoSpans<[Span; 1]>>(span: S) -> Return {
        Return {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Return {
        fn default() -> Self {
            Return { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Return {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Return {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Return {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Return")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Return {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Return {
        fn eq(&self, _other: &Return) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Return {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Return {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("return", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Return {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Return {
                span: parsing::keyword(input, "return")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Return {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "return")
        }
        fn display() -> &'static str {
            "`return`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Return {}
    pub struct SelfType {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn SelfType<S: IntoSpans<[Span; 1]>>(span: S) -> SelfType {
        SelfType {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for SelfType {
        fn default() -> Self {
            SelfType {
                span: Span::call_site(),
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for SelfType {}
    #[cfg(feature = "clone-impls")]
    impl Clone for SelfType {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for SelfType {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("SelfType")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for SelfType {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for SelfType {
        fn eq(&self, _other: &SelfType) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for SelfType {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for SelfType {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("Self", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for SelfType {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(SelfType {
                span: parsing::keyword(input, "Self")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for SelfType {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "Self")
        }
        fn display() -> &'static str {
            "`Self`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for SelfType {}
    pub struct SelfValue {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn SelfValue<S: IntoSpans<[Span; 1]>>(span: S) -> SelfValue {
        SelfValue {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for SelfValue {
        fn default() -> Self {
            SelfValue {
                span: Span::call_site(),
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for SelfValue {}
    #[cfg(feature = "clone-impls")]
    impl Clone for SelfValue {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for SelfValue {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("SelfValue")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for SelfValue {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for SelfValue {
        fn eq(&self, _other: &SelfValue) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for SelfValue {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for SelfValue {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("self", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for SelfValue {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(SelfValue {
                span: parsing::keyword(input, "self")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for SelfValue {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "self")
        }
        fn display() -> &'static str {
            "`self`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for SelfValue {}
    pub struct Static {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Static<S: IntoSpans<[Span; 1]>>(span: S) -> Static {
        Static {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Static {
        fn default() -> Self {
            Static { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Static {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Static {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Static {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Static")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Static {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Static {
        fn eq(&self, _other: &Static) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Static {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Static {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("static", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Static {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Static {
                span: parsing::keyword(input, "static")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Static {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "static")
        }
        fn display() -> &'static str {
            "`static`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Static {}
    pub struct Struct {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Struct<S: IntoSpans<[Span; 1]>>(span: S) -> Struct {
        Struct {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Struct {
        fn default() -> Self {
            Struct { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Struct {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Struct {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Struct {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Struct")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Struct {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Struct {
        fn eq(&self, _other: &Struct) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Struct {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Struct {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("struct", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Struct {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Struct {
                span: parsing::keyword(input, "struct")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Struct {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "struct")
        }
        fn display() -> &'static str {
            "`struct`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Struct {}
    pub struct Super {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Super<S: IntoSpans<[Span; 1]>>(span: S) -> Super {
        Super {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Super {
        fn default() -> Self {
            Super { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Super {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Super {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Super {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Super")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Super {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Super {
        fn eq(&self, _other: &Super) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Super {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Super {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("super", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Super {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Super {
                span: parsing::keyword(input, "super")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Super {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "super")
        }
        fn display() -> &'static str {
            "`super`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Super {}
    pub struct Trait {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Trait<S: IntoSpans<[Span; 1]>>(span: S) -> Trait {
        Trait {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Trait {
        fn default() -> Self {
            Trait { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Trait {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Trait {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Trait {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Trait")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Trait {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Trait {
        fn eq(&self, _other: &Trait) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Trait {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Trait {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("trait", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Trait {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Trait {
                span: parsing::keyword(input, "trait")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Trait {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "trait")
        }
        fn display() -> &'static str {
            "`trait`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Trait {}
    pub struct Try {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Try<S: IntoSpans<[Span; 1]>>(span: S) -> Try {
        Try { span: span.into_spans()[0] }
    }
    impl std::default::Default for Try {
        fn default() -> Self {
            Try { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Try {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Try {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Try {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Try")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Try {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Try {
        fn eq(&self, _other: &Try) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Try {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Try {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("try", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Try {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Try {
                span: parsing::keyword(input, "try")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Try {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "try")
        }
        fn display() -> &'static str {
            "`try`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Try {}
    pub struct Type {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Type<S: IntoSpans<[Span; 1]>>(span: S) -> Type {
        Type { span: span.into_spans()[0] }
    }
    impl std::default::Default for Type {
        fn default() -> Self {
            Type { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Type {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Type {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Type {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Type")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Type {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Type {
        fn eq(&self, _other: &Type) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Type {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Type {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("type", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Type {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Type {
                span: parsing::keyword(input, "type")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Type {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "type")
        }
        fn display() -> &'static str {
            "`type`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Type {}
    pub struct Typeof {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Typeof<S: IntoSpans<[Span; 1]>>(span: S) -> Typeof {
        Typeof {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Typeof {
        fn default() -> Self {
            Typeof { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Typeof {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Typeof {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Typeof {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Typeof")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Typeof {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Typeof {
        fn eq(&self, _other: &Typeof) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Typeof {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Typeof {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("typeof", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Typeof {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Typeof {
                span: parsing::keyword(input, "typeof")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Typeof {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "typeof")
        }
        fn display() -> &'static str {
            "`typeof`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Typeof {}
    pub struct Union {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Union<S: IntoSpans<[Span; 1]>>(span: S) -> Union {
        Union {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Union {
        fn default() -> Self {
            Union { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Union {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Union {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Union {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Union")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Union {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Union {
        fn eq(&self, _other: &Union) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Union {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Union {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("union", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Union {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Union {
                span: parsing::keyword(input, "union")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Union {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "union")
        }
        fn display() -> &'static str {
            "`union`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Union {}
    pub struct Unsafe {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Unsafe<S: IntoSpans<[Span; 1]>>(span: S) -> Unsafe {
        Unsafe {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Unsafe {
        fn default() -> Self {
            Unsafe { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Unsafe {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Unsafe {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Unsafe {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Unsafe")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Unsafe {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Unsafe {
        fn eq(&self, _other: &Unsafe) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Unsafe {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Unsafe {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("unsafe", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Unsafe {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Unsafe {
                span: parsing::keyword(input, "unsafe")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Unsafe {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "unsafe")
        }
        fn display() -> &'static str {
            "`unsafe`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Unsafe {}
    pub struct Unsized {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Unsized<S: IntoSpans<[Span; 1]>>(span: S) -> Unsized {
        Unsized {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Unsized {
        fn default() -> Self {
            Unsized { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Unsized {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Unsized {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Unsized {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Unsized")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Unsized {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Unsized {
        fn eq(&self, _other: &Unsized) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Unsized {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Unsized {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("unsized", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Unsized {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Unsized {
                span: parsing::keyword(input, "unsized")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Unsized {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "unsized")
        }
        fn display() -> &'static str {
            "`unsized`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Unsized {}
    pub struct Use {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Use<S: IntoSpans<[Span; 1]>>(span: S) -> Use {
        Use { span: span.into_spans()[0] }
    }
    impl std::default::Default for Use {
        fn default() -> Self {
            Use { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Use {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Use {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Use {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Use")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Use {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Use {
        fn eq(&self, _other: &Use) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Use {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Use {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("use", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Use {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Use {
                span: parsing::keyword(input, "use")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Use {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "use")
        }
        fn display() -> &'static str {
            "`use`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Use {}
    pub struct Virtual {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Virtual<S: IntoSpans<[Span; 1]>>(span: S) -> Virtual {
        Virtual {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Virtual {
        fn default() -> Self {
            Virtual { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Virtual {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Virtual {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Virtual {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Virtual")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Virtual {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Virtual {
        fn eq(&self, _other: &Virtual) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Virtual {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Virtual {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("virtual", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Virtual {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Virtual {
                span: parsing::keyword(input, "virtual")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Virtual {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "virtual")
        }
        fn display() -> &'static str {
            "`virtual`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Virtual {}
    pub struct Where {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Where<S: IntoSpans<[Span; 1]>>(span: S) -> Where {
        Where {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Where {
        fn default() -> Self {
            Where { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Where {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Where {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Where {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Where")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Where {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Where {
        fn eq(&self, _other: &Where) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Where {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Where {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("where", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Where {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Where {
                span: parsing::keyword(input, "where")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Where {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "where")
        }
        fn display() -> &'static str {
            "`where`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Where {}
    pub struct While {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn While<S: IntoSpans<[Span; 1]>>(span: S) -> While {
        While {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for While {
        fn default() -> Self {
            While { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for While {}
    #[cfg(feature = "clone-impls")]
    impl Clone for While {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for While {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("While")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for While {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for While {
        fn eq(&self, _other: &While) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for While {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for While {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("while", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for While {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(While {
                span: parsing::keyword(input, "while")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for While {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "while")
        }
        fn display() -> &'static str {
            "`while`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for While {}
    pub struct Yield {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Yield<S: IntoSpans<[Span; 1]>>(span: S) -> Yield {
        Yield {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Yield {
        fn default() -> Self {
            Yield { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Yield {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Yield {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Yield {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Yield")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Yield {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Yield {
        fn eq(&self, _other: &Yield) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Yield {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Yield {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::keyword("yield", self.span, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Yield {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Yield {
                span: parsing::keyword(input, "yield")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Yield {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_keyword(cursor, "yield")
        }
        fn display() -> &'static str {
            "`yield`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Yield {}
    #[repr(C)]
    pub struct Add {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Add<S: IntoSpans<[Span; 1]>>(spans: S) -> Add {
        Add { spans: spans.into_spans() }
    }
    impl std::default::Default for Add {
        fn default() -> Self {
            Add {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Add {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Add {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Add {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Add")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Add {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Add {
        fn eq(&self, _other: &Add) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Add {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Add {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Add {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Add {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("+", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Add {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Add {
                spans: parsing::punct(input, "+")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Add {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "+")
        }
        fn display() -> &'static str {
            "`+`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Add {}
    #[repr(C)]
    pub struct AddEq {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn AddEq<S: IntoSpans<[Span; 2]>>(spans: S) -> AddEq {
        AddEq { spans: spans.into_spans() }
    }
    impl std::default::Default for AddEq {
        fn default() -> Self {
            AddEq {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for AddEq {}
    #[cfg(feature = "clone-impls")]
    impl Clone for AddEq {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for AddEq {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("AddEq")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for AddEq {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for AddEq {
        fn eq(&self, _other: &AddEq) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for AddEq {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for AddEq {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("+=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for AddEq {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(AddEq {
                spans: parsing::punct(input, "+=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for AddEq {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "+=")
        }
        fn display() -> &'static str {
            "`+=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for AddEq {}
    #[repr(C)]
    pub struct And {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn And<S: IntoSpans<[Span; 1]>>(spans: S) -> And {
        And { spans: spans.into_spans() }
    }
    impl std::default::Default for And {
        fn default() -> Self {
            And {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for And {}
    #[cfg(feature = "clone-impls")]
    impl Clone for And {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for And {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("And")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for And {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for And {
        fn eq(&self, _other: &And) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for And {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for And {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for And {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for And {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("&", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for And {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(And {
                spans: parsing::punct(input, "&")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for And {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "&")
        }
        fn display() -> &'static str {
            "`&`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for And {}
    #[repr(C)]
    pub struct AndAnd {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn AndAnd<S: IntoSpans<[Span; 2]>>(spans: S) -> AndAnd {
        AndAnd {
            spans: spans.into_spans(),
        }
    }
    impl std::default::Default for AndAnd {
        fn default() -> Self {
            AndAnd {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for AndAnd {}
    #[cfg(feature = "clone-impls")]
    impl Clone for AndAnd {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for AndAnd {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("AndAnd")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for AndAnd {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for AndAnd {
        fn eq(&self, _other: &AndAnd) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for AndAnd {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for AndAnd {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("&&", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for AndAnd {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(AndAnd {
                spans: parsing::punct(input, "&&")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for AndAnd {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "&&")
        }
        fn display() -> &'static str {
            "`&&`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for AndAnd {}
    #[repr(C)]
    pub struct AndEq {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn AndEq<S: IntoSpans<[Span; 2]>>(spans: S) -> AndEq {
        AndEq { spans: spans.into_spans() }
    }
    impl std::default::Default for AndEq {
        fn default() -> Self {
            AndEq {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for AndEq {}
    #[cfg(feature = "clone-impls")]
    impl Clone for AndEq {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for AndEq {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("AndEq")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for AndEq {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for AndEq {
        fn eq(&self, _other: &AndEq) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for AndEq {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for AndEq {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("&=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for AndEq {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(AndEq {
                spans: parsing::punct(input, "&=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for AndEq {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "&=")
        }
        fn display() -> &'static str {
            "`&=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for AndEq {}
    #[repr(C)]
    pub struct At {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn At<S: IntoSpans<[Span; 1]>>(spans: S) -> At {
        At { spans: spans.into_spans() }
    }
    impl std::default::Default for At {
        fn default() -> Self {
            At {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for At {}
    #[cfg(feature = "clone-impls")]
    impl Clone for At {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for At {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("At")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for At {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for At {
        fn eq(&self, _other: &At) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for At {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for At {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for At {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for At {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("@", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for At {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(At {
                spans: parsing::punct(input, "@")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for At {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "@")
        }
        fn display() -> &'static str {
            "`@`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for At {}
    #[repr(C)]
    pub struct Bang {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Bang<S: IntoSpans<[Span; 1]>>(spans: S) -> Bang {
        Bang { spans: spans.into_spans() }
    }
    impl std::default::Default for Bang {
        fn default() -> Self {
            Bang {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Bang {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Bang {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Bang {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Bang")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Bang {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Bang {
        fn eq(&self, _other: &Bang) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Bang {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Bang {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Bang {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Bang {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("!", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Bang {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Bang {
                spans: parsing::punct(input, "!")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Bang {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "!")
        }
        fn display() -> &'static str {
            "`!`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Bang {}
    #[repr(C)]
    pub struct Caret {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Caret<S: IntoSpans<[Span; 1]>>(spans: S) -> Caret {
        Caret { spans: spans.into_spans() }
    }
    impl std::default::Default for Caret {
        fn default() -> Self {
            Caret {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Caret {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Caret {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Caret {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Caret")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Caret {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Caret {
        fn eq(&self, _other: &Caret) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Caret {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Caret {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Caret {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Caret {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("^", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Caret {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Caret {
                spans: parsing::punct(input, "^")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Caret {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "^")
        }
        fn display() -> &'static str {
            "`^`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Caret {}
    #[repr(C)]
    pub struct CaretEq {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn CaretEq<S: IntoSpans<[Span; 2]>>(spans: S) -> CaretEq {
        CaretEq {
            spans: spans.into_spans(),
        }
    }
    impl std::default::Default for CaretEq {
        fn default() -> Self {
            CaretEq {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for CaretEq {}
    #[cfg(feature = "clone-impls")]
    impl Clone for CaretEq {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for CaretEq {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("CaretEq")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for CaretEq {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for CaretEq {
        fn eq(&self, _other: &CaretEq) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for CaretEq {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for CaretEq {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("^=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for CaretEq {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(CaretEq {
                spans: parsing::punct(input, "^=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for CaretEq {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "^=")
        }
        fn display() -> &'static str {
            "`^=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for CaretEq {}
    #[repr(C)]
    pub struct Colon {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Colon<S: IntoSpans<[Span; 1]>>(spans: S) -> Colon {
        Colon { spans: spans.into_spans() }
    }
    impl std::default::Default for Colon {
        fn default() -> Self {
            Colon {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Colon {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Colon {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Colon {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Colon")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Colon {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Colon {
        fn eq(&self, _other: &Colon) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Colon {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Colon {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Colon {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Colon {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct(":", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Colon {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Colon {
                spans: parsing::punct(input, ":")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Colon {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, ":")
        }
        fn display() -> &'static str {
            "`:`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Colon {}
    #[repr(C)]
    pub struct Colon2 {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Colon2<S: IntoSpans<[Span; 2]>>(spans: S) -> Colon2 {
        Colon2 {
            spans: spans.into_spans(),
        }
    }
    impl std::default::Default for Colon2 {
        fn default() -> Self {
            Colon2 {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Colon2 {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Colon2 {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Colon2 {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Colon2")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Colon2 {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Colon2 {
        fn eq(&self, _other: &Colon2) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Colon2 {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Colon2 {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("::", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Colon2 {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Colon2 {
                spans: parsing::punct(input, "::")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Colon2 {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "::")
        }
        fn display() -> &'static str {
            "`::`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Colon2 {}
    #[repr(C)]
    pub struct Comma {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Comma<S: IntoSpans<[Span; 1]>>(spans: S) -> Comma {
        Comma { spans: spans.into_spans() }
    }
    impl std::default::Default for Comma {
        fn default() -> Self {
            Comma {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Comma {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Comma {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Comma {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Comma")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Comma {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Comma {
        fn eq(&self, _other: &Comma) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Comma {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Comma {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Comma {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Comma {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct(",", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Comma {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Comma {
                spans: parsing::punct(input, ",")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Comma {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, ",")
        }
        fn display() -> &'static str {
            "`,`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Comma {}
    #[repr(C)]
    pub struct Div {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Div<S: IntoSpans<[Span; 1]>>(spans: S) -> Div {
        Div { spans: spans.into_spans() }
    }
    impl std::default::Default for Div {
        fn default() -> Self {
            Div {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Div {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Div {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Div {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Div")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Div {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Div {
        fn eq(&self, _other: &Div) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Div {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Div {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Div {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Div {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("/", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Div {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Div {
                spans: parsing::punct(input, "/")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Div {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "/")
        }
        fn display() -> &'static str {
            "`/`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Div {}
    #[repr(C)]
    pub struct DivEq {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn DivEq<S: IntoSpans<[Span; 2]>>(spans: S) -> DivEq {
        DivEq { spans: spans.into_spans() }
    }
    impl std::default::Default for DivEq {
        fn default() -> Self {
            DivEq {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for DivEq {}
    #[cfg(feature = "clone-impls")]
    impl Clone for DivEq {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for DivEq {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("DivEq")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for DivEq {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for DivEq {
        fn eq(&self, _other: &DivEq) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for DivEq {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for DivEq {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("/=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for DivEq {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(DivEq {
                spans: parsing::punct(input, "/=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for DivEq {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "/=")
        }
        fn display() -> &'static str {
            "`/=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for DivEq {}
    #[repr(C)]
    pub struct Dollar {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Dollar<S: IntoSpans<[Span; 1]>>(spans: S) -> Dollar {
        Dollar {
            spans: spans.into_spans(),
        }
    }
    impl std::default::Default for Dollar {
        fn default() -> Self {
            Dollar {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Dollar {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Dollar {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Dollar {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Dollar")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Dollar {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Dollar {
        fn eq(&self, _other: &Dollar) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Dollar {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Dollar {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Dollar {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Dollar {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("$", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Dollar {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Dollar {
                spans: parsing::punct(input, "$")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Dollar {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "$")
        }
        fn display() -> &'static str {
            "`$`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Dollar {}
    #[repr(C)]
    pub struct Dot {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Dot<S: IntoSpans<[Span; 1]>>(spans: S) -> Dot {
        Dot { spans: spans.into_spans() }
    }
    impl std::default::Default for Dot {
        fn default() -> Self {
            Dot {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Dot {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Dot {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Dot {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Dot")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Dot {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Dot {
        fn eq(&self, _other: &Dot) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Dot {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Dot {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Dot {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Dot {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct(".", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Dot {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Dot {
                spans: parsing::punct(input, ".")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Dot {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, ".")
        }
        fn display() -> &'static str {
            "`.`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Dot {}
    #[repr(C)]
    pub struct Dot2 {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Dot2<S: IntoSpans<[Span; 2]>>(spans: S) -> Dot2 {
        Dot2 { spans: spans.into_spans() }
    }
    impl std::default::Default for Dot2 {
        fn default() -> Self {
            Dot2 {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Dot2 {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Dot2 {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Dot2 {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Dot2")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Dot2 {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Dot2 {
        fn eq(&self, _other: &Dot2) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Dot2 {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Dot2 {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("..", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Dot2 {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Dot2 {
                spans: parsing::punct(input, "..")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Dot2 {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "..")
        }
        fn display() -> &'static str {
            "`..`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Dot2 {}
    #[repr(C)]
    pub struct Dot3 {
        pub spans: [Span; 3],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Dot3<S: IntoSpans<[Span; 3]>>(spans: S) -> Dot3 {
        Dot3 { spans: spans.into_spans() }
    }
    impl std::default::Default for Dot3 {
        fn default() -> Self {
            Dot3 {
                spans: [Span::call_site(); 3],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Dot3 {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Dot3 {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Dot3 {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Dot3")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Dot3 {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Dot3 {
        fn eq(&self, _other: &Dot3) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Dot3 {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Dot3 {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("...", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Dot3 {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Dot3 {
                spans: parsing::punct(input, "...")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Dot3 {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "...")
        }
        fn display() -> &'static str {
            "`...`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Dot3 {}
    #[repr(C)]
    pub struct DotDotEq {
        pub spans: [Span; 3],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn DotDotEq<S: IntoSpans<[Span; 3]>>(spans: S) -> DotDotEq {
        DotDotEq {
            spans: spans.into_spans(),
        }
    }
    impl std::default::Default for DotDotEq {
        fn default() -> Self {
            DotDotEq {
                spans: [Span::call_site(); 3],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for DotDotEq {}
    #[cfg(feature = "clone-impls")]
    impl Clone for DotDotEq {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for DotDotEq {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("DotDotEq")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for DotDotEq {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for DotDotEq {
        fn eq(&self, _other: &DotDotEq) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for DotDotEq {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for DotDotEq {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("..=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for DotDotEq {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(DotDotEq {
                spans: parsing::punct(input, "..=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for DotDotEq {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "..=")
        }
        fn display() -> &'static str {
            "`..=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for DotDotEq {}
    #[repr(C)]
    pub struct Eq {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Eq<S: IntoSpans<[Span; 1]>>(spans: S) -> Eq {
        Eq { spans: spans.into_spans() }
    }
    impl std::default::Default for Eq {
        fn default() -> Self {
            Eq {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Eq {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Eq {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Eq {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Eq")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Eq {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Eq {
        fn eq(&self, _other: &Eq) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Eq {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Eq {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Eq {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Eq {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Eq {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Eq {
                spans: parsing::punct(input, "=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Eq {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "=")
        }
        fn display() -> &'static str {
            "`=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Eq {}
    #[repr(C)]
    pub struct EqEq {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn EqEq<S: IntoSpans<[Span; 2]>>(spans: S) -> EqEq {
        EqEq { spans: spans.into_spans() }
    }
    impl std::default::Default for EqEq {
        fn default() -> Self {
            EqEq {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for EqEq {}
    #[cfg(feature = "clone-impls")]
    impl Clone for EqEq {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for EqEq {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("EqEq")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for EqEq {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for EqEq {
        fn eq(&self, _other: &EqEq) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for EqEq {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for EqEq {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("==", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for EqEq {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(EqEq {
                spans: parsing::punct(input, "==")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for EqEq {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "==")
        }
        fn display() -> &'static str {
            "`==`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for EqEq {}
    #[repr(C)]
    pub struct Ge {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Ge<S: IntoSpans<[Span; 2]>>(spans: S) -> Ge {
        Ge { spans: spans.into_spans() }
    }
    impl std::default::Default for Ge {
        fn default() -> Self {
            Ge {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Ge {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Ge {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Ge {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Ge")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Ge {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Ge {
        fn eq(&self, _other: &Ge) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Ge {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Ge {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct(">=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Ge {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Ge {
                spans: parsing::punct(input, ">=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Ge {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, ">=")
        }
        fn display() -> &'static str {
            "`>=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Ge {}
    #[repr(C)]
    pub struct Gt {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Gt<S: IntoSpans<[Span; 1]>>(spans: S) -> Gt {
        Gt { spans: spans.into_spans() }
    }
    impl std::default::Default for Gt {
        fn default() -> Self {
            Gt {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Gt {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Gt {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Gt {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Gt")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Gt {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Gt {
        fn eq(&self, _other: &Gt) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Gt {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Gt {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Gt {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Gt {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct(">", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Gt {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Gt {
                spans: parsing::punct(input, ">")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Gt {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, ">")
        }
        fn display() -> &'static str {
            "`>`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Gt {}
    #[repr(C)]
    pub struct Le {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Le<S: IntoSpans<[Span; 2]>>(spans: S) -> Le {
        Le { spans: spans.into_spans() }
    }
    impl std::default::Default for Le {
        fn default() -> Self {
            Le {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Le {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Le {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Le {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Le")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Le {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Le {
        fn eq(&self, _other: &Le) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Le {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Le {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("<=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Le {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Le {
                spans: parsing::punct(input, "<=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Le {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "<=")
        }
        fn display() -> &'static str {
            "`<=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Le {}
    #[repr(C)]
    pub struct Lt {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Lt<S: IntoSpans<[Span; 1]>>(spans: S) -> Lt {
        Lt { spans: spans.into_spans() }
    }
    impl std::default::Default for Lt {
        fn default() -> Self {
            Lt {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Lt {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Lt {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Lt {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Lt")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Lt {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Lt {
        fn eq(&self, _other: &Lt) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Lt {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Lt {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Lt {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Lt {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("<", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Lt {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Lt {
                spans: parsing::punct(input, "<")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Lt {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "<")
        }
        fn display() -> &'static str {
            "`<`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Lt {}
    #[repr(C)]
    pub struct MulEq {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn MulEq<S: IntoSpans<[Span; 2]>>(spans: S) -> MulEq {
        MulEq { spans: spans.into_spans() }
    }
    impl std::default::Default for MulEq {
        fn default() -> Self {
            MulEq {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for MulEq {}
    #[cfg(feature = "clone-impls")]
    impl Clone for MulEq {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for MulEq {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("MulEq")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for MulEq {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for MulEq {
        fn eq(&self, _other: &MulEq) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for MulEq {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for MulEq {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("*=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for MulEq {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(MulEq {
                spans: parsing::punct(input, "*=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for MulEq {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "*=")
        }
        fn display() -> &'static str {
            "`*=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for MulEq {}
    #[repr(C)]
    pub struct Ne {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Ne<S: IntoSpans<[Span; 2]>>(spans: S) -> Ne {
        Ne { spans: spans.into_spans() }
    }
    impl std::default::Default for Ne {
        fn default() -> Self {
            Ne {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Ne {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Ne {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Ne {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Ne")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Ne {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Ne {
        fn eq(&self, _other: &Ne) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Ne {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Ne {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("!=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Ne {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Ne {
                spans: parsing::punct(input, "!=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Ne {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "!=")
        }
        fn display() -> &'static str {
            "`!=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Ne {}
    #[repr(C)]
    pub struct Or {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Or<S: IntoSpans<[Span; 1]>>(spans: S) -> Or {
        Or { spans: spans.into_spans() }
    }
    impl std::default::Default for Or {
        fn default() -> Self {
            Or {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Or {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Or {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Or {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Or")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Or {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Or {
        fn eq(&self, _other: &Or) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Or {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Or {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Or {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Or {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("|", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Or {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Or {
                spans: parsing::punct(input, "|")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Or {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "|")
        }
        fn display() -> &'static str {
            "`|`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Or {}
    #[repr(C)]
    pub struct OrEq {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn OrEq<S: IntoSpans<[Span; 2]>>(spans: S) -> OrEq {
        OrEq { spans: spans.into_spans() }
    }
    impl std::default::Default for OrEq {
        fn default() -> Self {
            OrEq {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for OrEq {}
    #[cfg(feature = "clone-impls")]
    impl Clone for OrEq {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for OrEq {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("OrEq")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for OrEq {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for OrEq {
        fn eq(&self, _other: &OrEq) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for OrEq {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for OrEq {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("|=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for OrEq {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(OrEq {
                spans: parsing::punct(input, "|=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for OrEq {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "|=")
        }
        fn display() -> &'static str {
            "`|=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for OrEq {}
    #[repr(C)]
    pub struct OrOr {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn OrOr<S: IntoSpans<[Span; 2]>>(spans: S) -> OrOr {
        OrOr { spans: spans.into_spans() }
    }
    impl std::default::Default for OrOr {
        fn default() -> Self {
            OrOr {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for OrOr {}
    #[cfg(feature = "clone-impls")]
    impl Clone for OrOr {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for OrOr {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("OrOr")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for OrOr {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for OrOr {
        fn eq(&self, _other: &OrOr) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for OrOr {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for OrOr {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("||", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for OrOr {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(OrOr {
                spans: parsing::punct(input, "||")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for OrOr {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "||")
        }
        fn display() -> &'static str {
            "`||`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for OrOr {}
    #[repr(C)]
    pub struct Pound {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Pound<S: IntoSpans<[Span; 1]>>(spans: S) -> Pound {
        Pound { spans: spans.into_spans() }
    }
    impl std::default::Default for Pound {
        fn default() -> Self {
            Pound {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Pound {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Pound {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Pound {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Pound")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Pound {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Pound {
        fn eq(&self, _other: &Pound) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Pound {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Pound {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Pound {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Pound {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("#", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Pound {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Pound {
                spans: parsing::punct(input, "#")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Pound {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "#")
        }
        fn display() -> &'static str {
            "`#`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Pound {}
    #[repr(C)]
    pub struct Question {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Question<S: IntoSpans<[Span; 1]>>(spans: S) -> Question {
        Question {
            spans: spans.into_spans(),
        }
    }
    impl std::default::Default for Question {
        fn default() -> Self {
            Question {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Question {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Question {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Question {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Question")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Question {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Question {
        fn eq(&self, _other: &Question) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Question {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Question {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Question {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Question {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("?", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Question {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Question {
                spans: parsing::punct(input, "?")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Question {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "?")
        }
        fn display() -> &'static str {
            "`?`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Question {}
    #[repr(C)]
    pub struct RArrow {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn RArrow<S: IntoSpans<[Span; 2]>>(spans: S) -> RArrow {
        RArrow {
            spans: spans.into_spans(),
        }
    }
    impl std::default::Default for RArrow {
        fn default() -> Self {
            RArrow {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for RArrow {}
    #[cfg(feature = "clone-impls")]
    impl Clone for RArrow {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for RArrow {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("RArrow")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for RArrow {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for RArrow {
        fn eq(&self, _other: &RArrow) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for RArrow {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for RArrow {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("->", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for RArrow {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(RArrow {
                spans: parsing::punct(input, "->")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for RArrow {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "->")
        }
        fn display() -> &'static str {
            "`->`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for RArrow {}
    #[repr(C)]
    pub struct LArrow {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn LArrow<S: IntoSpans<[Span; 2]>>(spans: S) -> LArrow {
        LArrow {
            spans: spans.into_spans(),
        }
    }
    impl std::default::Default for LArrow {
        fn default() -> Self {
            LArrow {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for LArrow {}
    #[cfg(feature = "clone-impls")]
    impl Clone for LArrow {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for LArrow {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("LArrow")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for LArrow {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for LArrow {
        fn eq(&self, _other: &LArrow) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for LArrow {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for LArrow {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("<-", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for LArrow {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(LArrow {
                spans: parsing::punct(input, "<-")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for LArrow {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "<-")
        }
        fn display() -> &'static str {
            "`<-`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for LArrow {}
    #[repr(C)]
    pub struct Rem {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Rem<S: IntoSpans<[Span; 1]>>(spans: S) -> Rem {
        Rem { spans: spans.into_spans() }
    }
    impl std::default::Default for Rem {
        fn default() -> Self {
            Rem {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Rem {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Rem {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Rem {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Rem")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Rem {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Rem {
        fn eq(&self, _other: &Rem) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Rem {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Rem {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Rem {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Rem {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("%", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Rem {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Rem {
                spans: parsing::punct(input, "%")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Rem {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "%")
        }
        fn display() -> &'static str {
            "`%`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Rem {}
    #[repr(C)]
    pub struct RemEq {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn RemEq<S: IntoSpans<[Span; 2]>>(spans: S) -> RemEq {
        RemEq { spans: spans.into_spans() }
    }
    impl std::default::Default for RemEq {
        fn default() -> Self {
            RemEq {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for RemEq {}
    #[cfg(feature = "clone-impls")]
    impl Clone for RemEq {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for RemEq {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("RemEq")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for RemEq {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for RemEq {
        fn eq(&self, _other: &RemEq) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for RemEq {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for RemEq {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("%=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for RemEq {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(RemEq {
                spans: parsing::punct(input, "%=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for RemEq {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "%=")
        }
        fn display() -> &'static str {
            "`%=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for RemEq {}
    #[repr(C)]
    pub struct FatArrow {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn FatArrow<S: IntoSpans<[Span; 2]>>(spans: S) -> FatArrow {
        FatArrow {
            spans: spans.into_spans(),
        }
    }
    impl std::default::Default for FatArrow {
        fn default() -> Self {
            FatArrow {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for FatArrow {}
    #[cfg(feature = "clone-impls")]
    impl Clone for FatArrow {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for FatArrow {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("FatArrow")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for FatArrow {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for FatArrow {
        fn eq(&self, _other: &FatArrow) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for FatArrow {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for FatArrow {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("=>", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for FatArrow {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(FatArrow {
                spans: parsing::punct(input, "=>")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for FatArrow {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "=>")
        }
        fn display() -> &'static str {
            "`=>`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for FatArrow {}
    #[repr(C)]
    pub struct Semi {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Semi<S: IntoSpans<[Span; 1]>>(spans: S) -> Semi {
        Semi { spans: spans.into_spans() }
    }
    impl std::default::Default for Semi {
        fn default() -> Self {
            Semi {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Semi {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Semi {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Semi {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Semi")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Semi {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Semi {
        fn eq(&self, _other: &Semi) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Semi {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Semi {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Semi {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Semi {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct(";", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Semi {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Semi {
                spans: parsing::punct(input, ";")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Semi {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, ";")
        }
        fn display() -> &'static str {
            "`;`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Semi {}
    #[repr(C)]
    pub struct Shl {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Shl<S: IntoSpans<[Span; 2]>>(spans: S) -> Shl {
        Shl { spans: spans.into_spans() }
    }
    impl std::default::Default for Shl {
        fn default() -> Self {
            Shl {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Shl {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Shl {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Shl {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Shl")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Shl {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Shl {
        fn eq(&self, _other: &Shl) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Shl {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Shl {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("<<", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Shl {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Shl {
                spans: parsing::punct(input, "<<")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Shl {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "<<")
        }
        fn display() -> &'static str {
            "`<<`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Shl {}
    #[repr(C)]
    pub struct ShlEq {
        pub spans: [Span; 3],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn ShlEq<S: IntoSpans<[Span; 3]>>(spans: S) -> ShlEq {
        ShlEq { spans: spans.into_spans() }
    }
    impl std::default::Default for ShlEq {
        fn default() -> Self {
            ShlEq {
                spans: [Span::call_site(); 3],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for ShlEq {}
    #[cfg(feature = "clone-impls")]
    impl Clone for ShlEq {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for ShlEq {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("ShlEq")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for ShlEq {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for ShlEq {
        fn eq(&self, _other: &ShlEq) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for ShlEq {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for ShlEq {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("<<=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for ShlEq {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(ShlEq {
                spans: parsing::punct(input, "<<=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for ShlEq {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "<<=")
        }
        fn display() -> &'static str {
            "`<<=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for ShlEq {}
    #[repr(C)]
    pub struct Shr {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Shr<S: IntoSpans<[Span; 2]>>(spans: S) -> Shr {
        Shr { spans: spans.into_spans() }
    }
    impl std::default::Default for Shr {
        fn default() -> Self {
            Shr {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Shr {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Shr {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Shr {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Shr")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Shr {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Shr {
        fn eq(&self, _other: &Shr) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Shr {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Shr {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct(">>", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Shr {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Shr {
                spans: parsing::punct(input, ">>")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Shr {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, ">>")
        }
        fn display() -> &'static str {
            "`>>`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Shr {}
    #[repr(C)]
    pub struct ShrEq {
        pub spans: [Span; 3],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn ShrEq<S: IntoSpans<[Span; 3]>>(spans: S) -> ShrEq {
        ShrEq { spans: spans.into_spans() }
    }
    impl std::default::Default for ShrEq {
        fn default() -> Self {
            ShrEq {
                spans: [Span::call_site(); 3],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for ShrEq {}
    #[cfg(feature = "clone-impls")]
    impl Clone for ShrEq {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for ShrEq {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("ShrEq")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for ShrEq {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for ShrEq {
        fn eq(&self, _other: &ShrEq) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for ShrEq {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for ShrEq {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct(">>=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for ShrEq {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(ShrEq {
                spans: parsing::punct(input, ">>=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for ShrEq {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, ">>=")
        }
        fn display() -> &'static str {
            "`>>=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for ShrEq {}
    #[repr(C)]
    pub struct Star {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Star<S: IntoSpans<[Span; 1]>>(spans: S) -> Star {
        Star { spans: spans.into_spans() }
    }
    impl std::default::Default for Star {
        fn default() -> Self {
            Star {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Star {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Star {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Star {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Star")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Star {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Star {
        fn eq(&self, _other: &Star) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Star {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Star {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Star {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Star {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("*", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Star {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Star {
                spans: parsing::punct(input, "*")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Star {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "*")
        }
        fn display() -> &'static str {
            "`*`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Star {}
    #[repr(C)]
    pub struct Sub {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Sub<S: IntoSpans<[Span; 1]>>(spans: S) -> Sub {
        Sub { spans: spans.into_spans() }
    }
    impl std::default::Default for Sub {
        fn default() -> Self {
            Sub {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Sub {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Sub {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Sub {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Sub")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Sub {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Sub {
        fn eq(&self, _other: &Sub) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Sub {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Sub {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Sub {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Sub {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("-", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Sub {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Sub {
                spans: parsing::punct(input, "-")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Sub {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "-")
        }
        fn display() -> &'static str {
            "`-`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Sub {}
    #[repr(C)]
    pub struct SubEq {
        pub spans: [Span; 2],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn SubEq<S: IntoSpans<[Span; 2]>>(spans: S) -> SubEq {
        SubEq { spans: spans.into_spans() }
    }
    impl std::default::Default for SubEq {
        fn default() -> Self {
            SubEq {
                spans: [Span::call_site(); 2],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for SubEq {}
    #[cfg(feature = "clone-impls")]
    impl Clone for SubEq {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for SubEq {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("SubEq")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for SubEq {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for SubEq {
        fn eq(&self, _other: &SubEq) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for SubEq {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    #[cfg(feature = "printing")]
    impl ToTokens for SubEq {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("-=", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for SubEq {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(SubEq {
                spans: parsing::punct(input, "-=")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for SubEq {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "-=")
        }
        fn display() -> &'static str {
            "`-=`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for SubEq {}
    #[repr(C)]
    pub struct Tilde {
        pub spans: [Span; 1],
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Tilde<S: IntoSpans<[Span; 1]>>(spans: S) -> Tilde {
        Tilde { spans: spans.into_spans() }
    }
    impl std::default::Default for Tilde {
        fn default() -> Self {
            Tilde {
                spans: [Span::call_site(); 1],
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Tilde {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Tilde {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Tilde {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Tilde")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Tilde {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Tilde {
        fn eq(&self, _other: &Tilde) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Tilde {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Deref for Tilde {
        type Target = WithSpan;
        fn deref(&self) -> &Self::Target {
            unsafe { &*(self as *const Self as *const WithSpan) }
        }
    }
    impl DerefMut for Tilde {
        fn deref_mut(&mut self) -> &mut Self::Target {
            unsafe { &mut *(self as *mut Self as *mut WithSpan) }
        }
    }
    #[cfg(feature = "printing")]
    impl ToTokens for Tilde {
        fn to_tokens(&self, tokens: &mut TokenStream) {
            printing::punct("~", &self.spans, tokens);
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Tilde {
        fn parse(input: ParseStream) -> Result<Self> {
            Ok(Tilde {
                spans: parsing::punct(input, "~")?,
            })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Tilde {
        fn peek(cursor: Cursor) -> bool {
            parsing::peek_punct(cursor, "~")
        }
        fn display() -> &'static str {
            "`~`"
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Tilde {}
    pub struct Brace {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Brace<S: IntoSpans<[Span; 1]>>(span: S) -> Brace {
        Brace {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Brace {
        fn default() -> Self {
            Brace { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Brace {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Brace {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Brace {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Brace")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Brace {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Brace {
        fn eq(&self, _other: &Brace) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Brace {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Brace {
        #[cfg(feature = "printing")]
        pub fn surround<F>(&self, tokens: &mut TokenStream, f: F)
        where
            F: FnOnce(&mut TokenStream),
        {
            printing::delim("{", self.span, tokens, f);
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Brace {}
    pub struct Bracket {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Bracket<S: IntoSpans<[Span; 1]>>(span: S) -> Bracket {
        Bracket {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Bracket {
        fn default() -> Self {
            Bracket { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Bracket {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Bracket {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Bracket {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Bracket")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Bracket {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Bracket {
        fn eq(&self, _other: &Bracket) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Bracket {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Bracket {
        #[cfg(feature = "printing")]
        pub fn surround<F>(&self, tokens: &mut TokenStream, f: F)
        where
            F: FnOnce(&mut TokenStream),
        {
            printing::delim("[", self.span, tokens, f);
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Bracket {}
    pub struct Paren {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Paren<S: IntoSpans<[Span; 1]>>(span: S) -> Paren {
        Paren {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Paren {
        fn default() -> Self {
            Paren { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Paren {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Paren {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Paren {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Paren")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Paren {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Paren {
        fn eq(&self, _other: &Paren) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Paren {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Paren {
        #[cfg(feature = "printing")]
        pub fn surround<F>(&self, tokens: &mut TokenStream, f: F)
        where
            F: FnOnce(&mut TokenStream),
        {
            printing::delim("(", self.span, tokens, f);
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Paren {}
    pub struct Group {
        pub span: Span,
    }
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Group<S: IntoSpans<[Span; 1]>>(span: S) -> Group {
        Group {
            span: span.into_spans()[0],
        }
    }
    impl std::default::Default for Group {
        fn default() -> Self {
            Group { span: Span::call_site() }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Copy for Group {}
    #[cfg(feature = "clone-impls")]
    impl Clone for Group {
        fn clone(&self) -> Self {
            *self
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Debug for Group {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            f.write_str("Group")
        }
    }
    #[cfg(feature = "extra-traits")]
    impl cmp::Eq for Group {}
    #[cfg(feature = "extra-traits")]
    impl PartialEq for Group {
        fn eq(&self, _other: &Group) -> bool {
            true
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for Group {
        fn hash<H: Hasher>(&self, _state: &mut H) {}
    }
    impl Group {
        #[cfg(feature = "printing")]
        pub fn surround<F>(&self, tokens: &mut TokenStream, f: F)
        where
            F: FnOnce(&mut TokenStream),
        {
            printing::delim(" ", self.span, tokens, f);
        }
    }
    #[cfg(feature = "parsing")]
    impl private::Sealed for Group {}
    #[doc(hidden)]
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use crate::buffer::Cursor;
        use crate::error::{Error, Result};
        use crate::parse::ParseStream;
        use crate::span::FromSpans;
        use proc_macro2::{Spacing, Span};
        pub fn keyword(input: ParseStream, token: &str) -> Result<Span> {
            input
                .step(|cursor| {
                    if let Some((ident, rest)) = cursor.ident() {
                        if ident == token {
                            return Ok((ident.span(), rest));
                        }
                    }
                    Err(
                        cursor
                            .error({
                                let res = ::alloc::fmt::format(
                                    ::core::fmt::Arguments::new_v1(
                                        &["expected `", "`"],
                                        &[::core::fmt::ArgumentV1::new_display(&token)],
                                    ),
                                );
                                res
                            }),
                    )
                })
        }
        pub fn peek_keyword(cursor: Cursor, token: &str) -> bool {
            if let Some((ident, _rest)) = cursor.ident() {
                ident == token
            } else {
                false
            }
        }
        pub fn punct<S: FromSpans>(input: ParseStream, token: &str) -> Result<S> {
            let mut spans = [input.span(); 3];
            punct_helper(input, token, &mut spans)?;
            Ok(S::from_spans(&spans))
        }
        fn punct_helper(
            input: ParseStream,
            token: &str,
            spans: &mut [Span; 3],
        ) -> Result<()> {
            input
                .step(|cursor| {
                    let mut cursor = *cursor;
                    if !(token.len() <= spans.len()) {
                        ::core::panicking::panic(
                            "assertion failed: token.len() <= spans.len()",
                        )
                    }
                    for (i, ch) in token.chars().enumerate() {
                        match cursor.punct() {
                            Some((punct, rest)) => {
                                spans[i] = punct.span();
                                if punct.as_char() != ch {
                                    break;
                                } else if i == token.len() - 1 {
                                    return Ok(((), rest));
                                } else if punct.spacing() != Spacing::Joint {
                                    break;
                                }
                                cursor = rest;
                            }
                            None => break,
                        }
                    }
                    Err(
                        Error::new(
                            spans[0],
                            {
                                let res = ::alloc::fmt::format(
                                    ::core::fmt::Arguments::new_v1(
                                        &["expected `", "`"],
                                        &[::core::fmt::ArgumentV1::new_display(&token)],
                                    ),
                                );
                                res
                            },
                        ),
                    )
                })
        }
        pub fn peek_punct(mut cursor: Cursor, token: &str) -> bool {
            for (i, ch) in token.chars().enumerate() {
                match cursor.punct() {
                    Some((punct, rest)) => {
                        if punct.as_char() != ch {
                            break;
                        } else if i == token.len() - 1 {
                            return true;
                        } else if punct.spacing() != Spacing::Joint {
                            break;
                        }
                        cursor = rest;
                    }
                    None => break,
                }
            }
            false
        }
    }
    #[doc(hidden)]
    #[cfg(feature = "printing")]
    pub mod printing {
        use proc_macro2::{Delimiter, Group, Ident, Punct, Spacing, Span, TokenStream};
        use quote::TokenStreamExt;
        pub fn punct(s: &str, spans: &[Span], tokens: &mut TokenStream) {
            match (&s.len(), &spans.len()) {
                (left_val, right_val) => {
                    if !(*left_val == *right_val) {
                        let kind = ::core::panicking::AssertKind::Eq;
                        ::core::panicking::assert_failed(
                            kind,
                            &*left_val,
                            &*right_val,
                            ::core::option::Option::None,
                        );
                    }
                }
            };
            let mut chars = s.chars();
            let mut spans = spans.iter();
            let ch = chars.next_back().unwrap();
            let span = spans.next_back().unwrap();
            for (ch, span) in chars.zip(spans) {
                let mut op = Punct::new(ch, Spacing::Joint);
                op.set_span(*span);
                tokens.append(op);
            }
            let mut op = Punct::new(ch, Spacing::Alone);
            op.set_span(*span);
            tokens.append(op);
        }
        pub fn keyword(s: &str, span: Span, tokens: &mut TokenStream) {
            tokens.append(Ident::new(s, span));
        }
        pub fn delim<F>(s: &str, span: Span, tokens: &mut TokenStream, f: F)
        where
            F: FnOnce(&mut TokenStream),
        {
            let delim = match s {
                "(" => Delimiter::Parenthesis,
                "[" => Delimiter::Bracket,
                "{" => Delimiter::Brace,
                " " => Delimiter::None,
                _ => {
                    ::std::rt::panic_fmt(
                        ::core::fmt::Arguments::new_v1(
                            &["unknown delimiter: "],
                            &[::core::fmt::ArgumentV1::new_display(&s)],
                        ),
                    )
                }
            };
            let mut inner = TokenStream::new();
            f(&mut inner);
            let mut g = Group::new(delim, inner);
            g.set_span(span);
            tokens.append(g);
        }
    }
}
mod ident {
    #[cfg(feature = "parsing")]
    use crate::buffer::Cursor;
    #[cfg(feature = "parsing")]
    use crate::lookahead;
    #[cfg(feature = "parsing")]
    use crate::parse::{Parse, ParseStream, Result};
    #[cfg(feature = "parsing")]
    use crate::token::Token;
    pub use proc_macro2::Ident;
    #[cfg(feature = "parsing")]
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Ident(marker: lookahead::TokenMarker) -> Ident {
        match marker {}
    }
    #[cfg(feature = "parsing")]
    fn accept_as_ident(ident: &Ident) -> bool {
        match ident.to_string().as_str() {
            "_" | "abstract" | "as" | "become" | "box" | "break" | "const" | "continue"
            | "crate" | "do" | "else" | "enum" | "extern" | "false" | "final" | "fn"
            | "for" | "if" | "impl" | "in" | "let" | "loop" | "macro" | "match" | "mod"
            | "move" | "mut" | "override" | "priv" | "pub" | "ref" | "return" | "Self"
            | "self" | "static" | "struct" | "super" | "trait" | "true" | "type"
            | "typeof" | "unsafe" | "unsized" | "use" | "virtual" | "where" | "while"
            | "yield" => false,
            _ => true,
        }
    }
    #[cfg(feature = "parsing")]
    impl Parse for Ident {
        fn parse(input: ParseStream) -> Result<Self> {
            input
                .step(|cursor| {
                    if let Some((ident, rest)) = cursor.ident() {
                        if accept_as_ident(&ident) {
                            return Ok((ident, rest));
                        }
                    }
                    Err(cursor.error("expected identifier"))
                })
        }
    }
    #[cfg(feature = "parsing")]
    impl Token for Ident {
        fn peek(cursor: Cursor) -> bool {
            if let Some((ident, _rest)) = cursor.ident() {
                accept_as_ident(&ident)
            } else {
                false
            }
        }
        fn display() -> &'static str {
            "identifier"
        }
    }
    impl From<crate::token::SelfValue> for Ident {
        fn from(token: crate::token::SelfValue) -> Ident {
            Ident::new("self", token.span)
        }
    }
    impl From<crate::token::SelfType> for Ident {
        fn from(token: crate::token::SelfType) -> Ident {
            Ident::new("Self", token.span)
        }
    }
    impl From<crate::token::Super> for Ident {
        fn from(token: crate::token::Super) -> Ident {
            Ident::new("super", token.span)
        }
    }
    impl From<crate::token::Crate> for Ident {
        fn from(token: crate::token::Crate) -> Ident {
            Ident::new("crate", token.span)
        }
    }
    impl From<crate::token::Extern> for Ident {
        fn from(token: crate::token::Extern) -> Ident {
            Ident::new("extern", token.span)
        }
    }
    impl From<crate::token::Underscore> for Ident {
        fn from(token: crate::token::Underscore) -> Ident {
            Ident::new("_", token.span)
        }
    }
    pub fn xid_ok(symbol: &str) -> bool {
        let mut chars = symbol.chars();
        let first = chars.next().unwrap();
        if !(first == '_' || unicode_ident::is_xid_start(first)) {
            return false;
        }
        for ch in chars {
            if !unicode_ident::is_xid_continue(ch) {
                return false;
            }
        }
        true
    }
}
pub use crate::ident::Ident;
#[cfg(any(feature = "full", feature = "derive"))]
mod attr {
    use super::*;
    use crate::punctuated::Punctuated;
    use proc_macro2::TokenStream;
    use std::iter;
    use std::slice;
    #[cfg(feature = "parsing")]
    use crate::parse::{Parse, ParseBuffer, ParseStream, Parser, Result};
    #[cfg(feature = "parsing")]
    use crate::punctuated::Pair;
    pub struct Attribute {
        pub pound_token: crate::token::Pound,
        pub style: AttrStyle,
        pub bracket_token: token::Bracket,
        pub path: Path,
        pub tokens: TokenStream,
    }
    impl Attribute {
        #[cfg(feature = "parsing")]
        pub fn parse_meta(&self) -> Result<Meta> {
            fn clone_ident_segment(segment: &PathSegment) -> PathSegment {
                PathSegment {
                    ident: segment.ident.clone(),
                    arguments: PathArguments::None,
                }
            }
            let path = Path {
                leading_colon: self
                    .path
                    .leading_colon
                    .as_ref()
                    .map(|colon| crate::token::Colon2(colon.spans)),
                segments: self
                    .path
                    .segments
                    .pairs()
                    .map(|pair| match pair {
                        Pair::Punctuated(seg, punct) => {
                            Pair::Punctuated(
                                clone_ident_segment(seg),
                                crate::token::Colon2(punct.spans),
                            )
                        }
                        Pair::End(seg) => Pair::End(clone_ident_segment(seg)),
                    })
                    .collect(),
            };
            let parser = |input: ParseStream| parsing::parse_meta_after_path(
                path,
                input,
            );
            parse::Parser::parse2(parser, self.tokens.clone())
        }
        #[cfg(feature = "parsing")]
        pub fn parse_args<T: Parse>(&self) -> Result<T> {
            self.parse_args_with(T::parse)
        }
        #[cfg(feature = "parsing")]
        pub fn parse_args_with<F: Parser>(&self, parser: F) -> Result<F::Output> {
            let parser = |input: ParseStream| {
                let args = enter_args(self, input)?;
                parse::parse_stream(parser, &args)
            };
            parser.parse2(self.tokens.clone())
        }
        #[cfg(feature = "parsing")]
        pub fn parse_outer(input: ParseStream) -> Result<Vec<Self>> {
            let mut attrs = Vec::new();
            while input.peek(crate::token::Pound) {
                attrs.push(input.call(parsing::single_parse_outer)?);
            }
            Ok(attrs)
        }
        #[cfg(feature = "parsing")]
        pub fn parse_inner(input: ParseStream) -> Result<Vec<Self>> {
            let mut attrs = Vec::new();
            parsing::parse_inner(input, &mut attrs)?;
            Ok(attrs)
        }
    }
    #[cfg(feature = "parsing")]
    fn expected_parentheses(attr: &Attribute) -> String {
        let style = match attr.style {
            AttrStyle::Outer => "#",
            AttrStyle::Inner(_) => "#!",
        };
        let mut path = String::new();
        for segment in &attr.path.segments {
            if !path.is_empty() || attr.path.leading_colon.is_some() {
                path += "::";
            }
            path += &segment.ident.to_string();
        }
        {
            let res = ::alloc::fmt::format(
                ::core::fmt::Arguments::new_v1(
                    &["", "[", "(...)]"],
                    &[
                        ::core::fmt::ArgumentV1::new_display(&style),
                        ::core::fmt::ArgumentV1::new_display(&path),
                    ],
                ),
            );
            res
        }
    }
    #[cfg(feature = "parsing")]
    fn enter_args<'a>(
        attr: &Attribute,
        input: ParseStream<'a>,
    ) -> Result<ParseBuffer<'a>> {
        if input.is_empty() {
            let expected = expected_parentheses(attr);
            let msg = {
                let res = ::alloc::fmt::format(
                    ::core::fmt::Arguments::new_v1(
                        &["expected attribute arguments in parentheses: "],
                        &[::core::fmt::ArgumentV1::new_display(&expected)],
                    ),
                );
                res
            };
            return Err(
                crate::error::new2(attr.pound_token.span, attr.bracket_token.span, msg),
            );
        } else if input.peek(crate::token::Eq) {
            let expected = expected_parentheses(attr);
            let msg = {
                let res = ::alloc::fmt::format(
                    ::core::fmt::Arguments::new_v1(
                        &["expected parentheses: "],
                        &[::core::fmt::ArgumentV1::new_display(&expected)],
                    ),
                );
                res
            };
            return Err(input.error(msg));
        }
        let content;
        if input.peek(token::Paren) {
            match crate::group::parse_parens(&input) {
                crate::__private::Ok(parens) => {
                    content = parens.content;
                    parens.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
        } else if input.peek(token::Bracket) {
            match crate::group::parse_brackets(&input) {
                crate::__private::Ok(brackets) => {
                    content = brackets.content;
                    brackets.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
        } else if input.peek(token::Brace) {
            match crate::group::parse_braces(&input) {
                crate::__private::Ok(braces) => {
                    content = braces.content;
                    braces.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
        } else {
            return Err(input.error("unexpected token in attribute arguments"));
        }
        if input.is_empty() {
            Ok(content)
        } else {
            Err(input.error("unexpected token in attribute arguments"))
        }
    }
    pub enum AttrStyle {
        Outer,
        Inner(crate::token::Bang),
    }
    pub enum Meta {
        Path(Path),
        List(MetaList),
        NameValue(MetaNameValue),
    }
    impl From<Path> for Meta {
        fn from(e: Path) -> Meta {
            Meta::Path(e)
        }
    }
    impl From<MetaList> for Meta {
        fn from(e: MetaList) -> Meta {
            Meta::List(e)
        }
    }
    impl From<MetaNameValue> for Meta {
        fn from(e: MetaNameValue) -> Meta {
            Meta::NameValue(e)
        }
    }
    impl ::quote::ToTokens for Meta {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                Meta::Path(_e) => _e.to_tokens(tokens),
                Meta::List(_e) => _e.to_tokens(tokens),
                Meta::NameValue(_e) => _e.to_tokens(tokens),
            }
        }
    }
    pub struct MetaList {
        pub path: Path,
        pub paren_token: token::Paren,
        pub nested: Punctuated<NestedMeta, crate::token::Comma>,
    }
    pub struct MetaNameValue {
        pub path: Path,
        pub eq_token: crate::token::Eq,
        pub lit: Lit,
    }
    impl Meta {
        pub fn path(&self) -> &Path {
            match self {
                Meta::Path(path) => path,
                Meta::List(meta) => &meta.path,
                Meta::NameValue(meta) => &meta.path,
            }
        }
    }
    pub enum NestedMeta {
        Meta(Meta),
        Lit(Lit),
    }
    impl From<Meta> for NestedMeta {
        fn from(e: Meta) -> NestedMeta {
            NestedMeta::Meta(e)
        }
    }
    impl From<Lit> for NestedMeta {
        fn from(e: Lit) -> NestedMeta {
            NestedMeta::Lit(e)
        }
    }
    impl ::quote::ToTokens for NestedMeta {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                NestedMeta::Meta(_e) => _e.to_tokens(tokens),
                NestedMeta::Lit(_e) => _e.to_tokens(tokens),
            }
        }
    }
    pub type AttributeArgs = Vec<NestedMeta>;
    pub trait FilterAttrs<'a> {
        type Ret: Iterator<Item = &'a Attribute>;
        fn outer(self) -> Self::Ret;
        fn inner(self) -> Self::Ret;
    }
    impl<'a> FilterAttrs<'a> for &'a [Attribute] {
        type Ret = iter::Filter<slice::Iter<'a, Attribute>, fn(&&Attribute) -> bool>;
        fn outer(self) -> Self::Ret {
            fn is_outer(attr: &&Attribute) -> bool {
                match attr.style {
                    AttrStyle::Outer => true,
                    AttrStyle::Inner(_) => false,
                }
            }
            self.iter().filter(is_outer)
        }
        fn inner(self) -> Self::Ret {
            fn is_inner(attr: &&Attribute) -> bool {
                match attr.style {
                    AttrStyle::Inner(_) => true,
                    AttrStyle::Outer => false,
                }
            }
            self.iter().filter(is_inner)
        }
    }
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use super::*;
        use crate::ext::IdentExt;
        use crate::parse::{Parse, ParseStream, Result};
        pub fn parse_inner(
            input: ParseStream,
            attrs: &mut Vec<Attribute>,
        ) -> Result<()> {
            while input.peek(crate::token::Pound) && input.peek2(crate::token::Bang) {
                attrs.push(input.call(parsing::single_parse_inner)?);
            }
            Ok(())
        }
        pub fn single_parse_inner(input: ParseStream) -> Result<Attribute> {
            let content;
            Ok(Attribute {
                pound_token: input.parse()?,
                style: AttrStyle::Inner(input.parse()?),
                bracket_token: match crate::group::parse_brackets(&input) {
                    crate::__private::Ok(brackets) => {
                        content = brackets.content;
                        brackets.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                },
                path: content.call(Path::parse_mod_style)?,
                tokens: content.parse()?,
            })
        }
        pub fn single_parse_outer(input: ParseStream) -> Result<Attribute> {
            let content;
            Ok(Attribute {
                pound_token: input.parse()?,
                style: AttrStyle::Outer,
                bracket_token: match crate::group::parse_brackets(&input) {
                    crate::__private::Ok(brackets) => {
                        content = brackets.content;
                        brackets.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                },
                path: content.call(Path::parse_mod_style)?,
                tokens: content.parse()?,
            })
        }
        fn parse_meta_path(input: ParseStream) -> Result<Path> {
            Ok(Path {
                leading_colon: input.parse()?,
                segments: {
                    let mut segments = Punctuated::new();
                    while input.peek(Ident::peek_any) {
                        let ident = Ident::parse_any(input)?;
                        segments.push_value(PathSegment::from(ident));
                        if !input.peek(crate::token::Colon2) {
                            break;
                        }
                        let punct = input.parse()?;
                        segments.push_punct(punct);
                    }
                    if segments.is_empty() {
                        return Err(input.error("expected path"));
                    } else if segments.trailing_punct() {
                        return Err(input.error("expected path segment"));
                    }
                    segments
                },
            })
        }
        impl Parse for Meta {
            fn parse(input: ParseStream) -> Result<Self> {
                let path = input.call(parse_meta_path)?;
                parse_meta_after_path(path, input)
            }
        }
        impl Parse for MetaList {
            fn parse(input: ParseStream) -> Result<Self> {
                let path = input.call(parse_meta_path)?;
                parse_meta_list_after_path(path, input)
            }
        }
        impl Parse for MetaNameValue {
            fn parse(input: ParseStream) -> Result<Self> {
                let path = input.call(parse_meta_path)?;
                parse_meta_name_value_after_path(path, input)
            }
        }
        impl Parse for NestedMeta {
            fn parse(input: ParseStream) -> Result<Self> {
                if input.peek(Lit)
                    && !(input.peek(LitBool) && input.peek2(crate::token::Eq))
                {
                    input.parse().map(NestedMeta::Lit)
                } else if input.peek(Ident::peek_any)
                    || input.peek(crate::token::Colon2) && input.peek3(Ident::peek_any)
                {
                    input.parse().map(NestedMeta::Meta)
                } else {
                    Err(input.error("expected identifier or literal"))
                }
            }
        }
        pub fn parse_meta_after_path(path: Path, input: ParseStream) -> Result<Meta> {
            if input.peek(token::Paren) {
                parse_meta_list_after_path(path, input).map(Meta::List)
            } else if input.peek(crate::token::Eq) {
                parse_meta_name_value_after_path(path, input).map(Meta::NameValue)
            } else {
                Ok(Meta::Path(path))
            }
        }
        fn parse_meta_list_after_path(
            path: Path,
            input: ParseStream,
        ) -> Result<MetaList> {
            let content;
            Ok(MetaList {
                path,
                paren_token: match crate::group::parse_parens(&input) {
                    crate::__private::Ok(parens) => {
                        content = parens.content;
                        parens.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                },
                nested: content.parse_terminated(NestedMeta::parse)?,
            })
        }
        fn parse_meta_name_value_after_path(
            path: Path,
            input: ParseStream,
        ) -> Result<MetaNameValue> {
            Ok(MetaNameValue {
                path,
                eq_token: input.parse()?,
                lit: input.parse()?,
            })
        }
    }
    #[cfg(feature = "printing")]
    mod printing {
        use super::*;
        use proc_macro2::TokenStream;
        use quote::ToTokens;
        impl ToTokens for Attribute {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.pound_token.to_tokens(tokens);
                if let AttrStyle::Inner(b) = &self.style {
                    b.to_tokens(tokens);
                }
                self.bracket_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.path.to_tokens(tokens);
                            self.tokens.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for MetaList {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.path.to_tokens(tokens);
                self.paren_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.nested.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for MetaNameValue {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.path.to_tokens(tokens);
                self.eq_token.to_tokens(tokens);
                self.lit.to_tokens(tokens);
            }
        }
    }
}
#[cfg(any(feature = "full", feature = "derive"))]
pub use crate::attr::{
    AttrStyle, Attribute, AttributeArgs, Meta, MetaList, MetaNameValue, NestedMeta,
};
mod bigint {
    use std::ops::{AddAssign, MulAssign};
    pub struct BigInt {
        digits: Vec<u8>,
    }
    impl BigInt {
        pub fn new() -> Self {
            BigInt { digits: Vec::new() }
        }
        pub fn to_string(&self) -> String {
            let mut repr = String::with_capacity(self.digits.len());
            let mut has_nonzero = false;
            for digit in self.digits.iter().rev() {
                has_nonzero |= *digit != 0;
                if has_nonzero {
                    repr.push((*digit + b'0') as char);
                }
            }
            if repr.is_empty() {
                repr.push('0');
            }
            repr
        }
        fn reserve_two_digits(&mut self) {
            let len = self.digits.len();
            let desired = len + !self.digits.ends_with(&[0, 0]) as usize
                + !self.digits.ends_with(&[0]) as usize;
            self.digits.resize(desired, 0);
        }
    }
    impl AddAssign<u8> for BigInt {
        fn add_assign(&mut self, mut increment: u8) {
            self.reserve_two_digits();
            let mut i = 0;
            while increment > 0 {
                let sum = self.digits[i] + increment;
                self.digits[i] = sum % 10;
                increment = sum / 10;
                i += 1;
            }
        }
    }
    impl MulAssign<u8> for BigInt {
        fn mul_assign(&mut self, base: u8) {
            self.reserve_two_digits();
            let mut carry = 0;
            for digit in &mut self.digits {
                let prod = *digit * base + carry;
                *digit = prod % 10;
                carry = prod / 10;
            }
        }
    }
}
#[cfg(any(feature = "full", feature = "derive"))]
mod data {
    use super::*;
    use crate::punctuated::Punctuated;
    pub struct Variant {
        pub attrs: Vec<Attribute>,
        pub ident: Ident,
        pub fields: Fields,
        pub discriminant: Option<(crate::token::Eq, Expr)>,
    }
    pub enum Fields {
        Named(FieldsNamed),
        Unnamed(FieldsUnnamed),
        Unit,
    }
    impl From<FieldsNamed> for Fields {
        fn from(e: FieldsNamed) -> Fields {
            Fields::Named(e)
        }
    }
    impl From<FieldsUnnamed> for Fields {
        fn from(e: FieldsUnnamed) -> Fields {
            Fields::Unnamed(e)
        }
    }
    impl ::quote::ToTokens for Fields {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                Fields::Named(_e) => _e.to_tokens(tokens),
                Fields::Unnamed(_e) => _e.to_tokens(tokens),
                Fields::Unit => {}
            }
        }
    }
    pub struct FieldsNamed {
        pub brace_token: token::Brace,
        pub named: Punctuated<Field, crate::token::Comma>,
    }
    pub struct FieldsUnnamed {
        pub paren_token: token::Paren,
        pub unnamed: Punctuated<Field, crate::token::Comma>,
    }
    impl Fields {
        pub fn iter(&self) -> punctuated::Iter<Field> {
            match self {
                Fields::Unit => crate::punctuated::empty_punctuated_iter(),
                Fields::Named(f) => f.named.iter(),
                Fields::Unnamed(f) => f.unnamed.iter(),
            }
        }
        pub fn iter_mut(&mut self) -> punctuated::IterMut<Field> {
            match self {
                Fields::Unit => crate::punctuated::empty_punctuated_iter_mut(),
                Fields::Named(f) => f.named.iter_mut(),
                Fields::Unnamed(f) => f.unnamed.iter_mut(),
            }
        }
        pub fn len(&self) -> usize {
            match self {
                Fields::Unit => 0,
                Fields::Named(f) => f.named.len(),
                Fields::Unnamed(f) => f.unnamed.len(),
            }
        }
        pub fn is_empty(&self) -> bool {
            match self {
                Fields::Unit => true,
                Fields::Named(f) => f.named.is_empty(),
                Fields::Unnamed(f) => f.unnamed.is_empty(),
            }
        }
    }
    impl IntoIterator for Fields {
        type Item = Field;
        type IntoIter = punctuated::IntoIter<Field>;
        fn into_iter(self) -> Self::IntoIter {
            match self {
                Fields::Unit => Punctuated::<Field, ()>::new().into_iter(),
                Fields::Named(f) => f.named.into_iter(),
                Fields::Unnamed(f) => f.unnamed.into_iter(),
            }
        }
    }
    impl<'a> IntoIterator for &'a Fields {
        type Item = &'a Field;
        type IntoIter = punctuated::Iter<'a, Field>;
        fn into_iter(self) -> Self::IntoIter {
            self.iter()
        }
    }
    impl<'a> IntoIterator for &'a mut Fields {
        type Item = &'a mut Field;
        type IntoIter = punctuated::IterMut<'a, Field>;
        fn into_iter(self) -> Self::IntoIter {
            self.iter_mut()
        }
    }
    pub struct Field {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub ident: Option<Ident>,
        pub colon_token: Option<crate::token::Colon>,
        pub ty: Type,
    }
    pub enum Visibility {
        Public(VisPublic),
        Crate(VisCrate),
        Restricted(VisRestricted),
        Inherited,
    }
    impl From<VisPublic> for Visibility {
        fn from(e: VisPublic) -> Visibility {
            Visibility::Public(e)
        }
    }
    impl From<VisCrate> for Visibility {
        fn from(e: VisCrate) -> Visibility {
            Visibility::Crate(e)
        }
    }
    impl From<VisRestricted> for Visibility {
        fn from(e: VisRestricted) -> Visibility {
            Visibility::Restricted(e)
        }
    }
    impl ::quote::ToTokens for Visibility {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                Visibility::Public(_e) => _e.to_tokens(tokens),
                Visibility::Crate(_e) => _e.to_tokens(tokens),
                Visibility::Restricted(_e) => _e.to_tokens(tokens),
                Visibility::Inherited => {}
            }
        }
    }
    pub struct VisPublic {
        pub pub_token: crate::token::Pub,
    }
    pub struct VisCrate {
        pub crate_token: crate::token::Crate,
    }
    pub struct VisRestricted {
        pub pub_token: crate::token::Pub,
        pub paren_token: token::Paren,
        pub in_token: Option<crate::token::In>,
        pub path: Box<Path>,
    }
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use super::*;
        use crate::ext::IdentExt;
        use crate::parse::discouraged::Speculative;
        use crate::parse::{Parse, ParseStream, Result};
        impl Parse for Variant {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let _visibility: Visibility = input.parse()?;
                let ident: Ident = input.parse()?;
                let fields = if input.peek(token::Brace) {
                    Fields::Named(input.parse()?)
                } else if input.peek(token::Paren) {
                    Fields::Unnamed(input.parse()?)
                } else {
                    Fields::Unit
                };
                let discriminant = if input.peek(crate::token::Eq) {
                    let eq_token: crate::token::Eq = input.parse()?;
                    let discriminant: Expr = input.parse()?;
                    Some((eq_token, discriminant))
                } else {
                    None
                };
                Ok(Variant {
                    attrs,
                    ident,
                    fields,
                    discriminant,
                })
            }
        }
        impl Parse for FieldsNamed {
            fn parse(input: ParseStream) -> Result<Self> {
                let content;
                Ok(FieldsNamed {
                    brace_token: match crate::group::parse_braces(&input) {
                        crate::__private::Ok(braces) => {
                            content = braces.content;
                            braces.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    },
                    named: content.parse_terminated(Field::parse_named)?,
                })
            }
        }
        impl Parse for FieldsUnnamed {
            fn parse(input: ParseStream) -> Result<Self> {
                let content;
                Ok(FieldsUnnamed {
                    paren_token: match crate::group::parse_parens(&input) {
                        crate::__private::Ok(parens) => {
                            content = parens.content;
                            parens.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    },
                    unnamed: content.parse_terminated(Field::parse_unnamed)?,
                })
            }
        }
        impl Field {
            pub fn parse_named(input: ParseStream) -> Result<Self> {
                Ok(Field {
                    attrs: input.call(Attribute::parse_outer)?,
                    vis: input.parse()?,
                    ident: Some(
                        if input.peek(crate::token::Underscore) {
                            input.call(Ident::parse_any)
                        } else {
                            input.parse()
                        }?,
                    ),
                    colon_token: Some(input.parse()?),
                    ty: input.parse()?,
                })
            }
            pub fn parse_unnamed(input: ParseStream) -> Result<Self> {
                Ok(Field {
                    attrs: input.call(Attribute::parse_outer)?,
                    vis: input.parse()?,
                    ident: None,
                    colon_token: None,
                    ty: input.parse()?,
                })
            }
        }
        impl Parse for Visibility {
            fn parse(input: ParseStream) -> Result<Self> {
                if input.peek(token::Group) {
                    let ahead = input.fork();
                    let group = crate::group::parse_group(&ahead)?;
                    if group.content.is_empty() {
                        input.advance_to(&ahead);
                        return Ok(Visibility::Inherited);
                    }
                }
                if input.peek(crate::token::Pub) {
                    Self::parse_pub(input)
                } else if input.peek(crate::token::Crate) {
                    Self::parse_crate(input)
                } else {
                    Ok(Visibility::Inherited)
                }
            }
        }
        impl Visibility {
            fn parse_pub(input: ParseStream) -> Result<Self> {
                let pub_token = input.parse::<crate::token::Pub>()?;
                if input.peek(token::Paren) {
                    let ahead = input.fork();
                    let content;
                    let paren_token = match crate::group::parse_parens(&ahead) {
                        crate::__private::Ok(parens) => {
                            content = parens.content;
                            parens.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    };
                    if content.peek(crate::token::Crate)
                        || content.peek(crate::token::SelfValue)
                        || content.peek(crate::token::Super)
                    {
                        let path = content.call(Ident::parse_any)?;
                        if content.is_empty() {
                            input.advance_to(&ahead);
                            return Ok(
                                Visibility::Restricted(VisRestricted {
                                    pub_token,
                                    paren_token,
                                    in_token: None,
                                    path: Box::new(Path::from(path)),
                                }),
                            );
                        }
                    } else if content.peek(crate::token::In) {
                        let in_token: crate::token::In = content.parse()?;
                        let path = content.call(Path::parse_mod_style)?;
                        input.advance_to(&ahead);
                        return Ok(
                            Visibility::Restricted(VisRestricted {
                                pub_token,
                                paren_token,
                                in_token: Some(in_token),
                                path: Box::new(path),
                            }),
                        );
                    }
                }
                Ok(Visibility::Public(VisPublic { pub_token }))
            }
            fn parse_crate(input: ParseStream) -> Result<Self> {
                if input.peek2(crate::token::Colon2) {
                    Ok(Visibility::Inherited)
                } else {
                    Ok(
                        Visibility::Crate(VisCrate {
                            crate_token: input.parse()?,
                        }),
                    )
                }
            }
            #[cfg(feature = "full")]
            pub(crate) fn is_some(&self) -> bool {
                match self {
                    Visibility::Inherited => false,
                    _ => true,
                }
            }
        }
    }
    #[cfg(feature = "printing")]
    mod printing {
        use super::*;
        use crate::print::TokensOrDefault;
        use proc_macro2::TokenStream;
        use quote::{ToTokens, TokenStreamExt};
        impl ToTokens for Variant {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(&self.attrs);
                self.ident.to_tokens(tokens);
                self.fields.to_tokens(tokens);
                if let Some((eq_token, disc)) = &self.discriminant {
                    eq_token.to_tokens(tokens);
                    disc.to_tokens(tokens);
                }
            }
        }
        impl ToTokens for FieldsNamed {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.named.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for FieldsUnnamed {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.paren_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.unnamed.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for Field {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(&self.attrs);
                self.vis.to_tokens(tokens);
                if let Some(ident) = &self.ident {
                    ident.to_tokens(tokens);
                    TokensOrDefault(&self.colon_token).to_tokens(tokens);
                }
                self.ty.to_tokens(tokens);
            }
        }
        impl ToTokens for VisPublic {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.pub_token.to_tokens(tokens);
            }
        }
        impl ToTokens for VisCrate {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.crate_token.to_tokens(tokens);
            }
        }
        impl ToTokens for VisRestricted {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.pub_token.to_tokens(tokens);
                self.paren_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.in_token.to_tokens(tokens);
                            self.path.to_tokens(tokens);
                        },
                    );
            }
        }
    }
}
#[cfg(any(feature = "full", feature = "derive"))]
pub use crate::data::{
    Field, Fields, FieldsNamed, FieldsUnnamed, Variant, VisCrate, VisPublic,
    VisRestricted, Visibility,
};
#[cfg(any(feature = "full", feature = "derive"))]
mod expr {
    use super::*;
    use crate::punctuated::Punctuated;
    #[cfg(feature = "full")]
    use crate::reserved::Reserved;
    use proc_macro2::{Span, TokenStream};
    #[cfg(feature = "printing")]
    use quote::IdentFragment;
    #[cfg(feature = "printing")]
    use std::fmt::{self, Display};
    use std::hash::{Hash, Hasher};
    #[cfg(feature = "parsing")]
    use std::mem;
    #[non_exhaustive]
    pub enum Expr {
        Array(ExprArray),
        Assign(ExprAssign),
        AssignOp(ExprAssignOp),
        Async(ExprAsync),
        Await(ExprAwait),
        Binary(ExprBinary),
        Block(ExprBlock),
        Box(ExprBox),
        Break(ExprBreak),
        Call(ExprCall),
        Cast(ExprCast),
        Closure(ExprClosure),
        Continue(ExprContinue),
        Field(ExprField),
        ForLoop(ExprForLoop),
        Group(ExprGroup),
        If(ExprIf),
        Index(ExprIndex),
        Let(ExprLet),
        Lit(ExprLit),
        Loop(ExprLoop),
        Macro(ExprMacro),
        Match(ExprMatch),
        MethodCall(ExprMethodCall),
        Paren(ExprParen),
        Path(ExprPath),
        Range(ExprRange),
        Reference(ExprReference),
        Repeat(ExprRepeat),
        Return(ExprReturn),
        Struct(ExprStruct),
        Try(ExprTry),
        TryBlock(ExprTryBlock),
        Tuple(ExprTuple),
        Type(ExprType),
        Unary(ExprUnary),
        Unsafe(ExprUnsafe),
        Verbatim(TokenStream),
        While(ExprWhile),
        Yield(ExprYield),
    }
    impl From<ExprArray> for Expr {
        fn from(e: ExprArray) -> Expr {
            Expr::Array(e)
        }
    }
    impl From<ExprAssign> for Expr {
        fn from(e: ExprAssign) -> Expr {
            Expr::Assign(e)
        }
    }
    impl From<ExprAssignOp> for Expr {
        fn from(e: ExprAssignOp) -> Expr {
            Expr::AssignOp(e)
        }
    }
    impl From<ExprAsync> for Expr {
        fn from(e: ExprAsync) -> Expr {
            Expr::Async(e)
        }
    }
    impl From<ExprAwait> for Expr {
        fn from(e: ExprAwait) -> Expr {
            Expr::Await(e)
        }
    }
    impl From<ExprBinary> for Expr {
        fn from(e: ExprBinary) -> Expr {
            Expr::Binary(e)
        }
    }
    impl From<ExprBlock> for Expr {
        fn from(e: ExprBlock) -> Expr {
            Expr::Block(e)
        }
    }
    impl From<ExprBox> for Expr {
        fn from(e: ExprBox) -> Expr {
            Expr::Box(e)
        }
    }
    impl From<ExprBreak> for Expr {
        fn from(e: ExprBreak) -> Expr {
            Expr::Break(e)
        }
    }
    impl From<ExprCall> for Expr {
        fn from(e: ExprCall) -> Expr {
            Expr::Call(e)
        }
    }
    impl From<ExprCast> for Expr {
        fn from(e: ExprCast) -> Expr {
            Expr::Cast(e)
        }
    }
    impl From<ExprClosure> for Expr {
        fn from(e: ExprClosure) -> Expr {
            Expr::Closure(e)
        }
    }
    impl From<ExprContinue> for Expr {
        fn from(e: ExprContinue) -> Expr {
            Expr::Continue(e)
        }
    }
    impl From<ExprField> for Expr {
        fn from(e: ExprField) -> Expr {
            Expr::Field(e)
        }
    }
    impl From<ExprForLoop> for Expr {
        fn from(e: ExprForLoop) -> Expr {
            Expr::ForLoop(e)
        }
    }
    impl From<ExprGroup> for Expr {
        fn from(e: ExprGroup) -> Expr {
            Expr::Group(e)
        }
    }
    impl From<ExprIf> for Expr {
        fn from(e: ExprIf) -> Expr {
            Expr::If(e)
        }
    }
    impl From<ExprIndex> for Expr {
        fn from(e: ExprIndex) -> Expr {
            Expr::Index(e)
        }
    }
    impl From<ExprLet> for Expr {
        fn from(e: ExprLet) -> Expr {
            Expr::Let(e)
        }
    }
    impl From<ExprLit> for Expr {
        fn from(e: ExprLit) -> Expr {
            Expr::Lit(e)
        }
    }
    impl From<ExprLoop> for Expr {
        fn from(e: ExprLoop) -> Expr {
            Expr::Loop(e)
        }
    }
    impl From<ExprMacro> for Expr {
        fn from(e: ExprMacro) -> Expr {
            Expr::Macro(e)
        }
    }
    impl From<ExprMatch> for Expr {
        fn from(e: ExprMatch) -> Expr {
            Expr::Match(e)
        }
    }
    impl From<ExprMethodCall> for Expr {
        fn from(e: ExprMethodCall) -> Expr {
            Expr::MethodCall(e)
        }
    }
    impl From<ExprParen> for Expr {
        fn from(e: ExprParen) -> Expr {
            Expr::Paren(e)
        }
    }
    impl From<ExprPath> for Expr {
        fn from(e: ExprPath) -> Expr {
            Expr::Path(e)
        }
    }
    impl From<ExprRange> for Expr {
        fn from(e: ExprRange) -> Expr {
            Expr::Range(e)
        }
    }
    impl From<ExprReference> for Expr {
        fn from(e: ExprReference) -> Expr {
            Expr::Reference(e)
        }
    }
    impl From<ExprRepeat> for Expr {
        fn from(e: ExprRepeat) -> Expr {
            Expr::Repeat(e)
        }
    }
    impl From<ExprReturn> for Expr {
        fn from(e: ExprReturn) -> Expr {
            Expr::Return(e)
        }
    }
    impl From<ExprStruct> for Expr {
        fn from(e: ExprStruct) -> Expr {
            Expr::Struct(e)
        }
    }
    impl From<ExprTry> for Expr {
        fn from(e: ExprTry) -> Expr {
            Expr::Try(e)
        }
    }
    impl From<ExprTryBlock> for Expr {
        fn from(e: ExprTryBlock) -> Expr {
            Expr::TryBlock(e)
        }
    }
    impl From<ExprTuple> for Expr {
        fn from(e: ExprTuple) -> Expr {
            Expr::Tuple(e)
        }
    }
    impl From<ExprType> for Expr {
        fn from(e: ExprType) -> Expr {
            Expr::Type(e)
        }
    }
    impl From<ExprUnary> for Expr {
        fn from(e: ExprUnary) -> Expr {
            Expr::Unary(e)
        }
    }
    impl From<ExprUnsafe> for Expr {
        fn from(e: ExprUnsafe) -> Expr {
            Expr::Unsafe(e)
        }
    }
    impl From<ExprWhile> for Expr {
        fn from(e: ExprWhile) -> Expr {
            Expr::While(e)
        }
    }
    impl From<ExprYield> for Expr {
        fn from(e: ExprYield) -> Expr {
            Expr::Yield(e)
        }
    }
    impl ::quote::ToTokens for Expr {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                Expr::Array(_e) => _e.to_tokens(tokens),
                Expr::Assign(_e) => _e.to_tokens(tokens),
                Expr::AssignOp(_e) => _e.to_tokens(tokens),
                Expr::Async(_e) => _e.to_tokens(tokens),
                Expr::Await(_e) => _e.to_tokens(tokens),
                Expr::Binary(_e) => _e.to_tokens(tokens),
                Expr::Block(_e) => _e.to_tokens(tokens),
                Expr::Box(_e) => _e.to_tokens(tokens),
                Expr::Break(_e) => _e.to_tokens(tokens),
                Expr::Call(_e) => _e.to_tokens(tokens),
                Expr::Cast(_e) => _e.to_tokens(tokens),
                Expr::Closure(_e) => _e.to_tokens(tokens),
                Expr::Continue(_e) => _e.to_tokens(tokens),
                Expr::Field(_e) => _e.to_tokens(tokens),
                Expr::ForLoop(_e) => _e.to_tokens(tokens),
                Expr::Group(_e) => _e.to_tokens(tokens),
                Expr::If(_e) => _e.to_tokens(tokens),
                Expr::Index(_e) => _e.to_tokens(tokens),
                Expr::Let(_e) => _e.to_tokens(tokens),
                Expr::Lit(_e) => _e.to_tokens(tokens),
                Expr::Loop(_e) => _e.to_tokens(tokens),
                Expr::Macro(_e) => _e.to_tokens(tokens),
                Expr::Match(_e) => _e.to_tokens(tokens),
                Expr::MethodCall(_e) => _e.to_tokens(tokens),
                Expr::Paren(_e) => _e.to_tokens(tokens),
                Expr::Path(_e) => _e.to_tokens(tokens),
                Expr::Range(_e) => _e.to_tokens(tokens),
                Expr::Reference(_e) => _e.to_tokens(tokens),
                Expr::Repeat(_e) => _e.to_tokens(tokens),
                Expr::Return(_e) => _e.to_tokens(tokens),
                Expr::Struct(_e) => _e.to_tokens(tokens),
                Expr::Try(_e) => _e.to_tokens(tokens),
                Expr::TryBlock(_e) => _e.to_tokens(tokens),
                Expr::Tuple(_e) => _e.to_tokens(tokens),
                Expr::Type(_e) => _e.to_tokens(tokens),
                Expr::Unary(_e) => _e.to_tokens(tokens),
                Expr::Unsafe(_e) => _e.to_tokens(tokens),
                Expr::Verbatim(_e) => _e.to_tokens(tokens),
                Expr::While(_e) => _e.to_tokens(tokens),
                Expr::Yield(_e) => _e.to_tokens(tokens),
            }
        }
    }
    #[cfg(feature = "full")]
    pub struct ExprArray {
        pub attrs: Vec<Attribute>,
        pub bracket_token: token::Bracket,
        pub elems: Punctuated<Expr, crate::token::Comma>,
    }
    #[cfg(feature = "full")]
    pub struct ExprAssign {
        pub attrs: Vec<Attribute>,
        pub left: Box<Expr>,
        pub eq_token: crate::token::Eq,
        pub right: Box<Expr>,
    }
    #[cfg(feature = "full")]
    pub struct ExprAssignOp {
        pub attrs: Vec<Attribute>,
        pub left: Box<Expr>,
        pub op: BinOp,
        pub right: Box<Expr>,
    }
    #[cfg(feature = "full")]
    pub struct ExprAsync {
        pub attrs: Vec<Attribute>,
        pub async_token: crate::token::Async,
        pub capture: Option<crate::token::Move>,
        pub block: Block,
    }
    #[cfg(feature = "full")]
    pub struct ExprAwait {
        pub attrs: Vec<Attribute>,
        pub base: Box<Expr>,
        pub dot_token: crate::token::Dot,
        pub await_token: token::Await,
    }
    pub struct ExprBinary {
        pub attrs: Vec<Attribute>,
        pub left: Box<Expr>,
        pub op: BinOp,
        pub right: Box<Expr>,
    }
    #[cfg(feature = "full")]
    pub struct ExprBlock {
        pub attrs: Vec<Attribute>,
        pub label: Option<Label>,
        pub block: Block,
    }
    #[cfg(feature = "full")]
    pub struct ExprBox {
        pub attrs: Vec<Attribute>,
        pub box_token: crate::token::Box,
        pub expr: Box<Expr>,
    }
    #[cfg(feature = "full")]
    pub struct ExprBreak {
        pub attrs: Vec<Attribute>,
        pub break_token: crate::token::Break,
        pub label: Option<Lifetime>,
        pub expr: Option<Box<Expr>>,
    }
    pub struct ExprCall {
        pub attrs: Vec<Attribute>,
        pub func: Box<Expr>,
        pub paren_token: token::Paren,
        pub args: Punctuated<Expr, crate::token::Comma>,
    }
    pub struct ExprCast {
        pub attrs: Vec<Attribute>,
        pub expr: Box<Expr>,
        pub as_token: crate::token::As,
        pub ty: Box<Type>,
    }
    #[cfg(feature = "full")]
    pub struct ExprClosure {
        pub attrs: Vec<Attribute>,
        pub movability: Option<crate::token::Static>,
        pub asyncness: Option<crate::token::Async>,
        pub capture: Option<crate::token::Move>,
        pub or1_token: crate::token::Or,
        pub inputs: Punctuated<Pat, crate::token::Comma>,
        pub or2_token: crate::token::Or,
        pub output: ReturnType,
        pub body: Box<Expr>,
    }
    #[cfg(feature = "full")]
    pub struct ExprContinue {
        pub attrs: Vec<Attribute>,
        pub continue_token: crate::token::Continue,
        pub label: Option<Lifetime>,
    }
    pub struct ExprField {
        pub attrs: Vec<Attribute>,
        pub base: Box<Expr>,
        pub dot_token: crate::token::Dot,
        pub member: Member,
    }
    #[cfg(feature = "full")]
    pub struct ExprForLoop {
        pub attrs: Vec<Attribute>,
        pub label: Option<Label>,
        pub for_token: crate::token::For,
        pub pat: Pat,
        pub in_token: crate::token::In,
        pub expr: Box<Expr>,
        pub body: Block,
    }
    #[cfg(feature = "full")]
    pub struct ExprGroup {
        pub attrs: Vec<Attribute>,
        pub group_token: token::Group,
        pub expr: Box<Expr>,
    }
    #[cfg(feature = "full")]
    pub struct ExprIf {
        pub attrs: Vec<Attribute>,
        pub if_token: crate::token::If,
        pub cond: Box<Expr>,
        pub then_branch: Block,
        pub else_branch: Option<(crate::token::Else, Box<Expr>)>,
    }
    pub struct ExprIndex {
        pub attrs: Vec<Attribute>,
        pub expr: Box<Expr>,
        pub bracket_token: token::Bracket,
        pub index: Box<Expr>,
    }
    #[cfg(feature = "full")]
    pub struct ExprLet {
        pub attrs: Vec<Attribute>,
        pub let_token: crate::token::Let,
        pub pat: Pat,
        pub eq_token: crate::token::Eq,
        pub expr: Box<Expr>,
    }
    pub struct ExprLit {
        pub attrs: Vec<Attribute>,
        pub lit: Lit,
    }
    #[cfg(feature = "full")]
    pub struct ExprLoop {
        pub attrs: Vec<Attribute>,
        pub label: Option<Label>,
        pub loop_token: crate::token::Loop,
        pub body: Block,
    }
    #[cfg(feature = "full")]
    pub struct ExprMacro {
        pub attrs: Vec<Attribute>,
        pub mac: Macro,
    }
    #[cfg(feature = "full")]
    pub struct ExprMatch {
        pub attrs: Vec<Attribute>,
        pub match_token: crate::token::Match,
        pub expr: Box<Expr>,
        pub brace_token: token::Brace,
        pub arms: Vec<Arm>,
    }
    #[cfg(feature = "full")]
    pub struct ExprMethodCall {
        pub attrs: Vec<Attribute>,
        pub receiver: Box<Expr>,
        pub dot_token: crate::token::Dot,
        pub method: Ident,
        pub turbofish: Option<MethodTurbofish>,
        pub paren_token: token::Paren,
        pub args: Punctuated<Expr, crate::token::Comma>,
    }
    pub struct ExprParen {
        pub attrs: Vec<Attribute>,
        pub paren_token: token::Paren,
        pub expr: Box<Expr>,
    }
    pub struct ExprPath {
        pub attrs: Vec<Attribute>,
        pub qself: Option<QSelf>,
        pub path: Path,
    }
    #[cfg(feature = "full")]
    pub struct ExprRange {
        pub attrs: Vec<Attribute>,
        pub from: Option<Box<Expr>>,
        pub limits: RangeLimits,
        pub to: Option<Box<Expr>>,
    }
    #[cfg(feature = "full")]
    pub struct ExprReference {
        pub attrs: Vec<Attribute>,
        pub and_token: crate::token::And,
        pub raw: Reserved,
        pub mutability: Option<crate::token::Mut>,
        pub expr: Box<Expr>,
    }
    #[cfg(feature = "full")]
    pub struct ExprRepeat {
        pub attrs: Vec<Attribute>,
        pub bracket_token: token::Bracket,
        pub expr: Box<Expr>,
        pub semi_token: crate::token::Semi,
        pub len: Box<Expr>,
    }
    #[cfg(feature = "full")]
    pub struct ExprReturn {
        pub attrs: Vec<Attribute>,
        pub return_token: crate::token::Return,
        pub expr: Option<Box<Expr>>,
    }
    #[cfg(feature = "full")]
    pub struct ExprStruct {
        pub attrs: Vec<Attribute>,
        pub path: Path,
        pub brace_token: token::Brace,
        pub fields: Punctuated<FieldValue, crate::token::Comma>,
        pub dot2_token: Option<crate::token::Dot2>,
        pub rest: Option<Box<Expr>>,
    }
    #[cfg(feature = "full")]
    pub struct ExprTry {
        pub attrs: Vec<Attribute>,
        pub expr: Box<Expr>,
        pub question_token: crate::token::Question,
    }
    #[cfg(feature = "full")]
    pub struct ExprTryBlock {
        pub attrs: Vec<Attribute>,
        pub try_token: crate::token::Try,
        pub block: Block,
    }
    #[cfg(feature = "full")]
    pub struct ExprTuple {
        pub attrs: Vec<Attribute>,
        pub paren_token: token::Paren,
        pub elems: Punctuated<Expr, crate::token::Comma>,
    }
    #[cfg(feature = "full")]
    pub struct ExprType {
        pub attrs: Vec<Attribute>,
        pub expr: Box<Expr>,
        pub colon_token: crate::token::Colon,
        pub ty: Box<Type>,
    }
    pub struct ExprUnary {
        pub attrs: Vec<Attribute>,
        pub op: UnOp,
        pub expr: Box<Expr>,
    }
    #[cfg(feature = "full")]
    pub struct ExprUnsafe {
        pub attrs: Vec<Attribute>,
        pub unsafe_token: crate::token::Unsafe,
        pub block: Block,
    }
    #[cfg(feature = "full")]
    pub struct ExprWhile {
        pub attrs: Vec<Attribute>,
        pub label: Option<Label>,
        pub while_token: crate::token::While,
        pub cond: Box<Expr>,
        pub body: Block,
    }
    #[cfg(feature = "full")]
    pub struct ExprYield {
        pub attrs: Vec<Attribute>,
        pub yield_token: crate::token::Yield,
        pub expr: Option<Box<Expr>>,
    }
    impl Expr {
        #[cfg(all(feature = "parsing", not(syn_no_const_vec_new)))]
        const DUMMY: Self = Expr::Path(ExprPath {
            attrs: Vec::new(),
            qself: None,
            path: Path {
                leading_colon: None,
                segments: Punctuated::new(),
            },
        });
        #[cfg(all(feature = "parsing", feature = "full"))]
        pub(crate) fn replace_attrs(&mut self, new: Vec<Attribute>) -> Vec<Attribute> {
            match self {
                Expr::Box(ExprBox { attrs, .. })
                | Expr::Array(ExprArray { attrs, .. })
                | Expr::Call(ExprCall { attrs, .. })
                | Expr::MethodCall(ExprMethodCall { attrs, .. })
                | Expr::Tuple(ExprTuple { attrs, .. })
                | Expr::Binary(ExprBinary { attrs, .. })
                | Expr::Unary(ExprUnary { attrs, .. })
                | Expr::Lit(ExprLit { attrs, .. })
                | Expr::Cast(ExprCast { attrs, .. })
                | Expr::Type(ExprType { attrs, .. })
                | Expr::Let(ExprLet { attrs, .. })
                | Expr::If(ExprIf { attrs, .. })
                | Expr::While(ExprWhile { attrs, .. })
                | Expr::ForLoop(ExprForLoop { attrs, .. })
                | Expr::Loop(ExprLoop { attrs, .. })
                | Expr::Match(ExprMatch { attrs, .. })
                | Expr::Closure(ExprClosure { attrs, .. })
                | Expr::Unsafe(ExprUnsafe { attrs, .. })
                | Expr::Block(ExprBlock { attrs, .. })
                | Expr::Assign(ExprAssign { attrs, .. })
                | Expr::AssignOp(ExprAssignOp { attrs, .. })
                | Expr::Field(ExprField { attrs, .. })
                | Expr::Index(ExprIndex { attrs, .. })
                | Expr::Range(ExprRange { attrs, .. })
                | Expr::Path(ExprPath { attrs, .. })
                | Expr::Reference(ExprReference { attrs, .. })
                | Expr::Break(ExprBreak { attrs, .. })
                | Expr::Continue(ExprContinue { attrs, .. })
                | Expr::Return(ExprReturn { attrs, .. })
                | Expr::Macro(ExprMacro { attrs, .. })
                | Expr::Struct(ExprStruct { attrs, .. })
                | Expr::Repeat(ExprRepeat { attrs, .. })
                | Expr::Paren(ExprParen { attrs, .. })
                | Expr::Group(ExprGroup { attrs, .. })
                | Expr::Try(ExprTry { attrs, .. })
                | Expr::Async(ExprAsync { attrs, .. })
                | Expr::Await(ExprAwait { attrs, .. })
                | Expr::TryBlock(ExprTryBlock { attrs, .. })
                | Expr::Yield(ExprYield { attrs, .. }) => mem::replace(attrs, new),
                Expr::Verbatim(_) => Vec::new(),
            }
        }
    }
    pub enum Member {
        Named(Ident),
        Unnamed(Index),
    }
    impl From<Ident> for Member {
        fn from(ident: Ident) -> Member {
            Member::Named(ident)
        }
    }
    impl From<Index> for Member {
        fn from(index: Index) -> Member {
            Member::Unnamed(index)
        }
    }
    impl From<usize> for Member {
        fn from(index: usize) -> Member {
            Member::Unnamed(Index::from(index))
        }
    }
    impl Eq for Member {}
    impl PartialEq for Member {
        fn eq(&self, other: &Self) -> bool {
            match (self, other) {
                (Member::Named(this), Member::Named(other)) => this == other,
                (Member::Unnamed(this), Member::Unnamed(other)) => this == other,
                _ => false,
            }
        }
    }
    impl Hash for Member {
        fn hash<H: Hasher>(&self, state: &mut H) {
            match self {
                Member::Named(m) => m.hash(state),
                Member::Unnamed(m) => m.hash(state),
            }
        }
    }
    #[cfg(feature = "printing")]
    impl IdentFragment for Member {
        fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
            match self {
                Member::Named(m) => Display::fmt(m, formatter),
                Member::Unnamed(m) => Display::fmt(&m.index, formatter),
            }
        }
        fn span(&self) -> Option<Span> {
            match self {
                Member::Named(m) => Some(m.span()),
                Member::Unnamed(m) => Some(m.span),
            }
        }
    }
    pub struct Index {
        pub index: u32,
        pub span: Span,
    }
    impl From<usize> for Index {
        fn from(index: usize) -> Index {
            if !(index < u32::max_value() as usize) {
                ::core::panicking::panic(
                    "assertion failed: index < u32::max_value() as usize",
                )
            }
            Index {
                index: index as u32,
                span: Span::call_site(),
            }
        }
    }
    impl Eq for Index {}
    impl PartialEq for Index {
        fn eq(&self, other: &Self) -> bool {
            self.index == other.index
        }
    }
    impl Hash for Index {
        fn hash<H: Hasher>(&self, state: &mut H) {
            self.index.hash(state);
        }
    }
    #[cfg(feature = "printing")]
    impl IdentFragment for Index {
        fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
            Display::fmt(&self.index, formatter)
        }
        fn span(&self) -> Option<Span> {
            Some(self.span)
        }
    }
    pub struct MethodTurbofish {
        pub colon2_token: crate::token::Colon2,
        pub lt_token: crate::token::Lt,
        pub args: Punctuated<GenericMethodArgument, crate::token::Comma>,
        pub gt_token: crate::token::Gt,
    }
    pub enum GenericMethodArgument {
        Type(Type),
        Const(Expr),
    }
    pub struct FieldValue {
        pub attrs: Vec<Attribute>,
        pub member: Member,
        pub colon_token: Option<crate::token::Colon>,
        pub expr: Expr,
    }
    pub struct Label {
        pub name: Lifetime,
        pub colon_token: crate::token::Colon,
    }
    pub struct Arm {
        pub attrs: Vec<Attribute>,
        pub pat: Pat,
        pub guard: Option<(crate::token::If, Box<Expr>)>,
        pub fat_arrow_token: crate::token::FatArrow,
        pub body: Box<Expr>,
        pub comma: Option<crate::token::Comma>,
    }
    pub enum RangeLimits {
        HalfOpen(crate::token::Dot2),
        Closed(crate::token::DotDotEq),
    }
    #[cfg(any(feature = "parsing", feature = "printing"))]
    #[cfg(feature = "full")]
    pub(crate) fn requires_terminator(expr: &Expr) -> bool {
        match *expr {
            Expr::Unsafe(..)
            | Expr::Block(..)
            | Expr::If(..)
            | Expr::Match(..)
            | Expr::While(..)
            | Expr::Loop(..)
            | Expr::ForLoop(..)
            | Expr::Async(..)
            | Expr::TryBlock(..) => false,
            _ => true,
        }
    }
    #[cfg(feature = "parsing")]
    pub(crate) mod parsing {
        use super::*;
        #[cfg(feature = "full")]
        use crate::parse::ParseBuffer;
        use crate::parse::{Parse, ParseStream, Result};
        use crate::path;
        #[cfg(feature = "full")]
        use proc_macro2::TokenTree;
        use std::cmp::Ordering;
        #[allow(non_camel_case_types)]
        pub struct raw {
            pub span: crate::__private::Span,
        }
        #[doc(hidden)]
        #[allow(dead_code, non_snake_case)]
        pub fn raw<__S: crate::__private::IntoSpans<[crate::__private::Span; 1]>>(
            span: __S,
        ) -> raw {
            raw {
                span: crate::__private::IntoSpans::into_spans(span)[0],
            }
        }
        impl crate::__private::Default for raw {
            fn default() -> Self {
                raw {
                    span: crate::__private::Span::call_site(),
                }
            }
        }
        impl crate::token::CustomToken for raw {
            fn peek(cursor: crate::buffer::Cursor) -> crate::__private::bool {
                if let crate::__private::Some((ident, _rest)) = cursor.ident() {
                    ident == "raw"
                } else {
                    false
                }
            }
            fn display() -> &'static crate::__private::str {
                "`raw`"
            }
        }
        impl crate::parse::Parse for raw {
            fn parse(input: crate::parse::ParseStream) -> crate::parse::Result<raw> {
                input
                    .step(|cursor| {
                        if let crate::__private::Some((ident, rest)) = cursor.ident() {
                            if ident == "raw" {
                                return crate::__private::Ok((
                                    raw { span: ident.span() },
                                    rest,
                                ));
                            }
                        }
                        crate::__private::Err(cursor.error("expected `raw`"))
                    })
            }
        }
        impl crate::__private::ToTokens for raw {
            fn to_tokens(&self, tokens: &mut crate::__private::TokenStream2) {
                let ident = crate::Ident::new("raw", self.span);
                crate::__private::TokenStreamExt::append(tokens, ident);
            }
        }
        impl crate::__private::Copy for raw {}
        #[allow(clippy::expl_impl_clone_on_copy)]
        impl crate::__private::Clone for raw {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl crate::__private::Debug for raw {
            fn fmt(
                &self,
                f: &mut crate::__private::Formatter,
            ) -> crate::__private::fmt::Result {
                crate::__private::Formatter::write_str(f, "Keyword [raw]")
            }
        }
        impl crate::__private::Eq for raw {}
        impl crate::__private::PartialEq for raw {
            fn eq(&self, _other: &Self) -> crate::__private::bool {
                true
            }
        }
        impl crate::__private::Hash for raw {
            fn hash<__H: crate::__private::Hasher>(&self, _state: &mut __H) {}
        }
        pub struct AllowStruct(bool);
        enum Precedence {
            Any,
            Assign,
            Range,
            Or,
            And,
            Compare,
            BitOr,
            BitXor,
            BitAnd,
            Shift,
            Arithmetic,
            Term,
            Cast,
        }
        impl Precedence {
            fn of(op: &BinOp) -> Self {
                match *op {
                    BinOp::Add(_) | BinOp::Sub(_) => Precedence::Arithmetic,
                    BinOp::Mul(_) | BinOp::Div(_) | BinOp::Rem(_) => Precedence::Term,
                    BinOp::And(_) => Precedence::And,
                    BinOp::Or(_) => Precedence::Or,
                    BinOp::BitXor(_) => Precedence::BitXor,
                    BinOp::BitAnd(_) => Precedence::BitAnd,
                    BinOp::BitOr(_) => Precedence::BitOr,
                    BinOp::Shl(_) | BinOp::Shr(_) => Precedence::Shift,
                    BinOp::Eq(_)
                    | BinOp::Lt(_)
                    | BinOp::Le(_)
                    | BinOp::Ne(_)
                    | BinOp::Ge(_)
                    | BinOp::Gt(_) => Precedence::Compare,
                    BinOp::AddEq(_)
                    | BinOp::SubEq(_)
                    | BinOp::MulEq(_)
                    | BinOp::DivEq(_)
                    | BinOp::RemEq(_)
                    | BinOp::BitXorEq(_)
                    | BinOp::BitAndEq(_)
                    | BinOp::BitOrEq(_)
                    | BinOp::ShlEq(_)
                    | BinOp::ShrEq(_) => Precedence::Assign,
                }
            }
        }
        impl Parse for Expr {
            fn parse(input: ParseStream) -> Result<Self> {
                ambiguous_expr(input, AllowStruct(true))
            }
        }
        impl Expr {
            #[cfg(feature = "full")]
            pub fn parse_without_eager_brace(input: ParseStream) -> Result<Expr> {
                ambiguous_expr(input, AllowStruct(false))
            }
        }
        impl Copy for AllowStruct {}
        impl Clone for AllowStruct {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl Copy for Precedence {}
        impl Clone for Precedence {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl PartialEq for Precedence {
            fn eq(&self, other: &Self) -> bool {
                *self as u8 == *other as u8
            }
        }
        impl PartialOrd for Precedence {
            fn partial_cmp(&self, other: &Self) -> Option<Ordering> {
                let this = *self as u8;
                let other = *other as u8;
                Some(this.cmp(&other))
            }
        }
        #[cfg(feature = "full")]
        fn parse_expr(
            input: ParseStream,
            mut lhs: Expr,
            allow_struct: AllowStruct,
            base: Precedence,
        ) -> Result<Expr> {
            loop {
                if input
                    .fork()
                    .parse::<BinOp>()
                    .ok()
                    .map_or(false, |op| Precedence::of(&op) >= base)
                {
                    let op: BinOp = input.parse()?;
                    let precedence = Precedence::of(&op);
                    let mut rhs = unary_expr(input, allow_struct)?;
                    loop {
                        let next = peek_precedence(input);
                        if next > precedence
                            || next == precedence && precedence == Precedence::Assign
                        {
                            rhs = parse_expr(input, rhs, allow_struct, next)?;
                        } else {
                            break;
                        }
                    }
                    lhs = if precedence == Precedence::Assign {
                        Expr::AssignOp(ExprAssignOp {
                            attrs: Vec::new(),
                            left: Box::new(lhs),
                            op,
                            right: Box::new(rhs),
                        })
                    } else {
                        Expr::Binary(ExprBinary {
                            attrs: Vec::new(),
                            left: Box::new(lhs),
                            op,
                            right: Box::new(rhs),
                        })
                    };
                } else if Precedence::Assign >= base && input.peek(crate::token::Eq)
                    && !input.peek(crate::token::EqEq)
                    && !input.peek(crate::token::FatArrow)
                {
                    let eq_token: crate::token::Eq = input.parse()?;
                    let mut rhs = unary_expr(input, allow_struct)?;
                    loop {
                        let next = peek_precedence(input);
                        if next >= Precedence::Assign {
                            rhs = parse_expr(input, rhs, allow_struct, next)?;
                        } else {
                            break;
                        }
                    }
                    lhs = Expr::Assign(ExprAssign {
                        attrs: Vec::new(),
                        left: Box::new(lhs),
                        eq_token,
                        right: Box::new(rhs),
                    });
                } else if Precedence::Range >= base && input.peek(crate::token::Dot2) {
                    let limits: RangeLimits = input.parse()?;
                    let rhs = if input.is_empty() || input.peek(crate::token::Comma)
                        || input.peek(crate::token::Semi)
                        || input.peek(crate::token::Dot)
                            && !input.peek(crate::token::Dot2)
                        || !allow_struct.0 && input.peek(token::Brace)
                    {
                        None
                    } else {
                        let mut rhs = unary_expr(input, allow_struct)?;
                        loop {
                            let next = peek_precedence(input);
                            if next > Precedence::Range {
                                rhs = parse_expr(input, rhs, allow_struct, next)?;
                            } else {
                                break;
                            }
                        }
                        Some(rhs)
                    };
                    lhs = Expr::Range(ExprRange {
                        attrs: Vec::new(),
                        from: Some(Box::new(lhs)),
                        limits,
                        to: rhs.map(Box::new),
                    });
                } else if Precedence::Cast >= base && input.peek(crate::token::As) {
                    let as_token: crate::token::As = input.parse()?;
                    let ty = input.call(Type::without_plus)?;
                    check_cast(input)?;
                    lhs = Expr::Cast(ExprCast {
                        attrs: Vec::new(),
                        expr: Box::new(lhs),
                        as_token,
                        ty: Box::new(ty),
                    });
                } else if Precedence::Cast >= base && input.peek(crate::token::Colon)
                    && !input.peek(crate::token::Colon2)
                {
                    let colon_token: crate::token::Colon = input.parse()?;
                    let ty = input.call(Type::without_plus)?;
                    check_cast(input)?;
                    lhs = Expr::Type(ExprType {
                        attrs: Vec::new(),
                        expr: Box::new(lhs),
                        colon_token,
                        ty: Box::new(ty),
                    });
                } else {
                    break;
                }
            }
            Ok(lhs)
        }
        fn peek_precedence(input: ParseStream) -> Precedence {
            if let Ok(op) = input.fork().parse() {
                Precedence::of(&op)
            } else if input.peek(crate::token::Eq) && !input.peek(crate::token::FatArrow)
            {
                Precedence::Assign
            } else if input.peek(crate::token::Dot2) {
                Precedence::Range
            } else if input.peek(crate::token::As)
                || true && input.peek(crate::token::Colon)
                    && !input.peek(crate::token::Colon2)
            {
                Precedence::Cast
            } else {
                Precedence::Any
            }
        }
        fn ambiguous_expr(
            input: ParseStream,
            allow_struct: AllowStruct,
        ) -> Result<Expr> {
            let lhs = unary_expr(input, allow_struct)?;
            parse_expr(input, lhs, allow_struct, Precedence::Any)
        }
        #[cfg(feature = "full")]
        fn expr_attrs(input: ParseStream) -> Result<Vec<Attribute>> {
            let mut attrs = Vec::new();
            loop {
                if input.peek(token::Group) {
                    let ahead = input.fork();
                    let group = crate::group::parse_group(&ahead)?;
                    if !group.content.peek(crate::token::Pound)
                        || group.content.peek2(crate::token::Bang)
                    {
                        break;
                    }
                    let attr = group.content.call(attr::parsing::single_parse_outer)?;
                    if !group.content.is_empty() {
                        break;
                    }
                    attrs.push(attr);
                } else if input.peek(crate::token::Pound) {
                    attrs.push(input.call(attr::parsing::single_parse_outer)?);
                } else {
                    break;
                }
            }
            Ok(attrs)
        }
        #[cfg(feature = "full")]
        fn unary_expr(input: ParseStream, allow_struct: AllowStruct) -> Result<Expr> {
            let begin = input.fork();
            let attrs = input.call(expr_attrs)?;
            if input.peek(crate::token::And) {
                let and_token: crate::token::And = input.parse()?;
                let raw: Option<raw> = if input.peek(raw)
                    && (input.peek2(crate::token::Mut)
                        || input.peek2(crate::token::Const))
                {
                    Some(input.parse()?)
                } else {
                    None
                };
                let mutability: Option<crate::token::Mut> = input.parse()?;
                if raw.is_some() && mutability.is_none() {
                    input.parse::<crate::token::Const>()?;
                }
                let expr = Box::new(unary_expr(input, allow_struct)?);
                if raw.is_some() {
                    Ok(Expr::Verbatim(verbatim::between(begin, input)))
                } else {
                    Ok(
                        Expr::Reference(ExprReference {
                            attrs,
                            and_token,
                            raw: Reserved::default(),
                            mutability,
                            expr,
                        }),
                    )
                }
            } else if input.peek(crate::token::Box) {
                expr_box(input, attrs, allow_struct).map(Expr::Box)
            } else if input.peek(crate::token::Star) || input.peek(crate::token::Bang)
                || input.peek(crate::token::Sub)
            {
                expr_unary(input, attrs, allow_struct).map(Expr::Unary)
            } else {
                trailer_expr(begin, attrs, input, allow_struct)
            }
        }
        #[cfg(feature = "full")]
        fn trailer_expr(
            begin: ParseBuffer,
            mut attrs: Vec<Attribute>,
            input: ParseStream,
            allow_struct: AllowStruct,
        ) -> Result<Expr> {
            let atom = atom_expr(input, allow_struct)?;
            let mut e = trailer_helper(input, atom)?;
            if let Expr::Verbatim(tokens) = &mut e {
                *tokens = verbatim::between(begin, input);
            } else {
                let inner_attrs = e.replace_attrs(Vec::new());
                attrs.extend(inner_attrs);
                e.replace_attrs(attrs);
            }
            Ok(e)
        }
        #[cfg(feature = "full")]
        fn trailer_helper(input: ParseStream, mut e: Expr) -> Result<Expr> {
            loop {
                if input.peek(token::Paren) {
                    let content;
                    e = Expr::Call(ExprCall {
                        attrs: Vec::new(),
                        func: Box::new(e),
                        paren_token: match crate::group::parse_parens(&input) {
                            crate::__private::Ok(parens) => {
                                content = parens.content;
                                parens.token
                            }
                            crate::__private::Err(error) => {
                                return crate::__private::Err(error);
                            }
                        },
                        args: content.parse_terminated(Expr::parse)?,
                    });
                } else if input.peek(crate::token::Dot)
                    && !input.peek(crate::token::Dot2)
                    && match e {
                        Expr::Range(_) => false,
                        _ => true,
                    }
                {
                    let mut dot_token: crate::token::Dot = input.parse()?;
                    let await_token: Option<token::Await> = input.parse()?;
                    if let Some(await_token) = await_token {
                        e = Expr::Await(ExprAwait {
                            attrs: Vec::new(),
                            base: Box::new(e),
                            dot_token,
                            await_token,
                        });
                        continue;
                    }
                    let float_token: Option<LitFloat> = input.parse()?;
                    if let Some(float_token) = float_token {
                        if multi_index(&mut e, &mut dot_token, float_token)? {
                            continue;
                        }
                    }
                    let member: Member = input.parse()?;
                    let turbofish = if member.is_named()
                        && input.peek(crate::token::Colon2)
                    {
                        Some(input.parse::<MethodTurbofish>()?)
                    } else {
                        None
                    };
                    if turbofish.is_some() || input.peek(token::Paren) {
                        if let Member::Named(method) = member {
                            let content;
                            e = Expr::MethodCall(ExprMethodCall {
                                attrs: Vec::new(),
                                receiver: Box::new(e),
                                dot_token,
                                method,
                                turbofish,
                                paren_token: match crate::group::parse_parens(&input) {
                                    crate::__private::Ok(parens) => {
                                        content = parens.content;
                                        parens.token
                                    }
                                    crate::__private::Err(error) => {
                                        return crate::__private::Err(error);
                                    }
                                },
                                args: content.parse_terminated(Expr::parse)?,
                            });
                            continue;
                        }
                    }
                    e = Expr::Field(ExprField {
                        attrs: Vec::new(),
                        base: Box::new(e),
                        dot_token,
                        member,
                    });
                } else if input.peek(token::Bracket) {
                    let content;
                    e = Expr::Index(ExprIndex {
                        attrs: Vec::new(),
                        expr: Box::new(e),
                        bracket_token: match crate::group::parse_brackets(&input) {
                            crate::__private::Ok(brackets) => {
                                content = brackets.content;
                                brackets.token
                            }
                            crate::__private::Err(error) => {
                                return crate::__private::Err(error);
                            }
                        },
                        index: content.parse()?,
                    });
                } else if input.peek(crate::token::Question) {
                    e = Expr::Try(ExprTry {
                        attrs: Vec::new(),
                        expr: Box::new(e),
                        question_token: input.parse()?,
                    });
                } else {
                    break;
                }
            }
            Ok(e)
        }
        #[cfg(feature = "full")]
        fn atom_expr(input: ParseStream, allow_struct: AllowStruct) -> Result<Expr> {
            if input.peek(token::Group) && !input.peek2(crate::token::Colon2)
                && !input.peek2(crate::token::Bang) && !input.peek2(token::Brace)
            {
                input.call(expr_group).map(Expr::Group)
            } else if input.peek(Lit) {
                input.parse().map(Expr::Lit)
            } else if input.peek(crate::token::Async)
                && (input.peek2(token::Brace)
                    || input.peek2(crate::token::Move) && input.peek3(token::Brace))
            {
                input.parse().map(Expr::Async)
            } else if input.peek(crate::token::Try) && input.peek2(token::Brace) {
                input.parse().map(Expr::TryBlock)
            } else if input.peek(crate::token::Or)
                || input.peek(crate::token::Async)
                    && (input.peek2(crate::token::Or) || input.peek2(crate::token::Move))
                || input.peek(crate::token::Static) || input.peek(crate::token::Move)
            {
                expr_closure(input, allow_struct).map(Expr::Closure)
            } else if input.peek(crate::token::For) && input.peek2(crate::token::Lt)
                && input.peek3(Lifetime)
            {
                let begin = input.fork();
                input.parse::<BoundLifetimes>()?;
                expr_closure(input, allow_struct)?;
                let verbatim = verbatim::between(begin, input);
                Ok(Expr::Verbatim(verbatim))
            } else if input.peek(Ident) || input.peek(crate::token::Colon2)
                || input.peek(crate::token::Lt) || input.peek(crate::token::SelfValue)
                || input.peek(crate::token::SelfType) || input.peek(crate::token::Super)
                || input.peek(crate::token::Crate)
            {
                path_or_macro_or_struct(input, allow_struct)
            } else if input.peek(token::Paren) {
                paren_or_tuple(input)
            } else if input.peek(crate::token::Break) {
                expr_break(input, allow_struct).map(Expr::Break)
            } else if input.peek(crate::token::Continue) {
                input.parse().map(Expr::Continue)
            } else if input.peek(crate::token::Return) {
                expr_ret(input, allow_struct).map(Expr::Return)
            } else if input.peek(token::Bracket) {
                array_or_repeat(input)
            } else if input.peek(crate::token::Let) {
                input.parse().map(Expr::Let)
            } else if input.peek(crate::token::If) {
                input.parse().map(Expr::If)
            } else if input.peek(crate::token::While) {
                input.parse().map(Expr::While)
            } else if input.peek(crate::token::For) {
                input.parse().map(Expr::ForLoop)
            } else if input.peek(crate::token::Loop) {
                input.parse().map(Expr::Loop)
            } else if input.peek(crate::token::Match) {
                input.parse().map(Expr::Match)
            } else if input.peek(crate::token::Yield) {
                input.parse().map(Expr::Yield)
            } else if input.peek(crate::token::Unsafe) {
                input.parse().map(Expr::Unsafe)
            } else if input.peek(crate::token::Const) {
                input.call(expr_const).map(Expr::Verbatim)
            } else if input.peek(token::Brace) {
                input.parse().map(Expr::Block)
            } else if input.peek(crate::token::Dot2) {
                expr_range(input, allow_struct).map(Expr::Range)
            } else if input.peek(crate::token::Underscore) {
                Ok(Expr::Verbatim(TokenStream::from(input.parse::<TokenTree>()?)))
            } else if input.peek(Lifetime) {
                let the_label: Label = input.parse()?;
                let mut expr = if input.peek(crate::token::While) {
                    Expr::While(input.parse()?)
                } else if input.peek(crate::token::For) {
                    Expr::ForLoop(input.parse()?)
                } else if input.peek(crate::token::Loop) {
                    Expr::Loop(input.parse()?)
                } else if input.peek(token::Brace) {
                    Expr::Block(input.parse()?)
                } else {
                    return Err(input.error("expected loop or block expression"));
                };
                match &mut expr {
                    Expr::While(ExprWhile { label, .. })
                    | Expr::ForLoop(ExprForLoop { label, .. })
                    | Expr::Loop(ExprLoop { label, .. })
                    | Expr::Block(ExprBlock { label, .. }) => *label = Some(the_label),
                    _ => {
                        ::core::panicking::panic(
                            "internal error: entered unreachable code",
                        )
                    }
                }
                Ok(expr)
            } else {
                Err(input.error("expected expression"))
            }
        }
        #[cfg(feature = "full")]
        fn path_or_macro_or_struct(
            input: ParseStream,
            allow_struct: AllowStruct,
        ) -> Result<Expr> {
            let begin = input.fork();
            let expr: ExprPath = input.parse()?;
            if expr.qself.is_none() && input.peek(crate::token::Bang)
                && !input.peek(crate::token::Ne)
            {
                let mut contains_arguments = false;
                for segment in &expr.path.segments {
                    match segment.arguments {
                        PathArguments::None => {}
                        PathArguments::AngleBracketed(_)
                        | PathArguments::Parenthesized(_) => {
                            contains_arguments = true;
                        }
                    }
                }
                if !contains_arguments {
                    let bang_token: crate::token::Bang = input.parse()?;
                    let (delimiter, tokens) = mac::parse_delimiter(input)?;
                    return Ok(
                        Expr::Macro(ExprMacro {
                            attrs: Vec::new(),
                            mac: Macro {
                                path: expr.path,
                                bang_token,
                                delimiter,
                                tokens,
                            },
                        }),
                    );
                }
            }
            if allow_struct.0 && input.peek(token::Brace) {
                let expr_struct = expr_struct_helper(input, expr.path)?;
                if expr.qself.is_some() {
                    Ok(Expr::Verbatim(verbatim::between(begin, input)))
                } else {
                    Ok(Expr::Struct(expr_struct))
                }
            } else {
                Ok(Expr::Path(expr))
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprMacro {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ExprMacro {
                    attrs: Vec::new(),
                    mac: input.parse()?,
                })
            }
        }
        #[cfg(feature = "full")]
        fn paren_or_tuple(input: ParseStream) -> Result<Expr> {
            let content;
            let paren_token = match crate::group::parse_parens(&input) {
                crate::__private::Ok(parens) => {
                    content = parens.content;
                    parens.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
            if content.is_empty() {
                return Ok(
                    Expr::Tuple(ExprTuple {
                        attrs: Vec::new(),
                        paren_token,
                        elems: Punctuated::new(),
                    }),
                );
            }
            let first: Expr = content.parse()?;
            if content.is_empty() {
                return Ok(
                    Expr::Paren(ExprParen {
                        attrs: Vec::new(),
                        paren_token,
                        expr: Box::new(first),
                    }),
                );
            }
            let mut elems = Punctuated::new();
            elems.push_value(first);
            while !content.is_empty() {
                let punct = content.parse()?;
                elems.push_punct(punct);
                if content.is_empty() {
                    break;
                }
                let value = content.parse()?;
                elems.push_value(value);
            }
            Ok(
                Expr::Tuple(ExprTuple {
                    attrs: Vec::new(),
                    paren_token,
                    elems,
                }),
            )
        }
        #[cfg(feature = "full")]
        fn array_or_repeat(input: ParseStream) -> Result<Expr> {
            let content;
            let bracket_token = match crate::group::parse_brackets(&input) {
                crate::__private::Ok(brackets) => {
                    content = brackets.content;
                    brackets.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
            if content.is_empty() {
                return Ok(
                    Expr::Array(ExprArray {
                        attrs: Vec::new(),
                        bracket_token,
                        elems: Punctuated::new(),
                    }),
                );
            }
            let first: Expr = content.parse()?;
            if content.is_empty() || content.peek(crate::token::Comma) {
                let mut elems = Punctuated::new();
                elems.push_value(first);
                while !content.is_empty() {
                    let punct = content.parse()?;
                    elems.push_punct(punct);
                    if content.is_empty() {
                        break;
                    }
                    let value = content.parse()?;
                    elems.push_value(value);
                }
                Ok(
                    Expr::Array(ExprArray {
                        attrs: Vec::new(),
                        bracket_token,
                        elems,
                    }),
                )
            } else if content.peek(crate::token::Semi) {
                let semi_token: crate::token::Semi = content.parse()?;
                let len: Expr = content.parse()?;
                Ok(
                    Expr::Repeat(ExprRepeat {
                        attrs: Vec::new(),
                        bracket_token,
                        expr: Box::new(first),
                        semi_token,
                        len: Box::new(len),
                    }),
                )
            } else {
                Err(content.error("expected `,` or `;`"))
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprArray {
            fn parse(input: ParseStream) -> Result<Self> {
                let content;
                let bracket_token = match crate::group::parse_brackets(&input) {
                    crate::__private::Ok(brackets) => {
                        content = brackets.content;
                        brackets.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                };
                let mut elems = Punctuated::new();
                while !content.is_empty() {
                    let first: Expr = content.parse()?;
                    elems.push_value(first);
                    if content.is_empty() {
                        break;
                    }
                    let punct = content.parse()?;
                    elems.push_punct(punct);
                }
                Ok(ExprArray {
                    attrs: Vec::new(),
                    bracket_token,
                    elems,
                })
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprRepeat {
            fn parse(input: ParseStream) -> Result<Self> {
                let content;
                Ok(ExprRepeat {
                    bracket_token: match crate::group::parse_brackets(&input) {
                        crate::__private::Ok(brackets) => {
                            content = brackets.content;
                            brackets.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    },
                    attrs: Vec::new(),
                    expr: content.parse()?,
                    semi_token: content.parse()?,
                    len: content.parse()?,
                })
            }
        }
        #[cfg(feature = "full")]
        pub(crate) fn expr_early(input: ParseStream) -> Result<Expr> {
            let mut attrs = input.call(expr_attrs)?;
            let mut expr = if input.peek(crate::token::If) {
                Expr::If(input.parse()?)
            } else if input.peek(crate::token::While) {
                Expr::While(input.parse()?)
            } else if input.peek(crate::token::For) {
                Expr::ForLoop(input.parse()?)
            } else if input.peek(crate::token::Loop) {
                Expr::Loop(input.parse()?)
            } else if input.peek(crate::token::Match) {
                Expr::Match(input.parse()?)
            } else if input.peek(crate::token::Try) && input.peek2(token::Brace) {
                Expr::TryBlock(input.parse()?)
            } else if input.peek(crate::token::Unsafe) {
                Expr::Unsafe(input.parse()?)
            } else if input.peek(crate::token::Const) {
                Expr::Verbatim(input.call(expr_const)?)
            } else if input.peek(token::Brace) {
                Expr::Block(input.parse()?)
            } else {
                let allow_struct = AllowStruct(true);
                let mut expr = unary_expr(input, allow_struct)?;
                attrs.extend(expr.replace_attrs(Vec::new()));
                expr.replace_attrs(attrs);
                return parse_expr(input, expr, allow_struct, Precedence::Any);
            };
            if input.peek(crate::token::Dot) && !input.peek(crate::token::Dot2)
                || input.peek(crate::token::Question)
            {
                expr = trailer_helper(input, expr)?;
                attrs.extend(expr.replace_attrs(Vec::new()));
                expr.replace_attrs(attrs);
                let allow_struct = AllowStruct(true);
                return parse_expr(input, expr, allow_struct, Precedence::Any);
            }
            attrs.extend(expr.replace_attrs(Vec::new()));
            expr.replace_attrs(attrs);
            Ok(expr)
        }
        impl Parse for ExprLit {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ExprLit {
                    attrs: Vec::new(),
                    lit: input.parse()?,
                })
            }
        }
        #[cfg(feature = "full")]
        fn expr_group(input: ParseStream) -> Result<ExprGroup> {
            let group = crate::group::parse_group(input)?;
            Ok(ExprGroup {
                attrs: Vec::new(),
                group_token: group.token,
                expr: group.content.parse()?,
            })
        }
        #[cfg(feature = "full")]
        impl Parse for ExprParen {
            fn parse(input: ParseStream) -> Result<Self> {
                expr_paren(input)
            }
        }
        fn expr_paren(input: ParseStream) -> Result<ExprParen> {
            let content;
            Ok(ExprParen {
                attrs: Vec::new(),
                paren_token: match crate::group::parse_parens(&input) {
                    crate::__private::Ok(parens) => {
                        content = parens.content;
                        parens.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                },
                expr: content.parse()?,
            })
        }
        #[cfg(feature = "full")]
        impl Parse for GenericMethodArgument {
            fn parse(input: ParseStream) -> Result<Self> {
                if input.peek(Lit) {
                    let lit = input.parse()?;
                    return Ok(GenericMethodArgument::Const(Expr::Lit(lit)));
                }
                if input.peek(token::Brace) {
                    let block: ExprBlock = input.parse()?;
                    return Ok(GenericMethodArgument::Const(Expr::Block(block)));
                }
                input.parse().map(GenericMethodArgument::Type)
            }
        }
        #[cfg(feature = "full")]
        impl Parse for MethodTurbofish {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(MethodTurbofish {
                    colon2_token: input.parse()?,
                    lt_token: input.parse()?,
                    args: {
                        let mut args = Punctuated::new();
                        loop {
                            if input.peek(crate::token::Gt) {
                                break;
                            }
                            let value: GenericMethodArgument = input.parse()?;
                            args.push_value(value);
                            if input.peek(crate::token::Gt) {
                                break;
                            }
                            let punct = input.parse()?;
                            args.push_punct(punct);
                        }
                        args
                    },
                    gt_token: input.parse()?,
                })
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprLet {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ExprLet {
                    attrs: Vec::new(),
                    let_token: input.parse()?,
                    pat: pat::parsing::multi_pat_with_leading_vert(input)?,
                    eq_token: input.parse()?,
                    expr: Box::new({
                        let allow_struct = AllowStruct(false);
                        let lhs = unary_expr(input, allow_struct)?;
                        parse_expr(input, lhs, allow_struct, Precedence::Compare)?
                    }),
                })
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprIf {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                Ok(ExprIf {
                    attrs,
                    if_token: input.parse()?,
                    cond: Box::new(input.call(Expr::parse_without_eager_brace)?),
                    then_branch: input.parse()?,
                    else_branch: {
                        if input.peek(crate::token::Else) {
                            Some(input.call(else_block)?)
                        } else {
                            None
                        }
                    },
                })
            }
        }
        #[cfg(feature = "full")]
        fn else_block(input: ParseStream) -> Result<(crate::token::Else, Box<Expr>)> {
            let else_token: crate::token::Else = input.parse()?;
            let lookahead = input.lookahead1();
            let else_branch = if input.peek(crate::token::If) {
                input.parse().map(Expr::If)?
            } else if input.peek(token::Brace) {
                Expr::Block(ExprBlock {
                    attrs: Vec::new(),
                    label: None,
                    block: input.parse()?,
                })
            } else {
                return Err(lookahead.error());
            };
            Ok((else_token, Box::new(else_branch)))
        }
        #[cfg(feature = "full")]
        impl Parse for ExprForLoop {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut attrs = input.call(Attribute::parse_outer)?;
                let label: Option<Label> = input.parse()?;
                let for_token: crate::token::For = input.parse()?;
                let pat = pat::parsing::multi_pat_with_leading_vert(input)?;
                let in_token: crate::token::In = input.parse()?;
                let expr: Expr = input.call(Expr::parse_without_eager_brace)?;
                let content;
                let brace_token = match crate::group::parse_braces(&input) {
                    crate::__private::Ok(braces) => {
                        content = braces.content;
                        braces.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                };
                attr::parsing::parse_inner(&content, &mut attrs)?;
                let stmts = content.call(Block::parse_within)?;
                Ok(ExprForLoop {
                    attrs,
                    label,
                    for_token,
                    pat,
                    in_token,
                    expr: Box::new(expr),
                    body: Block { brace_token, stmts },
                })
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprLoop {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut attrs = input.call(Attribute::parse_outer)?;
                let label: Option<Label> = input.parse()?;
                let loop_token: crate::token::Loop = input.parse()?;
                let content;
                let brace_token = match crate::group::parse_braces(&input) {
                    crate::__private::Ok(braces) => {
                        content = braces.content;
                        braces.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                };
                attr::parsing::parse_inner(&content, &mut attrs)?;
                let stmts = content.call(Block::parse_within)?;
                Ok(ExprLoop {
                    attrs,
                    label,
                    loop_token,
                    body: Block { brace_token, stmts },
                })
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprMatch {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut attrs = input.call(Attribute::parse_outer)?;
                let match_token: crate::token::Match = input.parse()?;
                let expr = Expr::parse_without_eager_brace(input)?;
                let content;
                let brace_token = match crate::group::parse_braces(&input) {
                    crate::__private::Ok(braces) => {
                        content = braces.content;
                        braces.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                };
                attr::parsing::parse_inner(&content, &mut attrs)?;
                let mut arms = Vec::new();
                while !content.is_empty() {
                    arms.push(content.call(Arm::parse)?);
                }
                Ok(ExprMatch {
                    attrs,
                    match_token,
                    expr: Box::new(expr),
                    brace_token,
                    arms,
                })
            }
        }
        #[cfg(all(feature = "full", feature = "printing"))]
        impl Parse for ExprAssign {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut expr: Expr = input.parse()?;
                loop {
                    match expr {
                        Expr::Assign(inner) => return Ok(inner),
                        Expr::Group(next) => expr = *next.expr,
                        _ => {
                            return Err(
                                Error::new_spanned(expr, "expected assignment expression"),
                            );
                        }
                    }
                }
            }
        }
        #[cfg(all(feature = "full", feature = "printing"))]
        impl Parse for ExprAssignOp {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut expr: Expr = input.parse()?;
                loop {
                    match expr {
                        Expr::AssignOp(inner) => return Ok(inner),
                        Expr::Group(next) => expr = *next.expr,
                        _ => {
                            return Err(
                                Error::new_spanned(
                                    expr,
                                    "expected compound assignment expression",
                                ),
                            );
                        }
                    }
                }
            }
        }
        #[cfg(all(feature = "full", feature = "printing"))]
        impl Parse for ExprAwait {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut expr: Expr = input.parse()?;
                loop {
                    match expr {
                        Expr::Await(inner) => return Ok(inner),
                        Expr::Group(next) => expr = *next.expr,
                        _ => {
                            return Err(
                                Error::new_spanned(expr, "expected await expression"),
                            );
                        }
                    }
                }
            }
        }
        #[cfg(all(feature = "full", feature = "printing"))]
        impl Parse for ExprBinary {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut expr: Expr = input.parse()?;
                loop {
                    match expr {
                        Expr::Binary(inner) => return Ok(inner),
                        Expr::Group(next) => expr = *next.expr,
                        _ => {
                            return Err(
                                Error::new_spanned(expr, "expected binary operation"),
                            );
                        }
                    }
                }
            }
        }
        #[cfg(all(feature = "full", feature = "printing"))]
        impl Parse for ExprCall {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut expr: Expr = input.parse()?;
                loop {
                    match expr {
                        Expr::Call(inner) => return Ok(inner),
                        Expr::Group(next) => expr = *next.expr,
                        _ => {
                            return Err(
                                Error::new_spanned(
                                    expr,
                                    "expected function call expression",
                                ),
                            );
                        }
                    }
                }
            }
        }
        #[cfg(all(feature = "full", feature = "printing"))]
        impl Parse for ExprCast {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut expr: Expr = input.parse()?;
                loop {
                    match expr {
                        Expr::Cast(inner) => return Ok(inner),
                        Expr::Group(next) => expr = *next.expr,
                        _ => {
                            return Err(
                                Error::new_spanned(expr, "expected cast expression"),
                            );
                        }
                    }
                }
            }
        }
        #[cfg(all(feature = "full", feature = "printing"))]
        impl Parse for ExprField {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut expr: Expr = input.parse()?;
                loop {
                    match expr {
                        Expr::Field(inner) => return Ok(inner),
                        Expr::Group(next) => expr = *next.expr,
                        _ => {
                            return Err(
                                Error::new_spanned(expr, "expected struct field access"),
                            );
                        }
                    }
                }
            }
        }
        #[cfg(all(feature = "full", feature = "printing"))]
        impl Parse for ExprIndex {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut expr: Expr = input.parse()?;
                loop {
                    match expr {
                        Expr::Index(inner) => return Ok(inner),
                        Expr::Group(next) => expr = *next.expr,
                        _ => {
                            return Err(
                                Error::new_spanned(expr, "expected indexing expression"),
                            );
                        }
                    }
                }
            }
        }
        #[cfg(all(feature = "full", feature = "printing"))]
        impl Parse for ExprMethodCall {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut expr: Expr = input.parse()?;
                loop {
                    match expr {
                        Expr::MethodCall(inner) => return Ok(inner),
                        Expr::Group(next) => expr = *next.expr,
                        _ => {
                            return Err(
                                Error::new_spanned(expr, "expected method call expression"),
                            );
                        }
                    }
                }
            }
        }
        #[cfg(all(feature = "full", feature = "printing"))]
        impl Parse for ExprRange {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut expr: Expr = input.parse()?;
                loop {
                    match expr {
                        Expr::Range(inner) => return Ok(inner),
                        Expr::Group(next) => expr = *next.expr,
                        _ => {
                            return Err(
                                Error::new_spanned(expr, "expected range expression"),
                            );
                        }
                    }
                }
            }
        }
        #[cfg(all(feature = "full", feature = "printing"))]
        impl Parse for ExprTry {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut expr: Expr = input.parse()?;
                loop {
                    match expr {
                        Expr::Try(inner) => return Ok(inner),
                        Expr::Group(next) => expr = *next.expr,
                        _ => {
                            return Err(
                                Error::new_spanned(expr, "expected try expression"),
                            );
                        }
                    }
                }
            }
        }
        #[cfg(all(feature = "full", feature = "printing"))]
        impl Parse for ExprTuple {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut expr: Expr = input.parse()?;
                loop {
                    match expr {
                        Expr::Tuple(inner) => return Ok(inner),
                        Expr::Group(next) => expr = *next.expr,
                        _ => {
                            return Err(
                                Error::new_spanned(expr, "expected tuple expression"),
                            );
                        }
                    }
                }
            }
        }
        #[cfg(all(feature = "full", feature = "printing"))]
        impl Parse for ExprType {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut expr: Expr = input.parse()?;
                loop {
                    match expr {
                        Expr::Type(inner) => return Ok(inner),
                        Expr::Group(next) => expr = *next.expr,
                        _ => {
                            return Err(
                                Error::new_spanned(
                                    expr,
                                    "expected type ascription expression",
                                ),
                            );
                        }
                    }
                }
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprBox {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = Vec::new();
                let allow_struct = AllowStruct(true);
                expr_box(input, attrs, allow_struct)
            }
        }
        #[cfg(feature = "full")]
        fn expr_box(
            input: ParseStream,
            attrs: Vec<Attribute>,
            allow_struct: AllowStruct,
        ) -> Result<ExprBox> {
            Ok(ExprBox {
                attrs,
                box_token: input.parse()?,
                expr: Box::new(unary_expr(input, allow_struct)?),
            })
        }
        #[cfg(feature = "full")]
        impl Parse for ExprUnary {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = Vec::new();
                let allow_struct = AllowStruct(true);
                expr_unary(input, attrs, allow_struct)
            }
        }
        #[cfg(feature = "full")]
        fn expr_unary(
            input: ParseStream,
            attrs: Vec<Attribute>,
            allow_struct: AllowStruct,
        ) -> Result<ExprUnary> {
            Ok(ExprUnary {
                attrs,
                op: input.parse()?,
                expr: Box::new(unary_expr(input, allow_struct)?),
            })
        }
        #[cfg(feature = "full")]
        impl Parse for ExprClosure {
            fn parse(input: ParseStream) -> Result<Self> {
                let allow_struct = AllowStruct(true);
                expr_closure(input, allow_struct)
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprReference {
            fn parse(input: ParseStream) -> Result<Self> {
                let allow_struct = AllowStruct(true);
                Ok(ExprReference {
                    attrs: Vec::new(),
                    and_token: input.parse()?,
                    raw: Reserved::default(),
                    mutability: input.parse()?,
                    expr: Box::new(unary_expr(input, allow_struct)?),
                })
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprBreak {
            fn parse(input: ParseStream) -> Result<Self> {
                let allow_struct = AllowStruct(true);
                expr_break(input, allow_struct)
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprReturn {
            fn parse(input: ParseStream) -> Result<Self> {
                let allow_struct = AllowStruct(true);
                expr_ret(input, allow_struct)
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprTryBlock {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ExprTryBlock {
                    attrs: Vec::new(),
                    try_token: input.parse()?,
                    block: input.parse()?,
                })
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprYield {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ExprYield {
                    attrs: Vec::new(),
                    yield_token: input.parse()?,
                    expr: {
                        if !input.is_empty() && !input.peek(crate::token::Comma)
                            && !input.peek(crate::token::Semi)
                        {
                            Some(input.parse()?)
                        } else {
                            None
                        }
                    },
                })
            }
        }
        #[cfg(feature = "full")]
        fn expr_closure(
            input: ParseStream,
            allow_struct: AllowStruct,
        ) -> Result<ExprClosure> {
            let movability: Option<crate::token::Static> = input.parse()?;
            let asyncness: Option<crate::token::Async> = input.parse()?;
            let capture: Option<crate::token::Move> = input.parse()?;
            let or1_token: crate::token::Or = input.parse()?;
            let mut inputs = Punctuated::new();
            loop {
                if input.peek(crate::token::Or) {
                    break;
                }
                let value = closure_arg(input)?;
                inputs.push_value(value);
                if input.peek(crate::token::Or) {
                    break;
                }
                let punct: crate::token::Comma = input.parse()?;
                inputs.push_punct(punct);
            }
            let or2_token: crate::token::Or = input.parse()?;
            let (output, body) = if input.peek(crate::token::RArrow) {
                let arrow_token: crate::token::RArrow = input.parse()?;
                let ty: Type = input.parse()?;
                let body: Block = input.parse()?;
                let output = ReturnType::Type(arrow_token, Box::new(ty));
                let block = Expr::Block(ExprBlock {
                    attrs: Vec::new(),
                    label: None,
                    block: body,
                });
                (output, block)
            } else {
                let body = ambiguous_expr(input, allow_struct)?;
                (ReturnType::Default, body)
            };
            Ok(ExprClosure {
                attrs: Vec::new(),
                movability,
                asyncness,
                capture,
                or1_token,
                inputs,
                or2_token,
                output,
                body: Box::new(body),
            })
        }
        #[cfg(feature = "full")]
        impl Parse for ExprAsync {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ExprAsync {
                    attrs: Vec::new(),
                    async_token: input.parse()?,
                    capture: input.parse()?,
                    block: input.parse()?,
                })
            }
        }
        #[cfg(feature = "full")]
        fn closure_arg(input: ParseStream) -> Result<Pat> {
            let attrs = input.call(Attribute::parse_outer)?;
            let mut pat: Pat = input.parse()?;
            if input.peek(crate::token::Colon) {
                Ok(
                    Pat::Type(PatType {
                        attrs,
                        pat: Box::new(pat),
                        colon_token: input.parse()?,
                        ty: input.parse()?,
                    }),
                )
            } else {
                match &mut pat {
                    Pat::Box(pat) => pat.attrs = attrs,
                    Pat::Ident(pat) => pat.attrs = attrs,
                    Pat::Lit(pat) => pat.attrs = attrs,
                    Pat::Macro(pat) => pat.attrs = attrs,
                    Pat::Or(pat) => pat.attrs = attrs,
                    Pat::Path(pat) => pat.attrs = attrs,
                    Pat::Range(pat) => pat.attrs = attrs,
                    Pat::Reference(pat) => pat.attrs = attrs,
                    Pat::Rest(pat) => pat.attrs = attrs,
                    Pat::Slice(pat) => pat.attrs = attrs,
                    Pat::Struct(pat) => pat.attrs = attrs,
                    Pat::Tuple(pat) => pat.attrs = attrs,
                    Pat::TupleStruct(pat) => pat.attrs = attrs,
                    Pat::Type(_) => {
                        ::core::panicking::panic(
                            "internal error: entered unreachable code",
                        )
                    }
                    Pat::Verbatim(_) => {}
                    Pat::Wild(pat) => pat.attrs = attrs,
                }
                Ok(pat)
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprWhile {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut attrs = input.call(Attribute::parse_outer)?;
                let label: Option<Label> = input.parse()?;
                let while_token: crate::token::While = input.parse()?;
                let cond = Expr::parse_without_eager_brace(input)?;
                let content;
                let brace_token = match crate::group::parse_braces(&input) {
                    crate::__private::Ok(braces) => {
                        content = braces.content;
                        braces.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                };
                attr::parsing::parse_inner(&content, &mut attrs)?;
                let stmts = content.call(Block::parse_within)?;
                Ok(ExprWhile {
                    attrs,
                    label,
                    while_token,
                    cond: Box::new(cond),
                    body: Block { brace_token, stmts },
                })
            }
        }
        #[cfg(feature = "full")]
        impl Parse for Label {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(Label {
                    name: input.parse()?,
                    colon_token: input.parse()?,
                })
            }
        }
        #[cfg(feature = "full")]
        impl Parse for Option<Label> {
            fn parse(input: ParseStream) -> Result<Self> {
                if input.peek(Lifetime) { input.parse().map(Some) } else { Ok(None) }
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprContinue {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ExprContinue {
                    attrs: Vec::new(),
                    continue_token: input.parse()?,
                    label: input.parse()?,
                })
            }
        }
        #[cfg(feature = "full")]
        fn expr_break(
            input: ParseStream,
            allow_struct: AllowStruct,
        ) -> Result<ExprBreak> {
            Ok(ExprBreak {
                attrs: Vec::new(),
                break_token: input.parse()?,
                label: input.parse()?,
                expr: {
                    if input.is_empty() || input.peek(crate::token::Comma)
                        || input.peek(crate::token::Semi)
                        || !allow_struct.0 && input.peek(token::Brace)
                    {
                        None
                    } else {
                        let expr = ambiguous_expr(input, allow_struct)?;
                        Some(Box::new(expr))
                    }
                },
            })
        }
        #[cfg(feature = "full")]
        fn expr_ret(
            input: ParseStream,
            allow_struct: AllowStruct,
        ) -> Result<ExprReturn> {
            Ok(ExprReturn {
                attrs: Vec::new(),
                return_token: input.parse()?,
                expr: {
                    if input.is_empty() || input.peek(crate::token::Comma)
                        || input.peek(crate::token::Semi)
                    {
                        None
                    } else {
                        let expr = ambiguous_expr(input, allow_struct)?;
                        Some(Box::new(expr))
                    }
                },
            })
        }
        #[cfg(feature = "full")]
        impl Parse for FieldValue {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let member: Member = input.parse()?;
                let (colon_token, value) = if input.peek(crate::token::Colon)
                    || !member.is_named()
                {
                    let colon_token: crate::token::Colon = input.parse()?;
                    let value: Expr = input.parse()?;
                    (Some(colon_token), value)
                } else if let Member::Named(ident) = &member {
                    let value = Expr::Path(ExprPath {
                        attrs: Vec::new(),
                        qself: None,
                        path: Path::from(ident.clone()),
                    });
                    (None, value)
                } else {
                    ::core::panicking::panic("internal error: entered unreachable code")
                };
                Ok(FieldValue {
                    attrs,
                    member,
                    colon_token,
                    expr: value,
                })
            }
        }
        #[cfg(feature = "full")]
        impl Parse for ExprStruct {
            fn parse(input: ParseStream) -> Result<Self> {
                let path: Path = input.parse()?;
                expr_struct_helper(input, path)
            }
        }
        #[cfg(feature = "full")]
        fn expr_struct_helper(input: ParseStream, path: Path) -> Result<ExprStruct> {
            let content;
            let brace_token = match crate::group::parse_braces(&input) {
                crate::__private::Ok(braces) => {
                    content = braces.content;
                    braces.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
            let mut fields = Punctuated::new();
            while !content.is_empty() {
                if content.peek(crate::token::Dot2) {
                    return Ok(ExprStruct {
                        attrs: Vec::new(),
                        brace_token,
                        path,
                        fields,
                        dot2_token: Some(content.parse()?),
                        rest: if content.is_empty() {
                            None
                        } else {
                            Some(Box::new(content.parse()?))
                        },
                    });
                }
                fields.push(content.parse()?);
                if content.is_empty() {
                    break;
                }
                let punct: crate::token::Comma = content.parse()?;
                fields.push_punct(punct);
            }
            Ok(ExprStruct {
                attrs: Vec::new(),
                brace_token,
                path,
                fields,
                dot2_token: None,
                rest: None,
            })
        }
        #[cfg(feature = "full")]
        impl Parse for ExprUnsafe {
            fn parse(input: ParseStream) -> Result<Self> {
                let unsafe_token: crate::token::Unsafe = input.parse()?;
                let content;
                let brace_token = match crate::group::parse_braces(&input) {
                    crate::__private::Ok(braces) => {
                        content = braces.content;
                        braces.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                };
                let inner_attrs = content.call(Attribute::parse_inner)?;
                let stmts = content.call(Block::parse_within)?;
                Ok(ExprUnsafe {
                    attrs: inner_attrs,
                    unsafe_token,
                    block: Block { brace_token, stmts },
                })
            }
        }
        #[cfg(feature = "full")]
        pub(crate) fn expr_const(input: ParseStream) -> Result<TokenStream> {
            let begin = input.fork();
            input.parse::<crate::token::Const>()?;
            let content;
            match crate::group::parse_braces(&input) {
                crate::__private::Ok(braces) => {
                    content = braces.content;
                    braces.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
            content.call(Attribute::parse_inner)?;
            content.call(Block::parse_within)?;
            Ok(verbatim::between(begin, input))
        }
        #[cfg(feature = "full")]
        impl Parse for ExprBlock {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut attrs = input.call(Attribute::parse_outer)?;
                let label: Option<Label> = input.parse()?;
                let content;
                let brace_token = match crate::group::parse_braces(&input) {
                    crate::__private::Ok(braces) => {
                        content = braces.content;
                        braces.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                };
                attr::parsing::parse_inner(&content, &mut attrs)?;
                let stmts = content.call(Block::parse_within)?;
                Ok(ExprBlock {
                    attrs,
                    label,
                    block: Block { brace_token, stmts },
                })
            }
        }
        #[cfg(feature = "full")]
        fn expr_range(
            input: ParseStream,
            allow_struct: AllowStruct,
        ) -> Result<ExprRange> {
            Ok(ExprRange {
                attrs: Vec::new(),
                from: None,
                limits: input.parse()?,
                to: {
                    if input.is_empty() || input.peek(crate::token::Comma)
                        || input.peek(crate::token::Semi)
                        || input.peek(crate::token::Dot)
                            && !input.peek(crate::token::Dot2)
                        || !allow_struct.0 && input.peek(token::Brace)
                    {
                        None
                    } else {
                        let to = ambiguous_expr(input, allow_struct)?;
                        Some(Box::new(to))
                    }
                },
            })
        }
        #[cfg(feature = "full")]
        impl Parse for RangeLimits {
            fn parse(input: ParseStream) -> Result<Self> {
                let lookahead = input.lookahead1();
                if lookahead.peek(crate::token::DotDotEq) {
                    input.parse().map(RangeLimits::Closed)
                } else if lookahead.peek(crate::token::Dot3) {
                    let dot3: crate::token::Dot3 = input.parse()?;
                    Ok(RangeLimits::Closed(crate::token::DotDotEq(dot3.spans)))
                } else if lookahead.peek(crate::token::Dot2) {
                    input.parse().map(RangeLimits::HalfOpen)
                } else {
                    Err(lookahead.error())
                }
            }
        }
        impl Parse for ExprPath {
            fn parse(input: ParseStream) -> Result<Self> {
                #[cfg(feature = "full")]
                let attrs = input.call(Attribute::parse_outer)?;
                let (qself, path) = path::parsing::qpath(input, true)?;
                Ok(ExprPath { attrs, qself, path })
            }
        }
        impl Parse for Member {
            fn parse(input: ParseStream) -> Result<Self> {
                if input.peek(Ident) {
                    input.parse().map(Member::Named)
                } else if input.peek(LitInt) {
                    input.parse().map(Member::Unnamed)
                } else {
                    Err(input.error("expected identifier or integer"))
                }
            }
        }
        #[cfg(feature = "full")]
        impl Parse for Arm {
            fn parse(input: ParseStream) -> Result<Arm> {
                let requires_comma;
                Ok(Arm {
                    attrs: input.call(Attribute::parse_outer)?,
                    pat: pat::parsing::multi_pat_with_leading_vert(input)?,
                    guard: {
                        if input.peek(crate::token::If) {
                            let if_token: crate::token::If = input.parse()?;
                            let guard: Expr = input.parse()?;
                            Some((if_token, Box::new(guard)))
                        } else {
                            None
                        }
                    },
                    fat_arrow_token: input.parse()?,
                    body: {
                        let body = input.call(expr_early)?;
                        requires_comma = requires_terminator(&body);
                        Box::new(body)
                    },
                    comma: {
                        if requires_comma && !input.is_empty() {
                            Some(input.parse()?)
                        } else {
                            input.parse()?
                        }
                    },
                })
            }
        }
        impl Parse for Index {
            fn parse(input: ParseStream) -> Result<Self> {
                let lit: LitInt = input.parse()?;
                if lit.suffix().is_empty() {
                    Ok(Index {
                        index: lit
                            .base10_digits()
                            .parse()
                            .map_err(|err| Error::new(lit.span(), err))?,
                        span: lit.span(),
                    })
                } else {
                    Err(Error::new(lit.span(), "expected unsuffixed integer"))
                }
            }
        }
        fn multi_index(
            e: &mut Expr,
            dot_token: &mut crate::token::Dot,
            float: LitFloat,
        ) -> Result<bool> {
            let mut float_repr = float.to_string();
            let trailing_dot = float_repr.ends_with('.');
            if trailing_dot {
                float_repr.truncate(float_repr.len() - 1);
            }
            for part in float_repr.split('.') {
                let index = crate::parse_str(part)
                    .map_err(|err| Error::new(float.span(), err))?;
                #[cfg(not(syn_no_const_vec_new))]
                let base = mem::replace(e, Expr::DUMMY);
                *e = Expr::Field(ExprField {
                    attrs: Vec::new(),
                    base: Box::new(base),
                    dot_token: crate::token::Dot(dot_token.span),
                    member: Member::Unnamed(index),
                });
                *dot_token = crate::token::Dot(float.span());
            }
            Ok(!trailing_dot)
        }
        #[cfg(feature = "full")]
        impl Member {
            fn is_named(&self) -> bool {
                match *self {
                    Member::Named(_) => true,
                    Member::Unnamed(_) => false,
                }
            }
        }
        fn check_cast(input: ParseStream) -> Result<()> {
            let kind = if input.peek(crate::token::Dot)
                && !input.peek(crate::token::Dot2)
            {
                if input.peek2(token::Await) {
                    "`.await`"
                } else if input.peek2(Ident)
                    && (input.peek3(token::Paren) || input.peek3(crate::token::Colon2))
                {
                    "a method call"
                } else {
                    "a field access"
                }
            } else if input.peek(crate::token::Question) {
                "`?`"
            } else if input.peek(token::Bracket) {
                "indexing"
            } else if input.peek(token::Paren) {
                "a function call"
            } else {
                return Ok(());
            };
            let msg = {
                let res = ::alloc::fmt::format(
                    ::core::fmt::Arguments::new_v1(
                        &["casts cannot be followed by "],
                        &[::core::fmt::ArgumentV1::new_display(&kind)],
                    ),
                );
                res
            };
            Err(input.error(msg))
        }
    }
    #[cfg(feature = "printing")]
    pub(crate) mod printing {
        use super::*;
        #[cfg(feature = "full")]
        use crate::attr::FilterAttrs;
        use proc_macro2::{Literal, TokenStream};
        use quote::{ToTokens, TokenStreamExt};
        #[cfg(feature = "full")]
        fn wrap_bare_struct(tokens: &mut TokenStream, e: &Expr) {
            if let Expr::Struct(_) = *e {
                token::Paren::default()
                    .surround(
                        tokens,
                        |tokens| {
                            e.to_tokens(tokens);
                        },
                    );
            } else {
                e.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        pub(crate) fn outer_attrs_to_tokens(
            attrs: &[Attribute],
            tokens: &mut TokenStream,
        ) {
            tokens.append_all(attrs.outer());
        }
        #[cfg(feature = "full")]
        fn inner_attrs_to_tokens(attrs: &[Attribute], tokens: &mut TokenStream) {
            tokens.append_all(attrs.inner());
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprBox {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.box_token.to_tokens(tokens);
                self.expr.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprArray {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.bracket_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.elems.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for ExprCall {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.func.to_tokens(tokens);
                self.paren_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.args.to_tokens(tokens);
                        },
                    );
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprMethodCall {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.receiver.to_tokens(tokens);
                self.dot_token.to_tokens(tokens);
                self.method.to_tokens(tokens);
                self.turbofish.to_tokens(tokens);
                self.paren_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.args.to_tokens(tokens);
                        },
                    );
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for MethodTurbofish {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.colon2_token.to_tokens(tokens);
                self.lt_token.to_tokens(tokens);
                self.args.to_tokens(tokens);
                self.gt_token.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for GenericMethodArgument {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                match self {
                    GenericMethodArgument::Type(t) => t.to_tokens(tokens),
                    GenericMethodArgument::Const(c) => c.to_tokens(tokens),
                }
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprTuple {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.paren_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.elems.to_tokens(tokens);
                            if self.elems.len() == 1 && !self.elems.trailing_punct() {
                                <crate::token::Comma>::default().to_tokens(tokens);
                            }
                        },
                    );
            }
        }
        impl ToTokens for ExprBinary {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.left.to_tokens(tokens);
                self.op.to_tokens(tokens);
                self.right.to_tokens(tokens);
            }
        }
        impl ToTokens for ExprUnary {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.op.to_tokens(tokens);
                self.expr.to_tokens(tokens);
            }
        }
        impl ToTokens for ExprLit {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.lit.to_tokens(tokens);
            }
        }
        impl ToTokens for ExprCast {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.expr.to_tokens(tokens);
                self.as_token.to_tokens(tokens);
                self.ty.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprType {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.expr.to_tokens(tokens);
                self.colon_token.to_tokens(tokens);
                self.ty.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        fn maybe_wrap_else(
            tokens: &mut TokenStream,
            else_: &Option<(crate::token::Else, Box<Expr>)>,
        ) {
            if let Some((else_token, else_)) = else_ {
                else_token.to_tokens(tokens);
                match **else_ {
                    Expr::If(_) | Expr::Block(_) => {
                        else_.to_tokens(tokens);
                    }
                    _ => {
                        token::Brace::default()
                            .surround(
                                tokens,
                                |tokens| {
                                    else_.to_tokens(tokens);
                                },
                            );
                    }
                }
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprLet {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.let_token.to_tokens(tokens);
                self.pat.to_tokens(tokens);
                self.eq_token.to_tokens(tokens);
                wrap_bare_struct(tokens, &self.expr);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprIf {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.if_token.to_tokens(tokens);
                wrap_bare_struct(tokens, &self.cond);
                self.then_branch.to_tokens(tokens);
                maybe_wrap_else(tokens, &self.else_branch);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprWhile {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.label.to_tokens(tokens);
                self.while_token.to_tokens(tokens);
                wrap_bare_struct(tokens, &self.cond);
                self.body
                    .brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            inner_attrs_to_tokens(&self.attrs, tokens);
                            tokens.append_all(&self.body.stmts);
                        },
                    );
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprForLoop {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.label.to_tokens(tokens);
                self.for_token.to_tokens(tokens);
                self.pat.to_tokens(tokens);
                self.in_token.to_tokens(tokens);
                wrap_bare_struct(tokens, &self.expr);
                self.body
                    .brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            inner_attrs_to_tokens(&self.attrs, tokens);
                            tokens.append_all(&self.body.stmts);
                        },
                    );
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprLoop {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.label.to_tokens(tokens);
                self.loop_token.to_tokens(tokens);
                self.body
                    .brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            inner_attrs_to_tokens(&self.attrs, tokens);
                            tokens.append_all(&self.body.stmts);
                        },
                    );
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprMatch {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.match_token.to_tokens(tokens);
                wrap_bare_struct(tokens, &self.expr);
                self.brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            inner_attrs_to_tokens(&self.attrs, tokens);
                            for (i, arm) in self.arms.iter().enumerate() {
                                arm.to_tokens(tokens);
                                let is_last = i == self.arms.len() - 1;
                                if !is_last && requires_terminator(&arm.body)
                                    && arm.comma.is_none()
                                {
                                    <crate::token::Comma>::default().to_tokens(tokens);
                                }
                            }
                        },
                    );
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprAsync {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.async_token.to_tokens(tokens);
                self.capture.to_tokens(tokens);
                self.block.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprAwait {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.base.to_tokens(tokens);
                self.dot_token.to_tokens(tokens);
                self.await_token.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprTryBlock {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.try_token.to_tokens(tokens);
                self.block.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprYield {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.yield_token.to_tokens(tokens);
                self.expr.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprClosure {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.movability.to_tokens(tokens);
                self.asyncness.to_tokens(tokens);
                self.capture.to_tokens(tokens);
                self.or1_token.to_tokens(tokens);
                self.inputs.to_tokens(tokens);
                self.or2_token.to_tokens(tokens);
                self.output.to_tokens(tokens);
                self.body.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprUnsafe {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.unsafe_token.to_tokens(tokens);
                self.block
                    .brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            inner_attrs_to_tokens(&self.attrs, tokens);
                            tokens.append_all(&self.block.stmts);
                        },
                    );
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprBlock {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.label.to_tokens(tokens);
                self.block
                    .brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            inner_attrs_to_tokens(&self.attrs, tokens);
                            tokens.append_all(&self.block.stmts);
                        },
                    );
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprAssign {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.left.to_tokens(tokens);
                self.eq_token.to_tokens(tokens);
                self.right.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprAssignOp {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.left.to_tokens(tokens);
                self.op.to_tokens(tokens);
                self.right.to_tokens(tokens);
            }
        }
        impl ToTokens for ExprField {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.base.to_tokens(tokens);
                self.dot_token.to_tokens(tokens);
                self.member.to_tokens(tokens);
            }
        }
        impl ToTokens for Member {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                match self {
                    Member::Named(ident) => ident.to_tokens(tokens),
                    Member::Unnamed(index) => index.to_tokens(tokens),
                }
            }
        }
        impl ToTokens for Index {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                let mut lit = Literal::i64_unsuffixed(i64::from(self.index));
                lit.set_span(self.span);
                tokens.append(lit);
            }
        }
        impl ToTokens for ExprIndex {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.expr.to_tokens(tokens);
                self.bracket_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.index.to_tokens(tokens);
                        },
                    );
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for RangeLimits {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                match self {
                    RangeLimits::HalfOpen(t) => t.to_tokens(tokens),
                    RangeLimits::Closed(t) => t.to_tokens(tokens),
                }
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprRange {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.from.to_tokens(tokens);
                self.limits.to_tokens(tokens);
                self.to.to_tokens(tokens);
            }
        }
        impl ToTokens for ExprPath {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                path::printing::print_path(tokens, &self.qself, &self.path);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprReference {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.and_token.to_tokens(tokens);
                self.mutability.to_tokens(tokens);
                self.expr.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprBreak {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.break_token.to_tokens(tokens);
                self.label.to_tokens(tokens);
                self.expr.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprContinue {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.continue_token.to_tokens(tokens);
                self.label.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprReturn {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.return_token.to_tokens(tokens);
                self.expr.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprMacro {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.mac.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprStruct {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.path.to_tokens(tokens);
                self.brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.fields.to_tokens(tokens);
                            if let Some(dot2_token) = &self.dot2_token {
                                dot2_token.to_tokens(tokens);
                            } else if self.rest.is_some() {
                                crate::token::Dot2(Span::call_site()).to_tokens(tokens);
                            }
                            self.rest.to_tokens(tokens);
                        },
                    );
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprRepeat {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.bracket_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.expr.to_tokens(tokens);
                            self.semi_token.to_tokens(tokens);
                            self.len.to_tokens(tokens);
                        },
                    );
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprGroup {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.group_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.expr.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for ExprParen {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.paren_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.expr.to_tokens(tokens);
                        },
                    );
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for ExprTry {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.expr.to_tokens(tokens);
                self.question_token.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for Label {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.name.to_tokens(tokens);
                self.colon_token.to_tokens(tokens);
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for FieldValue {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                outer_attrs_to_tokens(&self.attrs, tokens);
                self.member.to_tokens(tokens);
                if let Some(colon_token) = &self.colon_token {
                    colon_token.to_tokens(tokens);
                    self.expr.to_tokens(tokens);
                }
            }
        }
        #[cfg(feature = "full")]
        impl ToTokens for Arm {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(&self.attrs);
                self.pat.to_tokens(tokens);
                if let Some((if_token, guard)) = &self.guard {
                    if_token.to_tokens(tokens);
                    guard.to_tokens(tokens);
                }
                self.fat_arrow_token.to_tokens(tokens);
                self.body.to_tokens(tokens);
                self.comma.to_tokens(tokens);
            }
        }
    }
}
#[cfg(feature = "full")]
pub use crate::expr::{
    Arm, FieldValue, GenericMethodArgument, Label, MethodTurbofish, RangeLimits,
};
#[cfg(any(feature = "full", feature = "derive"))]
pub use crate::expr::{
    Expr, ExprArray, ExprAssign, ExprAssignOp, ExprAsync, ExprAwait, ExprBinary,
    ExprBlock, ExprBox, ExprBreak, ExprCall, ExprCast, ExprClosure, ExprContinue,
    ExprField, ExprForLoop, ExprGroup, ExprIf, ExprIndex, ExprLet, ExprLit, ExprLoop,
    ExprMacro, ExprMatch, ExprMethodCall, ExprParen, ExprPath, ExprRange, ExprReference,
    ExprRepeat, ExprReturn, ExprStruct, ExprTry, ExprTryBlock, ExprTuple, ExprType,
    ExprUnary, ExprUnsafe, ExprWhile, ExprYield, Index, Member,
};
#[cfg(any(feature = "full", feature = "derive"))]
mod generics {
    use super::*;
    use crate::punctuated::{Iter, IterMut, Punctuated};
    #[cfg(all(feature = "printing", feature = "extra-traits"))]
    use std::fmt::{self, Debug};
    #[cfg(all(feature = "printing", feature = "extra-traits"))]
    use std::hash::{Hash, Hasher};
    pub struct Generics {
        pub lt_token: Option<crate::token::Lt>,
        pub params: Punctuated<GenericParam, crate::token::Comma>,
        pub gt_token: Option<crate::token::Gt>,
        pub where_clause: Option<WhereClause>,
    }
    pub enum GenericParam {
        Type(TypeParam),
        Lifetime(LifetimeDef),
        Const(ConstParam),
    }
    impl From<TypeParam> for GenericParam {
        fn from(e: TypeParam) -> GenericParam {
            GenericParam::Type(e)
        }
    }
    impl From<LifetimeDef> for GenericParam {
        fn from(e: LifetimeDef) -> GenericParam {
            GenericParam::Lifetime(e)
        }
    }
    impl From<ConstParam> for GenericParam {
        fn from(e: ConstParam) -> GenericParam {
            GenericParam::Const(e)
        }
    }
    impl ::quote::ToTokens for GenericParam {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                GenericParam::Type(_e) => _e.to_tokens(tokens),
                GenericParam::Lifetime(_e) => _e.to_tokens(tokens),
                GenericParam::Const(_e) => _e.to_tokens(tokens),
            }
        }
    }
    pub struct TypeParam {
        pub attrs: Vec<Attribute>,
        pub ident: Ident,
        pub colon_token: Option<crate::token::Colon>,
        pub bounds: Punctuated<TypeParamBound, crate::token::Add>,
        pub eq_token: Option<crate::token::Eq>,
        pub default: Option<Type>,
    }
    pub struct LifetimeDef {
        pub attrs: Vec<Attribute>,
        pub lifetime: Lifetime,
        pub colon_token: Option<crate::token::Colon>,
        pub bounds: Punctuated<Lifetime, crate::token::Add>,
    }
    pub struct ConstParam {
        pub attrs: Vec<Attribute>,
        pub const_token: crate::token::Const,
        pub ident: Ident,
        pub colon_token: crate::token::Colon,
        pub ty: Type,
        pub eq_token: Option<crate::token::Eq>,
        pub default: Option<Expr>,
    }
    impl Default for Generics {
        fn default() -> Self {
            Generics {
                lt_token: None,
                params: Punctuated::new(),
                gt_token: None,
                where_clause: None,
            }
        }
    }
    impl Generics {
        pub fn type_params(&self) -> TypeParams {
            TypeParams(self.params.iter())
        }
        pub fn type_params_mut(&mut self) -> TypeParamsMut {
            TypeParamsMut(self.params.iter_mut())
        }
        pub fn lifetimes(&self) -> Lifetimes {
            Lifetimes(self.params.iter())
        }
        pub fn lifetimes_mut(&mut self) -> LifetimesMut {
            LifetimesMut(self.params.iter_mut())
        }
        pub fn const_params(&self) -> ConstParams {
            ConstParams(self.params.iter())
        }
        pub fn const_params_mut(&mut self) -> ConstParamsMut {
            ConstParamsMut(self.params.iter_mut())
        }
        pub fn make_where_clause(&mut self) -> &mut WhereClause {
            self.where_clause
                .get_or_insert_with(|| WhereClause {
                    where_token: <crate::token::Where>::default(),
                    predicates: Punctuated::new(),
                })
        }
    }
    pub struct TypeParams<'a>(Iter<'a, GenericParam>);
    impl<'a> Iterator for TypeParams<'a> {
        type Item = &'a TypeParam;
        fn next(&mut self) -> Option<Self::Item> {
            let next = match self.0.next() {
                Some(item) => item,
                None => return None,
            };
            if let GenericParam::Type(type_param) = next {
                Some(type_param)
            } else {
                self.next()
            }
        }
    }
    pub struct TypeParamsMut<'a>(IterMut<'a, GenericParam>);
    impl<'a> Iterator for TypeParamsMut<'a> {
        type Item = &'a mut TypeParam;
        fn next(&mut self) -> Option<Self::Item> {
            let next = match self.0.next() {
                Some(item) => item,
                None => return None,
            };
            if let GenericParam::Type(type_param) = next {
                Some(type_param)
            } else {
                self.next()
            }
        }
    }
    pub struct Lifetimes<'a>(Iter<'a, GenericParam>);
    impl<'a> Iterator for Lifetimes<'a> {
        type Item = &'a LifetimeDef;
        fn next(&mut self) -> Option<Self::Item> {
            let next = match self.0.next() {
                Some(item) => item,
                None => return None,
            };
            if let GenericParam::Lifetime(lifetime) = next {
                Some(lifetime)
            } else {
                self.next()
            }
        }
    }
    pub struct LifetimesMut<'a>(IterMut<'a, GenericParam>);
    impl<'a> Iterator for LifetimesMut<'a> {
        type Item = &'a mut LifetimeDef;
        fn next(&mut self) -> Option<Self::Item> {
            let next = match self.0.next() {
                Some(item) => item,
                None => return None,
            };
            if let GenericParam::Lifetime(lifetime) = next {
                Some(lifetime)
            } else {
                self.next()
            }
        }
    }
    pub struct ConstParams<'a>(Iter<'a, GenericParam>);
    impl<'a> Iterator for ConstParams<'a> {
        type Item = &'a ConstParam;
        fn next(&mut self) -> Option<Self::Item> {
            let next = match self.0.next() {
                Some(item) => item,
                None => return None,
            };
            if let GenericParam::Const(const_param) = next {
                Some(const_param)
            } else {
                self.next()
            }
        }
    }
    pub struct ConstParamsMut<'a>(IterMut<'a, GenericParam>);
    impl<'a> Iterator for ConstParamsMut<'a> {
        type Item = &'a mut ConstParam;
        fn next(&mut self) -> Option<Self::Item> {
            let next = match self.0.next() {
                Some(item) => item,
                None => return None,
            };
            if let GenericParam::Const(const_param) = next {
                Some(const_param)
            } else {
                self.next()
            }
        }
    }
    #[cfg(feature = "printing")]
    pub struct ImplGenerics<'a>(&'a Generics);
    #[cfg(feature = "printing")]
    pub struct TypeGenerics<'a>(&'a Generics);
    #[cfg(feature = "printing")]
    pub struct Turbofish<'a>(&'a Generics);
    #[cfg(feature = "printing")]
    impl Generics {
        pub fn split_for_impl(
            &self,
        ) -> (ImplGenerics, TypeGenerics, Option<&WhereClause>) {
            (ImplGenerics(self), TypeGenerics(self), self.where_clause.as_ref())
        }
    }
    #[cfg(feature = "clone-impls")]
    impl<'a> Clone for ImplGenerics<'a> {
        fn clone(&self) -> Self {
            ImplGenerics(self.0)
        }
    }
    #[cfg(feature = "extra-traits")]
    impl<'a> Debug for ImplGenerics<'a> {
        fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
            formatter.debug_tuple("ImplGenerics").field(self.0).finish()
        }
    }
    #[cfg(feature = "extra-traits")]
    impl<'a> Eq for ImplGenerics<'a> {}
    #[cfg(feature = "extra-traits")]
    impl<'a> PartialEq for ImplGenerics<'a> {
        fn eq(&self, other: &Self) -> bool {
            self.0 == other.0
        }
    }
    #[cfg(feature = "extra-traits")]
    impl<'a> Hash for ImplGenerics<'a> {
        fn hash<H: Hasher>(&self, state: &mut H) {
            self.0.hash(state);
        }
    }
    #[cfg(feature = "clone-impls")]
    impl<'a> Clone for TypeGenerics<'a> {
        fn clone(&self) -> Self {
            TypeGenerics(self.0)
        }
    }
    #[cfg(feature = "extra-traits")]
    impl<'a> Debug for TypeGenerics<'a> {
        fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
            formatter.debug_tuple("TypeGenerics").field(self.0).finish()
        }
    }
    #[cfg(feature = "extra-traits")]
    impl<'a> Eq for TypeGenerics<'a> {}
    #[cfg(feature = "extra-traits")]
    impl<'a> PartialEq for TypeGenerics<'a> {
        fn eq(&self, other: &Self) -> bool {
            self.0 == other.0
        }
    }
    #[cfg(feature = "extra-traits")]
    impl<'a> Hash for TypeGenerics<'a> {
        fn hash<H: Hasher>(&self, state: &mut H) {
            self.0.hash(state);
        }
    }
    #[cfg(feature = "clone-impls")]
    impl<'a> Clone for Turbofish<'a> {
        fn clone(&self) -> Self {
            Turbofish(self.0)
        }
    }
    #[cfg(feature = "extra-traits")]
    impl<'a> Debug for Turbofish<'a> {
        fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
            formatter.debug_tuple("Turbofish").field(self.0).finish()
        }
    }
    #[cfg(feature = "extra-traits")]
    impl<'a> Eq for Turbofish<'a> {}
    #[cfg(feature = "extra-traits")]
    impl<'a> PartialEq for Turbofish<'a> {
        fn eq(&self, other: &Self) -> bool {
            self.0 == other.0
        }
    }
    #[cfg(feature = "extra-traits")]
    impl<'a> Hash for Turbofish<'a> {
        fn hash<H: Hasher>(&self, state: &mut H) {
            self.0.hash(state);
        }
    }
    #[cfg(feature = "printing")]
    impl<'a> TypeGenerics<'a> {
        pub fn as_turbofish(&self) -> Turbofish {
            Turbofish(self.0)
        }
    }
    pub struct BoundLifetimes {
        pub for_token: crate::token::For,
        pub lt_token: crate::token::Lt,
        pub lifetimes: Punctuated<LifetimeDef, crate::token::Comma>,
        pub gt_token: crate::token::Gt,
    }
    impl Default for BoundLifetimes {
        fn default() -> Self {
            BoundLifetimes {
                for_token: Default::default(),
                lt_token: Default::default(),
                lifetimes: Punctuated::new(),
                gt_token: Default::default(),
            }
        }
    }
    impl LifetimeDef {
        pub fn new(lifetime: Lifetime) -> Self {
            LifetimeDef {
                attrs: Vec::new(),
                lifetime,
                colon_token: None,
                bounds: Punctuated::new(),
            }
        }
    }
    impl From<Ident> for TypeParam {
        fn from(ident: Ident) -> Self {
            TypeParam {
                attrs: ::alloc::vec::Vec::new(),
                ident,
                colon_token: None,
                bounds: Punctuated::new(),
                eq_token: None,
                default: None,
            }
        }
    }
    pub enum TypeParamBound {
        Trait(TraitBound),
        Lifetime(Lifetime),
    }
    impl From<TraitBound> for TypeParamBound {
        fn from(e: TraitBound) -> TypeParamBound {
            TypeParamBound::Trait(e)
        }
    }
    impl From<Lifetime> for TypeParamBound {
        fn from(e: Lifetime) -> TypeParamBound {
            TypeParamBound::Lifetime(e)
        }
    }
    impl ::quote::ToTokens for TypeParamBound {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                TypeParamBound::Trait(_e) => _e.to_tokens(tokens),
                TypeParamBound::Lifetime(_e) => _e.to_tokens(tokens),
            }
        }
    }
    pub struct TraitBound {
        pub paren_token: Option<token::Paren>,
        pub modifier: TraitBoundModifier,
        pub lifetimes: Option<BoundLifetimes>,
        pub path: Path,
    }
    pub enum TraitBoundModifier {
        None,
        Maybe(crate::token::Question),
    }
    pub struct WhereClause {
        pub where_token: crate::token::Where,
        pub predicates: Punctuated<WherePredicate, crate::token::Comma>,
    }
    pub enum WherePredicate {
        Type(PredicateType),
        Lifetime(PredicateLifetime),
        Eq(PredicateEq),
    }
    impl From<PredicateType> for WherePredicate {
        fn from(e: PredicateType) -> WherePredicate {
            WherePredicate::Type(e)
        }
    }
    impl From<PredicateLifetime> for WherePredicate {
        fn from(e: PredicateLifetime) -> WherePredicate {
            WherePredicate::Lifetime(e)
        }
    }
    impl From<PredicateEq> for WherePredicate {
        fn from(e: PredicateEq) -> WherePredicate {
            WherePredicate::Eq(e)
        }
    }
    impl ::quote::ToTokens for WherePredicate {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                WherePredicate::Type(_e) => _e.to_tokens(tokens),
                WherePredicate::Lifetime(_e) => _e.to_tokens(tokens),
                WherePredicate::Eq(_e) => _e.to_tokens(tokens),
            }
        }
    }
    pub struct PredicateType {
        pub lifetimes: Option<BoundLifetimes>,
        pub bounded_ty: Type,
        pub colon_token: crate::token::Colon,
        pub bounds: Punctuated<TypeParamBound, crate::token::Add>,
    }
    pub struct PredicateLifetime {
        pub lifetime: Lifetime,
        pub colon_token: crate::token::Colon,
        pub bounds: Punctuated<Lifetime, crate::token::Add>,
    }
    pub struct PredicateEq {
        pub lhs_ty: Type,
        pub eq_token: crate::token::Eq,
        pub rhs_ty: Type,
    }
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use super::*;
        use crate::ext::IdentExt;
        use crate::parse::{Parse, ParseStream, Result};
        impl Parse for Generics {
            fn parse(input: ParseStream) -> Result<Self> {
                if !input.peek(crate::token::Lt) {
                    return Ok(Generics::default());
                }
                let lt_token: crate::token::Lt = input.parse()?;
                let mut params = Punctuated::new();
                loop {
                    if input.peek(crate::token::Gt) {
                        break;
                    }
                    let attrs = input.call(Attribute::parse_outer)?;
                    let lookahead = input.lookahead1();
                    if lookahead.peek(Lifetime) {
                        params
                            .push_value(
                                GenericParam::Lifetime(LifetimeDef {
                                    attrs,
                                    ..input.parse()?
                                }),
                            );
                    } else if lookahead.peek(Ident) {
                        params
                            .push_value(
                                GenericParam::Type(TypeParam {
                                    attrs,
                                    ..input.parse()?
                                }),
                            );
                    } else if lookahead.peek(crate::token::Const) {
                        params
                            .push_value(
                                GenericParam::Const(ConstParam {
                                    attrs,
                                    ..input.parse()?
                                }),
                            );
                    } else if input.peek(crate::token::Underscore) {
                        params
                            .push_value(
                                GenericParam::Type(TypeParam {
                                    attrs,
                                    ident: input.call(Ident::parse_any)?,
                                    colon_token: None,
                                    bounds: Punctuated::new(),
                                    eq_token: None,
                                    default: None,
                                }),
                            );
                    } else {
                        return Err(lookahead.error());
                    }
                    if input.peek(crate::token::Gt) {
                        break;
                    }
                    let punct = input.parse()?;
                    params.push_punct(punct);
                }
                let gt_token: crate::token::Gt = input.parse()?;
                Ok(Generics {
                    lt_token: Some(lt_token),
                    params,
                    gt_token: Some(gt_token),
                    where_clause: None,
                })
            }
        }
        impl Parse for GenericParam {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let lookahead = input.lookahead1();
                if lookahead.peek(Ident) {
                    Ok(
                        GenericParam::Type(TypeParam {
                            attrs,
                            ..input.parse()?
                        }),
                    )
                } else if lookahead.peek(Lifetime) {
                    Ok(
                        GenericParam::Lifetime(LifetimeDef {
                            attrs,
                            ..input.parse()?
                        }),
                    )
                } else if lookahead.peek(crate::token::Const) {
                    Ok(
                        GenericParam::Const(ConstParam {
                            attrs,
                            ..input.parse()?
                        }),
                    )
                } else {
                    Err(lookahead.error())
                }
            }
        }
        impl Parse for LifetimeDef {
            fn parse(input: ParseStream) -> Result<Self> {
                let has_colon;
                Ok(LifetimeDef {
                    attrs: input.call(Attribute::parse_outer)?,
                    lifetime: input.parse()?,
                    colon_token: {
                        if input.peek(crate::token::Colon) {
                            has_colon = true;
                            Some(input.parse()?)
                        } else {
                            has_colon = false;
                            None
                        }
                    },
                    bounds: {
                        let mut bounds = Punctuated::new();
                        if has_colon {
                            loop {
                                if input.peek(crate::token::Comma)
                                    || input.peek(crate::token::Gt)
                                {
                                    break;
                                }
                                let value = input.parse()?;
                                bounds.push_value(value);
                                if !input.peek(crate::token::Add) {
                                    break;
                                }
                                let punct = input.parse()?;
                                bounds.push_punct(punct);
                            }
                        }
                        bounds
                    },
                })
            }
        }
        impl Parse for BoundLifetimes {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(BoundLifetimes {
                    for_token: input.parse()?,
                    lt_token: input.parse()?,
                    lifetimes: {
                        let mut lifetimes = Punctuated::new();
                        while !input.peek(crate::token::Gt) {
                            lifetimes.push_value(input.parse()?);
                            if input.peek(crate::token::Gt) {
                                break;
                            }
                            lifetimes.push_punct(input.parse()?);
                        }
                        lifetimes
                    },
                    gt_token: input.parse()?,
                })
            }
        }
        impl Parse for Option<BoundLifetimes> {
            fn parse(input: ParseStream) -> Result<Self> {
                if input.peek(crate::token::For) {
                    input.parse().map(Some)
                } else {
                    Ok(None)
                }
            }
        }
        impl Parse for TypeParam {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let ident: Ident = input.parse()?;
                let colon_token: Option<crate::token::Colon> = input.parse()?;
                let begin_bound = input.fork();
                let mut is_maybe_const = false;
                let mut bounds = Punctuated::new();
                if colon_token.is_some() {
                    loop {
                        if input.peek(crate::token::Comma)
                            || input.peek(crate::token::Gt)
                            || input.peek(crate::token::Eq)
                        {
                            break;
                        }
                        if input.peek(crate::token::Tilde)
                            && input.peek2(crate::token::Const)
                        {
                            input.parse::<crate::token::Tilde>()?;
                            input.parse::<crate::token::Const>()?;
                            is_maybe_const = true;
                        }
                        let value: TypeParamBound = input.parse()?;
                        bounds.push_value(value);
                        if !input.peek(crate::token::Add) {
                            break;
                        }
                        let punct: crate::token::Add = input.parse()?;
                        bounds.push_punct(punct);
                    }
                }
                let mut eq_token: Option<crate::token::Eq> = input.parse()?;
                let mut default = if eq_token.is_some() {
                    Some(input.parse::<Type>()?)
                } else {
                    None
                };
                if is_maybe_const {
                    bounds.clear();
                    eq_token = None;
                    default = Some(
                        Type::Verbatim(verbatim::between(begin_bound, input)),
                    );
                }
                Ok(TypeParam {
                    attrs,
                    ident,
                    colon_token,
                    bounds,
                    eq_token,
                    default,
                })
            }
        }
        impl Parse for TypeParamBound {
            fn parse(input: ParseStream) -> Result<Self> {
                if input.peek(Lifetime) {
                    return input.parse().map(TypeParamBound::Lifetime);
                }
                if input.peek(token::Paren) {
                    let content;
                    let paren_token = match crate::group::parse_parens(&input) {
                        crate::__private::Ok(parens) => {
                            content = parens.content;
                            parens.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    };
                    let mut bound: TraitBound = content.parse()?;
                    bound.paren_token = Some(paren_token);
                    return Ok(TypeParamBound::Trait(bound));
                }
                input.parse().map(TypeParamBound::Trait)
            }
        }
        impl Parse for TraitBound {
            fn parse(input: ParseStream) -> Result<Self> {
                #[cfg(feature = "full")]
                let tilde_const = if input.peek(crate::token::Tilde)
                    && input.peek2(crate::token::Const)
                {
                    let tilde_token = input.parse::<crate::token::Tilde>()?;
                    let const_token = input.parse::<crate::token::Const>()?;
                    Some((tilde_token, const_token))
                } else {
                    None
                };
                let modifier: TraitBoundModifier = input.parse()?;
                let lifetimes: Option<BoundLifetimes> = input.parse()?;
                let mut path: Path = input.parse()?;
                if path.segments.last().unwrap().arguments.is_empty()
                    && (input.peek(token::Paren)
                        || input.peek(crate::token::Colon2) && input.peek3(token::Paren))
                {
                    input.parse::<Option<crate::token::Colon2>>()?;
                    let args: ParenthesizedGenericArguments = input.parse()?;
                    let parenthesized = PathArguments::Parenthesized(args);
                    path.segments.last_mut().unwrap().arguments = parenthesized;
                }
                #[cfg(feature = "full")]
                {
                    if let Some((tilde_token, const_token)) = tilde_const {
                        path.segments
                            .insert(
                                0,
                                PathSegment {
                                    ident: Ident::new("const", const_token.span),
                                    arguments: PathArguments::None,
                                },
                            );
                        let (_const, punct) = path
                            .segments
                            .pairs_mut()
                            .next()
                            .unwrap()
                            .into_tuple();
                        *punct.unwrap() = crate::token::Colon2(tilde_token.span);
                    }
                }
                Ok(TraitBound {
                    paren_token: None,
                    modifier,
                    lifetimes,
                    path,
                })
            }
        }
        impl Parse for TraitBoundModifier {
            fn parse(input: ParseStream) -> Result<Self> {
                if input.peek(crate::token::Question) {
                    input.parse().map(TraitBoundModifier::Maybe)
                } else {
                    Ok(TraitBoundModifier::None)
                }
            }
        }
        impl Parse for ConstParam {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut default = None;
                Ok(ConstParam {
                    attrs: input.call(Attribute::parse_outer)?,
                    const_token: input.parse()?,
                    ident: input.parse()?,
                    colon_token: input.parse()?,
                    ty: input.parse()?,
                    eq_token: {
                        if input.peek(crate::token::Eq) {
                            let eq_token = input.parse()?;
                            default = Some(path::parsing::const_argument(input)?);
                            Some(eq_token)
                        } else {
                            None
                        }
                    },
                    default,
                })
            }
        }
        impl Parse for WhereClause {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(WhereClause {
                    where_token: input.parse()?,
                    predicates: {
                        let mut predicates = Punctuated::new();
                        loop {
                            if input.is_empty() || input.peek(token::Brace)
                                || input.peek(crate::token::Comma)
                                || input.peek(crate::token::Semi)
                                || input.peek(crate::token::Colon)
                                    && !input.peek(crate::token::Colon2)
                                || input.peek(crate::token::Eq)
                            {
                                break;
                            }
                            let value = input.parse()?;
                            predicates.push_value(value);
                            if !input.peek(crate::token::Comma) {
                                break;
                            }
                            let punct = input.parse()?;
                            predicates.push_punct(punct);
                        }
                        predicates
                    },
                })
            }
        }
        impl Parse for Option<WhereClause> {
            fn parse(input: ParseStream) -> Result<Self> {
                if input.peek(crate::token::Where) {
                    input.parse().map(Some)
                } else {
                    Ok(None)
                }
            }
        }
        impl Parse for WherePredicate {
            fn parse(input: ParseStream) -> Result<Self> {
                if input.peek(Lifetime) && input.peek2(crate::token::Colon) {
                    Ok(
                        WherePredicate::Lifetime(PredicateLifetime {
                            lifetime: input.parse()?,
                            colon_token: input.parse()?,
                            bounds: {
                                let mut bounds = Punctuated::new();
                                loop {
                                    if input.is_empty() || input.peek(token::Brace)
                                        || input.peek(crate::token::Comma)
                                        || input.peek(crate::token::Semi)
                                        || input.peek(crate::token::Colon)
                                        || input.peek(crate::token::Eq)
                                    {
                                        break;
                                    }
                                    let value = input.parse()?;
                                    bounds.push_value(value);
                                    if !input.peek(crate::token::Add) {
                                        break;
                                    }
                                    let punct = input.parse()?;
                                    bounds.push_punct(punct);
                                }
                                bounds
                            },
                        }),
                    )
                } else {
                    Ok(
                        WherePredicate::Type(PredicateType {
                            lifetimes: input.parse()?,
                            bounded_ty: input.parse()?,
                            colon_token: input.parse()?,
                            bounds: {
                                let mut bounds = Punctuated::new();
                                loop {
                                    if input.is_empty() || input.peek(token::Brace)
                                        || input.peek(crate::token::Comma)
                                        || input.peek(crate::token::Semi)
                                        || input.peek(crate::token::Colon)
                                            && !input.peek(crate::token::Colon2)
                                        || input.peek(crate::token::Eq)
                                    {
                                        break;
                                    }
                                    let value = input.parse()?;
                                    bounds.push_value(value);
                                    if !input.peek(crate::token::Add) {
                                        break;
                                    }
                                    let punct = input.parse()?;
                                    bounds.push_punct(punct);
                                }
                                bounds
                            },
                        }),
                    )
                }
            }
        }
    }
    #[cfg(feature = "printing")]
    mod printing {
        use super::*;
        use crate::attr::FilterAttrs;
        use crate::print::TokensOrDefault;
        #[cfg(feature = "full")]
        use crate::punctuated::Pair;
        use proc_macro2::TokenStream;
        #[cfg(feature = "full")]
        use proc_macro2::TokenTree;
        use quote::{ToTokens, TokenStreamExt};
        impl ToTokens for Generics {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                if self.params.is_empty() {
                    return;
                }
                TokensOrDefault(&self.lt_token).to_tokens(tokens);
                let mut trailing_or_empty = true;
                for param in self.params.pairs() {
                    if let GenericParam::Lifetime(_) = **param.value() {
                        param.to_tokens(tokens);
                        trailing_or_empty = param.punct().is_some();
                    }
                }
                for param in self.params.pairs() {
                    match **param.value() {
                        GenericParam::Type(_) | GenericParam::Const(_) => {
                            if !trailing_or_empty {
                                <crate::token::Comma>::default().to_tokens(tokens);
                                trailing_or_empty = true;
                            }
                            param.to_tokens(tokens);
                        }
                        GenericParam::Lifetime(_) => {}
                    }
                }
                TokensOrDefault(&self.gt_token).to_tokens(tokens);
            }
        }
        impl<'a> ToTokens for ImplGenerics<'a> {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                if self.0.params.is_empty() {
                    return;
                }
                TokensOrDefault(&self.0.lt_token).to_tokens(tokens);
                let mut trailing_or_empty = true;
                for param in self.0.params.pairs() {
                    if let GenericParam::Lifetime(_) = **param.value() {
                        param.to_tokens(tokens);
                        trailing_or_empty = param.punct().is_some();
                    }
                }
                for param in self.0.params.pairs() {
                    if let GenericParam::Lifetime(_) = **param.value() {
                        continue;
                    }
                    if !trailing_or_empty {
                        <crate::token::Comma>::default().to_tokens(tokens);
                        trailing_or_empty = true;
                    }
                    match *param.value() {
                        GenericParam::Lifetime(_) => {
                            ::core::panicking::panic(
                                "internal error: entered unreachable code",
                            )
                        }
                        GenericParam::Type(param) => {
                            tokens.append_all(param.attrs.outer());
                            param.ident.to_tokens(tokens);
                            if !param.bounds.is_empty() {
                                TokensOrDefault(&param.colon_token).to_tokens(tokens);
                                param.bounds.to_tokens(tokens);
                            }
                        }
                        GenericParam::Const(param) => {
                            tokens.append_all(param.attrs.outer());
                            param.const_token.to_tokens(tokens);
                            param.ident.to_tokens(tokens);
                            param.colon_token.to_tokens(tokens);
                            param.ty.to_tokens(tokens);
                        }
                    }
                    param.punct().to_tokens(tokens);
                }
                TokensOrDefault(&self.0.gt_token).to_tokens(tokens);
            }
        }
        impl<'a> ToTokens for TypeGenerics<'a> {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                if self.0.params.is_empty() {
                    return;
                }
                TokensOrDefault(&self.0.lt_token).to_tokens(tokens);
                let mut trailing_or_empty = true;
                for param in self.0.params.pairs() {
                    if let GenericParam::Lifetime(def) = *param.value() {
                        def.lifetime.to_tokens(tokens);
                        param.punct().to_tokens(tokens);
                        trailing_or_empty = param.punct().is_some();
                    }
                }
                for param in self.0.params.pairs() {
                    if let GenericParam::Lifetime(_) = **param.value() {
                        continue;
                    }
                    if !trailing_or_empty {
                        <crate::token::Comma>::default().to_tokens(tokens);
                        trailing_or_empty = true;
                    }
                    match *param.value() {
                        GenericParam::Lifetime(_) => {
                            ::core::panicking::panic(
                                "internal error: entered unreachable code",
                            )
                        }
                        GenericParam::Type(param) => {
                            param.ident.to_tokens(tokens);
                        }
                        GenericParam::Const(param) => {
                            param.ident.to_tokens(tokens);
                        }
                    }
                    param.punct().to_tokens(tokens);
                }
                TokensOrDefault(&self.0.gt_token).to_tokens(tokens);
            }
        }
        impl<'a> ToTokens for Turbofish<'a> {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                if !self.0.params.is_empty() {
                    <crate::token::Colon2>::default().to_tokens(tokens);
                    TypeGenerics(self.0).to_tokens(tokens);
                }
            }
        }
        impl ToTokens for BoundLifetimes {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.for_token.to_tokens(tokens);
                self.lt_token.to_tokens(tokens);
                self.lifetimes.to_tokens(tokens);
                self.gt_token.to_tokens(tokens);
            }
        }
        impl ToTokens for LifetimeDef {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.lifetime.to_tokens(tokens);
                if !self.bounds.is_empty() {
                    TokensOrDefault(&self.colon_token).to_tokens(tokens);
                    self.bounds.to_tokens(tokens);
                }
            }
        }
        impl ToTokens for TypeParam {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.ident.to_tokens(tokens);
                if !self.bounds.is_empty() {
                    TokensOrDefault(&self.colon_token).to_tokens(tokens);
                    self.bounds.to_tokens(tokens);
                }
                if let Some(default) = &self.default {
                    #[cfg(feature = "full")]
                    {
                        if self.eq_token.is_none() {
                            if let Type::Verbatim(default) = default {
                                let mut iter = default.clone().into_iter().peekable();
                                while let Some(token) = iter.next() {
                                    if let TokenTree::Punct(q) = token {
                                        if q.as_char() == '~' {
                                            if let Some(TokenTree::Ident(c)) = iter.peek() {
                                                if c == "const" {
                                                    if self.bounds.is_empty() {
                                                        TokensOrDefault(&self.colon_token).to_tokens(tokens);
                                                    }
                                                    return default.to_tokens(tokens);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    TokensOrDefault(&self.eq_token).to_tokens(tokens);
                    default.to_tokens(tokens);
                }
            }
        }
        impl ToTokens for TraitBound {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                let to_tokens = |tokens: &mut TokenStream| {
                    #[cfg(feature = "full")]
                    let skip = match self.path.segments.pairs().next() {
                        Some(Pair::Punctuated(t, p)) if t.ident == "const" => {
                            crate::token::Tilde(p.spans[0]).to_tokens(tokens);
                            t.to_tokens(tokens);
                            1
                        }
                        _ => 0,
                    };
                    self.modifier.to_tokens(tokens);
                    self.lifetimes.to_tokens(tokens);
                    #[cfg(feature = "full")]
                    {
                        self.path.leading_colon.to_tokens(tokens);
                        tokens.append_all(self.path.segments.pairs().skip(skip));
                    }
                };
                match &self.paren_token {
                    Some(paren) => paren.surround(tokens, to_tokens),
                    None => to_tokens(tokens),
                }
            }
        }
        impl ToTokens for TraitBoundModifier {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                match self {
                    TraitBoundModifier::None => {}
                    TraitBoundModifier::Maybe(t) => t.to_tokens(tokens),
                }
            }
        }
        impl ToTokens for ConstParam {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.const_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.colon_token.to_tokens(tokens);
                self.ty.to_tokens(tokens);
                if let Some(default) = &self.default {
                    TokensOrDefault(&self.eq_token).to_tokens(tokens);
                    default.to_tokens(tokens);
                }
            }
        }
        impl ToTokens for WhereClause {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                if !self.predicates.is_empty() {
                    self.where_token.to_tokens(tokens);
                    self.predicates.to_tokens(tokens);
                }
            }
        }
        impl ToTokens for PredicateType {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.lifetimes.to_tokens(tokens);
                self.bounded_ty.to_tokens(tokens);
                self.colon_token.to_tokens(tokens);
                self.bounds.to_tokens(tokens);
            }
        }
        impl ToTokens for PredicateLifetime {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.lifetime.to_tokens(tokens);
                self.colon_token.to_tokens(tokens);
                self.bounds.to_tokens(tokens);
            }
        }
        impl ToTokens for PredicateEq {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.lhs_ty.to_tokens(tokens);
                self.eq_token.to_tokens(tokens);
                self.rhs_ty.to_tokens(tokens);
            }
        }
    }
}
#[cfg(any(feature = "full", feature = "derive"))]
pub use crate::generics::{
    BoundLifetimes, ConstParam, GenericParam, Generics, LifetimeDef, PredicateEq,
    PredicateLifetime, PredicateType, TraitBound, TraitBoundModifier, TypeParam,
    TypeParamBound, WhereClause, WherePredicate,
};
#[cfg(all(any(feature = "full", feature = "derive"), feature = "printing"))]
pub use crate::generics::{ImplGenerics, Turbofish, TypeGenerics};
#[cfg(feature = "full")]
mod item {
    use super::*;
    use crate::derive::{Data, DataEnum, DataStruct, DataUnion, DeriveInput};
    use crate::punctuated::Punctuated;
    use proc_macro2::TokenStream;
    #[cfg(feature = "parsing")]
    use std::mem;
    #[non_exhaustive]
    pub enum Item {
        Const(ItemConst),
        Enum(ItemEnum),
        ExternCrate(ItemExternCrate),
        Fn(ItemFn),
        ForeignMod(ItemForeignMod),
        Impl(ItemImpl),
        Macro(ItemMacro),
        Macro2(ItemMacro2),
        Mod(ItemMod),
        Static(ItemStatic),
        Struct(ItemStruct),
        Trait(ItemTrait),
        TraitAlias(ItemTraitAlias),
        Type(ItemType),
        Union(ItemUnion),
        Use(ItemUse),
        Verbatim(TokenStream),
    }
    impl From<ItemConst> for Item {
        fn from(e: ItemConst) -> Item {
            Item::Const(e)
        }
    }
    impl From<ItemEnum> for Item {
        fn from(e: ItemEnum) -> Item {
            Item::Enum(e)
        }
    }
    impl From<ItemExternCrate> for Item {
        fn from(e: ItemExternCrate) -> Item {
            Item::ExternCrate(e)
        }
    }
    impl From<ItemFn> for Item {
        fn from(e: ItemFn) -> Item {
            Item::Fn(e)
        }
    }
    impl From<ItemForeignMod> for Item {
        fn from(e: ItemForeignMod) -> Item {
            Item::ForeignMod(e)
        }
    }
    impl From<ItemImpl> for Item {
        fn from(e: ItemImpl) -> Item {
            Item::Impl(e)
        }
    }
    impl From<ItemMacro> for Item {
        fn from(e: ItemMacro) -> Item {
            Item::Macro(e)
        }
    }
    impl From<ItemMacro2> for Item {
        fn from(e: ItemMacro2) -> Item {
            Item::Macro2(e)
        }
    }
    impl From<ItemMod> for Item {
        fn from(e: ItemMod) -> Item {
            Item::Mod(e)
        }
    }
    impl From<ItemStatic> for Item {
        fn from(e: ItemStatic) -> Item {
            Item::Static(e)
        }
    }
    impl From<ItemStruct> for Item {
        fn from(e: ItemStruct) -> Item {
            Item::Struct(e)
        }
    }
    impl From<ItemTrait> for Item {
        fn from(e: ItemTrait) -> Item {
            Item::Trait(e)
        }
    }
    impl From<ItemTraitAlias> for Item {
        fn from(e: ItemTraitAlias) -> Item {
            Item::TraitAlias(e)
        }
    }
    impl From<ItemType> for Item {
        fn from(e: ItemType) -> Item {
            Item::Type(e)
        }
    }
    impl From<ItemUnion> for Item {
        fn from(e: ItemUnion) -> Item {
            Item::Union(e)
        }
    }
    impl From<ItemUse> for Item {
        fn from(e: ItemUse) -> Item {
            Item::Use(e)
        }
    }
    impl ::quote::ToTokens for Item {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                Item::Const(_e) => _e.to_tokens(tokens),
                Item::Enum(_e) => _e.to_tokens(tokens),
                Item::ExternCrate(_e) => _e.to_tokens(tokens),
                Item::Fn(_e) => _e.to_tokens(tokens),
                Item::ForeignMod(_e) => _e.to_tokens(tokens),
                Item::Impl(_e) => _e.to_tokens(tokens),
                Item::Macro(_e) => _e.to_tokens(tokens),
                Item::Macro2(_e) => _e.to_tokens(tokens),
                Item::Mod(_e) => _e.to_tokens(tokens),
                Item::Static(_e) => _e.to_tokens(tokens),
                Item::Struct(_e) => _e.to_tokens(tokens),
                Item::Trait(_e) => _e.to_tokens(tokens),
                Item::TraitAlias(_e) => _e.to_tokens(tokens),
                Item::Type(_e) => _e.to_tokens(tokens),
                Item::Union(_e) => _e.to_tokens(tokens),
                Item::Use(_e) => _e.to_tokens(tokens),
                Item::Verbatim(_e) => _e.to_tokens(tokens),
            }
        }
    }
    pub struct ItemConst {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub const_token: crate::token::Const,
        pub ident: Ident,
        pub colon_token: crate::token::Colon,
        pub ty: Box<Type>,
        pub eq_token: crate::token::Eq,
        pub expr: Box<Expr>,
        pub semi_token: crate::token::Semi,
    }
    pub struct ItemEnum {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub enum_token: crate::token::Enum,
        pub ident: Ident,
        pub generics: Generics,
        pub brace_token: token::Brace,
        pub variants: Punctuated<Variant, crate::token::Comma>,
    }
    pub struct ItemExternCrate {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub extern_token: crate::token::Extern,
        pub crate_token: crate::token::Crate,
        pub ident: Ident,
        pub rename: Option<(crate::token::As, Ident)>,
        pub semi_token: crate::token::Semi,
    }
    pub struct ItemFn {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub sig: Signature,
        pub block: Box<Block>,
    }
    pub struct ItemForeignMod {
        pub attrs: Vec<Attribute>,
        pub abi: Abi,
        pub brace_token: token::Brace,
        pub items: Vec<ForeignItem>,
    }
    pub struct ItemImpl {
        pub attrs: Vec<Attribute>,
        pub defaultness: Option<crate::token::Default>,
        pub unsafety: Option<crate::token::Unsafe>,
        pub impl_token: crate::token::Impl,
        pub generics: Generics,
        pub trait_: Option<(Option<crate::token::Bang>, Path, crate::token::For)>,
        pub self_ty: Box<Type>,
        pub brace_token: token::Brace,
        pub items: Vec<ImplItem>,
    }
    pub struct ItemMacro {
        pub attrs: Vec<Attribute>,
        pub ident: Option<Ident>,
        pub mac: Macro,
        pub semi_token: Option<crate::token::Semi>,
    }
    pub struct ItemMacro2 {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub macro_token: crate::token::Macro,
        pub ident: Ident,
        pub rules: TokenStream,
    }
    pub struct ItemMod {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub mod_token: crate::token::Mod,
        pub ident: Ident,
        pub content: Option<(token::Brace, Vec<Item>)>,
        pub semi: Option<crate::token::Semi>,
    }
    pub struct ItemStatic {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub static_token: crate::token::Static,
        pub mutability: Option<crate::token::Mut>,
        pub ident: Ident,
        pub colon_token: crate::token::Colon,
        pub ty: Box<Type>,
        pub eq_token: crate::token::Eq,
        pub expr: Box<Expr>,
        pub semi_token: crate::token::Semi,
    }
    pub struct ItemStruct {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub struct_token: crate::token::Struct,
        pub ident: Ident,
        pub generics: Generics,
        pub fields: Fields,
        pub semi_token: Option<crate::token::Semi>,
    }
    pub struct ItemTrait {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub unsafety: Option<crate::token::Unsafe>,
        pub auto_token: Option<crate::token::Auto>,
        pub trait_token: crate::token::Trait,
        pub ident: Ident,
        pub generics: Generics,
        pub colon_token: Option<crate::token::Colon>,
        pub supertraits: Punctuated<TypeParamBound, crate::token::Add>,
        pub brace_token: token::Brace,
        pub items: Vec<TraitItem>,
    }
    pub struct ItemTraitAlias {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub trait_token: crate::token::Trait,
        pub ident: Ident,
        pub generics: Generics,
        pub eq_token: crate::token::Eq,
        pub bounds: Punctuated<TypeParamBound, crate::token::Add>,
        pub semi_token: crate::token::Semi,
    }
    pub struct ItemType {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub type_token: crate::token::Type,
        pub ident: Ident,
        pub generics: Generics,
        pub eq_token: crate::token::Eq,
        pub ty: Box<Type>,
        pub semi_token: crate::token::Semi,
    }
    pub struct ItemUnion {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub union_token: crate::token::Union,
        pub ident: Ident,
        pub generics: Generics,
        pub fields: FieldsNamed,
    }
    pub struct ItemUse {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub use_token: crate::token::Use,
        pub leading_colon: Option<crate::token::Colon2>,
        pub tree: UseTree,
        pub semi_token: crate::token::Semi,
    }
    impl Item {
        #[cfg(feature = "parsing")]
        pub(crate) fn replace_attrs(&mut self, new: Vec<Attribute>) -> Vec<Attribute> {
            match self {
                Item::ExternCrate(ItemExternCrate { attrs, .. })
                | Item::Use(ItemUse { attrs, .. })
                | Item::Static(ItemStatic { attrs, .. })
                | Item::Const(ItemConst { attrs, .. })
                | Item::Fn(ItemFn { attrs, .. })
                | Item::Mod(ItemMod { attrs, .. })
                | Item::ForeignMod(ItemForeignMod { attrs, .. })
                | Item::Type(ItemType { attrs, .. })
                | Item::Struct(ItemStruct { attrs, .. })
                | Item::Enum(ItemEnum { attrs, .. })
                | Item::Union(ItemUnion { attrs, .. })
                | Item::Trait(ItemTrait { attrs, .. })
                | Item::TraitAlias(ItemTraitAlias { attrs, .. })
                | Item::Impl(ItemImpl { attrs, .. })
                | Item::Macro(ItemMacro { attrs, .. })
                | Item::Macro2(ItemMacro2 { attrs, .. }) => mem::replace(attrs, new),
                Item::Verbatim(_) => Vec::new(),
            }
        }
    }
    impl From<DeriveInput> for Item {
        fn from(input: DeriveInput) -> Item {
            match input.data {
                Data::Struct(data) => {
                    Item::Struct(ItemStruct {
                        attrs: input.attrs,
                        vis: input.vis,
                        struct_token: data.struct_token,
                        ident: input.ident,
                        generics: input.generics,
                        fields: data.fields,
                        semi_token: data.semi_token,
                    })
                }
                Data::Enum(data) => {
                    Item::Enum(ItemEnum {
                        attrs: input.attrs,
                        vis: input.vis,
                        enum_token: data.enum_token,
                        ident: input.ident,
                        generics: input.generics,
                        brace_token: data.brace_token,
                        variants: data.variants,
                    })
                }
                Data::Union(data) => {
                    Item::Union(ItemUnion {
                        attrs: input.attrs,
                        vis: input.vis,
                        union_token: data.union_token,
                        ident: input.ident,
                        generics: input.generics,
                        fields: data.fields,
                    })
                }
            }
        }
    }
    impl From<ItemStruct> for DeriveInput {
        fn from(input: ItemStruct) -> DeriveInput {
            DeriveInput {
                attrs: input.attrs,
                vis: input.vis,
                ident: input.ident,
                generics: input.generics,
                data: Data::Struct(DataStruct {
                    struct_token: input.struct_token,
                    fields: input.fields,
                    semi_token: input.semi_token,
                }),
            }
        }
    }
    impl From<ItemEnum> for DeriveInput {
        fn from(input: ItemEnum) -> DeriveInput {
            DeriveInput {
                attrs: input.attrs,
                vis: input.vis,
                ident: input.ident,
                generics: input.generics,
                data: Data::Enum(DataEnum {
                    enum_token: input.enum_token,
                    brace_token: input.brace_token,
                    variants: input.variants,
                }),
            }
        }
    }
    impl From<ItemUnion> for DeriveInput {
        fn from(input: ItemUnion) -> DeriveInput {
            DeriveInput {
                attrs: input.attrs,
                vis: input.vis,
                ident: input.ident,
                generics: input.generics,
                data: Data::Union(DataUnion {
                    union_token: input.union_token,
                    fields: input.fields,
                }),
            }
        }
    }
    pub enum UseTree {
        Path(UsePath),
        Name(UseName),
        Rename(UseRename),
        Glob(UseGlob),
        Group(UseGroup),
    }
    impl From<UsePath> for UseTree {
        fn from(e: UsePath) -> UseTree {
            UseTree::Path(e)
        }
    }
    impl From<UseName> for UseTree {
        fn from(e: UseName) -> UseTree {
            UseTree::Name(e)
        }
    }
    impl From<UseRename> for UseTree {
        fn from(e: UseRename) -> UseTree {
            UseTree::Rename(e)
        }
    }
    impl From<UseGlob> for UseTree {
        fn from(e: UseGlob) -> UseTree {
            UseTree::Glob(e)
        }
    }
    impl From<UseGroup> for UseTree {
        fn from(e: UseGroup) -> UseTree {
            UseTree::Group(e)
        }
    }
    impl ::quote::ToTokens for UseTree {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                UseTree::Path(_e) => _e.to_tokens(tokens),
                UseTree::Name(_e) => _e.to_tokens(tokens),
                UseTree::Rename(_e) => _e.to_tokens(tokens),
                UseTree::Glob(_e) => _e.to_tokens(tokens),
                UseTree::Group(_e) => _e.to_tokens(tokens),
            }
        }
    }
    pub struct UsePath {
        pub ident: Ident,
        pub colon2_token: crate::token::Colon2,
        pub tree: Box<UseTree>,
    }
    pub struct UseName {
        pub ident: Ident,
    }
    pub struct UseRename {
        pub ident: Ident,
        pub as_token: crate::token::As,
        pub rename: Ident,
    }
    pub struct UseGlob {
        pub star_token: crate::token::Star,
    }
    pub struct UseGroup {
        pub brace_token: token::Brace,
        pub items: Punctuated<UseTree, crate::token::Comma>,
    }
    #[non_exhaustive]
    pub enum ForeignItem {
        Fn(ForeignItemFn),
        Static(ForeignItemStatic),
        Type(ForeignItemType),
        Macro(ForeignItemMacro),
        Verbatim(TokenStream),
    }
    impl From<ForeignItemFn> for ForeignItem {
        fn from(e: ForeignItemFn) -> ForeignItem {
            ForeignItem::Fn(e)
        }
    }
    impl From<ForeignItemStatic> for ForeignItem {
        fn from(e: ForeignItemStatic) -> ForeignItem {
            ForeignItem::Static(e)
        }
    }
    impl From<ForeignItemType> for ForeignItem {
        fn from(e: ForeignItemType) -> ForeignItem {
            ForeignItem::Type(e)
        }
    }
    impl From<ForeignItemMacro> for ForeignItem {
        fn from(e: ForeignItemMacro) -> ForeignItem {
            ForeignItem::Macro(e)
        }
    }
    impl ::quote::ToTokens for ForeignItem {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                ForeignItem::Fn(_e) => _e.to_tokens(tokens),
                ForeignItem::Static(_e) => _e.to_tokens(tokens),
                ForeignItem::Type(_e) => _e.to_tokens(tokens),
                ForeignItem::Macro(_e) => _e.to_tokens(tokens),
                ForeignItem::Verbatim(_e) => _e.to_tokens(tokens),
            }
        }
    }
    pub struct ForeignItemFn {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub sig: Signature,
        pub semi_token: crate::token::Semi,
    }
    pub struct ForeignItemStatic {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub static_token: crate::token::Static,
        pub mutability: Option<crate::token::Mut>,
        pub ident: Ident,
        pub colon_token: crate::token::Colon,
        pub ty: Box<Type>,
        pub semi_token: crate::token::Semi,
    }
    pub struct ForeignItemType {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub type_token: crate::token::Type,
        pub ident: Ident,
        pub semi_token: crate::token::Semi,
    }
    pub struct ForeignItemMacro {
        pub attrs: Vec<Attribute>,
        pub mac: Macro,
        pub semi_token: Option<crate::token::Semi>,
    }
    #[non_exhaustive]
    pub enum TraitItem {
        Const(TraitItemConst),
        Method(TraitItemMethod),
        Type(TraitItemType),
        Macro(TraitItemMacro),
        Verbatim(TokenStream),
    }
    impl From<TraitItemConst> for TraitItem {
        fn from(e: TraitItemConst) -> TraitItem {
            TraitItem::Const(e)
        }
    }
    impl From<TraitItemMethod> for TraitItem {
        fn from(e: TraitItemMethod) -> TraitItem {
            TraitItem::Method(e)
        }
    }
    impl From<TraitItemType> for TraitItem {
        fn from(e: TraitItemType) -> TraitItem {
            TraitItem::Type(e)
        }
    }
    impl From<TraitItemMacro> for TraitItem {
        fn from(e: TraitItemMacro) -> TraitItem {
            TraitItem::Macro(e)
        }
    }
    impl ::quote::ToTokens for TraitItem {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                TraitItem::Const(_e) => _e.to_tokens(tokens),
                TraitItem::Method(_e) => _e.to_tokens(tokens),
                TraitItem::Type(_e) => _e.to_tokens(tokens),
                TraitItem::Macro(_e) => _e.to_tokens(tokens),
                TraitItem::Verbatim(_e) => _e.to_tokens(tokens),
            }
        }
    }
    pub struct TraitItemConst {
        pub attrs: Vec<Attribute>,
        pub const_token: crate::token::Const,
        pub ident: Ident,
        pub colon_token: crate::token::Colon,
        pub ty: Type,
        pub default: Option<(crate::token::Eq, Expr)>,
        pub semi_token: crate::token::Semi,
    }
    pub struct TraitItemMethod {
        pub attrs: Vec<Attribute>,
        pub sig: Signature,
        pub default: Option<Block>,
        pub semi_token: Option<crate::token::Semi>,
    }
    pub struct TraitItemType {
        pub attrs: Vec<Attribute>,
        pub type_token: crate::token::Type,
        pub ident: Ident,
        pub generics: Generics,
        pub colon_token: Option<crate::token::Colon>,
        pub bounds: Punctuated<TypeParamBound, crate::token::Add>,
        pub default: Option<(crate::token::Eq, Type)>,
        pub semi_token: crate::token::Semi,
    }
    pub struct TraitItemMacro {
        pub attrs: Vec<Attribute>,
        pub mac: Macro,
        pub semi_token: Option<crate::token::Semi>,
    }
    #[non_exhaustive]
    pub enum ImplItem {
        Const(ImplItemConst),
        Method(ImplItemMethod),
        Type(ImplItemType),
        Macro(ImplItemMacro),
        Verbatim(TokenStream),
    }
    impl From<ImplItemConst> for ImplItem {
        fn from(e: ImplItemConst) -> ImplItem {
            ImplItem::Const(e)
        }
    }
    impl From<ImplItemMethod> for ImplItem {
        fn from(e: ImplItemMethod) -> ImplItem {
            ImplItem::Method(e)
        }
    }
    impl From<ImplItemType> for ImplItem {
        fn from(e: ImplItemType) -> ImplItem {
            ImplItem::Type(e)
        }
    }
    impl From<ImplItemMacro> for ImplItem {
        fn from(e: ImplItemMacro) -> ImplItem {
            ImplItem::Macro(e)
        }
    }
    impl ::quote::ToTokens for ImplItem {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                ImplItem::Const(_e) => _e.to_tokens(tokens),
                ImplItem::Method(_e) => _e.to_tokens(tokens),
                ImplItem::Type(_e) => _e.to_tokens(tokens),
                ImplItem::Macro(_e) => _e.to_tokens(tokens),
                ImplItem::Verbatim(_e) => _e.to_tokens(tokens),
            }
        }
    }
    pub struct ImplItemConst {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub defaultness: Option<crate::token::Default>,
        pub const_token: crate::token::Const,
        pub ident: Ident,
        pub colon_token: crate::token::Colon,
        pub ty: Type,
        pub eq_token: crate::token::Eq,
        pub expr: Expr,
        pub semi_token: crate::token::Semi,
    }
    pub struct ImplItemMethod {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub defaultness: Option<crate::token::Default>,
        pub sig: Signature,
        pub block: Block,
    }
    pub struct ImplItemType {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub defaultness: Option<crate::token::Default>,
        pub type_token: crate::token::Type,
        pub ident: Ident,
        pub generics: Generics,
        pub eq_token: crate::token::Eq,
        pub ty: Type,
        pub semi_token: crate::token::Semi,
    }
    pub struct ImplItemMacro {
        pub attrs: Vec<Attribute>,
        pub mac: Macro,
        pub semi_token: Option<crate::token::Semi>,
    }
    pub struct Signature {
        pub constness: Option<crate::token::Const>,
        pub asyncness: Option<crate::token::Async>,
        pub unsafety: Option<crate::token::Unsafe>,
        pub abi: Option<Abi>,
        pub fn_token: crate::token::Fn,
        pub ident: Ident,
        pub generics: Generics,
        pub paren_token: token::Paren,
        pub inputs: Punctuated<FnArg, crate::token::Comma>,
        pub variadic: Option<Variadic>,
        pub output: ReturnType,
    }
    impl Signature {
        pub fn receiver(&self) -> Option<&FnArg> {
            let arg = self.inputs.first()?;
            match arg {
                FnArg::Receiver(_) => Some(arg),
                FnArg::Typed(PatType { pat, .. }) => {
                    if let Pat::Ident(PatIdent { ident, .. }) = &**pat {
                        if ident == "self" {
                            return Some(arg);
                        }
                    }
                    None
                }
            }
        }
    }
    pub enum FnArg {
        Receiver(Receiver),
        Typed(PatType),
    }
    impl From<Receiver> for FnArg {
        fn from(e: Receiver) -> FnArg {
            FnArg::Receiver(e)
        }
    }
    impl From<PatType> for FnArg {
        fn from(e: PatType) -> FnArg {
            FnArg::Typed(e)
        }
    }
    impl ::quote::ToTokens for FnArg {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                FnArg::Receiver(_e) => _e.to_tokens(tokens),
                FnArg::Typed(_e) => _e.to_tokens(tokens),
            }
        }
    }
    pub struct Receiver {
        pub attrs: Vec<Attribute>,
        pub reference: Option<(crate::token::And, Option<Lifetime>)>,
        pub mutability: Option<crate::token::Mut>,
        pub self_token: crate::token::SelfValue,
    }
    impl Receiver {
        pub fn lifetime(&self) -> Option<&Lifetime> {
            self.reference.as_ref()?.1.as_ref()
        }
    }
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use super::*;
        use crate::ext::IdentExt;
        use crate::parse::discouraged::Speculative;
        use crate::parse::{Parse, ParseBuffer, ParseStream, Result};
        use crate::token::Brace;
        use proc_macro2::{Delimiter, Group, Punct, Spacing, TokenTree};
        use std::iter::{self, FromIterator};
        #[allow(non_camel_case_types)]
        pub struct macro_rules {
            pub span: crate::__private::Span,
        }
        #[doc(hidden)]
        #[allow(dead_code, non_snake_case)]
        pub fn macro_rules<
            __S: crate::__private::IntoSpans<[crate::__private::Span; 1]>,
        >(span: __S) -> macro_rules {
            macro_rules {
                span: crate::__private::IntoSpans::into_spans(span)[0],
            }
        }
        impl crate::__private::Default for macro_rules {
            fn default() -> Self {
                macro_rules {
                    span: crate::__private::Span::call_site(),
                }
            }
        }
        impl crate::token::CustomToken for macro_rules {
            fn peek(cursor: crate::buffer::Cursor) -> crate::__private::bool {
                if let crate::__private::Some((ident, _rest)) = cursor.ident() {
                    ident == "macro_rules"
                } else {
                    false
                }
            }
            fn display() -> &'static crate::__private::str {
                "`macro_rules`"
            }
        }
        impl crate::parse::Parse for macro_rules {
            fn parse(
                input: crate::parse::ParseStream,
            ) -> crate::parse::Result<macro_rules> {
                input
                    .step(|cursor| {
                        if let crate::__private::Some((ident, rest)) = cursor.ident() {
                            if ident == "macro_rules" {
                                return crate::__private::Ok((
                                    macro_rules { span: ident.span() },
                                    rest,
                                ));
                            }
                        }
                        crate::__private::Err(cursor.error("expected `macro_rules`"))
                    })
            }
        }
        impl crate::__private::ToTokens for macro_rules {
            fn to_tokens(&self, tokens: &mut crate::__private::TokenStream2) {
                let ident = crate::Ident::new("macro_rules", self.span);
                crate::__private::TokenStreamExt::append(tokens, ident);
            }
        }
        impl crate::__private::Copy for macro_rules {}
        #[allow(clippy::expl_impl_clone_on_copy)]
        impl crate::__private::Clone for macro_rules {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl crate::__private::Debug for macro_rules {
            fn fmt(
                &self,
                f: &mut crate::__private::Formatter,
            ) -> crate::__private::fmt::Result {
                crate::__private::Formatter::write_str(f, "Keyword [macro_rules]")
            }
        }
        impl crate::__private::Eq for macro_rules {}
        impl crate::__private::PartialEq for macro_rules {
            fn eq(&self, _other: &Self) -> crate::__private::bool {
                true
            }
        }
        impl crate::__private::Hash for macro_rules {
            fn hash<__H: crate::__private::Hasher>(&self, _state: &mut __H) {}
        }
        impl Parse for Item {
            fn parse(input: ParseStream) -> Result<Self> {
                let begin = input.fork();
                let mut attrs = input.call(Attribute::parse_outer)?;
                let ahead = input.fork();
                let vis: Visibility = ahead.parse()?;
                let lookahead = ahead.lookahead1();
                let mut item = if lookahead.peek(crate::token::Fn)
                    || peek_signature(&ahead)
                {
                    let vis: Visibility = input.parse()?;
                    let sig: Signature = input.parse()?;
                    if input.peek(crate::token::Semi) {
                        input.parse::<crate::token::Semi>()?;
                        Ok(Item::Verbatim(verbatim::between(begin, input)))
                    } else {
                        parse_rest_of_fn(input, Vec::new(), vis, sig).map(Item::Fn)
                    }
                } else if lookahead.peek(crate::token::Extern) {
                    ahead.parse::<crate::token::Extern>()?;
                    let lookahead = ahead.lookahead1();
                    if lookahead.peek(crate::token::Crate) {
                        input.parse().map(Item::ExternCrate)
                    } else if lookahead.peek(token::Brace) {
                        input.parse().map(Item::ForeignMod)
                    } else if lookahead.peek(LitStr) {
                        ahead.parse::<LitStr>()?;
                        let lookahead = ahead.lookahead1();
                        if lookahead.peek(token::Brace) {
                            input.parse().map(Item::ForeignMod)
                        } else {
                            Err(lookahead.error())
                        }
                    } else {
                        Err(lookahead.error())
                    }
                } else if lookahead.peek(crate::token::Use) {
                    input.parse().map(Item::Use)
                } else if lookahead.peek(crate::token::Static) {
                    let vis = input.parse()?;
                    let static_token = input.parse()?;
                    let mutability = input.parse()?;
                    let ident = input.parse()?;
                    if input.peek(crate::token::Eq) {
                        input.parse::<crate::token::Eq>()?;
                        input.parse::<Expr>()?;
                        input.parse::<crate::token::Semi>()?;
                        Ok(Item::Verbatim(verbatim::between(begin, input)))
                    } else {
                        let colon_token = input.parse()?;
                        let ty = input.parse()?;
                        if input.peek(crate::token::Semi) {
                            input.parse::<crate::token::Semi>()?;
                            Ok(Item::Verbatim(verbatim::between(begin, input)))
                        } else {
                            Ok(
                                Item::Static(ItemStatic {
                                    attrs: Vec::new(),
                                    vis,
                                    static_token,
                                    mutability,
                                    ident,
                                    colon_token,
                                    ty,
                                    eq_token: input.parse()?,
                                    expr: input.parse()?,
                                    semi_token: input.parse()?,
                                }),
                            )
                        }
                    }
                } else if lookahead.peek(crate::token::Const) {
                    ahead.parse::<crate::token::Const>()?;
                    let lookahead = ahead.lookahead1();
                    if lookahead.peek(Ident) || lookahead.peek(crate::token::Underscore)
                    {
                        let vis = input.parse()?;
                        let const_token = input.parse()?;
                        let ident = {
                            let lookahead = input.lookahead1();
                            if lookahead.peek(Ident)
                                || lookahead.peek(crate::token::Underscore)
                            {
                                input.call(Ident::parse_any)?
                            } else {
                                return Err(lookahead.error());
                            }
                        };
                        let colon_token = input.parse()?;
                        let ty = input.parse()?;
                        if input.peek(crate::token::Semi) {
                            input.parse::<crate::token::Semi>()?;
                            Ok(Item::Verbatim(verbatim::between(begin, input)))
                        } else {
                            Ok(
                                Item::Const(ItemConst {
                                    attrs: Vec::new(),
                                    vis,
                                    const_token,
                                    ident,
                                    colon_token,
                                    ty,
                                    eq_token: input.parse()?,
                                    expr: input.parse()?,
                                    semi_token: input.parse()?,
                                }),
                            )
                        }
                    } else {
                        Err(lookahead.error())
                    }
                } else if lookahead.peek(crate::token::Unsafe) {
                    ahead.parse::<crate::token::Unsafe>()?;
                    let lookahead = ahead.lookahead1();
                    if lookahead.peek(crate::token::Trait)
                        || lookahead.peek(crate::token::Auto)
                            && ahead.peek2(crate::token::Trait)
                    {
                        input.parse().map(Item::Trait)
                    } else if lookahead.peek(crate::token::Impl) {
                        let allow_verbatim_impl = true;
                        if let Some(item) = parse_impl(input, allow_verbatim_impl)? {
                            Ok(Item::Impl(item))
                        } else {
                            Ok(Item::Verbatim(verbatim::between(begin, input)))
                        }
                    } else if lookahead.peek(crate::token::Extern) {
                        input.parse::<Visibility>()?;
                        input.parse::<crate::token::Unsafe>()?;
                        input.parse::<ItemForeignMod>()?;
                        Ok(Item::Verbatim(verbatim::between(begin, input)))
                    } else if lookahead.peek(crate::token::Mod) {
                        input.parse::<Visibility>()?;
                        input.parse::<crate::token::Unsafe>()?;
                        input.parse::<ItemMod>()?;
                        Ok(Item::Verbatim(verbatim::between(begin, input)))
                    } else {
                        Err(lookahead.error())
                    }
                } else if lookahead.peek(crate::token::Mod) {
                    input.parse().map(Item::Mod)
                } else if lookahead.peek(crate::token::Type) {
                    parse_item_type(begin, input)
                } else if lookahead.peek(crate::token::Struct) {
                    input.parse().map(Item::Struct)
                } else if lookahead.peek(crate::token::Enum) {
                    input.parse().map(Item::Enum)
                } else if lookahead.peek(crate::token::Union) && ahead.peek2(Ident) {
                    input.parse().map(Item::Union)
                } else if lookahead.peek(crate::token::Trait) {
                    input.call(parse_trait_or_trait_alias)
                } else if lookahead.peek(crate::token::Auto)
                    && ahead.peek2(crate::token::Trait)
                {
                    input.parse().map(Item::Trait)
                } else if lookahead.peek(crate::token::Impl)
                    || lookahead.peek(crate::token::Default)
                        && !ahead.peek2(crate::token::Bang)
                {
                    let allow_verbatim_impl = true;
                    if let Some(item) = parse_impl(input, allow_verbatim_impl)? {
                        Ok(Item::Impl(item))
                    } else {
                        Ok(Item::Verbatim(verbatim::between(begin, input)))
                    }
                } else if lookahead.peek(crate::token::Macro) {
                    input.parse().map(Item::Macro2)
                } else if vis.is_inherited()
                    && (lookahead.peek(Ident) || lookahead.peek(crate::token::SelfValue)
                        || lookahead.peek(crate::token::Super)
                        || lookahead.peek(crate::token::Crate)
                        || lookahead.peek(crate::token::Colon2))
                {
                    input.parse().map(Item::Macro)
                } else if ahead.peek(macro_rules) {
                    input.advance_to(&ahead);
                    input.parse::<ItemMacro>()?;
                    Ok(Item::Verbatim(verbatim::between(begin, input)))
                } else {
                    Err(lookahead.error())
                }?;
                attrs.extend(item.replace_attrs(Vec::new()));
                item.replace_attrs(attrs);
                Ok(item)
            }
        }
        struct FlexibleItemType {
            vis: Visibility,
            defaultness: Option<crate::token::Default>,
            type_token: crate::token::Type,
            ident: Ident,
            generics: Generics,
            colon_token: Option<crate::token::Colon>,
            bounds: Punctuated<TypeParamBound, crate::token::Add>,
            ty: Option<(crate::token::Eq, Type)>,
            semi_token: crate::token::Semi,
        }
        enum WhereClauseLocation {
            BeforeEq,
            #[allow(dead_code)]
            AfterEq,
            Both,
        }
        impl FlexibleItemType {
            fn parse(
                input: ParseStream,
                where_clause_location: WhereClauseLocation,
            ) -> Result<Self> {
                let vis: Visibility = input.parse()?;
                let defaultness: Option<crate::token::Default> = input.parse()?;
                let type_token: crate::token::Type = input.parse()?;
                let ident: Ident = input.parse()?;
                let mut generics: Generics = input.parse()?;
                let colon_token: Option<crate::token::Colon> = input.parse()?;
                let mut bounds = Punctuated::new();
                if colon_token.is_some() {
                    loop {
                        if input.peek(crate::token::Where)
                            || input.peek(crate::token::Eq)
                            || input.peek(crate::token::Semi)
                        {
                            break;
                        }
                        bounds.push_value(input.parse::<TypeParamBound>()?);
                        if input.peek(crate::token::Where)
                            || input.peek(crate::token::Eq)
                            || input.peek(crate::token::Semi)
                        {
                            break;
                        }
                        bounds.push_punct(input.parse::<crate::token::Add>()?);
                    }
                }
                match where_clause_location {
                    WhereClauseLocation::BeforeEq | WhereClauseLocation::Both => {
                        generics.where_clause = input.parse()?;
                    }
                    _ => {}
                }
                let ty = if let Some(eq_token) = input.parse()? {
                    Some((eq_token, input.parse::<Type>()?))
                } else {
                    None
                };
                match where_clause_location {
                    WhereClauseLocation::AfterEq
                    | WhereClauseLocation::Both if generics.where_clause.is_none() => {
                        generics.where_clause = input.parse()?;
                    }
                    _ => {}
                }
                let semi_token: crate::token::Semi = input.parse()?;
                Ok(FlexibleItemType {
                    vis,
                    defaultness,
                    type_token,
                    ident,
                    generics,
                    colon_token,
                    bounds,
                    ty,
                    semi_token,
                })
            }
        }
        impl Parse for ItemMacro {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let path = input.call(Path::parse_mod_style)?;
                let bang_token: crate::token::Bang = input.parse()?;
                let ident: Option<Ident> = input.parse()?;
                let (delimiter, tokens) = input.call(mac::parse_delimiter)?;
                let semi_token: Option<crate::token::Semi> = if !delimiter.is_brace() {
                    Some(input.parse()?)
                } else {
                    None
                };
                Ok(ItemMacro {
                    attrs,
                    ident,
                    mac: Macro {
                        path,
                        bang_token,
                        delimiter,
                        tokens,
                    },
                    semi_token,
                })
            }
        }
        impl Parse for ItemMacro2 {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let vis: Visibility = input.parse()?;
                let macro_token: crate::token::Macro = input.parse()?;
                let ident: Ident = input.parse()?;
                let mut rules = TokenStream::new();
                let mut lookahead = input.lookahead1();
                if lookahead.peek(token::Paren) {
                    let paren_content;
                    let paren_token = match crate::group::parse_parens(&input) {
                        crate::__private::Ok(parens) => {
                            paren_content = parens.content;
                            parens.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    };
                    let args: TokenStream = paren_content.parse()?;
                    let mut args = Group::new(Delimiter::Parenthesis, args);
                    args.set_span(paren_token.span);
                    rules.extend(iter::once(TokenTree::Group(args)));
                    lookahead = input.lookahead1();
                }
                if lookahead.peek(token::Brace) {
                    let brace_content;
                    let brace_token = match crate::group::parse_braces(&input) {
                        crate::__private::Ok(braces) => {
                            brace_content = braces.content;
                            braces.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    };
                    let body: TokenStream = brace_content.parse()?;
                    let mut body = Group::new(Delimiter::Brace, body);
                    body.set_span(brace_token.span);
                    rules.extend(iter::once(TokenTree::Group(body)));
                } else {
                    return Err(lookahead.error());
                }
                Ok(ItemMacro2 {
                    attrs,
                    vis,
                    macro_token,
                    ident,
                    rules,
                })
            }
        }
        impl Parse for ItemExternCrate {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ItemExternCrate {
                    attrs: input.call(Attribute::parse_outer)?,
                    vis: input.parse()?,
                    extern_token: input.parse()?,
                    crate_token: input.parse()?,
                    ident: {
                        if input.peek(crate::token::SelfValue) {
                            input.call(Ident::parse_any)?
                        } else {
                            input.parse()?
                        }
                    },
                    rename: {
                        if input.peek(crate::token::As) {
                            let as_token: crate::token::As = input.parse()?;
                            let rename: Ident = if input.peek(crate::token::Underscore) {
                                Ident::from(input.parse::<crate::token::Underscore>()?)
                            } else {
                                input.parse()?
                            };
                            Some((as_token, rename))
                        } else {
                            None
                        }
                    },
                    semi_token: input.parse()?,
                })
            }
        }
        impl Parse for ItemUse {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ItemUse {
                    attrs: input.call(Attribute::parse_outer)?,
                    vis: input.parse()?,
                    use_token: input.parse()?,
                    leading_colon: input.parse()?,
                    tree: input.parse()?,
                    semi_token: input.parse()?,
                })
            }
        }
        impl Parse for UseTree {
            fn parse(input: ParseStream) -> Result<UseTree> {
                let lookahead = input.lookahead1();
                if lookahead.peek(Ident) || lookahead.peek(crate::token::SelfValue)
                    || lookahead.peek(crate::token::Super)
                    || lookahead.peek(crate::token::Crate)
                {
                    let ident = input.call(Ident::parse_any)?;
                    if input.peek(crate::token::Colon2) {
                        Ok(
                            UseTree::Path(UsePath {
                                ident,
                                colon2_token: input.parse()?,
                                tree: Box::new(input.parse()?),
                            }),
                        )
                    } else if input.peek(crate::token::As) {
                        Ok(
                            UseTree::Rename(UseRename {
                                ident,
                                as_token: input.parse()?,
                                rename: {
                                    if input.peek(Ident) {
                                        input.parse()?
                                    } else if input.peek(crate::token::Underscore) {
                                        Ident::from(input.parse::<crate::token::Underscore>()?)
                                    } else {
                                        return Err(
                                            input.error("expected identifier or underscore"),
                                        );
                                    }
                                },
                            }),
                        )
                    } else {
                        Ok(UseTree::Name(UseName { ident }))
                    }
                } else if lookahead.peek(crate::token::Star) {
                    Ok(
                        UseTree::Glob(UseGlob {
                            star_token: input.parse()?,
                        }),
                    )
                } else if lookahead.peek(token::Brace) {
                    let content;
                    Ok(
                        UseTree::Group(UseGroup {
                            brace_token: match crate::group::parse_braces(&input) {
                                crate::__private::Ok(braces) => {
                                    content = braces.content;
                                    braces.token
                                }
                                crate::__private::Err(error) => {
                                    return crate::__private::Err(error);
                                }
                            },
                            items: content.parse_terminated(UseTree::parse)?,
                        }),
                    )
                } else {
                    Err(lookahead.error())
                }
            }
        }
        impl Parse for ItemStatic {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ItemStatic {
                    attrs: input.call(Attribute::parse_outer)?,
                    vis: input.parse()?,
                    static_token: input.parse()?,
                    mutability: input.parse()?,
                    ident: input.parse()?,
                    colon_token: input.parse()?,
                    ty: input.parse()?,
                    eq_token: input.parse()?,
                    expr: input.parse()?,
                    semi_token: input.parse()?,
                })
            }
        }
        impl Parse for ItemConst {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ItemConst {
                    attrs: input.call(Attribute::parse_outer)?,
                    vis: input.parse()?,
                    const_token: input.parse()?,
                    ident: {
                        let lookahead = input.lookahead1();
                        if lookahead.peek(Ident)
                            || lookahead.peek(crate::token::Underscore)
                        {
                            input.call(Ident::parse_any)?
                        } else {
                            return Err(lookahead.error());
                        }
                    },
                    colon_token: input.parse()?,
                    ty: input.parse()?,
                    eq_token: input.parse()?,
                    expr: input.parse()?,
                    semi_token: input.parse()?,
                })
            }
        }
        fn pop_variadic(
            args: &mut Punctuated<FnArg, crate::token::Comma>,
        ) -> Option<Variadic> {
            let trailing_punct = args.trailing_punct();
            let last = match args.last_mut()? {
                FnArg::Typed(last) => last,
                _ => return None,
            };
            let ty = match last.ty.as_ref() {
                Type::Verbatim(ty) => ty,
                _ => return None,
            };
            let mut variadic = Variadic {
                attrs: Vec::new(),
                dots: parse2(ty.clone()).ok()?,
            };
            if let Pat::Verbatim(pat) = last.pat.as_ref() {
                if pat.to_string() == "..." && !trailing_punct {
                    variadic.attrs = mem::replace(&mut last.attrs, Vec::new());
                    args.pop();
                }
            }
            Some(variadic)
        }
        fn variadic_to_tokens(dots: &crate::token::Dot3) -> TokenStream {
            TokenStream::from_iter(
                <[_]>::into_vec(
                    #[rustc_box]
                    ::alloc::boxed::Box::new([
                        TokenTree::Punct({
                            let mut dot = Punct::new('.', Spacing::Joint);
                            dot.set_span(dots.spans[0]);
                            dot
                        }),
                        TokenTree::Punct({
                            let mut dot = Punct::new('.', Spacing::Joint);
                            dot.set_span(dots.spans[1]);
                            dot
                        }),
                        TokenTree::Punct({
                            let mut dot = Punct::new('.', Spacing::Alone);
                            dot.set_span(dots.spans[2]);
                            dot
                        }),
                    ]),
                ),
            )
        }
        fn peek_signature(input: ParseStream) -> bool {
            let fork = input.fork();
            fork.parse::<Option<crate::token::Const>>().is_ok()
                && fork.parse::<Option<crate::token::Async>>().is_ok()
                && fork.parse::<Option<crate::token::Unsafe>>().is_ok()
                && fork.parse::<Option<Abi>>().is_ok() && fork.peek(crate::token::Fn)
        }
        impl Parse for Signature {
            fn parse(input: ParseStream) -> Result<Self> {
                let constness: Option<crate::token::Const> = input.parse()?;
                let asyncness: Option<crate::token::Async> = input.parse()?;
                let unsafety: Option<crate::token::Unsafe> = input.parse()?;
                let abi: Option<Abi> = input.parse()?;
                let fn_token: crate::token::Fn = input.parse()?;
                let ident: Ident = input.parse()?;
                let mut generics: Generics = input.parse()?;
                let content;
                let paren_token = match crate::group::parse_parens(&input) {
                    crate::__private::Ok(parens) => {
                        content = parens.content;
                        parens.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                };
                let mut inputs = parse_fn_args(&content)?;
                let variadic = pop_variadic(&mut inputs);
                let output: ReturnType = input.parse()?;
                generics.where_clause = input.parse()?;
                Ok(Signature {
                    constness,
                    asyncness,
                    unsafety,
                    abi,
                    fn_token,
                    ident,
                    generics,
                    paren_token,
                    inputs,
                    variadic,
                    output,
                })
            }
        }
        impl Parse for ItemFn {
            fn parse(input: ParseStream) -> Result<Self> {
                let outer_attrs = input.call(Attribute::parse_outer)?;
                let vis: Visibility = input.parse()?;
                let sig: Signature = input.parse()?;
                parse_rest_of_fn(input, outer_attrs, vis, sig)
            }
        }
        fn parse_rest_of_fn(
            input: ParseStream,
            mut attrs: Vec<Attribute>,
            vis: Visibility,
            sig: Signature,
        ) -> Result<ItemFn> {
            let content;
            let brace_token = match crate::group::parse_braces(&input) {
                crate::__private::Ok(braces) => {
                    content = braces.content;
                    braces.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
            attr::parsing::parse_inner(&content, &mut attrs)?;
            let stmts = content.call(Block::parse_within)?;
            Ok(ItemFn {
                attrs,
                vis,
                sig,
                block: Box::new(Block { brace_token, stmts }),
            })
        }
        impl Parse for FnArg {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let ahead = input.fork();
                if let Ok(mut receiver) = ahead.parse::<Receiver>() {
                    if !ahead.peek(crate::token::Colon) {
                        input.advance_to(&ahead);
                        receiver.attrs = attrs;
                        return Ok(FnArg::Receiver(receiver));
                    }
                }
                let mut typed = input.call(fn_arg_typed)?;
                typed.attrs = attrs;
                Ok(FnArg::Typed(typed))
            }
        }
        impl Parse for Receiver {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(Receiver {
                    attrs: Vec::new(),
                    reference: {
                        if input.peek(crate::token::And) {
                            Some((input.parse()?, input.parse()?))
                        } else {
                            None
                        }
                    },
                    mutability: input.parse()?,
                    self_token: input.parse()?,
                })
            }
        }
        fn parse_fn_args(
            input: ParseStream,
        ) -> Result<Punctuated<FnArg, crate::token::Comma>> {
            let mut args = Punctuated::new();
            let mut has_receiver = false;
            while !input.is_empty() {
                let attrs = input.call(Attribute::parse_outer)?;
                let arg = if let Some(dots) = input
                    .parse::<Option<crate::token::Dot3>>()?
                {
                    FnArg::Typed(PatType {
                        attrs,
                        pat: Box::new(Pat::Verbatim(variadic_to_tokens(&dots))),
                        colon_token: crate::token::Colon(dots.spans[0]),
                        ty: Box::new(Type::Verbatim(variadic_to_tokens(&dots))),
                    })
                } else {
                    let mut arg: FnArg = input.parse()?;
                    match &mut arg {
                        FnArg::Receiver(receiver) if has_receiver => {
                            return Err(
                                Error::new(
                                    receiver.self_token.span,
                                    "unexpected second method receiver",
                                ),
                            );
                        }
                        FnArg::Receiver(receiver) if !args.is_empty() => {
                            return Err(
                                Error::new(
                                    receiver.self_token.span,
                                    "unexpected method receiver",
                                ),
                            );
                        }
                        FnArg::Receiver(receiver) => {
                            has_receiver = true;
                            receiver.attrs = attrs;
                        }
                        FnArg::Typed(arg) => arg.attrs = attrs,
                    }
                    arg
                };
                args.push_value(arg);
                if input.is_empty() {
                    break;
                }
                let comma: crate::token::Comma = input.parse()?;
                args.push_punct(comma);
            }
            Ok(args)
        }
        fn fn_arg_typed(input: ParseStream) -> Result<PatType> {
            if input.peek(Ident) && input.peek2(crate::token::Lt) {
                let span = input.fork().parse::<Ident>()?.span();
                return Ok(PatType {
                    attrs: Vec::new(),
                    pat: Box::new(
                        Pat::Wild(PatWild {
                            attrs: Vec::new(),
                            underscore_token: crate::token::Underscore(span),
                        }),
                    ),
                    colon_token: crate::token::Colon(span),
                    ty: input.parse()?,
                });
            }
            Ok(PatType {
                attrs: Vec::new(),
                pat: Box::new(pat::parsing::multi_pat(input)?),
                colon_token: input.parse()?,
                ty: Box::new(
                    match input.parse::<Option<crate::token::Dot3>>()? {
                        Some(dot3) => Type::Verbatim(variadic_to_tokens(&dot3)),
                        None => input.parse()?,
                    },
                ),
            })
        }
        impl Parse for ItemMod {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut attrs = input.call(Attribute::parse_outer)?;
                let vis: Visibility = input.parse()?;
                let mod_token: crate::token::Mod = input.parse()?;
                let ident: Ident = input.parse()?;
                let lookahead = input.lookahead1();
                if lookahead.peek(crate::token::Semi) {
                    Ok(ItemMod {
                        attrs,
                        vis,
                        mod_token,
                        ident,
                        content: None,
                        semi: Some(input.parse()?),
                    })
                } else if lookahead.peek(token::Brace) {
                    let content;
                    let brace_token = match crate::group::parse_braces(&input) {
                        crate::__private::Ok(braces) => {
                            content = braces.content;
                            braces.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    };
                    attr::parsing::parse_inner(&content, &mut attrs)?;
                    let mut items = Vec::new();
                    while !content.is_empty() {
                        items.push(content.parse()?);
                    }
                    Ok(ItemMod {
                        attrs,
                        vis,
                        mod_token,
                        ident,
                        content: Some((brace_token, items)),
                        semi: None,
                    })
                } else {
                    Err(lookahead.error())
                }
            }
        }
        impl Parse for ItemForeignMod {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut attrs = input.call(Attribute::parse_outer)?;
                let abi: Abi = input.parse()?;
                let content;
                let brace_token = match crate::group::parse_braces(&input) {
                    crate::__private::Ok(braces) => {
                        content = braces.content;
                        braces.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                };
                attr::parsing::parse_inner(&content, &mut attrs)?;
                let mut items = Vec::new();
                while !content.is_empty() {
                    items.push(content.parse()?);
                }
                Ok(ItemForeignMod {
                    attrs,
                    abi,
                    brace_token,
                    items,
                })
            }
        }
        impl Parse for ForeignItem {
            fn parse(input: ParseStream) -> Result<Self> {
                let begin = input.fork();
                let mut attrs = input.call(Attribute::parse_outer)?;
                let ahead = input.fork();
                let vis: Visibility = ahead.parse()?;
                let lookahead = ahead.lookahead1();
                let mut item = if lookahead.peek(crate::token::Fn)
                    || peek_signature(&ahead)
                {
                    let vis: Visibility = input.parse()?;
                    let sig: Signature = input.parse()?;
                    if input.peek(token::Brace) {
                        let content;
                        match crate::group::parse_braces(&input) {
                            crate::__private::Ok(braces) => {
                                content = braces.content;
                                braces.token
                            }
                            crate::__private::Err(error) => {
                                return crate::__private::Err(error);
                            }
                        };
                        content.call(Attribute::parse_inner)?;
                        content.call(Block::parse_within)?;
                        Ok(ForeignItem::Verbatim(verbatim::between(begin, input)))
                    } else {
                        Ok(
                            ForeignItem::Fn(ForeignItemFn {
                                attrs: Vec::new(),
                                vis,
                                sig,
                                semi_token: input.parse()?,
                            }),
                        )
                    }
                } else if lookahead.peek(crate::token::Static) {
                    let vis = input.parse()?;
                    let static_token = input.parse()?;
                    let mutability = input.parse()?;
                    let ident = input.parse()?;
                    let colon_token = input.parse()?;
                    let ty = input.parse()?;
                    if input.peek(crate::token::Eq) {
                        input.parse::<crate::token::Eq>()?;
                        input.parse::<Expr>()?;
                        input.parse::<crate::token::Semi>()?;
                        Ok(ForeignItem::Verbatim(verbatim::between(begin, input)))
                    } else {
                        Ok(
                            ForeignItem::Static(ForeignItemStatic {
                                attrs: Vec::new(),
                                vis,
                                static_token,
                                mutability,
                                ident,
                                colon_token,
                                ty,
                                semi_token: input.parse()?,
                            }),
                        )
                    }
                } else if lookahead.peek(crate::token::Type) {
                    parse_foreign_item_type(begin, input)
                } else if vis.is_inherited()
                    && (lookahead.peek(Ident) || lookahead.peek(crate::token::SelfValue)
                        || lookahead.peek(crate::token::Super)
                        || lookahead.peek(crate::token::Crate)
                        || lookahead.peek(crate::token::Colon2))
                {
                    input.parse().map(ForeignItem::Macro)
                } else {
                    Err(lookahead.error())
                }?;
                let item_attrs = match &mut item {
                    ForeignItem::Fn(item) => &mut item.attrs,
                    ForeignItem::Static(item) => &mut item.attrs,
                    ForeignItem::Type(item) => &mut item.attrs,
                    ForeignItem::Macro(item) => &mut item.attrs,
                    ForeignItem::Verbatim(_) => return Ok(item),
                };
                attrs.append(item_attrs);
                *item_attrs = attrs;
                Ok(item)
            }
        }
        impl Parse for ForeignItemFn {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let vis: Visibility = input.parse()?;
                let sig: Signature = input.parse()?;
                let semi_token: crate::token::Semi = input.parse()?;
                Ok(ForeignItemFn {
                    attrs,
                    vis,
                    sig,
                    semi_token,
                })
            }
        }
        impl Parse for ForeignItemStatic {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ForeignItemStatic {
                    attrs: input.call(Attribute::parse_outer)?,
                    vis: input.parse()?,
                    static_token: input.parse()?,
                    mutability: input.parse()?,
                    ident: input.parse()?,
                    colon_token: input.parse()?,
                    ty: input.parse()?,
                    semi_token: input.parse()?,
                })
            }
        }
        impl Parse for ForeignItemType {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ForeignItemType {
                    attrs: input.call(Attribute::parse_outer)?,
                    vis: input.parse()?,
                    type_token: input.parse()?,
                    ident: input.parse()?,
                    semi_token: input.parse()?,
                })
            }
        }
        fn parse_foreign_item_type(
            begin: ParseBuffer,
            input: ParseStream,
        ) -> Result<ForeignItem> {
            let FlexibleItemType {
                vis,
                defaultness,
                type_token,
                ident,
                generics,
                colon_token,
                bounds: _,
                ty,
                semi_token,
            } = FlexibleItemType::parse(input, WhereClauseLocation::BeforeEq)?;
            if defaultness.is_some() || generics.lt_token.is_some()
                || generics.where_clause.is_some() || colon_token.is_some()
                || ty.is_some()
            {
                Ok(ForeignItem::Verbatim(verbatim::between(begin, input)))
            } else {
                Ok(
                    ForeignItem::Type(ForeignItemType {
                        attrs: Vec::new(),
                        vis,
                        type_token,
                        ident,
                        semi_token,
                    }),
                )
            }
        }
        impl Parse for ForeignItemMacro {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let mac: Macro = input.parse()?;
                let semi_token: Option<crate::token::Semi> = if mac.delimiter.is_brace()
                {
                    None
                } else {
                    Some(input.parse()?)
                };
                Ok(ForeignItemMacro {
                    attrs,
                    mac,
                    semi_token,
                })
            }
        }
        impl Parse for ItemType {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ItemType {
                    attrs: input.call(Attribute::parse_outer)?,
                    vis: input.parse()?,
                    type_token: input.parse()?,
                    ident: input.parse()?,
                    generics: {
                        let mut generics: Generics = input.parse()?;
                        generics.where_clause = input.parse()?;
                        generics
                    },
                    eq_token: input.parse()?,
                    ty: input.parse()?,
                    semi_token: input.parse()?,
                })
            }
        }
        fn parse_item_type(begin: ParseBuffer, input: ParseStream) -> Result<Item> {
            let FlexibleItemType {
                vis,
                defaultness,
                type_token,
                ident,
                generics,
                colon_token,
                bounds: _,
                ty,
                semi_token,
            } = FlexibleItemType::parse(input, WhereClauseLocation::BeforeEq)?;
            if defaultness.is_some() || colon_token.is_some() || ty.is_none() {
                Ok(Item::Verbatim(verbatim::between(begin, input)))
            } else {
                let (eq_token, ty) = ty.unwrap();
                Ok(
                    Item::Type(ItemType {
                        attrs: Vec::new(),
                        vis,
                        type_token,
                        ident,
                        generics,
                        eq_token,
                        ty: Box::new(ty),
                        semi_token,
                    }),
                )
            }
        }
        impl Parse for ItemStruct {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let vis = input.parse::<Visibility>()?;
                let struct_token = input.parse::<crate::token::Struct>()?;
                let ident = input.parse::<Ident>()?;
                let generics = input.parse::<Generics>()?;
                let (where_clause, fields, semi_token) = derive::parsing::data_struct(
                    input,
                )?;
                Ok(ItemStruct {
                    attrs,
                    vis,
                    struct_token,
                    ident,
                    generics: Generics {
                        where_clause,
                        ..generics
                    },
                    fields,
                    semi_token,
                })
            }
        }
        impl Parse for ItemEnum {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let vis = input.parse::<Visibility>()?;
                let enum_token = input.parse::<crate::token::Enum>()?;
                let ident = input.parse::<Ident>()?;
                let generics = input.parse::<Generics>()?;
                let (where_clause, brace_token, variants) = derive::parsing::data_enum(
                    input,
                )?;
                Ok(ItemEnum {
                    attrs,
                    vis,
                    enum_token,
                    ident,
                    generics: Generics {
                        where_clause,
                        ..generics
                    },
                    brace_token,
                    variants,
                })
            }
        }
        impl Parse for ItemUnion {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let vis = input.parse::<Visibility>()?;
                let union_token = input.parse::<crate::token::Union>()?;
                let ident = input.parse::<Ident>()?;
                let generics = input.parse::<Generics>()?;
                let (where_clause, fields) = derive::parsing::data_union(input)?;
                Ok(ItemUnion {
                    attrs,
                    vis,
                    union_token,
                    ident,
                    generics: Generics {
                        where_clause,
                        ..generics
                    },
                    fields,
                })
            }
        }
        fn parse_trait_or_trait_alias(input: ParseStream) -> Result<Item> {
            let (attrs, vis, trait_token, ident, generics) = parse_start_of_trait_alias(
                input,
            )?;
            let lookahead = input.lookahead1();
            if lookahead.peek(token::Brace) || lookahead.peek(crate::token::Colon)
                || lookahead.peek(crate::token::Where)
            {
                let unsafety = None;
                let auto_token = None;
                parse_rest_of_trait(
                        input,
                        attrs,
                        vis,
                        unsafety,
                        auto_token,
                        trait_token,
                        ident,
                        generics,
                    )
                    .map(Item::Trait)
            } else if lookahead.peek(crate::token::Eq) {
                parse_rest_of_trait_alias(
                        input,
                        attrs,
                        vis,
                        trait_token,
                        ident,
                        generics,
                    )
                    .map(Item::TraitAlias)
            } else {
                Err(lookahead.error())
            }
        }
        impl Parse for ItemTrait {
            fn parse(input: ParseStream) -> Result<Self> {
                let outer_attrs = input.call(Attribute::parse_outer)?;
                let vis: Visibility = input.parse()?;
                let unsafety: Option<crate::token::Unsafe> = input.parse()?;
                let auto_token: Option<crate::token::Auto> = input.parse()?;
                let trait_token: crate::token::Trait = input.parse()?;
                let ident: Ident = input.parse()?;
                let generics: Generics = input.parse()?;
                parse_rest_of_trait(
                    input,
                    outer_attrs,
                    vis,
                    unsafety,
                    auto_token,
                    trait_token,
                    ident,
                    generics,
                )
            }
        }
        fn parse_rest_of_trait(
            input: ParseStream,
            mut attrs: Vec<Attribute>,
            vis: Visibility,
            unsafety: Option<crate::token::Unsafe>,
            auto_token: Option<crate::token::Auto>,
            trait_token: crate::token::Trait,
            ident: Ident,
            mut generics: Generics,
        ) -> Result<ItemTrait> {
            let colon_token: Option<crate::token::Colon> = input.parse()?;
            let mut supertraits = Punctuated::new();
            if colon_token.is_some() {
                loop {
                    if input.peek(crate::token::Where) || input.peek(token::Brace) {
                        break;
                    }
                    supertraits.push_value(input.parse()?);
                    if input.peek(crate::token::Where) || input.peek(token::Brace) {
                        break;
                    }
                    supertraits.push_punct(input.parse()?);
                }
            }
            generics.where_clause = input.parse()?;
            let content;
            let brace_token = match crate::group::parse_braces(&input) {
                crate::__private::Ok(braces) => {
                    content = braces.content;
                    braces.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
            attr::parsing::parse_inner(&content, &mut attrs)?;
            let mut items = Vec::new();
            while !content.is_empty() {
                items.push(content.parse()?);
            }
            Ok(ItemTrait {
                attrs,
                vis,
                unsafety,
                auto_token,
                trait_token,
                ident,
                generics,
                colon_token,
                supertraits,
                brace_token,
                items,
            })
        }
        impl Parse for ItemTraitAlias {
            fn parse(input: ParseStream) -> Result<Self> {
                let (attrs, vis, trait_token, ident, generics) = parse_start_of_trait_alias(
                    input,
                )?;
                parse_rest_of_trait_alias(
                    input,
                    attrs,
                    vis,
                    trait_token,
                    ident,
                    generics,
                )
            }
        }
        fn parse_start_of_trait_alias(
            input: ParseStream,
        ) -> Result<(Vec<Attribute>, Visibility, crate::token::Trait, Ident, Generics)> {
            let attrs = input.call(Attribute::parse_outer)?;
            let vis: Visibility = input.parse()?;
            let trait_token: crate::token::Trait = input.parse()?;
            let ident: Ident = input.parse()?;
            let generics: Generics = input.parse()?;
            Ok((attrs, vis, trait_token, ident, generics))
        }
        fn parse_rest_of_trait_alias(
            input: ParseStream,
            attrs: Vec<Attribute>,
            vis: Visibility,
            trait_token: crate::token::Trait,
            ident: Ident,
            mut generics: Generics,
        ) -> Result<ItemTraitAlias> {
            let eq_token: crate::token::Eq = input.parse()?;
            let mut bounds = Punctuated::new();
            loop {
                if input.peek(crate::token::Where) || input.peek(crate::token::Semi) {
                    break;
                }
                bounds.push_value(input.parse()?);
                if input.peek(crate::token::Where) || input.peek(crate::token::Semi) {
                    break;
                }
                bounds.push_punct(input.parse()?);
            }
            generics.where_clause = input.parse()?;
            let semi_token: crate::token::Semi = input.parse()?;
            Ok(ItemTraitAlias {
                attrs,
                vis,
                trait_token,
                ident,
                generics,
                eq_token,
                bounds,
                semi_token,
            })
        }
        impl Parse for TraitItem {
            fn parse(input: ParseStream) -> Result<Self> {
                let begin = input.fork();
                let mut attrs = input.call(Attribute::parse_outer)?;
                let vis: Visibility = input.parse()?;
                let defaultness: Option<crate::token::Default> = input.parse()?;
                let ahead = input.fork();
                let lookahead = ahead.lookahead1();
                let mut item = if lookahead.peek(crate::token::Fn)
                    || peek_signature(&ahead)
                {
                    input.parse().map(TraitItem::Method)
                } else if lookahead.peek(crate::token::Const) {
                    ahead.parse::<crate::token::Const>()?;
                    let lookahead = ahead.lookahead1();
                    if lookahead.peek(Ident) || lookahead.peek(crate::token::Underscore)
                    {
                        input.parse().map(TraitItem::Const)
                    } else if lookahead.peek(crate::token::Async)
                        || lookahead.peek(crate::token::Unsafe)
                        || lookahead.peek(crate::token::Extern)
                        || lookahead.peek(crate::token::Fn)
                    {
                        input.parse().map(TraitItem::Method)
                    } else {
                        Err(lookahead.error())
                    }
                } else if lookahead.peek(crate::token::Type) {
                    parse_trait_item_type(begin.fork(), input)
                } else if lookahead.peek(Ident)
                    || lookahead.peek(crate::token::SelfValue)
                    || lookahead.peek(crate::token::Super)
                    || lookahead.peek(crate::token::Crate)
                    || lookahead.peek(crate::token::Colon2)
                {
                    input.parse().map(TraitItem::Macro)
                } else {
                    Err(lookahead.error())
                }?;
                match (vis, defaultness) {
                    (Visibility::Inherited, None) => {}
                    _ => return Ok(TraitItem::Verbatim(verbatim::between(begin, input))),
                }
                let item_attrs = match &mut item {
                    TraitItem::Const(item) => &mut item.attrs,
                    TraitItem::Method(item) => &mut item.attrs,
                    TraitItem::Type(item) => &mut item.attrs,
                    TraitItem::Macro(item) => &mut item.attrs,
                    TraitItem::Verbatim(_) => {
                        ::core::panicking::panic(
                            "internal error: entered unreachable code",
                        )
                    }
                };
                attrs.append(item_attrs);
                *item_attrs = attrs;
                Ok(item)
            }
        }
        impl Parse for TraitItemConst {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(TraitItemConst {
                    attrs: input.call(Attribute::parse_outer)?,
                    const_token: input.parse()?,
                    ident: {
                        let lookahead = input.lookahead1();
                        if lookahead.peek(Ident)
                            || lookahead.peek(crate::token::Underscore)
                        {
                            input.call(Ident::parse_any)?
                        } else {
                            return Err(lookahead.error());
                        }
                    },
                    colon_token: input.parse()?,
                    ty: input.parse()?,
                    default: {
                        if input.peek(crate::token::Eq) {
                            let eq_token: crate::token::Eq = input.parse()?;
                            let default: Expr = input.parse()?;
                            Some((eq_token, default))
                        } else {
                            None
                        }
                    },
                    semi_token: input.parse()?,
                })
            }
        }
        impl Parse for TraitItemMethod {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut attrs = input.call(Attribute::parse_outer)?;
                let sig: Signature = input.parse()?;
                let lookahead = input.lookahead1();
                let (brace_token, stmts, semi_token) = if lookahead.peek(token::Brace) {
                    let content;
                    let brace_token = match crate::group::parse_braces(&input) {
                        crate::__private::Ok(braces) => {
                            content = braces.content;
                            braces.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    };
                    attr::parsing::parse_inner(&content, &mut attrs)?;
                    let stmts = content.call(Block::parse_within)?;
                    (Some(brace_token), stmts, None)
                } else if lookahead.peek(crate::token::Semi) {
                    let semi_token: crate::token::Semi = input.parse()?;
                    (None, Vec::new(), Some(semi_token))
                } else {
                    return Err(lookahead.error());
                };
                Ok(TraitItemMethod {
                    attrs,
                    sig,
                    default: brace_token.map(|brace_token| Block { brace_token, stmts }),
                    semi_token,
                })
            }
        }
        impl Parse for TraitItemType {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let type_token: crate::token::Type = input.parse()?;
                let ident: Ident = input.parse()?;
                let mut generics: Generics = input.parse()?;
                let colon_token: Option<crate::token::Colon> = input.parse()?;
                let mut bounds = Punctuated::new();
                if colon_token.is_some() {
                    while !input.peek(crate::token::Where)
                        && !input.peek(crate::token::Eq)
                        && !input.peek(crate::token::Semi)
                    {
                        if !bounds.is_empty() {
                            bounds.push_punct(input.parse()?);
                        }
                        bounds.push_value(input.parse()?);
                    }
                }
                let default = if input.peek(crate::token::Eq) {
                    let eq_token: crate::token::Eq = input.parse()?;
                    let default: Type = input.parse()?;
                    Some((eq_token, default))
                } else {
                    None
                };
                generics.where_clause = input.parse()?;
                let semi_token: crate::token::Semi = input.parse()?;
                Ok(TraitItemType {
                    attrs,
                    type_token,
                    ident,
                    generics,
                    colon_token,
                    bounds,
                    default,
                    semi_token,
                })
            }
        }
        fn parse_trait_item_type(
            begin: ParseBuffer,
            input: ParseStream,
        ) -> Result<TraitItem> {
            let FlexibleItemType {
                vis,
                defaultness,
                type_token,
                ident,
                generics,
                colon_token,
                bounds,
                ty,
                semi_token,
            } = FlexibleItemType::parse(input, WhereClauseLocation::Both)?;
            if defaultness.is_some() || vis.is_some() {
                Ok(TraitItem::Verbatim(verbatim::between(begin, input)))
            } else {
                Ok(
                    TraitItem::Type(TraitItemType {
                        attrs: Vec::new(),
                        type_token,
                        ident,
                        generics,
                        colon_token,
                        bounds,
                        default: ty,
                        semi_token,
                    }),
                )
            }
        }
        impl Parse for TraitItemMacro {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let mac: Macro = input.parse()?;
                let semi_token: Option<crate::token::Semi> = if mac.delimiter.is_brace()
                {
                    None
                } else {
                    Some(input.parse()?)
                };
                Ok(TraitItemMacro {
                    attrs,
                    mac,
                    semi_token,
                })
            }
        }
        impl Parse for ItemImpl {
            fn parse(input: ParseStream) -> Result<Self> {
                let allow_verbatim_impl = false;
                parse_impl(input, allow_verbatim_impl).map(Option::unwrap)
            }
        }
        fn parse_impl(
            input: ParseStream,
            allow_verbatim_impl: bool,
        ) -> Result<Option<ItemImpl>> {
            let mut attrs = input.call(Attribute::parse_outer)?;
            let has_visibility = allow_verbatim_impl
                && input.parse::<Visibility>()?.is_some();
            let defaultness: Option<crate::token::Default> = input.parse()?;
            let unsafety: Option<crate::token::Unsafe> = input.parse()?;
            let impl_token: crate::token::Impl = input.parse()?;
            let has_generics = input.peek(crate::token::Lt)
                && (input.peek2(crate::token::Gt) || input.peek2(crate::token::Pound)
                    || (input.peek2(Ident) || input.peek2(Lifetime))
                        && (input.peek3(crate::token::Colon)
                            || input.peek3(crate::token::Comma)
                            || input.peek3(crate::token::Gt)
                            || input.peek3(crate::token::Eq))
                    || input.peek2(crate::token::Const));
            let mut generics: Generics = if has_generics {
                input.parse()?
            } else {
                Generics::default()
            };
            let is_const_impl = allow_verbatim_impl
                && (input.peek(crate::token::Const)
                    || input.peek(crate::token::Question)
                        && input.peek2(crate::token::Const));
            if is_const_impl {
                input.parse::<Option<crate::token::Question>>()?;
                input.parse::<crate::token::Const>()?;
            }
            let begin = input.fork();
            let polarity = if input.peek(crate::token::Bang)
                && !input.peek2(token::Brace)
            {
                Some(input.parse::<crate::token::Bang>()?)
            } else {
                None
            };
            let mut first_ty: Type = input.parse()?;
            let self_ty: Type;
            let trait_;
            let is_impl_for = input.peek(crate::token::For);
            if is_impl_for {
                let for_token: crate::token::For = input.parse()?;
                let mut first_ty_ref = &first_ty;
                while let Type::Group(ty) = first_ty_ref {
                    first_ty_ref = &ty.elem;
                }
                if let Type::Path(TypePath { qself: None, .. }) = first_ty_ref {
                    while let Type::Group(ty) = first_ty {
                        first_ty = *ty.elem;
                    }
                    if let Type::Path(TypePath { qself: None, path }) = first_ty {
                        trait_ = Some((polarity, path, for_token));
                    } else {
                        ::core::panicking::panic(
                            "internal error: entered unreachable code",
                        );
                    }
                } else if !allow_verbatim_impl {
                    #[cfg(feature = "printing")]
                    return Err(Error::new_spanned(first_ty_ref, "expected trait path"));
                } else {
                    trait_ = None;
                }
                self_ty = input.parse()?;
            } else {
                trait_ = None;
                self_ty = if polarity.is_none() {
                    first_ty
                } else {
                    Type::Verbatim(verbatim::between(begin, input))
                };
            }
            generics.where_clause = input.parse()?;
            let content;
            let brace_token = match crate::group::parse_braces(&input) {
                crate::__private::Ok(braces) => {
                    content = braces.content;
                    braces.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
            attr::parsing::parse_inner(&content, &mut attrs)?;
            let mut items = Vec::new();
            while !content.is_empty() {
                items.push(content.parse()?);
            }
            if has_visibility || is_const_impl || is_impl_for && trait_.is_none() {
                Ok(None)
            } else {
                Ok(
                    Some(ItemImpl {
                        attrs,
                        defaultness,
                        unsafety,
                        impl_token,
                        generics,
                        trait_,
                        self_ty: Box::new(self_ty),
                        brace_token,
                        items,
                    }),
                )
            }
        }
        impl Parse for ImplItem {
            fn parse(input: ParseStream) -> Result<Self> {
                let begin = input.fork();
                let mut attrs = input.call(Attribute::parse_outer)?;
                let ahead = input.fork();
                let vis: Visibility = ahead.parse()?;
                let mut lookahead = ahead.lookahead1();
                let defaultness = if lookahead.peek(crate::token::Default)
                    && !ahead.peek2(crate::token::Bang)
                {
                    let defaultness: crate::token::Default = ahead.parse()?;
                    lookahead = ahead.lookahead1();
                    Some(defaultness)
                } else {
                    None
                };
                let mut item = if lookahead.peek(crate::token::Fn)
                    || peek_signature(&ahead)
                {
                    input.parse().map(ImplItem::Method)
                } else if lookahead.peek(crate::token::Const) {
                    let const_token: crate::token::Const = ahead.parse()?;
                    let lookahead = ahead.lookahead1();
                    if lookahead.peek(Ident) || lookahead.peek(crate::token::Underscore)
                    {
                        input.advance_to(&ahead);
                        let ident: Ident = input.call(Ident::parse_any)?;
                        let colon_token: crate::token::Colon = input.parse()?;
                        let ty: Type = input.parse()?;
                        if let Some(eq_token) = input.parse()? {
                            return Ok(
                                ImplItem::Const(ImplItemConst {
                                    attrs,
                                    vis,
                                    defaultness,
                                    const_token,
                                    ident,
                                    colon_token,
                                    ty,
                                    eq_token,
                                    expr: input.parse()?,
                                    semi_token: input.parse()?,
                                }),
                            );
                        } else {
                            input.parse::<crate::token::Semi>()?;
                            return Ok(
                                ImplItem::Verbatim(verbatim::between(begin, input)),
                            );
                        }
                    } else {
                        Err(lookahead.error())
                    }
                } else if lookahead.peek(crate::token::Type) {
                    parse_impl_item_type(begin, input)
                } else if vis.is_inherited() && defaultness.is_none()
                    && (lookahead.peek(Ident) || lookahead.peek(crate::token::SelfValue)
                        || lookahead.peek(crate::token::Super)
                        || lookahead.peek(crate::token::Crate)
                        || lookahead.peek(crate::token::Colon2))
                {
                    input.parse().map(ImplItem::Macro)
                } else {
                    Err(lookahead.error())
                }?;
                {
                    let item_attrs = match &mut item {
                        ImplItem::Const(item) => &mut item.attrs,
                        ImplItem::Method(item) => &mut item.attrs,
                        ImplItem::Type(item) => &mut item.attrs,
                        ImplItem::Macro(item) => &mut item.attrs,
                        ImplItem::Verbatim(_) => return Ok(item),
                    };
                    attrs.append(item_attrs);
                    *item_attrs = attrs;
                }
                Ok(item)
            }
        }
        impl Parse for ImplItemConst {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(ImplItemConst {
                    attrs: input.call(Attribute::parse_outer)?,
                    vis: input.parse()?,
                    defaultness: input.parse()?,
                    const_token: input.parse()?,
                    ident: {
                        let lookahead = input.lookahead1();
                        if lookahead.peek(Ident)
                            || lookahead.peek(crate::token::Underscore)
                        {
                            input.call(Ident::parse_any)?
                        } else {
                            return Err(lookahead.error());
                        }
                    },
                    colon_token: input.parse()?,
                    ty: input.parse()?,
                    eq_token: input.parse()?,
                    expr: input.parse()?,
                    semi_token: input.parse()?,
                })
            }
        }
        impl Parse for ImplItemMethod {
            fn parse(input: ParseStream) -> Result<Self> {
                let mut attrs = input.call(Attribute::parse_outer)?;
                let vis: Visibility = input.parse()?;
                let defaultness: Option<crate::token::Default> = input.parse()?;
                let sig: Signature = input.parse()?;
                let block = if let Some(semi) = input
                    .parse::<Option<crate::token::Semi>>()?
                {
                    let mut punct = Punct::new(';', Spacing::Alone);
                    punct.set_span(semi.span);
                    let tokens = TokenStream::from_iter(
                        <[_]>::into_vec(
                            #[rustc_box]
                            ::alloc::boxed::Box::new([TokenTree::Punct(punct)]),
                        ),
                    );
                    Block {
                        brace_token: Brace { span: semi.span },
                        stmts: <[_]>::into_vec(
                            #[rustc_box]
                            ::alloc::boxed::Box::new([
                                Stmt::Item(Item::Verbatim(tokens)),
                            ]),
                        ),
                    }
                } else {
                    let content;
                    let brace_token = match crate::group::parse_braces(&input) {
                        crate::__private::Ok(braces) => {
                            content = braces.content;
                            braces.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    };
                    attrs.extend(content.call(Attribute::parse_inner)?);
                    Block {
                        brace_token,
                        stmts: content.call(Block::parse_within)?,
                    }
                };
                Ok(ImplItemMethod {
                    attrs,
                    vis,
                    defaultness,
                    sig,
                    block,
                })
            }
        }
        impl Parse for ImplItemType {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let vis: Visibility = input.parse()?;
                let defaultness: Option<crate::token::Default> = input.parse()?;
                let type_token: crate::token::Type = input.parse()?;
                let ident: Ident = input.parse()?;
                let mut generics: Generics = input.parse()?;
                let eq_token: crate::token::Eq = input.parse()?;
                let ty: Type = input.parse()?;
                generics.where_clause = input.parse()?;
                let semi_token: crate::token::Semi = input.parse()?;
                Ok(ImplItemType {
                    attrs,
                    vis,
                    defaultness,
                    type_token,
                    ident,
                    generics,
                    eq_token,
                    ty,
                    semi_token,
                })
            }
        }
        fn parse_impl_item_type(
            begin: ParseBuffer,
            input: ParseStream,
        ) -> Result<ImplItem> {
            let FlexibleItemType {
                vis,
                defaultness,
                type_token,
                ident,
                generics,
                colon_token,
                bounds: _,
                ty,
                semi_token,
            } = FlexibleItemType::parse(input, WhereClauseLocation::Both)?;
            if colon_token.is_some() || ty.is_none() {
                Ok(ImplItem::Verbatim(verbatim::between(begin, input)))
            } else {
                let (eq_token, ty) = ty.unwrap();
                Ok(
                    ImplItem::Type(ImplItemType {
                        attrs: Vec::new(),
                        vis,
                        defaultness,
                        type_token,
                        ident,
                        generics,
                        eq_token,
                        ty,
                        semi_token,
                    }),
                )
            }
        }
        impl Parse for ImplItemMacro {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let mac: Macro = input.parse()?;
                let semi_token: Option<crate::token::Semi> = if mac.delimiter.is_brace()
                {
                    None
                } else {
                    Some(input.parse()?)
                };
                Ok(ImplItemMacro {
                    attrs,
                    mac,
                    semi_token,
                })
            }
        }
        impl Visibility {
            fn is_inherited(&self) -> bool {
                match *self {
                    Visibility::Inherited => true,
                    _ => false,
                }
            }
        }
        impl MacroDelimiter {
            fn is_brace(&self) -> bool {
                match *self {
                    MacroDelimiter::Brace(_) => true,
                    MacroDelimiter::Paren(_) | MacroDelimiter::Bracket(_) => false,
                }
            }
        }
    }
    #[cfg(feature = "printing")]
    mod printing {
        use super::*;
        use crate::attr::FilterAttrs;
        use crate::print::TokensOrDefault;
        use crate::punctuated::Pair;
        use proc_macro2::TokenStream;
        use quote::{ToTokens, TokenStreamExt};
        impl ToTokens for ItemExternCrate {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.extern_token.to_tokens(tokens);
                self.crate_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                if let Some((as_token, rename)) = &self.rename {
                    as_token.to_tokens(tokens);
                    rename.to_tokens(tokens);
                }
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for ItemUse {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.use_token.to_tokens(tokens);
                self.leading_colon.to_tokens(tokens);
                self.tree.to_tokens(tokens);
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for ItemStatic {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.static_token.to_tokens(tokens);
                self.mutability.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.colon_token.to_tokens(tokens);
                self.ty.to_tokens(tokens);
                self.eq_token.to_tokens(tokens);
                self.expr.to_tokens(tokens);
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for ItemConst {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.const_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.colon_token.to_tokens(tokens);
                self.ty.to_tokens(tokens);
                self.eq_token.to_tokens(tokens);
                self.expr.to_tokens(tokens);
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for ItemFn {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.sig.to_tokens(tokens);
                self.block
                    .brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            tokens.append_all(self.attrs.inner());
                            tokens.append_all(&self.block.stmts);
                        },
                    );
            }
        }
        impl ToTokens for ItemMod {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.mod_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                if let Some((brace, items)) = &self.content {
                    brace
                        .surround(
                            tokens,
                            |tokens| {
                                tokens.append_all(self.attrs.inner());
                                tokens.append_all(items);
                            },
                        );
                } else {
                    TokensOrDefault(&self.semi).to_tokens(tokens);
                }
            }
        }
        impl ToTokens for ItemForeignMod {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.abi.to_tokens(tokens);
                self.brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            tokens.append_all(self.attrs.inner());
                            tokens.append_all(&self.items);
                        },
                    );
            }
        }
        impl ToTokens for ItemType {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.type_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.generics.to_tokens(tokens);
                self.generics.where_clause.to_tokens(tokens);
                self.eq_token.to_tokens(tokens);
                self.ty.to_tokens(tokens);
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for ItemEnum {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.enum_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.generics.to_tokens(tokens);
                self.generics.where_clause.to_tokens(tokens);
                self.brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.variants.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for ItemStruct {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.struct_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.generics.to_tokens(tokens);
                match &self.fields {
                    Fields::Named(fields) => {
                        self.generics.where_clause.to_tokens(tokens);
                        fields.to_tokens(tokens);
                    }
                    Fields::Unnamed(fields) => {
                        fields.to_tokens(tokens);
                        self.generics.where_clause.to_tokens(tokens);
                        TokensOrDefault(&self.semi_token).to_tokens(tokens);
                    }
                    Fields::Unit => {
                        self.generics.where_clause.to_tokens(tokens);
                        TokensOrDefault(&self.semi_token).to_tokens(tokens);
                    }
                }
            }
        }
        impl ToTokens for ItemUnion {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.union_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.generics.to_tokens(tokens);
                self.generics.where_clause.to_tokens(tokens);
                self.fields.to_tokens(tokens);
            }
        }
        impl ToTokens for ItemTrait {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.unsafety.to_tokens(tokens);
                self.auto_token.to_tokens(tokens);
                self.trait_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.generics.to_tokens(tokens);
                if !self.supertraits.is_empty() {
                    TokensOrDefault(&self.colon_token).to_tokens(tokens);
                    self.supertraits.to_tokens(tokens);
                }
                self.generics.where_clause.to_tokens(tokens);
                self.brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            tokens.append_all(self.attrs.inner());
                            tokens.append_all(&self.items);
                        },
                    );
            }
        }
        impl ToTokens for ItemTraitAlias {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.trait_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.generics.to_tokens(tokens);
                self.eq_token.to_tokens(tokens);
                self.bounds.to_tokens(tokens);
                self.generics.where_clause.to_tokens(tokens);
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for ItemImpl {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.defaultness.to_tokens(tokens);
                self.unsafety.to_tokens(tokens);
                self.impl_token.to_tokens(tokens);
                self.generics.to_tokens(tokens);
                if let Some((polarity, path, for_token)) = &self.trait_ {
                    polarity.to_tokens(tokens);
                    path.to_tokens(tokens);
                    for_token.to_tokens(tokens);
                }
                self.self_ty.to_tokens(tokens);
                self.generics.where_clause.to_tokens(tokens);
                self.brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            tokens.append_all(self.attrs.inner());
                            tokens.append_all(&self.items);
                        },
                    );
            }
        }
        impl ToTokens for ItemMacro {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.mac.path.to_tokens(tokens);
                self.mac.bang_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                match &self.mac.delimiter {
                    MacroDelimiter::Paren(paren) => {
                        paren
                            .surround(
                                tokens,
                                |tokens| self.mac.tokens.to_tokens(tokens),
                            );
                    }
                    MacroDelimiter::Brace(brace) => {
                        brace
                            .surround(
                                tokens,
                                |tokens| self.mac.tokens.to_tokens(tokens),
                            );
                    }
                    MacroDelimiter::Bracket(bracket) => {
                        bracket
                            .surround(
                                tokens,
                                |tokens| self.mac.tokens.to_tokens(tokens),
                            );
                    }
                }
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for ItemMacro2 {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.macro_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.rules.to_tokens(tokens);
            }
        }
        impl ToTokens for UsePath {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.ident.to_tokens(tokens);
                self.colon2_token.to_tokens(tokens);
                self.tree.to_tokens(tokens);
            }
        }
        impl ToTokens for UseName {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.ident.to_tokens(tokens);
            }
        }
        impl ToTokens for UseRename {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.ident.to_tokens(tokens);
                self.as_token.to_tokens(tokens);
                self.rename.to_tokens(tokens);
            }
        }
        impl ToTokens for UseGlob {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.star_token.to_tokens(tokens);
            }
        }
        impl ToTokens for UseGroup {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.items.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for TraitItemConst {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.const_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.colon_token.to_tokens(tokens);
                self.ty.to_tokens(tokens);
                if let Some((eq_token, default)) = &self.default {
                    eq_token.to_tokens(tokens);
                    default.to_tokens(tokens);
                }
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for TraitItemMethod {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.sig.to_tokens(tokens);
                match &self.default {
                    Some(block) => {
                        block
                            .brace_token
                            .surround(
                                tokens,
                                |tokens| {
                                    tokens.append_all(self.attrs.inner());
                                    tokens.append_all(&block.stmts);
                                },
                            );
                    }
                    None => {
                        TokensOrDefault(&self.semi_token).to_tokens(tokens);
                    }
                }
            }
        }
        impl ToTokens for TraitItemType {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.type_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.generics.to_tokens(tokens);
                if !self.bounds.is_empty() {
                    TokensOrDefault(&self.colon_token).to_tokens(tokens);
                    self.bounds.to_tokens(tokens);
                }
                if let Some((eq_token, default)) = &self.default {
                    eq_token.to_tokens(tokens);
                    default.to_tokens(tokens);
                }
                self.generics.where_clause.to_tokens(tokens);
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for TraitItemMacro {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.mac.to_tokens(tokens);
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for ImplItemConst {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.defaultness.to_tokens(tokens);
                self.const_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.colon_token.to_tokens(tokens);
                self.ty.to_tokens(tokens);
                self.eq_token.to_tokens(tokens);
                self.expr.to_tokens(tokens);
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for ImplItemMethod {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.defaultness.to_tokens(tokens);
                self.sig.to_tokens(tokens);
                if self.block.stmts.len() == 1 {
                    if let Stmt::Item(Item::Verbatim(verbatim)) = &self.block.stmts[0] {
                        if verbatim.to_string() == ";" {
                            verbatim.to_tokens(tokens);
                            return;
                        }
                    }
                }
                self.block
                    .brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            tokens.append_all(self.attrs.inner());
                            tokens.append_all(&self.block.stmts);
                        },
                    );
            }
        }
        impl ToTokens for ImplItemType {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.defaultness.to_tokens(tokens);
                self.type_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.generics.to_tokens(tokens);
                self.eq_token.to_tokens(tokens);
                self.ty.to_tokens(tokens);
                self.generics.where_clause.to_tokens(tokens);
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for ImplItemMacro {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.mac.to_tokens(tokens);
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for ForeignItemFn {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.sig.to_tokens(tokens);
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for ForeignItemStatic {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.static_token.to_tokens(tokens);
                self.mutability.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.colon_token.to_tokens(tokens);
                self.ty.to_tokens(tokens);
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for ForeignItemType {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.vis.to_tokens(tokens);
                self.type_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.semi_token.to_tokens(tokens);
            }
        }
        impl ToTokens for ForeignItemMacro {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.mac.to_tokens(tokens);
                self.semi_token.to_tokens(tokens);
            }
        }
        fn maybe_variadic_to_tokens(arg: &FnArg, tokens: &mut TokenStream) -> bool {
            let arg = match arg {
                FnArg::Typed(arg) => arg,
                FnArg::Receiver(receiver) => {
                    receiver.to_tokens(tokens);
                    return false;
                }
            };
            match arg.ty.as_ref() {
                Type::Verbatim(ty) if ty.to_string() == "..." => {
                    match arg.pat.as_ref() {
                        Pat::Verbatim(pat) if pat.to_string() == "..." => {
                            tokens.append_all(arg.attrs.outer());
                            pat.to_tokens(tokens);
                        }
                        _ => arg.to_tokens(tokens),
                    }
                    true
                }
                _ => {
                    arg.to_tokens(tokens);
                    false
                }
            }
        }
        impl ToTokens for Signature {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.constness.to_tokens(tokens);
                self.asyncness.to_tokens(tokens);
                self.unsafety.to_tokens(tokens);
                self.abi.to_tokens(tokens);
                self.fn_token.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                self.generics.to_tokens(tokens);
                self.paren_token
                    .surround(
                        tokens,
                        |tokens| {
                            let mut last_is_variadic = false;
                            for input in self.inputs.pairs() {
                                match input {
                                    Pair::Punctuated(input, comma) => {
                                        maybe_variadic_to_tokens(input, tokens);
                                        comma.to_tokens(tokens);
                                    }
                                    Pair::End(input) => {
                                        last_is_variadic = maybe_variadic_to_tokens(input, tokens);
                                    }
                                }
                            }
                            if self.variadic.is_some() && !last_is_variadic {
                                if !self.inputs.empty_or_trailing() {
                                    <crate::token::Comma>::default().to_tokens(tokens);
                                }
                                self.variadic.to_tokens(tokens);
                            }
                        },
                    );
                self.output.to_tokens(tokens);
                self.generics.where_clause.to_tokens(tokens);
            }
        }
        impl ToTokens for Receiver {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                if let Some((ampersand, lifetime)) = &self.reference {
                    ampersand.to_tokens(tokens);
                    lifetime.to_tokens(tokens);
                }
                self.mutability.to_tokens(tokens);
                self.self_token.to_tokens(tokens);
            }
        }
    }
}
#[cfg(feature = "full")]
pub use crate::item::{
    FnArg, ForeignItem, ForeignItemFn, ForeignItemMacro, ForeignItemStatic,
    ForeignItemType, ImplItem, ImplItemConst, ImplItemMacro, ImplItemMethod,
    ImplItemType, Item, ItemConst, ItemEnum, ItemExternCrate, ItemFn, ItemForeignMod,
    ItemImpl, ItemMacro, ItemMacro2, ItemMod, ItemStatic, ItemStruct, ItemTrait,
    ItemTraitAlias, ItemType, ItemUnion, ItemUse, Receiver, Signature, TraitItem,
    TraitItemConst, TraitItemMacro, TraitItemMethod, TraitItemType, UseGlob, UseGroup,
    UseName, UsePath, UseRename, UseTree,
};
#[cfg(feature = "full")]
mod file {
    use super::*;
    pub struct File {
        pub shebang: Option<String>,
        pub attrs: Vec<Attribute>,
        pub items: Vec<Item>,
    }
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use super::*;
        use crate::parse::{Parse, ParseStream, Result};
        impl Parse for File {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(File {
                    shebang: None,
                    attrs: input.call(Attribute::parse_inner)?,
                    items: {
                        let mut items = Vec::new();
                        while !input.is_empty() {
                            items.push(input.parse()?);
                        }
                        items
                    },
                })
            }
        }
    }
    #[cfg(feature = "printing")]
    mod printing {
        use super::*;
        use crate::attr::FilterAttrs;
        use proc_macro2::TokenStream;
        use quote::{ToTokens, TokenStreamExt};
        impl ToTokens for File {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.inner());
                tokens.append_all(&self.items);
            }
        }
    }
}
#[cfg(feature = "full")]
pub use crate::file::File;
mod lifetime {
    use proc_macro2::{Ident, Span};
    use std::cmp::Ordering;
    use std::fmt::{self, Display};
    use std::hash::{Hash, Hasher};
    #[cfg(feature = "parsing")]
    use crate::lookahead;
    pub struct Lifetime {
        pub apostrophe: Span,
        pub ident: Ident,
    }
    impl Lifetime {
        pub fn new(symbol: &str, span: Span) -> Self {
            if !symbol.starts_with('\'') {
                {
                    ::std::rt::panic_fmt(
                        ::core::fmt::Arguments::new_v1(
                            &[
                                "lifetime name must start with apostrophe as in \"\'a\", got ",
                            ],
                            &[::core::fmt::ArgumentV1::new_debug(&symbol)],
                        ),
                    )
                };
            }
            if symbol == "'" {
                { ::std::rt::begin_panic("lifetime name must not be empty") };
            }
            if !crate::ident::xid_ok(&symbol[1..]) {
                {
                    ::std::rt::panic_fmt(
                        ::core::fmt::Arguments::new_v1(
                            &["", " is not a valid lifetime name"],
                            &[::core::fmt::ArgumentV1::new_debug(&symbol)],
                        ),
                    )
                };
            }
            Lifetime {
                apostrophe: span,
                ident: Ident::new(&symbol[1..], span),
            }
        }
        pub fn span(&self) -> Span {
            self.apostrophe.join(self.ident.span()).unwrap_or(self.apostrophe)
        }
        pub fn set_span(&mut self, span: Span) {
            self.apostrophe = span;
            self.ident.set_span(span);
        }
    }
    impl Display for Lifetime {
        fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
            "'".fmt(formatter)?;
            self.ident.fmt(formatter)
        }
    }
    impl Clone for Lifetime {
        fn clone(&self) -> Self {
            Lifetime {
                apostrophe: self.apostrophe,
                ident: self.ident.clone(),
            }
        }
    }
    impl PartialEq for Lifetime {
        fn eq(&self, other: &Lifetime) -> bool {
            self.ident.eq(&other.ident)
        }
    }
    impl Eq for Lifetime {}
    impl PartialOrd for Lifetime {
        fn partial_cmp(&self, other: &Lifetime) -> Option<Ordering> {
            Some(self.cmp(other))
        }
    }
    impl Ord for Lifetime {
        fn cmp(&self, other: &Lifetime) -> Ordering {
            self.ident.cmp(&other.ident)
        }
    }
    impl Hash for Lifetime {
        fn hash<H: Hasher>(&self, h: &mut H) {
            self.ident.hash(h);
        }
    }
    #[cfg(feature = "parsing")]
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Lifetime(marker: lookahead::TokenMarker) -> Lifetime {
        match marker {}
    }
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use super::*;
        use crate::parse::{Parse, ParseStream, Result};
        impl Parse for Lifetime {
            fn parse(input: ParseStream) -> Result<Self> {
                input
                    .step(|cursor| {
                        cursor
                            .lifetime()
                            .ok_or_else(|| cursor.error("expected lifetime"))
                    })
            }
        }
    }
    #[cfg(feature = "printing")]
    mod printing {
        use super::*;
        use proc_macro2::{Punct, Spacing, TokenStream};
        use quote::{ToTokens, TokenStreamExt};
        impl ToTokens for Lifetime {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                let mut apostrophe = Punct::new('\'', Spacing::Joint);
                apostrophe.set_span(self.apostrophe);
                tokens.append(apostrophe);
                self.ident.to_tokens(tokens);
            }
        }
    }
}
pub use crate::lifetime::Lifetime;
mod lit {
    #[cfg(feature = "parsing")]
    use crate::lookahead;
    #[cfg(feature = "parsing")]
    use crate::parse::{Parse, Parser};
    use crate::{Error, Result};
    use proc_macro2::{Ident, Literal, Span};
    #[cfg(feature = "parsing")]
    use proc_macro2::{TokenStream, TokenTree};
    use std::fmt::{self, Display};
    #[cfg(feature = "extra-traits")]
    use std::hash::{Hash, Hasher};
    use std::str::{self, FromStr};
    pub enum Lit {
        Str(LitStr),
        ByteStr(LitByteStr),
        Byte(LitByte),
        Char(LitChar),
        Int(LitInt),
        Float(LitFloat),
        Bool(LitBool),
        Verbatim(Literal),
    }
    impl From<LitStr> for Lit {
        fn from(e: LitStr) -> Lit {
            Lit::Str(e)
        }
    }
    impl From<LitByteStr> for Lit {
        fn from(e: LitByteStr) -> Lit {
            Lit::ByteStr(e)
        }
    }
    impl From<LitByte> for Lit {
        fn from(e: LitByte) -> Lit {
            Lit::Byte(e)
        }
    }
    impl From<LitChar> for Lit {
        fn from(e: LitChar) -> Lit {
            Lit::Char(e)
        }
    }
    impl From<LitInt> for Lit {
        fn from(e: LitInt) -> Lit {
            Lit::Int(e)
        }
    }
    impl From<LitFloat> for Lit {
        fn from(e: LitFloat) -> Lit {
            Lit::Float(e)
        }
    }
    impl From<LitBool> for Lit {
        fn from(e: LitBool) -> Lit {
            Lit::Bool(e)
        }
    }
    impl ::quote::ToTokens for Lit {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                Lit::Str(_e) => _e.to_tokens(tokens),
                Lit::ByteStr(_e) => _e.to_tokens(tokens),
                Lit::Byte(_e) => _e.to_tokens(tokens),
                Lit::Char(_e) => _e.to_tokens(tokens),
                Lit::Int(_e) => _e.to_tokens(tokens),
                Lit::Float(_e) => _e.to_tokens(tokens),
                Lit::Bool(_e) => _e.to_tokens(tokens),
                Lit::Verbatim(_e) => _e.to_tokens(tokens),
            }
        }
    }
    pub struct LitStr {
        repr: Box<LitRepr>,
    }
    pub struct LitByteStr {
        repr: Box<LitRepr>,
    }
    pub struct LitByte {
        repr: Box<LitRepr>,
    }
    pub struct LitChar {
        repr: Box<LitRepr>,
    }
    struct LitRepr {
        token: Literal,
        suffix: Box<str>,
    }
    pub struct LitInt {
        repr: Box<LitIntRepr>,
    }
    struct LitIntRepr {
        token: Literal,
        digits: Box<str>,
        suffix: Box<str>,
    }
    pub struct LitFloat {
        repr: Box<LitFloatRepr>,
    }
    struct LitFloatRepr {
        token: Literal,
        digits: Box<str>,
        suffix: Box<str>,
    }
    pub struct LitBool {
        pub value: bool,
        pub span: Span,
    }
    impl LitStr {
        pub fn new(value: &str, span: Span) -> Self {
            let mut token = Literal::string(value);
            token.set_span(span);
            LitStr {
                repr: Box::new(LitRepr {
                    token,
                    suffix: Box::<str>::default(),
                }),
            }
        }
        pub fn value(&self) -> String {
            let repr = self.repr.token.to_string();
            let (value, _suffix) = value::parse_lit_str(&repr);
            String::from(value)
        }
        #[cfg(feature = "parsing")]
        pub fn parse<T: Parse>(&self) -> Result<T> {
            self.parse_with(T::parse)
        }
        #[cfg(feature = "parsing")]
        pub fn parse_with<F: Parser>(&self, parser: F) -> Result<F::Output> {
            use proc_macro2::Group;
            fn respan_token_stream(stream: TokenStream, span: Span) -> TokenStream {
                stream.into_iter().map(|token| respan_token_tree(token, span)).collect()
            }
            fn respan_token_tree(mut token: TokenTree, span: Span) -> TokenTree {
                match &mut token {
                    TokenTree::Group(g) => {
                        let stream = respan_token_stream(g.stream(), span);
                        *g = Group::new(g.delimiter(), stream);
                        g.set_span(span);
                    }
                    other => other.set_span(span),
                }
                token
            }
            let mut tokens = crate::parse_str(&self.value())?;
            tokens = respan_token_stream(tokens, self.span());
            parser.parse2(tokens)
        }
        pub fn span(&self) -> Span {
            self.repr.token.span()
        }
        pub fn set_span(&mut self, span: Span) {
            self.repr.token.set_span(span);
        }
        pub fn suffix(&self) -> &str {
            &self.repr.suffix
        }
        pub fn token(&self) -> Literal {
            self.repr.token.clone()
        }
    }
    impl LitByteStr {
        pub fn new(value: &[u8], span: Span) -> Self {
            let mut token = Literal::byte_string(value);
            token.set_span(span);
            LitByteStr {
                repr: Box::new(LitRepr {
                    token,
                    suffix: Box::<str>::default(),
                }),
            }
        }
        pub fn value(&self) -> Vec<u8> {
            let repr = self.repr.token.to_string();
            let (value, _suffix) = value::parse_lit_byte_str(&repr);
            value
        }
        pub fn span(&self) -> Span {
            self.repr.token.span()
        }
        pub fn set_span(&mut self, span: Span) {
            self.repr.token.set_span(span);
        }
        pub fn suffix(&self) -> &str {
            &self.repr.suffix
        }
        pub fn token(&self) -> Literal {
            self.repr.token.clone()
        }
    }
    impl LitByte {
        pub fn new(value: u8, span: Span) -> Self {
            let mut token = Literal::u8_suffixed(value);
            token.set_span(span);
            LitByte {
                repr: Box::new(LitRepr {
                    token,
                    suffix: Box::<str>::default(),
                }),
            }
        }
        pub fn value(&self) -> u8 {
            let repr = self.repr.token.to_string();
            let (value, _suffix) = value::parse_lit_byte(&repr);
            value
        }
        pub fn span(&self) -> Span {
            self.repr.token.span()
        }
        pub fn set_span(&mut self, span: Span) {
            self.repr.token.set_span(span);
        }
        pub fn suffix(&self) -> &str {
            &self.repr.suffix
        }
        pub fn token(&self) -> Literal {
            self.repr.token.clone()
        }
    }
    impl LitChar {
        pub fn new(value: char, span: Span) -> Self {
            let mut token = Literal::character(value);
            token.set_span(span);
            LitChar {
                repr: Box::new(LitRepr {
                    token,
                    suffix: Box::<str>::default(),
                }),
            }
        }
        pub fn value(&self) -> char {
            let repr = self.repr.token.to_string();
            let (value, _suffix) = value::parse_lit_char(&repr);
            value
        }
        pub fn span(&self) -> Span {
            self.repr.token.span()
        }
        pub fn set_span(&mut self, span: Span) {
            self.repr.token.set_span(span);
        }
        pub fn suffix(&self) -> &str {
            &self.repr.suffix
        }
        pub fn token(&self) -> Literal {
            self.repr.token.clone()
        }
    }
    impl LitInt {
        pub fn new(repr: &str, span: Span) -> Self {
            let (digits, suffix) = match value::parse_lit_int(repr) {
                Some(parse) => parse,
                None => {
                    ::std::rt::panic_fmt(
                        ::core::fmt::Arguments::new_v1(
                            &["Not an integer literal: `", "`"],
                            &[::core::fmt::ArgumentV1::new_display(&repr)],
                        ),
                    )
                }
            };
            let mut token = match value::to_literal(repr, &digits, &suffix) {
                Some(token) => token,
                None => {
                    ::std::rt::panic_fmt(
                        ::core::fmt::Arguments::new_v1(
                            &["Unsupported integer literal: `", "`"],
                            &[::core::fmt::ArgumentV1::new_display(&repr)],
                        ),
                    )
                }
            };
            token.set_span(span);
            LitInt {
                repr: Box::new(LitIntRepr {
                    token,
                    digits,
                    suffix,
                }),
            }
        }
        pub fn base10_digits(&self) -> &str {
            &self.repr.digits
        }
        pub fn base10_parse<N>(&self) -> Result<N>
        where
            N: FromStr,
            N::Err: Display,
        {
            self.base10_digits().parse().map_err(|err| Error::new(self.span(), err))
        }
        pub fn suffix(&self) -> &str {
            &self.repr.suffix
        }
        pub fn span(&self) -> Span {
            self.repr.token.span()
        }
        pub fn set_span(&mut self, span: Span) {
            self.repr.token.set_span(span);
        }
        pub fn token(&self) -> Literal {
            self.repr.token.clone()
        }
    }
    impl From<Literal> for LitInt {
        fn from(token: Literal) -> Self {
            let repr = token.to_string();
            if let Some((digits, suffix)) = value::parse_lit_int(&repr) {
                LitInt {
                    repr: Box::new(LitIntRepr {
                        token,
                        digits,
                        suffix,
                    }),
                }
            } else {
                {
                    ::std::rt::panic_fmt(
                        ::core::fmt::Arguments::new_v1(
                            &["Not an integer literal: `", "`"],
                            &[::core::fmt::ArgumentV1::new_display(&repr)],
                        ),
                    )
                };
            }
        }
    }
    impl Display for LitInt {
        fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
            self.repr.token.fmt(formatter)
        }
    }
    impl LitFloat {
        pub fn new(repr: &str, span: Span) -> Self {
            let (digits, suffix) = match value::parse_lit_float(repr) {
                Some(parse) => parse,
                None => {
                    ::std::rt::panic_fmt(
                        ::core::fmt::Arguments::new_v1(
                            &["Not a float literal: `", "`"],
                            &[::core::fmt::ArgumentV1::new_display(&repr)],
                        ),
                    )
                }
            };
            let mut token = match value::to_literal(repr, &digits, &suffix) {
                Some(token) => token,
                None => {
                    ::std::rt::panic_fmt(
                        ::core::fmt::Arguments::new_v1(
                            &["Unsupported float literal: `", "`"],
                            &[::core::fmt::ArgumentV1::new_display(&repr)],
                        ),
                    )
                }
            };
            token.set_span(span);
            LitFloat {
                repr: Box::new(LitFloatRepr {
                    token,
                    digits,
                    suffix,
                }),
            }
        }
        pub fn base10_digits(&self) -> &str {
            &self.repr.digits
        }
        pub fn base10_parse<N>(&self) -> Result<N>
        where
            N: FromStr,
            N::Err: Display,
        {
            self.base10_digits().parse().map_err(|err| Error::new(self.span(), err))
        }
        pub fn suffix(&self) -> &str {
            &self.repr.suffix
        }
        pub fn span(&self) -> Span {
            self.repr.token.span()
        }
        pub fn set_span(&mut self, span: Span) {
            self.repr.token.set_span(span);
        }
        pub fn token(&self) -> Literal {
            self.repr.token.clone()
        }
    }
    impl From<Literal> for LitFloat {
        fn from(token: Literal) -> Self {
            let repr = token.to_string();
            if let Some((digits, suffix)) = value::parse_lit_float(&repr) {
                LitFloat {
                    repr: Box::new(LitFloatRepr {
                        token,
                        digits,
                        suffix,
                    }),
                }
            } else {
                {
                    ::std::rt::panic_fmt(
                        ::core::fmt::Arguments::new_v1(
                            &["Not a float literal: `", "`"],
                            &[::core::fmt::ArgumentV1::new_display(&repr)],
                        ),
                    )
                };
            }
        }
    }
    impl Display for LitFloat {
        fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
            self.repr.token.fmt(formatter)
        }
    }
    impl LitBool {
        pub fn new(value: bool, span: Span) -> Self {
            LitBool { value, span }
        }
        pub fn value(&self) -> bool {
            self.value
        }
        pub fn span(&self) -> Span {
            self.span
        }
        pub fn set_span(&mut self, span: Span) {
            self.span = span;
        }
        pub fn token(&self) -> Ident {
            let s = if self.value { "true" } else { "false" };
            Ident::new(s, self.span)
        }
    }
    #[cfg(feature = "extra-traits")]
    mod debug_impls {
        use super::*;
        use std::fmt::{self, Debug};
        impl Debug for LitStr {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("LitStr")
                    .field(
                        "token",
                        &::core::fmt::Arguments::new_v1(
                            &[""],
                            &[::core::fmt::ArgumentV1::new_display(&self.repr.token)],
                        ),
                    )
                    .finish()
            }
        }
        impl Debug for LitByteStr {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("LitByteStr")
                    .field(
                        "token",
                        &::core::fmt::Arguments::new_v1(
                            &[""],
                            &[::core::fmt::ArgumentV1::new_display(&self.repr.token)],
                        ),
                    )
                    .finish()
            }
        }
        impl Debug for LitByte {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("LitByte")
                    .field(
                        "token",
                        &::core::fmt::Arguments::new_v1(
                            &[""],
                            &[::core::fmt::ArgumentV1::new_display(&self.repr.token)],
                        ),
                    )
                    .finish()
            }
        }
        impl Debug for LitChar {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("LitChar")
                    .field(
                        "token",
                        &::core::fmt::Arguments::new_v1(
                            &[""],
                            &[::core::fmt::ArgumentV1::new_display(&self.repr.token)],
                        ),
                    )
                    .finish()
            }
        }
        impl Debug for LitInt {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("LitInt")
                    .field(
                        "token",
                        &::core::fmt::Arguments::new_v1(
                            &[""],
                            &[::core::fmt::ArgumentV1::new_display(&self.repr.token)],
                        ),
                    )
                    .finish()
            }
        }
        impl Debug for LitFloat {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("LitFloat")
                    .field(
                        "token",
                        &::core::fmt::Arguments::new_v1(
                            &[""],
                            &[::core::fmt::ArgumentV1::new_display(&self.repr.token)],
                        ),
                    )
                    .finish()
            }
        }
        impl Debug for LitBool {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.debug_struct("LitBool").field("value", &self.value).finish()
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Clone for LitRepr {
        fn clone(&self) -> Self {
            LitRepr {
                token: self.token.clone(),
                suffix: self.suffix.clone(),
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Clone for LitIntRepr {
        fn clone(&self) -> Self {
            LitIntRepr {
                token: self.token.clone(),
                digits: self.digits.clone(),
                suffix: self.suffix.clone(),
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Clone for LitFloatRepr {
        fn clone(&self) -> Self {
            LitFloatRepr {
                token: self.token.clone(),
                digits: self.digits.clone(),
                suffix: self.suffix.clone(),
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl Clone for LitStr {
        fn clone(&self) -> Self {
            LitStr { repr: self.repr.clone() }
        }
    }
    #[cfg(feature = "extra-traits")]
    impl PartialEq for LitStr {
        fn eq(&self, other: &Self) -> bool {
            self.repr.token.to_string() == other.repr.token.to_string()
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for LitStr {
        fn hash<H>(&self, state: &mut H)
        where
            H: Hasher,
        {
            self.repr.token.to_string().hash(state);
        }
    }
    #[cfg(feature = "parsing")]
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn LitStr(marker: lookahead::TokenMarker) -> LitStr {
        match marker {}
    }
    #[cfg(feature = "clone-impls")]
    impl Clone for LitByteStr {
        fn clone(&self) -> Self {
            LitByteStr {
                repr: self.repr.clone(),
            }
        }
    }
    #[cfg(feature = "extra-traits")]
    impl PartialEq for LitByteStr {
        fn eq(&self, other: &Self) -> bool {
            self.repr.token.to_string() == other.repr.token.to_string()
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for LitByteStr {
        fn hash<H>(&self, state: &mut H)
        where
            H: Hasher,
        {
            self.repr.token.to_string().hash(state);
        }
    }
    #[cfg(feature = "parsing")]
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn LitByteStr(marker: lookahead::TokenMarker) -> LitByteStr {
        match marker {}
    }
    #[cfg(feature = "clone-impls")]
    impl Clone for LitByte {
        fn clone(&self) -> Self {
            LitByte { repr: self.repr.clone() }
        }
    }
    #[cfg(feature = "extra-traits")]
    impl PartialEq for LitByte {
        fn eq(&self, other: &Self) -> bool {
            self.repr.token.to_string() == other.repr.token.to_string()
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for LitByte {
        fn hash<H>(&self, state: &mut H)
        where
            H: Hasher,
        {
            self.repr.token.to_string().hash(state);
        }
    }
    #[cfg(feature = "parsing")]
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn LitByte(marker: lookahead::TokenMarker) -> LitByte {
        match marker {}
    }
    #[cfg(feature = "clone-impls")]
    impl Clone for LitChar {
        fn clone(&self) -> Self {
            LitChar { repr: self.repr.clone() }
        }
    }
    #[cfg(feature = "extra-traits")]
    impl PartialEq for LitChar {
        fn eq(&self, other: &Self) -> bool {
            self.repr.token.to_string() == other.repr.token.to_string()
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for LitChar {
        fn hash<H>(&self, state: &mut H)
        where
            H: Hasher,
        {
            self.repr.token.to_string().hash(state);
        }
    }
    #[cfg(feature = "parsing")]
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn LitChar(marker: lookahead::TokenMarker) -> LitChar {
        match marker {}
    }
    #[cfg(feature = "clone-impls")]
    impl Clone for LitInt {
        fn clone(&self) -> Self {
            LitInt { repr: self.repr.clone() }
        }
    }
    #[cfg(feature = "extra-traits")]
    impl PartialEq for LitInt {
        fn eq(&self, other: &Self) -> bool {
            self.repr.token.to_string() == other.repr.token.to_string()
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for LitInt {
        fn hash<H>(&self, state: &mut H)
        where
            H: Hasher,
        {
            self.repr.token.to_string().hash(state);
        }
    }
    #[cfg(feature = "parsing")]
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn LitInt(marker: lookahead::TokenMarker) -> LitInt {
        match marker {}
    }
    #[cfg(feature = "clone-impls")]
    impl Clone for LitFloat {
        fn clone(&self) -> Self {
            LitFloat {
                repr: self.repr.clone(),
            }
        }
    }
    #[cfg(feature = "extra-traits")]
    impl PartialEq for LitFloat {
        fn eq(&self, other: &Self) -> bool {
            self.repr.token.to_string() == other.repr.token.to_string()
        }
    }
    #[cfg(feature = "extra-traits")]
    impl Hash for LitFloat {
        fn hash<H>(&self, state: &mut H)
        where
            H: Hasher,
        {
            self.repr.token.to_string().hash(state);
        }
    }
    #[cfg(feature = "parsing")]
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn LitFloat(marker: lookahead::TokenMarker) -> LitFloat {
        match marker {}
    }
    #[cfg(feature = "parsing")]
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn LitBool(marker: lookahead::TokenMarker) -> LitBool {
        match marker {}
    }
    pub enum StrStyle {
        Cooked,
        Raw(usize),
    }
    #[cfg(feature = "parsing")]
    #[doc(hidden)]
    #[allow(non_snake_case)]
    pub fn Lit(marker: lookahead::TokenMarker) -> Lit {
        match marker {}
    }
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use super::*;
        use crate::buffer::Cursor;
        use crate::parse::{Parse, ParseStream, Result};
        use proc_macro2::Punct;
        impl Parse for Lit {
            fn parse(input: ParseStream) -> Result<Self> {
                input
                    .step(|cursor| {
                        if let Some((lit, rest)) = cursor.literal() {
                            return Ok((Lit::new(lit), rest));
                        }
                        if let Some((ident, rest)) = cursor.ident() {
                            let value = ident == "true";
                            if value || ident == "false" {
                                let lit_bool = LitBool {
                                    value,
                                    span: ident.span(),
                                };
                                return Ok((Lit::Bool(lit_bool), rest));
                            }
                        }
                        if let Some((punct, rest)) = cursor.punct() {
                            if punct.as_char() == '-' {
                                if let Some((lit, rest)) = parse_negative_lit(punct, rest) {
                                    return Ok((lit, rest));
                                }
                            }
                        }
                        Err(cursor.error("expected literal"))
                    })
            }
        }
        fn parse_negative_lit(neg: Punct, cursor: Cursor) -> Option<(Lit, Cursor)> {
            let (lit, rest) = cursor.literal()?;
            let mut span = neg.span();
            span = span.join(lit.span()).unwrap_or(span);
            let mut repr = lit.to_string();
            repr.insert(0, '-');
            if let Some((digits, suffix)) = value::parse_lit_int(&repr) {
                if let Some(mut token) = value::to_literal(&repr, &digits, &suffix) {
                    token.set_span(span);
                    return Some((
                        Lit::Int(LitInt {
                            repr: Box::new(LitIntRepr {
                                token,
                                digits,
                                suffix,
                            }),
                        }),
                        rest,
                    ));
                }
            }
            let (digits, suffix) = value::parse_lit_float(&repr)?;
            let mut token = value::to_literal(&repr, &digits, &suffix)?;
            token.set_span(span);
            Some((
                Lit::Float(LitFloat {
                    repr: Box::new(LitFloatRepr {
                        token,
                        digits,
                        suffix,
                    }),
                }),
                rest,
            ))
        }
        impl Parse for LitStr {
            fn parse(input: ParseStream) -> Result<Self> {
                let head = input.fork();
                match input.parse() {
                    Ok(Lit::Str(lit)) => Ok(lit),
                    _ => Err(head.error("expected string literal")),
                }
            }
        }
        impl Parse for LitByteStr {
            fn parse(input: ParseStream) -> Result<Self> {
                let head = input.fork();
                match input.parse() {
                    Ok(Lit::ByteStr(lit)) => Ok(lit),
                    _ => Err(head.error("expected byte string literal")),
                }
            }
        }
        impl Parse for LitByte {
            fn parse(input: ParseStream) -> Result<Self> {
                let head = input.fork();
                match input.parse() {
                    Ok(Lit::Byte(lit)) => Ok(lit),
                    _ => Err(head.error("expected byte literal")),
                }
            }
        }
        impl Parse for LitChar {
            fn parse(input: ParseStream) -> Result<Self> {
                let head = input.fork();
                match input.parse() {
                    Ok(Lit::Char(lit)) => Ok(lit),
                    _ => Err(head.error("expected character literal")),
                }
            }
        }
        impl Parse for LitInt {
            fn parse(input: ParseStream) -> Result<Self> {
                let head = input.fork();
                match input.parse() {
                    Ok(Lit::Int(lit)) => Ok(lit),
                    _ => Err(head.error("expected integer literal")),
                }
            }
        }
        impl Parse for LitFloat {
            fn parse(input: ParseStream) -> Result<Self> {
                let head = input.fork();
                match input.parse() {
                    Ok(Lit::Float(lit)) => Ok(lit),
                    _ => Err(head.error("expected floating point literal")),
                }
            }
        }
        impl Parse for LitBool {
            fn parse(input: ParseStream) -> Result<Self> {
                let head = input.fork();
                match input.parse() {
                    Ok(Lit::Bool(lit)) => Ok(lit),
                    _ => Err(head.error("expected boolean literal")),
                }
            }
        }
    }
    #[cfg(feature = "printing")]
    mod printing {
        use super::*;
        use proc_macro2::TokenStream;
        use quote::{ToTokens, TokenStreamExt};
        impl ToTokens for LitStr {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.repr.token.to_tokens(tokens);
            }
        }
        impl ToTokens for LitByteStr {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.repr.token.to_tokens(tokens);
            }
        }
        impl ToTokens for LitByte {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.repr.token.to_tokens(tokens);
            }
        }
        impl ToTokens for LitChar {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.repr.token.to_tokens(tokens);
            }
        }
        impl ToTokens for LitInt {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.repr.token.to_tokens(tokens);
            }
        }
        impl ToTokens for LitFloat {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.repr.token.to_tokens(tokens);
            }
        }
        impl ToTokens for LitBool {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append(self.token());
            }
        }
    }
    mod value {
        use super::*;
        use crate::bigint::BigInt;
        use std::char;
        use std::ops::{Index, RangeFrom};
        impl Lit {
            pub fn new(token: Literal) -> Self {
                let repr = token.to_string();
                match byte(&repr, 0) {
                    b'"' | b'r' => {
                        let (_, suffix) = parse_lit_str(&repr);
                        return Lit::Str(LitStr {
                            repr: Box::new(LitRepr { token, suffix }),
                        });
                    }
                    b'b' => {
                        match byte(&repr, 1) {
                            b'"' | b'r' => {
                                let (_, suffix) = parse_lit_byte_str(&repr);
                                return Lit::ByteStr(LitByteStr {
                                    repr: Box::new(LitRepr { token, suffix }),
                                });
                            }
                            b'\'' => {
                                let (_, suffix) = parse_lit_byte(&repr);
                                return Lit::Byte(LitByte {
                                    repr: Box::new(LitRepr { token, suffix }),
                                });
                            }
                            _ => {}
                        }
                    }
                    b'\'' => {
                        let (_, suffix) = parse_lit_char(&repr);
                        return Lit::Char(LitChar {
                            repr: Box::new(LitRepr { token, suffix }),
                        });
                    }
                    b'0'..=b'9' | b'-' => {
                        if let Some((digits, suffix)) = parse_lit_int(&repr) {
                            return Lit::Int(LitInt {
                                repr: Box::new(LitIntRepr {
                                    token,
                                    digits,
                                    suffix,
                                }),
                            });
                        }
                        if let Some((digits, suffix)) = parse_lit_float(&repr) {
                            return Lit::Float(LitFloat {
                                repr: Box::new(LitFloatRepr {
                                    token,
                                    digits,
                                    suffix,
                                }),
                            });
                        }
                    }
                    b't' | b'f' => {
                        if repr == "true" || repr == "false" {
                            return Lit::Bool(LitBool {
                                value: repr == "true",
                                span: token.span(),
                            });
                        }
                    }
                    _ => {}
                }
                {
                    ::std::rt::panic_fmt(
                        ::core::fmt::Arguments::new_v1(
                            &["Unrecognized literal: `", "`"],
                            &[::core::fmt::ArgumentV1::new_display(&repr)],
                        ),
                    )
                };
            }
            pub fn suffix(&self) -> &str {
                match self {
                    Lit::Str(lit) => lit.suffix(),
                    Lit::ByteStr(lit) => lit.suffix(),
                    Lit::Byte(lit) => lit.suffix(),
                    Lit::Char(lit) => lit.suffix(),
                    Lit::Int(lit) => lit.suffix(),
                    Lit::Float(lit) => lit.suffix(),
                    Lit::Bool(_) | Lit::Verbatim(_) => "",
                }
            }
            pub fn span(&self) -> Span {
                match self {
                    Lit::Str(lit) => lit.span(),
                    Lit::ByteStr(lit) => lit.span(),
                    Lit::Byte(lit) => lit.span(),
                    Lit::Char(lit) => lit.span(),
                    Lit::Int(lit) => lit.span(),
                    Lit::Float(lit) => lit.span(),
                    Lit::Bool(lit) => lit.span,
                    Lit::Verbatim(lit) => lit.span(),
                }
            }
            pub fn set_span(&mut self, span: Span) {
                match self {
                    Lit::Str(lit) => lit.set_span(span),
                    Lit::ByteStr(lit) => lit.set_span(span),
                    Lit::Byte(lit) => lit.set_span(span),
                    Lit::Char(lit) => lit.set_span(span),
                    Lit::Int(lit) => lit.set_span(span),
                    Lit::Float(lit) => lit.set_span(span),
                    Lit::Bool(lit) => lit.span = span,
                    Lit::Verbatim(lit) => lit.set_span(span),
                }
            }
        }
        pub fn byte<S: AsRef<[u8]> + ?Sized>(s: &S, idx: usize) -> u8 {
            let s = s.as_ref();
            if idx < s.len() { s[idx] } else { 0 }
        }
        fn next_chr(s: &str) -> char {
            s.chars().next().unwrap_or('\0')
        }
        pub fn parse_lit_str(s: &str) -> (Box<str>, Box<str>) {
            match byte(s, 0) {
                b'"' => parse_lit_str_cooked(s),
                b'r' => parse_lit_str_raw(s),
                _ => ::core::panicking::panic("internal error: entered unreachable code"),
            }
        }
        #[allow(clippy::needless_continue)]
        fn parse_lit_str_cooked(mut s: &str) -> (Box<str>, Box<str>) {
            match (&byte(s, 0), &b'"') {
                (left_val, right_val) => {
                    if !(*left_val == *right_val) {
                        let kind = ::core::panicking::AssertKind::Eq;
                        ::core::panicking::assert_failed(
                            kind,
                            &*left_val,
                            &*right_val,
                            ::core::option::Option::None,
                        );
                    }
                }
            };
            s = &s[1..];
            let mut content = String::new();
            'outer: loop {
                let ch = match byte(s, 0) {
                    b'"' => break,
                    b'\\' => {
                        let b = byte(s, 1);
                        s = &s[2..];
                        match b {
                            b'x' => {
                                let (byte, rest) = backslash_x(s);
                                s = rest;
                                if !(byte <= 0x80) {
                                    {
                                        ::std::rt::begin_panic("Invalid \\x byte in string literal")
                                    }
                                }
                                char::from_u32(u32::from(byte)).unwrap()
                            }
                            b'u' => {
                                let (chr, rest) = backslash_u(s);
                                s = rest;
                                chr
                            }
                            b'n' => '\n',
                            b'r' => '\r',
                            b't' => '\t',
                            b'\\' => '\\',
                            b'0' => '\0',
                            b'\'' => '\'',
                            b'"' => '"',
                            b'\r' | b'\n' => {
                                loop {
                                    let ch = next_chr(s);
                                    if ch.is_whitespace() {
                                        s = &s[ch.len_utf8()..];
                                    } else {
                                        continue 'outer;
                                    }
                                }
                            }
                            b => {
                                ::std::rt::panic_fmt(
                                    ::core::fmt::Arguments::new_v1(
                                        &[
                                            "unexpected byte ",
                                            " after \\ character in byte literal",
                                        ],
                                        &[::core::fmt::ArgumentV1::new_debug(&b)],
                                    ),
                                )
                            }
                        }
                    }
                    b'\r' => {
                        match (&byte(s, 1), &b'\n') {
                            (left_val, right_val) => {
                                if !(*left_val == *right_val) {
                                    let kind = ::core::panicking::AssertKind::Eq;
                                    ::core::panicking::assert_failed(
                                        kind,
                                        &*left_val,
                                        &*right_val,
                                        ::core::option::Option::Some(
                                            ::core::fmt::Arguments::new_v1(
                                                &["Bare CR not allowed in string"],
                                                &[],
                                            ),
                                        ),
                                    );
                                }
                            }
                        };
                        s = &s[2..];
                        '\n'
                    }
                    _ => {
                        let ch = next_chr(s);
                        s = &s[ch.len_utf8()..];
                        ch
                    }
                };
                content.push(ch);
            }
            if !s.starts_with('"') {
                ::core::panicking::panic("assertion failed: s.starts_with(\\\'\\\"\\\')")
            }
            let content = content.into_boxed_str();
            let suffix = s[1..].to_owned().into_boxed_str();
            (content, suffix)
        }
        fn parse_lit_str_raw(mut s: &str) -> (Box<str>, Box<str>) {
            match (&byte(s, 0), &b'r') {
                (left_val, right_val) => {
                    if !(*left_val == *right_val) {
                        let kind = ::core::panicking::AssertKind::Eq;
                        ::core::panicking::assert_failed(
                            kind,
                            &*left_val,
                            &*right_val,
                            ::core::option::Option::None,
                        );
                    }
                }
            };
            s = &s[1..];
            let mut pounds = 0;
            while byte(s, pounds) == b'#' {
                pounds += 1;
            }
            match (&byte(s, pounds), &b'"') {
                (left_val, right_val) => {
                    if !(*left_val == *right_val) {
                        let kind = ::core::panicking::AssertKind::Eq;
                        ::core::panicking::assert_failed(
                            kind,
                            &*left_val,
                            &*right_val,
                            ::core::option::Option::None,
                        );
                    }
                }
            };
            let close = s.rfind('"').unwrap();
            for end in s[close + 1..close + 1 + pounds].bytes() {
                match (&end, &b'#') {
                    (left_val, right_val) => {
                        if !(*left_val == *right_val) {
                            let kind = ::core::panicking::AssertKind::Eq;
                            ::core::panicking::assert_failed(
                                kind,
                                &*left_val,
                                &*right_val,
                                ::core::option::Option::None,
                            );
                        }
                    }
                };
            }
            let content = s[pounds + 1..close].to_owned().into_boxed_str();
            let suffix = s[close + 1 + pounds..].to_owned().into_boxed_str();
            (content, suffix)
        }
        pub fn parse_lit_byte_str(s: &str) -> (Vec<u8>, Box<str>) {
            match (&byte(s, 0), &b'b') {
                (left_val, right_val) => {
                    if !(*left_val == *right_val) {
                        let kind = ::core::panicking::AssertKind::Eq;
                        ::core::panicking::assert_failed(
                            kind,
                            &*left_val,
                            &*right_val,
                            ::core::option::Option::None,
                        );
                    }
                }
            };
            match byte(s, 1) {
                b'"' => parse_lit_byte_str_cooked(s),
                b'r' => parse_lit_byte_str_raw(s),
                _ => ::core::panicking::panic("internal error: entered unreachable code"),
            }
        }
        #[allow(clippy::needless_continue)]
        fn parse_lit_byte_str_cooked(mut s: &str) -> (Vec<u8>, Box<str>) {
            match (&byte(s, 0), &b'b') {
                (left_val, right_val) => {
                    if !(*left_val == *right_val) {
                        let kind = ::core::panicking::AssertKind::Eq;
                        ::core::panicking::assert_failed(
                            kind,
                            &*left_val,
                            &*right_val,
                            ::core::option::Option::None,
                        );
                    }
                }
            };
            match (&byte(s, 1), &b'"') {
                (left_val, right_val) => {
                    if !(*left_val == *right_val) {
                        let kind = ::core::panicking::AssertKind::Eq;
                        ::core::panicking::assert_failed(
                            kind,
                            &*left_val,
                            &*right_val,
                            ::core::option::Option::None,
                        );
                    }
                }
            };
            s = &s[2..];
            let mut v = s.as_bytes();
            let mut out = Vec::new();
            'outer: loop {
                let byte = match byte(v, 0) {
                    b'"' => break,
                    b'\\' => {
                        let b = byte(v, 1);
                        v = &v[2..];
                        match b {
                            b'x' => {
                                let (b, rest) = backslash_x(v);
                                v = rest;
                                b
                            }
                            b'n' => b'\n',
                            b'r' => b'\r',
                            b't' => b'\t',
                            b'\\' => b'\\',
                            b'0' => b'\0',
                            b'\'' => b'\'',
                            b'"' => b'"',
                            b'\r' | b'\n' => {
                                loop {
                                    let byte = byte(v, 0);
                                    let ch = char::from_u32(u32::from(byte)).unwrap();
                                    if ch.is_whitespace() {
                                        v = &v[1..];
                                    } else {
                                        continue 'outer;
                                    }
                                }
                            }
                            b => {
                                ::std::rt::panic_fmt(
                                    ::core::fmt::Arguments::new_v1(
                                        &[
                                            "unexpected byte ",
                                            " after \\ character in byte literal",
                                        ],
                                        &[::core::fmt::ArgumentV1::new_debug(&b)],
                                    ),
                                )
                            }
                        }
                    }
                    b'\r' => {
                        match (&byte(v, 1), &b'\n') {
                            (left_val, right_val) => {
                                if !(*left_val == *right_val) {
                                    let kind = ::core::panicking::AssertKind::Eq;
                                    ::core::panicking::assert_failed(
                                        kind,
                                        &*left_val,
                                        &*right_val,
                                        ::core::option::Option::Some(
                                            ::core::fmt::Arguments::new_v1(
                                                &["Bare CR not allowed in string"],
                                                &[],
                                            ),
                                        ),
                                    );
                                }
                            }
                        };
                        v = &v[2..];
                        b'\n'
                    }
                    b => {
                        v = &v[1..];
                        b
                    }
                };
                out.push(byte);
            }
            match (&byte(v, 0), &b'"') {
                (left_val, right_val) => {
                    if !(*left_val == *right_val) {
                        let kind = ::core::panicking::AssertKind::Eq;
                        ::core::panicking::assert_failed(
                            kind,
                            &*left_val,
                            &*right_val,
                            ::core::option::Option::None,
                        );
                    }
                }
            };
            let suffix = s[s.len() - v.len() + 1..].to_owned().into_boxed_str();
            (out, suffix)
        }
        fn parse_lit_byte_str_raw(s: &str) -> (Vec<u8>, Box<str>) {
            match (&byte(s, 0), &b'b') {
                (left_val, right_val) => {
                    if !(*left_val == *right_val) {
                        let kind = ::core::panicking::AssertKind::Eq;
                        ::core::panicking::assert_failed(
                            kind,
                            &*left_val,
                            &*right_val,
                            ::core::option::Option::None,
                        );
                    }
                }
            };
            let (value, suffix) = parse_lit_str_raw(&s[1..]);
            (String::from(value).into_bytes(), suffix)
        }
        pub fn parse_lit_byte(s: &str) -> (u8, Box<str>) {
            match (&byte(s, 0), &b'b') {
                (left_val, right_val) => {
                    if !(*left_val == *right_val) {
                        let kind = ::core::panicking::AssertKind::Eq;
                        ::core::panicking::assert_failed(
                            kind,
                            &*left_val,
                            &*right_val,
                            ::core::option::Option::None,
                        );
                    }
                }
            };
            match (&byte(s, 1), &b'\'') {
                (left_val, right_val) => {
                    if !(*left_val == *right_val) {
                        let kind = ::core::panicking::AssertKind::Eq;
                        ::core::panicking::assert_failed(
                            kind,
                            &*left_val,
                            &*right_val,
                            ::core::option::Option::None,
                        );
                    }
                }
            };
            let mut v = s[2..].as_bytes();
            let b = match byte(v, 0) {
                b'\\' => {
                    let b = byte(v, 1);
                    v = &v[2..];
                    match b {
                        b'x' => {
                            let (b, rest) = backslash_x(v);
                            v = rest;
                            b
                        }
                        b'n' => b'\n',
                        b'r' => b'\r',
                        b't' => b'\t',
                        b'\\' => b'\\',
                        b'0' => b'\0',
                        b'\'' => b'\'',
                        b'"' => b'"',
                        b => {
                            ::std::rt::panic_fmt(
                                ::core::fmt::Arguments::new_v1(
                                    &[
                                        "unexpected byte ",
                                        " after \\ character in byte literal",
                                    ],
                                    &[::core::fmt::ArgumentV1::new_debug(&b)],
                                ),
                            )
                        }
                    }
                }
                b => {
                    v = &v[1..];
                    b
                }
            };
            match (&byte(v, 0), &b'\'') {
                (left_val, right_val) => {
                    if !(*left_val == *right_val) {
                        let kind = ::core::panicking::AssertKind::Eq;
                        ::core::panicking::assert_failed(
                            kind,
                            &*left_val,
                            &*right_val,
                            ::core::option::Option::None,
                        );
                    }
                }
            };
            let suffix = s[s.len() - v.len() + 1..].to_owned().into_boxed_str();
            (b, suffix)
        }
        pub fn parse_lit_char(mut s: &str) -> (char, Box<str>) {
            match (&byte(s, 0), &b'\'') {
                (left_val, right_val) => {
                    if !(*left_val == *right_val) {
                        let kind = ::core::panicking::AssertKind::Eq;
                        ::core::panicking::assert_failed(
                            kind,
                            &*left_val,
                            &*right_val,
                            ::core::option::Option::None,
                        );
                    }
                }
            };
            s = &s[1..];
            let ch = match byte(s, 0) {
                b'\\' => {
                    let b = byte(s, 1);
                    s = &s[2..];
                    match b {
                        b'x' => {
                            let (byte, rest) = backslash_x(s);
                            s = rest;
                            if !(byte <= 0x80) {
                                {
                                    ::std::rt::begin_panic("Invalid \\x byte in string literal")
                                }
                            }
                            char::from_u32(u32::from(byte)).unwrap()
                        }
                        b'u' => {
                            let (chr, rest) = backslash_u(s);
                            s = rest;
                            chr
                        }
                        b'n' => '\n',
                        b'r' => '\r',
                        b't' => '\t',
                        b'\\' => '\\',
                        b'0' => '\0',
                        b'\'' => '\'',
                        b'"' => '"',
                        b => {
                            ::std::rt::panic_fmt(
                                ::core::fmt::Arguments::new_v1(
                                    &[
                                        "unexpected byte ",
                                        " after \\ character in byte literal",
                                    ],
                                    &[::core::fmt::ArgumentV1::new_debug(&b)],
                                ),
                            )
                        }
                    }
                }
                _ => {
                    let ch = next_chr(s);
                    s = &s[ch.len_utf8()..];
                    ch
                }
            };
            match (&byte(s, 0), &b'\'') {
                (left_val, right_val) => {
                    if !(*left_val == *right_val) {
                        let kind = ::core::panicking::AssertKind::Eq;
                        ::core::panicking::assert_failed(
                            kind,
                            &*left_val,
                            &*right_val,
                            ::core::option::Option::None,
                        );
                    }
                }
            };
            let suffix = s[1..].to_owned().into_boxed_str();
            (ch, suffix)
        }
        fn backslash_x<S>(s: &S) -> (u8, &S)
        where
            S: Index<RangeFrom<usize>, Output = S> + AsRef<[u8]> + ?Sized,
        {
            let mut ch = 0;
            let b0 = byte(s, 0);
            let b1 = byte(s, 1);
            ch
                += 0x10
                    * match b0 {
                        b'0'..=b'9' => b0 - b'0',
                        b'a'..=b'f' => 10 + (b0 - b'a'),
                        b'A'..=b'F' => 10 + (b0 - b'A'),
                        _ => {
                            ::std::rt::begin_panic(
                                "unexpected non-hex character after \\x",
                            )
                        }
                    };
            ch
                += match b1 {
                    b'0'..=b'9' => b1 - b'0',
                    b'a'..=b'f' => 10 + (b1 - b'a'),
                    b'A'..=b'F' => 10 + (b1 - b'A'),
                    _ => ::std::rt::begin_panic("unexpected non-hex character after \\x"),
                };
            (ch, &s[2..])
        }
        fn backslash_u(mut s: &str) -> (char, &str) {
            if byte(s, 0) != b'{' {
                { ::std::rt::panic_display(&"expected { after \\u") };
            }
            s = &s[1..];
            let mut ch = 0;
            let mut digits = 0;
            loop {
                let b = byte(s, 0);
                let digit = match b {
                    b'0'..=b'9' => b - b'0',
                    b'a'..=b'f' => 10 + b - b'a',
                    b'A'..=b'F' => 10 + b - b'A',
                    b'_' if digits > 0 => {
                        s = &s[1..];
                        continue;
                    }
                    b'}' if digits == 0 => {
                        ::std::rt::begin_panic("invalid empty unicode escape")
                    }
                    b'}' => break,
                    _ => ::std::rt::begin_panic("unexpected non-hex character after \\u"),
                };
                if digits == 6 {
                    {
                        ::std::rt::begin_panic(
                            "overlong unicode escape (must have at most 6 hex digits)",
                        )
                    };
                }
                ch *= 0x10;
                ch += u32::from(digit);
                digits += 1;
                s = &s[1..];
            }
            if !(byte(s, 0) == b'}') {
                ::core::panicking::panic("assertion failed: byte(s, 0) == b\\\'}\\\'")
            }
            s = &s[1..];
            if let Some(ch) = char::from_u32(ch) {
                (ch, s)
            } else {
                {
                    ::std::rt::panic_fmt(
                        ::core::fmt::Arguments::new_v1(
                            &["character code ", " is not a valid unicode character"],
                            &[::core::fmt::ArgumentV1::new_lower_hex(&ch)],
                        ),
                    )
                };
            }
        }
        pub fn parse_lit_int(mut s: &str) -> Option<(Box<str>, Box<str>)> {
            let negative = byte(s, 0) == b'-';
            if negative {
                s = &s[1..];
            }
            let base = match (byte(s, 0), byte(s, 1)) {
                (b'0', b'x') => {
                    s = &s[2..];
                    16
                }
                (b'0', b'o') => {
                    s = &s[2..];
                    8
                }
                (b'0', b'b') => {
                    s = &s[2..];
                    2
                }
                (b'0'..=b'9', _) => 10,
                _ => return None,
            };
            let mut value = BigInt::new();
            'outer: loop {
                let b = byte(s, 0);
                let digit = match b {
                    b'0'..=b'9' => b - b'0',
                    b'a'..=b'f' if base > 10 => b - b'a' + 10,
                    b'A'..=b'F' if base > 10 => b - b'A' + 10,
                    b'_' => {
                        s = &s[1..];
                        continue;
                    }
                    b'.' if base == 10 => return None,
                    b'e' | b'E' if base == 10 => {
                        let mut has_exp = false;
                        for (i, b) in s[1..].bytes().enumerate() {
                            match b {
                                b'_' => {}
                                b'-' | b'+' => return None,
                                b'0'..=b'9' => has_exp = true,
                                _ => {
                                    let suffix = &s[1 + i..];
                                    if has_exp && crate::ident::xid_ok(suffix) {
                                        return None;
                                    } else {
                                        break 'outer;
                                    }
                                }
                            }
                        }
                        if has_exp {
                            return None;
                        } else {
                            break;
                        }
                    }
                    _ => break,
                };
                if digit >= base {
                    return None;
                }
                value *= base;
                value += digit;
                s = &s[1..];
            }
            let suffix = s;
            if suffix.is_empty() || crate::ident::xid_ok(suffix) {
                let mut repr = value.to_string();
                if negative {
                    repr.insert(0, '-');
                }
                Some((repr.into_boxed_str(), suffix.to_owned().into_boxed_str()))
            } else {
                None
            }
        }
        pub fn parse_lit_float(input: &str) -> Option<(Box<str>, Box<str>)> {
            let mut bytes = input.to_owned().into_bytes();
            let start = (*bytes.first()? == b'-') as usize;
            match bytes.get(start)? {
                b'0'..=b'9' => {}
                _ => return None,
            }
            let mut read = start;
            let mut write = start;
            let mut has_dot = false;
            let mut has_e = false;
            let mut has_sign = false;
            let mut has_exponent = false;
            while read < bytes.len() {
                match bytes[read] {
                    b'_' => {
                        read += 1;
                        continue;
                    }
                    b'0'..=b'9' => {
                        if has_e {
                            has_exponent = true;
                        }
                        bytes[write] = bytes[read];
                    }
                    b'.' => {
                        if has_e || has_dot {
                            return None;
                        }
                        has_dot = true;
                        bytes[write] = b'.';
                    }
                    b'e' | b'E' => {
                        match bytes[read + 1..]
                            .iter()
                            .find(|b| **b != b'_')
                            .unwrap_or(&b'\0')
                        {
                            b'-' | b'+' | b'0'..=b'9' => {}
                            _ => break,
                        }
                        if has_e {
                            if has_exponent {
                                break;
                            } else {
                                return None;
                            }
                        }
                        has_e = true;
                        bytes[write] = b'e';
                    }
                    b'-' | b'+' => {
                        if has_sign || has_exponent || !has_e {
                            return None;
                        }
                        has_sign = true;
                        if bytes[read] == b'-' {
                            bytes[write] = bytes[read];
                        } else {
                            read += 1;
                            continue;
                        }
                    }
                    _ => break,
                }
                read += 1;
                write += 1;
            }
            if has_e && !has_exponent {
                return None;
            }
            let mut digits = String::from_utf8(bytes).unwrap();
            let suffix = digits.split_off(read);
            digits.truncate(write);
            if suffix.is_empty() || crate::ident::xid_ok(&suffix) {
                Some((digits.into_boxed_str(), suffix.into_boxed_str()))
            } else {
                None
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        pub fn to_literal(repr: &str, digits: &str, suffix: &str) -> Option<Literal> {
            let _ = digits;
            let _ = suffix;
            Some(repr.parse::<Literal>().unwrap())
        }
    }
}
pub use crate::lit::{
    Lit, LitBool, LitByte, LitByteStr, LitChar, LitFloat, LitInt, LitStr, StrStyle,
};
#[cfg(any(feature = "full", feature = "derive"))]
mod mac {
    use super::*;
    use crate::token::{Brace, Bracket, Paren};
    use proc_macro2::TokenStream;
    #[cfg(feature = "parsing")]
    use proc_macro2::{Delimiter, Group, Span, TokenTree};
    #[cfg(feature = "parsing")]
    use crate::parse::{Parse, ParseStream, Parser, Result};
    pub struct Macro {
        pub path: Path,
        pub bang_token: crate::token::Bang,
        pub delimiter: MacroDelimiter,
        pub tokens: TokenStream,
    }
    pub enum MacroDelimiter {
        Paren(Paren),
        Brace(Brace),
        Bracket(Bracket),
    }
    #[cfg(feature = "parsing")]
    fn delimiter_span_close(macro_delimiter: &MacroDelimiter) -> Span {
        let delimiter = match macro_delimiter {
            MacroDelimiter::Paren(_) => Delimiter::Parenthesis,
            MacroDelimiter::Brace(_) => Delimiter::Brace,
            MacroDelimiter::Bracket(_) => Delimiter::Bracket,
        };
        let mut group = Group::new(delimiter, TokenStream::new());
        group
            .set_span(
                match macro_delimiter {
                    MacroDelimiter::Paren(token) => token.span,
                    MacroDelimiter::Brace(token) => token.span,
                    MacroDelimiter::Bracket(token) => token.span,
                },
            );
        group.span_close()
    }
    impl Macro {
        #[cfg(feature = "parsing")]
        pub fn parse_body<T: Parse>(&self) -> Result<T> {
            self.parse_body_with(T::parse)
        }
        #[cfg(feature = "parsing")]
        pub fn parse_body_with<F: Parser>(&self, parser: F) -> Result<F::Output> {
            let scope = delimiter_span_close(&self.delimiter);
            crate::parse::parse_scoped(parser, scope, self.tokens.clone())
        }
    }
    #[cfg(feature = "parsing")]
    pub fn parse_delimiter(input: ParseStream) -> Result<(MacroDelimiter, TokenStream)> {
        input
            .step(|cursor| {
                if let Some((TokenTree::Group(g), rest)) = cursor.token_tree() {
                    let span = g.span();
                    let delimiter = match g.delimiter() {
                        Delimiter::Parenthesis => MacroDelimiter::Paren(Paren(span)),
                        Delimiter::Brace => MacroDelimiter::Brace(Brace(span)),
                        Delimiter::Bracket => MacroDelimiter::Bracket(Bracket(span)),
                        Delimiter::None => {
                            return Err(cursor.error("expected delimiter"));
                        }
                    };
                    Ok(((delimiter, g.stream()), rest))
                } else {
                    Err(cursor.error("expected delimiter"))
                }
            })
    }
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use super::*;
        use crate::parse::{Parse, ParseStream, Result};
        impl Parse for Macro {
            fn parse(input: ParseStream) -> Result<Self> {
                let tokens;
                Ok(Macro {
                    path: input.call(Path::parse_mod_style)?,
                    bang_token: input.parse()?,
                    delimiter: {
                        let (delimiter, content) = parse_delimiter(input)?;
                        tokens = content;
                        delimiter
                    },
                    tokens,
                })
            }
        }
    }
    #[cfg(feature = "printing")]
    mod printing {
        use super::*;
        use proc_macro2::TokenStream;
        use quote::ToTokens;
        impl ToTokens for Macro {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.path.to_tokens(tokens);
                self.bang_token.to_tokens(tokens);
                match &self.delimiter {
                    MacroDelimiter::Paren(paren) => {
                        paren.surround(tokens, |tokens| self.tokens.to_tokens(tokens));
                    }
                    MacroDelimiter::Brace(brace) => {
                        brace.surround(tokens, |tokens| self.tokens.to_tokens(tokens));
                    }
                    MacroDelimiter::Bracket(bracket) => {
                        bracket.surround(tokens, |tokens| self.tokens.to_tokens(tokens));
                    }
                }
            }
        }
    }
}
#[cfg(any(feature = "full", feature = "derive"))]
pub use crate::mac::{Macro, MacroDelimiter};
#[cfg(any(feature = "full", feature = "derive"))]
mod derive {
    use super::*;
    use crate::punctuated::Punctuated;
    pub struct DeriveInput {
        pub attrs: Vec<Attribute>,
        pub vis: Visibility,
        pub ident: Ident,
        pub generics: Generics,
        pub data: Data,
    }
    pub enum Data {
        Struct(DataStruct),
        Enum(DataEnum),
        Union(DataUnion),
    }
    impl From<DataStruct> for Data {
        fn from(e: DataStruct) -> Data {
            Data::Struct(e)
        }
    }
    impl From<DataEnum> for Data {
        fn from(e: DataEnum) -> Data {
            Data::Enum(e)
        }
    }
    impl From<DataUnion> for Data {
        fn from(e: DataUnion) -> Data {
            Data::Union(e)
        }
    }
    pub struct DataStruct {
        pub struct_token: crate::token::Struct,
        pub fields: Fields,
        pub semi_token: Option<crate::token::Semi>,
    }
    pub struct DataEnum {
        pub enum_token: crate::token::Enum,
        pub brace_token: token::Brace,
        pub variants: Punctuated<Variant, crate::token::Comma>,
    }
    pub struct DataUnion {
        pub union_token: crate::token::Union,
        pub fields: FieldsNamed,
    }
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use super::*;
        use crate::parse::{Parse, ParseStream, Result};
        impl Parse for DeriveInput {
            fn parse(input: ParseStream) -> Result<Self> {
                let attrs = input.call(Attribute::parse_outer)?;
                let vis = input.parse::<Visibility>()?;
                let lookahead = input.lookahead1();
                if lookahead.peek(crate::token::Struct) {
                    let struct_token = input.parse::<crate::token::Struct>()?;
                    let ident = input.parse::<Ident>()?;
                    let generics = input.parse::<Generics>()?;
                    let (where_clause, fields, semi) = data_struct(input)?;
                    Ok(DeriveInput {
                        attrs,
                        vis,
                        ident,
                        generics: Generics {
                            where_clause,
                            ..generics
                        },
                        data: Data::Struct(DataStruct {
                            struct_token,
                            fields,
                            semi_token: semi,
                        }),
                    })
                } else if lookahead.peek(crate::token::Enum) {
                    let enum_token = input.parse::<crate::token::Enum>()?;
                    let ident = input.parse::<Ident>()?;
                    let generics = input.parse::<Generics>()?;
                    let (where_clause, brace, variants) = data_enum(input)?;
                    Ok(DeriveInput {
                        attrs,
                        vis,
                        ident,
                        generics: Generics {
                            where_clause,
                            ..generics
                        },
                        data: Data::Enum(DataEnum {
                            enum_token,
                            brace_token: brace,
                            variants,
                        }),
                    })
                } else if lookahead.peek(crate::token::Union) {
                    let union_token = input.parse::<crate::token::Union>()?;
                    let ident = input.parse::<Ident>()?;
                    let generics = input.parse::<Generics>()?;
                    let (where_clause, fields) = data_union(input)?;
                    Ok(DeriveInput {
                        attrs,
                        vis,
                        ident,
                        generics: Generics {
                            where_clause,
                            ..generics
                        },
                        data: Data::Union(DataUnion { union_token, fields }),
                    })
                } else {
                    Err(lookahead.error())
                }
            }
        }
        pub fn data_struct(
            input: ParseStream,
        ) -> Result<(Option<WhereClause>, Fields, Option<crate::token::Semi>)> {
            let mut lookahead = input.lookahead1();
            let mut where_clause = None;
            if lookahead.peek(crate::token::Where) {
                where_clause = Some(input.parse()?);
                lookahead = input.lookahead1();
            }
            if where_clause.is_none() && lookahead.peek(token::Paren) {
                let fields = input.parse()?;
                lookahead = input.lookahead1();
                if lookahead.peek(crate::token::Where) {
                    where_clause = Some(input.parse()?);
                    lookahead = input.lookahead1();
                }
                if lookahead.peek(crate::token::Semi) {
                    let semi = input.parse()?;
                    Ok((where_clause, Fields::Unnamed(fields), Some(semi)))
                } else {
                    Err(lookahead.error())
                }
            } else if lookahead.peek(token::Brace) {
                let fields = input.parse()?;
                Ok((where_clause, Fields::Named(fields), None))
            } else if lookahead.peek(crate::token::Semi) {
                let semi = input.parse()?;
                Ok((where_clause, Fields::Unit, Some(semi)))
            } else {
                Err(lookahead.error())
            }
        }
        pub fn data_enum(
            input: ParseStream,
        ) -> Result<
            (Option<WhereClause>, token::Brace, Punctuated<Variant, crate::token::Comma>),
        > {
            let where_clause = input.parse()?;
            let content;
            let brace = match crate::group::parse_braces(&input) {
                crate::__private::Ok(braces) => {
                    content = braces.content;
                    braces.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
            let variants = content.parse_terminated(Variant::parse)?;
            Ok((where_clause, brace, variants))
        }
        pub fn data_union(
            input: ParseStream,
        ) -> Result<(Option<WhereClause>, FieldsNamed)> {
            let where_clause = input.parse()?;
            let fields = input.parse()?;
            Ok((where_clause, fields))
        }
    }
    #[cfg(feature = "printing")]
    mod printing {
        use super::*;
        use crate::attr::FilterAttrs;
        use crate::print::TokensOrDefault;
        use proc_macro2::TokenStream;
        use quote::ToTokens;
        impl ToTokens for DeriveInput {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                for attr in self.attrs.outer() {
                    attr.to_tokens(tokens);
                }
                self.vis.to_tokens(tokens);
                match &self.data {
                    Data::Struct(d) => d.struct_token.to_tokens(tokens),
                    Data::Enum(d) => d.enum_token.to_tokens(tokens),
                    Data::Union(d) => d.union_token.to_tokens(tokens),
                }
                self.ident.to_tokens(tokens);
                self.generics.to_tokens(tokens);
                match &self.data {
                    Data::Struct(data) => {
                        match &data.fields {
                            Fields::Named(fields) => {
                                self.generics.where_clause.to_tokens(tokens);
                                fields.to_tokens(tokens);
                            }
                            Fields::Unnamed(fields) => {
                                fields.to_tokens(tokens);
                                self.generics.where_clause.to_tokens(tokens);
                                TokensOrDefault(&data.semi_token).to_tokens(tokens);
                            }
                            Fields::Unit => {
                                self.generics.where_clause.to_tokens(tokens);
                                TokensOrDefault(&data.semi_token).to_tokens(tokens);
                            }
                        }
                    }
                    Data::Enum(data) => {
                        self.generics.where_clause.to_tokens(tokens);
                        data.brace_token
                            .surround(
                                tokens,
                                |tokens| {
                                    data.variants.to_tokens(tokens);
                                },
                            );
                    }
                    Data::Union(data) => {
                        self.generics.where_clause.to_tokens(tokens);
                        data.fields.to_tokens(tokens);
                    }
                }
            }
        }
    }
}
#[cfg(feature = "derive")]
pub use crate::derive::{Data, DataEnum, DataStruct, DataUnion, DeriveInput};
#[cfg(any(feature = "full", feature = "derive"))]
mod op {
    pub enum BinOp {
        Add(crate::token::Add),
        Sub(crate::token::Sub),
        Mul(crate::token::Star),
        Div(crate::token::Div),
        Rem(crate::token::Rem),
        And(crate::token::AndAnd),
        Or(crate::token::OrOr),
        BitXor(crate::token::Caret),
        BitAnd(crate::token::And),
        BitOr(crate::token::Or),
        Shl(crate::token::Shl),
        Shr(crate::token::Shr),
        Eq(crate::token::EqEq),
        Lt(crate::token::Lt),
        Le(crate::token::Le),
        Ne(crate::token::Ne),
        Ge(crate::token::Ge),
        Gt(crate::token::Gt),
        AddEq(crate::token::AddEq),
        SubEq(crate::token::SubEq),
        MulEq(crate::token::MulEq),
        DivEq(crate::token::DivEq),
        RemEq(crate::token::RemEq),
        BitXorEq(crate::token::CaretEq),
        BitAndEq(crate::token::AndEq),
        BitOrEq(crate::token::OrEq),
        ShlEq(crate::token::ShlEq),
        ShrEq(crate::token::ShrEq),
    }
    pub enum UnOp {
        Deref(crate::token::Star),
        Not(crate::token::Bang),
        Neg(crate::token::Sub),
    }
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use super::*;
        use crate::parse::{Parse, ParseStream, Result};
        fn parse_binop(input: ParseStream) -> Result<BinOp> {
            if input.peek(crate::token::AndAnd) {
                input.parse().map(BinOp::And)
            } else if input.peek(crate::token::OrOr) {
                input.parse().map(BinOp::Or)
            } else if input.peek(crate::token::Shl) {
                input.parse().map(BinOp::Shl)
            } else if input.peek(crate::token::Shr) {
                input.parse().map(BinOp::Shr)
            } else if input.peek(crate::token::EqEq) {
                input.parse().map(BinOp::Eq)
            } else if input.peek(crate::token::Le) {
                input.parse().map(BinOp::Le)
            } else if input.peek(crate::token::Ne) {
                input.parse().map(BinOp::Ne)
            } else if input.peek(crate::token::Ge) {
                input.parse().map(BinOp::Ge)
            } else if input.peek(crate::token::Add) {
                input.parse().map(BinOp::Add)
            } else if input.peek(crate::token::Sub) {
                input.parse().map(BinOp::Sub)
            } else if input.peek(crate::token::Star) {
                input.parse().map(BinOp::Mul)
            } else if input.peek(crate::token::Div) {
                input.parse().map(BinOp::Div)
            } else if input.peek(crate::token::Rem) {
                input.parse().map(BinOp::Rem)
            } else if input.peek(crate::token::Caret) {
                input.parse().map(BinOp::BitXor)
            } else if input.peek(crate::token::And) {
                input.parse().map(BinOp::BitAnd)
            } else if input.peek(crate::token::Or) {
                input.parse().map(BinOp::BitOr)
            } else if input.peek(crate::token::Lt) {
                input.parse().map(BinOp::Lt)
            } else if input.peek(crate::token::Gt) {
                input.parse().map(BinOp::Gt)
            } else {
                Err(input.error("expected binary operator"))
            }
        }
        impl Parse for BinOp {
            #[cfg(feature = "full")]
            fn parse(input: ParseStream) -> Result<Self> {
                if input.peek(crate::token::AddEq) {
                    input.parse().map(BinOp::AddEq)
                } else if input.peek(crate::token::SubEq) {
                    input.parse().map(BinOp::SubEq)
                } else if input.peek(crate::token::MulEq) {
                    input.parse().map(BinOp::MulEq)
                } else if input.peek(crate::token::DivEq) {
                    input.parse().map(BinOp::DivEq)
                } else if input.peek(crate::token::RemEq) {
                    input.parse().map(BinOp::RemEq)
                } else if input.peek(crate::token::CaretEq) {
                    input.parse().map(BinOp::BitXorEq)
                } else if input.peek(crate::token::AndEq) {
                    input.parse().map(BinOp::BitAndEq)
                } else if input.peek(crate::token::OrEq) {
                    input.parse().map(BinOp::BitOrEq)
                } else if input.peek(crate::token::ShlEq) {
                    input.parse().map(BinOp::ShlEq)
                } else if input.peek(crate::token::ShrEq) {
                    input.parse().map(BinOp::ShrEq)
                } else {
                    parse_binop(input)
                }
            }
        }
        impl Parse for UnOp {
            fn parse(input: ParseStream) -> Result<Self> {
                let lookahead = input.lookahead1();
                if lookahead.peek(crate::token::Star) {
                    input.parse().map(UnOp::Deref)
                } else if lookahead.peek(crate::token::Bang) {
                    input.parse().map(UnOp::Not)
                } else if lookahead.peek(crate::token::Sub) {
                    input.parse().map(UnOp::Neg)
                } else {
                    Err(lookahead.error())
                }
            }
        }
    }
    #[cfg(feature = "printing")]
    mod printing {
        use super::*;
        use proc_macro2::TokenStream;
        use quote::ToTokens;
        impl ToTokens for BinOp {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                match self {
                    BinOp::Add(t) => t.to_tokens(tokens),
                    BinOp::Sub(t) => t.to_tokens(tokens),
                    BinOp::Mul(t) => t.to_tokens(tokens),
                    BinOp::Div(t) => t.to_tokens(tokens),
                    BinOp::Rem(t) => t.to_tokens(tokens),
                    BinOp::And(t) => t.to_tokens(tokens),
                    BinOp::Or(t) => t.to_tokens(tokens),
                    BinOp::BitXor(t) => t.to_tokens(tokens),
                    BinOp::BitAnd(t) => t.to_tokens(tokens),
                    BinOp::BitOr(t) => t.to_tokens(tokens),
                    BinOp::Shl(t) => t.to_tokens(tokens),
                    BinOp::Shr(t) => t.to_tokens(tokens),
                    BinOp::Eq(t) => t.to_tokens(tokens),
                    BinOp::Lt(t) => t.to_tokens(tokens),
                    BinOp::Le(t) => t.to_tokens(tokens),
                    BinOp::Ne(t) => t.to_tokens(tokens),
                    BinOp::Ge(t) => t.to_tokens(tokens),
                    BinOp::Gt(t) => t.to_tokens(tokens),
                    BinOp::AddEq(t) => t.to_tokens(tokens),
                    BinOp::SubEq(t) => t.to_tokens(tokens),
                    BinOp::MulEq(t) => t.to_tokens(tokens),
                    BinOp::DivEq(t) => t.to_tokens(tokens),
                    BinOp::RemEq(t) => t.to_tokens(tokens),
                    BinOp::BitXorEq(t) => t.to_tokens(tokens),
                    BinOp::BitAndEq(t) => t.to_tokens(tokens),
                    BinOp::BitOrEq(t) => t.to_tokens(tokens),
                    BinOp::ShlEq(t) => t.to_tokens(tokens),
                    BinOp::ShrEq(t) => t.to_tokens(tokens),
                }
            }
        }
        impl ToTokens for UnOp {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                match self {
                    UnOp::Deref(t) => t.to_tokens(tokens),
                    UnOp::Not(t) => t.to_tokens(tokens),
                    UnOp::Neg(t) => t.to_tokens(tokens),
                }
            }
        }
    }
}
#[cfg(any(feature = "full", feature = "derive"))]
pub use crate::op::{BinOp, UnOp};
#[cfg(feature = "full")]
mod stmt {
    use super::*;
    pub struct Block {
        pub brace_token: token::Brace,
        pub stmts: Vec<Stmt>,
    }
    pub enum Stmt {
        Local(Local),
        Item(Item),
        Expr(Expr),
        Semi(Expr, crate::token::Semi),
    }
    pub struct Local {
        pub attrs: Vec<Attribute>,
        pub let_token: crate::token::Let,
        pub pat: Pat,
        pub init: Option<(crate::token::Eq, Box<Expr>)>,
        pub semi_token: crate::token::Semi,
    }
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use super::*;
        use crate::parse::discouraged::Speculative;
        use crate::parse::{Parse, ParseBuffer, ParseStream, Result};
        use proc_macro2::TokenStream;
        impl Block {
            pub fn parse_within(input: ParseStream) -> Result<Vec<Stmt>> {
                let mut stmts = Vec::new();
                loop {
                    while let Some(semi) = input.parse::<Option<crate::token::Semi>>()? {
                        stmts.push(Stmt::Semi(Expr::Verbatim(TokenStream::new()), semi));
                    }
                    if input.is_empty() {
                        break;
                    }
                    let s = parse_stmt(input, true)?;
                    let requires_semicolon = if let Stmt::Expr(s) = &s {
                        expr::requires_terminator(s)
                    } else {
                        false
                    };
                    stmts.push(s);
                    if input.is_empty() {
                        break;
                    } else if requires_semicolon {
                        return Err(input.error("unexpected token"));
                    }
                }
                Ok(stmts)
            }
        }
        impl Parse for Block {
            fn parse(input: ParseStream) -> Result<Self> {
                let content;
                Ok(Block {
                    brace_token: match crate::group::parse_braces(&input) {
                        crate::__private::Ok(braces) => {
                            content = braces.content;
                            braces.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    },
                    stmts: content.call(Block::parse_within)?,
                })
            }
        }
        impl Parse for Stmt {
            fn parse(input: ParseStream) -> Result<Self> {
                parse_stmt(input, false)
            }
        }
        fn parse_stmt(input: ParseStream, allow_nosemi: bool) -> Result<Stmt> {
            let begin = input.fork();
            let mut attrs = input.call(Attribute::parse_outer)?;
            let ahead = input.fork();
            if let Ok(path) = ahead.call(Path::parse_mod_style) {
                if ahead.peek(crate::token::Bang)
                    && (ahead.peek2(token::Brace)
                        && !(ahead.peek3(crate::token::Dot)
                            || ahead.peek3(crate::token::Question))
                        || ahead.peek2(Ident))
                {
                    input.advance_to(&ahead);
                    return stmt_mac(input, attrs, path);
                }
            }
            if input.peek(crate::token::Let) {
                stmt_local(input, attrs, begin)
            } else if input.peek(crate::token::Pub)
                || input.peek(crate::token::Crate) && !input.peek2(crate::token::Colon2)
                || input.peek(crate::token::Extern) || input.peek(crate::token::Use)
                || input.peek(crate::token::Static)
                    && (input.peek2(crate::token::Mut) || input.peek2(Ident))
                || input.peek(crate::token::Const) && !input.peek2(token::Brace)
                || input.peek(crate::token::Unsafe) && !input.peek2(token::Brace)
                || input.peek(crate::token::Async)
                    && (input.peek2(crate::token::Unsafe)
                        || input.peek2(crate::token::Extern)
                        || input.peek2(crate::token::Fn)) || input.peek(crate::token::Fn)
                || input.peek(crate::token::Mod) || input.peek(crate::token::Type)
                || input.peek(crate::token::Struct) || input.peek(crate::token::Enum)
                || input.peek(crate::token::Union) && input.peek2(Ident)
                || input.peek(crate::token::Auto) && input.peek2(crate::token::Trait)
                || input.peek(crate::token::Trait)
                || input.peek(crate::token::Default)
                    && (input.peek2(crate::token::Unsafe)
                        || input.peek2(crate::token::Impl))
                || input.peek(crate::token::Impl) || input.peek(crate::token::Macro)
            {
                let mut item: Item = input.parse()?;
                attrs.extend(item.replace_attrs(Vec::new()));
                item.replace_attrs(attrs);
                Ok(Stmt::Item(item))
            } else {
                stmt_expr(input, allow_nosemi, attrs)
            }
        }
        fn stmt_mac(
            input: ParseStream,
            attrs: Vec<Attribute>,
            path: Path,
        ) -> Result<Stmt> {
            let bang_token: crate::token::Bang = input.parse()?;
            let ident: Option<Ident> = input.parse()?;
            let (delimiter, tokens) = mac::parse_delimiter(input)?;
            let semi_token: Option<crate::token::Semi> = input.parse()?;
            Ok(
                Stmt::Item(
                    Item::Macro(ItemMacro {
                        attrs,
                        ident,
                        mac: Macro {
                            path,
                            bang_token,
                            delimiter,
                            tokens,
                        },
                        semi_token,
                    }),
                ),
            )
        }
        fn stmt_local(
            input: ParseStream,
            attrs: Vec<Attribute>,
            begin: ParseBuffer,
        ) -> Result<Stmt> {
            let let_token: crate::token::Let = input.parse()?;
            let mut pat: Pat = pat::parsing::multi_pat_with_leading_vert(input)?;
            if input.peek(crate::token::Colon) {
                let colon_token: crate::token::Colon = input.parse()?;
                let ty: Type = input.parse()?;
                pat = Pat::Type(PatType {
                    attrs: Vec::new(),
                    pat: Box::new(pat),
                    colon_token,
                    ty: Box::new(ty),
                });
            }
            let init = if input.peek(crate::token::Eq) {
                let eq_token: crate::token::Eq = input.parse()?;
                let init: Expr = input.parse()?;
                if input.peek(crate::token::Else) {
                    input.parse::<crate::token::Else>()?;
                    let content;
                    match crate::group::parse_braces(&input) {
                        crate::__private::Ok(braces) => {
                            content = braces.content;
                            braces.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    };
                    content.call(Block::parse_within)?;
                    let verbatim = Expr::Verbatim(verbatim::between(begin, input));
                    let semi_token: crate::token::Semi = input.parse()?;
                    return Ok(Stmt::Semi(verbatim, semi_token));
                }
                Some((eq_token, Box::new(init)))
            } else {
                None
            };
            let semi_token: crate::token::Semi = input.parse()?;
            Ok(
                Stmt::Local(Local {
                    attrs,
                    let_token,
                    pat,
                    init,
                    semi_token,
                }),
            )
        }
        fn stmt_expr(
            input: ParseStream,
            allow_nosemi: bool,
            mut attrs: Vec<Attribute>,
        ) -> Result<Stmt> {
            let mut e = expr::parsing::expr_early(input)?;
            let mut attr_target = &mut e;
            loop {
                attr_target = match attr_target {
                    Expr::Assign(e) => &mut e.left,
                    Expr::AssignOp(e) => &mut e.left,
                    Expr::Binary(e) => &mut e.left,
                    _ => break,
                };
            }
            attrs.extend(attr_target.replace_attrs(Vec::new()));
            attr_target.replace_attrs(attrs);
            if input.peek(crate::token::Semi) {
                return Ok(Stmt::Semi(e, input.parse()?));
            }
            if allow_nosemi || !expr::requires_terminator(&e) {
                Ok(Stmt::Expr(e))
            } else {
                Err(input.error("expected semicolon"))
            }
        }
    }
    #[cfg(feature = "printing")]
    mod printing {
        use super::*;
        use proc_macro2::TokenStream;
        use quote::{ToTokens, TokenStreamExt};
        impl ToTokens for Block {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            tokens.append_all(&self.stmts);
                        },
                    );
            }
        }
        impl ToTokens for Stmt {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                match self {
                    Stmt::Local(local) => local.to_tokens(tokens),
                    Stmt::Item(item) => item.to_tokens(tokens),
                    Stmt::Expr(expr) => expr.to_tokens(tokens),
                    Stmt::Semi(expr, semi) => {
                        expr.to_tokens(tokens);
                        semi.to_tokens(tokens);
                    }
                }
            }
        }
        impl ToTokens for Local {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                expr::printing::outer_attrs_to_tokens(&self.attrs, tokens);
                self.let_token.to_tokens(tokens);
                self.pat.to_tokens(tokens);
                if let Some((eq_token, init)) = &self.init {
                    eq_token.to_tokens(tokens);
                    init.to_tokens(tokens);
                }
                self.semi_token.to_tokens(tokens);
            }
        }
    }
}
#[cfg(feature = "full")]
pub use crate::stmt::{Block, Local, Stmt};
#[cfg(any(feature = "full", feature = "derive"))]
mod ty {
    use super::*;
    use crate::punctuated::Punctuated;
    use proc_macro2::TokenStream;
    #[non_exhaustive]
    pub enum Type {
        Array(TypeArray),
        BareFn(TypeBareFn),
        Group(TypeGroup),
        ImplTrait(TypeImplTrait),
        Infer(TypeInfer),
        Macro(TypeMacro),
        Never(TypeNever),
        Paren(TypeParen),
        Path(TypePath),
        Ptr(TypePtr),
        Reference(TypeReference),
        Slice(TypeSlice),
        TraitObject(TypeTraitObject),
        Tuple(TypeTuple),
        Verbatim(TokenStream),
    }
    impl From<TypeArray> for Type {
        fn from(e: TypeArray) -> Type {
            Type::Array(e)
        }
    }
    impl From<TypeBareFn> for Type {
        fn from(e: TypeBareFn) -> Type {
            Type::BareFn(e)
        }
    }
    impl From<TypeGroup> for Type {
        fn from(e: TypeGroup) -> Type {
            Type::Group(e)
        }
    }
    impl From<TypeImplTrait> for Type {
        fn from(e: TypeImplTrait) -> Type {
            Type::ImplTrait(e)
        }
    }
    impl From<TypeInfer> for Type {
        fn from(e: TypeInfer) -> Type {
            Type::Infer(e)
        }
    }
    impl From<TypeMacro> for Type {
        fn from(e: TypeMacro) -> Type {
            Type::Macro(e)
        }
    }
    impl From<TypeNever> for Type {
        fn from(e: TypeNever) -> Type {
            Type::Never(e)
        }
    }
    impl From<TypeParen> for Type {
        fn from(e: TypeParen) -> Type {
            Type::Paren(e)
        }
    }
    impl From<TypePath> for Type {
        fn from(e: TypePath) -> Type {
            Type::Path(e)
        }
    }
    impl From<TypePtr> for Type {
        fn from(e: TypePtr) -> Type {
            Type::Ptr(e)
        }
    }
    impl From<TypeReference> for Type {
        fn from(e: TypeReference) -> Type {
            Type::Reference(e)
        }
    }
    impl From<TypeSlice> for Type {
        fn from(e: TypeSlice) -> Type {
            Type::Slice(e)
        }
    }
    impl From<TypeTraitObject> for Type {
        fn from(e: TypeTraitObject) -> Type {
            Type::TraitObject(e)
        }
    }
    impl From<TypeTuple> for Type {
        fn from(e: TypeTuple) -> Type {
            Type::Tuple(e)
        }
    }
    impl ::quote::ToTokens for Type {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                Type::Array(_e) => _e.to_tokens(tokens),
                Type::BareFn(_e) => _e.to_tokens(tokens),
                Type::Group(_e) => _e.to_tokens(tokens),
                Type::ImplTrait(_e) => _e.to_tokens(tokens),
                Type::Infer(_e) => _e.to_tokens(tokens),
                Type::Macro(_e) => _e.to_tokens(tokens),
                Type::Never(_e) => _e.to_tokens(tokens),
                Type::Paren(_e) => _e.to_tokens(tokens),
                Type::Path(_e) => _e.to_tokens(tokens),
                Type::Ptr(_e) => _e.to_tokens(tokens),
                Type::Reference(_e) => _e.to_tokens(tokens),
                Type::Slice(_e) => _e.to_tokens(tokens),
                Type::TraitObject(_e) => _e.to_tokens(tokens),
                Type::Tuple(_e) => _e.to_tokens(tokens),
                Type::Verbatim(_e) => _e.to_tokens(tokens),
            }
        }
    }
    pub struct TypeArray {
        pub bracket_token: token::Bracket,
        pub elem: Box<Type>,
        pub semi_token: crate::token::Semi,
        pub len: Expr,
    }
    pub struct TypeBareFn {
        pub lifetimes: Option<BoundLifetimes>,
        pub unsafety: Option<crate::token::Unsafe>,
        pub abi: Option<Abi>,
        pub fn_token: crate::token::Fn,
        pub paren_token: token::Paren,
        pub inputs: Punctuated<BareFnArg, crate::token::Comma>,
        pub variadic: Option<Variadic>,
        pub output: ReturnType,
    }
    pub struct TypeGroup {
        pub group_token: token::Group,
        pub elem: Box<Type>,
    }
    pub struct TypeImplTrait {
        pub impl_token: crate::token::Impl,
        pub bounds: Punctuated<TypeParamBound, crate::token::Add>,
    }
    pub struct TypeInfer {
        pub underscore_token: crate::token::Underscore,
    }
    pub struct TypeMacro {
        pub mac: Macro,
    }
    pub struct TypeNever {
        pub bang_token: crate::token::Bang,
    }
    pub struct TypeParen {
        pub paren_token: token::Paren,
        pub elem: Box<Type>,
    }
    pub struct TypePath {
        pub qself: Option<QSelf>,
        pub path: Path,
    }
    pub struct TypePtr {
        pub star_token: crate::token::Star,
        pub const_token: Option<crate::token::Const>,
        pub mutability: Option<crate::token::Mut>,
        pub elem: Box<Type>,
    }
    pub struct TypeReference {
        pub and_token: crate::token::And,
        pub lifetime: Option<Lifetime>,
        pub mutability: Option<crate::token::Mut>,
        pub elem: Box<Type>,
    }
    pub struct TypeSlice {
        pub bracket_token: token::Bracket,
        pub elem: Box<Type>,
    }
    pub struct TypeTraitObject {
        pub dyn_token: Option<crate::token::Dyn>,
        pub bounds: Punctuated<TypeParamBound, crate::token::Add>,
    }
    pub struct TypeTuple {
        pub paren_token: token::Paren,
        pub elems: Punctuated<Type, crate::token::Comma>,
    }
    pub struct Abi {
        pub extern_token: crate::token::Extern,
        pub name: Option<LitStr>,
    }
    pub struct BareFnArg {
        pub attrs: Vec<Attribute>,
        pub name: Option<(Ident, crate::token::Colon)>,
        pub ty: Type,
    }
    pub struct Variadic {
        pub attrs: Vec<Attribute>,
        pub dots: crate::token::Dot3,
    }
    pub enum ReturnType {
        Default,
        Type(crate::token::RArrow, Box<Type>),
    }
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use super::*;
        use crate::ext::IdentExt;
        use crate::parse::{Parse, ParseStream, Result};
        use crate::path;
        use proc_macro2::{Punct, Spacing, TokenTree};
        impl Parse for Type {
            fn parse(input: ParseStream) -> Result<Self> {
                let allow_plus = true;
                ambig_ty(input, allow_plus)
            }
        }
        impl Type {
            pub fn without_plus(input: ParseStream) -> Result<Self> {
                let allow_plus = false;
                ambig_ty(input, allow_plus)
            }
        }
        fn ambig_ty(input: ParseStream, allow_plus: bool) -> Result<Type> {
            let begin = input.fork();
            if input.peek(token::Group) {
                let mut group: TypeGroup = input.parse()?;
                if input.peek(crate::token::Colon2) && input.peek3(Ident::peek_any) {
                    if let Type::Path(mut ty) = *group.elem {
                        Path::parse_rest(input, &mut ty.path, false)?;
                        return Ok(Type::Path(ty));
                    } else {
                        return Ok(
                            Type::Path(TypePath {
                                qself: Some(QSelf {
                                    lt_token: crate::token::Lt(group.group_token.span),
                                    position: 0,
                                    as_token: None,
                                    gt_token: crate::token::Gt(group.group_token.span),
                                    ty: group.elem,
                                }),
                                path: Path::parse_helper(input, false)?,
                            }),
                        );
                    }
                } else if input.peek(crate::token::Lt)
                    || input.peek(crate::token::Colon2) && input.peek3(crate::token::Lt)
                {
                    if let Type::Path(mut ty) = *group.elem {
                        let arguments = &mut ty
                            .path
                            .segments
                            .last_mut()
                            .unwrap()
                            .arguments;
                        if let PathArguments::None = arguments {
                            *arguments = PathArguments::AngleBracketed(input.parse()?);
                            Path::parse_rest(input, &mut ty.path, false)?;
                            return Ok(Type::Path(ty));
                        } else {
                            group.elem = Box::new(Type::Path(ty));
                        }
                    }
                }
                return Ok(Type::Group(group));
            }
            let mut lifetimes = None::<BoundLifetimes>;
            let mut lookahead = input.lookahead1();
            if lookahead.peek(crate::token::For) {
                lifetimes = input.parse()?;
                lookahead = input.lookahead1();
                if !lookahead.peek(Ident) && !lookahead.peek(crate::token::Fn)
                    && !lookahead.peek(crate::token::Unsafe)
                    && !lookahead.peek(crate::token::Extern)
                    && !lookahead.peek(crate::token::Super)
                    && !lookahead.peek(crate::token::SelfValue)
                    && !lookahead.peek(crate::token::SelfType)
                    && !lookahead.peek(crate::token::Crate)
                    || input.peek(crate::token::Dyn)
                {
                    return Err(lookahead.error());
                }
            }
            if lookahead.peek(token::Paren) {
                let content;
                let paren_token = match crate::group::parse_parens(&input) {
                    crate::__private::Ok(parens) => {
                        content = parens.content;
                        parens.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                };
                if content.is_empty() {
                    return Ok(
                        Type::Tuple(TypeTuple {
                            paren_token,
                            elems: Punctuated::new(),
                        }),
                    );
                }
                if content.peek(Lifetime) {
                    return Ok(
                        Type::Paren(TypeParen {
                            paren_token,
                            elem: Box::new(Type::TraitObject(content.parse()?)),
                        }),
                    );
                }
                if content.peek(crate::token::Question) {
                    return Ok(
                        Type::TraitObject(TypeTraitObject {
                            dyn_token: None,
                            bounds: {
                                let mut bounds = Punctuated::new();
                                bounds
                                    .push_value(
                                        TypeParamBound::Trait(TraitBound {
                                            paren_token: Some(paren_token),
                                            ..content.parse()?
                                        }),
                                    );
                                while let Some(plus) = input.parse()? {
                                    bounds.push_punct(plus);
                                    bounds.push_value(input.parse()?);
                                }
                                bounds
                            },
                        }),
                    );
                }
                let mut first: Type = content.parse()?;
                if content.peek(crate::token::Comma) {
                    return Ok(
                        Type::Tuple(TypeTuple {
                            paren_token,
                            elems: {
                                let mut elems = Punctuated::new();
                                elems.push_value(first);
                                elems.push_punct(content.parse()?);
                                while !content.is_empty() {
                                    elems.push_value(content.parse()?);
                                    if content.is_empty() {
                                        break;
                                    }
                                    elems.push_punct(content.parse()?);
                                }
                                elems
                            },
                        }),
                    );
                }
                if allow_plus && input.peek(crate::token::Add) {
                    loop {
                        let first = match first {
                            Type::Path(TypePath { qself: None, path }) => {
                                TypeParamBound::Trait(TraitBound {
                                    paren_token: Some(paren_token),
                                    modifier: TraitBoundModifier::None,
                                    lifetimes: None,
                                    path,
                                })
                            }
                            Type::TraitObject(
                                TypeTraitObject { dyn_token: None, bounds },
                            ) => {
                                if bounds.len() > 1 || bounds.trailing_punct() {
                                    first = Type::TraitObject(TypeTraitObject {
                                        dyn_token: None,
                                        bounds,
                                    });
                                    break;
                                }
                                match bounds.into_iter().next().unwrap() {
                                    TypeParamBound::Trait(trait_bound) => {
                                        TypeParamBound::Trait(TraitBound {
                                            paren_token: Some(paren_token),
                                            ..trait_bound
                                        })
                                    }
                                    other @ TypeParamBound::Lifetime(_) => other,
                                }
                            }
                            _ => break,
                        };
                        return Ok(
                            Type::TraitObject(TypeTraitObject {
                                dyn_token: None,
                                bounds: {
                                    let mut bounds = Punctuated::new();
                                    bounds.push_value(first);
                                    while let Some(plus) = input.parse()? {
                                        bounds.push_punct(plus);
                                        bounds.push_value(input.parse()?);
                                    }
                                    bounds
                                },
                            }),
                        );
                    }
                }
                Ok(
                    Type::Paren(TypeParen {
                        paren_token,
                        elem: Box::new(first),
                    }),
                )
            } else if lookahead.peek(crate::token::Fn)
                || lookahead.peek(crate::token::Unsafe)
                || lookahead.peek(crate::token::Extern)
            {
                let allow_mut_self = true;
                if let Some(mut bare_fn) = parse_bare_fn(input, allow_mut_self)? {
                    bare_fn.lifetimes = lifetimes;
                    Ok(Type::BareFn(bare_fn))
                } else {
                    Ok(Type::Verbatim(verbatim::between(begin, input)))
                }
            } else if lookahead.peek(Ident) || input.peek(crate::token::Super)
                || input.peek(crate::token::SelfValue)
                || input.peek(crate::token::SelfType) || input.peek(crate::token::Crate)
                || lookahead.peek(crate::token::Colon2)
                || lookahead.peek(crate::token::Lt)
            {
                if input.peek(crate::token::Dyn) {
                    let trait_object = TypeTraitObject::parse(input, allow_plus)?;
                    return Ok(Type::TraitObject(trait_object));
                }
                let ty: TypePath = input.parse()?;
                if ty.qself.is_some() {
                    return Ok(Type::Path(ty));
                }
                if input.peek(crate::token::Bang) && !input.peek(crate::token::Ne) {
                    let mut contains_arguments = false;
                    for segment in &ty.path.segments {
                        match segment.arguments {
                            PathArguments::None => {}
                            PathArguments::AngleBracketed(_)
                            | PathArguments::Parenthesized(_) => {
                                contains_arguments = true;
                            }
                        }
                    }
                    if !contains_arguments {
                        let bang_token: crate::token::Bang = input.parse()?;
                        let (delimiter, tokens) = mac::parse_delimiter(input)?;
                        return Ok(
                            Type::Macro(TypeMacro {
                                mac: Macro {
                                    path: ty.path,
                                    bang_token,
                                    delimiter,
                                    tokens,
                                },
                            }),
                        );
                    }
                }
                if lifetimes.is_some() || allow_plus && input.peek(crate::token::Add) {
                    let mut bounds = Punctuated::new();
                    bounds
                        .push_value(
                            TypeParamBound::Trait(TraitBound {
                                paren_token: None,
                                modifier: TraitBoundModifier::None,
                                lifetimes,
                                path: ty.path,
                            }),
                        );
                    if allow_plus {
                        while input.peek(crate::token::Add) {
                            bounds.push_punct(input.parse()?);
                            if !(input.peek(Ident::peek_any)
                                || input.peek(crate::token::Colon2)
                                || input.peek(crate::token::Question)
                                || input.peek(Lifetime) || input.peek(token::Paren))
                            {
                                break;
                            }
                            bounds.push_value(input.parse()?);
                        }
                    }
                    return Ok(
                        Type::TraitObject(TypeTraitObject {
                            dyn_token: None,
                            bounds,
                        }),
                    );
                }
                Ok(Type::Path(ty))
            } else if lookahead.peek(token::Bracket) {
                let content;
                let bracket_token = match crate::group::parse_brackets(&input) {
                    crate::__private::Ok(brackets) => {
                        content = brackets.content;
                        brackets.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                };
                let elem: Type = content.parse()?;
                if content.peek(crate::token::Semi) {
                    Ok(
                        Type::Array(TypeArray {
                            bracket_token,
                            elem: Box::new(elem),
                            semi_token: content.parse()?,
                            len: content.parse()?,
                        }),
                    )
                } else {
                    Ok(
                        Type::Slice(TypeSlice {
                            bracket_token,
                            elem: Box::new(elem),
                        }),
                    )
                }
            } else if lookahead.peek(crate::token::Star) {
                input.parse().map(Type::Ptr)
            } else if lookahead.peek(crate::token::And) {
                input.parse().map(Type::Reference)
            } else if lookahead.peek(crate::token::Bang) && !input.peek(crate::token::Eq)
            {
                input.parse().map(Type::Never)
            } else if lookahead.peek(crate::token::Impl) {
                TypeImplTrait::parse(input, allow_plus).map(Type::ImplTrait)
            } else if lookahead.peek(crate::token::Underscore) {
                input.parse().map(Type::Infer)
            } else if lookahead.peek(Lifetime) {
                input.parse().map(Type::TraitObject)
            } else {
                Err(lookahead.error())
            }
        }
        impl Parse for TypeSlice {
            fn parse(input: ParseStream) -> Result<Self> {
                let content;
                Ok(TypeSlice {
                    bracket_token: match crate::group::parse_brackets(&input) {
                        crate::__private::Ok(brackets) => {
                            content = brackets.content;
                            brackets.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    },
                    elem: content.parse()?,
                })
            }
        }
        impl Parse for TypeArray {
            fn parse(input: ParseStream) -> Result<Self> {
                let content;
                Ok(TypeArray {
                    bracket_token: match crate::group::parse_brackets(&input) {
                        crate::__private::Ok(brackets) => {
                            content = brackets.content;
                            brackets.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    },
                    elem: content.parse()?,
                    semi_token: content.parse()?,
                    len: content.parse()?,
                })
            }
        }
        impl Parse for TypePtr {
            fn parse(input: ParseStream) -> Result<Self> {
                let star_token: crate::token::Star = input.parse()?;
                let lookahead = input.lookahead1();
                let (const_token, mutability) = if lookahead.peek(crate::token::Const) {
                    (Some(input.parse()?), None)
                } else if lookahead.peek(crate::token::Mut) {
                    (None, Some(input.parse()?))
                } else {
                    return Err(lookahead.error());
                };
                Ok(TypePtr {
                    star_token,
                    const_token,
                    mutability,
                    elem: Box::new(input.call(Type::without_plus)?),
                })
            }
        }
        impl Parse for TypeReference {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(TypeReference {
                    and_token: input.parse()?,
                    lifetime: input.parse()?,
                    mutability: input.parse()?,
                    elem: Box::new(input.call(Type::without_plus)?),
                })
            }
        }
        impl Parse for TypeBareFn {
            fn parse(input: ParseStream) -> Result<Self> {
                let allow_mut_self = false;
                parse_bare_fn(input, allow_mut_self).map(Option::unwrap)
            }
        }
        fn parse_bare_fn(
            input: ParseStream,
            allow_mut_self: bool,
        ) -> Result<Option<TypeBareFn>> {
            let args;
            let mut variadic = None;
            let mut has_mut_self = false;
            let bare_fn = TypeBareFn {
                lifetimes: input.parse()?,
                unsafety: input.parse()?,
                abi: input.parse()?,
                fn_token: input.parse()?,
                paren_token: match crate::group::parse_parens(&input) {
                    crate::__private::Ok(parens) => {
                        args = parens.content;
                        parens.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                },
                inputs: {
                    let mut inputs = Punctuated::new();
                    while !args.is_empty() {
                        let attrs = args.call(Attribute::parse_outer)?;
                        if inputs.empty_or_trailing() && args.peek(crate::token::Dot3) {
                            variadic = Some(Variadic {
                                attrs,
                                dots: args.parse()?,
                            });
                            break;
                        }
                        if let Some(arg) = parse_bare_fn_arg(&args, allow_mut_self)? {
                            inputs.push_value(BareFnArg { attrs, ..arg });
                        } else {
                            has_mut_self = true;
                        }
                        if args.is_empty() {
                            break;
                        }
                        let comma = args.parse()?;
                        if !has_mut_self {
                            inputs.push_punct(comma);
                        }
                    }
                    inputs
                },
                variadic,
                output: input.call(ReturnType::without_plus)?,
            };
            if has_mut_self { Ok(None) } else { Ok(Some(bare_fn)) }
        }
        impl Parse for TypeNever {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(TypeNever {
                    bang_token: input.parse()?,
                })
            }
        }
        impl Parse for TypeInfer {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(TypeInfer {
                    underscore_token: input.parse()?,
                })
            }
        }
        impl Parse for TypeTuple {
            fn parse(input: ParseStream) -> Result<Self> {
                let content;
                let paren_token = match crate::group::parse_parens(&input) {
                    crate::__private::Ok(parens) => {
                        content = parens.content;
                        parens.token
                    }
                    crate::__private::Err(error) => {
                        return crate::__private::Err(error);
                    }
                };
                if content.is_empty() {
                    return Ok(TypeTuple {
                        paren_token,
                        elems: Punctuated::new(),
                    });
                }
                let first: Type = content.parse()?;
                Ok(TypeTuple {
                    paren_token,
                    elems: {
                        let mut elems = Punctuated::new();
                        elems.push_value(first);
                        elems.push_punct(content.parse()?);
                        while !content.is_empty() {
                            elems.push_value(content.parse()?);
                            if content.is_empty() {
                                break;
                            }
                            elems.push_punct(content.parse()?);
                        }
                        elems
                    },
                })
            }
        }
        impl Parse for TypeMacro {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(TypeMacro { mac: input.parse()? })
            }
        }
        impl Parse for TypePath {
            fn parse(input: ParseStream) -> Result<Self> {
                let (qself, mut path) = path::parsing::qpath(input, false)?;
                if path.segments.last().unwrap().arguments.is_empty()
                    && (input.peek(token::Paren)
                        || input.peek(crate::token::Colon2) && input.peek3(token::Paren))
                {
                    input.parse::<Option<crate::token::Colon2>>()?;
                    let args: ParenthesizedGenericArguments = input.parse()?;
                    let parenthesized = PathArguments::Parenthesized(args);
                    path.segments.last_mut().unwrap().arguments = parenthesized;
                }
                Ok(TypePath { qself, path })
            }
        }
        impl ReturnType {
            pub fn without_plus(input: ParseStream) -> Result<Self> {
                let allow_plus = false;
                Self::parse(input, allow_plus)
            }
            pub(crate) fn parse(input: ParseStream, allow_plus: bool) -> Result<Self> {
                if input.peek(crate::token::RArrow) {
                    let arrow = input.parse()?;
                    let ty = ambig_ty(input, allow_plus)?;
                    Ok(ReturnType::Type(arrow, Box::new(ty)))
                } else {
                    Ok(ReturnType::Default)
                }
            }
        }
        impl Parse for ReturnType {
            fn parse(input: ParseStream) -> Result<Self> {
                let allow_plus = true;
                Self::parse(input, allow_plus)
            }
        }
        impl Parse for TypeTraitObject {
            fn parse(input: ParseStream) -> Result<Self> {
                let allow_plus = true;
                Self::parse(input, allow_plus)
            }
        }
        fn at_least_one_type(
            bounds: &Punctuated<TypeParamBound, crate::token::Add>,
        ) -> bool {
            for bound in bounds {
                if let TypeParamBound::Trait(_) = *bound {
                    return true;
                }
            }
            false
        }
        impl TypeTraitObject {
            pub fn without_plus(input: ParseStream) -> Result<Self> {
                let allow_plus = false;
                Self::parse(input, allow_plus)
            }
            pub(crate) fn parse(input: ParseStream, allow_plus: bool) -> Result<Self> {
                Ok(TypeTraitObject {
                    dyn_token: input.parse()?,
                    bounds: Self::parse_bounds(input, allow_plus)?,
                })
            }
            fn parse_bounds(
                input: ParseStream,
                allow_plus: bool,
            ) -> Result<Punctuated<TypeParamBound, crate::token::Add>> {
                let mut bounds = Punctuated::new();
                loop {
                    bounds.push_value(input.parse()?);
                    if !(allow_plus && input.peek(crate::token::Add)) {
                        break;
                    }
                    bounds.push_punct(input.parse()?);
                    if !(input.peek(Ident::peek_any) || input.peek(crate::token::Colon2)
                        || input.peek(crate::token::Question) || input.peek(Lifetime)
                        || input.peek(token::Paren))
                    {
                        break;
                    }
                }
                if !at_least_one_type(&bounds) {
                    return Err(input.error("expected at least one type"));
                }
                Ok(bounds)
            }
        }
        impl Parse for TypeImplTrait {
            fn parse(input: ParseStream) -> Result<Self> {
                let allow_plus = true;
                Self::parse(input, allow_plus)
            }
        }
        impl TypeImplTrait {
            pub fn without_plus(input: ParseStream) -> Result<Self> {
                let allow_plus = false;
                Self::parse(input, allow_plus)
            }
            pub(crate) fn parse(input: ParseStream, allow_plus: bool) -> Result<Self> {
                Ok(TypeImplTrait {
                    impl_token: input.parse()?,
                    bounds: TypeTraitObject::parse_bounds(input, allow_plus)?,
                })
            }
        }
        impl Parse for TypeGroup {
            fn parse(input: ParseStream) -> Result<Self> {
                let group = crate::group::parse_group(input)?;
                Ok(TypeGroup {
                    group_token: group.token,
                    elem: group.content.parse()?,
                })
            }
        }
        impl Parse for TypeParen {
            fn parse(input: ParseStream) -> Result<Self> {
                let allow_plus = false;
                Self::parse(input, allow_plus)
            }
        }
        impl TypeParen {
            fn parse(input: ParseStream, allow_plus: bool) -> Result<Self> {
                let content;
                Ok(TypeParen {
                    paren_token: match crate::group::parse_parens(&input) {
                        crate::__private::Ok(parens) => {
                            content = parens.content;
                            parens.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    },
                    elem: Box::new(ambig_ty(&content, allow_plus)?),
                })
            }
        }
        impl Parse for BareFnArg {
            fn parse(input: ParseStream) -> Result<Self> {
                let allow_mut_self = false;
                parse_bare_fn_arg(input, allow_mut_self).map(Option::unwrap)
            }
        }
        fn parse_bare_fn_arg(
            input: ParseStream,
            mut allow_mut_self: bool,
        ) -> Result<Option<BareFnArg>> {
            let mut has_mut_self = false;
            let arg = BareFnArg {
                attrs: input.call(Attribute::parse_outer)?,
                name: {
                    if (input.peek(Ident) || input.peek(crate::token::Underscore)
                        || input.peek(crate::token::SelfValue))
                        && input.peek2(crate::token::Colon)
                        && !input.peek2(crate::token::Colon2)
                    {
                        let name = input.call(Ident::parse_any)?;
                        let colon: crate::token::Colon = input.parse()?;
                        Some((name, colon))
                    } else if allow_mut_self && input.peek(crate::token::Mut)
                        && input.peek2(crate::token::SelfValue)
                        && input.peek3(crate::token::Colon)
                        && !input.peek3(crate::token::Colon2)
                    {
                        has_mut_self = true;
                        allow_mut_self = false;
                        input.parse::<crate::token::Mut>()?;
                        input.parse::<crate::token::SelfValue>()?;
                        input.parse::<crate::token::Colon>()?;
                        None
                    } else {
                        None
                    }
                },
                ty: if !has_mut_self && input.peek(crate::token::Dot3) {
                    let dot3 = input.parse::<crate::token::Dot3>()?;
                    let args = <[_]>::into_vec(
                        #[rustc_box]
                        ::alloc::boxed::Box::new([
                            TokenTree::Punct(Punct::new('.', Spacing::Joint)),
                            TokenTree::Punct(Punct::new('.', Spacing::Joint)),
                            TokenTree::Punct(Punct::new('.', Spacing::Alone)),
                        ]),
                    );
                    let tokens: TokenStream = args
                        .into_iter()
                        .zip(&dot3.spans)
                        .map(|(mut arg, span)| {
                            arg.set_span(*span);
                            arg
                        })
                        .collect();
                    Type::Verbatim(tokens)
                } else if allow_mut_self && input.peek(crate::token::Mut)
                    && input.peek2(crate::token::SelfValue)
                {
                    has_mut_self = true;
                    input.parse::<crate::token::Mut>()?;
                    Type::Path(TypePath {
                        qself: None,
                        path: input.parse::<crate::token::SelfValue>()?.into(),
                    })
                } else {
                    input.parse()?
                },
            };
            if has_mut_self { Ok(None) } else { Ok(Some(arg)) }
        }
        impl Parse for Abi {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(Abi {
                    extern_token: input.parse()?,
                    name: input.parse()?,
                })
            }
        }
        impl Parse for Option<Abi> {
            fn parse(input: ParseStream) -> Result<Self> {
                if input.peek(crate::token::Extern) {
                    input.parse().map(Some)
                } else {
                    Ok(None)
                }
            }
        }
    }
    #[cfg(feature = "printing")]
    mod printing {
        use super::*;
        use crate::attr::FilterAttrs;
        use crate::print::TokensOrDefault;
        use proc_macro2::TokenStream;
        use quote::{ToTokens, TokenStreamExt};
        impl ToTokens for TypeSlice {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.bracket_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.elem.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for TypeArray {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.bracket_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.elem.to_tokens(tokens);
                            self.semi_token.to_tokens(tokens);
                            self.len.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for TypePtr {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.star_token.to_tokens(tokens);
                match &self.mutability {
                    Some(tok) => tok.to_tokens(tokens),
                    None => {
                        TokensOrDefault(&self.const_token).to_tokens(tokens);
                    }
                }
                self.elem.to_tokens(tokens);
            }
        }
        impl ToTokens for TypeReference {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.and_token.to_tokens(tokens);
                self.lifetime.to_tokens(tokens);
                self.mutability.to_tokens(tokens);
                self.elem.to_tokens(tokens);
            }
        }
        impl ToTokens for TypeBareFn {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.lifetimes.to_tokens(tokens);
                self.unsafety.to_tokens(tokens);
                self.abi.to_tokens(tokens);
                self.fn_token.to_tokens(tokens);
                self.paren_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.inputs.to_tokens(tokens);
                            if let Some(variadic) = &self.variadic {
                                if !self.inputs.empty_or_trailing() {
                                    let span = variadic.dots.spans[0];
                                    crate::token::Comma(span).to_tokens(tokens);
                                }
                                variadic.to_tokens(tokens);
                            }
                        },
                    );
                self.output.to_tokens(tokens);
            }
        }
        impl ToTokens for TypeNever {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.bang_token.to_tokens(tokens);
            }
        }
        impl ToTokens for TypeTuple {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.paren_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.elems.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for TypePath {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                path::printing::print_path(tokens, &self.qself, &self.path);
            }
        }
        impl ToTokens for TypeTraitObject {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.dyn_token.to_tokens(tokens);
                self.bounds.to_tokens(tokens);
            }
        }
        impl ToTokens for TypeImplTrait {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.impl_token.to_tokens(tokens);
                self.bounds.to_tokens(tokens);
            }
        }
        impl ToTokens for TypeGroup {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.group_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.elem.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for TypeParen {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.paren_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.elem.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for TypeInfer {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.underscore_token.to_tokens(tokens);
            }
        }
        impl ToTokens for TypeMacro {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.mac.to_tokens(tokens);
            }
        }
        impl ToTokens for ReturnType {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                match self {
                    ReturnType::Default => {}
                    ReturnType::Type(arrow, ty) => {
                        arrow.to_tokens(tokens);
                        ty.to_tokens(tokens);
                    }
                }
            }
        }
        impl ToTokens for BareFnArg {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                if let Some((name, colon)) = &self.name {
                    name.to_tokens(tokens);
                    colon.to_tokens(tokens);
                }
                self.ty.to_tokens(tokens);
            }
        }
        impl ToTokens for Variadic {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.dots.to_tokens(tokens);
            }
        }
        impl ToTokens for Abi {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.extern_token.to_tokens(tokens);
                self.name.to_tokens(tokens);
            }
        }
    }
}
#[cfg(any(feature = "full", feature = "derive"))]
pub use crate::ty::{
    Abi, BareFnArg, ReturnType, Type, TypeArray, TypeBareFn, TypeGroup, TypeImplTrait,
    TypeInfer, TypeMacro, TypeNever, TypeParen, TypePath, TypePtr, TypeReference,
    TypeSlice, TypeTraitObject, TypeTuple, Variadic,
};
#[cfg(feature = "full")]
mod pat {
    use super::*;
    use crate::punctuated::Punctuated;
    use proc_macro2::TokenStream;
    #[non_exhaustive]
    pub enum Pat {
        Box(PatBox),
        Ident(PatIdent),
        Lit(PatLit),
        Macro(PatMacro),
        Or(PatOr),
        Path(PatPath),
        Range(PatRange),
        Reference(PatReference),
        Rest(PatRest),
        Slice(PatSlice),
        Struct(PatStruct),
        Tuple(PatTuple),
        TupleStruct(PatTupleStruct),
        Type(PatType),
        Verbatim(TokenStream),
        Wild(PatWild),
    }
    impl From<PatBox> for Pat {
        fn from(e: PatBox) -> Pat {
            Pat::Box(e)
        }
    }
    impl From<PatIdent> for Pat {
        fn from(e: PatIdent) -> Pat {
            Pat::Ident(e)
        }
    }
    impl From<PatLit> for Pat {
        fn from(e: PatLit) -> Pat {
            Pat::Lit(e)
        }
    }
    impl From<PatMacro> for Pat {
        fn from(e: PatMacro) -> Pat {
            Pat::Macro(e)
        }
    }
    impl From<PatOr> for Pat {
        fn from(e: PatOr) -> Pat {
            Pat::Or(e)
        }
    }
    impl From<PatPath> for Pat {
        fn from(e: PatPath) -> Pat {
            Pat::Path(e)
        }
    }
    impl From<PatRange> for Pat {
        fn from(e: PatRange) -> Pat {
            Pat::Range(e)
        }
    }
    impl From<PatReference> for Pat {
        fn from(e: PatReference) -> Pat {
            Pat::Reference(e)
        }
    }
    impl From<PatRest> for Pat {
        fn from(e: PatRest) -> Pat {
            Pat::Rest(e)
        }
    }
    impl From<PatSlice> for Pat {
        fn from(e: PatSlice) -> Pat {
            Pat::Slice(e)
        }
    }
    impl From<PatStruct> for Pat {
        fn from(e: PatStruct) -> Pat {
            Pat::Struct(e)
        }
    }
    impl From<PatTuple> for Pat {
        fn from(e: PatTuple) -> Pat {
            Pat::Tuple(e)
        }
    }
    impl From<PatTupleStruct> for Pat {
        fn from(e: PatTupleStruct) -> Pat {
            Pat::TupleStruct(e)
        }
    }
    impl From<PatType> for Pat {
        fn from(e: PatType) -> Pat {
            Pat::Type(e)
        }
    }
    impl From<PatWild> for Pat {
        fn from(e: PatWild) -> Pat {
            Pat::Wild(e)
        }
    }
    impl ::quote::ToTokens for Pat {
        fn to_tokens(&self, tokens: &mut ::proc_macro2::TokenStream) {
            match self {
                Pat::Box(_e) => _e.to_tokens(tokens),
                Pat::Ident(_e) => _e.to_tokens(tokens),
                Pat::Lit(_e) => _e.to_tokens(tokens),
                Pat::Macro(_e) => _e.to_tokens(tokens),
                Pat::Or(_e) => _e.to_tokens(tokens),
                Pat::Path(_e) => _e.to_tokens(tokens),
                Pat::Range(_e) => _e.to_tokens(tokens),
                Pat::Reference(_e) => _e.to_tokens(tokens),
                Pat::Rest(_e) => _e.to_tokens(tokens),
                Pat::Slice(_e) => _e.to_tokens(tokens),
                Pat::Struct(_e) => _e.to_tokens(tokens),
                Pat::Tuple(_e) => _e.to_tokens(tokens),
                Pat::TupleStruct(_e) => _e.to_tokens(tokens),
                Pat::Type(_e) => _e.to_tokens(tokens),
                Pat::Verbatim(_e) => _e.to_tokens(tokens),
                Pat::Wild(_e) => _e.to_tokens(tokens),
            }
        }
    }
    pub struct PatBox {
        pub attrs: Vec<Attribute>,
        pub box_token: crate::token::Box,
        pub pat: Box<Pat>,
    }
    pub struct PatIdent {
        pub attrs: Vec<Attribute>,
        pub by_ref: Option<crate::token::Ref>,
        pub mutability: Option<crate::token::Mut>,
        pub ident: Ident,
        pub subpat: Option<(crate::token::At, Box<Pat>)>,
    }
    pub struct PatLit {
        pub attrs: Vec<Attribute>,
        pub expr: Box<Expr>,
    }
    pub struct PatMacro {
        pub attrs: Vec<Attribute>,
        pub mac: Macro,
    }
    pub struct PatOr {
        pub attrs: Vec<Attribute>,
        pub leading_vert: Option<crate::token::Or>,
        pub cases: Punctuated<Pat, crate::token::Or>,
    }
    pub struct PatPath {
        pub attrs: Vec<Attribute>,
        pub qself: Option<QSelf>,
        pub path: Path,
    }
    pub struct PatRange {
        pub attrs: Vec<Attribute>,
        pub lo: Box<Expr>,
        pub limits: RangeLimits,
        pub hi: Box<Expr>,
    }
    pub struct PatReference {
        pub attrs: Vec<Attribute>,
        pub and_token: crate::token::And,
        pub mutability: Option<crate::token::Mut>,
        pub pat: Box<Pat>,
    }
    pub struct PatRest {
        pub attrs: Vec<Attribute>,
        pub dot2_token: crate::token::Dot2,
    }
    pub struct PatSlice {
        pub attrs: Vec<Attribute>,
        pub bracket_token: token::Bracket,
        pub elems: Punctuated<Pat, crate::token::Comma>,
    }
    pub struct PatStruct {
        pub attrs: Vec<Attribute>,
        pub path: Path,
        pub brace_token: token::Brace,
        pub fields: Punctuated<FieldPat, crate::token::Comma>,
        pub dot2_token: Option<crate::token::Dot2>,
    }
    pub struct PatTuple {
        pub attrs: Vec<Attribute>,
        pub paren_token: token::Paren,
        pub elems: Punctuated<Pat, crate::token::Comma>,
    }
    pub struct PatTupleStruct {
        pub attrs: Vec<Attribute>,
        pub path: Path,
        pub pat: PatTuple,
    }
    pub struct PatType {
        pub attrs: Vec<Attribute>,
        pub pat: Box<Pat>,
        pub colon_token: crate::token::Colon,
        pub ty: Box<Type>,
    }
    pub struct PatWild {
        pub attrs: Vec<Attribute>,
        pub underscore_token: crate::token::Underscore,
    }
    pub struct FieldPat {
        pub attrs: Vec<Attribute>,
        pub member: Member,
        pub colon_token: Option<crate::token::Colon>,
        pub pat: Box<Pat>,
    }
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use super::*;
        use crate::ext::IdentExt;
        use crate::parse::{Parse, ParseBuffer, ParseStream, Result};
        use crate::path;
        impl Parse for Pat {
            fn parse(input: ParseStream) -> Result<Self> {
                let begin = input.fork();
                let lookahead = input.lookahead1();
                if {
                    let ahead = input.fork();
                    ahead.parse::<Option<Ident>>()?.is_some()
                        && (ahead.peek(crate::token::Colon2)
                            || ahead.peek(crate::token::Bang) || ahead.peek(token::Brace)
                            || ahead.peek(token::Paren)
                            || ahead.peek(crate::token::Dot2)
                                && ahead.parse::<RangeLimits>().is_ok()
                                && !(ahead.is_empty() || ahead.peek(crate::token::Comma)))
                }
                    || {
                        let ahead = input.fork();
                        ahead.parse::<Option<crate::token::SelfValue>>()?.is_some()
                            && ahead.peek(crate::token::Colon2)
                    } || lookahead.peek(crate::token::Colon2)
                    || lookahead.peek(crate::token::Lt)
                    || input.peek(crate::token::SelfType)
                    || input.peek(crate::token::Super) || input.peek(crate::token::Crate)
                {
                    pat_path_or_macro_or_struct_or_range(input)
                } else if lookahead.peek(crate::token::Underscore) {
                    input.call(pat_wild).map(Pat::Wild)
                } else if input.peek(crate::token::Box) {
                    input.call(pat_box).map(Pat::Box)
                } else if input.peek(crate::token::Sub) || lookahead.peek(Lit)
                    || lookahead.peek(crate::token::Const)
                {
                    pat_lit_or_range(input)
                } else if lookahead.peek(crate::token::Ref)
                    || lookahead.peek(crate::token::Mut)
                    || input.peek(crate::token::SelfValue) || input.peek(Ident)
                {
                    input.call(pat_ident).map(Pat::Ident)
                } else if lookahead.peek(crate::token::And) {
                    input.call(pat_reference).map(Pat::Reference)
                } else if lookahead.peek(token::Paren) {
                    input.call(pat_tuple).map(Pat::Tuple)
                } else if lookahead.peek(token::Bracket) {
                    input.call(pat_slice).map(Pat::Slice)
                } else if lookahead.peek(crate::token::Dot2)
                    && !input.peek(crate::token::Dot3)
                {
                    pat_range_half_open(input, begin)
                } else if lookahead.peek(crate::token::Const) {
                    input.call(pat_const).map(Pat::Verbatim)
                } else {
                    Err(lookahead.error())
                }
            }
        }
        fn pat_path_or_macro_or_struct_or_range(input: ParseStream) -> Result<Pat> {
            let begin = input.fork();
            let (qself, path) = path::parsing::qpath(input, true)?;
            if qself.is_none() && input.peek(crate::token::Bang)
                && !input.peek(crate::token::Ne)
            {
                let mut contains_arguments = false;
                for segment in &path.segments {
                    match segment.arguments {
                        PathArguments::None => {}
                        PathArguments::AngleBracketed(_)
                        | PathArguments::Parenthesized(_) => {
                            contains_arguments = true;
                        }
                    }
                }
                if !contains_arguments {
                    let bang_token: crate::token::Bang = input.parse()?;
                    let (delimiter, tokens) = mac::parse_delimiter(input)?;
                    return Ok(
                        Pat::Macro(PatMacro {
                            attrs: Vec::new(),
                            mac: Macro {
                                path,
                                bang_token,
                                delimiter,
                                tokens,
                            },
                        }),
                    );
                }
            }
            if input.peek(token::Brace) {
                let pat = pat_struct(input, path)?;
                if qself.is_some() {
                    Ok(Pat::Verbatim(verbatim::between(begin, input)))
                } else {
                    Ok(Pat::Struct(pat))
                }
            } else if input.peek(token::Paren) {
                let pat = pat_tuple_struct(input, path)?;
                if qself.is_some() {
                    Ok(Pat::Verbatim(verbatim::between(begin, input)))
                } else {
                    Ok(Pat::TupleStruct(pat))
                }
            } else if input.peek(crate::token::Dot2) {
                pat_range(input, begin, qself, path)
            } else {
                Ok(
                    Pat::Path(PatPath {
                        attrs: Vec::new(),
                        qself,
                        path,
                    }),
                )
            }
        }
        fn pat_wild(input: ParseStream) -> Result<PatWild> {
            Ok(PatWild {
                attrs: Vec::new(),
                underscore_token: input.parse()?,
            })
        }
        fn pat_box(input: ParseStream) -> Result<PatBox> {
            Ok(PatBox {
                attrs: Vec::new(),
                box_token: input.parse()?,
                pat: input.parse()?,
            })
        }
        fn pat_ident(input: ParseStream) -> Result<PatIdent> {
            Ok(PatIdent {
                attrs: Vec::new(),
                by_ref: input.parse()?,
                mutability: input.parse()?,
                ident: input.call(Ident::parse_any)?,
                subpat: {
                    if input.peek(crate::token::At) {
                        let at_token: crate::token::At = input.parse()?;
                        let subpat: Pat = input.parse()?;
                        Some((at_token, Box::new(subpat)))
                    } else {
                        None
                    }
                },
            })
        }
        fn pat_tuple_struct(input: ParseStream, path: Path) -> Result<PatTupleStruct> {
            Ok(PatTupleStruct {
                attrs: Vec::new(),
                path,
                pat: input.call(pat_tuple)?,
            })
        }
        fn pat_struct(input: ParseStream, path: Path) -> Result<PatStruct> {
            let content;
            let brace_token = match crate::group::parse_braces(&input) {
                crate::__private::Ok(braces) => {
                    content = braces.content;
                    braces.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
            let mut fields = Punctuated::new();
            while !content.is_empty() && !content.peek(crate::token::Dot2) {
                let value = content.call(field_pat)?;
                fields.push_value(value);
                if content.is_empty() {
                    break;
                }
                let punct: crate::token::Comma = content.parse()?;
                fields.push_punct(punct);
            }
            let dot2_token = if fields.empty_or_trailing()
                && content.peek(crate::token::Dot2)
            {
                Some(content.parse()?)
            } else {
                None
            };
            Ok(PatStruct {
                attrs: Vec::new(),
                path,
                brace_token,
                fields,
                dot2_token,
            })
        }
        impl Member {
            fn is_unnamed(&self) -> bool {
                match *self {
                    Member::Named(_) => false,
                    Member::Unnamed(_) => true,
                }
            }
        }
        fn field_pat(input: ParseStream) -> Result<FieldPat> {
            let attrs = input.call(Attribute::parse_outer)?;
            let boxed: Option<crate::token::Box> = input.parse()?;
            let by_ref: Option<crate::token::Ref> = input.parse()?;
            let mutability: Option<crate::token::Mut> = input.parse()?;
            let member: Member = input.parse()?;
            if boxed.is_none() && by_ref.is_none() && mutability.is_none()
                && input.peek(crate::token::Colon) || member.is_unnamed()
            {
                return Ok(FieldPat {
                    attrs,
                    member,
                    colon_token: input.parse()?,
                    pat: Box::new(multi_pat_with_leading_vert(input)?),
                });
            }
            let ident = match member {
                Member::Named(ident) => ident,
                Member::Unnamed(_) => {
                    ::core::panicking::panic("internal error: entered unreachable code")
                }
            };
            let mut pat = Pat::Ident(PatIdent {
                attrs: Vec::new(),
                by_ref,
                mutability,
                ident: ident.clone(),
                subpat: None,
            });
            if let Some(boxed) = boxed {
                pat = Pat::Box(PatBox {
                    attrs: Vec::new(),
                    box_token: boxed,
                    pat: Box::new(pat),
                });
            }
            Ok(FieldPat {
                attrs,
                member: Member::Named(ident),
                colon_token: None,
                pat: Box::new(pat),
            })
        }
        fn pat_range(
            input: ParseStream,
            begin: ParseBuffer,
            qself: Option<QSelf>,
            path: Path,
        ) -> Result<Pat> {
            let limits: RangeLimits = input.parse()?;
            let hi = input.call(pat_lit_expr)?;
            if let Some(hi) = hi {
                Ok(
                    Pat::Range(PatRange {
                        attrs: Vec::new(),
                        lo: Box::new(
                            Expr::Path(ExprPath {
                                attrs: Vec::new(),
                                qself,
                                path,
                            }),
                        ),
                        limits,
                        hi,
                    }),
                )
            } else {
                Ok(Pat::Verbatim(verbatim::between(begin, input)))
            }
        }
        fn pat_range_half_open(input: ParseStream, begin: ParseBuffer) -> Result<Pat> {
            let limits: RangeLimits = input.parse()?;
            let hi = input.call(pat_lit_expr)?;
            if hi.is_some() {
                Ok(Pat::Verbatim(verbatim::between(begin, input)))
            } else {
                match limits {
                    RangeLimits::HalfOpen(dot2_token) => {
                        Ok(
                            Pat::Rest(PatRest {
                                attrs: Vec::new(),
                                dot2_token,
                            }),
                        )
                    }
                    RangeLimits::Closed(_) => {
                        Err(input.error("expected range upper bound"))
                    }
                }
            }
        }
        fn pat_tuple(input: ParseStream) -> Result<PatTuple> {
            let content;
            let paren_token = match crate::group::parse_parens(&input) {
                crate::__private::Ok(parens) => {
                    content = parens.content;
                    parens.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
            let mut elems = Punctuated::new();
            while !content.is_empty() {
                let value = multi_pat_with_leading_vert(&content)?;
                elems.push_value(value);
                if content.is_empty() {
                    break;
                }
                let punct = content.parse()?;
                elems.push_punct(punct);
            }
            Ok(PatTuple {
                attrs: Vec::new(),
                paren_token,
                elems,
            })
        }
        fn pat_reference(input: ParseStream) -> Result<PatReference> {
            Ok(PatReference {
                attrs: Vec::new(),
                and_token: input.parse()?,
                mutability: input.parse()?,
                pat: input.parse()?,
            })
        }
        fn pat_lit_or_range(input: ParseStream) -> Result<Pat> {
            let begin = input.fork();
            let lo = input.call(pat_lit_expr)?.unwrap();
            if input.peek(crate::token::Dot2) {
                let limits: RangeLimits = input.parse()?;
                let hi = input.call(pat_lit_expr)?;
                if let Some(hi) = hi {
                    Ok(
                        Pat::Range(PatRange {
                            attrs: Vec::new(),
                            lo,
                            limits,
                            hi,
                        }),
                    )
                } else {
                    Ok(Pat::Verbatim(verbatim::between(begin, input)))
                }
            } else if let Expr::Verbatim(verbatim) = *lo {
                Ok(Pat::Verbatim(verbatim))
            } else {
                Ok(
                    Pat::Lit(PatLit {
                        attrs: Vec::new(),
                        expr: lo,
                    }),
                )
            }
        }
        fn pat_lit_expr(input: ParseStream) -> Result<Option<Box<Expr>>> {
            if input.is_empty() || input.peek(crate::token::Or)
                || input.peek(crate::token::Eq)
                || input.peek(crate::token::Colon) && !input.peek(crate::token::Colon2)
                || input.peek(crate::token::Comma) || input.peek(crate::token::Semi)
            {
                return Ok(None);
            }
            let neg: Option<crate::token::Sub> = input.parse()?;
            let lookahead = input.lookahead1();
            let expr = if lookahead.peek(Lit) {
                Expr::Lit(input.parse()?)
            } else if lookahead.peek(Ident) || lookahead.peek(crate::token::Colon2)
                || lookahead.peek(crate::token::Lt)
                || lookahead.peek(crate::token::SelfValue)
                || lookahead.peek(crate::token::SelfType)
                || lookahead.peek(crate::token::Super)
                || lookahead.peek(crate::token::Crate)
            {
                Expr::Path(input.parse()?)
            } else if lookahead.peek(crate::token::Const) {
                Expr::Verbatim(input.call(expr::parsing::expr_const)?)
            } else {
                return Err(lookahead.error());
            };
            Ok(
                Some(
                    Box::new(
                        if let Some(neg) = neg {
                            Expr::Unary(ExprUnary {
                                attrs: Vec::new(),
                                op: UnOp::Neg(neg),
                                expr: Box::new(expr),
                            })
                        } else {
                            expr
                        },
                    ),
                ),
            )
        }
        fn pat_slice(input: ParseStream) -> Result<PatSlice> {
            let content;
            let bracket_token = match crate::group::parse_brackets(&input) {
                crate::__private::Ok(brackets) => {
                    content = brackets.content;
                    brackets.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
            let mut elems = Punctuated::new();
            while !content.is_empty() {
                let value = multi_pat_with_leading_vert(&content)?;
                elems.push_value(value);
                if content.is_empty() {
                    break;
                }
                let punct = content.parse()?;
                elems.push_punct(punct);
            }
            Ok(PatSlice {
                attrs: Vec::new(),
                bracket_token,
                elems,
            })
        }
        fn pat_const(input: ParseStream) -> Result<TokenStream> {
            let begin = input.fork();
            input.parse::<crate::token::Const>()?;
            let content;
            match crate::group::parse_braces(&input) {
                crate::__private::Ok(braces) => {
                    content = braces.content;
                    braces.token
                }
                crate::__private::Err(error) => {
                    return crate::__private::Err(error);
                }
            };
            content.call(Attribute::parse_inner)?;
            content.call(Block::parse_within)?;
            Ok(verbatim::between(begin, input))
        }
        pub fn multi_pat(input: ParseStream) -> Result<Pat> {
            multi_pat_impl(input, None)
        }
        pub fn multi_pat_with_leading_vert(input: ParseStream) -> Result<Pat> {
            let leading_vert: Option<crate::token::Or> = input.parse()?;
            multi_pat_impl(input, leading_vert)
        }
        fn multi_pat_impl(
            input: ParseStream,
            leading_vert: Option<crate::token::Or>,
        ) -> Result<Pat> {
            let mut pat: Pat = input.parse()?;
            if leading_vert.is_some()
                || input.peek(crate::token::Or) && !input.peek(crate::token::OrOr)
                    && !input.peek(crate::token::OrEq)
            {
                let mut cases = Punctuated::new();
                cases.push_value(pat);
                while input.peek(crate::token::Or) && !input.peek(crate::token::OrOr)
                    && !input.peek(crate::token::OrEq)
                {
                    let punct = input.parse()?;
                    cases.push_punct(punct);
                    let pat: Pat = input.parse()?;
                    cases.push_value(pat);
                }
                pat = Pat::Or(PatOr {
                    attrs: Vec::new(),
                    leading_vert,
                    cases,
                });
            }
            Ok(pat)
        }
    }
    #[cfg(feature = "printing")]
    mod printing {
        use super::*;
        use crate::attr::FilterAttrs;
        use proc_macro2::TokenStream;
        use quote::{ToTokens, TokenStreamExt};
        impl ToTokens for PatWild {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.underscore_token.to_tokens(tokens);
            }
        }
        impl ToTokens for PatIdent {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.by_ref.to_tokens(tokens);
                self.mutability.to_tokens(tokens);
                self.ident.to_tokens(tokens);
                if let Some((at_token, subpat)) = &self.subpat {
                    at_token.to_tokens(tokens);
                    subpat.to_tokens(tokens);
                }
            }
        }
        impl ToTokens for PatStruct {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.path.to_tokens(tokens);
                self.brace_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.fields.to_tokens(tokens);
                            if !self.fields.empty_or_trailing()
                                && self.dot2_token.is_some()
                            {
                                <crate::token::Comma>::default().to_tokens(tokens);
                            }
                            self.dot2_token.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for PatTupleStruct {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.path.to_tokens(tokens);
                self.pat.to_tokens(tokens);
            }
        }
        impl ToTokens for PatType {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.pat.to_tokens(tokens);
                self.colon_token.to_tokens(tokens);
                self.ty.to_tokens(tokens);
            }
        }
        impl ToTokens for PatPath {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                path::printing::print_path(tokens, &self.qself, &self.path);
            }
        }
        impl ToTokens for PatTuple {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.paren_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.elems.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for PatBox {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.box_token.to_tokens(tokens);
                self.pat.to_tokens(tokens);
            }
        }
        impl ToTokens for PatReference {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.and_token.to_tokens(tokens);
                self.mutability.to_tokens(tokens);
                self.pat.to_tokens(tokens);
            }
        }
        impl ToTokens for PatRest {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.dot2_token.to_tokens(tokens);
            }
        }
        impl ToTokens for PatLit {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.expr.to_tokens(tokens);
            }
        }
        impl ToTokens for PatRange {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.lo.to_tokens(tokens);
                self.limits.to_tokens(tokens);
                self.hi.to_tokens(tokens);
            }
        }
        impl ToTokens for PatSlice {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.bracket_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.elems.to_tokens(tokens);
                        },
                    );
            }
        }
        impl ToTokens for PatMacro {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.mac.to_tokens(tokens);
            }
        }
        impl ToTokens for PatOr {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                self.leading_vert.to_tokens(tokens);
                self.cases.to_tokens(tokens);
            }
        }
        impl ToTokens for FieldPat {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.attrs.outer());
                if let Some(colon_token) = &self.colon_token {
                    self.member.to_tokens(tokens);
                    colon_token.to_tokens(tokens);
                }
                self.pat.to_tokens(tokens);
            }
        }
    }
}
#[cfg(feature = "full")]
pub use crate::pat::{
    FieldPat, Pat, PatBox, PatIdent, PatLit, PatMacro, PatOr, PatPath, PatRange,
    PatReference, PatRest, PatSlice, PatStruct, PatTuple, PatTupleStruct, PatType,
    PatWild,
};
#[cfg(any(feature = "full", feature = "derive"))]
mod path {
    use super::*;
    use crate::punctuated::Punctuated;
    pub struct Path {
        pub leading_colon: Option<crate::token::Colon2>,
        pub segments: Punctuated<PathSegment, crate::token::Colon2>,
    }
    impl<T> From<T> for Path
    where
        T: Into<PathSegment>,
    {
        fn from(segment: T) -> Self {
            let mut path = Path {
                leading_colon: None,
                segments: Punctuated::new(),
            };
            path.segments.push_value(segment.into());
            path
        }
    }
    pub struct PathSegment {
        pub ident: Ident,
        pub arguments: PathArguments,
    }
    impl<T> From<T> for PathSegment
    where
        T: Into<Ident>,
    {
        fn from(ident: T) -> Self {
            PathSegment {
                ident: ident.into(),
                arguments: PathArguments::None,
            }
        }
    }
    pub enum PathArguments {
        None,
        AngleBracketed(AngleBracketedGenericArguments),
        Parenthesized(ParenthesizedGenericArguments),
    }
    impl Default for PathArguments {
        fn default() -> Self {
            PathArguments::None
        }
    }
    impl PathArguments {
        pub fn is_empty(&self) -> bool {
            match self {
                PathArguments::None => true,
                PathArguments::AngleBracketed(bracketed) => bracketed.args.is_empty(),
                PathArguments::Parenthesized(_) => false,
            }
        }
        #[cfg(feature = "parsing")]
        fn is_none(&self) -> bool {
            match *self {
                PathArguments::None => true,
                PathArguments::AngleBracketed(_) | PathArguments::Parenthesized(_) => {
                    false
                }
            }
        }
    }
    pub enum GenericArgument {
        Lifetime(Lifetime),
        Type(Type),
        Binding(Binding),
        Constraint(Constraint),
        Const(Expr),
    }
    pub struct AngleBracketedGenericArguments {
        pub colon2_token: Option<crate::token::Colon2>,
        pub lt_token: crate::token::Lt,
        pub args: Punctuated<GenericArgument, crate::token::Comma>,
        pub gt_token: crate::token::Gt,
    }
    pub struct Binding {
        pub ident: Ident,
        pub eq_token: crate::token::Eq,
        pub ty: Type,
    }
    pub struct Constraint {
        pub ident: Ident,
        pub colon_token: crate::token::Colon,
        pub bounds: Punctuated<TypeParamBound, crate::token::Add>,
    }
    pub struct ParenthesizedGenericArguments {
        pub paren_token: token::Paren,
        pub inputs: Punctuated<Type, crate::token::Comma>,
        pub output: ReturnType,
    }
    pub struct QSelf {
        pub lt_token: crate::token::Lt,
        pub ty: Box<Type>,
        pub position: usize,
        pub as_token: Option<crate::token::As>,
        pub gt_token: crate::token::Gt,
    }
    #[cfg(feature = "parsing")]
    pub mod parsing {
        use super::*;
        use crate::ext::IdentExt;
        use crate::parse::{Parse, ParseStream, Result};
        impl Parse for Path {
            fn parse(input: ParseStream) -> Result<Self> {
                Self::parse_helper(input, false)
            }
        }
        impl Parse for GenericArgument {
            fn parse(input: ParseStream) -> Result<Self> {
                if input.peek(Lifetime) && !input.peek2(crate::token::Add) {
                    return Ok(GenericArgument::Lifetime(input.parse()?));
                }
                if input.peek(Ident) && input.peek2(crate::token::Eq) {
                    let ident: Ident = input.parse()?;
                    let eq_token: crate::token::Eq = input.parse()?;
                    let ty = if input.peek(Lit) {
                        let begin = input.fork();
                        input.parse::<Lit>()?;
                        Type::Verbatim(verbatim::between(begin, input))
                    } else if input.peek(token::Brace) {
                        let begin = input.fork();
                        #[cfg(feature = "full")]
                        {
                            input.parse::<ExprBlock>()?;
                        }
                        Type::Verbatim(verbatim::between(begin, input))
                    } else {
                        input.parse()?
                    };
                    return Ok(GenericArgument::Binding(Binding { ident, eq_token, ty }));
                }
                #[cfg(feature = "full")]
                {
                    if input.peek(Ident) && input.peek2(crate::token::Colon)
                        && !input.peek2(crate::token::Colon2)
                    {
                        return Ok(GenericArgument::Constraint(input.parse()?));
                    }
                }
                if input.peek(Lit) || input.peek(token::Brace) {
                    return const_argument(input).map(GenericArgument::Const);
                }
                #[cfg(feature = "full")]
                let begin = input.fork();
                let argument: Type = input.parse()?;
                #[cfg(feature = "full")]
                {
                    if match &argument {
                        Type::Path(
                            argument,
                        ) if argument.qself.is_none()
                            && argument.path.leading_colon.is_none()
                            && argument.path.segments.len() == 1 => {
                            match argument.path.segments[0].arguments {
                                PathArguments::AngleBracketed(_) => true,
                                _ => false,
                            }
                        }
                        _ => false,
                    }
                        && if input.peek(crate::token::Eq) {
                            input.parse::<crate::token::Eq>()?;
                            input.parse::<Type>()?;
                            true
                        } else if input.peek(crate::token::Colon) {
                            input.parse::<crate::token::Colon>()?;
                            input.call(constraint_bounds)?;
                            true
                        } else {
                            false
                        }
                    {
                        let verbatim = verbatim::between(begin, input);
                        return Ok(GenericArgument::Type(Type::Verbatim(verbatim)));
                    }
                }
                Ok(GenericArgument::Type(argument))
            }
        }
        pub fn const_argument(input: ParseStream) -> Result<Expr> {
            let lookahead = input.lookahead1();
            if input.peek(Lit) {
                let lit = input.parse()?;
                return Ok(Expr::Lit(lit));
            }
            #[cfg(feature = "full")]
            {
                if input.peek(Ident) {
                    let ident: Ident = input.parse()?;
                    return Ok(
                        Expr::Path(ExprPath {
                            attrs: Vec::new(),
                            qself: None,
                            path: Path::from(ident),
                        }),
                    );
                }
            }
            if input.peek(token::Brace) {
                #[cfg(feature = "full")]
                {
                    let block: ExprBlock = input.parse()?;
                    return Ok(Expr::Block(block));
                }
            }
            Err(lookahead.error())
        }
        impl Parse for AngleBracketedGenericArguments {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(AngleBracketedGenericArguments {
                    colon2_token: input.parse()?,
                    lt_token: input.parse()?,
                    args: {
                        let mut args = Punctuated::new();
                        loop {
                            if input.peek(crate::token::Gt) {
                                break;
                            }
                            let value = input.parse()?;
                            args.push_value(value);
                            if input.peek(crate::token::Gt) {
                                break;
                            }
                            let punct = input.parse()?;
                            args.push_punct(punct);
                        }
                        args
                    },
                    gt_token: input.parse()?,
                })
            }
        }
        impl Parse for ParenthesizedGenericArguments {
            fn parse(input: ParseStream) -> Result<Self> {
                let content;
                Ok(ParenthesizedGenericArguments {
                    paren_token: match crate::group::parse_parens(&input) {
                        crate::__private::Ok(parens) => {
                            content = parens.content;
                            parens.token
                        }
                        crate::__private::Err(error) => {
                            return crate::__private::Err(error);
                        }
                    },
                    inputs: content.parse_terminated(Type::parse)?,
                    output: input.call(ReturnType::without_plus)?,
                })
            }
        }
        impl Parse for PathSegment {
            fn parse(input: ParseStream) -> Result<Self> {
                Self::parse_helper(input, false)
            }
        }
        impl PathSegment {
            fn parse_helper(input: ParseStream, expr_style: bool) -> Result<Self> {
                if input.peek(crate::token::Super) || input.peek(crate::token::SelfValue)
                    || input.peek(crate::token::Crate)
                {
                    let ident = input.call(Ident::parse_any)?;
                    return Ok(PathSegment::from(ident));
                }
                let ident = if input.peek(crate::token::SelfType) {
                    input.call(Ident::parse_any)?
                } else {
                    input.parse()?
                };
                if !expr_style && input.peek(crate::token::Lt)
                    && !input.peek(crate::token::Le)
                    || input.peek(crate::token::Colon2) && input.peek3(crate::token::Lt)
                {
                    Ok(PathSegment {
                        ident,
                        arguments: PathArguments::AngleBracketed(input.parse()?),
                    })
                } else {
                    Ok(PathSegment::from(ident))
                }
            }
        }
        impl Parse for Binding {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(Binding {
                    ident: input.parse()?,
                    eq_token: input.parse()?,
                    ty: input.parse()?,
                })
            }
        }
        #[cfg(feature = "full")]
        impl Parse for Constraint {
            fn parse(input: ParseStream) -> Result<Self> {
                Ok(Constraint {
                    ident: input.parse()?,
                    colon_token: input.parse()?,
                    bounds: constraint_bounds(input)?,
                })
            }
        }
        #[cfg(feature = "full")]
        fn constraint_bounds(
            input: ParseStream,
        ) -> Result<Punctuated<TypeParamBound, crate::token::Add>> {
            let mut bounds = Punctuated::new();
            loop {
                if input.peek(crate::token::Comma) || input.peek(crate::token::Gt) {
                    break;
                }
                let value = input.parse()?;
                bounds.push_value(value);
                if !input.peek(crate::token::Add) {
                    break;
                }
                let punct = input.parse()?;
                bounds.push_punct(punct);
            }
            Ok(bounds)
        }
        impl Path {
            pub fn parse_mod_style(input: ParseStream) -> Result<Self> {
                Ok(Path {
                    leading_colon: input.parse()?,
                    segments: {
                        let mut segments = Punctuated::new();
                        loop {
                            if !input.peek(Ident) && !input.peek(crate::token::Super)
                                && !input.peek(crate::token::SelfValue)
                                && !input.peek(crate::token::SelfType)
                                && !input.peek(crate::token::Crate)
                            {
                                break;
                            }
                            let ident = Ident::parse_any(input)?;
                            segments.push_value(PathSegment::from(ident));
                            if !input.peek(crate::token::Colon2) {
                                break;
                            }
                            let punct = input.parse()?;
                            segments.push_punct(punct);
                        }
                        if segments.is_empty() {
                            return Err(input.error("expected path"));
                        } else if segments.trailing_punct() {
                            return Err(input.error("expected path segment"));
                        }
                        segments
                    },
                })
            }
            pub fn is_ident<I: ?Sized>(&self, ident: &I) -> bool
            where
                Ident: PartialEq<I>,
            {
                match self.get_ident() {
                    Some(id) => id == ident,
                    None => false,
                }
            }
            pub fn get_ident(&self) -> Option<&Ident> {
                if self.leading_colon.is_none() && self.segments.len() == 1
                    && self.segments[0].arguments.is_none()
                {
                    Some(&self.segments[0].ident)
                } else {
                    None
                }
            }
            pub(crate) fn parse_helper(
                input: ParseStream,
                expr_style: bool,
            ) -> Result<Self> {
                let mut path = Path {
                    leading_colon: input.parse()?,
                    segments: {
                        let mut segments = Punctuated::new();
                        let value = PathSegment::parse_helper(input, expr_style)?;
                        segments.push_value(value);
                        segments
                    },
                };
                Path::parse_rest(input, &mut path, expr_style)?;
                Ok(path)
            }
            pub(crate) fn parse_rest(
                input: ParseStream,
                path: &mut Self,
                expr_style: bool,
            ) -> Result<()> {
                while input.peek(crate::token::Colon2) && !input.peek3(token::Paren) {
                    let punct: crate::token::Colon2 = input.parse()?;
                    path.segments.push_punct(punct);
                    let value = PathSegment::parse_helper(input, expr_style)?;
                    path.segments.push_value(value);
                }
                Ok(())
            }
        }
        pub fn qpath(
            input: ParseStream,
            expr_style: bool,
        ) -> Result<(Option<QSelf>, Path)> {
            if input.peek(crate::token::Lt) {
                let lt_token: crate::token::Lt = input.parse()?;
                let this: Type = input.parse()?;
                let path = if input.peek(crate::token::As) {
                    let as_token: crate::token::As = input.parse()?;
                    let path: Path = input.parse()?;
                    Some((as_token, path))
                } else {
                    None
                };
                let gt_token: crate::token::Gt = input.parse()?;
                let colon2_token: crate::token::Colon2 = input.parse()?;
                let mut rest = Punctuated::new();
                loop {
                    let path = PathSegment::parse_helper(input, expr_style)?;
                    rest.push_value(path);
                    if !input.peek(crate::token::Colon2) {
                        break;
                    }
                    let punct: crate::token::Colon2 = input.parse()?;
                    rest.push_punct(punct);
                }
                let (position, as_token, path) = match path {
                    Some((as_token, mut path)) => {
                        let pos = path.segments.len();
                        path.segments.push_punct(colon2_token);
                        path.segments.extend(rest.into_pairs());
                        (pos, Some(as_token), path)
                    }
                    None => {
                        let path = Path {
                            leading_colon: Some(colon2_token),
                            segments: rest,
                        };
                        (0, None, path)
                    }
                };
                let qself = QSelf {
                    lt_token,
                    ty: Box::new(this),
                    position,
                    as_token,
                    gt_token,
                };
                Ok((Some(qself), path))
            } else {
                let path = Path::parse_helper(input, expr_style)?;
                Ok((None, path))
            }
        }
    }
    #[cfg(feature = "printing")]
    pub(crate) mod printing {
        use super::*;
        use crate::print::TokensOrDefault;
        use proc_macro2::TokenStream;
        use quote::ToTokens;
        use std::cmp;
        impl ToTokens for Path {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.leading_colon.to_tokens(tokens);
                self.segments.to_tokens(tokens);
            }
        }
        impl ToTokens for PathSegment {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.ident.to_tokens(tokens);
                self.arguments.to_tokens(tokens);
            }
        }
        impl ToTokens for PathArguments {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                match self {
                    PathArguments::None => {}
                    PathArguments::AngleBracketed(arguments) => {
                        arguments.to_tokens(tokens);
                    }
                    PathArguments::Parenthesized(arguments) => {
                        arguments.to_tokens(tokens);
                    }
                }
            }
        }
        impl ToTokens for GenericArgument {
            #[allow(clippy::match_same_arms)]
            fn to_tokens(&self, tokens: &mut TokenStream) {
                match self {
                    GenericArgument::Lifetime(lt) => lt.to_tokens(tokens),
                    GenericArgument::Type(ty) => ty.to_tokens(tokens),
                    GenericArgument::Binding(tb) => tb.to_tokens(tokens),
                    GenericArgument::Constraint(tc) => tc.to_tokens(tokens),
                    GenericArgument::Const(e) => {
                        match *e {
                            Expr::Lit(_) => e.to_tokens(tokens),
                            #[cfg(feature = "full")]
                            Expr::Block(_) => e.to_tokens(tokens),
                            _ => {
                                token::Brace::default()
                                    .surround(
                                        tokens,
                                        |tokens| {
                                            e.to_tokens(tokens);
                                        },
                                    )
                            }
                        }
                    }
                }
            }
        }
        impl ToTokens for AngleBracketedGenericArguments {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.colon2_token.to_tokens(tokens);
                self.lt_token.to_tokens(tokens);
                let mut trailing_or_empty = true;
                for param in self.args.pairs() {
                    match **param.value() {
                        GenericArgument::Lifetime(_) => {
                            param.to_tokens(tokens);
                            trailing_or_empty = param.punct().is_some();
                        }
                        GenericArgument::Type(_)
                        | GenericArgument::Binding(_)
                        | GenericArgument::Constraint(_)
                        | GenericArgument::Const(_) => {}
                    }
                }
                for param in self.args.pairs() {
                    match **param.value() {
                        GenericArgument::Type(_) | GenericArgument::Const(_) => {
                            if !trailing_or_empty {
                                <crate::token::Comma>::default().to_tokens(tokens);
                            }
                            param.to_tokens(tokens);
                            trailing_or_empty = param.punct().is_some();
                        }
                        GenericArgument::Lifetime(_)
                        | GenericArgument::Binding(_)
                        | GenericArgument::Constraint(_) => {}
                    }
                }
                for param in self.args.pairs() {
                    match **param.value() {
                        GenericArgument::Binding(_) | GenericArgument::Constraint(_) => {
                            if !trailing_or_empty {
                                <crate::token::Comma>::default().to_tokens(tokens);
                            }
                            param.to_tokens(tokens);
                            trailing_or_empty = param.punct().is_some();
                        }
                        GenericArgument::Lifetime(_)
                        | GenericArgument::Type(_)
                        | GenericArgument::Const(_) => {}
                    }
                }
                self.gt_token.to_tokens(tokens);
            }
        }
        impl ToTokens for Binding {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.ident.to_tokens(tokens);
                self.eq_token.to_tokens(tokens);
                self.ty.to_tokens(tokens);
            }
        }
        impl ToTokens for Constraint {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.ident.to_tokens(tokens);
                self.colon_token.to_tokens(tokens);
                self.bounds.to_tokens(tokens);
            }
        }
        impl ToTokens for ParenthesizedGenericArguments {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                self.paren_token
                    .surround(
                        tokens,
                        |tokens| {
                            self.inputs.to_tokens(tokens);
                        },
                    );
                self.output.to_tokens(tokens);
            }
        }
        pub(crate) fn print_path(
            tokens: &mut TokenStream,
            qself: &Option<QSelf>,
            path: &Path,
        ) {
            let qself = match qself {
                Some(qself) => qself,
                None => {
                    path.to_tokens(tokens);
                    return;
                }
            };
            qself.lt_token.to_tokens(tokens);
            qself.ty.to_tokens(tokens);
            let pos = cmp::min(qself.position, path.segments.len());
            let mut segments = path.segments.pairs();
            if pos > 0 {
                TokensOrDefault(&qself.as_token).to_tokens(tokens);
                path.leading_colon.to_tokens(tokens);
                for (i, segment) in segments.by_ref().take(pos).enumerate() {
                    if i + 1 == pos {
                        segment.value().to_tokens(tokens);
                        qself.gt_token.to_tokens(tokens);
                        segment.punct().to_tokens(tokens);
                    } else {
                        segment.to_tokens(tokens);
                    }
                }
            } else {
                qself.gt_token.to_tokens(tokens);
                path.leading_colon.to_tokens(tokens);
            }
            for segment in segments {
                segment.to_tokens(tokens);
            }
        }
    }
}
#[cfg(any(feature = "full", feature = "derive"))]
pub use crate::path::{
    AngleBracketedGenericArguments, Binding, Constraint, GenericArgument,
    ParenthesizedGenericArguments, Path, PathArguments, PathSegment, QSelf,
};
#[cfg(feature = "parsing")]
pub mod buffer {
    #[cfg(
        all(
            not(
                all(
                    target_arch = "wasm32",
                    any(target_os = "unknown", target_os = "wasi")
                )
            ),
            feature = "proc-macro"
        )
    )]
    use crate::proc_macro as pm;
    use crate::Lifetime;
    use proc_macro2::{
        Delimiter, Group, Ident, Literal, Punct, Spacing, Span, TokenStream, TokenTree,
    };
    use std::marker::PhantomData;
    use std::ptr;
    use std::slice;
    enum Entry {
        Group(Group, TokenBuffer),
        Ident(Ident),
        Punct(Punct),
        Literal(Literal),
        End(*const Entry),
    }
    pub struct TokenBuffer {
        ptr: *const Entry,
        len: usize,
    }
    impl Drop for TokenBuffer {
        fn drop(&mut self) {
            unsafe {
                let slice = slice::from_raw_parts_mut(self.ptr as *mut Entry, self.len);
                let _ = Box::from_raw(slice);
            }
        }
    }
    impl TokenBuffer {
        fn inner_new(stream: TokenStream, up: *const Entry) -> TokenBuffer {
            let mut entries = Vec::new();
            let mut groups = Vec::new();
            for tt in stream {
                match tt {
                    TokenTree::Ident(sym) => {
                        entries.push(Entry::Ident(sym));
                    }
                    TokenTree::Punct(op) => {
                        entries.push(Entry::Punct(op));
                    }
                    TokenTree::Literal(l) => {
                        entries.push(Entry::Literal(l));
                    }
                    TokenTree::Group(g) => {
                        groups.push((entries.len(), g));
                        entries.push(Entry::End(ptr::null()));
                    }
                }
            }
            entries.push(Entry::End(up));
            let entries = entries.into_boxed_slice();
            let len = entries.len();
            let entries = Box::into_raw(entries) as *mut Entry;
            for (idx, group) in groups {
                let group_up = unsafe { entries.add(idx + 1) };
                let inner = Self::inner_new(group.stream(), group_up);
                unsafe { *entries.add(idx) = Entry::Group(group, inner) };
            }
            TokenBuffer { ptr: entries, len }
        }
        #[cfg(
            all(
                not(
                    all(
                        target_arch = "wasm32",
                        any(target_os = "unknown", target_os = "wasi")
                    )
                ),
                feature = "proc-macro"
            )
        )]
        pub fn new(stream: pm::TokenStream) -> Self {
            Self::new2(stream.into())
        }
        pub fn new2(stream: TokenStream) -> Self {
            Self::inner_new(stream, ptr::null())
        }
        pub fn begin(&self) -> Cursor {
            unsafe { Cursor::create(self.ptr, self.ptr.add(self.len - 1)) }
        }
    }
    pub struct Cursor<'a> {
        ptr: *const Entry,
        scope: *const Entry,
        marker: PhantomData<&'a Entry>,
    }
    impl<'a> Cursor<'a> {
        pub fn empty() -> Self {
            struct UnsafeSyncEntry(Entry);
            unsafe impl Sync for UnsafeSyncEntry {}
            static EMPTY_ENTRY: UnsafeSyncEntry = UnsafeSyncEntry(
                Entry::End(0 as *const Entry),
            );
            Cursor {
                ptr: &EMPTY_ENTRY.0,
                scope: &EMPTY_ENTRY.0,
                marker: PhantomData,
            }
        }
        unsafe fn create(mut ptr: *const Entry, scope: *const Entry) -> Self {
            while let Entry::End(exit) = *ptr {
                if ptr == scope {
                    break;
                }
                ptr = exit;
            }
            Cursor {
                ptr,
                scope,
                marker: PhantomData,
            }
        }
        fn entry(self) -> &'a Entry {
            unsafe { &*self.ptr }
        }
        unsafe fn bump(self) -> Cursor<'a> {
            Cursor::create(self.ptr.offset(1), self.scope)
        }
        fn ignore_none(&mut self) {
            while let Entry::Group(group, buf) = self.entry() {
                if group.delimiter() == Delimiter::None {
                    unsafe {
                        *self = Cursor::create(buf.ptr, self.scope);
                    }
                } else {
                    break;
                }
            }
        }
        pub fn eof(self) -> bool {
            self.ptr == self.scope
        }
        pub fn group(
            mut self,
            delim: Delimiter,
        ) -> Option<(Cursor<'a>, Span, Cursor<'a>)> {
            if delim != Delimiter::None {
                self.ignore_none();
            }
            if let Entry::Group(group, buf) = self.entry() {
                if group.delimiter() == delim {
                    return Some((buf.begin(), group.span(), unsafe { self.bump() }));
                }
            }
            None
        }
        pub fn ident(mut self) -> Option<(Ident, Cursor<'a>)> {
            self.ignore_none();
            match self.entry() {
                Entry::Ident(ident) => Some((ident.clone(), unsafe { self.bump() })),
                _ => None,
            }
        }
        pub fn punct(mut self) -> Option<(Punct, Cursor<'a>)> {
            self.ignore_none();
            match self.entry() {
                Entry::Punct(op) if op.as_char() != '\'' => {
                    Some((op.clone(), unsafe { self.bump() }))
                }
                _ => None,
            }
        }
        pub fn literal(mut self) -> Option<(Literal, Cursor<'a>)> {
            self.ignore_none();
            match self.entry() {
                Entry::Literal(lit) => Some((lit.clone(), unsafe { self.bump() })),
                _ => None,
            }
        }
        pub fn lifetime(mut self) -> Option<(Lifetime, Cursor<'a>)> {
            self.ignore_none();
            match self.entry() {
                Entry::Punct(
                    op,
                ) if op.as_char() == '\'' && op.spacing() == Spacing::Joint => {
                    let next = unsafe { self.bump() };
                    match next.ident() {
                        Some((ident, rest)) => {
                            let lifetime = Lifetime {
                                apostrophe: op.span(),
                                ident,
                            };
                            Some((lifetime, rest))
                        }
                        None => None,
                    }
                }
                _ => None,
            }
        }
        pub fn token_stream(self) -> TokenStream {
            let mut tts = Vec::new();
            let mut cursor = self;
            while let Some((tt, rest)) = cursor.token_tree() {
                tts.push(tt);
                cursor = rest;
            }
            tts.into_iter().collect()
        }
        pub fn token_tree(self) -> Option<(TokenTree, Cursor<'a>)> {
            let tree = match self.entry() {
                Entry::Group(group, _) => group.clone().into(),
                Entry::Literal(lit) => lit.clone().into(),
                Entry::Ident(ident) => ident.clone().into(),
                Entry::Punct(op) => op.clone().into(),
                Entry::End(..) => return None,
            };
            Some((tree, unsafe { self.bump() }))
        }
        pub fn span(self) -> Span {
            match self.entry() {
                Entry::Group(group, _) => group.span(),
                Entry::Literal(l) => l.span(),
                Entry::Ident(t) => t.span(),
                Entry::Punct(o) => o.span(),
                Entry::End(..) => Span::call_site(),
            }
        }
        pub(crate) fn skip(self) -> Option<Cursor<'a>> {
            match self.entry() {
                Entry::End(..) => None,
                Entry::Punct(
                    op,
                ) if op.as_char() == '\'' && op.spacing() == Spacing::Joint => {
                    let next = unsafe { self.bump() };
                    match next.entry() {
                        Entry::Ident(_) => Some(unsafe { next.bump() }),
                        _ => Some(next),
                    }
                }
                _ => Some(unsafe { self.bump() }),
            }
        }
    }
    impl<'a> Copy for Cursor<'a> {}
    impl<'a> Clone for Cursor<'a> {
        fn clone(&self) -> Self {
            *self
        }
    }
    impl<'a> Eq for Cursor<'a> {}
    impl<'a> PartialEq for Cursor<'a> {
        fn eq(&self, other: &Self) -> bool {
            let Cursor { ptr, scope, marker } = self;
            let _ = marker;
            *ptr == other.ptr && *scope == other.scope
        }
    }
    pub(crate) fn same_scope(a: Cursor, b: Cursor) -> bool {
        a.scope == b.scope
    }
    pub(crate) fn open_span_of_group(cursor: Cursor) -> Span {
        match cursor.entry() {
            Entry::Group(group, _) => group.span_open(),
            _ => cursor.span(),
        }
    }
    pub(crate) fn close_span_of_group(cursor: Cursor) -> Span {
        match cursor.entry() {
            Entry::Group(group, _) => group.span_close(),
            _ => cursor.span(),
        }
    }
}
#[cfg(feature = "parsing")]
pub mod ext {
    use crate::buffer::Cursor;
    use crate::parse::Peek;
    use crate::parse::{ParseStream, Result};
    use crate::sealed::lookahead;
    use crate::token::CustomToken;
    use proc_macro2::Ident;
    pub trait IdentExt: Sized + private::Sealed {
        fn parse_any(input: ParseStream) -> Result<Self>;
        #[allow(non_upper_case_globals)]
        const peek_any: private::PeekFn = private::PeekFn;
        fn unraw(&self) -> Ident;
    }
    impl IdentExt for Ident {
        fn parse_any(input: ParseStream) -> Result<Self> {
            input
                .step(|cursor| match cursor.ident() {
                    Some((ident, rest)) => Ok((ident, rest)),
                    None => Err(cursor.error("expected ident")),
                })
        }
        fn unraw(&self) -> Ident {
            let string = self.to_string();
            if string.starts_with("r#") {
                Ident::new(&string[2..], self.span())
            } else {
                self.clone()
            }
        }
    }
    impl Peek for private::PeekFn {
        type Token = private::IdentAny;
    }
    impl CustomToken for private::IdentAny {
        fn peek(cursor: Cursor) -> bool {
            cursor.ident().is_some()
        }
        fn display() -> &'static str {
            "identifier"
        }
    }
    impl lookahead::Sealed for private::PeekFn {}
    mod private {
        use proc_macro2::Ident;
        pub trait Sealed {}
        impl Sealed for Ident {}
        pub struct PeekFn;
        pub struct IdentAny;
        impl Copy for PeekFn {}
        impl Clone for PeekFn {
            fn clone(&self) -> Self {
                *self
            }
        }
    }
}
pub mod punctuated {
    #[cfg(feature = "extra-traits")]
    use std::fmt::{self, Debug};
    #[cfg(feature = "extra-traits")]
    use std::hash::{Hash, Hasher};
    #[cfg(any(feature = "full", feature = "derive"))]
    use std::iter;
    use std::iter::FromIterator;
    use std::ops::{Index, IndexMut};
    use std::option;
    use std::slice;
    use std::vec;
    #[cfg(feature = "parsing")]
    use crate::parse::{Parse, ParseStream, Result};
    #[cfg(feature = "parsing")]
    use crate::token::Token;
    pub struct Punctuated<T, P> {
        inner: Vec<(T, P)>,
        last: Option<Box<T>>,
    }
    impl<T, P> Punctuated<T, P> {
        #[cfg(not(syn_no_const_vec_new))]
        pub const fn new() -> Self {
            Punctuated {
                inner: Vec::new(),
                last: None,
            }
        }
        pub fn is_empty(&self) -> bool {
            self.inner.len() == 0 && self.last.is_none()
        }
        pub fn len(&self) -> usize {
            self.inner.len() + if self.last.is_some() { 1 } else { 0 }
        }
        pub fn first(&self) -> Option<&T> {
            self.iter().next()
        }
        pub fn first_mut(&mut self) -> Option<&mut T> {
            self.iter_mut().next()
        }
        pub fn last(&self) -> Option<&T> {
            self.iter().next_back()
        }
        pub fn last_mut(&mut self) -> Option<&mut T> {
            self.iter_mut().next_back()
        }
        pub fn iter(&self) -> Iter<T> {
            Iter {
                inner: Box::new(PrivateIter {
                    inner: self.inner.iter(),
                    last: self.last.as_ref().map(Box::as_ref).into_iter(),
                }),
            }
        }
        pub fn iter_mut(&mut self) -> IterMut<T> {
            IterMut {
                inner: Box::new(PrivateIterMut {
                    inner: self.inner.iter_mut(),
                    last: self.last.as_mut().map(Box::as_mut).into_iter(),
                }),
            }
        }
        pub fn pairs(&self) -> Pairs<T, P> {
            Pairs {
                inner: self.inner.iter(),
                last: self.last.as_ref().map(Box::as_ref).into_iter(),
            }
        }
        pub fn pairs_mut(&mut self) -> PairsMut<T, P> {
            PairsMut {
                inner: self.inner.iter_mut(),
                last: self.last.as_mut().map(Box::as_mut).into_iter(),
            }
        }
        pub fn into_pairs(self) -> IntoPairs<T, P> {
            IntoPairs {
                inner: self.inner.into_iter(),
                last: self.last.map(|t| *t).into_iter(),
            }
        }
        pub fn push_value(&mut self, value: T) {
            if !self.empty_or_trailing() {
                {
                    ::std::rt::begin_panic(
                        "Punctuated::push_value: cannot push value if Punctuated is missing trailing punctuation",
                    )
                }
            }
            self.last = Some(Box::new(value));
        }
        pub fn push_punct(&mut self, punctuation: P) {
            if !self.last.is_some() {
                {
                    ::std::rt::begin_panic(
                        "Punctuated::push_punct: cannot push punctuation if Punctuated is empty or already has trailing punctuation",
                    )
                }
            }
            let last = self.last.take().unwrap();
            self.inner.push((*last, punctuation));
        }
        pub fn pop(&mut self) -> Option<Pair<T, P>> {
            if self.last.is_some() {
                self.last.take().map(|t| Pair::End(*t))
            } else {
                self.inner.pop().map(|(t, p)| Pair::Punctuated(t, p))
            }
        }
        pub fn trailing_punct(&self) -> bool {
            self.last.is_none() && !self.is_empty()
        }
        pub fn empty_or_trailing(&self) -> bool {
            self.last.is_none()
        }
        pub fn push(&mut self, value: T)
        where
            P: Default,
        {
            if !self.empty_or_trailing() {
                self.push_punct(Default::default());
            }
            self.push_value(value);
        }
        pub fn insert(&mut self, index: usize, value: T)
        where
            P: Default,
        {
            if !(index <= self.len()) {
                { ::std::rt::begin_panic("Punctuated::insert: index out of range") }
            }
            if index == self.len() {
                self.push(value);
            } else {
                self.inner.insert(index, (value, Default::default()));
            }
        }
        pub fn clear(&mut self) {
            self.inner.clear();
            self.last = None;
        }
        #[cfg(feature = "parsing")]
        pub fn parse_terminated(input: ParseStream) -> Result<Self>
        where
            T: Parse,
            P: Parse,
        {
            Self::parse_terminated_with(input, T::parse)
        }
        #[cfg(feature = "parsing")]
        pub fn parse_terminated_with(
            input: ParseStream,
            parser: fn(ParseStream) -> Result<T>,
        ) -> Result<Self>
        where
            P: Parse,
        {
            let mut punctuated = Punctuated::new();
            loop {
                if input.is_empty() {
                    break;
                }
                let value = parser(input)?;
                punctuated.push_value(value);
                if input.is_empty() {
                    break;
                }
                let punct = input.parse()?;
                punctuated.push_punct(punct);
            }
            Ok(punctuated)
        }
        #[cfg(feature = "parsing")]
        pub fn parse_separated_nonempty(input: ParseStream) -> Result<Self>
        where
            T: Parse,
            P: Token + Parse,
        {
            Self::parse_separated_nonempty_with(input, T::parse)
        }
        #[cfg(feature = "parsing")]
        pub fn parse_separated_nonempty_with(
            input: ParseStream,
            parser: fn(ParseStream) -> Result<T>,
        ) -> Result<Self>
        where
            P: Token + Parse,
        {
            let mut punctuated = Punctuated::new();
            loop {
                let value = parser(input)?;
                punctuated.push_value(value);
                if !P::peek(input.cursor()) {
                    break;
                }
                let punct = input.parse()?;
                punctuated.push_punct(punct);
            }
            Ok(punctuated)
        }
    }
    #[cfg(feature = "clone-impls")]
    impl<T, P> Clone for Punctuated<T, P>
    where
        T: Clone,
        P: Clone,
    {
        fn clone(&self) -> Self {
            Punctuated {
                inner: self.inner.clone(),
                last: self.last.clone(),
            }
        }
    }
    #[cfg(feature = "extra-traits")]
    impl<T, P> Eq for Punctuated<T, P>
    where
        T: Eq,
        P: Eq,
    {}
    #[cfg(feature = "extra-traits")]
    impl<T, P> PartialEq for Punctuated<T, P>
    where
        T: PartialEq,
        P: PartialEq,
    {
        fn eq(&self, other: &Self) -> bool {
            let Punctuated { inner, last } = self;
            *inner == other.inner && *last == other.last
        }
    }
    #[cfg(feature = "extra-traits")]
    impl<T, P> Hash for Punctuated<T, P>
    where
        T: Hash,
        P: Hash,
    {
        fn hash<H: Hasher>(&self, state: &mut H) {
            let Punctuated { inner, last } = self;
            inner.hash(state);
            last.hash(state);
        }
    }
    #[cfg(feature = "extra-traits")]
    impl<T: Debug, P: Debug> Debug for Punctuated<T, P> {
        fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
            let mut list = f.debug_list();
            for (t, p) in &self.inner {
                list.entry(t);
                list.entry(p);
            }
            if let Some(last) = &self.last {
                list.entry(last);
            }
            list.finish()
        }
    }
    impl<T, P> FromIterator<T> for Punctuated<T, P>
    where
        P: Default,
    {
        fn from_iter<I: IntoIterator<Item = T>>(i: I) -> Self {
            let mut ret = Punctuated::new();
            ret.extend(i);
            ret
        }
    }
    impl<T, P> Extend<T> for Punctuated<T, P>
    where
        P: Default,
    {
        fn extend<I: IntoIterator<Item = T>>(&mut self, i: I) {
            for value in i {
                self.push(value);
            }
        }
    }
    impl<T, P> FromIterator<Pair<T, P>> for Punctuated<T, P> {
        fn from_iter<I: IntoIterator<Item = Pair<T, P>>>(i: I) -> Self {
            let mut ret = Punctuated::new();
            ret.extend(i);
            ret
        }
    }
    impl<T, P> Extend<Pair<T, P>> for Punctuated<T, P> {
        fn extend<I: IntoIterator<Item = Pair<T, P>>>(&mut self, i: I) {
            if !self.empty_or_trailing() {
                {
                    ::std::rt::begin_panic(
                        "Punctuated::extend: Punctuated is not empty or does not have a trailing punctuation",
                    )
                }
            }
            let mut nomore = false;
            for pair in i {
                if nomore {
                    {
                        ::std::rt::begin_panic(
                            "Punctuated extended with items after a Pair::End",
                        )
                    };
                }
                match pair {
                    Pair::Punctuated(a, b) => self.inner.push((a, b)),
                    Pair::End(a) => {
                        self.last = Some(Box::new(a));
                        nomore = true;
                    }
                }
            }
        }
    }
    impl<T, P> IntoIterator for Punctuated<T, P> {
        type Item = T;
        type IntoIter = IntoIter<T>;
        fn into_iter(self) -> Self::IntoIter {
            let mut elements = Vec::with_capacity(self.len());
            elements.extend(self.inner.into_iter().map(|pair| pair.0));
            elements.extend(self.last.map(|t| *t));
            IntoIter {
                inner: elements.into_iter(),
            }
        }
    }
    impl<'a, T, P> IntoIterator for &'a Punctuated<T, P> {
        type Item = &'a T;
        type IntoIter = Iter<'a, T>;
        fn into_iter(self) -> Self::IntoIter {
            Punctuated::iter(self)
        }
    }
    impl<'a, T, P> IntoIterator for &'a mut Punctuated<T, P> {
        type Item = &'a mut T;
        type IntoIter = IterMut<'a, T>;
        fn into_iter(self) -> Self::IntoIter {
            Punctuated::iter_mut(self)
        }
    }
    impl<T, P> Default for Punctuated<T, P> {
        fn default() -> Self {
            Punctuated::new()
        }
    }
    pub struct Pairs<'a, T: 'a, P: 'a> {
        inner: slice::Iter<'a, (T, P)>,
        last: option::IntoIter<&'a T>,
    }
    impl<'a, T, P> Iterator for Pairs<'a, T, P> {
        type Item = Pair<&'a T, &'a P>;
        fn next(&mut self) -> Option<Self::Item> {
            self.inner
                .next()
                .map(|(t, p)| Pair::Punctuated(t, p))
                .or_else(|| self.last.next().map(Pair::End))
        }
        fn size_hint(&self) -> (usize, Option<usize>) {
            (self.len(), Some(self.len()))
        }
    }
    impl<'a, T, P> DoubleEndedIterator for Pairs<'a, T, P> {
        fn next_back(&mut self) -> Option<Self::Item> {
            self.last
                .next()
                .map(Pair::End)
                .or_else(|| self.inner.next_back().map(|(t, p)| Pair::Punctuated(t, p)))
        }
    }
    impl<'a, T, P> ExactSizeIterator for Pairs<'a, T, P> {
        fn len(&self) -> usize {
            self.inner.len() + self.last.len()
        }
    }
    impl<'a, T, P> Clone for Pairs<'a, T, P> {
        fn clone(&self) -> Self {
            Pairs {
                inner: self.inner.clone(),
                last: self.last.clone(),
            }
        }
    }
    pub struct PairsMut<'a, T: 'a, P: 'a> {
        inner: slice::IterMut<'a, (T, P)>,
        last: option::IntoIter<&'a mut T>,
    }
    impl<'a, T, P> Iterator for PairsMut<'a, T, P> {
        type Item = Pair<&'a mut T, &'a mut P>;
        fn next(&mut self) -> Option<Self::Item> {
            self.inner
                .next()
                .map(|(t, p)| Pair::Punctuated(t, p))
                .or_else(|| self.last.next().map(Pair::End))
        }
        fn size_hint(&self) -> (usize, Option<usize>) {
            (self.len(), Some(self.len()))
        }
    }
    impl<'a, T, P> DoubleEndedIterator for PairsMut<'a, T, P> {
        fn next_back(&mut self) -> Option<Self::Item> {
            self.last
                .next()
                .map(Pair::End)
                .or_else(|| self.inner.next_back().map(|(t, p)| Pair::Punctuated(t, p)))
        }
    }
    impl<'a, T, P> ExactSizeIterator for PairsMut<'a, T, P> {
        fn len(&self) -> usize {
            self.inner.len() + self.last.len()
        }
    }
    pub struct IntoPairs<T, P> {
        inner: vec::IntoIter<(T, P)>,
        last: option::IntoIter<T>,
    }
    impl<T, P> Iterator for IntoPairs<T, P> {
        type Item = Pair<T, P>;
        fn next(&mut self) -> Option<Self::Item> {
            self.inner
                .next()
                .map(|(t, p)| Pair::Punctuated(t, p))
                .or_else(|| self.last.next().map(Pair::End))
        }
        fn size_hint(&self) -> (usize, Option<usize>) {
            (self.len(), Some(self.len()))
        }
    }
    impl<T, P> DoubleEndedIterator for IntoPairs<T, P> {
        fn next_back(&mut self) -> Option<Self::Item> {
            self.last
                .next()
                .map(Pair::End)
                .or_else(|| self.inner.next_back().map(|(t, p)| Pair::Punctuated(t, p)))
        }
    }
    impl<T, P> ExactSizeIterator for IntoPairs<T, P> {
        fn len(&self) -> usize {
            self.inner.len() + self.last.len()
        }
    }
    impl<T, P> Clone for IntoPairs<T, P>
    where
        T: Clone,
        P: Clone,
    {
        fn clone(&self) -> Self {
            IntoPairs {
                inner: self.inner.clone(),
                last: self.last.clone(),
            }
        }
    }
    pub struct IntoIter<T> {
        inner: vec::IntoIter<T>,
    }
    impl<T> Iterator for IntoIter<T> {
        type Item = T;
        fn next(&mut self) -> Option<Self::Item> {
            self.inner.next()
        }
        fn size_hint(&self) -> (usize, Option<usize>) {
            (self.len(), Some(self.len()))
        }
    }
    impl<T> DoubleEndedIterator for IntoIter<T> {
        fn next_back(&mut self) -> Option<Self::Item> {
            self.inner.next_back()
        }
    }
    impl<T> ExactSizeIterator for IntoIter<T> {
        fn len(&self) -> usize {
            self.inner.len()
        }
    }
    impl<T> Clone for IntoIter<T>
    where
        T: Clone,
    {
        fn clone(&self) -> Self {
            IntoIter {
                inner: self.inner.clone(),
            }
        }
    }
    pub struct Iter<'a, T: 'a> {
        inner: Box<dyn IterTrait<'a, T, Item = &'a T> + 'a>,
    }
    trait IterTrait<
        'a,
        T: 'a,
    >: DoubleEndedIterator<Item = &'a T> + ExactSizeIterator<Item = &'a T> {
        fn clone_box(&self) -> Box<dyn IterTrait<'a, T, Item = &'a T> + 'a>;
    }
    struct PrivateIter<'a, T: 'a, P: 'a> {
        inner: slice::Iter<'a, (T, P)>,
        last: option::IntoIter<&'a T>,
    }
    #[cfg(any(feature = "full", feature = "derive"))]
    pub(crate) fn empty_punctuated_iter<'a, T>() -> Iter<'a, T> {
        Iter {
            inner: Box::new(iter::empty()),
        }
    }
    impl<'a, T> Clone for Iter<'a, T> {
        fn clone(&self) -> Self {
            Iter {
                inner: self.inner.clone_box(),
            }
        }
    }
    impl<'a, T> Iterator for Iter<'a, T> {
        type Item = &'a T;
        fn next(&mut self) -> Option<Self::Item> {
            self.inner.next()
        }
        fn size_hint(&self) -> (usize, Option<usize>) {
            (self.len(), Some(self.len()))
        }
    }
    impl<'a, T> DoubleEndedIterator for Iter<'a, T> {
        fn next_back(&mut self) -> Option<Self::Item> {
            self.inner.next_back()
        }
    }
    impl<'a, T> ExactSizeIterator for Iter<'a, T> {
        fn len(&self) -> usize {
            self.inner.len()
        }
    }
    impl<'a, T, P> Iterator for PrivateIter<'a, T, P> {
        type Item = &'a T;
        fn next(&mut self) -> Option<Self::Item> {
            self.inner.next().map(|pair| &pair.0).or_else(|| self.last.next())
        }
    }
    impl<'a, T, P> DoubleEndedIterator for PrivateIter<'a, T, P> {
        fn next_back(&mut self) -> Option<Self::Item> {
            self.last.next().or_else(|| self.inner.next_back().map(|pair| &pair.0))
        }
    }
    impl<'a, T, P> ExactSizeIterator for PrivateIter<'a, T, P> {
        fn len(&self) -> usize {
            self.inner.len() + self.last.len()
        }
    }
    impl<'a, T, P> Clone for PrivateIter<'a, T, P> {
        fn clone(&self) -> Self {
            PrivateIter {
                inner: self.inner.clone(),
                last: self.last.clone(),
            }
        }
    }
    impl<'a, T, I> IterTrait<'a, T> for I
    where
        T: 'a,
        I: DoubleEndedIterator<Item = &'a T> + ExactSizeIterator<Item = &'a T> + Clone
            + 'a,
    {
        fn clone_box(&self) -> Box<dyn IterTrait<'a, T, Item = &'a T> + 'a> {
            Box::new(self.clone())
        }
    }
    pub struct IterMut<'a, T: 'a> {
        inner: Box<dyn IterMutTrait<'a, T, Item = &'a mut T> + 'a>,
    }
    trait IterMutTrait<
        'a,
        T: 'a,
    >: DoubleEndedIterator<Item = &'a mut T> + ExactSizeIterator<Item = &'a mut T> {}
    struct PrivateIterMut<'a, T: 'a, P: 'a> {
        inner: slice::IterMut<'a, (T, P)>,
        last: option::IntoIter<&'a mut T>,
    }
    #[cfg(any(feature = "full", feature = "derive"))]
    pub(crate) fn empty_punctuated_iter_mut<'a, T>() -> IterMut<'a, T> {
        IterMut {
            inner: Box::new(iter::empty()),
        }
    }
    impl<'a, T> Iterator for IterMut<'a, T> {
        type Item = &'a mut T;
        fn next(&mut self) -> Option<Self::Item> {
            self.inner.next()
        }
        fn size_hint(&self) -> (usize, Option<usize>) {
            (self.len(), Some(self.len()))
        }
    }
    impl<'a, T> DoubleEndedIterator for IterMut<'a, T> {
        fn next_back(&mut self) -> Option<Self::Item> {
            self.inner.next_back()
        }
    }
    impl<'a, T> ExactSizeIterator for IterMut<'a, T> {
        fn len(&self) -> usize {
            self.inner.len()
        }
    }
    impl<'a, T, P> Iterator for PrivateIterMut<'a, T, P> {
        type Item = &'a mut T;
        fn next(&mut self) -> Option<Self::Item> {
            self.inner.next().map(|pair| &mut pair.0).or_else(|| self.last.next())
        }
    }
    impl<'a, T, P> DoubleEndedIterator for PrivateIterMut<'a, T, P> {
        fn next_back(&mut self) -> Option<Self::Item> {
            self.last.next().or_else(|| self.inner.next_back().map(|pair| &mut pair.0))
        }
    }
    impl<'a, T, P> ExactSizeIterator for PrivateIterMut<'a, T, P> {
        fn len(&self) -> usize {
            self.inner.len() + self.last.len()
        }
    }
    impl<'a, T, I> IterMutTrait<'a, T> for I
    where
        T: 'a,
        I: DoubleEndedIterator<Item = &'a mut T> + ExactSizeIterator<Item = &'a mut T>
            + 'a,
    {}
    pub enum Pair<T, P> {
        Punctuated(T, P),
        End(T),
    }
    impl<T, P> Pair<T, P> {
        pub fn into_value(self) -> T {
            match self {
                Pair::Punctuated(t, _) | Pair::End(t) => t,
            }
        }
        pub fn value(&self) -> &T {
            match self {
                Pair::Punctuated(t, _) | Pair::End(t) => t,
            }
        }
        pub fn value_mut(&mut self) -> &mut T {
            match self {
                Pair::Punctuated(t, _) | Pair::End(t) => t,
            }
        }
        pub fn punct(&self) -> Option<&P> {
            match self {
                Pair::Punctuated(_, p) => Some(p),
                Pair::End(_) => None,
            }
        }
        pub fn punct_mut(&mut self) -> Option<&mut P> {
            match self {
                Pair::Punctuated(_, p) => Some(p),
                Pair::End(_) => None,
            }
        }
        pub fn new(t: T, p: Option<P>) -> Self {
            match p {
                Some(p) => Pair::Punctuated(t, p),
                None => Pair::End(t),
            }
        }
        pub fn into_tuple(self) -> (T, Option<P>) {
            match self {
                Pair::Punctuated(t, p) => (t, Some(p)),
                Pair::End(t) => (t, None),
            }
        }
    }
    #[cfg(feature = "clone-impls")]
    impl<T, P> Clone for Pair<T, P>
    where
        T: Clone,
        P: Clone,
    {
        fn clone(&self) -> Self {
            match self {
                Pair::Punctuated(t, p) => Pair::Punctuated(t.clone(), p.clone()),
                Pair::End(t) => Pair::End(t.clone()),
            }
        }
    }
    impl<T, P> Index<usize> for Punctuated<T, P> {
        type Output = T;
        fn index(&self, index: usize) -> &Self::Output {
            if index == self.len() - 1 {
                match &self.last {
                    Some(t) => t,
                    None => &self.inner[index].0,
                }
            } else {
                &self.inner[index].0
            }
        }
    }
    impl<T, P> IndexMut<usize> for Punctuated<T, P> {
        fn index_mut(&mut self, index: usize) -> &mut Self::Output {
            if index == self.len() - 1 {
                match &mut self.last {
                    Some(t) => t,
                    None => &mut self.inner[index].0,
                }
            } else {
                &mut self.inner[index].0
            }
        }
    }
    #[cfg(feature = "printing")]
    mod printing {
        use super::*;
        use proc_macro2::TokenStream;
        use quote::{ToTokens, TokenStreamExt};
        impl<T, P> ToTokens for Punctuated<T, P>
        where
            T: ToTokens,
            P: ToTokens,
        {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                tokens.append_all(self.pairs());
            }
        }
        impl<T, P> ToTokens for Pair<T, P>
        where
            T: ToTokens,
            P: ToTokens,
        {
            fn to_tokens(&self, tokens: &mut TokenStream) {
                match self {
                    Pair::Punctuated(a, b) => {
                        a.to_tokens(tokens);
                        b.to_tokens(tokens);
                    }
                    Pair::End(a) => a.to_tokens(tokens),
                }
            }
        }
    }
}
#[cfg(all(any(feature = "full", feature = "derive"), feature = "extra-traits"))]
mod tt {
    use proc_macro2::{Delimiter, TokenStream, TokenTree};
    use std::hash::{Hash, Hasher};
    pub struct TokenTreeHelper<'a>(pub &'a TokenTree);
    impl<'a> PartialEq for TokenTreeHelper<'a> {
        fn eq(&self, other: &Self) -> bool {
            use proc_macro2::Spacing;
            match (self.0, other.0) {
                (TokenTree::Group(g1), TokenTree::Group(g2)) => {
                    match (g1.delimiter(), g2.delimiter()) {
                        (Delimiter::Parenthesis, Delimiter::Parenthesis)
                        | (Delimiter::Brace, Delimiter::Brace)
                        | (Delimiter::Bracket, Delimiter::Bracket)
                        | (Delimiter::None, Delimiter::None) => {}
                        _ => return false,
                    }
                    let s1 = g1.stream().into_iter();
                    let mut s2 = g2.stream().into_iter();
                    for item1 in s1 {
                        let item2 = match s2.next() {
                            Some(item) => item,
                            None => return false,
                        };
                        if TokenTreeHelper(&item1) != TokenTreeHelper(&item2) {
                            return false;
                        }
                    }
                    s2.next().is_none()
                }
                (TokenTree::Punct(o1), TokenTree::Punct(o2)) => {
                    o1.as_char() == o2.as_char()
                        && match (o1.spacing(), o2.spacing()) {
                            (Spacing::Alone, Spacing::Alone)
                            | (Spacing::Joint, Spacing::Joint) => true,
                            _ => false,
                        }
                }
                (TokenTree::Literal(l1), TokenTree::Literal(l2)) => {
                    l1.to_string() == l2.to_string()
                }
                (TokenTree::Ident(s1), TokenTree::Ident(s2)) => s1 == s2,
                _ => false,
            }
        }
    }
    impl<'a> Hash for TokenTreeHelper<'a> {
        fn hash<H: Hasher>(&self, h: &mut H) {
            use proc_macro2::Spacing;
            match self.0 {
                TokenTree::Group(g) => {
                    0u8.hash(h);
                    match g.delimiter() {
                        Delimiter::Parenthesis => 0u8.hash(h),
                        Delimiter::Brace => 1u8.hash(h),
                        Delimiter::Bracket => 2u8.hash(h),
                        Delimiter::None => 3u8.hash(h),
                    }
                    for item in g.stream() {
                        TokenTreeHelper(&item).hash(h);
                    }
                    0xffu8.hash(h);
                }
                TokenTree::Punct(op) => {
                    1u8.hash(h);
                    op.as_char().hash(h);
                    match op.spacing() {
                        Spacing::Alone => 0u8.hash(h),
                        Spacing::Joint => 1u8.hash(h),
                    }
                }
                TokenTree::Literal(lit) => (2u8, lit.to_string()).hash(h),
                TokenTree::Ident(word) => (3u8, word).hash(h),
            }
        }
    }
    pub struct TokenStreamHelper<'a>(pub &'a TokenStream);
    impl<'a> PartialEq for TokenStreamHelper<'a> {
        fn eq(&self, other: &Self) -> bool {
            let left = self.0.clone().into_iter().collect::<Vec<_>>();
            let right = other.0.clone().into_iter().collect::<Vec<_>>();
            if left.len() != right.len() {
                return false;
            }
            for (a, b) in left.into_iter().zip(right) {
                if TokenTreeHelper(&a) != TokenTreeHelper(&b) {
                    return false;
                }
            }
            true
        }
    }
    impl<'a> Hash for TokenStreamHelper<'a> {
        fn hash<H: Hasher>(&self, state: &mut H) {
            let tts = self.0.clone().into_iter().collect::<Vec<_>>();
            tts.len().hash(state);
            for tt in tts {
                TokenTreeHelper(&tt).hash(state);
            }
        }
    }
}
#[cfg(feature = "parsing")]
#[doc(hidden)]
pub mod parse_quote {
    use crate::parse::{Parse, ParseStream, Parser, Result};
    use proc_macro2::TokenStream;
    #[doc(hidden)]
    pub fn parse<T: ParseQuote>(token_stream: TokenStream) -> T {
        let parser = T::parse;
        match parser.parse2(token_stream) {
            Ok(t) => t,
            Err(err) => ::std::rt::panic_display(&err),
        }
    }
    #[doc(hidden)]
    pub trait ParseQuote: Sized {
        fn parse(input: ParseStream) -> Result<Self>;
    }
    impl<T: Parse> ParseQuote for T {
        fn parse(input: ParseStream) -> Result<Self> {
            <T as Parse>::parse(input)
        }
    }
    use crate::punctuated::Punctuated;
    #[cfg(any(feature = "full", feature = "derive"))]
    use crate::{attr, Attribute};
    #[cfg(feature = "full")]
    use crate::{Block, Stmt};
    #[cfg(any(feature = "full", feature = "derive"))]
    impl ParseQuote for Attribute {
        fn parse(input: ParseStream) -> Result<Self> {
            if input.peek(crate::token::Pound) && input.peek2(crate::token::Bang) {
                attr::parsing::single_parse_inner(input)
            } else {
                attr::parsing::single_parse_outer(input)
            }
        }
    }
    impl<T: Parse, P: Parse> ParseQuote for Punctuated<T, P> {
        fn parse(input: ParseStream) -> Result<Self> {
            Self::parse_terminated(input)
        }
    }
    #[cfg(feature = "full")]
    impl ParseQuote for Vec<Stmt> {
        fn parse(input: ParseStream) -> Result<Self> {
            Block::parse_within(input)
        }
    }
}
#[cfg(
    all(
        not(all(target_arch = "wasm32", any(target_os = "unknown", target_os = "wasi"))),
        feature = "parsing",
        feature = "proc-macro"
    )
)]
#[doc(hidden)]
pub mod parse_macro_input {
    use crate::parse::{Parse, ParseStream, Parser, Result};
    use proc_macro::TokenStream;
    #[doc(hidden)]
    pub fn parse<T: ParseMacroInput>(token_stream: TokenStream) -> Result<T> {
        T::parse.parse(token_stream)
    }
    #[doc(hidden)]
    pub trait ParseMacroInput: Sized {
        fn parse(input: ParseStream) -> Result<Self>;
    }
    impl<T: Parse> ParseMacroInput for T {
        fn parse(input: ParseStream) -> Result<Self> {
            <T as Parse>::parse(input)
        }
    }
    #[cfg(any(feature = "full", feature = "derive"))]
    use crate::AttributeArgs;
    #[cfg(any(feature = "full", feature = "derive"))]
    impl ParseMacroInput for AttributeArgs {
        fn parse(input: ParseStream) -> Result<Self> {
            let mut metas = Vec::new();
            loop {
                if input.is_empty() {
                    break;
                }
                let value = input.parse()?;
                metas.push(value);
                if input.is_empty() {
                    break;
                }
                input.parse::<crate::token::Comma>()?;
            }
            Ok(metas)
        }
    }
}
#[cfg(all(feature = "parsing", feature = "printing"))]
pub mod spanned {
    use proc_macro2::Span;
    use quote::spanned::Spanned as ToTokens;
    pub trait Spanned {
        fn span(&self) -> Span;
    }
    impl<T: ?Sized + ToTokens> Spanned for T {
        fn span(&self) -> Span {
            self.__span()
        }
    }
}
#[cfg(all(feature = "parsing", feature = "full"))]
mod whitespace {
    pub fn skip(mut s: &str) -> &str {
        'skip: while !s.is_empty() {
            let byte = s.as_bytes()[0];
            if byte == b'/' {
                if s.starts_with("//")
                    && (!s.starts_with("///") || s.starts_with("////"))
                    && !s.starts_with("//!")
                {
                    if let Some(i) = s.find('\n') {
                        s = &s[i + 1..];
                        continue;
                    } else {
                        return "";
                    }
                } else if s.starts_with("/**/") {
                    s = &s[4..];
                    continue;
                } else if s.starts_with("/*")
                    && (!s.starts_with("/**") || s.starts_with("/***"))
                    && !s.starts_with("/*!")
                {
                    let mut depth = 0;
                    let bytes = s.as_bytes();
                    let mut i = 0;
                    let upper = bytes.len() - 1;
                    while i < upper {
                        if bytes[i] == b'/' && bytes[i + 1] == b'*' {
                            depth += 1;
                            i += 1;
                        } else if bytes[i] == b'*' && bytes[i + 1] == b'/' {
                            depth -= 1;
                            if depth == 0 {
                                s = &s[i + 2..];
                                continue 'skip;
                            }
                            i += 1;
                        }
                        i += 1;
                    }
                    return s;
                }
            }
            match byte {
                b' ' | 0x09..=0x0d => {
                    s = &s[1..];
                    continue;
                }
                b if b <= 0x7f => {}
                _ => {
                    let ch = s.chars().next().unwrap();
                    if is_whitespace(ch) {
                        s = &s[ch.len_utf8()..];
                        continue;
                    }
                }
            }
            return s;
        }
        s
    }
    fn is_whitespace(ch: char) -> bool {
        ch.is_whitespace() || ch == '\u{200e}' || ch == '\u{200f}'
    }
}
mod gen {
    #[cfg(feature = "visit")]
    #[rustfmt::skip]
    pub mod visit {
        #![allow(unused_variables)]
        #[cfg(any(feature = "full", feature = "derive"))]
        use crate::gen::helper::visit::*;
        #[cfg(any(feature = "full", feature = "derive"))]
        use crate::punctuated::Punctuated;
        use crate::*;
        use proc_macro2::Span;
        pub trait Visit<'ast> {
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_abi(&mut self, i: &'ast Abi) {
                visit_abi(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_angle_bracketed_generic_arguments(
                &mut self,
                i: &'ast AngleBracketedGenericArguments,
            ) {
                visit_angle_bracketed_generic_arguments(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_arm(&mut self, i: &'ast Arm) {
                visit_arm(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_attr_style(&mut self, i: &'ast AttrStyle) {
                visit_attr_style(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_attribute(&mut self, i: &'ast Attribute) {
                visit_attribute(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_bare_fn_arg(&mut self, i: &'ast BareFnArg) {
                visit_bare_fn_arg(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_bin_op(&mut self, i: &'ast BinOp) {
                visit_bin_op(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_binding(&mut self, i: &'ast Binding) {
                visit_binding(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_block(&mut self, i: &'ast Block) {
                visit_block(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_bound_lifetimes(&mut self, i: &'ast BoundLifetimes) {
                visit_bound_lifetimes(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_const_param(&mut self, i: &'ast ConstParam) {
                visit_const_param(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_constraint(&mut self, i: &'ast Constraint) {
                visit_constraint(self, i);
            }
            #[cfg(feature = "derive")]
            fn visit_data(&mut self, i: &'ast Data) {
                visit_data(self, i);
            }
            #[cfg(feature = "derive")]
            fn visit_data_enum(&mut self, i: &'ast DataEnum) {
                visit_data_enum(self, i);
            }
            #[cfg(feature = "derive")]
            fn visit_data_struct(&mut self, i: &'ast DataStruct) {
                visit_data_struct(self, i);
            }
            #[cfg(feature = "derive")]
            fn visit_data_union(&mut self, i: &'ast DataUnion) {
                visit_data_union(self, i);
            }
            #[cfg(feature = "derive")]
            fn visit_derive_input(&mut self, i: &'ast DeriveInput) {
                visit_derive_input(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr(&mut self, i: &'ast Expr) {
                visit_expr(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_array(&mut self, i: &'ast ExprArray) {
                visit_expr_array(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_assign(&mut self, i: &'ast ExprAssign) {
                visit_expr_assign(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_assign_op(&mut self, i: &'ast ExprAssignOp) {
                visit_expr_assign_op(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_async(&mut self, i: &'ast ExprAsync) {
                visit_expr_async(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_await(&mut self, i: &'ast ExprAwait) {
                visit_expr_await(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_binary(&mut self, i: &'ast ExprBinary) {
                visit_expr_binary(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_block(&mut self, i: &'ast ExprBlock) {
                visit_expr_block(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_box(&mut self, i: &'ast ExprBox) {
                visit_expr_box(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_break(&mut self, i: &'ast ExprBreak) {
                visit_expr_break(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_call(&mut self, i: &'ast ExprCall) {
                visit_expr_call(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_cast(&mut self, i: &'ast ExprCast) {
                visit_expr_cast(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_closure(&mut self, i: &'ast ExprClosure) {
                visit_expr_closure(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_continue(&mut self, i: &'ast ExprContinue) {
                visit_expr_continue(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_field(&mut self, i: &'ast ExprField) {
                visit_expr_field(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_for_loop(&mut self, i: &'ast ExprForLoop) {
                visit_expr_for_loop(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_group(&mut self, i: &'ast ExprGroup) {
                visit_expr_group(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_if(&mut self, i: &'ast ExprIf) {
                visit_expr_if(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_index(&mut self, i: &'ast ExprIndex) {
                visit_expr_index(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_let(&mut self, i: &'ast ExprLet) {
                visit_expr_let(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_lit(&mut self, i: &'ast ExprLit) {
                visit_expr_lit(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_loop(&mut self, i: &'ast ExprLoop) {
                visit_expr_loop(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_macro(&mut self, i: &'ast ExprMacro) {
                visit_expr_macro(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_match(&mut self, i: &'ast ExprMatch) {
                visit_expr_match(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_method_call(&mut self, i: &'ast ExprMethodCall) {
                visit_expr_method_call(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_paren(&mut self, i: &'ast ExprParen) {
                visit_expr_paren(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_path(&mut self, i: &'ast ExprPath) {
                visit_expr_path(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_range(&mut self, i: &'ast ExprRange) {
                visit_expr_range(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_reference(&mut self, i: &'ast ExprReference) {
                visit_expr_reference(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_repeat(&mut self, i: &'ast ExprRepeat) {
                visit_expr_repeat(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_return(&mut self, i: &'ast ExprReturn) {
                visit_expr_return(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_struct(&mut self, i: &'ast ExprStruct) {
                visit_expr_struct(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_try(&mut self, i: &'ast ExprTry) {
                visit_expr_try(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_try_block(&mut self, i: &'ast ExprTryBlock) {
                visit_expr_try_block(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_tuple(&mut self, i: &'ast ExprTuple) {
                visit_expr_tuple(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_type(&mut self, i: &'ast ExprType) {
                visit_expr_type(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_unary(&mut self, i: &'ast ExprUnary) {
                visit_expr_unary(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_unsafe(&mut self, i: &'ast ExprUnsafe) {
                visit_expr_unsafe(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_while(&mut self, i: &'ast ExprWhile) {
                visit_expr_while(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_yield(&mut self, i: &'ast ExprYield) {
                visit_expr_yield(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_field(&mut self, i: &'ast Field) {
                visit_field(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_field_pat(&mut self, i: &'ast FieldPat) {
                visit_field_pat(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_field_value(&mut self, i: &'ast FieldValue) {
                visit_field_value(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_fields(&mut self, i: &'ast Fields) {
                visit_fields(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_fields_named(&mut self, i: &'ast FieldsNamed) {
                visit_fields_named(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_fields_unnamed(&mut self, i: &'ast FieldsUnnamed) {
                visit_fields_unnamed(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_file(&mut self, i: &'ast File) {
                visit_file(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_fn_arg(&mut self, i: &'ast FnArg) {
                visit_fn_arg(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_foreign_item(&mut self, i: &'ast ForeignItem) {
                visit_foreign_item(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_foreign_item_fn(&mut self, i: &'ast ForeignItemFn) {
                visit_foreign_item_fn(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_foreign_item_macro(&mut self, i: &'ast ForeignItemMacro) {
                visit_foreign_item_macro(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_foreign_item_static(&mut self, i: &'ast ForeignItemStatic) {
                visit_foreign_item_static(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_foreign_item_type(&mut self, i: &'ast ForeignItemType) {
                visit_foreign_item_type(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_generic_argument(&mut self, i: &'ast GenericArgument) {
                visit_generic_argument(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_generic_method_argument(&mut self, i: &'ast GenericMethodArgument) {
                visit_generic_method_argument(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_generic_param(&mut self, i: &'ast GenericParam) {
                visit_generic_param(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_generics(&mut self, i: &'ast Generics) {
                visit_generics(self, i);
            }
            fn visit_ident(&mut self, i: &'ast Ident) {
                visit_ident(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_impl_item(&mut self, i: &'ast ImplItem) {
                visit_impl_item(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_impl_item_const(&mut self, i: &'ast ImplItemConst) {
                visit_impl_item_const(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_impl_item_macro(&mut self, i: &'ast ImplItemMacro) {
                visit_impl_item_macro(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_impl_item_method(&mut self, i: &'ast ImplItemMethod) {
                visit_impl_item_method(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_impl_item_type(&mut self, i: &'ast ImplItemType) {
                visit_impl_item_type(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_index(&mut self, i: &'ast Index) {
                visit_index(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item(&mut self, i: &'ast Item) {
                visit_item(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_const(&mut self, i: &'ast ItemConst) {
                visit_item_const(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_enum(&mut self, i: &'ast ItemEnum) {
                visit_item_enum(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_extern_crate(&mut self, i: &'ast ItemExternCrate) {
                visit_item_extern_crate(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_fn(&mut self, i: &'ast ItemFn) {
                visit_item_fn(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_foreign_mod(&mut self, i: &'ast ItemForeignMod) {
                visit_item_foreign_mod(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_impl(&mut self, i: &'ast ItemImpl) {
                visit_item_impl(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_macro(&mut self, i: &'ast ItemMacro) {
                visit_item_macro(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_macro2(&mut self, i: &'ast ItemMacro2) {
                visit_item_macro2(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_mod(&mut self, i: &'ast ItemMod) {
                visit_item_mod(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_static(&mut self, i: &'ast ItemStatic) {
                visit_item_static(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_struct(&mut self, i: &'ast ItemStruct) {
                visit_item_struct(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_trait(&mut self, i: &'ast ItemTrait) {
                visit_item_trait(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_trait_alias(&mut self, i: &'ast ItemTraitAlias) {
                visit_item_trait_alias(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_type(&mut self, i: &'ast ItemType) {
                visit_item_type(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_union(&mut self, i: &'ast ItemUnion) {
                visit_item_union(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_use(&mut self, i: &'ast ItemUse) {
                visit_item_use(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_label(&mut self, i: &'ast Label) {
                visit_label(self, i);
            }
            fn visit_lifetime(&mut self, i: &'ast Lifetime) {
                visit_lifetime(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_lifetime_def(&mut self, i: &'ast LifetimeDef) {
                visit_lifetime_def(self, i);
            }
            fn visit_lit(&mut self, i: &'ast Lit) {
                visit_lit(self, i);
            }
            fn visit_lit_bool(&mut self, i: &'ast LitBool) {
                visit_lit_bool(self, i);
            }
            fn visit_lit_byte(&mut self, i: &'ast LitByte) {
                visit_lit_byte(self, i);
            }
            fn visit_lit_byte_str(&mut self, i: &'ast LitByteStr) {
                visit_lit_byte_str(self, i);
            }
            fn visit_lit_char(&mut self, i: &'ast LitChar) {
                visit_lit_char(self, i);
            }
            fn visit_lit_float(&mut self, i: &'ast LitFloat) {
                visit_lit_float(self, i);
            }
            fn visit_lit_int(&mut self, i: &'ast LitInt) {
                visit_lit_int(self, i);
            }
            fn visit_lit_str(&mut self, i: &'ast LitStr) {
                visit_lit_str(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_local(&mut self, i: &'ast Local) {
                visit_local(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_macro(&mut self, i: &'ast Macro) {
                visit_macro(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_macro_delimiter(&mut self, i: &'ast MacroDelimiter) {
                visit_macro_delimiter(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_member(&mut self, i: &'ast Member) {
                visit_member(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_meta(&mut self, i: &'ast Meta) {
                visit_meta(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_meta_list(&mut self, i: &'ast MetaList) {
                visit_meta_list(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_meta_name_value(&mut self, i: &'ast MetaNameValue) {
                visit_meta_name_value(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_method_turbofish(&mut self, i: &'ast MethodTurbofish) {
                visit_method_turbofish(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_nested_meta(&mut self, i: &'ast NestedMeta) {
                visit_nested_meta(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_parenthesized_generic_arguments(
                &mut self,
                i: &'ast ParenthesizedGenericArguments,
            ) {
                visit_parenthesized_generic_arguments(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat(&mut self, i: &'ast Pat) {
                visit_pat(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_box(&mut self, i: &'ast PatBox) {
                visit_pat_box(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_ident(&mut self, i: &'ast PatIdent) {
                visit_pat_ident(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_lit(&mut self, i: &'ast PatLit) {
                visit_pat_lit(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_macro(&mut self, i: &'ast PatMacro) {
                visit_pat_macro(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_or(&mut self, i: &'ast PatOr) {
                visit_pat_or(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_path(&mut self, i: &'ast PatPath) {
                visit_pat_path(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_range(&mut self, i: &'ast PatRange) {
                visit_pat_range(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_reference(&mut self, i: &'ast PatReference) {
                visit_pat_reference(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_rest(&mut self, i: &'ast PatRest) {
                visit_pat_rest(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_slice(&mut self, i: &'ast PatSlice) {
                visit_pat_slice(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_struct(&mut self, i: &'ast PatStruct) {
                visit_pat_struct(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_tuple(&mut self, i: &'ast PatTuple) {
                visit_pat_tuple(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_tuple_struct(&mut self, i: &'ast PatTupleStruct) {
                visit_pat_tuple_struct(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_type(&mut self, i: &'ast PatType) {
                visit_pat_type(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_wild(&mut self, i: &'ast PatWild) {
                visit_pat_wild(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_path(&mut self, i: &'ast Path) {
                visit_path(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_path_arguments(&mut self, i: &'ast PathArguments) {
                visit_path_arguments(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_path_segment(&mut self, i: &'ast PathSegment) {
                visit_path_segment(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_predicate_eq(&mut self, i: &'ast PredicateEq) {
                visit_predicate_eq(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_predicate_lifetime(&mut self, i: &'ast PredicateLifetime) {
                visit_predicate_lifetime(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_predicate_type(&mut self, i: &'ast PredicateType) {
                visit_predicate_type(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_qself(&mut self, i: &'ast QSelf) {
                visit_qself(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_range_limits(&mut self, i: &'ast RangeLimits) {
                visit_range_limits(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_receiver(&mut self, i: &'ast Receiver) {
                visit_receiver(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_return_type(&mut self, i: &'ast ReturnType) {
                visit_return_type(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_signature(&mut self, i: &'ast Signature) {
                visit_signature(self, i);
            }
            fn visit_span(&mut self, i: &Span) {
                visit_span(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_stmt(&mut self, i: &'ast Stmt) {
                visit_stmt(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_trait_bound(&mut self, i: &'ast TraitBound) {
                visit_trait_bound(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_trait_bound_modifier(&mut self, i: &'ast TraitBoundModifier) {
                visit_trait_bound_modifier(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_trait_item(&mut self, i: &'ast TraitItem) {
                visit_trait_item(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_trait_item_const(&mut self, i: &'ast TraitItemConst) {
                visit_trait_item_const(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_trait_item_macro(&mut self, i: &'ast TraitItemMacro) {
                visit_trait_item_macro(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_trait_item_method(&mut self, i: &'ast TraitItemMethod) {
                visit_trait_item_method(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_trait_item_type(&mut self, i: &'ast TraitItemType) {
                visit_trait_item_type(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type(&mut self, i: &'ast Type) {
                visit_type(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_array(&mut self, i: &'ast TypeArray) {
                visit_type_array(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_bare_fn(&mut self, i: &'ast TypeBareFn) {
                visit_type_bare_fn(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_group(&mut self, i: &'ast TypeGroup) {
                visit_type_group(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_impl_trait(&mut self, i: &'ast TypeImplTrait) {
                visit_type_impl_trait(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_infer(&mut self, i: &'ast TypeInfer) {
                visit_type_infer(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_macro(&mut self, i: &'ast TypeMacro) {
                visit_type_macro(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_never(&mut self, i: &'ast TypeNever) {
                visit_type_never(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_param(&mut self, i: &'ast TypeParam) {
                visit_type_param(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_param_bound(&mut self, i: &'ast TypeParamBound) {
                visit_type_param_bound(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_paren(&mut self, i: &'ast TypeParen) {
                visit_type_paren(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_path(&mut self, i: &'ast TypePath) {
                visit_type_path(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_ptr(&mut self, i: &'ast TypePtr) {
                visit_type_ptr(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_reference(&mut self, i: &'ast TypeReference) {
                visit_type_reference(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_slice(&mut self, i: &'ast TypeSlice) {
                visit_type_slice(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_trait_object(&mut self, i: &'ast TypeTraitObject) {
                visit_type_trait_object(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_tuple(&mut self, i: &'ast TypeTuple) {
                visit_type_tuple(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_un_op(&mut self, i: &'ast UnOp) {
                visit_un_op(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_use_glob(&mut self, i: &'ast UseGlob) {
                visit_use_glob(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_use_group(&mut self, i: &'ast UseGroup) {
                visit_use_group(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_use_name(&mut self, i: &'ast UseName) {
                visit_use_name(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_use_path(&mut self, i: &'ast UsePath) {
                visit_use_path(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_use_rename(&mut self, i: &'ast UseRename) {
                visit_use_rename(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_use_tree(&mut self, i: &'ast UseTree) {
                visit_use_tree(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_variadic(&mut self, i: &'ast Variadic) {
                visit_variadic(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_variant(&mut self, i: &'ast Variant) {
                visit_variant(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_vis_crate(&mut self, i: &'ast VisCrate) {
                visit_vis_crate(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_vis_public(&mut self, i: &'ast VisPublic) {
                visit_vis_public(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_vis_restricted(&mut self, i: &'ast VisRestricted) {
                visit_vis_restricted(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_visibility(&mut self, i: &'ast Visibility) {
                visit_visibility(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_where_clause(&mut self, i: &'ast WhereClause) {
                visit_where_clause(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_where_predicate(&mut self, i: &'ast WherePredicate) {
                visit_where_predicate(self, i);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_abi<'ast, V>(v: &mut V, node: &'ast Abi)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.extern_token.span);
            if let Some(it) = &node.name {
                v.visit_lit_str(it);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_angle_bracketed_generic_arguments<'ast, V>(
            v: &mut V,
            node: &'ast AngleBracketedGenericArguments,
        )
        where
            V: Visit<'ast> + ?Sized,
        {
            if let Some(it) = &node.colon2_token {
                tokens_helper(v, &it.spans);
            }
            tokens_helper(v, &node.lt_token.spans);
            for el in Punctuated::pairs(&node.args) {
                let (it, p) = el.into_tuple();
                v.visit_generic_argument(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
            tokens_helper(v, &node.gt_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_arm<'ast, V>(v: &mut V, node: &'ast Arm)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_pat(&node.pat);
            if let Some(it) = &node.guard {
                tokens_helper(v, &(it).0.span);
                v.visit_expr(&*(it).1);
            }
            tokens_helper(v, &node.fat_arrow_token.spans);
            v.visit_expr(&*node.body);
            if let Some(it) = &node.comma {
                tokens_helper(v, &it.spans);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_attr_style<'ast, V>(v: &mut V, node: &'ast AttrStyle)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                AttrStyle::Outer => {}
                AttrStyle::Inner(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_attribute<'ast, V>(v: &mut V, node: &'ast Attribute)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.pound_token.spans);
            v.visit_attr_style(&node.style);
            tokens_helper(v, &node.bracket_token.span);
            v.visit_path(&node.path);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_bare_fn_arg<'ast, V>(v: &mut V, node: &'ast BareFnArg)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            if let Some(it) = &node.name {
                v.visit_ident(&(it).0);
                tokens_helper(v, &(it).1.spans);
            }
            v.visit_type(&node.ty);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_bin_op<'ast, V>(v: &mut V, node: &'ast BinOp)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                BinOp::Add(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::Sub(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::Mul(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::Div(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::Rem(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::And(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::Or(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::BitXor(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::BitAnd(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::BitOr(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::Shl(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::Shr(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::Eq(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::Lt(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::Le(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::Ne(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::Ge(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::Gt(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::AddEq(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::SubEq(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::MulEq(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::DivEq(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::RemEq(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::BitXorEq(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::BitAndEq(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::BitOrEq(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::ShlEq(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                BinOp::ShrEq(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_binding<'ast, V>(v: &mut V, node: &'ast Binding)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_ident(&node.ident);
            tokens_helper(v, &node.eq_token.spans);
            v.visit_type(&node.ty);
        }
        #[cfg(feature = "full")]
        pub fn visit_block<'ast, V>(v: &mut V, node: &'ast Block)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.brace_token.span);
            for it in &node.stmts {
                v.visit_stmt(it);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_bound_lifetimes<'ast, V>(v: &mut V, node: &'ast BoundLifetimes)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.for_token.span);
            tokens_helper(v, &node.lt_token.spans);
            for el in Punctuated::pairs(&node.lifetimes) {
                let (it, p) = el.into_tuple();
                v.visit_lifetime_def(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
            tokens_helper(v, &node.gt_token.spans);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_const_param<'ast, V>(v: &mut V, node: &'ast ConstParam)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.const_token.span);
            v.visit_ident(&node.ident);
            tokens_helper(v, &node.colon_token.spans);
            v.visit_type(&node.ty);
            if let Some(it) = &node.eq_token {
                tokens_helper(v, &it.spans);
            }
            if let Some(it) = &node.default {
                v.visit_expr(it);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_constraint<'ast, V>(v: &mut V, node: &'ast Constraint)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_ident(&node.ident);
            tokens_helper(v, &node.colon_token.spans);
            for el in Punctuated::pairs(&node.bounds) {
                let (it, p) = el.into_tuple();
                v.visit_type_param_bound(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(feature = "derive")]
        pub fn visit_data<'ast, V>(v: &mut V, node: &'ast Data)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                Data::Struct(_binding_0) => {
                    v.visit_data_struct(_binding_0);
                }
                Data::Enum(_binding_0) => {
                    v.visit_data_enum(_binding_0);
                }
                Data::Union(_binding_0) => {
                    v.visit_data_union(_binding_0);
                }
            }
        }
        #[cfg(feature = "derive")]
        pub fn visit_data_enum<'ast, V>(v: &mut V, node: &'ast DataEnum)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.enum_token.span);
            tokens_helper(v, &node.brace_token.span);
            for el in Punctuated::pairs(&node.variants) {
                let (it, p) = el.into_tuple();
                v.visit_variant(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(feature = "derive")]
        pub fn visit_data_struct<'ast, V>(v: &mut V, node: &'ast DataStruct)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.struct_token.span);
            v.visit_fields(&node.fields);
            if let Some(it) = &node.semi_token {
                tokens_helper(v, &it.spans);
            }
        }
        #[cfg(feature = "derive")]
        pub fn visit_data_union<'ast, V>(v: &mut V, node: &'ast DataUnion)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.union_token.span);
            v.visit_fields_named(&node.fields);
        }
        #[cfg(feature = "derive")]
        pub fn visit_derive_input<'ast, V>(v: &mut V, node: &'ast DeriveInput)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            v.visit_ident(&node.ident);
            v.visit_generics(&node.generics);
            v.visit_data(&node.data);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr<'ast, V>(v: &mut V, node: &'ast Expr)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                Expr::Array(_binding_0) => {
                    v.visit_expr_array(_binding_0);
                }
                Expr::Assign(_binding_0) => {
                    v.visit_expr_assign(_binding_0);
                }
                Expr::AssignOp(_binding_0) => {
                    v.visit_expr_assign_op(_binding_0);
                }
                Expr::Async(_binding_0) => {
                    v.visit_expr_async(_binding_0);
                }
                Expr::Await(_binding_0) => {
                    v.visit_expr_await(_binding_0);
                }
                Expr::Binary(_binding_0) => {
                    v.visit_expr_binary(_binding_0);
                }
                Expr::Block(_binding_0) => {
                    v.visit_expr_block(_binding_0);
                }
                Expr::Box(_binding_0) => {
                    v.visit_expr_box(_binding_0);
                }
                Expr::Break(_binding_0) => {
                    v.visit_expr_break(_binding_0);
                }
                Expr::Call(_binding_0) => {
                    v.visit_expr_call(_binding_0);
                }
                Expr::Cast(_binding_0) => {
                    v.visit_expr_cast(_binding_0);
                }
                Expr::Closure(_binding_0) => {
                    v.visit_expr_closure(_binding_0);
                }
                Expr::Continue(_binding_0) => {
                    v.visit_expr_continue(_binding_0);
                }
                Expr::Field(_binding_0) => {
                    v.visit_expr_field(_binding_0);
                }
                Expr::ForLoop(_binding_0) => {
                    v.visit_expr_for_loop(_binding_0);
                }
                Expr::Group(_binding_0) => {
                    v.visit_expr_group(_binding_0);
                }
                Expr::If(_binding_0) => {
                    v.visit_expr_if(_binding_0);
                }
                Expr::Index(_binding_0) => {
                    v.visit_expr_index(_binding_0);
                }
                Expr::Let(_binding_0) => {
                    v.visit_expr_let(_binding_0);
                }
                Expr::Lit(_binding_0) => {
                    v.visit_expr_lit(_binding_0);
                }
                Expr::Loop(_binding_0) => {
                    v.visit_expr_loop(_binding_0);
                }
                Expr::Macro(_binding_0) => {
                    v.visit_expr_macro(_binding_0);
                }
                Expr::Match(_binding_0) => {
                    v.visit_expr_match(_binding_0);
                }
                Expr::MethodCall(_binding_0) => {
                    v.visit_expr_method_call(_binding_0);
                }
                Expr::Paren(_binding_0) => {
                    v.visit_expr_paren(_binding_0);
                }
                Expr::Path(_binding_0) => {
                    v.visit_expr_path(_binding_0);
                }
                Expr::Range(_binding_0) => {
                    v.visit_expr_range(_binding_0);
                }
                Expr::Reference(_binding_0) => {
                    v.visit_expr_reference(_binding_0);
                }
                Expr::Repeat(_binding_0) => {
                    v.visit_expr_repeat(_binding_0);
                }
                Expr::Return(_binding_0) => {
                    v.visit_expr_return(_binding_0);
                }
                Expr::Struct(_binding_0) => {
                    v.visit_expr_struct(_binding_0);
                }
                Expr::Try(_binding_0) => {
                    v.visit_expr_try(_binding_0);
                }
                Expr::TryBlock(_binding_0) => {
                    v.visit_expr_try_block(_binding_0);
                }
                Expr::Tuple(_binding_0) => {
                    v.visit_expr_tuple(_binding_0);
                }
                Expr::Type(_binding_0) => {
                    v.visit_expr_type(_binding_0);
                }
                Expr::Unary(_binding_0) => {
                    v.visit_expr_unary(_binding_0);
                }
                Expr::Unsafe(_binding_0) => {
                    v.visit_expr_unsafe(_binding_0);
                }
                Expr::Verbatim(_binding_0) => {}
                Expr::While(_binding_0) => {
                    v.visit_expr_while(_binding_0);
                }
                Expr::Yield(_binding_0) => {
                    v.visit_expr_yield(_binding_0);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_array<'ast, V>(v: &mut V, node: &'ast ExprArray)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.bracket_token.span);
            for el in Punctuated::pairs(&node.elems) {
                let (it, p) = el.into_tuple();
                v.visit_expr(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_assign<'ast, V>(v: &mut V, node: &'ast ExprAssign)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_expr(&*node.left);
            tokens_helper(v, &node.eq_token.spans);
            v.visit_expr(&*node.right);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_assign_op<'ast, V>(v: &mut V, node: &'ast ExprAssignOp)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_expr(&*node.left);
            v.visit_bin_op(&node.op);
            v.visit_expr(&*node.right);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_async<'ast, V>(v: &mut V, node: &'ast ExprAsync)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.async_token.span);
            if let Some(it) = &node.capture {
                tokens_helper(v, &it.span);
            }
            v.visit_block(&node.block);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_await<'ast, V>(v: &mut V, node: &'ast ExprAwait)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_expr(&*node.base);
            tokens_helper(v, &node.dot_token.spans);
            tokens_helper(v, &node.await_token.span);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_binary<'ast, V>(v: &mut V, node: &'ast ExprBinary)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_expr(&*node.left);
            v.visit_bin_op(&node.op);
            v.visit_expr(&*node.right);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_block<'ast, V>(v: &mut V, node: &'ast ExprBlock)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            if let Some(it) = &node.label {
                v.visit_label(it);
            }
            v.visit_block(&node.block);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_box<'ast, V>(v: &mut V, node: &'ast ExprBox)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.box_token.span);
            v.visit_expr(&*node.expr);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_break<'ast, V>(v: &mut V, node: &'ast ExprBreak)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.break_token.span);
            if let Some(it) = &node.label {
                v.visit_lifetime(it);
            }
            if let Some(it) = &node.expr {
                v.visit_expr(&**it);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_call<'ast, V>(v: &mut V, node: &'ast ExprCall)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_expr(&*node.func);
            tokens_helper(v, &node.paren_token.span);
            for el in Punctuated::pairs(&node.args) {
                let (it, p) = el.into_tuple();
                v.visit_expr(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_cast<'ast, V>(v: &mut V, node: &'ast ExprCast)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_expr(&*node.expr);
            tokens_helper(v, &node.as_token.span);
            v.visit_type(&*node.ty);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_closure<'ast, V>(v: &mut V, node: &'ast ExprClosure)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            if let Some(it) = &node.movability {
                tokens_helper(v, &it.span);
            }
            if let Some(it) = &node.asyncness {
                tokens_helper(v, &it.span);
            }
            if let Some(it) = &node.capture {
                tokens_helper(v, &it.span);
            }
            tokens_helper(v, &node.or1_token.spans);
            for el in Punctuated::pairs(&node.inputs) {
                let (it, p) = el.into_tuple();
                v.visit_pat(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
            tokens_helper(v, &node.or2_token.spans);
            v.visit_return_type(&node.output);
            v.visit_expr(&*node.body);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_continue<'ast, V>(v: &mut V, node: &'ast ExprContinue)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.continue_token.span);
            if let Some(it) = &node.label {
                v.visit_lifetime(it);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_field<'ast, V>(v: &mut V, node: &'ast ExprField)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_expr(&*node.base);
            tokens_helper(v, &node.dot_token.spans);
            v.visit_member(&node.member);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_for_loop<'ast, V>(v: &mut V, node: &'ast ExprForLoop)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            if let Some(it) = &node.label {
                v.visit_label(it);
            }
            tokens_helper(v, &node.for_token.span);
            v.visit_pat(&node.pat);
            tokens_helper(v, &node.in_token.span);
            v.visit_expr(&*node.expr);
            v.visit_block(&node.body);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_group<'ast, V>(v: &mut V, node: &'ast ExprGroup)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.group_token.span);
            v.visit_expr(&*node.expr);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_if<'ast, V>(v: &mut V, node: &'ast ExprIf)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.if_token.span);
            v.visit_expr(&*node.cond);
            v.visit_block(&node.then_branch);
            if let Some(it) = &node.else_branch {
                tokens_helper(v, &(it).0.span);
                v.visit_expr(&*(it).1);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_index<'ast, V>(v: &mut V, node: &'ast ExprIndex)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_expr(&*node.expr);
            tokens_helper(v, &node.bracket_token.span);
            v.visit_expr(&*node.index);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_let<'ast, V>(v: &mut V, node: &'ast ExprLet)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.let_token.span);
            v.visit_pat(&node.pat);
            tokens_helper(v, &node.eq_token.spans);
            v.visit_expr(&*node.expr);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_lit<'ast, V>(v: &mut V, node: &'ast ExprLit)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_lit(&node.lit);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_loop<'ast, V>(v: &mut V, node: &'ast ExprLoop)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            if let Some(it) = &node.label {
                v.visit_label(it);
            }
            tokens_helper(v, &node.loop_token.span);
            v.visit_block(&node.body);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_macro<'ast, V>(v: &mut V, node: &'ast ExprMacro)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_macro(&node.mac);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_match<'ast, V>(v: &mut V, node: &'ast ExprMatch)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.match_token.span);
            v.visit_expr(&*node.expr);
            tokens_helper(v, &node.brace_token.span);
            for it in &node.arms {
                v.visit_arm(it);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_method_call<'ast, V>(v: &mut V, node: &'ast ExprMethodCall)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_expr(&*node.receiver);
            tokens_helper(v, &node.dot_token.spans);
            v.visit_ident(&node.method);
            if let Some(it) = &node.turbofish {
                v.visit_method_turbofish(it);
            }
            tokens_helper(v, &node.paren_token.span);
            for el in Punctuated::pairs(&node.args) {
                let (it, p) = el.into_tuple();
                v.visit_expr(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_paren<'ast, V>(v: &mut V, node: &'ast ExprParen)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.paren_token.span);
            v.visit_expr(&*node.expr);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_path<'ast, V>(v: &mut V, node: &'ast ExprPath)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            if let Some(it) = &node.qself {
                v.visit_qself(it);
            }
            v.visit_path(&node.path);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_range<'ast, V>(v: &mut V, node: &'ast ExprRange)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            if let Some(it) = &node.from {
                v.visit_expr(&**it);
            }
            v.visit_range_limits(&node.limits);
            if let Some(it) = &node.to {
                v.visit_expr(&**it);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_reference<'ast, V>(v: &mut V, node: &'ast ExprReference)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.and_token.spans);
            if let Some(it) = &node.mutability {
                tokens_helper(v, &it.span);
            }
            v.visit_expr(&*node.expr);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_repeat<'ast, V>(v: &mut V, node: &'ast ExprRepeat)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.bracket_token.span);
            v.visit_expr(&*node.expr);
            tokens_helper(v, &node.semi_token.spans);
            v.visit_expr(&*node.len);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_return<'ast, V>(v: &mut V, node: &'ast ExprReturn)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.return_token.span);
            if let Some(it) = &node.expr {
                v.visit_expr(&**it);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_struct<'ast, V>(v: &mut V, node: &'ast ExprStruct)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_path(&node.path);
            tokens_helper(v, &node.brace_token.span);
            for el in Punctuated::pairs(&node.fields) {
                let (it, p) = el.into_tuple();
                v.visit_field_value(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
            if let Some(it) = &node.dot2_token {
                tokens_helper(v, &it.spans);
            }
            if let Some(it) = &node.rest {
                v.visit_expr(&**it);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_try<'ast, V>(v: &mut V, node: &'ast ExprTry)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_expr(&*node.expr);
            tokens_helper(v, &node.question_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_try_block<'ast, V>(v: &mut V, node: &'ast ExprTryBlock)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.try_token.span);
            v.visit_block(&node.block);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_tuple<'ast, V>(v: &mut V, node: &'ast ExprTuple)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.paren_token.span);
            for el in Punctuated::pairs(&node.elems) {
                let (it, p) = el.into_tuple();
                v.visit_expr(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_type<'ast, V>(v: &mut V, node: &'ast ExprType)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_expr(&*node.expr);
            tokens_helper(v, &node.colon_token.spans);
            v.visit_type(&*node.ty);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_unary<'ast, V>(v: &mut V, node: &'ast ExprUnary)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_un_op(&node.op);
            v.visit_expr(&*node.expr);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_unsafe<'ast, V>(v: &mut V, node: &'ast ExprUnsafe)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.unsafe_token.span);
            v.visit_block(&node.block);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_while<'ast, V>(v: &mut V, node: &'ast ExprWhile)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            if let Some(it) = &node.label {
                v.visit_label(it);
            }
            tokens_helper(v, &node.while_token.span);
            v.visit_expr(&*node.cond);
            v.visit_block(&node.body);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_yield<'ast, V>(v: &mut V, node: &'ast ExprYield)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.yield_token.span);
            if let Some(it) = &node.expr {
                v.visit_expr(&**it);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_field<'ast, V>(v: &mut V, node: &'ast Field)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            if let Some(it) = &node.ident {
                v.visit_ident(it);
            }
            if let Some(it) = &node.colon_token {
                tokens_helper(v, &it.spans);
            }
            v.visit_type(&node.ty);
        }
        #[cfg(feature = "full")]
        pub fn visit_field_pat<'ast, V>(v: &mut V, node: &'ast FieldPat)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_member(&node.member);
            if let Some(it) = &node.colon_token {
                tokens_helper(v, &it.spans);
            }
            v.visit_pat(&*node.pat);
        }
        #[cfg(feature = "full")]
        pub fn visit_field_value<'ast, V>(v: &mut V, node: &'ast FieldValue)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_member(&node.member);
            if let Some(it) = &node.colon_token {
                tokens_helper(v, &it.spans);
            }
            v.visit_expr(&node.expr);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_fields<'ast, V>(v: &mut V, node: &'ast Fields)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                Fields::Named(_binding_0) => {
                    v.visit_fields_named(_binding_0);
                }
                Fields::Unnamed(_binding_0) => {
                    v.visit_fields_unnamed(_binding_0);
                }
                Fields::Unit => {}
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_fields_named<'ast, V>(v: &mut V, node: &'ast FieldsNamed)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.brace_token.span);
            for el in Punctuated::pairs(&node.named) {
                let (it, p) = el.into_tuple();
                v.visit_field(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_fields_unnamed<'ast, V>(v: &mut V, node: &'ast FieldsUnnamed)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.paren_token.span);
            for el in Punctuated::pairs(&node.unnamed) {
                let (it, p) = el.into_tuple();
                v.visit_field(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_file<'ast, V>(v: &mut V, node: &'ast File)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            for it in &node.items {
                v.visit_item(it);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_fn_arg<'ast, V>(v: &mut V, node: &'ast FnArg)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                FnArg::Receiver(_binding_0) => {
                    v.visit_receiver(_binding_0);
                }
                FnArg::Typed(_binding_0) => {
                    v.visit_pat_type(_binding_0);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_foreign_item<'ast, V>(v: &mut V, node: &'ast ForeignItem)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                ForeignItem::Fn(_binding_0) => {
                    v.visit_foreign_item_fn(_binding_0);
                }
                ForeignItem::Static(_binding_0) => {
                    v.visit_foreign_item_static(_binding_0);
                }
                ForeignItem::Type(_binding_0) => {
                    v.visit_foreign_item_type(_binding_0);
                }
                ForeignItem::Macro(_binding_0) => {
                    v.visit_foreign_item_macro(_binding_0);
                }
                ForeignItem::Verbatim(_binding_0) => {}
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_foreign_item_fn<'ast, V>(v: &mut V, node: &'ast ForeignItemFn)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            v.visit_signature(&node.sig);
            tokens_helper(v, &node.semi_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_foreign_item_macro<'ast, V>(v: &mut V, node: &'ast ForeignItemMacro)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_macro(&node.mac);
            if let Some(it) = &node.semi_token {
                tokens_helper(v, &it.spans);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_foreign_item_static<'ast, V>(
            v: &mut V,
            node: &'ast ForeignItemStatic,
        )
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            tokens_helper(v, &node.static_token.span);
            if let Some(it) = &node.mutability {
                tokens_helper(v, &it.span);
            }
            v.visit_ident(&node.ident);
            tokens_helper(v, &node.colon_token.spans);
            v.visit_type(&*node.ty);
            tokens_helper(v, &node.semi_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_foreign_item_type<'ast, V>(v: &mut V, node: &'ast ForeignItemType)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            tokens_helper(v, &node.type_token.span);
            v.visit_ident(&node.ident);
            tokens_helper(v, &node.semi_token.spans);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_generic_argument<'ast, V>(v: &mut V, node: &'ast GenericArgument)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                GenericArgument::Lifetime(_binding_0) => {
                    v.visit_lifetime(_binding_0);
                }
                GenericArgument::Type(_binding_0) => {
                    v.visit_type(_binding_0);
                }
                GenericArgument::Binding(_binding_0) => {
                    v.visit_binding(_binding_0);
                }
                GenericArgument::Constraint(_binding_0) => {
                    v.visit_constraint(_binding_0);
                }
                GenericArgument::Const(_binding_0) => {
                    v.visit_expr(_binding_0);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_generic_method_argument<'ast, V>(
            v: &mut V,
            node: &'ast GenericMethodArgument,
        )
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                GenericMethodArgument::Type(_binding_0) => {
                    v.visit_type(_binding_0);
                }
                GenericMethodArgument::Const(_binding_0) => {
                    v.visit_expr(_binding_0);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_generic_param<'ast, V>(v: &mut V, node: &'ast GenericParam)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                GenericParam::Type(_binding_0) => {
                    v.visit_type_param(_binding_0);
                }
                GenericParam::Lifetime(_binding_0) => {
                    v.visit_lifetime_def(_binding_0);
                }
                GenericParam::Const(_binding_0) => {
                    v.visit_const_param(_binding_0);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_generics<'ast, V>(v: &mut V, node: &'ast Generics)
        where
            V: Visit<'ast> + ?Sized,
        {
            if let Some(it) = &node.lt_token {
                tokens_helper(v, &it.spans);
            }
            for el in Punctuated::pairs(&node.params) {
                let (it, p) = el.into_tuple();
                v.visit_generic_param(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
            if let Some(it) = &node.gt_token {
                tokens_helper(v, &it.spans);
            }
            if let Some(it) = &node.where_clause {
                v.visit_where_clause(it);
            }
        }
        pub fn visit_ident<'ast, V>(v: &mut V, node: &'ast Ident)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_span(&node.span());
        }
        #[cfg(feature = "full")]
        pub fn visit_impl_item<'ast, V>(v: &mut V, node: &'ast ImplItem)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                ImplItem::Const(_binding_0) => {
                    v.visit_impl_item_const(_binding_0);
                }
                ImplItem::Method(_binding_0) => {
                    v.visit_impl_item_method(_binding_0);
                }
                ImplItem::Type(_binding_0) => {
                    v.visit_impl_item_type(_binding_0);
                }
                ImplItem::Macro(_binding_0) => {
                    v.visit_impl_item_macro(_binding_0);
                }
                ImplItem::Verbatim(_binding_0) => {}
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_impl_item_const<'ast, V>(v: &mut V, node: &'ast ImplItemConst)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            if let Some(it) = &node.defaultness {
                tokens_helper(v, &it.span);
            }
            tokens_helper(v, &node.const_token.span);
            v.visit_ident(&node.ident);
            tokens_helper(v, &node.colon_token.spans);
            v.visit_type(&node.ty);
            tokens_helper(v, &node.eq_token.spans);
            v.visit_expr(&node.expr);
            tokens_helper(v, &node.semi_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_impl_item_macro<'ast, V>(v: &mut V, node: &'ast ImplItemMacro)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_macro(&node.mac);
            if let Some(it) = &node.semi_token {
                tokens_helper(v, &it.spans);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_impl_item_method<'ast, V>(v: &mut V, node: &'ast ImplItemMethod)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            if let Some(it) = &node.defaultness {
                tokens_helper(v, &it.span);
            }
            v.visit_signature(&node.sig);
            v.visit_block(&node.block);
        }
        #[cfg(feature = "full")]
        pub fn visit_impl_item_type<'ast, V>(v: &mut V, node: &'ast ImplItemType)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            if let Some(it) = &node.defaultness {
                tokens_helper(v, &it.span);
            }
            tokens_helper(v, &node.type_token.span);
            v.visit_ident(&node.ident);
            v.visit_generics(&node.generics);
            tokens_helper(v, &node.eq_token.spans);
            v.visit_type(&node.ty);
            tokens_helper(v, &node.semi_token.spans);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_index<'ast, V>(v: &mut V, node: &'ast Index)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_span(&node.span);
        }
        #[cfg(feature = "full")]
        pub fn visit_item<'ast, V>(v: &mut V, node: &'ast Item)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                Item::Const(_binding_0) => {
                    v.visit_item_const(_binding_0);
                }
                Item::Enum(_binding_0) => {
                    v.visit_item_enum(_binding_0);
                }
                Item::ExternCrate(_binding_0) => {
                    v.visit_item_extern_crate(_binding_0);
                }
                Item::Fn(_binding_0) => {
                    v.visit_item_fn(_binding_0);
                }
                Item::ForeignMod(_binding_0) => {
                    v.visit_item_foreign_mod(_binding_0);
                }
                Item::Impl(_binding_0) => {
                    v.visit_item_impl(_binding_0);
                }
                Item::Macro(_binding_0) => {
                    v.visit_item_macro(_binding_0);
                }
                Item::Macro2(_binding_0) => {
                    v.visit_item_macro2(_binding_0);
                }
                Item::Mod(_binding_0) => {
                    v.visit_item_mod(_binding_0);
                }
                Item::Static(_binding_0) => {
                    v.visit_item_static(_binding_0);
                }
                Item::Struct(_binding_0) => {
                    v.visit_item_struct(_binding_0);
                }
                Item::Trait(_binding_0) => {
                    v.visit_item_trait(_binding_0);
                }
                Item::TraitAlias(_binding_0) => {
                    v.visit_item_trait_alias(_binding_0);
                }
                Item::Type(_binding_0) => {
                    v.visit_item_type(_binding_0);
                }
                Item::Union(_binding_0) => {
                    v.visit_item_union(_binding_0);
                }
                Item::Use(_binding_0) => {
                    v.visit_item_use(_binding_0);
                }
                Item::Verbatim(_binding_0) => {}
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_item_const<'ast, V>(v: &mut V, node: &'ast ItemConst)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            tokens_helper(v, &node.const_token.span);
            v.visit_ident(&node.ident);
            tokens_helper(v, &node.colon_token.spans);
            v.visit_type(&*node.ty);
            tokens_helper(v, &node.eq_token.spans);
            v.visit_expr(&*node.expr);
            tokens_helper(v, &node.semi_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_item_enum<'ast, V>(v: &mut V, node: &'ast ItemEnum)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            tokens_helper(v, &node.enum_token.span);
            v.visit_ident(&node.ident);
            v.visit_generics(&node.generics);
            tokens_helper(v, &node.brace_token.span);
            for el in Punctuated::pairs(&node.variants) {
                let (it, p) = el.into_tuple();
                v.visit_variant(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_item_extern_crate<'ast, V>(v: &mut V, node: &'ast ItemExternCrate)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            tokens_helper(v, &node.extern_token.span);
            tokens_helper(v, &node.crate_token.span);
            v.visit_ident(&node.ident);
            if let Some(it) = &node.rename {
                tokens_helper(v, &(it).0.span);
                v.visit_ident(&(it).1);
            }
            tokens_helper(v, &node.semi_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_item_fn<'ast, V>(v: &mut V, node: &'ast ItemFn)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            v.visit_signature(&node.sig);
            v.visit_block(&*node.block);
        }
        #[cfg(feature = "full")]
        pub fn visit_item_foreign_mod<'ast, V>(v: &mut V, node: &'ast ItemForeignMod)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_abi(&node.abi);
            tokens_helper(v, &node.brace_token.span);
            for it in &node.items {
                v.visit_foreign_item(it);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_item_impl<'ast, V>(v: &mut V, node: &'ast ItemImpl)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            if let Some(it) = &node.defaultness {
                tokens_helper(v, &it.span);
            }
            if let Some(it) = &node.unsafety {
                tokens_helper(v, &it.span);
            }
            tokens_helper(v, &node.impl_token.span);
            v.visit_generics(&node.generics);
            if let Some(it) = &node.trait_ {
                if let Some(it) = &(it).0 {
                    tokens_helper(v, &it.spans);
                }
                v.visit_path(&(it).1);
                tokens_helper(v, &(it).2.span);
            }
            v.visit_type(&*node.self_ty);
            tokens_helper(v, &node.brace_token.span);
            for it in &node.items {
                v.visit_impl_item(it);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_item_macro<'ast, V>(v: &mut V, node: &'ast ItemMacro)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            if let Some(it) = &node.ident {
                v.visit_ident(it);
            }
            v.visit_macro(&node.mac);
            if let Some(it) = &node.semi_token {
                tokens_helper(v, &it.spans);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_item_macro2<'ast, V>(v: &mut V, node: &'ast ItemMacro2)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            tokens_helper(v, &node.macro_token.span);
            v.visit_ident(&node.ident);
        }
        #[cfg(feature = "full")]
        pub fn visit_item_mod<'ast, V>(v: &mut V, node: &'ast ItemMod)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            tokens_helper(v, &node.mod_token.span);
            v.visit_ident(&node.ident);
            if let Some(it) = &node.content {
                tokens_helper(v, &(it).0.span);
                for it in &(it).1 {
                    v.visit_item(it);
                }
            }
            if let Some(it) = &node.semi {
                tokens_helper(v, &it.spans);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_item_static<'ast, V>(v: &mut V, node: &'ast ItemStatic)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            tokens_helper(v, &node.static_token.span);
            if let Some(it) = &node.mutability {
                tokens_helper(v, &it.span);
            }
            v.visit_ident(&node.ident);
            tokens_helper(v, &node.colon_token.spans);
            v.visit_type(&*node.ty);
            tokens_helper(v, &node.eq_token.spans);
            v.visit_expr(&*node.expr);
            tokens_helper(v, &node.semi_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_item_struct<'ast, V>(v: &mut V, node: &'ast ItemStruct)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            tokens_helper(v, &node.struct_token.span);
            v.visit_ident(&node.ident);
            v.visit_generics(&node.generics);
            v.visit_fields(&node.fields);
            if let Some(it) = &node.semi_token {
                tokens_helper(v, &it.spans);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_item_trait<'ast, V>(v: &mut V, node: &'ast ItemTrait)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            if let Some(it) = &node.unsafety {
                tokens_helper(v, &it.span);
            }
            if let Some(it) = &node.auto_token {
                tokens_helper(v, &it.span);
            }
            tokens_helper(v, &node.trait_token.span);
            v.visit_ident(&node.ident);
            v.visit_generics(&node.generics);
            if let Some(it) = &node.colon_token {
                tokens_helper(v, &it.spans);
            }
            for el in Punctuated::pairs(&node.supertraits) {
                let (it, p) = el.into_tuple();
                v.visit_type_param_bound(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
            tokens_helper(v, &node.brace_token.span);
            for it in &node.items {
                v.visit_trait_item(it);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_item_trait_alias<'ast, V>(v: &mut V, node: &'ast ItemTraitAlias)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            tokens_helper(v, &node.trait_token.span);
            v.visit_ident(&node.ident);
            v.visit_generics(&node.generics);
            tokens_helper(v, &node.eq_token.spans);
            for el in Punctuated::pairs(&node.bounds) {
                let (it, p) = el.into_tuple();
                v.visit_type_param_bound(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
            tokens_helper(v, &node.semi_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_item_type<'ast, V>(v: &mut V, node: &'ast ItemType)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            tokens_helper(v, &node.type_token.span);
            v.visit_ident(&node.ident);
            v.visit_generics(&node.generics);
            tokens_helper(v, &node.eq_token.spans);
            v.visit_type(&*node.ty);
            tokens_helper(v, &node.semi_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_item_union<'ast, V>(v: &mut V, node: &'ast ItemUnion)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            tokens_helper(v, &node.union_token.span);
            v.visit_ident(&node.ident);
            v.visit_generics(&node.generics);
            v.visit_fields_named(&node.fields);
        }
        #[cfg(feature = "full")]
        pub fn visit_item_use<'ast, V>(v: &mut V, node: &'ast ItemUse)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_visibility(&node.vis);
            tokens_helper(v, &node.use_token.span);
            if let Some(it) = &node.leading_colon {
                tokens_helper(v, &it.spans);
            }
            v.visit_use_tree(&node.tree);
            tokens_helper(v, &node.semi_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_label<'ast, V>(v: &mut V, node: &'ast Label)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_lifetime(&node.name);
            tokens_helper(v, &node.colon_token.spans);
        }
        pub fn visit_lifetime<'ast, V>(v: &mut V, node: &'ast Lifetime)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_span(&node.apostrophe);
            v.visit_ident(&node.ident);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_lifetime_def<'ast, V>(v: &mut V, node: &'ast LifetimeDef)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_lifetime(&node.lifetime);
            if let Some(it) = &node.colon_token {
                tokens_helper(v, &it.spans);
            }
            for el in Punctuated::pairs(&node.bounds) {
                let (it, p) = el.into_tuple();
                v.visit_lifetime(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        pub fn visit_lit<'ast, V>(v: &mut V, node: &'ast Lit)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                Lit::Str(_binding_0) => {
                    v.visit_lit_str(_binding_0);
                }
                Lit::ByteStr(_binding_0) => {
                    v.visit_lit_byte_str(_binding_0);
                }
                Lit::Byte(_binding_0) => {
                    v.visit_lit_byte(_binding_0);
                }
                Lit::Char(_binding_0) => {
                    v.visit_lit_char(_binding_0);
                }
                Lit::Int(_binding_0) => {
                    v.visit_lit_int(_binding_0);
                }
                Lit::Float(_binding_0) => {
                    v.visit_lit_float(_binding_0);
                }
                Lit::Bool(_binding_0) => {
                    v.visit_lit_bool(_binding_0);
                }
                Lit::Verbatim(_binding_0) => {}
            }
        }
        pub fn visit_lit_bool<'ast, V>(v: &mut V, node: &'ast LitBool)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_span(&node.span);
        }
        pub fn visit_lit_byte<'ast, V>(v: &mut V, node: &'ast LitByte)
        where
            V: Visit<'ast> + ?Sized,
        {}
        pub fn visit_lit_byte_str<'ast, V>(v: &mut V, node: &'ast LitByteStr)
        where
            V: Visit<'ast> + ?Sized,
        {}
        pub fn visit_lit_char<'ast, V>(v: &mut V, node: &'ast LitChar)
        where
            V: Visit<'ast> + ?Sized,
        {}
        pub fn visit_lit_float<'ast, V>(v: &mut V, node: &'ast LitFloat)
        where
            V: Visit<'ast> + ?Sized,
        {}
        pub fn visit_lit_int<'ast, V>(v: &mut V, node: &'ast LitInt)
        where
            V: Visit<'ast> + ?Sized,
        {}
        pub fn visit_lit_str<'ast, V>(v: &mut V, node: &'ast LitStr)
        where
            V: Visit<'ast> + ?Sized,
        {}
        #[cfg(feature = "full")]
        pub fn visit_local<'ast, V>(v: &mut V, node: &'ast Local)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.let_token.span);
            v.visit_pat(&node.pat);
            if let Some(it) = &node.init {
                tokens_helper(v, &(it).0.spans);
                v.visit_expr(&*(it).1);
            }
            tokens_helper(v, &node.semi_token.spans);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_macro<'ast, V>(v: &mut V, node: &'ast Macro)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_path(&node.path);
            tokens_helper(v, &node.bang_token.spans);
            v.visit_macro_delimiter(&node.delimiter);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_macro_delimiter<'ast, V>(v: &mut V, node: &'ast MacroDelimiter)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                MacroDelimiter::Paren(_binding_0) => {
                    tokens_helper(v, &_binding_0.span);
                }
                MacroDelimiter::Brace(_binding_0) => {
                    tokens_helper(v, &_binding_0.span);
                }
                MacroDelimiter::Bracket(_binding_0) => {
                    tokens_helper(v, &_binding_0.span);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_member<'ast, V>(v: &mut V, node: &'ast Member)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                Member::Named(_binding_0) => {
                    v.visit_ident(_binding_0);
                }
                Member::Unnamed(_binding_0) => {
                    v.visit_index(_binding_0);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_meta<'ast, V>(v: &mut V, node: &'ast Meta)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                Meta::Path(_binding_0) => {
                    v.visit_path(_binding_0);
                }
                Meta::List(_binding_0) => {
                    v.visit_meta_list(_binding_0);
                }
                Meta::NameValue(_binding_0) => {
                    v.visit_meta_name_value(_binding_0);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_meta_list<'ast, V>(v: &mut V, node: &'ast MetaList)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_path(&node.path);
            tokens_helper(v, &node.paren_token.span);
            for el in Punctuated::pairs(&node.nested) {
                let (it, p) = el.into_tuple();
                v.visit_nested_meta(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_meta_name_value<'ast, V>(v: &mut V, node: &'ast MetaNameValue)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_path(&node.path);
            tokens_helper(v, &node.eq_token.spans);
            v.visit_lit(&node.lit);
        }
        #[cfg(feature = "full")]
        pub fn visit_method_turbofish<'ast, V>(v: &mut V, node: &'ast MethodTurbofish)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.colon2_token.spans);
            tokens_helper(v, &node.lt_token.spans);
            for el in Punctuated::pairs(&node.args) {
                let (it, p) = el.into_tuple();
                v.visit_generic_method_argument(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
            tokens_helper(v, &node.gt_token.spans);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_nested_meta<'ast, V>(v: &mut V, node: &'ast NestedMeta)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                NestedMeta::Meta(_binding_0) => {
                    v.visit_meta(_binding_0);
                }
                NestedMeta::Lit(_binding_0) => {
                    v.visit_lit(_binding_0);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_parenthesized_generic_arguments<'ast, V>(
            v: &mut V,
            node: &'ast ParenthesizedGenericArguments,
        )
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.paren_token.span);
            for el in Punctuated::pairs(&node.inputs) {
                let (it, p) = el.into_tuple();
                v.visit_type(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
            v.visit_return_type(&node.output);
        }
        #[cfg(feature = "full")]
        pub fn visit_pat<'ast, V>(v: &mut V, node: &'ast Pat)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                Pat::Box(_binding_0) => {
                    v.visit_pat_box(_binding_0);
                }
                Pat::Ident(_binding_0) => {
                    v.visit_pat_ident(_binding_0);
                }
                Pat::Lit(_binding_0) => {
                    v.visit_pat_lit(_binding_0);
                }
                Pat::Macro(_binding_0) => {
                    v.visit_pat_macro(_binding_0);
                }
                Pat::Or(_binding_0) => {
                    v.visit_pat_or(_binding_0);
                }
                Pat::Path(_binding_0) => {
                    v.visit_pat_path(_binding_0);
                }
                Pat::Range(_binding_0) => {
                    v.visit_pat_range(_binding_0);
                }
                Pat::Reference(_binding_0) => {
                    v.visit_pat_reference(_binding_0);
                }
                Pat::Rest(_binding_0) => {
                    v.visit_pat_rest(_binding_0);
                }
                Pat::Slice(_binding_0) => {
                    v.visit_pat_slice(_binding_0);
                }
                Pat::Struct(_binding_0) => {
                    v.visit_pat_struct(_binding_0);
                }
                Pat::Tuple(_binding_0) => {
                    v.visit_pat_tuple(_binding_0);
                }
                Pat::TupleStruct(_binding_0) => {
                    v.visit_pat_tuple_struct(_binding_0);
                }
                Pat::Type(_binding_0) => {
                    v.visit_pat_type(_binding_0);
                }
                Pat::Verbatim(_binding_0) => {}
                Pat::Wild(_binding_0) => {
                    v.visit_pat_wild(_binding_0);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_box<'ast, V>(v: &mut V, node: &'ast PatBox)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.box_token.span);
            v.visit_pat(&*node.pat);
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_ident<'ast, V>(v: &mut V, node: &'ast PatIdent)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            if let Some(it) = &node.by_ref {
                tokens_helper(v, &it.span);
            }
            if let Some(it) = &node.mutability {
                tokens_helper(v, &it.span);
            }
            v.visit_ident(&node.ident);
            if let Some(it) = &node.subpat {
                tokens_helper(v, &(it).0.spans);
                v.visit_pat(&*(it).1);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_lit<'ast, V>(v: &mut V, node: &'ast PatLit)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_expr(&*node.expr);
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_macro<'ast, V>(v: &mut V, node: &'ast PatMacro)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_macro(&node.mac);
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_or<'ast, V>(v: &mut V, node: &'ast PatOr)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            if let Some(it) = &node.leading_vert {
                tokens_helper(v, &it.spans);
            }
            for el in Punctuated::pairs(&node.cases) {
                let (it, p) = el.into_tuple();
                v.visit_pat(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_path<'ast, V>(v: &mut V, node: &'ast PatPath)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            if let Some(it) = &node.qself {
                v.visit_qself(it);
            }
            v.visit_path(&node.path);
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_range<'ast, V>(v: &mut V, node: &'ast PatRange)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_expr(&*node.lo);
            v.visit_range_limits(&node.limits);
            v.visit_expr(&*node.hi);
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_reference<'ast, V>(v: &mut V, node: &'ast PatReference)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.and_token.spans);
            if let Some(it) = &node.mutability {
                tokens_helper(v, &it.span);
            }
            v.visit_pat(&*node.pat);
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_rest<'ast, V>(v: &mut V, node: &'ast PatRest)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.dot2_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_slice<'ast, V>(v: &mut V, node: &'ast PatSlice)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.bracket_token.span);
            for el in Punctuated::pairs(&node.elems) {
                let (it, p) = el.into_tuple();
                v.visit_pat(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_struct<'ast, V>(v: &mut V, node: &'ast PatStruct)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_path(&node.path);
            tokens_helper(v, &node.brace_token.span);
            for el in Punctuated::pairs(&node.fields) {
                let (it, p) = el.into_tuple();
                v.visit_field_pat(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
            if let Some(it) = &node.dot2_token {
                tokens_helper(v, &it.spans);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_tuple<'ast, V>(v: &mut V, node: &'ast PatTuple)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.paren_token.span);
            for el in Punctuated::pairs(&node.elems) {
                let (it, p) = el.into_tuple();
                v.visit_pat(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_tuple_struct<'ast, V>(v: &mut V, node: &'ast PatTupleStruct)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_path(&node.path);
            v.visit_pat_tuple(&node.pat);
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_type<'ast, V>(v: &mut V, node: &'ast PatType)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_pat(&*node.pat);
            tokens_helper(v, &node.colon_token.spans);
            v.visit_type(&*node.ty);
        }
        #[cfg(feature = "full")]
        pub fn visit_pat_wild<'ast, V>(v: &mut V, node: &'ast PatWild)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.underscore_token.spans);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_path<'ast, V>(v: &mut V, node: &'ast Path)
        where
            V: Visit<'ast> + ?Sized,
        {
            if let Some(it) = &node.leading_colon {
                tokens_helper(v, &it.spans);
            }
            for el in Punctuated::pairs(&node.segments) {
                let (it, p) = el.into_tuple();
                v.visit_path_segment(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_path_arguments<'ast, V>(v: &mut V, node: &'ast PathArguments)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                PathArguments::None => {}
                PathArguments::AngleBracketed(_binding_0) => {
                    v.visit_angle_bracketed_generic_arguments(_binding_0);
                }
                PathArguments::Parenthesized(_binding_0) => {
                    v.visit_parenthesized_generic_arguments(_binding_0);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_path_segment<'ast, V>(v: &mut V, node: &'ast PathSegment)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_ident(&node.ident);
            v.visit_path_arguments(&node.arguments);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_predicate_eq<'ast, V>(v: &mut V, node: &'ast PredicateEq)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_type(&node.lhs_ty);
            tokens_helper(v, &node.eq_token.spans);
            v.visit_type(&node.rhs_ty);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_predicate_lifetime<'ast, V>(
            v: &mut V,
            node: &'ast PredicateLifetime,
        )
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_lifetime(&node.lifetime);
            tokens_helper(v, &node.colon_token.spans);
            for el in Punctuated::pairs(&node.bounds) {
                let (it, p) = el.into_tuple();
                v.visit_lifetime(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_predicate_type<'ast, V>(v: &mut V, node: &'ast PredicateType)
        where
            V: Visit<'ast> + ?Sized,
        {
            if let Some(it) = &node.lifetimes {
                v.visit_bound_lifetimes(it);
            }
            v.visit_type(&node.bounded_ty);
            tokens_helper(v, &node.colon_token.spans);
            for el in Punctuated::pairs(&node.bounds) {
                let (it, p) = el.into_tuple();
                v.visit_type_param_bound(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_qself<'ast, V>(v: &mut V, node: &'ast QSelf)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.lt_token.spans);
            v.visit_type(&*node.ty);
            if let Some(it) = &node.as_token {
                tokens_helper(v, &it.span);
            }
            tokens_helper(v, &node.gt_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_range_limits<'ast, V>(v: &mut V, node: &'ast RangeLimits)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                RangeLimits::HalfOpen(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                RangeLimits::Closed(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_receiver<'ast, V>(v: &mut V, node: &'ast Receiver)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            if let Some(it) = &node.reference {
                tokens_helper(v, &(it).0.spans);
                if let Some(it) = &(it).1 {
                    v.visit_lifetime(it);
                }
            }
            if let Some(it) = &node.mutability {
                tokens_helper(v, &it.span);
            }
            tokens_helper(v, &node.self_token.span);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_return_type<'ast, V>(v: &mut V, node: &'ast ReturnType)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                ReturnType::Default => {}
                ReturnType::Type(_binding_0, _binding_1) => {
                    tokens_helper(v, &_binding_0.spans);
                    v.visit_type(&**_binding_1);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_signature<'ast, V>(v: &mut V, node: &'ast Signature)
        where
            V: Visit<'ast> + ?Sized,
        {
            if let Some(it) = &node.constness {
                tokens_helper(v, &it.span);
            }
            if let Some(it) = &node.asyncness {
                tokens_helper(v, &it.span);
            }
            if let Some(it) = &node.unsafety {
                tokens_helper(v, &it.span);
            }
            if let Some(it) = &node.abi {
                v.visit_abi(it);
            }
            tokens_helper(v, &node.fn_token.span);
            v.visit_ident(&node.ident);
            v.visit_generics(&node.generics);
            tokens_helper(v, &node.paren_token.span);
            for el in Punctuated::pairs(&node.inputs) {
                let (it, p) = el.into_tuple();
                v.visit_fn_arg(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
            if let Some(it) = &node.variadic {
                v.visit_variadic(it);
            }
            v.visit_return_type(&node.output);
        }
        pub fn visit_span<'ast, V>(v: &mut V, node: &Span)
        where
            V: Visit<'ast> + ?Sized,
        {}
        #[cfg(feature = "full")]
        pub fn visit_stmt<'ast, V>(v: &mut V, node: &'ast Stmt)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                Stmt::Local(_binding_0) => {
                    v.visit_local(_binding_0);
                }
                Stmt::Item(_binding_0) => {
                    v.visit_item(_binding_0);
                }
                Stmt::Expr(_binding_0) => {
                    v.visit_expr(_binding_0);
                }
                Stmt::Semi(_binding_0, _binding_1) => {
                    v.visit_expr(_binding_0);
                    tokens_helper(v, &_binding_1.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_trait_bound<'ast, V>(v: &mut V, node: &'ast TraitBound)
        where
            V: Visit<'ast> + ?Sized,
        {
            if let Some(it) = &node.paren_token {
                tokens_helper(v, &it.span);
            }
            v.visit_trait_bound_modifier(&node.modifier);
            if let Some(it) = &node.lifetimes {
                v.visit_bound_lifetimes(it);
            }
            v.visit_path(&node.path);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_trait_bound_modifier<'ast, V>(
            v: &mut V,
            node: &'ast TraitBoundModifier,
        )
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                TraitBoundModifier::None => {}
                TraitBoundModifier::Maybe(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_trait_item<'ast, V>(v: &mut V, node: &'ast TraitItem)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                TraitItem::Const(_binding_0) => {
                    v.visit_trait_item_const(_binding_0);
                }
                TraitItem::Method(_binding_0) => {
                    v.visit_trait_item_method(_binding_0);
                }
                TraitItem::Type(_binding_0) => {
                    v.visit_trait_item_type(_binding_0);
                }
                TraitItem::Macro(_binding_0) => {
                    v.visit_trait_item_macro(_binding_0);
                }
                TraitItem::Verbatim(_binding_0) => {}
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_trait_item_const<'ast, V>(v: &mut V, node: &'ast TraitItemConst)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.const_token.span);
            v.visit_ident(&node.ident);
            tokens_helper(v, &node.colon_token.spans);
            v.visit_type(&node.ty);
            if let Some(it) = &node.default {
                tokens_helper(v, &(it).0.spans);
                v.visit_expr(&(it).1);
            }
            tokens_helper(v, &node.semi_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_trait_item_macro<'ast, V>(v: &mut V, node: &'ast TraitItemMacro)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_macro(&node.mac);
            if let Some(it) = &node.semi_token {
                tokens_helper(v, &it.spans);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_trait_item_method<'ast, V>(v: &mut V, node: &'ast TraitItemMethod)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_signature(&node.sig);
            if let Some(it) = &node.default {
                v.visit_block(it);
            }
            if let Some(it) = &node.semi_token {
                tokens_helper(v, &it.spans);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_trait_item_type<'ast, V>(v: &mut V, node: &'ast TraitItemType)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.type_token.span);
            v.visit_ident(&node.ident);
            v.visit_generics(&node.generics);
            if let Some(it) = &node.colon_token {
                tokens_helper(v, &it.spans);
            }
            for el in Punctuated::pairs(&node.bounds) {
                let (it, p) = el.into_tuple();
                v.visit_type_param_bound(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
            if let Some(it) = &node.default {
                tokens_helper(v, &(it).0.spans);
                v.visit_type(&(it).1);
            }
            tokens_helper(v, &node.semi_token.spans);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type<'ast, V>(v: &mut V, node: &'ast Type)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                Type::Array(_binding_0) => {
                    v.visit_type_array(_binding_0);
                }
                Type::BareFn(_binding_0) => {
                    v.visit_type_bare_fn(_binding_0);
                }
                Type::Group(_binding_0) => {
                    v.visit_type_group(_binding_0);
                }
                Type::ImplTrait(_binding_0) => {
                    v.visit_type_impl_trait(_binding_0);
                }
                Type::Infer(_binding_0) => {
                    v.visit_type_infer(_binding_0);
                }
                Type::Macro(_binding_0) => {
                    v.visit_type_macro(_binding_0);
                }
                Type::Never(_binding_0) => {
                    v.visit_type_never(_binding_0);
                }
                Type::Paren(_binding_0) => {
                    v.visit_type_paren(_binding_0);
                }
                Type::Path(_binding_0) => {
                    v.visit_type_path(_binding_0);
                }
                Type::Ptr(_binding_0) => {
                    v.visit_type_ptr(_binding_0);
                }
                Type::Reference(_binding_0) => {
                    v.visit_type_reference(_binding_0);
                }
                Type::Slice(_binding_0) => {
                    v.visit_type_slice(_binding_0);
                }
                Type::TraitObject(_binding_0) => {
                    v.visit_type_trait_object(_binding_0);
                }
                Type::Tuple(_binding_0) => {
                    v.visit_type_tuple(_binding_0);
                }
                Type::Verbatim(_binding_0) => {}
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_array<'ast, V>(v: &mut V, node: &'ast TypeArray)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.bracket_token.span);
            v.visit_type(&*node.elem);
            tokens_helper(v, &node.semi_token.spans);
            v.visit_expr(&node.len);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_bare_fn<'ast, V>(v: &mut V, node: &'ast TypeBareFn)
        where
            V: Visit<'ast> + ?Sized,
        {
            if let Some(it) = &node.lifetimes {
                v.visit_bound_lifetimes(it);
            }
            if let Some(it) = &node.unsafety {
                tokens_helper(v, &it.span);
            }
            if let Some(it) = &node.abi {
                v.visit_abi(it);
            }
            tokens_helper(v, &node.fn_token.span);
            tokens_helper(v, &node.paren_token.span);
            for el in Punctuated::pairs(&node.inputs) {
                let (it, p) = el.into_tuple();
                v.visit_bare_fn_arg(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
            if let Some(it) = &node.variadic {
                v.visit_variadic(it);
            }
            v.visit_return_type(&node.output);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_group<'ast, V>(v: &mut V, node: &'ast TypeGroup)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.group_token.span);
            v.visit_type(&*node.elem);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_impl_trait<'ast, V>(v: &mut V, node: &'ast TypeImplTrait)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.impl_token.span);
            for el in Punctuated::pairs(&node.bounds) {
                let (it, p) = el.into_tuple();
                v.visit_type_param_bound(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_infer<'ast, V>(v: &mut V, node: &'ast TypeInfer)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.underscore_token.spans);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_macro<'ast, V>(v: &mut V, node: &'ast TypeMacro)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_macro(&node.mac);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_never<'ast, V>(v: &mut V, node: &'ast TypeNever)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.bang_token.spans);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_param<'ast, V>(v: &mut V, node: &'ast TypeParam)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_ident(&node.ident);
            if let Some(it) = &node.colon_token {
                tokens_helper(v, &it.spans);
            }
            for el in Punctuated::pairs(&node.bounds) {
                let (it, p) = el.into_tuple();
                v.visit_type_param_bound(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
            if let Some(it) = &node.eq_token {
                tokens_helper(v, &it.spans);
            }
            if let Some(it) = &node.default {
                v.visit_type(it);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_param_bound<'ast, V>(v: &mut V, node: &'ast TypeParamBound)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                TypeParamBound::Trait(_binding_0) => {
                    v.visit_trait_bound(_binding_0);
                }
                TypeParamBound::Lifetime(_binding_0) => {
                    v.visit_lifetime(_binding_0);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_paren<'ast, V>(v: &mut V, node: &'ast TypeParen)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.paren_token.span);
            v.visit_type(&*node.elem);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_path<'ast, V>(v: &mut V, node: &'ast TypePath)
        where
            V: Visit<'ast> + ?Sized,
        {
            if let Some(it) = &node.qself {
                v.visit_qself(it);
            }
            v.visit_path(&node.path);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_ptr<'ast, V>(v: &mut V, node: &'ast TypePtr)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.star_token.spans);
            if let Some(it) = &node.const_token {
                tokens_helper(v, &it.span);
            }
            if let Some(it) = &node.mutability {
                tokens_helper(v, &it.span);
            }
            v.visit_type(&*node.elem);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_reference<'ast, V>(v: &mut V, node: &'ast TypeReference)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.and_token.spans);
            if let Some(it) = &node.lifetime {
                v.visit_lifetime(it);
            }
            if let Some(it) = &node.mutability {
                tokens_helper(v, &it.span);
            }
            v.visit_type(&*node.elem);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_slice<'ast, V>(v: &mut V, node: &'ast TypeSlice)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.bracket_token.span);
            v.visit_type(&*node.elem);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_trait_object<'ast, V>(v: &mut V, node: &'ast TypeTraitObject)
        where
            V: Visit<'ast> + ?Sized,
        {
            if let Some(it) = &node.dyn_token {
                tokens_helper(v, &it.span);
            }
            for el in Punctuated::pairs(&node.bounds) {
                let (it, p) = el.into_tuple();
                v.visit_type_param_bound(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_type_tuple<'ast, V>(v: &mut V, node: &'ast TypeTuple)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.paren_token.span);
            for el in Punctuated::pairs(&node.elems) {
                let (it, p) = el.into_tuple();
                v.visit_type(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_un_op<'ast, V>(v: &mut V, node: &'ast UnOp)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                UnOp::Deref(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                UnOp::Not(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
                UnOp::Neg(_binding_0) => {
                    tokens_helper(v, &_binding_0.spans);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_use_glob<'ast, V>(v: &mut V, node: &'ast UseGlob)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.star_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_use_group<'ast, V>(v: &mut V, node: &'ast UseGroup)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.brace_token.span);
            for el in Punctuated::pairs(&node.items) {
                let (it, p) = el.into_tuple();
                v.visit_use_tree(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_use_name<'ast, V>(v: &mut V, node: &'ast UseName)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_ident(&node.ident);
        }
        #[cfg(feature = "full")]
        pub fn visit_use_path<'ast, V>(v: &mut V, node: &'ast UsePath)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_ident(&node.ident);
            tokens_helper(v, &node.colon2_token.spans);
            v.visit_use_tree(&*node.tree);
        }
        #[cfg(feature = "full")]
        pub fn visit_use_rename<'ast, V>(v: &mut V, node: &'ast UseRename)
        where
            V: Visit<'ast> + ?Sized,
        {
            v.visit_ident(&node.ident);
            tokens_helper(v, &node.as_token.span);
            v.visit_ident(&node.rename);
        }
        #[cfg(feature = "full")]
        pub fn visit_use_tree<'ast, V>(v: &mut V, node: &'ast UseTree)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                UseTree::Path(_binding_0) => {
                    v.visit_use_path(_binding_0);
                }
                UseTree::Name(_binding_0) => {
                    v.visit_use_name(_binding_0);
                }
                UseTree::Rename(_binding_0) => {
                    v.visit_use_rename(_binding_0);
                }
                UseTree::Glob(_binding_0) => {
                    v.visit_use_glob(_binding_0);
                }
                UseTree::Group(_binding_0) => {
                    v.visit_use_group(_binding_0);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_variadic<'ast, V>(v: &mut V, node: &'ast Variadic)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            tokens_helper(v, &node.dots.spans);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_variant<'ast, V>(v: &mut V, node: &'ast Variant)
        where
            V: Visit<'ast> + ?Sized,
        {
            for it in &node.attrs {
                v.visit_attribute(it);
            }
            v.visit_ident(&node.ident);
            v.visit_fields(&node.fields);
            if let Some(it) = &node.discriminant {
                tokens_helper(v, &(it).0.spans);
                v.visit_expr(&(it).1);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_vis_crate<'ast, V>(v: &mut V, node: &'ast VisCrate)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.crate_token.span);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_vis_public<'ast, V>(v: &mut V, node: &'ast VisPublic)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.pub_token.span);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_vis_restricted<'ast, V>(v: &mut V, node: &'ast VisRestricted)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.pub_token.span);
            tokens_helper(v, &node.paren_token.span);
            if let Some(it) = &node.in_token {
                tokens_helper(v, &it.span);
            }
            v.visit_path(&*node.path);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_visibility<'ast, V>(v: &mut V, node: &'ast Visibility)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                Visibility::Public(_binding_0) => {
                    v.visit_vis_public(_binding_0);
                }
                Visibility::Crate(_binding_0) => {
                    v.visit_vis_crate(_binding_0);
                }
                Visibility::Restricted(_binding_0) => {
                    v.visit_vis_restricted(_binding_0);
                }
                Visibility::Inherited => {}
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_where_clause<'ast, V>(v: &mut V, node: &'ast WhereClause)
        where
            V: Visit<'ast> + ?Sized,
        {
            tokens_helper(v, &node.where_token.span);
            for el in Punctuated::pairs(&node.predicates) {
                let (it, p) = el.into_tuple();
                v.visit_where_predicate(it);
                if let Some(p) = p {
                    tokens_helper(v, &p.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_where_predicate<'ast, V>(v: &mut V, node: &'ast WherePredicate)
        where
            V: Visit<'ast> + ?Sized,
        {
            match node {
                WherePredicate::Type(_binding_0) => {
                    v.visit_predicate_type(_binding_0);
                }
                WherePredicate::Lifetime(_binding_0) => {
                    v.visit_predicate_lifetime(_binding_0);
                }
                WherePredicate::Eq(_binding_0) => {
                    v.visit_predicate_eq(_binding_0);
                }
            }
        }
    }
    #[cfg(feature = "visit-mut")]
    #[rustfmt::skip]
    pub mod visit_mut {
        #![allow(unused_variables)]
        #[cfg(any(feature = "full", feature = "derive"))]
        use crate::gen::helper::visit_mut::*;
        #[cfg(any(feature = "full", feature = "derive"))]
        use crate::punctuated::Punctuated;
        use crate::*;
        use proc_macro2::Span;
        pub trait VisitMut {
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_abi_mut(&mut self, i: &mut Abi) {
                visit_abi_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_angle_bracketed_generic_arguments_mut(
                &mut self,
                i: &mut AngleBracketedGenericArguments,
            ) {
                visit_angle_bracketed_generic_arguments_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_arm_mut(&mut self, i: &mut Arm) {
                visit_arm_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_attr_style_mut(&mut self, i: &mut AttrStyle) {
                visit_attr_style_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_attribute_mut(&mut self, i: &mut Attribute) {
                visit_attribute_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_bare_fn_arg_mut(&mut self, i: &mut BareFnArg) {
                visit_bare_fn_arg_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_bin_op_mut(&mut self, i: &mut BinOp) {
                visit_bin_op_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_binding_mut(&mut self, i: &mut Binding) {
                visit_binding_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_block_mut(&mut self, i: &mut Block) {
                visit_block_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_bound_lifetimes_mut(&mut self, i: &mut BoundLifetimes) {
                visit_bound_lifetimes_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_const_param_mut(&mut self, i: &mut ConstParam) {
                visit_const_param_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_constraint_mut(&mut self, i: &mut Constraint) {
                visit_constraint_mut(self, i);
            }
            #[cfg(feature = "derive")]
            fn visit_data_mut(&mut self, i: &mut Data) {
                visit_data_mut(self, i);
            }
            #[cfg(feature = "derive")]
            fn visit_data_enum_mut(&mut self, i: &mut DataEnum) {
                visit_data_enum_mut(self, i);
            }
            #[cfg(feature = "derive")]
            fn visit_data_struct_mut(&mut self, i: &mut DataStruct) {
                visit_data_struct_mut(self, i);
            }
            #[cfg(feature = "derive")]
            fn visit_data_union_mut(&mut self, i: &mut DataUnion) {
                visit_data_union_mut(self, i);
            }
            #[cfg(feature = "derive")]
            fn visit_derive_input_mut(&mut self, i: &mut DeriveInput) {
                visit_derive_input_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_mut(&mut self, i: &mut Expr) {
                visit_expr_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_array_mut(&mut self, i: &mut ExprArray) {
                visit_expr_array_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_assign_mut(&mut self, i: &mut ExprAssign) {
                visit_expr_assign_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_assign_op_mut(&mut self, i: &mut ExprAssignOp) {
                visit_expr_assign_op_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_async_mut(&mut self, i: &mut ExprAsync) {
                visit_expr_async_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_await_mut(&mut self, i: &mut ExprAwait) {
                visit_expr_await_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_binary_mut(&mut self, i: &mut ExprBinary) {
                visit_expr_binary_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_block_mut(&mut self, i: &mut ExprBlock) {
                visit_expr_block_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_box_mut(&mut self, i: &mut ExprBox) {
                visit_expr_box_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_break_mut(&mut self, i: &mut ExprBreak) {
                visit_expr_break_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_call_mut(&mut self, i: &mut ExprCall) {
                visit_expr_call_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_cast_mut(&mut self, i: &mut ExprCast) {
                visit_expr_cast_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_closure_mut(&mut self, i: &mut ExprClosure) {
                visit_expr_closure_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_continue_mut(&mut self, i: &mut ExprContinue) {
                visit_expr_continue_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_field_mut(&mut self, i: &mut ExprField) {
                visit_expr_field_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_for_loop_mut(&mut self, i: &mut ExprForLoop) {
                visit_expr_for_loop_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_group_mut(&mut self, i: &mut ExprGroup) {
                visit_expr_group_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_if_mut(&mut self, i: &mut ExprIf) {
                visit_expr_if_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_index_mut(&mut self, i: &mut ExprIndex) {
                visit_expr_index_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_let_mut(&mut self, i: &mut ExprLet) {
                visit_expr_let_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_lit_mut(&mut self, i: &mut ExprLit) {
                visit_expr_lit_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_loop_mut(&mut self, i: &mut ExprLoop) {
                visit_expr_loop_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_macro_mut(&mut self, i: &mut ExprMacro) {
                visit_expr_macro_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_match_mut(&mut self, i: &mut ExprMatch) {
                visit_expr_match_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_method_call_mut(&mut self, i: &mut ExprMethodCall) {
                visit_expr_method_call_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_paren_mut(&mut self, i: &mut ExprParen) {
                visit_expr_paren_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_path_mut(&mut self, i: &mut ExprPath) {
                visit_expr_path_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_range_mut(&mut self, i: &mut ExprRange) {
                visit_expr_range_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_reference_mut(&mut self, i: &mut ExprReference) {
                visit_expr_reference_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_repeat_mut(&mut self, i: &mut ExprRepeat) {
                visit_expr_repeat_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_return_mut(&mut self, i: &mut ExprReturn) {
                visit_expr_return_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_struct_mut(&mut self, i: &mut ExprStruct) {
                visit_expr_struct_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_try_mut(&mut self, i: &mut ExprTry) {
                visit_expr_try_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_try_block_mut(&mut self, i: &mut ExprTryBlock) {
                visit_expr_try_block_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_tuple_mut(&mut self, i: &mut ExprTuple) {
                visit_expr_tuple_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_type_mut(&mut self, i: &mut ExprType) {
                visit_expr_type_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_expr_unary_mut(&mut self, i: &mut ExprUnary) {
                visit_expr_unary_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_unsafe_mut(&mut self, i: &mut ExprUnsafe) {
                visit_expr_unsafe_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_while_mut(&mut self, i: &mut ExprWhile) {
                visit_expr_while_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_expr_yield_mut(&mut self, i: &mut ExprYield) {
                visit_expr_yield_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_field_mut(&mut self, i: &mut Field) {
                visit_field_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_field_pat_mut(&mut self, i: &mut FieldPat) {
                visit_field_pat_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_field_value_mut(&mut self, i: &mut FieldValue) {
                visit_field_value_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_fields_mut(&mut self, i: &mut Fields) {
                visit_fields_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_fields_named_mut(&mut self, i: &mut FieldsNamed) {
                visit_fields_named_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_fields_unnamed_mut(&mut self, i: &mut FieldsUnnamed) {
                visit_fields_unnamed_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_file_mut(&mut self, i: &mut File) {
                visit_file_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_fn_arg_mut(&mut self, i: &mut FnArg) {
                visit_fn_arg_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_foreign_item_mut(&mut self, i: &mut ForeignItem) {
                visit_foreign_item_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_foreign_item_fn_mut(&mut self, i: &mut ForeignItemFn) {
                visit_foreign_item_fn_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_foreign_item_macro_mut(&mut self, i: &mut ForeignItemMacro) {
                visit_foreign_item_macro_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_foreign_item_static_mut(&mut self, i: &mut ForeignItemStatic) {
                visit_foreign_item_static_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_foreign_item_type_mut(&mut self, i: &mut ForeignItemType) {
                visit_foreign_item_type_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_generic_argument_mut(&mut self, i: &mut GenericArgument) {
                visit_generic_argument_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_generic_method_argument_mut(
                &mut self,
                i: &mut GenericMethodArgument,
            ) {
                visit_generic_method_argument_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_generic_param_mut(&mut self, i: &mut GenericParam) {
                visit_generic_param_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_generics_mut(&mut self, i: &mut Generics) {
                visit_generics_mut(self, i);
            }
            fn visit_ident_mut(&mut self, i: &mut Ident) {
                visit_ident_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_impl_item_mut(&mut self, i: &mut ImplItem) {
                visit_impl_item_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_impl_item_const_mut(&mut self, i: &mut ImplItemConst) {
                visit_impl_item_const_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_impl_item_macro_mut(&mut self, i: &mut ImplItemMacro) {
                visit_impl_item_macro_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_impl_item_method_mut(&mut self, i: &mut ImplItemMethod) {
                visit_impl_item_method_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_impl_item_type_mut(&mut self, i: &mut ImplItemType) {
                visit_impl_item_type_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_index_mut(&mut self, i: &mut Index) {
                visit_index_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_mut(&mut self, i: &mut Item) {
                visit_item_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_const_mut(&mut self, i: &mut ItemConst) {
                visit_item_const_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_enum_mut(&mut self, i: &mut ItemEnum) {
                visit_item_enum_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_extern_crate_mut(&mut self, i: &mut ItemExternCrate) {
                visit_item_extern_crate_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_fn_mut(&mut self, i: &mut ItemFn) {
                visit_item_fn_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_foreign_mod_mut(&mut self, i: &mut ItemForeignMod) {
                visit_item_foreign_mod_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_impl_mut(&mut self, i: &mut ItemImpl) {
                visit_item_impl_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_macro_mut(&mut self, i: &mut ItemMacro) {
                visit_item_macro_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_macro2_mut(&mut self, i: &mut ItemMacro2) {
                visit_item_macro2_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_mod_mut(&mut self, i: &mut ItemMod) {
                visit_item_mod_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_static_mut(&mut self, i: &mut ItemStatic) {
                visit_item_static_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_struct_mut(&mut self, i: &mut ItemStruct) {
                visit_item_struct_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_trait_mut(&mut self, i: &mut ItemTrait) {
                visit_item_trait_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_trait_alias_mut(&mut self, i: &mut ItemTraitAlias) {
                visit_item_trait_alias_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_type_mut(&mut self, i: &mut ItemType) {
                visit_item_type_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_union_mut(&mut self, i: &mut ItemUnion) {
                visit_item_union_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_item_use_mut(&mut self, i: &mut ItemUse) {
                visit_item_use_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_label_mut(&mut self, i: &mut Label) {
                visit_label_mut(self, i);
            }
            fn visit_lifetime_mut(&mut self, i: &mut Lifetime) {
                visit_lifetime_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_lifetime_def_mut(&mut self, i: &mut LifetimeDef) {
                visit_lifetime_def_mut(self, i);
            }
            fn visit_lit_mut(&mut self, i: &mut Lit) {
                visit_lit_mut(self, i);
            }
            fn visit_lit_bool_mut(&mut self, i: &mut LitBool) {
                visit_lit_bool_mut(self, i);
            }
            fn visit_lit_byte_mut(&mut self, i: &mut LitByte) {
                visit_lit_byte_mut(self, i);
            }
            fn visit_lit_byte_str_mut(&mut self, i: &mut LitByteStr) {
                visit_lit_byte_str_mut(self, i);
            }
            fn visit_lit_char_mut(&mut self, i: &mut LitChar) {
                visit_lit_char_mut(self, i);
            }
            fn visit_lit_float_mut(&mut self, i: &mut LitFloat) {
                visit_lit_float_mut(self, i);
            }
            fn visit_lit_int_mut(&mut self, i: &mut LitInt) {
                visit_lit_int_mut(self, i);
            }
            fn visit_lit_str_mut(&mut self, i: &mut LitStr) {
                visit_lit_str_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_local_mut(&mut self, i: &mut Local) {
                visit_local_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_macro_mut(&mut self, i: &mut Macro) {
                visit_macro_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_macro_delimiter_mut(&mut self, i: &mut MacroDelimiter) {
                visit_macro_delimiter_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_member_mut(&mut self, i: &mut Member) {
                visit_member_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_meta_mut(&mut self, i: &mut Meta) {
                visit_meta_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_meta_list_mut(&mut self, i: &mut MetaList) {
                visit_meta_list_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_meta_name_value_mut(&mut self, i: &mut MetaNameValue) {
                visit_meta_name_value_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_method_turbofish_mut(&mut self, i: &mut MethodTurbofish) {
                visit_method_turbofish_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_nested_meta_mut(&mut self, i: &mut NestedMeta) {
                visit_nested_meta_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_parenthesized_generic_arguments_mut(
                &mut self,
                i: &mut ParenthesizedGenericArguments,
            ) {
                visit_parenthesized_generic_arguments_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_mut(&mut self, i: &mut Pat) {
                visit_pat_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_box_mut(&mut self, i: &mut PatBox) {
                visit_pat_box_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_ident_mut(&mut self, i: &mut PatIdent) {
                visit_pat_ident_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_lit_mut(&mut self, i: &mut PatLit) {
                visit_pat_lit_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_macro_mut(&mut self, i: &mut PatMacro) {
                visit_pat_macro_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_or_mut(&mut self, i: &mut PatOr) {
                visit_pat_or_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_path_mut(&mut self, i: &mut PatPath) {
                visit_pat_path_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_range_mut(&mut self, i: &mut PatRange) {
                visit_pat_range_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_reference_mut(&mut self, i: &mut PatReference) {
                visit_pat_reference_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_rest_mut(&mut self, i: &mut PatRest) {
                visit_pat_rest_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_slice_mut(&mut self, i: &mut PatSlice) {
                visit_pat_slice_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_struct_mut(&mut self, i: &mut PatStruct) {
                visit_pat_struct_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_tuple_mut(&mut self, i: &mut PatTuple) {
                visit_pat_tuple_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_tuple_struct_mut(&mut self, i: &mut PatTupleStruct) {
                visit_pat_tuple_struct_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_type_mut(&mut self, i: &mut PatType) {
                visit_pat_type_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_pat_wild_mut(&mut self, i: &mut PatWild) {
                visit_pat_wild_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_path_mut(&mut self, i: &mut Path) {
                visit_path_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_path_arguments_mut(&mut self, i: &mut PathArguments) {
                visit_path_arguments_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_path_segment_mut(&mut self, i: &mut PathSegment) {
                visit_path_segment_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_predicate_eq_mut(&mut self, i: &mut PredicateEq) {
                visit_predicate_eq_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_predicate_lifetime_mut(&mut self, i: &mut PredicateLifetime) {
                visit_predicate_lifetime_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_predicate_type_mut(&mut self, i: &mut PredicateType) {
                visit_predicate_type_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_qself_mut(&mut self, i: &mut QSelf) {
                visit_qself_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_range_limits_mut(&mut self, i: &mut RangeLimits) {
                visit_range_limits_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_receiver_mut(&mut self, i: &mut Receiver) {
                visit_receiver_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_return_type_mut(&mut self, i: &mut ReturnType) {
                visit_return_type_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_signature_mut(&mut self, i: &mut Signature) {
                visit_signature_mut(self, i);
            }
            fn visit_span_mut(&mut self, i: &mut Span) {
                visit_span_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_stmt_mut(&mut self, i: &mut Stmt) {
                visit_stmt_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_trait_bound_mut(&mut self, i: &mut TraitBound) {
                visit_trait_bound_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_trait_bound_modifier_mut(&mut self, i: &mut TraitBoundModifier) {
                visit_trait_bound_modifier_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_trait_item_mut(&mut self, i: &mut TraitItem) {
                visit_trait_item_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_trait_item_const_mut(&mut self, i: &mut TraitItemConst) {
                visit_trait_item_const_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_trait_item_macro_mut(&mut self, i: &mut TraitItemMacro) {
                visit_trait_item_macro_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_trait_item_method_mut(&mut self, i: &mut TraitItemMethod) {
                visit_trait_item_method_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_trait_item_type_mut(&mut self, i: &mut TraitItemType) {
                visit_trait_item_type_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_mut(&mut self, i: &mut Type) {
                visit_type_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_array_mut(&mut self, i: &mut TypeArray) {
                visit_type_array_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_bare_fn_mut(&mut self, i: &mut TypeBareFn) {
                visit_type_bare_fn_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_group_mut(&mut self, i: &mut TypeGroup) {
                visit_type_group_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_impl_trait_mut(&mut self, i: &mut TypeImplTrait) {
                visit_type_impl_trait_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_infer_mut(&mut self, i: &mut TypeInfer) {
                visit_type_infer_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_macro_mut(&mut self, i: &mut TypeMacro) {
                visit_type_macro_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_never_mut(&mut self, i: &mut TypeNever) {
                visit_type_never_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_param_mut(&mut self, i: &mut TypeParam) {
                visit_type_param_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_param_bound_mut(&mut self, i: &mut TypeParamBound) {
                visit_type_param_bound_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_paren_mut(&mut self, i: &mut TypeParen) {
                visit_type_paren_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_path_mut(&mut self, i: &mut TypePath) {
                visit_type_path_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_ptr_mut(&mut self, i: &mut TypePtr) {
                visit_type_ptr_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_reference_mut(&mut self, i: &mut TypeReference) {
                visit_type_reference_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_slice_mut(&mut self, i: &mut TypeSlice) {
                visit_type_slice_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_trait_object_mut(&mut self, i: &mut TypeTraitObject) {
                visit_type_trait_object_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_type_tuple_mut(&mut self, i: &mut TypeTuple) {
                visit_type_tuple_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_un_op_mut(&mut self, i: &mut UnOp) {
                visit_un_op_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_use_glob_mut(&mut self, i: &mut UseGlob) {
                visit_use_glob_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_use_group_mut(&mut self, i: &mut UseGroup) {
                visit_use_group_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_use_name_mut(&mut self, i: &mut UseName) {
                visit_use_name_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_use_path_mut(&mut self, i: &mut UsePath) {
                visit_use_path_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_use_rename_mut(&mut self, i: &mut UseRename) {
                visit_use_rename_mut(self, i);
            }
            #[cfg(feature = "full")]
            fn visit_use_tree_mut(&mut self, i: &mut UseTree) {
                visit_use_tree_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_variadic_mut(&mut self, i: &mut Variadic) {
                visit_variadic_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_variant_mut(&mut self, i: &mut Variant) {
                visit_variant_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_vis_crate_mut(&mut self, i: &mut VisCrate) {
                visit_vis_crate_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_vis_public_mut(&mut self, i: &mut VisPublic) {
                visit_vis_public_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_vis_restricted_mut(&mut self, i: &mut VisRestricted) {
                visit_vis_restricted_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_visibility_mut(&mut self, i: &mut Visibility) {
                visit_visibility_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_where_clause_mut(&mut self, i: &mut WhereClause) {
                visit_where_clause_mut(self, i);
            }
            #[cfg(any(feature = "derive", feature = "full"))]
            fn visit_where_predicate_mut(&mut self, i: &mut WherePredicate) {
                visit_where_predicate_mut(self, i);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_abi_mut<V>(v: &mut V, node: &mut Abi)
        where
            V: VisitMut + ?Sized,
        {
            tokens_helper(v, &mut node.extern_token.span);
            if let Some(it) = &mut node.name {
                v.visit_lit_str_mut(it);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_angle_bracketed_generic_arguments_mut<V>(
            v: &mut V,
            node: &mut AngleBracketedGenericArguments,
        )
        where
            V: VisitMut + ?Sized,
        {
            if let Some(it) = &mut node.colon2_token {
                tokens_helper(v, &mut it.spans);
            }
            tokens_helper(v, &mut node.lt_token.spans);
            for el in Punctuated::pairs_mut(&mut node.args) {
                let (it, p) = el.into_tuple();
                v.visit_generic_argument_mut(it);
                if let Some(p) = p {
                    tokens_helper(v, &mut p.spans);
                }
            }
            tokens_helper(v, &mut node.gt_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_arm_mut<V>(v: &mut V, node: &mut Arm)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_pat_mut(&mut node.pat);
            if let Some(it) = &mut node.guard {
                tokens_helper(v, &mut (it).0.span);
                v.visit_expr_mut(&mut *(it).1);
            }
            tokens_helper(v, &mut node.fat_arrow_token.spans);
            v.visit_expr_mut(&mut *node.body);
            if let Some(it) = &mut node.comma {
                tokens_helper(v, &mut it.spans);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_attr_style_mut<V>(v: &mut V, node: &mut AttrStyle)
        where
            V: VisitMut + ?Sized,
        {
            match node {
                AttrStyle::Outer => {}
                AttrStyle::Inner(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_attribute_mut<V>(v: &mut V, node: &mut Attribute)
        where
            V: VisitMut + ?Sized,
        {
            tokens_helper(v, &mut node.pound_token.spans);
            v.visit_attr_style_mut(&mut node.style);
            tokens_helper(v, &mut node.bracket_token.span);
            v.visit_path_mut(&mut node.path);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_bare_fn_arg_mut<V>(v: &mut V, node: &mut BareFnArg)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            if let Some(it) = &mut node.name {
                v.visit_ident_mut(&mut (it).0);
                tokens_helper(v, &mut (it).1.spans);
            }
            v.visit_type_mut(&mut node.ty);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_bin_op_mut<V>(v: &mut V, node: &mut BinOp)
        where
            V: VisitMut + ?Sized,
        {
            match node {
                BinOp::Add(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::Sub(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::Mul(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::Div(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::Rem(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::And(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::Or(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::BitXor(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::BitAnd(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::BitOr(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::Shl(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::Shr(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::Eq(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::Lt(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::Le(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::Ne(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::Ge(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::Gt(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::AddEq(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::SubEq(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::MulEq(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::DivEq(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::RemEq(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::BitXorEq(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::BitAndEq(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::BitOrEq(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::ShlEq(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
                BinOp::ShrEq(_binding_0) => {
                    tokens_helper(v, &mut _binding_0.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_binding_mut<V>(v: &mut V, node: &mut Binding)
        where
            V: VisitMut + ?Sized,
        {
            v.visit_ident_mut(&mut node.ident);
            tokens_helper(v, &mut node.eq_token.spans);
            v.visit_type_mut(&mut node.ty);
        }
        #[cfg(feature = "full")]
        pub fn visit_block_mut<V>(v: &mut V, node: &mut Block)
        where
            V: VisitMut + ?Sized,
        {
            tokens_helper(v, &mut node.brace_token.span);
            for it in &mut node.stmts {
                v.visit_stmt_mut(it);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_bound_lifetimes_mut<V>(v: &mut V, node: &mut BoundLifetimes)
        where
            V: VisitMut + ?Sized,
        {
            tokens_helper(v, &mut node.for_token.span);
            tokens_helper(v, &mut node.lt_token.spans);
            for el in Punctuated::pairs_mut(&mut node.lifetimes) {
                let (it, p) = el.into_tuple();
                v.visit_lifetime_def_mut(it);
                if let Some(p) = p {
                    tokens_helper(v, &mut p.spans);
                }
            }
            tokens_helper(v, &mut node.gt_token.spans);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_const_param_mut<V>(v: &mut V, node: &mut ConstParam)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.const_token.span);
            v.visit_ident_mut(&mut node.ident);
            tokens_helper(v, &mut node.colon_token.spans);
            v.visit_type_mut(&mut node.ty);
            if let Some(it) = &mut node.eq_token {
                tokens_helper(v, &mut it.spans);
            }
            if let Some(it) = &mut node.default {
                v.visit_expr_mut(it);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_constraint_mut<V>(v: &mut V, node: &mut Constraint)
        where
            V: VisitMut + ?Sized,
        {
            v.visit_ident_mut(&mut node.ident);
            tokens_helper(v, &mut node.colon_token.spans);
            for el in Punctuated::pairs_mut(&mut node.bounds) {
                let (it, p) = el.into_tuple();
                v.visit_type_param_bound_mut(it);
                if let Some(p) = p {
                    tokens_helper(v, &mut p.spans);
                }
            }
        }
        #[cfg(feature = "derive")]
        pub fn visit_data_mut<V>(v: &mut V, node: &mut Data)
        where
            V: VisitMut + ?Sized,
        {
            match node {
                Data::Struct(_binding_0) => {
                    v.visit_data_struct_mut(_binding_0);
                }
                Data::Enum(_binding_0) => {
                    v.visit_data_enum_mut(_binding_0);
                }
                Data::Union(_binding_0) => {
                    v.visit_data_union_mut(_binding_0);
                }
            }
        }
        #[cfg(feature = "derive")]
        pub fn visit_data_enum_mut<V>(v: &mut V, node: &mut DataEnum)
        where
            V: VisitMut + ?Sized,
        {
            tokens_helper(v, &mut node.enum_token.span);
            tokens_helper(v, &mut node.brace_token.span);
            for el in Punctuated::pairs_mut(&mut node.variants) {
                let (it, p) = el.into_tuple();
                v.visit_variant_mut(it);
                if let Some(p) = p {
                    tokens_helper(v, &mut p.spans);
                }
            }
        }
        #[cfg(feature = "derive")]
        pub fn visit_data_struct_mut<V>(v: &mut V, node: &mut DataStruct)
        where
            V: VisitMut + ?Sized,
        {
            tokens_helper(v, &mut node.struct_token.span);
            v.visit_fields_mut(&mut node.fields);
            if let Some(it) = &mut node.semi_token {
                tokens_helper(v, &mut it.spans);
            }
        }
        #[cfg(feature = "derive")]
        pub fn visit_data_union_mut<V>(v: &mut V, node: &mut DataUnion)
        where
            V: VisitMut + ?Sized,
        {
            tokens_helper(v, &mut node.union_token.span);
            v.visit_fields_named_mut(&mut node.fields);
        }
        #[cfg(feature = "derive")]
        pub fn visit_derive_input_mut<V>(v: &mut V, node: &mut DeriveInput)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_visibility_mut(&mut node.vis);
            v.visit_ident_mut(&mut node.ident);
            v.visit_generics_mut(&mut node.generics);
            v.visit_data_mut(&mut node.data);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_mut<V>(v: &mut V, node: &mut Expr)
        where
            V: VisitMut + ?Sized,
        {
            match node {
                Expr::Array(_binding_0) => {
                    v.visit_expr_array_mut(_binding_0);
                }
                Expr::Assign(_binding_0) => {
                    v.visit_expr_assign_mut(_binding_0);
                }
                Expr::AssignOp(_binding_0) => {
                    v.visit_expr_assign_op_mut(_binding_0);
                }
                Expr::Async(_binding_0) => {
                    v.visit_expr_async_mut(_binding_0);
                }
                Expr::Await(_binding_0) => {
                    v.visit_expr_await_mut(_binding_0);
                }
                Expr::Binary(_binding_0) => {
                    v.visit_expr_binary_mut(_binding_0);
                }
                Expr::Block(_binding_0) => {
                    v.visit_expr_block_mut(_binding_0);
                }
                Expr::Box(_binding_0) => {
                    v.visit_expr_box_mut(_binding_0);
                }
                Expr::Break(_binding_0) => {
                    v.visit_expr_break_mut(_binding_0);
                }
                Expr::Call(_binding_0) => {
                    v.visit_expr_call_mut(_binding_0);
                }
                Expr::Cast(_binding_0) => {
                    v.visit_expr_cast_mut(_binding_0);
                }
                Expr::Closure(_binding_0) => {
                    v.visit_expr_closure_mut(_binding_0);
                }
                Expr::Continue(_binding_0) => {
                    v.visit_expr_continue_mut(_binding_0);
                }
                Expr::Field(_binding_0) => {
                    v.visit_expr_field_mut(_binding_0);
                }
                Expr::ForLoop(_binding_0) => {
                    v.visit_expr_for_loop_mut(_binding_0);
                }
                Expr::Group(_binding_0) => {
                    v.visit_expr_group_mut(_binding_0);
                }
                Expr::If(_binding_0) => {
                    v.visit_expr_if_mut(_binding_0);
                }
                Expr::Index(_binding_0) => {
                    v.visit_expr_index_mut(_binding_0);
                }
                Expr::Let(_binding_0) => {
                    v.visit_expr_let_mut(_binding_0);
                }
                Expr::Lit(_binding_0) => {
                    v.visit_expr_lit_mut(_binding_0);
                }
                Expr::Loop(_binding_0) => {
                    v.visit_expr_loop_mut(_binding_0);
                }
                Expr::Macro(_binding_0) => {
                    v.visit_expr_macro_mut(_binding_0);
                }
                Expr::Match(_binding_0) => {
                    v.visit_expr_match_mut(_binding_0);
                }
                Expr::MethodCall(_binding_0) => {
                    v.visit_expr_method_call_mut(_binding_0);
                }
                Expr::Paren(_binding_0) => {
                    v.visit_expr_paren_mut(_binding_0);
                }
                Expr::Path(_binding_0) => {
                    v.visit_expr_path_mut(_binding_0);
                }
                Expr::Range(_binding_0) => {
                    v.visit_expr_range_mut(_binding_0);
                }
                Expr::Reference(_binding_0) => {
                    v.visit_expr_reference_mut(_binding_0);
                }
                Expr::Repeat(_binding_0) => {
                    v.visit_expr_repeat_mut(_binding_0);
                }
                Expr::Return(_binding_0) => {
                    v.visit_expr_return_mut(_binding_0);
                }
                Expr::Struct(_binding_0) => {
                    v.visit_expr_struct_mut(_binding_0);
                }
                Expr::Try(_binding_0) => {
                    v.visit_expr_try_mut(_binding_0);
                }
                Expr::TryBlock(_binding_0) => {
                    v.visit_expr_try_block_mut(_binding_0);
                }
                Expr::Tuple(_binding_0) => {
                    v.visit_expr_tuple_mut(_binding_0);
                }
                Expr::Type(_binding_0) => {
                    v.visit_expr_type_mut(_binding_0);
                }
                Expr::Unary(_binding_0) => {
                    v.visit_expr_unary_mut(_binding_0);
                }
                Expr::Unsafe(_binding_0) => {
                    v.visit_expr_unsafe_mut(_binding_0);
                }
                Expr::Verbatim(_binding_0) => {}
                Expr::While(_binding_0) => {
                    v.visit_expr_while_mut(_binding_0);
                }
                Expr::Yield(_binding_0) => {
                    v.visit_expr_yield_mut(_binding_0);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_array_mut<V>(v: &mut V, node: &mut ExprArray)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.bracket_token.span);
            for el in Punctuated::pairs_mut(&mut node.elems) {
                let (it, p) = el.into_tuple();
                v.visit_expr_mut(it);
                if let Some(p) = p {
                    tokens_helper(v, &mut p.spans);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_assign_mut<V>(v: &mut V, node: &mut ExprAssign)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_expr_mut(&mut *node.left);
            tokens_helper(v, &mut node.eq_token.spans);
            v.visit_expr_mut(&mut *node.right);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_assign_op_mut<V>(v: &mut V, node: &mut ExprAssignOp)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_expr_mut(&mut *node.left);
            v.visit_bin_op_mut(&mut node.op);
            v.visit_expr_mut(&mut *node.right);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_async_mut<V>(v: &mut V, node: &mut ExprAsync)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.async_token.span);
            if let Some(it) = &mut node.capture {
                tokens_helper(v, &mut it.span);
            }
            v.visit_block_mut(&mut node.block);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_await_mut<V>(v: &mut V, node: &mut ExprAwait)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_expr_mut(&mut *node.base);
            tokens_helper(v, &mut node.dot_token.spans);
            tokens_helper(v, &mut node.await_token.span);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_binary_mut<V>(v: &mut V, node: &mut ExprBinary)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_expr_mut(&mut *node.left);
            v.visit_bin_op_mut(&mut node.op);
            v.visit_expr_mut(&mut *node.right);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_block_mut<V>(v: &mut V, node: &mut ExprBlock)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            if let Some(it) = &mut node.label {
                v.visit_label_mut(it);
            }
            v.visit_block_mut(&mut node.block);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_box_mut<V>(v: &mut V, node: &mut ExprBox)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.box_token.span);
            v.visit_expr_mut(&mut *node.expr);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_break_mut<V>(v: &mut V, node: &mut ExprBreak)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.break_token.span);
            if let Some(it) = &mut node.label {
                v.visit_lifetime_mut(it);
            }
            if let Some(it) = &mut node.expr {
                v.visit_expr_mut(&mut **it);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_call_mut<V>(v: &mut V, node: &mut ExprCall)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_expr_mut(&mut *node.func);
            tokens_helper(v, &mut node.paren_token.span);
            for el in Punctuated::pairs_mut(&mut node.args) {
                let (it, p) = el.into_tuple();
                v.visit_expr_mut(it);
                if let Some(p) = p {
                    tokens_helper(v, &mut p.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_cast_mut<V>(v: &mut V, node: &mut ExprCast)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_expr_mut(&mut *node.expr);
            tokens_helper(v, &mut node.as_token.span);
            v.visit_type_mut(&mut *node.ty);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_closure_mut<V>(v: &mut V, node: &mut ExprClosure)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            if let Some(it) = &mut node.movability {
                tokens_helper(v, &mut it.span);
            }
            if let Some(it) = &mut node.asyncness {
                tokens_helper(v, &mut it.span);
            }
            if let Some(it) = &mut node.capture {
                tokens_helper(v, &mut it.span);
            }
            tokens_helper(v, &mut node.or1_token.spans);
            for el in Punctuated::pairs_mut(&mut node.inputs) {
                let (it, p) = el.into_tuple();
                v.visit_pat_mut(it);
                if let Some(p) = p {
                    tokens_helper(v, &mut p.spans);
                }
            }
            tokens_helper(v, &mut node.or2_token.spans);
            v.visit_return_type_mut(&mut node.output);
            v.visit_expr_mut(&mut *node.body);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_continue_mut<V>(v: &mut V, node: &mut ExprContinue)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.continue_token.span);
            if let Some(it) = &mut node.label {
                v.visit_lifetime_mut(it);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_field_mut<V>(v: &mut V, node: &mut ExprField)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_expr_mut(&mut *node.base);
            tokens_helper(v, &mut node.dot_token.spans);
            v.visit_member_mut(&mut node.member);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_for_loop_mut<V>(v: &mut V, node: &mut ExprForLoop)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            if let Some(it) = &mut node.label {
                v.visit_label_mut(it);
            }
            tokens_helper(v, &mut node.for_token.span);
            v.visit_pat_mut(&mut node.pat);
            tokens_helper(v, &mut node.in_token.span);
            v.visit_expr_mut(&mut *node.expr);
            v.visit_block_mut(&mut node.body);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_group_mut<V>(v: &mut V, node: &mut ExprGroup)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.group_token.span);
            v.visit_expr_mut(&mut *node.expr);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_if_mut<V>(v: &mut V, node: &mut ExprIf)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.if_token.span);
            v.visit_expr_mut(&mut *node.cond);
            v.visit_block_mut(&mut node.then_branch);
            if let Some(it) = &mut node.else_branch {
                tokens_helper(v, &mut (it).0.span);
                v.visit_expr_mut(&mut *(it).1);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_index_mut<V>(v: &mut V, node: &mut ExprIndex)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_expr_mut(&mut *node.expr);
            tokens_helper(v, &mut node.bracket_token.span);
            v.visit_expr_mut(&mut *node.index);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_let_mut<V>(v: &mut V, node: &mut ExprLet)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.let_token.span);
            v.visit_pat_mut(&mut node.pat);
            tokens_helper(v, &mut node.eq_token.spans);
            v.visit_expr_mut(&mut *node.expr);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_lit_mut<V>(v: &mut V, node: &mut ExprLit)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_lit_mut(&mut node.lit);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_loop_mut<V>(v: &mut V, node: &mut ExprLoop)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            if let Some(it) = &mut node.label {
                v.visit_label_mut(it);
            }
            tokens_helper(v, &mut node.loop_token.span);
            v.visit_block_mut(&mut node.body);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_macro_mut<V>(v: &mut V, node: &mut ExprMacro)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_macro_mut(&mut node.mac);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_match_mut<V>(v: &mut V, node: &mut ExprMatch)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.match_token.span);
            v.visit_expr_mut(&mut *node.expr);
            tokens_helper(v, &mut node.brace_token.span);
            for it in &mut node.arms {
                v.visit_arm_mut(it);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_method_call_mut<V>(v: &mut V, node: &mut ExprMethodCall)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_expr_mut(&mut *node.receiver);
            tokens_helper(v, &mut node.dot_token.spans);
            v.visit_ident_mut(&mut node.method);
            if let Some(it) = &mut node.turbofish {
                v.visit_method_turbofish_mut(it);
            }
            tokens_helper(v, &mut node.paren_token.span);
            for el in Punctuated::pairs_mut(&mut node.args) {
                let (it, p) = el.into_tuple();
                v.visit_expr_mut(it);
                if let Some(p) = p {
                    tokens_helper(v, &mut p.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_paren_mut<V>(v: &mut V, node: &mut ExprParen)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.paren_token.span);
            v.visit_expr_mut(&mut *node.expr);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_path_mut<V>(v: &mut V, node: &mut ExprPath)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            if let Some(it) = &mut node.qself {
                v.visit_qself_mut(it);
            }
            v.visit_path_mut(&mut node.path);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_range_mut<V>(v: &mut V, node: &mut ExprRange)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            if let Some(it) = &mut node.from {
                v.visit_expr_mut(&mut **it);
            }
            v.visit_range_limits_mut(&mut node.limits);
            if let Some(it) = &mut node.to {
                v.visit_expr_mut(&mut **it);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_reference_mut<V>(v: &mut V, node: &mut ExprReference)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.and_token.spans);
            if let Some(it) = &mut node.mutability {
                tokens_helper(v, &mut it.span);
            }
            v.visit_expr_mut(&mut *node.expr);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_repeat_mut<V>(v: &mut V, node: &mut ExprRepeat)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.bracket_token.span);
            v.visit_expr_mut(&mut *node.expr);
            tokens_helper(v, &mut node.semi_token.spans);
            v.visit_expr_mut(&mut *node.len);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_return_mut<V>(v: &mut V, node: &mut ExprReturn)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.return_token.span);
            if let Some(it) = &mut node.expr {
                v.visit_expr_mut(&mut **it);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_struct_mut<V>(v: &mut V, node: &mut ExprStruct)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_path_mut(&mut node.path);
            tokens_helper(v, &mut node.brace_token.span);
            for el in Punctuated::pairs_mut(&mut node.fields) {
                let (it, p) = el.into_tuple();
                v.visit_field_value_mut(it);
                if let Some(p) = p {
                    tokens_helper(v, &mut p.spans);
                }
            }
            if let Some(it) = &mut node.dot2_token {
                tokens_helper(v, &mut it.spans);
            }
            if let Some(it) = &mut node.rest {
                v.visit_expr_mut(&mut **it);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_try_mut<V>(v: &mut V, node: &mut ExprTry)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_expr_mut(&mut *node.expr);
            tokens_helper(v, &mut node.question_token.spans);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_try_block_mut<V>(v: &mut V, node: &mut ExprTryBlock)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.try_token.span);
            v.visit_block_mut(&mut node.block);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_tuple_mut<V>(v: &mut V, node: &mut ExprTuple)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.paren_token.span);
            for el in Punctuated::pairs_mut(&mut node.elems) {
                let (it, p) = el.into_tuple();
                v.visit_expr_mut(it);
                if let Some(p) = p {
                    tokens_helper(v, &mut p.spans);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_type_mut<V>(v: &mut V, node: &mut ExprType)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_expr_mut(&mut *node.expr);
            tokens_helper(v, &mut node.colon_token.spans);
            v.visit_type_mut(&mut *node.ty);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_expr_unary_mut<V>(v: &mut V, node: &mut ExprUnary)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_un_op_mut(&mut node.op);
            v.visit_expr_mut(&mut *node.expr);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_unsafe_mut<V>(v: &mut V, node: &mut ExprUnsafe)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.unsafe_token.span);
            v.visit_block_mut(&mut node.block);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_while_mut<V>(v: &mut V, node: &mut ExprWhile)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            if let Some(it) = &mut node.label {
                v.visit_label_mut(it);
            }
            tokens_helper(v, &mut node.while_token.span);
            v.visit_expr_mut(&mut *node.cond);
            v.visit_block_mut(&mut node.body);
        }
        #[cfg(feature = "full")]
        pub fn visit_expr_yield_mut<V>(v: &mut V, node: &mut ExprYield)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            tokens_helper(v, &mut node.yield_token.span);
            if let Some(it) = &mut node.expr {
                v.visit_expr_mut(&mut **it);
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_field_mut<V>(v: &mut V, node: &mut Field)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_visibility_mut(&mut node.vis);
            if let Some(it) = &mut node.ident {
                v.visit_ident_mut(it);
            }
            if let Some(it) = &mut node.colon_token {
                tokens_helper(v, &mut it.spans);
            }
            v.visit_type_mut(&mut node.ty);
        }
        #[cfg(feature = "full")]
        pub fn visit_field_pat_mut<V>(v: &mut V, node: &mut FieldPat)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_member_mut(&mut node.member);
            if let Some(it) = &mut node.colon_token {
                tokens_helper(v, &mut it.spans);
            }
            v.visit_pat_mut(&mut *node.pat);
        }
        #[cfg(feature = "full")]
        pub fn visit_field_value_mut<V>(v: &mut V, node: &mut FieldValue)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            v.visit_member_mut(&mut node.member);
            if let Some(it) = &mut node.colon_token {
                tokens_helper(v, &mut it.spans);
            }
            v.visit_expr_mut(&mut node.expr);
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_fields_mut<V>(v: &mut V, node: &mut Fields)
        where
            V: VisitMut + ?Sized,
        {
            match node {
                Fields::Named(_binding_0) => {
                    v.visit_fields_named_mut(_binding_0);
                }
                Fields::Unnamed(_binding_0) => {
                    v.visit_fields_unnamed_mut(_binding_0);
                }
                Fields::Unit => {}
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_fields_named_mut<V>(v: &mut V, node: &mut FieldsNamed)
        where
            V: VisitMut + ?Sized,
        {
            tokens_helper(v, &mut node.brace_token.span);
            for el in Punctuated::pairs_mut(&mut node.named) {
                let (it, p) = el.into_tuple();
                v.visit_field_mut(it);
                if let Some(p) = p {
                    tokens_helper(v, &mut p.spans);
                }
            }
        }
        #[cfg(any(feature = "derive", feature = "full"))]
        pub fn visit_fields_unnamed_mut<V>(v: &mut V, node: &mut FieldsUnnamed)
        where
            V: VisitMut + ?Sized,
        {
            tokens_helper(v, &mut node.paren_token.span);
            for el in Punctuated::pairs_mut(&mut node.unnamed) {
                let (it, p) = el.into_tuple();
                v.visit_field_mut(it);
                if let Some(p) = p {
                    tokens_helper(v, &mut p.spans);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_file_mut<V>(v: &mut V, node: &mut File)
        where
            V: VisitMut + ?Sized,
        {
            for it in &mut node.attrs {
                v.visit_attribute_mut(it);
            }
            for it in &mut node.items {
                v.visit_item_mut(it);
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_fn_arg_mut<V>(v: &mut V, node: &mut FnArg)
        where
            V: VisitMut + ?Sized,
        {
            match node {
                FnArg::Receiver(_binding_0) => {
                    v.visit_receiver_mut(_binding_0);
                }
                FnArg::Typed(_binding_0) => {
                    v.visit_pat_type_mut(_binding_0);
                }
            }
        }
        #[cfg(feature = "full")]
        pub fn visit_foreign_item_mut<V>(v: &mut V, node: &mut ForeignItem)
        where
            V: VisitMut + ?Sized,
        {
            match node {
                ForeignItem::Fn(_binding_0) => {
                    v.visit_foreign_item_fn_mut(_bindin