ITK Release 3.20
================

This release covers the period April 15 2010 through July 12 2010

New Classes in this Release
---------------------------


    Code/Common/itkScaleVersor3DTransform

    Code/Review/itkGenericUtilities
    Code/Review/itkMRCHeaderObject
    Code/Review/itkMRCImageIO
    Code/Review/itkMRCImageIOFactory
    Code/Review/itkStreamingImageIOBase
    Code/Review/itkVTKImageIO2
    Code/Review/itkVTKImageIO2Factory
    Code/Review/Statistics/itkHistogramToEntropyImageFilter
    Code/Review/Statistics/itkHistogramToImageFilter
    Code/Review/Statistics/itkHistogramToIntensityImageFilter
    Code/Review/Statistics/itkHistogramToLogProbabilityImageFilter
    Code/Review/Statistics/itkHistogramToProbabilityImageFilter

New Tests in this Release
-------------------------

    Testing/Code/Common/itkImageToImageFilterTest
    Testing/Code/Common/itkNonUniformBSplineTest
    Testing/Code/Common/itkScaleVersor3DTransformTest
    Testing/Code/Common/itkTransformFactoryBaseTest

    Testing/Code/BasicFilters/itkHessianRecursiveGaussianFilterScaleSpaceTest

    Testing/Code/IO/itkReadWriteImageWithDictionaryTest
    Testing/Code/IO/itkSymmetricSecondRankTensorImageWriteReadTest

    Testing/Code/Algorithms/itkBinaryMedialNodeMetricTest
    Testing/Code/Algorithms/itkVoronoiSegmentationRGBImageFilterTest

    Testing/Code/SpatialObject/itkContourSpatialObjectTest
    Testing/Code/SpatialObject/itkMetaArrowConverterTest

    Testing/Code/Review/itkMRCImageIOTest
    Testing/Code/Review/itkVTKImageIO2Test
    Testing/Code/Review/Statistics/itkHistogramToEntropyImageFilterTest1
    Testing/Code/Review/Statistics/itkHistogramToEntropyImageFilterTest2
    Testing/Code/Review/Statistics/itkHistogramToIntensityImageFilterTest1
    Testing/Code/Review/Statistics/itkHistogramToIntensityImageFilterTest2
    Testing/Code/Review/Statistics/itkHistogramToLogProbabilityImageFilterTest1
    Testing/Code/Review/Statistics/itkHistogramToLogProbabilityImageFilterTest2
    Testing/Code/Review/Statistics/itkHistogramToProbabilityImageFilterTest1
    Testing/Code/Review/Statistics/itkHistogramToProbabilityImageFilterTest2
    Testing/Code/Review/Statistics/itkWeightedCovarianceSampleFilterTest2

New Examples in this Release
----------------------------

New Utilities in this Release
-----------------------------

    Utilities/MetaIO/Copyright.txt

This release covers the period April 15 2010 through July 12 2010

Changes in this Release
-----------------------


    CMakeLists.txt
        ENH: Updating the minor version number in preparation for releasing ITK 3.20.
        ENH: Updating ITK_VERSION_MINOR to "18" in preparation for the release of ITK 3.18.

    CMake/CTestCustom.ctest.in

    CMake/InsightValgrind.supp
        ENH: suppression added for the dynamic analysis suppression file

    Code/Algorithms/itkBinaryMedialNodeMetric
        ENH: Added a new test for itkBinaryMedialNodeMetric.  In the process a bug in the implementation was fixed pertaining to the sorting of eigenvalues in BinaryMedialNodeMetric::OrderValues().

    Code/Algorithms/itkBinaryMedialNodeMetr
        BUG: Attempting to debug the few sporadic failures.  Made sure all arrays were initialized and that the success check in the test has a small tolerance for precision errors
        ENH: Added a new test for itkBinaryMedialNodeMetric.  In the process a bug in the implementation was fixed pertaining to the sorting of eigenvalues in BinaryMedialNodeMetric::OrderValues().

    Code/Algorithms/itkFFTComplexConjugateToRealImageFilter
        STYLE: add something in the doc to make doxygen generate something in wrapitk

    Code/Algorithms/itkFastMarchingImageFilter
        BUG: Progress never reached 100 percent. Set progress to 1.0 when the stopping condition is reached.

    Code/Algorithms/itkVoronoiDiagram2DGenerator

    Code/Algorithms/itkVoronoiSegmentationRGBImageFilter
        BUG: floating point divide by zero in atan(). Use atan2() instead. Also check for atan2(0,0)

    Code/BasicFilters/itkCastImageFilter

    Code/BasicFilters/itkDiscreteGaussianImageFilter
        BUG: 10785 Improved performance of the filter by reordering the dirctional convolutions and added a ivar to determin the number of streams

    Code/BasicFilters/itkDiscreteGaussianImageFilter
        BUG: 10785 Improved performance of the filter by reordering the dirctional convolutions and added a ivar to determin the number of streams

    Code/BasicFilters/itkHessianRecursiveGaussianImageFilter
        BUG: fix to bug 0010599 and introduction of a new test itkHessianRecursiveGaussianImageFilterScaleSpaceTest testing the behavior of itkHessianRecursiveGaussianImageFilter in scale-space for dimensions 3 and greater

    Code/BasicFilters/itkSmoothingRecursiveGaussianImageFilter
        ENH: Allow non-isotropic sigmas to be applied across each axis.

    Code/BasicFilters/itkSmoothingRecursiveGaussianImageFilter
        ENH: Allow non-isotropic sigmas to be applied across each axis.

    Code/BasicFilters/itkTriangleMeshToBinaryImageFilter
        BUG: direction cosines were not accounted for - if different from identity matrix it would cause crash

    Code/BasicFilters/itkTriangleMeshToBinaryImageFilter
        ENH: printing newly added variable m_Direction in printself method
        BUG: direction cosines were not accounted for - if different from identity matrix it would cause crash

    Code/BasicFilters/itkTriangleMeshToSimplexMeshFilter
        BUG: wrong index reported in exception (occurs rarely)

    Code/Common/itkBloxCoreAtomPixel
        BUG: Updated itkBinaryMedialNodeMetricTest to only run when ITK_USE_CENTERED_COORDINATES_CONSISTENTLY is enabled.  The algorithm does not work properly when this option is disabled

    Code/Common/itkBloxCoreAtomPixel
        BUG: Updated itkBinaryMedialNodeMetricTest to only run when ITK_USE_CENTERED_COORDINATES_CONSISTENTLY is enabled.  The algorithm does not work properly when this option is disabled

    Code/Common/itkImageDuplicator
        DOC: fix doxygen comments

    Code/Common/itkMacro

    Code/Common/itkMe

    Code/Common/itkMetaDataObject
        COMP: Trying to make specialized MetaDataObject printing work + unused parameter warning fix

    Code/Common/itkNonUniformBSpline

    Code/Common/itkNonUniformBSpline
        COMP: Fixed Borland warning about unused variable.
        COMP: Temporarily commenting out vnl_matrix_inverse lines that fail to compile in many platforms.

    Code/Common/itkScaleVersor3DTransform

    Code/Common/itkScaleVersor3DTransform

    Code/Common/itk_hashtable

    Code/IO/itkAnalyzeImageIO
        BUG: AnalyzeImageIO was not using the right field to store the acquitition time. Added a test to exercise the storage and retrieval of metadata in the image file format.

    Code/IO/itkGDCMImageIO

    Code/IO/itkImageIOBase

    Code/IO/itkImageIOFactory
        BUG: BioRad files can appear to be DICOM files without a preamble. Move BioRad factory before GDCM factory.

    Code/IO/itkMetaImageIO
        COMP: Trying to fix borland compile errors

    Code/IO/itkNiftiImageIO
        BUG:10899:  Addressed memory leak when a manually instantiated Nifti filter was used multiple times.

    Code/Numerics/itkLBFGSBOptimizer

    Code/Numerics/itkLBFGSBOptimizer

    Code/Numerics/Statistics/itkExpectationMaximizationMixtureModelEstimator

    Code/Review/CMakeLists.txt
        ENH: adding Object factory for Review ImageIO classes

    Code/Review/itkAutoCropLabelMapFilter
        ENH: GetRegion() from the superclass already return the cropped region, so there is no need for GetCropRegion().
        BUG: 0010513: Adding Get functions for calculated crop region in itkAutoCropLabelMapFilter (bug 0010513)

    Code/Review/itkAutoCropLabelMapFilter
        ENH: GetRegion() from the superclass already return the cropped region, so there is no need for GetCropRegion().

    Code/Review/itkDirectFourierReconstructionImageToImageFilter
    ** */

    Code/Review/itkDiscreteGaussianDerivativeImageFilter
        BUG: 10785 Improved performance of the filter by reordering the dirctional convolutions and added a ivar to determin the number of streams

    Code/Review/itkDiscreteGaussianDerivativeImageFilter
        BUG: 10785 Improved performance of the filter by reordering the dirctional convolutions and added a ivar to determin the number of streams

    Code/Review/itkGenericUtilities
        BUG: Added itkMRCImageIOTest.cxx to test MRCImageIO system.  Also removed Local namespace from all files associated with the paper.

    Code/Review/itkHessianToObjectnessMeasureImageFilter
        ENH: Added progress support, multi-threaded the computation,changed using SymmetricEigenAnalysisImageFilter to SymmetricEigenAnalysis calculator, too alpha and beta to the limits when they are zero. These changes significantly reduce memory usage and improve performance.

    Code/Review/itkHessianToObjectnessMeasureImageFilter
        ENH: Added progress support, multi-threaded the computation,changed using SymmetricEigenAnalysisImageFilter to SymmetricEigenAnalysis calculator, too alpha and beta to the limits when they are zero. These changes significantly reduce memory usage and improve performance.

    Code/Review/itkMRCHeaderObject
        BUG: Added itkMRCImageIOTest.cxx to test MRCImageIO system.  Also removed Local namespace from all files associated with the paper.
    3171 by Lowekamp B., Chen D.

    Code/Review/itkMRCHeaderObject
        BUG: Added itkMRCImageIOTest.cxx to test MRCImageIO system.  Also removed Local namespace from all files associated with the paper.
    3171 by Lowekamp B., Chen D.

    Code/Review/itkMRCImageIO
        BUG: Spacing should default to 1 when padding from a lesser dimension image to write to 3d
        BUG: Fixed segfault in itkMRCImageIO.cxx when using 1 or 2 dimensions.  Error was caused by trying to access indices 1 and 2 of m_Spacing and m_Origin without checking dimensionality.
        COMP: VS6 require explicit template parameterization for templated member functions

    Code/Review/itkMRCImageIO
        BUG: Corrected the Superclass typedef and the itkTypeMacro
        COMP: Moved templated function into header to avoid VS 6 issues.
    3171 by Lowekamp B., Chen D.

    Code/Review/itkMRCImageIOFactory
        ENH: adding Object factory for Review ImageIO classes

    Code/Review/itkMRCImageIOFactory
        ENH: Adding ImageIOFactories for MRCImageIO and VTKImageIO2

    Code/Review/itkMultiScaleHessianBasedMeasureImageFilter
        BUG: added check for calculation of progress to avoid a divide by zero when m_NumberOfSigmaSteps is zero

    Code/Review/itkQuadEdge

    Code/Review/itkQuadEdgeMe

    Code/Review/itkQuadEdgeMeshBaseIterator
    ** */

    Code/Review/itkQuadEdgeMeshFrontIterator
    ** */

    Code/Review/itkQuadEdgeMeshPoint
    ** */

    Code/Review/itkQuadEdgeMeshTraits

    Code/Review/Attic/itkScaleVersor3DTransform
        STYLE: Further code review in preparation for moving the class into Common.

    Code/Review/Attic/itkScaleVersor3DTransform
        STYLE: Further code review in preparation for moving the class into Common.

    Code/Review/itkShapeLabelMapFilter
        BUG: Fix overflow with negative indexes

    Code/Review/itkSliceBySliceImageFilter
        BUG: 0009923 Added missing include in itkSliceBySliceImageFilter, add it as first include in filter's test

    Code/Review/itkStatisticsLabelMapFilter
        ENH: Added comment to redirect to the Migration Users Guide.

    Code/Review/itkStreamingImageIOBase
        COMP: BCC appears not to have a streampos += streamoff operator so it is changed to streampos = streampos + streamoff
        ENH: Removing "Local" namespace that was used as a temporary help.

    Code/Review/itkStreamingImageIOBase
    ** */
    3171 by Lowekamp B., Chen D.

    Code/Review/itkTransformIOBase

    Code/Review/itkVTKImageIO2
        COMP: On systems that do not have uint64_t, use double for swapping type if component size is 8.
        BUG: Added itkMRCImageIOTest.cxx to test MRCImageIO system.  Also removed Local namespace from all files associated with the paper.
        COMP: not all systems have uint64_t added ITK_HAS_INT definition check

    Code/Review/itkVTKImageIO2
        BUG: Corrected the Superclass typedef and the itkTypeMacro
    3171 by Lowekamp B., Chen D.

    Code/Review/itkVTKImageIO2Factory
        ENH: adding Object factory for Review ImageIO classes

    Code/Review/itkVTKImageIO2Factory
        ENH: Adding ImageIOFactories for MRCImageIO and VTKImageIO2

    Code/Review/Statistics/itkExpectationMaximizationMixtureModelEstimator
        BUG: Should never allow a division by 0.

    Code/Review/Statistics/itkHistogramToEntropyImageFilter
        ENH: Porting to the new Statistics Framework the filters that convert Histograms into Images.

    Code/Review/Statistics/itkHistogramToImageFilter
        ENH: Porting to the new Statistics Framework the filters that convert Histograms into Images.

    Code/Review/Statistics/itkHistogramToImageFilter
        ENH: Porting to the new Statistics Framework the filters that convert Histograms into Images.

    Code/Review/Statistics/itkHistogramToIntensityImageFilter
        ENH: Porting to the new Statistics Framework the filters that convert Histograms into Images.

    Code/Review/Statistics/itkHistogramToLogProbabilityImageFilter
        ENH: Porting to the new Statistics Framework the filters that convert Histograms into Images.

    Code/Review/Statistics/itkHistogramToProbabilityImageFilter
        ENH: Porting to the new Statistics Framework the filters that convert Histograms into Images.

    Code/Review/Statistics/itkWeightedCovarianceSampleFilter
        BUG:  Added explicit run-time MeasurementVector length specification.

    Code/SpatialObject/itkContourSpatialObject
        BUG: Adding modified versions of itkMetaArrowConverter.txx, itkContourSpatialObject.h, and itkContourSpatialObject.txx that I forgot to add with previous commits (causing test failure).

    Code/SpatialObject/itkContourSpatialObject
        COMP: Removed parameter name "point" from itkContourSpatialObject::IsInside since no longer used in order to remove compiler warnings
        BUG: Adding modified versions of itkMetaArrowConverter.txx, itkContourSpatialObject.h, and itkContourSpatialObject.txx that I forgot to add with previous commits (causing test failure).

    Code/SpatialObject/itkMetaArrowConverter
        BUG: Fixed the conversion of Direction between ArrowSpatialObject and MetaArrow by adding a new field to MetaArrow rather than trying to put the direction vector into the Orientation matrix.

    Code/SpatialObject/itkPolygonSpatialObject
        BUG: attempt to copy-construct an iterator from a singular iterator.

    Examples/Registration/CMakeLists.txt
        ENH: Condition ImageRegistration20Test to only be run in a Release build.

    Testing/CMakeLists.txt
        COMP: Need FIND_PACKAGE(Java) when building inside tree as well as outside.

    Testing/Code/Algorithms/CMakeLists.txt
        ENH: Added a test of the VoronoiSegmentationRGBImageFilter.  This test creates an image with foreground objects and random rgb noise and checks that the segmentation performs reasonably well.
        BUG: Disabled itkBinaryMedialNodeMetricTest in CMakeLists file and itkAlgorithmsTests4.cxx so that the underlying Blox code can be debugged to uncover the cause of random test failure.

    Testing/Code/Algorithms/itkAlgorithmsTests4
        ENH: Added a test of the VoronoiSegmentationRGBImageFilter.  This test creates an image with foreground objects and random rgb noise and checks that the segmentation performs reasonably well.
        BUG: Disabled itkBinaryMedialNodeMetricTest in CMakeLists file and itkAlgorithmsTests4.cxx so that the underlying Blox code can be debugged to uncover the cause of random test failure.

    Testing/Code/Algorithms/itkBinaryMedialNodeMetricTest
        BUG: Attempting to debug the few sporadic failures.  Made sure all arrays were initialized and that the success check in the test has a small tolerance for precision errors
        ENH: Added coverage for printing and GetNameOfClass in  itkBinaryMedialNodeMetric

    Testing/Code/Algorithms/itkImagePCAShapeModelEstimatorTest
        COMP: fix warning NUMLARGESTPC is an unsigned int

    Testing/Code/Algorithms/itkVoronoiSegmentationRGBImageFilterTest
        BUG: Added still more debug output to itkVoronoiSegmentationRGBImageFilterTest.cxx in an attempt to fix runtime errors when build with bcc
        ENH: Added a test of the VoronoiSegmentationRGBImageFilter.  This test creates an image with foreground objects and random rgb noise and checks that the segmentation performs reasonably well.

    Testing/Code/BasicFilters/CMakeLists.txt
        BUG: fix to bug 0010599 and introduction of a new test itkHessianRecursiveGaussianImageFilterScaleSpaceTest testing the behavior of itkHessianRecursiveGaussianImageFilter in scale-space for dimensions 3 and greater

    Testing/Code/BasicFilters/itkAdaptImageFilterTest
        STYLE: Revert an erroneous 'cerr' message to 'cout'.

    Testing/Code/BasicFilters/itkBasicFiltersTests3
        BUG: fix to bug 0010599 and introduction of a new test itkHessianRecursiveGaussianImageFilterScaleSpaceTest testing the behavior of itkHessianRecursiveGaussianImageFilter in scale-space for dimensions 3 and greater

    Testing/Code/BasicFilters/itkHessianRecursiveGaussianFilterScaleSpaceTest
        BUG: replacing exp with vcl_exp, thanks to Marius Staring for pointing this out

    Testing/Code/BasicFilters/itkTriangleMeshToSimplexMeshFilter2Test

    Testing/Code/Common/CMakeLists.txt
        ENH: Added test for itkTransformFactoryBase
        ENH: Adding explicit test fo the ImageToImageFilter class.

    Testing/Code/Common/itkBSplineDeformableTransformTest3
        COMP: should be int instead of unsigned int

    Testing/Code/Common/itkCommonTests2
        ENH: Added test for itkTransformFactoryBase
        ENH: Adding explicit test fo the ImageToImageFilter class.

    Testing/Code/Common/itkImageComputeOffsetAndIndexTest
        COMP: index is filled with 0 values (warning on gcc 4.4.4).

    Testing/Code/Common/itkImageToImageFilterTest
        COMP: Adding a explicit typedef for Superclass in order to help the SunCC compiler.
        ENH: Adding explicit test fo the ImageToImageFilter class.

    Testing/Code/Common/itkNonUniformBSplineTest
        COMP: Fixed warnings about initializing integer variables with doubles.

    Testing/Code/Common/itkScaleVersor3DTransformTest
        COMP: resolving warnings 'excp' : unreferenced local variable

    Testing/Code/Common/itkTransformFactoryBaseTest
        ENH: Added test for itkTransformFactoryBase

    Testing/Code/IO/CMakeLists.txt
        BUG: Outcommenting LSM write test. It fails.
        BUG: AnalyzeImageIO was not using the right field to store the acquitition time. Added a test to exercise the storage and retrieval of metadata in the image file format.

    Testing/Code/IO/itkGDCMImageIOTest
        ENH: more code coverage by exercising get methods

    Testing/Code/IO/itkIOCommonTest
        BUG: accounting for case of no filename extension in this test

    Testing/Code/IO/itkIOTests
        BUG: AnalyzeImageIO was not using the right field to store the acquitition time. Added a test to exercise the storage and retrieval of metadata in the image file format.

    Testing/Code/IO/itkImageFileWriterTest2
        BUG: Uninitialized image buffer was fixed.

    Testing/Code/IO/itkMetaImageIOTest
        BUG: Fixed failure of MetaImageStreamingIOTest and MetaImageCompressedStreamingIOTest.  Problem was caused by using the same MetaImageIO object for both reading and writing in itkMetaImageStreamingIOTest.cxx

    Testing/Code/IO/itkMetaImageStreamingIOTest
        BUG: Fixed failure of MetaImageStreamingIOTest and MetaImageCompressedStreamingIOTest.  Problem was caused by using the same MetaImageIO object for both reading and writing in itkMetaImageStreamingIOTest.cxx

    Testing/Code/IO/itkReadWriteImageWithDictionaryTest
        COMP: For Visual Studio 6, the map iterator cannot be safely used outside the DLL that contains the map. The part of the test that uses the MetaDataDictionary is removed for VS6, shared builds.
        COMP: Trying to fix MSVC link errors
        ENH: Added support for ITK_VoxelUnits and ITK_ExperimentDate in MetaImageIO. This relies on MetaObject::DistanceUnits and MetaObject::AcquisitionDate.

    Testing/Code/IO/itkSymmetricSecondRankTensorImageWriteReadTest

    Testing/Code/Numerics/itkLBFGSBOptimizerTest
        ENH: more code coverage by exercising get methods
        ENH: more code coverage by exercising get methods

    Testing/Code/Numerics/itkLBFGSOptimizerTest
        ENH: more code coverage by exercising get methods

    Testing/Code/Review/CMakeLists.txt
        ENH: Added itkVTKImageIO2Test.cxx as a test for the new itkVTKImageIO2 class in review

    Testing/Code/Review/itkAutoCropLabelMapFilterTest1
        ENH: GetRegion() from the superclass already return the cropped region, so there is no need for GetCropRegion().

    Testing/Code/Review/itkMRCImageIOTest
        ENH: add  EXERCISE_BASIC_OBJECT_METHODS macro to increase code coverage
        BUG: Trying to fix VS6 compilation issue relating to use of templates in calling the WriteMRCImage and ReadMRCImage tests
        BUG: Added #include <numeric> to itkMRCImageIO.h so that std::accumulate would compile

    Testing/Code/Review/itkReviewTests3

    Testing/Code/Review/itkReviewTests5
        ENH: Added itkVTKImageIO2Test.cxx as a test for the new itkVTKImageIO2 class in review

    Testing/Code/Review/Attic/itkScaleVersor3DTransformTest
        ENH: Increased code coverage to 98% by exercising the SetMatrix() method.

    Testing/Code/Review/itkSliceBySliceImageFilterTest
        BUG: 0009923 Added missing include in itkSliceBySliceImageFilter, add it as first include in filter's test

    Testing/Code/Review/itkTestingMacros
        COMP: Temporary Borland compiler workaround

    Testing/Code/Review/itkTransformFileReaderWriterTest
        BUG: Fixed problem with default transformations not being registered by explicitly calling RegisterDefaultTransforms.  There appears to be a logical flaw in the system for registering transforms where the defaults are only registered if no other transform is registered.  While this seems to be a bug, changing it would break backwards compatibility, so it is left as is.
        BUG:  0010866 Reported on bug tracker.  When registering a new transform, all the default registerd transform types are lost.

    Testing/Code/Review/itkVTKImageIO2Test
        ENH: add  EXERCISE_BASIC_OBJECT_METHODS macro to increase code coverage
        COMP: Fix the compiler warnings being issued for itkVTKImageIO2Test::Read about index as an unused parameter.  Also added an additional line of exception output to itkVTKImageIO2.cxx for the case when the element size is unknown
        BUG: Fixed Borland compiler bug in itkVTKImageIO2Test relating to calls to WriteVTKImage and added tests for CanReadFile and CanWriteFile

    Testing/Code/Review/Statistics/CMakeLists.txt

        ENH: Adding tests for the Histogram to Image Filters.

    Testing/Code/Review/Statistics/itkHistogramToEntropyImageFilterTest1
        ENH: Adding tests for the Histogram to Image Filters.

    Testing/Code/Review/Statistics/itkHistogramToEntropyImageFilterTest2

    Testing/Code/Review/Statistics/itkHistogramToIntensityImageFilterTest1
        ENH: Adding tests for the Histogram to Image Filters.

    Testing/Code/Review/Statistics/itkHistogramToIntensityImageFilterTest2

    Testing/Code/Review/Statistics/itkHistogramToLogProbabilityImageFilterTest1
        ENH: Adding tests for the Histogram to Image Filters.

    Testing/Code/Review/Statistics/itkHistogramToLogProbabilityImageFilterTest2

    Testing/Code/Review/Statistics/itkHistogramToProbabilityImageFilterTest1
        ENH: Adding tests for the Histogram to Image Filters.

    Testing/Code/Review/Statistics/itkHistogramToProbabilityImageFilterTest2

    Testing/Code/Review/Statistics/itkHistogramToTextureFeaturesFilterTest
        STYLE: removing blank spaces at the end of lines.

    Testing/Code/Review/Statistics/itkImageClassifierFilterTest
        BUG: Modify the test so that it creates a situation where the Expectation Maximization filter will not (initially) classify everything correctly.  This will exercise the divide-by-zero fix committed in the Expectation Maximization Filter code.

    Testing/Code/Review/Statistics/itkStatisticsTests
        BUG: itkWeightedCovarianceSampleFilterTest2 was missing from test driver.
        ENH: Adding tests for the Histogram to Image Filters.

    Testing/Code/Review/Statistics/itkWeightedCovarianceSampleFilterTest2

    Testing/Code/SpatialObject/CMakeLists.txt
        ENH: Added test for itkMetaArrowConverter.  Added test to itkSpatialObjectTests5.  Tests conversion between MetaArrow object and itkArrowSpatialObject.  Currently only tests length conversion.

    Testing/Code/SpatialObject/itkContourSpatialObjectTest
        COMP: Removed dead argument names from ContourSpatialObject::IsInside and ContourSpatialObject::ValueAt.  Also, removed argument names from itkContourSpatialObjectTest.cxx function since no parameters are used.

    Testing/Code/SpatialObject/itkMetaArrowConverterTest
        BUG: Fixed an error in the MetaArrowConverterTest pertaining to MetaArrow's Orientation field
        BUG: Fixed itkMetaArrowConverterTest.cxx in correspondence with itkMetaArrowConverter.txx.  The test now properly tests to make sure direction is converted between ArrowSpatialObject and MetaArrow.
        BUG: fixing failures in itkMetaArrowConverterTest
        ENH: Added test for itkMetaArrowConverter.  Added test to itkSpatialObjectTests5.  Tests conversion between MetaArrow object and itkArrowSpatialObject.  Currently only tests length conversion.

    Testing/Code/SpatialObject/itkSpatialObjectTests5
        ENH: Added test for itkMetaArrowConverter.  Added test to itkSpatialObjectTests5.  Tests conversion between MetaArrow object and itkArrowSpatialObject.  Currently only tests length conversion.

    Testing/Data/Input/HeadMRVolume.mhd
        ENH: Added test coverage for missed methods in itkMetaImageIO.h.  Specifically, coverage was added for SupportsDimension, SetSubsamplingFactor, GetSubsamplingFactor, SetDoublePrecision, CanStreamWrite, and CanStreamRead.

    Testing/Data/Input/HeadMRVolumeCompressed.mha
        ENH: Added test coverage for missed methods in itkMetaImageIO.h.  Specifically, coverage was added for SupportsDimension, SetSubsamplingFactor, GetSubsamplingFactor, SetDoublePrecision, CanStreamWrite, and CanStreamRead.

    Utilities/KWStyle/ITKOverwrite.txt
    3171 by Lowekamp B., Chen D.

    Utilities/MetaIO/.svnrev
        ENH: subversion revision 2479 commited to CVS
        ENH: subversion revision 2437 commited to CVS
        ENH: subversion revision 2272 commited to CVS

    Utilities/MetaIO/CMakeLists.txt

    Utilities/MetaIO/Copyright.txt

    Utilities/MetaIO/localMetaConfiguration

    Utilities/MetaIO/metaArray

    Utilities/MetaIO/metaArray

    Utilities/MetaIO/metaArrow

    Utilities/MetaIO/metaArrow

    Utilities/MetaIO/metaBlob

    Utilities/MetaIO/metaBlob

    Utilities/MetaIO/metaCommand

    Utilities/MetaIO/metaCommand

    Utilities/MetaIO/metaContour

    Utilities/MetaIO/metaContour

    Utilities/MetaIO/metaDTITube

    Utilities/MetaIO/metaDTITube

    Utilities/MetaIO/metaEllipse

    Utilities/MetaIO/metaEllipse

    Utilities/MetaIO/metaEvent

    Utilities/MetaIO/metaForm

    Utilities/MetaIO/metaForm

    Utilities/MetaIO/metaGaussian

    Utilities/MetaIO/metaGaussian

    Utilities/MetaIO/metaGroup

    Utilities/MetaIO/metaGroup

    Utilities/MetaIO/metaITKUtils

    Utilities/MetaIO/metaImage

    Utilities/MetaIO/metaImage

    Utilities/MetaIO/metaImageTypes

    Utilities/MetaIO/metaImageUtils

    Utilities/MetaIO/metaImageUtils

    Utilities/MetaIO/metaLandmark

    Utilities/MetaIO/metaLandmark

    Utilities/MetaIO/metaLine

    Utilities/MetaIO/metaLine

    Utilities/MetaIO/metaMe

    Utilities/MetaIO/metaMesh

    Utilities/MetaIO/metaObject

    Utilities/MetaIO/metaObject

    Utilities/MetaIO/metaOutput

    Utilities/MetaIO/metaOutput

    Utilities/MetaIO/metaScene

    Utilities/MetaIO/metaScene

    Utilities/MetaIO/metaSurface

    Utilities/MetaIO/metaSurface

    Utilities/MetaIO/metaTransform

    Utilities/MetaIO/metaTransform

    Utilities/MetaIO/metaTube

    Utilities/MetaIO/metaTube

    Utilities/MetaIO/metaTubeGra

    Utilities/MetaIO/metaTubeGraph

    Utilities/MetaIO/metaTypes

    Utilities/MetaIO/metaUtils

    Utilities/MetaIO/metaUtils

    Utilities/MetaIO/metaVesselTube

    Utilities/MetaIO/metaVesselTube

    Utilities/NrrdIO/754

    Utilities/NrrdIO/NrrdIO

    Utilities/NrrdIO/defaultsNrrd

    Utilities/NrrdIO/encodingRaw

    Utilities/NrrdIO/privateNrrd

    Utilities/NrrdIO/sane
    .

    Utilities/NrrdIO/write

    Utilities/expat/xmlparse

    Utilities/gdcm/src/gdcmDocument
        BUG: 0010833 GDCM parse fault for special SQ data elements. Apply patch as proposed by Greg Sharp.

    Utilities/itkjpeg/jdscale
        COMP: Fixed local variable that was shadowing a global declaration of a type.

    Utilities/itktiff/mkg3states
        COMP: Fixing warnings about shadowing variables.

    Utilities/itktiff/tif_codec
        COMP: Fixing warnings about shadowing variables.

    Utilities/itktiff/tif_color
        COMP: Fixing warnings about shadowing variables.

    Utilities/itktiff/tif_compress
        COMP: Fixing warnings about shadowing variables.

    Utilities/itktiff/tif_getimage
        COMP: Fixing warnings about shadowing variables.

    Utilities/itktiff/tif_print
        COMP: Fixing warnings about shadowing variables.

    Utilities/itktiff/tiffiop
        COMP: Fixing warnings about shadowing variables.

    Utilities/kwsys/CMakeLists.txt

    Utilities/kwsys/Configure.h.in
        Silence warnings on sgi compiler.

    Utilities/kwsys/Configure.hxx.in

    Utilities/kwsys/DynamicLoader

    Utilities/kwsys/DynamicLoader.hxx.in

    Utilities/kwsys/ProcessUNIX
        KWSys: Process tree kill for Solaris

    Utilities/kwsys/ProcessWin32

    Utilities/kwsys/SharedForward.h.in

    Utilities/kwsys/SystemTools
        Fix for bug #10542, allow this to build on Tru64

    Utilities/kwsys/SystemTools.hxx.in

    Utilities/kwsys/hashtable.hxx.in
        Silence warnings on sgi compiler.
        Fix for bug #10550, work around instantiation out of scope

    Utilities/kwsys/kwsysDateStamp.cmake
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp
        KWSys Nightly Date Stamp

    Utilities/kwsys/testAutoPtr
        Fix for bug #10550, work around instantiation out of scope

    Utilities/kwsys/testProcess

    Utilities/openjpeg/j2k
        COMP: Fixing warnings about local variables shadowing declarations of global symbols (variables and functions).

    Utilities/openjpeg/jp2
        COMP: Fixing warnings about local variables shadowing declarations of global symbols (variables and functions).

    Utilities/openjpeg/openjpeg
        COMP: Fixing warnings about local variables shadowing declarations of global symbols (variables and functions).

    Utilities/openjpeg/pi
        COMP: Fixing warnings about local variables shadowing declarations of global symbols (variables and functions).

    Utilities/openjpeg/t2
        COMP: Fixing warnings about local variables shadowing declarations of global symbols (variables and functions).

    Utilities/openjpeg/tcd
        COMP: Fixing warnings about local variables shadowing declarations of global symbols (variables and functions).

    Utilities/vxl/core/vnl/algo/vnl_lsqr

    Wrapping/CSwig/CMakeLists.txt
        BUG: ITK_WRAP_NEEDS_DEPEND must be set to 1 (on all platforms) for the parallel build to work.

    Wrapping/CSwig/IO/itkTkImageViewer2D
        BUG: 10532. Committing updated patch contributed by Steve Robbins, to make wrapping work with Tcl 8.5.
