---
title: Front-end interfaces
linkTitle: Front-ends
description: Do you prefer a graphical user interface over a text editor? Give these front-ends a try.
categories: [developer tools]
keywords: [frontend, gui]
menu:
  docs:
    parent: developer-tools
    weight: 30
weight: 30
toc: true
aliases: [/tools/frontends/]
---

## Commercial

[CloudCannon](https://cloudcannon.com/hugo-cms/)
: The intuitive Git-based CMS for your Hugo website. CloudCannon syncs changes from your Git repository and pushes content changes back, so your development and content teams are always in sync. Edit all of your content on the page with visual editing, build entire pages with reusable custom components and then publish confidently.

[DatoCMS](https://www.datocms.com)
: DatoCMS is a fully customizable administrative area for your static websites. Use your favorite website generator, let your clients publish new content independently, and the host the site anywhere you like.

[PubCrank](https://www.pubcrank.com/)
: PubCrank is a static site editor which lets you define templates for different front matter layouts in your site. This gives writers an easy-to-use visual interface to create and edit content while maintaining the guardrails that the developer has created. PubCrank is free for local editing.

## Open-source

[Decap CMS](https://decapcms.org/)
: Decap CMS is an open-source, serverless solution for managing Git based content in static sites, and it works on any platform that can host static sites. A [Hugo/Decap CMS starter](https://github.com/decaporg/one-click-hugo-cms) is available to get new projects running quickly.

[Quiqr Desktop](https://quiqr.org/)
: Quiqr Desktop is a open-source, cross-platform, offline desktop CMS for Hugo with built-in Git functionality for deploying static sites to any hosting server.

[Sveltia CMS](https://github.com/sveltia/sveltia-cms/)
:  Sveltia CMS is a drop-in replacement for Decap CMS which is built from the ground up with powerful and performant modern UI library Svelte. Sveltia CMS incorporates i18n into every corner of the product, while striving to radically improve UX, performance and productivity.
