// Copyright 2024 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package unix

import (
	"internal/abi"
	"syscall"
	"unsafe"
)

func libc_faccessat_trampoline()

//go:cgo_import_dynamic libc_faccessat faccessat "/usr/lib/libSystem.B.dylib"

func faccessat(dirfd int, path string, mode uint32, flags int) error {
	p, err := syscall.BytePtrFromString(path)
	if err != nil {
		return err
	}
	_, _, errno := syscall_syscall6(abi.FuncPCABI0(libc_faccessat_trampoline), uintptr(dirfd), uintptr(unsafe.Pointer(p)), uintptr(mode), uintptr(flags), 0, 0)
	if errno != 0 {
		return errno
	}
	return nil
}

func Eaccess(path string, mode uint32) error {
	return faccessat(AT_FDCWD, path, mode, AT_EACCESS)
}
