// Generated by gmmproc 2.80.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <giomm/subprocesslauncher.h>
#include <giomm/private/subprocesslauncher_p.h>


/* Copyright (C) 2023 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gio/gio.h>

namespace
{
extern "C"
{
#ifdef G_OS_UNIX
static void SubprocessLauncher_child_setup_callback(void* user_data)
{
  try
  {
    (*static_cast<Glib::SlotSpawnChildSetup*>(user_data))();
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
  }
}

static void SubprocessLauncher_child_setup_callback_destroy(void* user_data)
{
  delete static_cast<Glib::SlotSpawnChildSetup*>(user_data);
}
#endif // G_OS_UNIX
} // extern "C"
} // anonymous namespace

namespace Gio
{
void SubprocessLauncher::inherit_environ()
{
  g_subprocess_launcher_set_environ(gobj(), nullptr);
}

#ifdef G_OS_UNIX
void SubprocessLauncher::set_child_setup(const Glib::SlotSpawnChildSetup& child_setup)
{
  const bool setup_slot = !child_setup.empty();

  g_subprocess_launcher_set_child_setup(gobj(),
    setup_slot ? &SubprocessLauncher_child_setup_callback : nullptr,
    setup_slot ? new Glib::SlotSpawnChildSetup(child_setup) : nullptr,
    setup_slot ? &SubprocessLauncher_child_setup_callback_destroy : nullptr);
}
#endif // G_OS_UNIX
} // namespace Gio

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::SubprocessLauncher> wrap(GSubprocessLauncher* object, bool take_copy)
{
  return Glib::make_refptr_for_instance<Gio::SubprocessLauncher>( dynamic_cast<Gio::SubprocessLauncher*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& SubprocessLauncher_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &SubprocessLauncher_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_subprocess_launcher_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void SubprocessLauncher_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* SubprocessLauncher_Class::wrap_new(GObject* object)
{
  return new SubprocessLauncher((GSubprocessLauncher*)object);
}


/* The implementation: */

GSubprocessLauncher* SubprocessLauncher::gobj_copy()
{
  reference();
  return gobj();
}

SubprocessLauncher::SubprocessLauncher(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

SubprocessLauncher::SubprocessLauncher(GSubprocessLauncher* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


SubprocessLauncher::SubprocessLauncher(SubprocessLauncher&& src) noexcept
: Glib::Object(std::move(src))
{}

SubprocessLauncher& SubprocessLauncher::operator=(SubprocessLauncher&& src) noexcept
{
  Glib::Object::operator=(std::move(src));
  return *this;
}


SubprocessLauncher::~SubprocessLauncher() noexcept
{}


SubprocessLauncher::CppClassType SubprocessLauncher::subprocesslauncher_class_; // initialize static member

GType SubprocessLauncher::get_type()
{
  return subprocesslauncher_class_.init().get_type();
}


GType SubprocessLauncher::get_base_type()
{
  return g_subprocess_launcher_get_type();
}


Glib::RefPtr<SubprocessLauncher> SubprocessLauncher::create(Subprocess::Flags flags)
{
  return Glib::wrap(g_subprocess_launcher_new(static_cast<GSubprocessFlags>(flags)));
}

Glib::RefPtr<Subprocess> SubprocessLauncher::spawn(const std::vector<std::string>& argv)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_subprocess_launcher_spawnv(gobj(), Glib::ArrayHandler<std::string>::vector_to_array(argv).data(), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

void SubprocessLauncher::set_environ(const std::vector<std::string>& env)
{
  g_subprocess_launcher_set_environ(gobj(), const_cast<char**>(Glib::ArrayHandler<std::string>::vector_to_array(env).data()));
}

void SubprocessLauncher::setenv(const std::string& variable, const std::string& value, bool overwrite)
{
  g_subprocess_launcher_setenv(gobj(), variable.c_str(), value.c_str(), static_cast<int>(overwrite));
}

void SubprocessLauncher::unsetenv(const std::string& variable)
{
  g_subprocess_launcher_unsetenv(gobj(), variable.c_str());
}

std::string SubprocessLauncher::getenv(const std::string& variable)
{
  return Glib::convert_const_gchar_ptr_to_stdstring(g_subprocess_launcher_getenv(gobj(), variable.c_str()));
}

void SubprocessLauncher::set_cwd(const std::string& cwd)
{
  g_subprocess_launcher_set_cwd(gobj(), cwd.c_str());
}

void SubprocessLauncher::set_flags(Subprocess::Flags flags)
{
  g_subprocess_launcher_set_flags(gobj(), static_cast<GSubprocessFlags>(flags));
}

#ifdef G_OS_UNIX
void SubprocessLauncher::set_stdin_file_path(const std::string& path)
{
  g_subprocess_launcher_set_stdin_file_path(gobj(), path.empty() ? nullptr : path.c_str());
}
#endif // G_OS_UNIX

#ifdef G_OS_UNIX
void SubprocessLauncher::take_stdin_fd(int fd)
{
  g_subprocess_launcher_take_stdin_fd(gobj(), fd);
}
#endif // G_OS_UNIX

#ifdef G_OS_UNIX
void SubprocessLauncher::set_stdout_file_path(const std::string& path)
{
  g_subprocess_launcher_set_stdout_file_path(gobj(), path.empty() ? nullptr : path.c_str());
}
#endif // G_OS_UNIX

#ifdef G_OS_UNIX
void SubprocessLauncher::take_stdout_fd(int fd)
{
  g_subprocess_launcher_take_stdout_fd(gobj(), fd);
}
#endif // G_OS_UNIX

#ifdef G_OS_UNIX
void SubprocessLauncher::set_stderr_file_path(const std::string& path)
{
  g_subprocess_launcher_set_stderr_file_path(gobj(), path.empty() ? nullptr : path.c_str());
}
#endif // G_OS_UNIX

#ifdef G_OS_UNIX
void SubprocessLauncher::take_stderr_fd(int fd)
{
  g_subprocess_launcher_take_stderr_fd(gobj(), fd);
}
#endif // G_OS_UNIX

#ifdef G_OS_UNIX
void SubprocessLauncher::take_fd(int source_fd, int target_fd)
{
  g_subprocess_launcher_take_fd(gobj(), source_fd, target_fd);
}
#endif // G_OS_UNIX

#ifdef G_OS_UNIX
void SubprocessLauncher::close()
{
  g_subprocess_launcher_close(gobj());
}
#endif // G_OS_UNIX


} // namespace Gio


