// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package prompter

import (
	"sync"
)

// Ensure, that PrompterMock does implement Prompter.
// If this is not the case, regenerate this file with moq.
var _ Prompter = &PrompterMock{}

// PrompterMock is a mock implementation of Prompter.
//
//	func TestSomethingThatUsesPrompter(t *testing.T) {
//
//		// make and configure a mocked Prompter
//		mockedPrompter := &PrompterMock{
//			AuthTokenFunc: func() (string, error) {
//				panic("mock out the AuthToken method")
//			},
//			ConfirmFunc: func(prompt string, defaultValue bool) (bool, error) {
//				panic("mock out the Confirm method")
//			},
//			ConfirmDeletionFunc: func(requiredValue string) error {
//				panic("mock out the ConfirmDeletion method")
//			},
//			InputFunc: func(prompt string, defaultValue string) (string, error) {
//				panic("mock out the Input method")
//			},
//			InputHostnameFunc: func() (string, error) {
//				panic("mock out the InputHostname method")
//			},
//			MarkdownEditorFunc: func(prompt string, defaultValue string, blankAllowed bool) (string, error) {
//				panic("mock out the MarkdownEditor method")
//			},
//			MultiSelectFunc: func(prompt string, defaults []string, options []string) ([]int, error) {
//				panic("mock out the MultiSelect method")
//			},
//			PasswordFunc: func(prompt string) (string, error) {
//				panic("mock out the Password method")
//			},
//			SelectFunc: func(prompt string, defaultValue string, options []string) (int, error) {
//				panic("mock out the Select method")
//			},
//		}
//
//		// use mockedPrompter in code that requires Prompter
//		// and then make assertions.
//
//	}
type PrompterMock struct {
	// AuthTokenFunc mocks the AuthToken method.
	AuthTokenFunc func() (string, error)

	// ConfirmFunc mocks the Confirm method.
	ConfirmFunc func(prompt string, defaultValue bool) (bool, error)

	// ConfirmDeletionFunc mocks the ConfirmDeletion method.
	ConfirmDeletionFunc func(requiredValue string) error

	// InputFunc mocks the Input method.
	InputFunc func(prompt string, defaultValue string) (string, error)

	// InputHostnameFunc mocks the InputHostname method.
	InputHostnameFunc func() (string, error)

	// MarkdownEditorFunc mocks the MarkdownEditor method.
	MarkdownEditorFunc func(prompt string, defaultValue string, blankAllowed bool) (string, error)

	// MultiSelectFunc mocks the MultiSelect method.
	MultiSelectFunc func(prompt string, defaults []string, options []string) ([]int, error)

	// PasswordFunc mocks the Password method.
	PasswordFunc func(prompt string) (string, error)

	// SelectFunc mocks the Select method.
	SelectFunc func(prompt string, defaultValue string, options []string) (int, error)

	// calls tracks calls to the methods.
	calls struct {
		// AuthToken holds details about calls to the AuthToken method.
		AuthToken []struct {
		}
		// Confirm holds details about calls to the Confirm method.
		Confirm []struct {
			// Prompt is the prompt argument value.
			Prompt string
			// DefaultValue is the defaultValue argument value.
			DefaultValue bool
		}
		// ConfirmDeletion holds details about calls to the ConfirmDeletion method.
		ConfirmDeletion []struct {
			// RequiredValue is the requiredValue argument value.
			RequiredValue string
		}
		// Input holds details about calls to the Input method.
		Input []struct {
			// Prompt is the prompt argument value.
			Prompt string
			// DefaultValue is the defaultValue argument value.
			DefaultValue string
		}
		// InputHostname holds details about calls to the InputHostname method.
		InputHostname []struct {
		}
		// MarkdownEditor holds details about calls to the MarkdownEditor method.
		MarkdownEditor []struct {
			// Prompt is the prompt argument value.
			Prompt string
			// DefaultValue is the defaultValue argument value.
			DefaultValue string
			// BlankAllowed is the blankAllowed argument value.
			BlankAllowed bool
		}
		// MultiSelect holds details about calls to the MultiSelect method.
		MultiSelect []struct {
			// Prompt is the prompt argument value.
			Prompt string
			// Defaults is the defaults argument value.
			Defaults []string
			// Options is the options argument value.
			Options []string
		}
		// Password holds details about calls to the Password method.
		Password []struct {
			// Prompt is the prompt argument value.
			Prompt string
		}
		// Select holds details about calls to the Select method.
		Select []struct {
			// Prompt is the prompt argument value.
			Prompt string
			// DefaultValue is the defaultValue argument value.
			DefaultValue string
			// Options is the options argument value.
			Options []string
		}
	}
	lockAuthToken       sync.RWMutex
	lockConfirm         sync.RWMutex
	lockConfirmDeletion sync.RWMutex
	lockInput           sync.RWMutex
	lockInputHostname   sync.RWMutex
	lockMarkdownEditor  sync.RWMutex
	lockMultiSelect     sync.RWMutex
	lockPassword        sync.RWMutex
	lockSelect          sync.RWMutex
}

// AuthToken calls AuthTokenFunc.
func (mock *PrompterMock) AuthToken() (string, error) {
	if mock.AuthTokenFunc == nil {
		panic("PrompterMock.AuthTokenFunc: method is nil but Prompter.AuthToken was just called")
	}
	callInfo := struct {
	}{}
	mock.lockAuthToken.Lock()
	mock.calls.AuthToken = append(mock.calls.AuthToken, callInfo)
	mock.lockAuthToken.Unlock()
	return mock.AuthTokenFunc()
}

// AuthTokenCalls gets all the calls that were made to AuthToken.
// Check the length with:
//
//	len(mockedPrompter.AuthTokenCalls())
func (mock *PrompterMock) AuthTokenCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockAuthToken.RLock()
	calls = mock.calls.AuthToken
	mock.lockAuthToken.RUnlock()
	return calls
}

// Confirm calls ConfirmFunc.
func (mock *PrompterMock) Confirm(prompt string, defaultValue bool) (bool, error) {
	if mock.ConfirmFunc == nil {
		panic("PrompterMock.ConfirmFunc: method is nil but Prompter.Confirm was just called")
	}
	callInfo := struct {
		Prompt       string
		DefaultValue bool
	}{
		Prompt:       prompt,
		DefaultValue: defaultValue,
	}
	mock.lockConfirm.Lock()
	mock.calls.Confirm = append(mock.calls.Confirm, callInfo)
	mock.lockConfirm.Unlock()
	return mock.ConfirmFunc(prompt, defaultValue)
}

// ConfirmCalls gets all the calls that were made to Confirm.
// Check the length with:
//
//	len(mockedPrompter.ConfirmCalls())
func (mock *PrompterMock) ConfirmCalls() []struct {
	Prompt       string
	DefaultValue bool
} {
	var calls []struct {
		Prompt       string
		DefaultValue bool
	}
	mock.lockConfirm.RLock()
	calls = mock.calls.Confirm
	mock.lockConfirm.RUnlock()
	return calls
}

// ConfirmDeletion calls ConfirmDeletionFunc.
func (mock *PrompterMock) ConfirmDeletion(requiredValue string) error {
	if mock.ConfirmDeletionFunc == nil {
		panic("PrompterMock.ConfirmDeletionFunc: method is nil but Prompter.ConfirmDeletion was just called")
	}
	callInfo := struct {
		RequiredValue string
	}{
		RequiredValue: requiredValue,
	}
	mock.lockConfirmDeletion.Lock()
	mock.calls.ConfirmDeletion = append(mock.calls.ConfirmDeletion, callInfo)
	mock.lockConfirmDeletion.Unlock()
	return mock.ConfirmDeletionFunc(requiredValue)
}

// ConfirmDeletionCalls gets all the calls that were made to ConfirmDeletion.
// Check the length with:
//
//	len(mockedPrompter.ConfirmDeletionCalls())
func (mock *PrompterMock) ConfirmDeletionCalls() []struct {
	RequiredValue string
} {
	var calls []struct {
		RequiredValue string
	}
	mock.lockConfirmDeletion.RLock()
	calls = mock.calls.ConfirmDeletion
	mock.lockConfirmDeletion.RUnlock()
	return calls
}

// Input calls InputFunc.
func (mock *PrompterMock) Input(prompt string, defaultValue string) (string, error) {
	if mock.InputFunc == nil {
		panic("PrompterMock.InputFunc: method is nil but Prompter.Input was just called")
	}
	callInfo := struct {
		Prompt       string
		DefaultValue string
	}{
		Prompt:       prompt,
		DefaultValue: defaultValue,
	}
	mock.lockInput.Lock()
	mock.calls.Input = append(mock.calls.Input, callInfo)
	mock.lockInput.Unlock()
	return mock.InputFunc(prompt, defaultValue)
}

// InputCalls gets all the calls that were made to Input.
// Check the length with:
//
//	len(mockedPrompter.InputCalls())
func (mock *PrompterMock) InputCalls() []struct {
	Prompt       string
	DefaultValue string
} {
	var calls []struct {
		Prompt       string
		DefaultValue string
	}
	mock.lockInput.RLock()
	calls = mock.calls.Input
	mock.lockInput.RUnlock()
	return calls
}

// InputHostname calls InputHostnameFunc.
func (mock *PrompterMock) InputHostname() (string, error) {
	if mock.InputHostnameFunc == nil {
		panic("PrompterMock.InputHostnameFunc: method is nil but Prompter.InputHostname was just called")
	}
	callInfo := struct {
	}{}
	mock.lockInputHostname.Lock()
	mock.calls.InputHostname = append(mock.calls.InputHostname, callInfo)
	mock.lockInputHostname.Unlock()
	return mock.InputHostnameFunc()
}

// InputHostnameCalls gets all the calls that were made to InputHostname.
// Check the length with:
//
//	len(mockedPrompter.InputHostnameCalls())
func (mock *PrompterMock) InputHostnameCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockInputHostname.RLock()
	calls = mock.calls.InputHostname
	mock.lockInputHostname.RUnlock()
	return calls
}

// MarkdownEditor calls MarkdownEditorFunc.
func (mock *PrompterMock) MarkdownEditor(prompt string, defaultValue string, blankAllowed bool) (string, error) {
	if mock.MarkdownEditorFunc == nil {
		panic("PrompterMock.MarkdownEditorFunc: method is nil but Prompter.MarkdownEditor was just called")
	}
	callInfo := struct {
		Prompt       string
		DefaultValue string
		BlankAllowed bool
	}{
		Prompt:       prompt,
		DefaultValue: defaultValue,
		BlankAllowed: blankAllowed,
	}
	mock.lockMarkdownEditor.Lock()
	mock.calls.MarkdownEditor = append(mock.calls.MarkdownEditor, callInfo)
	mock.lockMarkdownEditor.Unlock()
	return mock.MarkdownEditorFunc(prompt, defaultValue, blankAllowed)
}

// MarkdownEditorCalls gets all the calls that were made to MarkdownEditor.
// Check the length with:
//
//	len(mockedPrompter.MarkdownEditorCalls())
func (mock *PrompterMock) MarkdownEditorCalls() []struct {
	Prompt       string
	DefaultValue string
	BlankAllowed bool
} {
	var calls []struct {
		Prompt       string
		DefaultValue string
		BlankAllowed bool
	}
	mock.lockMarkdownEditor.RLock()
	calls = mock.calls.MarkdownEditor
	mock.lockMarkdownEditor.RUnlock()
	return calls
}

// MultiSelect calls MultiSelectFunc.
func (mock *PrompterMock) MultiSelect(prompt string, defaults []string, options []string) ([]int, error) {
	if mock.MultiSelectFunc == nil {
		panic("PrompterMock.MultiSelectFunc: method is nil but Prompter.MultiSelect was just called")
	}
	callInfo := struct {
		Prompt   string
		Defaults []string
		Options  []string
	}{
		Prompt:   prompt,
		Defaults: defaults,
		Options:  options,
	}
	mock.lockMultiSelect.Lock()
	mock.calls.MultiSelect = append(mock.calls.MultiSelect, callInfo)
	mock.lockMultiSelect.Unlock()
	return mock.MultiSelectFunc(prompt, defaults, options)
}

// MultiSelectCalls gets all the calls that were made to MultiSelect.
// Check the length with:
//
//	len(mockedPrompter.MultiSelectCalls())
func (mock *PrompterMock) MultiSelectCalls() []struct {
	Prompt   string
	Defaults []string
	Options  []string
} {
	var calls []struct {
		Prompt   string
		Defaults []string
		Options  []string
	}
	mock.lockMultiSelect.RLock()
	calls = mock.calls.MultiSelect
	mock.lockMultiSelect.RUnlock()
	return calls
}

// Password calls PasswordFunc.
func (mock *PrompterMock) Password(prompt string) (string, error) {
	if mock.PasswordFunc == nil {
		panic("PrompterMock.PasswordFunc: method is nil but Prompter.Password was just called")
	}
	callInfo := struct {
		Prompt string
	}{
		Prompt: prompt,
	}
	mock.lockPassword.Lock()
	mock.calls.Password = append(mock.calls.Password, callInfo)
	mock.lockPassword.Unlock()
	return mock.PasswordFunc(prompt)
}

// PasswordCalls gets all the calls that were made to Password.
// Check the length with:
//
//	len(mockedPrompter.PasswordCalls())
func (mock *PrompterMock) PasswordCalls() []struct {
	Prompt string
} {
	var calls []struct {
		Prompt string
	}
	mock.lockPassword.RLock()
	calls = mock.calls.Password
	mock.lockPassword.RUnlock()
	return calls
}

// Select calls SelectFunc.
func (mock *PrompterMock) Select(prompt string, defaultValue string, options []string) (int, error) {
	if mock.SelectFunc == nil {
		panic("PrompterMock.SelectFunc: method is nil but Prompter.Select was just called")
	}
	callInfo := struct {
		Prompt       string
		DefaultValue string
		Options      []string
	}{
		Prompt:       prompt,
		DefaultValue: defaultValue,
		Options:      options,
	}
	mock.lockSelect.Lock()
	mock.calls.Select = append(mock.calls.Select, callInfo)
	mock.lockSelect.Unlock()
	return mock.SelectFunc(prompt, defaultValue, options)
}

// SelectCalls gets all the calls that were made to Select.
// Check the length with:
//
//	len(mockedPrompter.SelectCalls())
func (mock *PrompterMock) SelectCalls() []struct {
	Prompt       string
	DefaultValue string
	Options      []string
} {
	var calls []struct {
		Prompt       string
		DefaultValue string
		Options      []string
	}
	mock.lockSelect.RLock()
	calls = mock.calls.Select
	mock.lockSelect.RUnlock()
	return calls
}
