/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpitem_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpitem
 * @title: gimpitem
 * @short_description: Functions to manipulate items.
 *
 * Functions to manipulate items.
 **/


/**
 * gimp_item_id_is_valid:
 * @item_id: The item ID to check.
 *
 * Returns %TRUE if the item ID is valid.
 *
 * This procedure checks if the given item ID is valid and refers to an
 * existing item.
 *
 * *Note*: in most use cases, you should not use this function. If you
 * got a [class@Gimp.Item] from the API, you should trust it is valid.
 * This function is mostly for internal usage.
 *
 * Returns: Whether the item ID is valid.
 *
 * Since: 3.0
 **/
gboolean
gimp_item_id_is_valid (gint item_id)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean valid = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_INT, item_id,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-id-is-valid",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    valid = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return valid;
}

/**
 * gimp_item_id_is_drawable:
 * @item_id: The item ID.
 *
 * Returns whether the item ID is a drawable.
 *
 * This procedure returns %TRUE if the specified item ID is a drawable.
 *
 * *Note*: in most use cases, you should not use this function. See
 * [func@Gimp.Item.id_is_layer] for a discussion on alternatives.
 *
 * Returns: TRUE if the item ID is a drawable, FALSE otherwise.
 *
 * Since: 3.0
 **/
gboolean
gimp_item_id_is_drawable (gint item_id)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean drawable = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_INT, item_id,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-id-is-drawable",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    drawable = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return drawable;
}

/**
 * gimp_item_id_is_layer:
 * @item_id: The item ID.
 *
 * Returns whether the item ID is a layer.
 *
 * This procedure returns %TRUE if the specified item ID is a layer.
 *
 * *Note*: in most use cases, you should not use this function. If the
 * goal is to verify the accurate type for a [class@Gimp.Item], you
 * should either use [method@Gimp.Item.is_layer] or the specific
 * type-checking methods for the used language.
 *
 * For instance, in C:
 *
 * ```C
 * if (GIMP_IS_LAYER (item))
 *   do_something ();
 * ```
 *
 * Or in the Python binding, you could run:
 *
 * ```py3
 * if isinstance(item, Gimp.Layer):
 *   do_something()
 * ```
 *
 * Returns: TRUE if the item is a layer, FALSE otherwise.
 *
 * Since: 3.0
 **/
gboolean
gimp_item_id_is_layer (gint item_id)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean layer = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_INT, item_id,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-id-is-layer",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    layer = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return layer;
}

/**
 * gimp_item_id_is_text_layer:
 * @item_id: The item ID.
 *
 * Returns whether the item ID is a text layer.
 *
 * This procedure returns %TRUE if the specified item ID is a text
 * layer.
 *
 * *Note*: in most use cases, you should not use this function. See
 * [func@Gimp.Item.id_is_layer] for a discussion on alternatives.
 *
 * Returns: TRUE if the item is a text layer, FALSE otherwise.
 *
 * Since: 3.0
 **/
gboolean
gimp_item_id_is_text_layer (gint item_id)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean text_layer = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_INT, item_id,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-id-is-text-layer",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    text_layer = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return text_layer;
}

/**
 * gimp_item_id_is_group_layer:
 * @item_id: The item ID.
 *
 * Returns whether the item ID is a group layer.
 *
 * This procedure returns %TRUE if the specified item ID is a group
 * layer.
 *
 * *Note*: in most use cases, you should not use this function. See
 * [func@Gimp.Item.id_is_layer] for a discussion on alternatives.
 *
 * Returns: TRUE if the item is a group layer, FALSE otherwise.
 *
 * Since: 3.0
 **/
gboolean
gimp_item_id_is_group_layer (gint item_id)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean group_layer = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_INT, item_id,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-id-is-group-layer",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    group_layer = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return group_layer;
}

/**
 * gimp_item_id_is_channel:
 * @item_id: The item ID.
 *
 * Returns whether the item ID is a channel.
 *
 * This procedure returns %TRUE if the specified item ID is a channel.
 *
 * *Note*: in most use cases, you should not use this function. See
 * [func@Gimp.Item.id_is_layer] for a discussion on alternatives.
 *
 * Returns: TRUE if the item ID is a channel, FALSE otherwise.
 *
 * Since: 3.0
 **/
gboolean
gimp_item_id_is_channel (gint item_id)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean channel = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_INT, item_id,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-id-is-channel",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    channel = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return channel;
}

/**
 * gimp_item_id_is_layer_mask:
 * @item_id: The item.
 *
 * Returns whether the item ID is a layer mask.
 *
 * This procedure returns %TRUE if the specified item ID is a layer
 * mask.
 *
 * *Note*: in most use cases, you should not use this function. See
 * [func@Gimp.Item.id_is_layer] for a discussion on alternatives.
 *
 * Returns: TRUE if the item ID is a layer mask, FALSE otherwise.
 *
 * Since: 3.0
 **/
gboolean
gimp_item_id_is_layer_mask (gint item_id)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean layer_mask = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_INT, item_id,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-id-is-layer-mask",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    layer_mask = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return layer_mask;
}

/**
 * gimp_item_id_is_path:
 * @item_id: The item ID.
 *
 * Returns whether the item ID is a path.
 *
 * This procedure returns %TRUE if the specified item ID is a path.
 *
 * *Note*: in most use cases, you should not use this function. See
 * [func@Gimp.Item.id_is_layer] for a discussion on alternatives.
 *
 * Returns: TRUE if the item ID is a path, FALSE otherwise.
 *
 * Since: 3.0
 **/
gboolean
gimp_item_id_is_path (gint item_id)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean path = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_INT, item_id,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-id-is-path",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    path = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return path;
}

/**
 * gimp_item_id_is_selection:
 * @item_id: The item ID.
 *
 * Returns whether the item ID is a selection.
 *
 * This procedure returns %TRUE if the specified item ID is a
 * selection.
 *
 * *Note*: in most use cases, you should not use this function. See
 * [func@Gimp.Item.id_is_layer] for a discussion on alternatives.
 *
 * Returns: TRUE if the item ID is a selection, FALSE otherwise.
 *
 * Since: 3.0
 **/
gboolean
gimp_item_id_is_selection (gint item_id)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean selection = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_INT, item_id,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-id-is-selection",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    selection = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return selection;
}

/**
 * gimp_item_get_image:
 * @item: The item.
 *
 * Returns the item's image.
 *
 * This procedure returns the item's image.
 *
 * Returns: (transfer none): The item's image.
 *
 * Since: 2.8
 **/
GimpImage *
gimp_item_get_image (GimpItem *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpImage *image = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-get-image",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    image = GIMP_VALUES_GET_IMAGE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return image;
}

/**
 * gimp_item_delete:
 * @item: The item to delete.
 *
 * Delete a item.
 *
 * This procedure deletes the specified item. This must not be done if
 * the image containing this item was already deleted or if the item
 * was already removed from the image. The only case in which this
 * procedure is useful is if you want to get rid of a item which has
 * not yet been added to an image.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_delete (GimpItem *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-delete",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_is_group:
 * @item: The item.
 *
 * Returns whether the item is a group item.
 *
 * This procedure returns %TRUE if the specified item is a group item
 * which can have children.
 *
 * Returns: TRUE if the item is a group, FALSE otherwise.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_is_group (GimpItem *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean group = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-is-group",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    group = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return group;
}

/**
 * gimp_item_get_parent:
 * @item: The item.
 *
 * Returns the item's parent item.
 *
 * This procedure returns the item's parent item, if any.
 *
 * Returns: (transfer none): The item's parent item.
 *
 * Since: 2.8
 **/
GimpItem *
gimp_item_get_parent (GimpItem *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpItem *parent = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-get-parent",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    parent = GIMP_VALUES_GET_ITEM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return parent;
}

/**
 * gimp_item_get_children:
 * @item: The item.
 *
 * Returns the item's list of children.
 *
 * This procedure returns the list of items which are children of the
 * specified item. The order is topmost to bottommost.
 *
 * Returns: (element-type GimpItem) (array zero-terminated=1) (transfer container):
 *          The item's list of children.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.8
 **/
GimpItem **
gimp_item_get_children (GimpItem *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpItem **children = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-get-children",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    children = g_value_dup_boxed (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return children;
}

/**
 * gimp_item_get_expanded:
 * @item: The item.
 *
 * Returns whether the item is expanded.
 *
 * This procedure returns %TRUE if the specified item is expanded.
 *
 * Returns: TRUE if the item is expanded, FALSE otherwise.
 *
 * Since: 2.10
 **/
gboolean
gimp_item_get_expanded (GimpItem *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean expanded = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-get-expanded",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    expanded = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return expanded;
}

/**
 * gimp_item_set_expanded:
 * @item: The item.
 * @expanded: TRUE to expand the item, FALSE to collapse the item.
 *
 * Sets the expanded state of the item.
 *
 * This procedure expands or collapses the item.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_item_set_expanded (GimpItem *item,
                        gboolean  expanded)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_BOOLEAN, expanded,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-set-expanded",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_name:
 * @item: The item.
 *
 * Get the name of the specified item.
 *
 * This procedure returns the specified item's name.
 *
 * Returns: (transfer full): The item name.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.8
 **/
gchar *
gimp_item_get_name (GimpItem *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-get-name",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    name = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return name;
}

/**
 * gimp_item_set_name:
 * @item: The item.
 * @name: The new item name.
 *
 * Set the name of the specified item.
 *
 * This procedure sets the specified item's name.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_set_name (GimpItem    *item,
                    const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-set-name",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_visible:
 * @item: The item.
 *
 * Get the visibility of the specified item.
 *
 * This procedure returns the specified item's visibility.
 *
 * Returns: The item visibility.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_get_visible (GimpItem *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean visible = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-get-visible",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    visible = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return visible;
}

/**
 * gimp_item_set_visible:
 * @item: The item.
 * @visible: The new item visibility.
 *
 * Set the visibility of the specified item.
 *
 * This procedure sets the specified item's visibility.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_set_visible (GimpItem *item,
                       gboolean  visible)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_BOOLEAN, visible,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-set-visible",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_lock_content:
 * @item: The item.
 *
 * Get the 'lock content' state of the specified item.
 *
 * This procedure returns the specified item's lock content state.
 *
 * Returns: Whether the item's contents are locked.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_get_lock_content (GimpItem *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean lock_content = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-get-lock-content",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    lock_content = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return lock_content;
}

/**
 * gimp_item_set_lock_content:
 * @item: The item.
 * @lock_content: The new item 'lock content' state.
 *
 * Set the 'lock content' state of the specified item.
 *
 * This procedure sets the specified item's lock content state.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_set_lock_content (GimpItem *item,
                            gboolean  lock_content)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_BOOLEAN, lock_content,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-set-lock-content",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_lock_position:
 * @item: The item.
 *
 * Get the 'lock position' state of the specified item.
 *
 * This procedure returns the specified item's lock position state.
 *
 * Returns: Whether the item's position is locked.
 *
 * Since: 2.10
 **/
gboolean
gimp_item_get_lock_position (GimpItem *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean lock_position = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-get-lock-position",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    lock_position = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return lock_position;
}

/**
 * gimp_item_set_lock_position:
 * @item: The item.
 * @lock_position: The new item 'lock position' state.
 *
 * Set the 'lock position' state of the specified item.
 *
 * This procedure sets the specified item's lock position state.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_item_set_lock_position (GimpItem *item,
                             gboolean  lock_position)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_BOOLEAN, lock_position,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-set-lock-position",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_lock_visibility:
 * @item: The item.
 *
 * Get the 'lock visibility' state of the specified item.
 *
 * This procedure returns the specified item's lock visibility state.
 *
 * Returns: Whether the item's visibility is locked.
 *
 * Since: 3.0
 **/
gboolean
gimp_item_get_lock_visibility (GimpItem *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean lock_visibility = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-get-lock-visibility",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    lock_visibility = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return lock_visibility;
}

/**
 * gimp_item_set_lock_visibility:
 * @item: The item.
 * @lock_visibility: The new item 'lock visibility' state.
 *
 * Set the 'lock visibility' state of the specified item.
 *
 * This procedure sets the specified item's lock visibility state.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
gimp_item_set_lock_visibility (GimpItem *item,
                               gboolean  lock_visibility)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_BOOLEAN, lock_visibility,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-set-lock-visibility",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_color_tag:
 * @item: The item.
 *
 * Get the color tag of the specified item.
 *
 * This procedure returns the specified item's color tag.
 *
 * Returns: The item's color tag.
 *
 * Since: 2.10
 **/
GimpColorTag
gimp_item_get_color_tag (GimpItem *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpColorTag color_tag = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-get-color-tag",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    color_tag = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return color_tag;
}

/**
 * gimp_item_set_color_tag:
 * @item: The item.
 * @color_tag: The new item color tag.
 *
 * Set the color tag of the specified item.
 *
 * This procedure sets the specified item's color tag.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_item_set_color_tag (GimpItem     *item,
                         GimpColorTag  color_tag)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          GIMP_TYPE_COLOR_TAG, color_tag,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-set-color-tag",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_tattoo:
 * @item: The item.
 *
 * Get the tattoo of the specified item.
 *
 * This procedure returns the specified item's tattoo. A tattoo is a
 * unique and permanent identifier attached to a item that can be used
 * to uniquely identify a item within an image even between sessions.
 *
 * Returns: The item tattoo.
 *
 * Since: 2.8
 **/
guint
gimp_item_get_tattoo (GimpItem *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  guint tattoo = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-get-tattoo",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    tattoo = GIMP_VALUES_GET_UINT (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return tattoo;
}

/**
 * gimp_item_set_tattoo:
 * @item: The item.
 * @tattoo: The new item tattoo.
 *
 * Set the tattoo of the specified item.
 *
 * This procedure sets the specified item's tattoo. A tattoo is a
 * unique and permanent identifier attached to a item that can be used
 * to uniquely identify a item within an image even between sessions.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_set_tattoo (GimpItem *item,
                      guint     tattoo)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_UINT, tattoo,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-set-tattoo",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_attach_parasite:
 * @item: The item.
 * @parasite: The parasite to attach to the item.
 *
 * Add a parasite to an item.
 *
 * This procedure attaches a parasite to an item. It has no return
 * values.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_attach_parasite (GimpItem           *item,
                           const GimpParasite *parasite)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          GIMP_TYPE_PARASITE, parasite,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-attach-parasite",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_detach_parasite:
 * @item: The item.
 * @name: The name of the parasite to detach from the item.
 *
 * Removes a parasite from an item.
 *
 * This procedure detaches a parasite from an item. It has no return
 * values.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_item_detach_parasite (GimpItem    *item,
                           const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-detach-parasite",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_item_get_parasite:
 * @item: The item.
 * @name: The name of the parasite to find.
 *
 * Look up a parasite in an item
 *
 * Finds and returns the parasite that is attached to an item.
 *
 * Returns: (transfer full): The found parasite.
 *
 * Since: 2.8
 **/
GimpParasite *
gimp_item_get_parasite (GimpItem    *item,
                        const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpParasite *parasite = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-get-parasite",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    parasite = GIMP_VALUES_DUP_PARASITE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return parasite;
}

/**
 * gimp_item_get_parasite_list:
 * @item: The item.
 *
 * List all parasites.
 *
 * Returns a list of all parasites currently attached the an item.
 *
 * Returns: (array zero-terminated=1) (transfer full):
 *          The names of currently attached parasites.
 *          The returned value must be freed with g_strfreev().
 *
 * Since: 2.8
 **/
gchar **
gimp_item_get_parasite_list (GimpItem *item)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar **parasites = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_ITEM, item,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-item-get-parasite-list",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    parasites = GIMP_VALUES_DUP_STRV (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return parasites;
}
