# Creates C resources file from files in given directory
function(create_resources
         dir
         output)
  # Create empty output file
  file(WRITE
       ${output}
       "")
  # Collect input files
  file(GLOB
       bins
       ${dir}/favicon.ico)
  # Iterate through input files
  foreach(bin
          ${bins})
    # Get short filename
    string(REGEX MATCH
                 "([^/]+)$"
                 filename
                 ${bin})
    # Replace filename spaces & extension separator for C compatibility
    string(REGEX
           REPLACE "\\.| |-"
                   "_"
                   filename
                   ${filename})
    # Read hex data from file
    file(READ
         ${bin}
         filedata
         HEX)
    # Convert hex data for C compatibility
    string(REGEX
           REPLACE "([0-9a-f][0-9a-f])"
                   "0x\\1,"
                   filedata
                   ${filedata})
    # Append data to output file
    file(
      APPEND
      ${output}
      "static const unsigned char ${filename}[] = {${filedata}};\nstatic const unsigned ${filename}_size = sizeof(${filename});\n"
      )
  endforeach()
endfunction()
