;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.

;; RUN: wasm-opt -all %s -S -o - | filecheck %s
;; RUN: wasm-opt -all %s --roundtrip -S -o - | filecheck %s --check-prefix=RTRIP

(module
  (type $struct-i32 (struct (field (mut i32))))
  (type $struct-eq (struct (field (mut eqref))))

  ;; CHECK:      (func $rmw-null (type $1) (result i32)
  ;; CHECK-NEXT:  (block ;; (replaces unreachable StructRMW we can't emit)
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (ref.null none)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $rmw-null (type $1) (result i32)
  ;; RTRIP-NEXT:  (drop
  ;; RTRIP-NEXT:   (ref.null none)
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT:  (drop
  ;; RTRIP-NEXT:   (i32.const 1)
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT:  (unreachable)
  ;; RTRIP-NEXT: )
  (func $rmw-null (result i32)
    (struct.atomic.rmw.add $struct-i32 0
      (ref.null none)
      (i32.const 1)
    )
  )

  ;; CHECK:      (func $cmpxchg-null (type $0) (result i31ref)
  ;; CHECK-NEXT:  (block ;; (replaces unreachable StructCmpxchg we can't emit)
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (ref.null none)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (ref.null none)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (ref.i31
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $cmpxchg-null (type $0) (result i31ref)
  ;; RTRIP-NEXT:  (drop
  ;; RTRIP-NEXT:   (ref.null none)
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT:  (drop
  ;; RTRIP-NEXT:   (ref.null none)
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT:  (drop
  ;; RTRIP-NEXT:   (ref.i31
  ;; RTRIP-NEXT:    (i32.const 0)
  ;; RTRIP-NEXT:   )
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT:  (unreachable)
  ;; RTRIP-NEXT: )
  (func $cmpxchg-null (result i31ref)
    ;; This is technically invalid because the result should be eqref, but we
    ;; lose that type information after parsing. Test that we compute a
    ;; sufficiently general result type from the expected and replacement
    ;; values.
    (struct.atomic.rmw.cmpxchg $struct-eq 0
      (ref.null none)
      (ref.null none)
      (ref.i31 (i32.const 0))
    )
  )

  ;; CHECK:      (func $cmpxchg-null-2 (type $0) (result i31ref)
  ;; CHECK-NEXT:  (block ;; (replaces unreachable StructCmpxchg we can't emit)
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (ref.null none)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (ref.i31
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (ref.null none)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $cmpxchg-null-2 (type $0) (result i31ref)
  ;; RTRIP-NEXT:  (drop
  ;; RTRIP-NEXT:   (ref.null none)
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT:  (drop
  ;; RTRIP-NEXT:   (ref.i31
  ;; RTRIP-NEXT:    (i32.const 0)
  ;; RTRIP-NEXT:   )
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT:  (drop
  ;; RTRIP-NEXT:   (ref.null none)
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT:  (unreachable)
  ;; RTRIP-NEXT: )
  (func $cmpxchg-null-2 (result i31ref)
    ;; Same as above, but with the expected and replacement types reversed.
    (struct.atomic.rmw.cmpxchg $struct-eq 0
      (ref.null none)
      (ref.i31 (i32.const 0))
      (ref.null none)
    )
  )
)
