;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wast -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wast
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wast | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wast | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
  ;; CHECK-TEXT:      (type $0 (func))

  ;; CHECK-TEXT:      (type $1 (func (result i32 i64)))

  ;; CHECK-TEXT:      (type $2 (func (result i32 i64 exnref)))

  ;; CHECK-TEXT:      (type $3 (func (result exnref)))

  ;; CHECK-TEXT:      (type $4 (func (result i32)))

  ;; CHECK-TEXT:      (type $5 (func (result i32 exnref)))

  ;; CHECK-TEXT:      (type $6 (func (param i32)))

  ;; CHECK-TEXT:      (type $7 (func (param i64)))

  ;; CHECK-TEXT:      (type $8 (func (param i32 i64)))

  ;; CHECK-TEXT:      (type $9 (func (param eqref)))

  ;; CHECK-TEXT:      (tag $e-i32 (type $6) (param i32))
  ;; CHECK-BIN:      (type $0 (func))

  ;; CHECK-BIN:      (type $1 (func (result i32 i64)))

  ;; CHECK-BIN:      (type $2 (func (result i32 i64 exnref)))

  ;; CHECK-BIN:      (type $3 (func (result exnref)))

  ;; CHECK-BIN:      (type $4 (func (result i32)))

  ;; CHECK-BIN:      (type $5 (func (result i32 exnref)))

  ;; CHECK-BIN:      (type $6 (func (param i32)))

  ;; CHECK-BIN:      (type $7 (func (param i64)))

  ;; CHECK-BIN:      (type $8 (func (param i32 i64)))

  ;; CHECK-BIN:      (type $9 (func (param eqref)))

  ;; CHECK-BIN:      (tag $e-i32 (type $6) (param i32))
  (tag $e-i32 (param i32))
  ;; CHECK-TEXT:      (tag $e-i64 (type $7) (param i64))
  ;; CHECK-BIN:      (tag $e-i64 (type $7) (param i64))
  (tag $e-i64 (param i64))
  ;; CHECK-TEXT:      (tag $e-i32-i64 (type $8) (param i32 i64))
  ;; CHECK-BIN:      (tag $e-i32-i64 (type $8) (param i32 i64))
  (tag $e-i32-i64 (param i32 i64))
  ;; CHECK-TEXT:      (tag $e-eqref (type $9) (param eqref))
  ;; CHECK-BIN:      (tag $e-eqref (type $9) (param eqref))
  (tag $e-eqref (param (ref null eq)))
  ;; CHECK-TEXT:      (tag $e-empty (type $0))
  ;; CHECK-BIN:      (tag $e-empty (type $0))
  (tag $e-empty)

  ;; CHECK-TEXT:      (func $foo (type $0)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $foo (type $0)
  ;; CHECK-BIN-NEXT: )
  (func $foo)

  ;; CHECK-TEXT:      (func $exnref-nullexnref-test (type $3) (result exnref)
  ;; CHECK-TEXT-NEXT:  (local $exn exnref)
  ;; CHECK-TEXT-NEXT:  (local $null-exn nullexnref)
  ;; CHECK-TEXT-NEXT:  (if (result exnref)
  ;; CHECK-TEXT-NEXT:   (i32.const 1)
  ;; CHECK-TEXT-NEXT:   (then
  ;; CHECK-TEXT-NEXT:    (if (result nullexnref)
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:     (then
  ;; CHECK-TEXT-NEXT:      (local.get $null-exn)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (else
  ;; CHECK-TEXT-NEXT:      (ref.null noexn)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (else
  ;; CHECK-TEXT-NEXT:    (local.get $exn)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $exnref-nullexnref-test (type $3) (result exnref)
  ;; CHECK-BIN-NEXT:  (local $exn exnref)
  ;; CHECK-BIN-NEXT:  (local $null-exn nullexnref)
  ;; CHECK-BIN-NEXT:  (if (result exnref)
  ;; CHECK-BIN-NEXT:   (i32.const 1)
  ;; CHECK-BIN-NEXT:   (then
  ;; CHECK-BIN-NEXT:    (if (result nullexnref)
  ;; CHECK-BIN-NEXT:     (i32.const 1)
  ;; CHECK-BIN-NEXT:     (then
  ;; CHECK-BIN-NEXT:      (local.get $null-exn)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (else
  ;; CHECK-BIN-NEXT:      (ref.null noexn)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (else
  ;; CHECK-BIN-NEXT:    (local.get $exn)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $exnref-nullexnref-test (result exnref) (local $exn exnref) (local $null-exn nullexnref)
    (if (result exnref)
      (i32.const 1)
      (then
        (if (result nullexnref)
          (i32.const 1)
          (then
            (local.get $null-exn)
          )
          (else
            (ref.null noexn)
          )
        )
      )
      (else
        (local.get $exn)
      )
    )
  )

  ;; CHECK-TEXT:      (func $catchless-try-table (type $0)
  ;; CHECK-TEXT-NEXT:  (try_table
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (try_table
  ;; CHECK-TEXT-NEXT:   (throw $e-empty)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $catchless-try-table (type $0)
  ;; CHECK-BIN-NEXT:  (try_table
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (try_table
  ;; CHECK-BIN-NEXT:   (throw $e-empty)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (unreachable)
  ;; CHECK-BIN-NEXT: )
  (func $catchless-try-table
    (try_table)
    (try_table
      (throw $e-empty)
    )
  )

  ;; CHECK-TEXT:      (func $simple-try-table-and-throw (type $4) (result i32)
  ;; CHECK-TEXT-NEXT:  (block $l-catch (result i32)
  ;; CHECK-TEXT-NEXT:   (try_table (catch $e-i32 $l-catch)
  ;; CHECK-TEXT-NEXT:    (throw $e-i32
  ;; CHECK-TEXT-NEXT:     (i32.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $simple-try-table-and-throw (type $4) (result i32)
  ;; CHECK-BIN-NEXT:  (block $block (result i32)
  ;; CHECK-BIN-NEXT:   (try_table (catch $e-i32 $block)
  ;; CHECK-BIN-NEXT:    (throw $e-i32
  ;; CHECK-BIN-NEXT:     (i32.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (unreachable)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $simple-try-table-and-throw (result i32)
    (block $l-catch (result i32)
      (try_table (catch $e-i32 $l-catch)
        (throw $e-i32 (i32.const 0))
      )
    )
  )

  ;; CHECK-TEXT:      (func $try-table-and-throw-ref (type $0)
  ;; CHECK-TEXT-NEXT:  (throw_ref
  ;; CHECK-TEXT-NEXT:   (block $l-catch-all-ref (result exnref)
  ;; CHECK-TEXT-NEXT:    (try_table (catch_all_ref $l-catch-all-ref)
  ;; CHECK-TEXT-NEXT:     (throw $e-i64
  ;; CHECK-TEXT-NEXT:      (i64.const 0)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $try-table-and-throw-ref (type $0)
  ;; CHECK-BIN-NEXT:  (throw_ref
  ;; CHECK-BIN-NEXT:   (block $block (result exnref)
  ;; CHECK-BIN-NEXT:    (try_table (catch_all_ref $block)
  ;; CHECK-BIN-NEXT:     (throw $e-i64
  ;; CHECK-BIN-NEXT:      (i64.const 0)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (unreachable)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $try-table-and-throw-ref
    (throw_ref
      (block $l-catch-all-ref (result exnref)
        (try_table (catch_all_ref $l-catch-all-ref)
          (throw $e-i64 (i64.const 0))
        )
      )
    )
  )

  ;; CHECK-TEXT:      (func $try-table-multivalue-tag (type $0)
  ;; CHECK-TEXT-NEXT:  (block $outer
  ;; CHECK-TEXT-NEXT:   (tuple.drop 3
  ;; CHECK-TEXT-NEXT:    (block $l-catch-ref (type $2) (result i32 i64 exnref)
  ;; CHECK-TEXT-NEXT:     (tuple.drop 2
  ;; CHECK-TEXT-NEXT:      (block $l-catch (type $1) (result i32 i64)
  ;; CHECK-TEXT-NEXT:       (try_table (catch $e-i32-i64 $l-catch) (catch_ref $e-i32-i64 $l-catch-ref)
  ;; CHECK-TEXT-NEXT:        (throw $e-i32-i64
  ;; CHECK-TEXT-NEXT:         (i32.const 0)
  ;; CHECK-TEXT-NEXT:         (i64.const 0)
  ;; CHECK-TEXT-NEXT:        )
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (br $outer)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $try-table-multivalue-tag (type $0)
  ;; CHECK-BIN-NEXT:  (local $scratch (tuple i32 i64))
  ;; CHECK-BIN-NEXT:  (local $scratch_1 i32)
  ;; CHECK-BIN-NEXT:  (local $scratch_2 (tuple i32 i64 exnref))
  ;; CHECK-BIN-NEXT:  (local $scratch_3 i64)
  ;; CHECK-BIN-NEXT:  (local $scratch_4 i32)
  ;; CHECK-BIN-NEXT:  (block $block2
  ;; CHECK-BIN-NEXT:   (drop
  ;; CHECK-BIN-NEXT:    (block (result i32)
  ;; CHECK-BIN-NEXT:     (local.set $scratch_4
  ;; CHECK-BIN-NEXT:      (tuple.extract 3 0
  ;; CHECK-BIN-NEXT:       (local.tee $scratch_2
  ;; CHECK-BIN-NEXT:        (block $block1 (type $2) (result i32 i64 exnref)
  ;; CHECK-BIN-NEXT:         (drop
  ;; CHECK-BIN-NEXT:          (block (result i32)
  ;; CHECK-BIN-NEXT:           (local.set $scratch_1
  ;; CHECK-BIN-NEXT:            (tuple.extract 2 0
  ;; CHECK-BIN-NEXT:             (local.tee $scratch
  ;; CHECK-BIN-NEXT:              (block $block (type $1) (result i32 i64)
  ;; CHECK-BIN-NEXT:               (try_table (catch $e-i32-i64 $block) (catch_ref $e-i32-i64 $block1)
  ;; CHECK-BIN-NEXT:                (throw $e-i32-i64
  ;; CHECK-BIN-NEXT:                 (i32.const 0)
  ;; CHECK-BIN-NEXT:                 (i64.const 0)
  ;; CHECK-BIN-NEXT:                )
  ;; CHECK-BIN-NEXT:               )
  ;; CHECK-BIN-NEXT:               (unreachable)
  ;; CHECK-BIN-NEXT:              )
  ;; CHECK-BIN-NEXT:             )
  ;; CHECK-BIN-NEXT:            )
  ;; CHECK-BIN-NEXT:           )
  ;; CHECK-BIN-NEXT:           (drop
  ;; CHECK-BIN-NEXT:            (tuple.extract 2 1
  ;; CHECK-BIN-NEXT:             (local.get $scratch)
  ;; CHECK-BIN-NEXT:            )
  ;; CHECK-BIN-NEXT:           )
  ;; CHECK-BIN-NEXT:           (local.get $scratch_1)
  ;; CHECK-BIN-NEXT:          )
  ;; CHECK-BIN-NEXT:         )
  ;; CHECK-BIN-NEXT:         (br $block2)
  ;; CHECK-BIN-NEXT:        )
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (drop
  ;; CHECK-BIN-NEXT:      (block (result i64)
  ;; CHECK-BIN-NEXT:       (local.set $scratch_3
  ;; CHECK-BIN-NEXT:        (tuple.extract 3 1
  ;; CHECK-BIN-NEXT:         (local.get $scratch_2)
  ;; CHECK-BIN-NEXT:        )
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:       (drop
  ;; CHECK-BIN-NEXT:        (tuple.extract 3 2
  ;; CHECK-BIN-NEXT:         (local.get $scratch_2)
  ;; CHECK-BIN-NEXT:        )
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:       (local.get $scratch_3)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (local.get $scratch_4)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $try-table-multivalue-tag
    (block $outer
      (tuple.drop 3
        (block $l-catch-ref (result i32 i64 exnref)
          (tuple.drop 2
            (block $l-catch (result i32 i64)
              (try_table (catch $e-i32-i64 $l-catch)
                         (catch_ref $e-i32-i64 $l-catch-ref)
                (throw $e-i32-i64 (i32.const 0) (i64.const 0))
              )
            )
          )
          (br $outer)
        )
      )
    )
  )

  ;; CHECK-TEXT:      (func $try-table-all-catch-clauses-empty-tag (type $0)
  ;; CHECK-TEXT-NEXT:  (block $outer
  ;; CHECK-TEXT-NEXT:   (block $l-catch
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (block $l-catch-ref (result exnref)
  ;; CHECK-TEXT-NEXT:      (block $l-catch-all
  ;; CHECK-TEXT-NEXT:       (throw_ref
  ;; CHECK-TEXT-NEXT:        (block $l-catch-all-ref (result exnref)
  ;; CHECK-TEXT-NEXT:         (try_table (catch $e-empty $l-catch) (catch_ref $e-empty $l-catch-ref) (catch_all $l-catch-all) (catch_all_ref $l-catch-all-ref)
  ;; CHECK-TEXT-NEXT:          (call $foo)
  ;; CHECK-TEXT-NEXT:          (call $foo)
  ;; CHECK-TEXT-NEXT:         )
  ;; CHECK-TEXT-NEXT:         (br $outer)
  ;; CHECK-TEXT-NEXT:        )
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:      (br $outer)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (br $outer)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $try-table-all-catch-clauses-empty-tag (type $0)
  ;; CHECK-BIN-NEXT:  (block $block4
  ;; CHECK-BIN-NEXT:   (block $block
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (block $block1 (result exnref)
  ;; CHECK-BIN-NEXT:      (block $block2
  ;; CHECK-BIN-NEXT:       (throw_ref
  ;; CHECK-BIN-NEXT:        (block $block3 (result exnref)
  ;; CHECK-BIN-NEXT:         (try_table (catch $e-empty $block) (catch_ref $e-empty $block1) (catch_all $block2) (catch_all_ref $block3)
  ;; CHECK-BIN-NEXT:          (call $foo)
  ;; CHECK-BIN-NEXT:          (call $foo)
  ;; CHECK-BIN-NEXT:         )
  ;; CHECK-BIN-NEXT:         (br $block4)
  ;; CHECK-BIN-NEXT:        )
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:      (br $block4)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (br $block4)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $try-table-all-catch-clauses-empty-tag
    ;; try_table with all kinds of catch clauses when using a tag with an empty
    ;; param type
    (block $outer
      (block $l-catch
        (drop
          (block $l-catch-ref (result exnref)
            (block $l-catch-all
              (throw_ref
                (block $l-catch-all-ref (result exnref)
                  (try_table (catch $e-empty $l-catch)
                             (catch_ref $e-empty $l-catch-ref)
                             (catch_all $l-catch-all)
                             (catch_all_ref $l-catch-all-ref)
                    (call $foo)
                    (call $foo)
                  )
                  (br $outer)
                )
              )
            )
            (br $outer)
          )
        )
        (br $outer)
      )
    )
  )

  ;; CHECK-TEXT:      (func $try-table-all-catch-clauses-i32-tag (type $0)
  ;; CHECK-TEXT-NEXT:  (block $outer
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (block $l-catch (result i32)
  ;; CHECK-TEXT-NEXT:     (tuple.drop 2
  ;; CHECK-TEXT-NEXT:      (block $l-catch-ref (type $5) (result i32 exnref)
  ;; CHECK-TEXT-NEXT:       (block $l-catch-all
  ;; CHECK-TEXT-NEXT:        (throw_ref
  ;; CHECK-TEXT-NEXT:         (block $l-catch-all-ref (result exnref)
  ;; CHECK-TEXT-NEXT:          (try_table (catch $e-i32 $l-catch) (catch_ref $e-i32 $l-catch-ref) (catch_all $l-catch-all) (catch_all_ref $l-catch-all-ref)
  ;; CHECK-TEXT-NEXT:           (call $foo)
  ;; CHECK-TEXT-NEXT:           (call $foo)
  ;; CHECK-TEXT-NEXT:          )
  ;; CHECK-TEXT-NEXT:          (br $outer)
  ;; CHECK-TEXT-NEXT:         )
  ;; CHECK-TEXT-NEXT:        )
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:       (br $outer)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (br $outer)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $try-table-all-catch-clauses-i32-tag (type $0)
  ;; CHECK-BIN-NEXT:  (local $scratch (tuple i32 exnref))
  ;; CHECK-BIN-NEXT:  (local $scratch_1 i32)
  ;; CHECK-BIN-NEXT:  (block $block4
  ;; CHECK-BIN-NEXT:   (drop
  ;; CHECK-BIN-NEXT:    (block $block (result i32)
  ;; CHECK-BIN-NEXT:     (drop
  ;; CHECK-BIN-NEXT:      (block (result i32)
  ;; CHECK-BIN-NEXT:       (local.set $scratch_1
  ;; CHECK-BIN-NEXT:        (tuple.extract 2 0
  ;; CHECK-BIN-NEXT:         (local.tee $scratch
  ;; CHECK-BIN-NEXT:          (block $block1 (type $5) (result i32 exnref)
  ;; CHECK-BIN-NEXT:           (block $block2
  ;; CHECK-BIN-NEXT:            (throw_ref
  ;; CHECK-BIN-NEXT:             (block $block3 (result exnref)
  ;; CHECK-BIN-NEXT:              (try_table (catch $e-i32 $block) (catch_ref $e-i32 $block1) (catch_all $block2) (catch_all_ref $block3)
  ;; CHECK-BIN-NEXT:               (call $foo)
  ;; CHECK-BIN-NEXT:               (call $foo)
  ;; CHECK-BIN-NEXT:              )
  ;; CHECK-BIN-NEXT:              (br $block4)
  ;; CHECK-BIN-NEXT:             )
  ;; CHECK-BIN-NEXT:            )
  ;; CHECK-BIN-NEXT:           )
  ;; CHECK-BIN-NEXT:           (br $block4)
  ;; CHECK-BIN-NEXT:          )
  ;; CHECK-BIN-NEXT:         )
  ;; CHECK-BIN-NEXT:        )
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:       (drop
  ;; CHECK-BIN-NEXT:        (tuple.extract 2 1
  ;; CHECK-BIN-NEXT:         (local.get $scratch)
  ;; CHECK-BIN-NEXT:        )
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:       (local.get $scratch_1)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (br $block4)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $try-table-all-catch-clauses-i32-tag
    ;; try_table with all kinds of catch clauses when using a tag with an i32
    ;; param type
    (block $outer
      (drop
        (block $l-catch (result i32)
          (tuple.drop 2
            (block $l-catch-ref (result i32 exnref)
              (block $l-catch-all
                (throw_ref
                  (block $l-catch-all-ref (result exnref)
                    (try_table (catch $e-i32 $l-catch)
                               (catch_ref $e-i32 $l-catch-ref)
                               (catch_all $l-catch-all)
                               (catch_all_ref $l-catch-all-ref)
                      (call $foo)
                      (call $foo)
                    )
                    (br $outer)
                  )
                )
              )
              (br $outer)
            )
          )
          (br $outer)
        )
      )
    )
  )

  ;; CHECK-TEXT:      (func $try-table-all-catch-clauses-multivalue-tag (type $0)
  ;; CHECK-TEXT-NEXT:  (block $outer
  ;; CHECK-TEXT-NEXT:   (tuple.drop 2
  ;; CHECK-TEXT-NEXT:    (block $l-catch (type $1) (result i32 i64)
  ;; CHECK-TEXT-NEXT:     (tuple.drop 3
  ;; CHECK-TEXT-NEXT:      (block $l-catch-ref (type $2) (result i32 i64 exnref)
  ;; CHECK-TEXT-NEXT:       (block $l-catch-all
  ;; CHECK-TEXT-NEXT:        (throw_ref
  ;; CHECK-TEXT-NEXT:         (block $l-catch-all-ref (result exnref)
  ;; CHECK-TEXT-NEXT:          (try_table (catch $e-i32-i64 $l-catch) (catch_ref $e-i32-i64 $l-catch-ref) (catch_all $l-catch-all) (catch_all_ref $l-catch-all-ref)
  ;; CHECK-TEXT-NEXT:           (call $foo)
  ;; CHECK-TEXT-NEXT:           (call $foo)
  ;; CHECK-TEXT-NEXT:          )
  ;; CHECK-TEXT-NEXT:          (br $outer)
  ;; CHECK-TEXT-NEXT:         )
  ;; CHECK-TEXT-NEXT:        )
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:       (br $outer)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (br $outer)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $try-table-all-catch-clauses-multivalue-tag (type $0)
  ;; CHECK-BIN-NEXT:  (local $scratch (tuple i32 i64 exnref))
  ;; CHECK-BIN-NEXT:  (local $scratch_1 i64)
  ;; CHECK-BIN-NEXT:  (local $scratch_2 i32)
  ;; CHECK-BIN-NEXT:  (local $scratch_3 (tuple i32 i64))
  ;; CHECK-BIN-NEXT:  (local $scratch_4 i32)
  ;; CHECK-BIN-NEXT:  (block $block4
  ;; CHECK-BIN-NEXT:   (drop
  ;; CHECK-BIN-NEXT:    (block (result i32)
  ;; CHECK-BIN-NEXT:     (local.set $scratch_4
  ;; CHECK-BIN-NEXT:      (tuple.extract 2 0
  ;; CHECK-BIN-NEXT:       (local.tee $scratch_3
  ;; CHECK-BIN-NEXT:        (block $block (type $1) (result i32 i64)
  ;; CHECK-BIN-NEXT:         (drop
  ;; CHECK-BIN-NEXT:          (block (result i32)
  ;; CHECK-BIN-NEXT:           (local.set $scratch_2
  ;; CHECK-BIN-NEXT:            (tuple.extract 3 0
  ;; CHECK-BIN-NEXT:             (local.tee $scratch
  ;; CHECK-BIN-NEXT:              (block $block1 (type $2) (result i32 i64 exnref)
  ;; CHECK-BIN-NEXT:               (block $block2
  ;; CHECK-BIN-NEXT:                (throw_ref
  ;; CHECK-BIN-NEXT:                 (block $block3 (result exnref)
  ;; CHECK-BIN-NEXT:                  (try_table (catch $e-i32-i64 $block) (catch_ref $e-i32-i64 $block1) (catch_all $block2) (catch_all_ref $block3)
  ;; CHECK-BIN-NEXT:                   (call $foo)
  ;; CHECK-BIN-NEXT:                   (call $foo)
  ;; CHECK-BIN-NEXT:                  )
  ;; CHECK-BIN-NEXT:                  (br $block4)
  ;; CHECK-BIN-NEXT:                 )
  ;; CHECK-BIN-NEXT:                )
  ;; CHECK-BIN-NEXT:               )
  ;; CHECK-BIN-NEXT:               (br $block4)
  ;; CHECK-BIN-NEXT:              )
  ;; CHECK-BIN-NEXT:             )
  ;; CHECK-BIN-NEXT:            )
  ;; CHECK-BIN-NEXT:           )
  ;; CHECK-BIN-NEXT:           (drop
  ;; CHECK-BIN-NEXT:            (block (result i64)
  ;; CHECK-BIN-NEXT:             (local.set $scratch_1
  ;; CHECK-BIN-NEXT:              (tuple.extract 3 1
  ;; CHECK-BIN-NEXT:               (local.get $scratch)
  ;; CHECK-BIN-NEXT:              )
  ;; CHECK-BIN-NEXT:             )
  ;; CHECK-BIN-NEXT:             (drop
  ;; CHECK-BIN-NEXT:              (tuple.extract 3 2
  ;; CHECK-BIN-NEXT:               (local.get $scratch)
  ;; CHECK-BIN-NEXT:              )
  ;; CHECK-BIN-NEXT:             )
  ;; CHECK-BIN-NEXT:             (local.get $scratch_1)
  ;; CHECK-BIN-NEXT:            )
  ;; CHECK-BIN-NEXT:           )
  ;; CHECK-BIN-NEXT:           (local.get $scratch_2)
  ;; CHECK-BIN-NEXT:          )
  ;; CHECK-BIN-NEXT:         )
  ;; CHECK-BIN-NEXT:         (br $block4)
  ;; CHECK-BIN-NEXT:        )
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (drop
  ;; CHECK-BIN-NEXT:      (tuple.extract 2 1
  ;; CHECK-BIN-NEXT:       (local.get $scratch_3)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (local.get $scratch_4)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $try-table-all-catch-clauses-multivalue-tag
    ;; try_table with all kinds of catch clauses when using a tag with a
    ;; multivalue param type
    (block $outer
      (tuple.drop 2
        (block $l-catch (result i32 i64)
          (tuple.drop 3
            (block $l-catch-ref (result i32 i64 exnref)
              (block $l-catch-all
                (throw_ref
                  (block $l-catch-all-ref (result exnref)
                    (try_table (catch $e-i32-i64 $l-catch)
                               (catch_ref $e-i32-i64 $l-catch-ref)
                               (catch_all $l-catch-all)
                               (catch_all_ref $l-catch-all-ref)
                      (call $foo)
                      (call $foo)
                    )
                    (br $outer)
                  )
                )
              )
              (br $outer)
            )
          )
          (br $outer)
        )
      )
    )
  )

  ;; CHECK-TEXT:      (func $try-table-with-label-and-br (type $4) (result i32)
  ;; CHECK-TEXT-NEXT:  (block $l-catch (result i32)
  ;; CHECK-TEXT-NEXT:   (block $l (result i32)
  ;; CHECK-TEXT-NEXT:    (try_table (result i32) (catch $e-i32 $l-catch)
  ;; CHECK-TEXT-NEXT:     (br $l
  ;; CHECK-TEXT-NEXT:      (i32.const 0)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $try-table-with-label-and-br (type $4) (result i32)
  ;; CHECK-BIN-NEXT:  (block $block (result i32)
  ;; CHECK-BIN-NEXT:   (block $block1 (result i32)
  ;; CHECK-BIN-NEXT:    (try_table (result i32) (catch $e-i32 $block)
  ;; CHECK-BIN-NEXT:     (br $block1
  ;; CHECK-BIN-NEXT:      (i32.const 0)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $try-table-with-label-and-br (result i32)
    (block $l-catch (result i32)
      (try_table $l (result i32) (catch $e-i32 $l-catch)
        (br $l (i32.const 0))
      )
    )
  )

  ;; CHECK-TEXT:      (func $nested-try-table (type $3) (result exnref)
  ;; CHECK-TEXT-NEXT:  (block $l-catch-outer (result exnref)
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (block $l-catch-inner (result i32)
  ;; CHECK-TEXT-NEXT:     (try_table (catch_all_ref $l-catch-outer)
  ;; CHECK-TEXT-NEXT:      (try_table (catch $e-i32 $l-catch-inner)
  ;; CHECK-TEXT-NEXT:       (if
  ;; CHECK-TEXT-NEXT:        (i32.const 0)
  ;; CHECK-TEXT-NEXT:        (then
  ;; CHECK-TEXT-NEXT:         (throw $e-i32
  ;; CHECK-TEXT-NEXT:          (i32.const 3)
  ;; CHECK-TEXT-NEXT:         )
  ;; CHECK-TEXT-NEXT:        )
  ;; CHECK-TEXT-NEXT:        (else
  ;; CHECK-TEXT-NEXT:         (throw $e-eqref
  ;; CHECK-TEXT-NEXT:          (ref.null none)
  ;; CHECK-TEXT-NEXT:         )
  ;; CHECK-TEXT-NEXT:        )
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (ref.null noexn)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $nested-try-table (type $3) (result exnref)
  ;; CHECK-BIN-NEXT:  (block $block (result exnref)
  ;; CHECK-BIN-NEXT:   (drop
  ;; CHECK-BIN-NEXT:    (block $block1 (result i32)
  ;; CHECK-BIN-NEXT:     (try_table (catch_all_ref $block)
  ;; CHECK-BIN-NEXT:      (try_table (catch $e-i32 $block1)
  ;; CHECK-BIN-NEXT:       (if
  ;; CHECK-BIN-NEXT:        (i32.const 0)
  ;; CHECK-BIN-NEXT:        (then
  ;; CHECK-BIN-NEXT:         (throw $e-i32
  ;; CHECK-BIN-NEXT:          (i32.const 3)
  ;; CHECK-BIN-NEXT:         )
  ;; CHECK-BIN-NEXT:        )
  ;; CHECK-BIN-NEXT:        (else
  ;; CHECK-BIN-NEXT:         (throw $e-eqref
  ;; CHECK-BIN-NEXT:          (ref.null none)
  ;; CHECK-BIN-NEXT:         )
  ;; CHECK-BIN-NEXT:        )
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:       (unreachable)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:      (unreachable)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (unreachable)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (ref.null noexn)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $nested-try-table (result exnref)
    (block $l-catch-outer (result exnref)
      (drop
        (block $l-catch-inner (result i32)
          (try_table (catch_all_ref $l-catch-outer)
            (try_table (catch $e-i32 $l-catch-inner)
              (if
                (i32.const 0)
                (then
                  (throw $e-i32 (i32.const 3))
                )
                (else
                  (throw $e-eqref (ref.null eq))
                )
              )
            )
          )
        )
      )
      (ref.null noexn)
    )
  )
)
;; CHECK-BIN-NODEBUG:      (type $0 (func))

;; CHECK-BIN-NODEBUG:      (type $1 (func (result i32 i64)))

;; CHECK-BIN-NODEBUG:      (type $2 (func (result i32 i64 exnref)))

;; CHECK-BIN-NODEBUG:      (type $3 (func (result exnref)))

;; CHECK-BIN-NODEBUG:      (type $4 (func (result i32)))

;; CHECK-BIN-NODEBUG:      (type $5 (func (result i32 exnref)))

;; CHECK-BIN-NODEBUG:      (type $6 (func (param i32)))

;; CHECK-BIN-NODEBUG:      (type $7 (func (param i64)))

;; CHECK-BIN-NODEBUG:      (type $8 (func (param i32 i64)))

;; CHECK-BIN-NODEBUG:      (type $9 (func (param eqref)))

;; CHECK-BIN-NODEBUG:      (tag $tag$0 (type $6) (param i32))

;; CHECK-BIN-NODEBUG:      (tag $tag$1 (type $7) (param i64))

;; CHECK-BIN-NODEBUG:      (tag $tag$2 (type $8) (param i32 i64))

;; CHECK-BIN-NODEBUG:      (tag $tag$3 (type $9) (param eqref))

;; CHECK-BIN-NODEBUG:      (tag $tag$4 (type $0))

;; CHECK-BIN-NODEBUG:      (func $0 (type $0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $1 (type $3) (result exnref)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 exnref)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 nullexnref)
;; CHECK-BIN-NODEBUG-NEXT:  (if (result exnref)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:   (then
;; CHECK-BIN-NODEBUG-NEXT:    (if (result nullexnref)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:     (then
;; CHECK-BIN-NODEBUG-NEXT:      (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (else
;; CHECK-BIN-NODEBUG-NEXT:      (ref.null noexn)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (else
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $2 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try_table
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (try_table
;; CHECK-BIN-NODEBUG-NEXT:   (throw $tag$4)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $3 (type $4) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block (result i32)
;; CHECK-BIN-NODEBUG-NEXT:   (try_table (catch $tag$0 $block)
;; CHECK-BIN-NODEBUG-NEXT:    (throw $tag$0
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $4 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (throw_ref
;; CHECK-BIN-NODEBUG-NEXT:   (block $block (result exnref)
;; CHECK-BIN-NODEBUG-NEXT:    (try_table (catch_all_ref $block)
;; CHECK-BIN-NODEBUG-NEXT:     (throw $tag$1
;; CHECK-BIN-NODEBUG-NEXT:      (i64.const 0)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $5 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch (tuple i32 i64))
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch_1 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch_2 (tuple i32 i64 exnref))
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch_3 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch_4 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block2
;; CHECK-BIN-NODEBUG-NEXT:   (drop
;; CHECK-BIN-NODEBUG-NEXT:    (block (result i32)
;; CHECK-BIN-NODEBUG-NEXT:     (local.set $scratch_4
;; CHECK-BIN-NODEBUG-NEXT:      (tuple.extract 3 0
;; CHECK-BIN-NODEBUG-NEXT:       (local.tee $scratch_2
;; CHECK-BIN-NODEBUG-NEXT:        (block $block1 (type $2) (result i32 i64 exnref)
;; CHECK-BIN-NODEBUG-NEXT:         (drop
;; CHECK-BIN-NODEBUG-NEXT:          (block (result i32)
;; CHECK-BIN-NODEBUG-NEXT:           (local.set $scratch_1
;; CHECK-BIN-NODEBUG-NEXT:            (tuple.extract 2 0
;; CHECK-BIN-NODEBUG-NEXT:             (local.tee $scratch
;; CHECK-BIN-NODEBUG-NEXT:              (block $block (type $1) (result i32 i64)
;; CHECK-BIN-NODEBUG-NEXT:               (try_table (catch $tag$2 $block) (catch_ref $tag$2 $block1)
;; CHECK-BIN-NODEBUG-NEXT:                (throw $tag$2
;; CHECK-BIN-NODEBUG-NEXT:                 (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:                 (i64.const 0)
;; CHECK-BIN-NODEBUG-NEXT:                )
;; CHECK-BIN-NODEBUG-NEXT:               )
;; CHECK-BIN-NODEBUG-NEXT:               (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:              )
;; CHECK-BIN-NODEBUG-NEXT:             )
;; CHECK-BIN-NODEBUG-NEXT:            )
;; CHECK-BIN-NODEBUG-NEXT:           )
;; CHECK-BIN-NODEBUG-NEXT:           (drop
;; CHECK-BIN-NODEBUG-NEXT:            (tuple.extract 2 1
;; CHECK-BIN-NODEBUG-NEXT:             (local.get $scratch)
;; CHECK-BIN-NODEBUG-NEXT:            )
;; CHECK-BIN-NODEBUG-NEXT:           )
;; CHECK-BIN-NODEBUG-NEXT:           (local.get $scratch_1)
;; CHECK-BIN-NODEBUG-NEXT:          )
;; CHECK-BIN-NODEBUG-NEXT:         )
;; CHECK-BIN-NODEBUG-NEXT:         (br $block2)
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (drop
;; CHECK-BIN-NODEBUG-NEXT:      (block (result i64)
;; CHECK-BIN-NODEBUG-NEXT:       (local.set $scratch_3
;; CHECK-BIN-NODEBUG-NEXT:        (tuple.extract 3 1
;; CHECK-BIN-NODEBUG-NEXT:         (local.get $scratch_2)
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:       (drop
;; CHECK-BIN-NODEBUG-NEXT:        (tuple.extract 3 2
;; CHECK-BIN-NODEBUG-NEXT:         (local.get $scratch_2)
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:       (local.get $scratch_3)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $scratch_4)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $6 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block4
;; CHECK-BIN-NODEBUG-NEXT:   (block $block
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (block $block1 (result exnref)
;; CHECK-BIN-NODEBUG-NEXT:      (block $block2
;; CHECK-BIN-NODEBUG-NEXT:       (throw_ref
;; CHECK-BIN-NODEBUG-NEXT:        (block $block3 (result exnref)
;; CHECK-BIN-NODEBUG-NEXT:         (try_table (catch $tag$4 $block) (catch_ref $tag$4 $block1) (catch_all $block2) (catch_all_ref $block3)
;; CHECK-BIN-NODEBUG-NEXT:          (call $0)
;; CHECK-BIN-NODEBUG-NEXT:          (call $0)
;; CHECK-BIN-NODEBUG-NEXT:         )
;; CHECK-BIN-NODEBUG-NEXT:         (br $block4)
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:      (br $block4)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (br $block4)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $7 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch (tuple i32 exnref))
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch_1 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block4
;; CHECK-BIN-NODEBUG-NEXT:   (drop
;; CHECK-BIN-NODEBUG-NEXT:    (block $block (result i32)
;; CHECK-BIN-NODEBUG-NEXT:     (drop
;; CHECK-BIN-NODEBUG-NEXT:      (block (result i32)
;; CHECK-BIN-NODEBUG-NEXT:       (local.set $scratch_1
;; CHECK-BIN-NODEBUG-NEXT:        (tuple.extract 2 0
;; CHECK-BIN-NODEBUG-NEXT:         (local.tee $scratch
;; CHECK-BIN-NODEBUG-NEXT:          (block $block1 (type $5) (result i32 exnref)
;; CHECK-BIN-NODEBUG-NEXT:           (block $block2
;; CHECK-BIN-NODEBUG-NEXT:            (throw_ref
;; CHECK-BIN-NODEBUG-NEXT:             (block $block3 (result exnref)
;; CHECK-BIN-NODEBUG-NEXT:              (try_table (catch $tag$0 $block) (catch_ref $tag$0 $block1) (catch_all $block2) (catch_all_ref $block3)
;; CHECK-BIN-NODEBUG-NEXT:               (call $0)
;; CHECK-BIN-NODEBUG-NEXT:               (call $0)
;; CHECK-BIN-NODEBUG-NEXT:              )
;; CHECK-BIN-NODEBUG-NEXT:              (br $block4)
;; CHECK-BIN-NODEBUG-NEXT:             )
;; CHECK-BIN-NODEBUG-NEXT:            )
;; CHECK-BIN-NODEBUG-NEXT:           )
;; CHECK-BIN-NODEBUG-NEXT:           (br $block4)
;; CHECK-BIN-NODEBUG-NEXT:          )
;; CHECK-BIN-NODEBUG-NEXT:         )
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:       (drop
;; CHECK-BIN-NODEBUG-NEXT:        (tuple.extract 2 1
;; CHECK-BIN-NODEBUG-NEXT:         (local.get $scratch)
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:       (local.get $scratch_1)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (br $block4)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $8 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch (tuple i32 i64 exnref))
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch_1 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch_2 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch_3 (tuple i32 i64))
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch_4 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block4
;; CHECK-BIN-NODEBUG-NEXT:   (drop
;; CHECK-BIN-NODEBUG-NEXT:    (block (result i32)
;; CHECK-BIN-NODEBUG-NEXT:     (local.set $scratch_4
;; CHECK-BIN-NODEBUG-NEXT:      (tuple.extract 2 0
;; CHECK-BIN-NODEBUG-NEXT:       (local.tee $scratch_3
;; CHECK-BIN-NODEBUG-NEXT:        (block $block (type $1) (result i32 i64)
;; CHECK-BIN-NODEBUG-NEXT:         (drop
;; CHECK-BIN-NODEBUG-NEXT:          (block (result i32)
;; CHECK-BIN-NODEBUG-NEXT:           (local.set $scratch_2
;; CHECK-BIN-NODEBUG-NEXT:            (tuple.extract 3 0
;; CHECK-BIN-NODEBUG-NEXT:             (local.tee $scratch
;; CHECK-BIN-NODEBUG-NEXT:              (block $block1 (type $2) (result i32 i64 exnref)
;; CHECK-BIN-NODEBUG-NEXT:               (block $block2
;; CHECK-BIN-NODEBUG-NEXT:                (throw_ref
;; CHECK-BIN-NODEBUG-NEXT:                 (block $block3 (result exnref)
;; CHECK-BIN-NODEBUG-NEXT:                  (try_table (catch $tag$2 $block) (catch_ref $tag$2 $block1) (catch_all $block2) (catch_all_ref $block3)
;; CHECK-BIN-NODEBUG-NEXT:                   (call $0)
;; CHECK-BIN-NODEBUG-NEXT:                   (call $0)
;; CHECK-BIN-NODEBUG-NEXT:                  )
;; CHECK-BIN-NODEBUG-NEXT:                  (br $block4)
;; CHECK-BIN-NODEBUG-NEXT:                 )
;; CHECK-BIN-NODEBUG-NEXT:                )
;; CHECK-BIN-NODEBUG-NEXT:               )
;; CHECK-BIN-NODEBUG-NEXT:               (br $block4)
;; CHECK-BIN-NODEBUG-NEXT:              )
;; CHECK-BIN-NODEBUG-NEXT:             )
;; CHECK-BIN-NODEBUG-NEXT:            )
;; CHECK-BIN-NODEBUG-NEXT:           )
;; CHECK-BIN-NODEBUG-NEXT:           (drop
;; CHECK-BIN-NODEBUG-NEXT:            (block (result i64)
;; CHECK-BIN-NODEBUG-NEXT:             (local.set $scratch_1
;; CHECK-BIN-NODEBUG-NEXT:              (tuple.extract 3 1
;; CHECK-BIN-NODEBUG-NEXT:               (local.get $scratch)
;; CHECK-BIN-NODEBUG-NEXT:              )
;; CHECK-BIN-NODEBUG-NEXT:             )
;; CHECK-BIN-NODEBUG-NEXT:             (drop
;; CHECK-BIN-NODEBUG-NEXT:              (tuple.extract 3 2
;; CHECK-BIN-NODEBUG-NEXT:               (local.get $scratch)
;; CHECK-BIN-NODEBUG-NEXT:              )
;; CHECK-BIN-NODEBUG-NEXT:             )
;; CHECK-BIN-NODEBUG-NEXT:             (local.get $scratch_1)
;; CHECK-BIN-NODEBUG-NEXT:            )
;; CHECK-BIN-NODEBUG-NEXT:           )
;; CHECK-BIN-NODEBUG-NEXT:           (local.get $scratch_2)
;; CHECK-BIN-NODEBUG-NEXT:          )
;; CHECK-BIN-NODEBUG-NEXT:         )
;; CHECK-BIN-NODEBUG-NEXT:         (br $block4)
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (drop
;; CHECK-BIN-NODEBUG-NEXT:      (tuple.extract 2 1
;; CHECK-BIN-NODEBUG-NEXT:       (local.get $scratch_3)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $scratch_4)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $9 (type $4) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block (result i32)
;; CHECK-BIN-NODEBUG-NEXT:   (block $block1 (result i32)
;; CHECK-BIN-NODEBUG-NEXT:    (try_table (result i32) (catch $tag$0 $block)
;; CHECK-BIN-NODEBUG-NEXT:     (br $block1
;; CHECK-BIN-NODEBUG-NEXT:      (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $10 (type $3) (result exnref)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block (result exnref)
;; CHECK-BIN-NODEBUG-NEXT:   (drop
;; CHECK-BIN-NODEBUG-NEXT:    (block $block1 (result i32)
;; CHECK-BIN-NODEBUG-NEXT:     (try_table (catch_all_ref $block)
;; CHECK-BIN-NODEBUG-NEXT:      (try_table (catch $tag$0 $block1)
;; CHECK-BIN-NODEBUG-NEXT:       (if
;; CHECK-BIN-NODEBUG-NEXT:        (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:        (then
;; CHECK-BIN-NODEBUG-NEXT:         (throw $tag$0
;; CHECK-BIN-NODEBUG-NEXT:          (i32.const 3)
;; CHECK-BIN-NODEBUG-NEXT:         )
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:        (else
;; CHECK-BIN-NODEBUG-NEXT:         (throw $tag$3
;; CHECK-BIN-NODEBUG-NEXT:          (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:         )
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:       (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:      (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null noexn)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )
