;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wast -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wast
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wast | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wast | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
  ;; CHECK-TEXT:      (type $0 (func (result anyref)))

  ;; CHECK-TEXT:      (type $sig_anyref (func (param anyref)))

  ;; CHECK-TEXT:      (type $sig_funcref (func (param funcref)))

  ;; CHECK-TEXT:      (type $3 (func (result funcref)))

  ;; CHECK-TEXT:      (type $sig_eqref (func (param eqref)))
  ;; CHECK-BIN:      (type $0 (func (result anyref)))

  ;; CHECK-BIN:      (type $sig_anyref (func (param anyref)))

  ;; CHECK-BIN:      (type $sig_funcref (func (param funcref)))

  ;; CHECK-BIN:      (type $3 (func))

  ;; CHECK-BIN:      (type $4 (func (result funcref)))

  ;; CHECK-BIN:      (type $sig_eqref (func (param eqref)))
  (type $sig_eqref (func (param eqref)))
  (type $sig_funcref (func (param funcref)))
  (type $sig_anyref (func (param anyref)))

  ;; CHECK-TEXT:      (type $5 (func))

  ;; CHECK-TEXT:      (type $6 (func (result eqref)))

  ;; CHECK-TEXT:      (type $7 (func (param i32)))

  ;; CHECK-TEXT:      (type $8 (func (param eqref) (result funcref)))

  ;; CHECK-TEXT:      (import "env" "import_global" (global $import_global eqref))

  ;; CHECK-TEXT:      (import "env" "import_func" (func $import_func (type $8) (param eqref) (result funcref)))
  ;; CHECK-BIN:      (type $6 (func (result eqref)))

  ;; CHECK-BIN:      (type $7 (func (param i32)))

  ;; CHECK-BIN:      (type $8 (func (param eqref) (result funcref)))

  ;; CHECK-BIN:      (import "env" "import_global" (global $import_global eqref))

  ;; CHECK-BIN:      (import "env" "import_func" (func $import_func (type $8) (param eqref) (result funcref)))
  (import "env" "import_func" (func $import_func (param eqref) (result funcref)))
  (import "env" "import_global" (global $import_global eqref))

  ;; CHECK-TEXT:      (global $global_eqref (mut eqref) (ref.null none))

  ;; CHECK-TEXT:      (global $global_funcref (mut funcref) (ref.null nofunc))

  ;; CHECK-TEXT:      (global $global_funcref_func (mut funcref) (ref.func $foo))

  ;; CHECK-TEXT:      (global $global_anyref (mut anyref) (ref.null none))

  ;; CHECK-TEXT:      (global $global_anyref2 (mut anyref) (ref.null none))

  ;; CHECK-TEXT:      (table $0 3 3 funcref)

  ;; CHECK-TEXT:      (elem $implicit-elem (i32.const 0) $take_eqref $take_funcref $take_anyref)

  ;; CHECK-TEXT:      (elem declare func $foo $ref-taken-but-not-in-table)

  ;; CHECK-TEXT:      (tag $e-i32 (param i32))

  ;; CHECK-TEXT:      (export "export_func" (func $import_func))

  ;; CHECK-TEXT:      (export "export_global" (global $import_global))

  ;; CHECK-TEXT:      (func $take_eqref (type $sig_eqref) (param $0 eqref)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (global $global_eqref (mut eqref) (ref.null none))

  ;; CHECK-BIN:      (global $global_funcref (mut funcref) (ref.null nofunc))

  ;; CHECK-BIN:      (global $global_funcref_func (mut funcref) (ref.func $foo))

  ;; CHECK-BIN:      (global $global_anyref (mut anyref) (ref.null none))

  ;; CHECK-BIN:      (global $global_anyref2 (mut anyref) (ref.null none))

  ;; CHECK-BIN:      (table $0 3 3 funcref)

  ;; CHECK-BIN:      (elem $0 (i32.const 0) $take_eqref $take_funcref $take_anyref)

  ;; CHECK-BIN:      (elem declare func $foo $ref-taken-but-not-in-table)

  ;; CHECK-BIN:      (tag $e-i32 (param i32))

  ;; CHECK-BIN:      (export "export_func" (func $import_func))

  ;; CHECK-BIN:      (export "export_global" (global $import_global))

  ;; CHECK-BIN:      (func $take_eqref (type $sig_eqref) (param $0 eqref)
  ;; CHECK-BIN-NEXT: )
  (func $take_eqref (param eqref))

  ;; CHECK-TEXT:      (func $take_funcref (type $sig_funcref) (param $0 funcref)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $take_funcref (type $sig_funcref) (param $0 funcref)
  ;; CHECK-BIN-NEXT: )
  (func $take_funcref (param funcref))

  ;; CHECK-TEXT:      (func $take_anyref (type $sig_anyref) (param $0 anyref)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $take_anyref (type $sig_anyref) (param $0 anyref)
  ;; CHECK-BIN-NEXT: )
  (func $take_anyref (param anyref))

  ;; CHECK-TEXT:      (func $foo (type $5)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $foo (type $3)
  ;; CHECK-BIN-NEXT: )
  (func $foo)

  (table funcref (elem $take_eqref $take_funcref $take_anyref))
  ;; CHECK-BIN-NODEBUG:      (type $0 (func (result anyref)))

  ;; CHECK-BIN-NODEBUG:      (type $1 (func (param anyref)))

  ;; CHECK-BIN-NODEBUG:      (type $2 (func (param funcref)))

  ;; CHECK-BIN-NODEBUG:      (type $3 (func))

  ;; CHECK-BIN-NODEBUG:      (type $4 (func (result funcref)))

  ;; CHECK-BIN-NODEBUG:      (type $5 (func (param eqref)))

  ;; CHECK-BIN-NODEBUG:      (type $6 (func (result eqref)))

  ;; CHECK-BIN-NODEBUG:      (type $7 (func (param i32)))

  ;; CHECK-BIN-NODEBUG:      (type $8 (func (param eqref) (result funcref)))

  ;; CHECK-BIN-NODEBUG:      (import "env" "import_global" (global $gimport$0 eqref))

  ;; CHECK-BIN-NODEBUG:      (import "env" "import_func" (func $fimport$0 (type $8) (param eqref) (result funcref)))

  ;; CHECK-BIN-NODEBUG:      (global $global$0 (mut eqref) (ref.null none))

  ;; CHECK-BIN-NODEBUG:      (global $global$1 (mut funcref) (ref.null nofunc))

  ;; CHECK-BIN-NODEBUG:      (global $global$2 (mut funcref) (ref.func $3))

  ;; CHECK-BIN-NODEBUG:      (global $global$3 (mut anyref) (ref.null none))

  ;; CHECK-BIN-NODEBUG:      (global $global$4 (mut anyref) (ref.null none))

  ;; CHECK-BIN-NODEBUG:      (table $0 3 3 funcref)

  ;; CHECK-BIN-NODEBUG:      (elem $0 (i32.const 0) $0 $1 $2)

  ;; CHECK-BIN-NODEBUG:      (elem declare func $23 $3)
  (elem declare func $ref-taken-but-not-in-table)

  (export "export_func" (func $import_func))
  (export "export_global" (global $import_global))

  ;; Test global initializer expressions
  (global $global_eqref (mut eqref) (ref.null eq))
  (global $global_funcref (mut funcref) (ref.null func))
  (global $global_funcref_func (mut funcref) (ref.func $foo))
  (global $global_anyref (mut anyref) (ref.null any))

  ;; Test subtype relationship in global initializer expressions
  (global $global_anyref2 (mut anyref) (ref.null eq))

  (tag $e-i32 (param i32))

  ;; CHECK-TEXT:      (func $test (type $5)
  ;; CHECK-TEXT-NEXT:  (local $local_eqref eqref)
  ;; CHECK-TEXT-NEXT:  (local $local_funcref funcref)
  ;; CHECK-TEXT-NEXT:  (local $local_anyref anyref)
  ;; CHECK-TEXT-NEXT:  (local.set $local_eqref
  ;; CHECK-TEXT-NEXT:   (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (local.set $local_eqref
  ;; CHECK-TEXT-NEXT:   (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (local.set $local_eqref
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (local.set $local_funcref
  ;; CHECK-TEXT-NEXT:   (local.get $local_funcref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (local.set $local_funcref
  ;; CHECK-TEXT-NEXT:   (global.get $global_funcref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (local.set $local_funcref
  ;; CHECK-TEXT-NEXT:   (ref.null nofunc)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (local.set $local_funcref
  ;; CHECK-TEXT-NEXT:   (ref.func $foo)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (local.set $local_anyref
  ;; CHECK-TEXT-NEXT:   (local.get $local_anyref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (local.set $local_anyref
  ;; CHECK-TEXT-NEXT:   (global.get $global_anyref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (local.set $local_anyref
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (local.set $local_anyref
  ;; CHECK-TEXT-NEXT:   (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (local.set $local_anyref
  ;; CHECK-TEXT-NEXT:   (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (local.set $local_anyref
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (global.set $global_eqref
  ;; CHECK-TEXT-NEXT:   (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (global.set $global_eqref
  ;; CHECK-TEXT-NEXT:   (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (global.set $global_eqref
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (global.set $global_funcref
  ;; CHECK-TEXT-NEXT:   (global.get $global_funcref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (global.set $global_funcref
  ;; CHECK-TEXT-NEXT:   (local.get $local_funcref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (global.set $global_funcref
  ;; CHECK-TEXT-NEXT:   (ref.null nofunc)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (global.set $global_funcref
  ;; CHECK-TEXT-NEXT:   (ref.func $foo)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (global.set $global_anyref
  ;; CHECK-TEXT-NEXT:   (global.get $global_anyref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (global.set $global_anyref
  ;; CHECK-TEXT-NEXT:   (local.get $local_anyref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (global.set $global_anyref
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (global.set $global_anyref
  ;; CHECK-TEXT-NEXT:   (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (global.set $global_anyref
  ;; CHECK-TEXT-NEXT:   (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (global.set $global_anyref
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call $take_eqref
  ;; CHECK-TEXT-NEXT:   (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call $take_eqref
  ;; CHECK-TEXT-NEXT:   (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call $take_eqref
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call $take_funcref
  ;; CHECK-TEXT-NEXT:   (local.get $local_funcref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call $take_funcref
  ;; CHECK-TEXT-NEXT:   (global.get $global_funcref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call $take_funcref
  ;; CHECK-TEXT-NEXT:   (ref.null nofunc)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call $take_funcref
  ;; CHECK-TEXT-NEXT:   (ref.func $foo)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call $take_anyref
  ;; CHECK-TEXT-NEXT:   (local.get $local_anyref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call $take_anyref
  ;; CHECK-TEXT-NEXT:   (global.get $global_anyref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call $take_anyref
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call $take_anyref
  ;; CHECK-TEXT-NEXT:   (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call $take_anyref
  ;; CHECK-TEXT-NEXT:   (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call $take_anyref
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call_indirect $0 (type $sig_eqref)
  ;; CHECK-TEXT-NEXT:   (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:   (i32.const 0)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call_indirect $0 (type $sig_eqref)
  ;; CHECK-TEXT-NEXT:   (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT:   (i32.const 0)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call_indirect $0 (type $sig_eqref)
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:   (i32.const 0)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call_indirect $0 (type $sig_funcref)
  ;; CHECK-TEXT-NEXT:   (local.get $local_funcref)
  ;; CHECK-TEXT-NEXT:   (i32.const 1)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call_indirect $0 (type $sig_funcref)
  ;; CHECK-TEXT-NEXT:   (global.get $global_funcref)
  ;; CHECK-TEXT-NEXT:   (i32.const 1)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call_indirect $0 (type $sig_funcref)
  ;; CHECK-TEXT-NEXT:   (ref.null nofunc)
  ;; CHECK-TEXT-NEXT:   (i32.const 1)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call_indirect $0 (type $sig_funcref)
  ;; CHECK-TEXT-NEXT:   (ref.func $foo)
  ;; CHECK-TEXT-NEXT:   (i32.const 1)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call_indirect $0 (type $sig_anyref)
  ;; CHECK-TEXT-NEXT:   (local.get $local_anyref)
  ;; CHECK-TEXT-NEXT:   (i32.const 3)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call_indirect $0 (type $sig_anyref)
  ;; CHECK-TEXT-NEXT:   (global.get $global_anyref)
  ;; CHECK-TEXT-NEXT:   (i32.const 3)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call_indirect $0 (type $sig_anyref)
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:   (i32.const 3)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call_indirect $0 (type $sig_anyref)
  ;; CHECK-TEXT-NEXT:   (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:   (i32.const 3)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call_indirect $0 (type $sig_anyref)
  ;; CHECK-TEXT-NEXT:   (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT:   (i32.const 3)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call_indirect $0 (type $sig_anyref)
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:   (i32.const 3)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $block (result eqref)
  ;; CHECK-TEXT-NEXT:    (br_if $block
  ;; CHECK-TEXT-NEXT:     (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $block0 (result eqref)
  ;; CHECK-TEXT-NEXT:    (br_if $block0
  ;; CHECK-TEXT-NEXT:     (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $block1 (result eqref)
  ;; CHECK-TEXT-NEXT:    (br_if $block1
  ;; CHECK-TEXT-NEXT:     (ref.null none)
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $block2 (result funcref)
  ;; CHECK-TEXT-NEXT:    (br_if $block2
  ;; CHECK-TEXT-NEXT:     (local.get $local_funcref)
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $block3 (result funcref)
  ;; CHECK-TEXT-NEXT:    (br_if $block3
  ;; CHECK-TEXT-NEXT:     (global.get $global_funcref)
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $block4 (result funcref)
  ;; CHECK-TEXT-NEXT:    (br_if $block4
  ;; CHECK-TEXT-NEXT:     (ref.null nofunc)
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $block5 (result funcref)
  ;; CHECK-TEXT-NEXT:    (br_if $block5
  ;; CHECK-TEXT-NEXT:     (ref.func $foo)
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $block6 (result anyref)
  ;; CHECK-TEXT-NEXT:    (br_if $block6
  ;; CHECK-TEXT-NEXT:     (local.get $local_anyref)
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $block7 (result anyref)
  ;; CHECK-TEXT-NEXT:    (br_if $block7
  ;; CHECK-TEXT-NEXT:     (global.get $global_anyref)
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $block8 (result anyref)
  ;; CHECK-TEXT-NEXT:    (br_if $block8
  ;; CHECK-TEXT-NEXT:     (ref.null none)
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $block9 (result anyref)
  ;; CHECK-TEXT-NEXT:    (br_if $block9
  ;; CHECK-TEXT-NEXT:     (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $block10 (result anyref)
  ;; CHECK-TEXT-NEXT:    (br_if $block10
  ;; CHECK-TEXT-NEXT:     (ref.null none)
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (loop (result eqref)
  ;; CHECK-TEXT-NEXT:    (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (loop (result eqref)
  ;; CHECK-TEXT-NEXT:    (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (loop (result eqref)
  ;; CHECK-TEXT-NEXT:    (ref.null none)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (loop (result funcref)
  ;; CHECK-TEXT-NEXT:    (local.get $local_funcref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (loop (result funcref)
  ;; CHECK-TEXT-NEXT:    (global.get $global_funcref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (loop (result funcref)
  ;; CHECK-TEXT-NEXT:    (ref.null nofunc)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (loop (result funcref)
  ;; CHECK-TEXT-NEXT:    (ref.func $foo)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (loop (result anyref)
  ;; CHECK-TEXT-NEXT:    (local.get $local_anyref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (loop (result anyref)
  ;; CHECK-TEXT-NEXT:    (global.get $global_anyref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (loop (result anyref)
  ;; CHECK-TEXT-NEXT:    (ref.null none)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (loop (result anyref)
  ;; CHECK-TEXT-NEXT:    (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (loop (result anyref)
  ;; CHECK-TEXT-NEXT:    (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (loop (result anyref)
  ;; CHECK-TEXT-NEXT:    (ref.null none)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (if (result eqref)
  ;; CHECK-TEXT-NEXT:    (i32.const 1)
  ;; CHECK-TEXT-NEXT:    (then
  ;; CHECK-TEXT-NEXT:     (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (else
  ;; CHECK-TEXT-NEXT:     (ref.null none)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (if (result funcref)
  ;; CHECK-TEXT-NEXT:    (i32.const 1)
  ;; CHECK-TEXT-NEXT:    (then
  ;; CHECK-TEXT-NEXT:     (local.get $local_funcref)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (else
  ;; CHECK-TEXT-NEXT:     (ref.null nofunc)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (if (result anyref)
  ;; CHECK-TEXT-NEXT:    (i32.const 1)
  ;; CHECK-TEXT-NEXT:    (then
  ;; CHECK-TEXT-NEXT:     (local.get $local_anyref)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (else
  ;; CHECK-TEXT-NEXT:     (ref.null none)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (if (result anyref)
  ;; CHECK-TEXT-NEXT:    (i32.const 1)
  ;; CHECK-TEXT-NEXT:    (then
  ;; CHECK-TEXT-NEXT:     (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (else
  ;; CHECK-TEXT-NEXT:     (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (if (result anyref)
  ;; CHECK-TEXT-NEXT:    (i32.const 1)
  ;; CHECK-TEXT-NEXT:    (then
  ;; CHECK-TEXT-NEXT:     (ref.null none)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (else
  ;; CHECK-TEXT-NEXT:     (ref.null none)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (if (result anyref)
  ;; CHECK-TEXT-NEXT:    (i32.const 1)
  ;; CHECK-TEXT-NEXT:    (then
  ;; CHECK-TEXT-NEXT:     (ref.i31
  ;; CHECK-TEXT-NEXT:      (i32.const 0)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (else
  ;; CHECK-TEXT-NEXT:     (ref.null none)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (try (result eqref)
  ;; CHECK-TEXT-NEXT:    (do
  ;; CHECK-TEXT-NEXT:     (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (catch $e-i32
  ;; CHECK-TEXT-NEXT:     (drop
  ;; CHECK-TEXT-NEXT:      (pop i32)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (ref.null none)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (try (result funcref)
  ;; CHECK-TEXT-NEXT:    (do
  ;; CHECK-TEXT-NEXT:     (ref.func $foo)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (catch $e-i32
  ;; CHECK-TEXT-NEXT:     (drop
  ;; CHECK-TEXT-NEXT:      (pop i32)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (ref.null nofunc)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (try (result anyref)
  ;; CHECK-TEXT-NEXT:    (do
  ;; CHECK-TEXT-NEXT:     (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (catch $e-i32
  ;; CHECK-TEXT-NEXT:     (drop
  ;; CHECK-TEXT-NEXT:      (pop i32)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (ref.null none)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (try (result anyref)
  ;; CHECK-TEXT-NEXT:    (do
  ;; CHECK-TEXT-NEXT:     (ref.null none)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (catch $e-i32
  ;; CHECK-TEXT-NEXT:     (drop
  ;; CHECK-TEXT-NEXT:      (pop i32)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $tryend (result eqref)
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (block $catch (result i32)
  ;; CHECK-TEXT-NEXT:      (br $tryend
  ;; CHECK-TEXT-NEXT:       (try_table (result eqref) (catch $e-i32 $catch)
  ;; CHECK-TEXT-NEXT:        (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (ref.null none)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $tryend0 (result funcref)
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (block $catch0 (result i32)
  ;; CHECK-TEXT-NEXT:      (br $tryend0
  ;; CHECK-TEXT-NEXT:       (try_table (result funcref) (catch $e-i32 $catch0)
  ;; CHECK-TEXT-NEXT:        (ref.func $foo)
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (ref.null nofunc)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $tryend1 (result anyref)
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (block $catch1 (result i32)
  ;; CHECK-TEXT-NEXT:      (br $tryend1
  ;; CHECK-TEXT-NEXT:       (try_table (result anyref) (catch $e-i32 $catch1)
  ;; CHECK-TEXT-NEXT:        (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (ref.null none)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block $tryend2 (result anyref)
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (block $catch2 (result i32)
  ;; CHECK-TEXT-NEXT:      (br $tryend2
  ;; CHECK-TEXT-NEXT:       (try_table (result anyref) (catch $e-i32 $catch2)
  ;; CHECK-TEXT-NEXT:        (ref.null none)
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (select (result eqref)
  ;; CHECK-TEXT-NEXT:    (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:    (ref.null none)
  ;; CHECK-TEXT-NEXT:    (i32.const 1)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (select (result funcref)
  ;; CHECK-TEXT-NEXT:    (local.get $local_funcref)
  ;; CHECK-TEXT-NEXT:    (ref.null nofunc)
  ;; CHECK-TEXT-NEXT:    (i32.const 1)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (select
  ;; CHECK-TEXT-NEXT:    (i32.const 0)
  ;; CHECK-TEXT-NEXT:    (i32.const 2)
  ;; CHECK-TEXT-NEXT:    (i32.const 1)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (select (result anyref)
  ;; CHECK-TEXT-NEXT:    (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:    (ref.i31
  ;; CHECK-TEXT-NEXT:     (i32.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (i32.const 1)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (ref.is_null
  ;; CHECK-TEXT-NEXT:    (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (ref.is_null
  ;; CHECK-TEXT-NEXT:    (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (ref.is_null
  ;; CHECK-TEXT-NEXT:    (ref.null none)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (ref.is_null
  ;; CHECK-TEXT-NEXT:    (local.get $local_funcref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (ref.is_null
  ;; CHECK-TEXT-NEXT:    (global.get $global_funcref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (ref.is_null
  ;; CHECK-TEXT-NEXT:    (ref.null nofunc)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (ref.is_null
  ;; CHECK-TEXT-NEXT:    (ref.func $foo)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (ref.is_null
  ;; CHECK-TEXT-NEXT:    (local.get $local_anyref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (ref.is_null
  ;; CHECK-TEXT-NEXT:    (global.get $global_anyref)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (ref.is_null
  ;; CHECK-TEXT-NEXT:    (ref.null none)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $test (type $3)
  ;; CHECK-BIN-NEXT:  (local $local_eqref eqref)
  ;; CHECK-BIN-NEXT:  (local $local_funcref funcref)
  ;; CHECK-BIN-NEXT:  (local $local_anyref anyref)
  ;; CHECK-BIN-NEXT:  (local.set $local_eqref
  ;; CHECK-BIN-NEXT:   (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $local_eqref
  ;; CHECK-BIN-NEXT:   (global.get $global_eqref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $local_eqref
  ;; CHECK-BIN-NEXT:   (ref.null none)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $local_funcref
  ;; CHECK-BIN-NEXT:   (local.get $local_funcref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $local_funcref
  ;; CHECK-BIN-NEXT:   (global.get $global_funcref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $local_funcref
  ;; CHECK-BIN-NEXT:   (ref.null nofunc)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $local_funcref
  ;; CHECK-BIN-NEXT:   (ref.func $foo)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $local_anyref
  ;; CHECK-BIN-NEXT:   (local.get $local_anyref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $local_anyref
  ;; CHECK-BIN-NEXT:   (global.get $global_anyref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $local_anyref
  ;; CHECK-BIN-NEXT:   (ref.null none)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $local_anyref
  ;; CHECK-BIN-NEXT:   (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $local_anyref
  ;; CHECK-BIN-NEXT:   (global.get $global_eqref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $local_anyref
  ;; CHECK-BIN-NEXT:   (ref.null none)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (global.set $global_eqref
  ;; CHECK-BIN-NEXT:   (global.get $global_eqref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (global.set $global_eqref
  ;; CHECK-BIN-NEXT:   (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (global.set $global_eqref
  ;; CHECK-BIN-NEXT:   (ref.null none)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (global.set $global_funcref
  ;; CHECK-BIN-NEXT:   (global.get $global_funcref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (global.set $global_funcref
  ;; CHECK-BIN-NEXT:   (local.get $local_funcref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (global.set $global_funcref
  ;; CHECK-BIN-NEXT:   (ref.null nofunc)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (global.set $global_funcref
  ;; CHECK-BIN-NEXT:   (ref.func $foo)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (global.set $global_anyref
  ;; CHECK-BIN-NEXT:   (global.get $global_anyref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (global.set $global_anyref
  ;; CHECK-BIN-NEXT:   (local.get $local_anyref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (global.set $global_anyref
  ;; CHECK-BIN-NEXT:   (ref.null none)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (global.set $global_anyref
  ;; CHECK-BIN-NEXT:   (global.get $global_eqref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (global.set $global_anyref
  ;; CHECK-BIN-NEXT:   (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (global.set $global_anyref
  ;; CHECK-BIN-NEXT:   (ref.null none)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call $take_eqref
  ;; CHECK-BIN-NEXT:   (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call $take_eqref
  ;; CHECK-BIN-NEXT:   (global.get $global_eqref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call $take_eqref
  ;; CHECK-BIN-NEXT:   (ref.null none)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call $take_funcref
  ;; CHECK-BIN-NEXT:   (local.get $local_funcref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call $take_funcref
  ;; CHECK-BIN-NEXT:   (global.get $global_funcref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call $take_funcref
  ;; CHECK-BIN-NEXT:   (ref.null nofunc)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call $take_funcref
  ;; CHECK-BIN-NEXT:   (ref.func $foo)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call $take_anyref
  ;; CHECK-BIN-NEXT:   (local.get $local_anyref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call $take_anyref
  ;; CHECK-BIN-NEXT:   (global.get $global_anyref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call $take_anyref
  ;; CHECK-BIN-NEXT:   (ref.null none)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call $take_anyref
  ;; CHECK-BIN-NEXT:   (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call $take_anyref
  ;; CHECK-BIN-NEXT:   (global.get $global_eqref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call $take_anyref
  ;; CHECK-BIN-NEXT:   (ref.null none)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $sig_eqref)
  ;; CHECK-BIN-NEXT:   (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:   (i32.const 0)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $sig_eqref)
  ;; CHECK-BIN-NEXT:   (global.get $global_eqref)
  ;; CHECK-BIN-NEXT:   (i32.const 0)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $sig_eqref)
  ;; CHECK-BIN-NEXT:   (ref.null none)
  ;; CHECK-BIN-NEXT:   (i32.const 0)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $sig_funcref)
  ;; CHECK-BIN-NEXT:   (local.get $local_funcref)
  ;; CHECK-BIN-NEXT:   (i32.const 1)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $sig_funcref)
  ;; CHECK-BIN-NEXT:   (global.get $global_funcref)
  ;; CHECK-BIN-NEXT:   (i32.const 1)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $sig_funcref)
  ;; CHECK-BIN-NEXT:   (ref.null nofunc)
  ;; CHECK-BIN-NEXT:   (i32.const 1)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $sig_funcref)
  ;; CHECK-BIN-NEXT:   (ref.func $foo)
  ;; CHECK-BIN-NEXT:   (i32.const 1)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $sig_anyref)
  ;; CHECK-BIN-NEXT:   (local.get $local_anyref)
  ;; CHECK-BIN-NEXT:   (i32.const 3)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $sig_anyref)
  ;; CHECK-BIN-NEXT:   (global.get $global_anyref)
  ;; CHECK-BIN-NEXT:   (i32.const 3)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $sig_anyref)
  ;; CHECK-BIN-NEXT:   (ref.null none)
  ;; CHECK-BIN-NEXT:   (i32.const 3)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $sig_anyref)
  ;; CHECK-BIN-NEXT:   (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:   (i32.const 3)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $sig_anyref)
  ;; CHECK-BIN-NEXT:   (global.get $global_eqref)
  ;; CHECK-BIN-NEXT:   (i32.const 3)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $sig_anyref)
  ;; CHECK-BIN-NEXT:   (ref.null none)
  ;; CHECK-BIN-NEXT:   (i32.const 3)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$1 (result eqref)
  ;; CHECK-BIN-NEXT:    (br_if $label$1
  ;; CHECK-BIN-NEXT:     (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:     (i32.const 1)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$2 (result eqref)
  ;; CHECK-BIN-NEXT:    (br_if $label$2
  ;; CHECK-BIN-NEXT:     (global.get $global_eqref)
  ;; CHECK-BIN-NEXT:     (i32.const 1)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$3 (result eqref)
  ;; CHECK-BIN-NEXT:    (ref.cast nullref
  ;; CHECK-BIN-NEXT:     (br_if $label$3
  ;; CHECK-BIN-NEXT:      (ref.null none)
  ;; CHECK-BIN-NEXT:      (i32.const 1)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$4 (result funcref)
  ;; CHECK-BIN-NEXT:    (br_if $label$4
  ;; CHECK-BIN-NEXT:     (local.get $local_funcref)
  ;; CHECK-BIN-NEXT:     (i32.const 1)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$5 (result funcref)
  ;; CHECK-BIN-NEXT:    (br_if $label$5
  ;; CHECK-BIN-NEXT:     (global.get $global_funcref)
  ;; CHECK-BIN-NEXT:     (i32.const 1)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$6 (result funcref)
  ;; CHECK-BIN-NEXT:    (ref.cast nullfuncref
  ;; CHECK-BIN-NEXT:     (br_if $label$6
  ;; CHECK-BIN-NEXT:      (ref.null nofunc)
  ;; CHECK-BIN-NEXT:      (i32.const 1)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$7 (result funcref)
  ;; CHECK-BIN-NEXT:    (ref.cast (ref $3)
  ;; CHECK-BIN-NEXT:     (br_if $label$7
  ;; CHECK-BIN-NEXT:      (ref.func $foo)
  ;; CHECK-BIN-NEXT:      (i32.const 1)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$8 (result anyref)
  ;; CHECK-BIN-NEXT:    (br_if $label$8
  ;; CHECK-BIN-NEXT:     (local.get $local_anyref)
  ;; CHECK-BIN-NEXT:     (i32.const 1)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$9 (result anyref)
  ;; CHECK-BIN-NEXT:    (br_if $label$9
  ;; CHECK-BIN-NEXT:     (global.get $global_anyref)
  ;; CHECK-BIN-NEXT:     (i32.const 1)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$10 (result anyref)
  ;; CHECK-BIN-NEXT:    (ref.cast nullref
  ;; CHECK-BIN-NEXT:     (br_if $label$10
  ;; CHECK-BIN-NEXT:      (ref.null none)
  ;; CHECK-BIN-NEXT:      (i32.const 1)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$11 (result anyref)
  ;; CHECK-BIN-NEXT:    (ref.cast eqref
  ;; CHECK-BIN-NEXT:     (br_if $label$11
  ;; CHECK-BIN-NEXT:      (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:      (i32.const 1)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$12 (result anyref)
  ;; CHECK-BIN-NEXT:    (ref.cast nullref
  ;; CHECK-BIN-NEXT:     (br_if $label$12
  ;; CHECK-BIN-NEXT:      (ref.null none)
  ;; CHECK-BIN-NEXT:      (i32.const 1)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (loop $label$13 (result eqref)
  ;; CHECK-BIN-NEXT:    (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (loop $label$14 (result eqref)
  ;; CHECK-BIN-NEXT:    (global.get $global_eqref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (loop $label$15 (result eqref)
  ;; CHECK-BIN-NEXT:    (ref.null none)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (loop $label$16 (result funcref)
  ;; CHECK-BIN-NEXT:    (local.get $local_funcref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (loop $label$17 (result funcref)
  ;; CHECK-BIN-NEXT:    (global.get $global_funcref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (loop $label$18 (result funcref)
  ;; CHECK-BIN-NEXT:    (ref.null nofunc)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (loop $label$19 (result funcref)
  ;; CHECK-BIN-NEXT:    (ref.func $foo)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (loop $label$20 (result anyref)
  ;; CHECK-BIN-NEXT:    (local.get $local_anyref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (loop $label$21 (result anyref)
  ;; CHECK-BIN-NEXT:    (global.get $global_anyref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (loop $label$22 (result anyref)
  ;; CHECK-BIN-NEXT:    (ref.null none)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (loop $label$23 (result anyref)
  ;; CHECK-BIN-NEXT:    (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (loop $label$24 (result anyref)
  ;; CHECK-BIN-NEXT:    (global.get $global_eqref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (loop $label$25 (result anyref)
  ;; CHECK-BIN-NEXT:    (ref.null none)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (if (result eqref)
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:    (then
  ;; CHECK-BIN-NEXT:     (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (else
  ;; CHECK-BIN-NEXT:     (ref.null none)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (if (result funcref)
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:    (then
  ;; CHECK-BIN-NEXT:     (local.get $local_funcref)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (else
  ;; CHECK-BIN-NEXT:     (ref.null nofunc)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (if (result anyref)
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:    (then
  ;; CHECK-BIN-NEXT:     (local.get $local_anyref)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (else
  ;; CHECK-BIN-NEXT:     (ref.null none)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (if (result anyref)
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:    (then
  ;; CHECK-BIN-NEXT:     (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (else
  ;; CHECK-BIN-NEXT:     (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (if (result anyref)
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:    (then
  ;; CHECK-BIN-NEXT:     (ref.null none)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (else
  ;; CHECK-BIN-NEXT:     (ref.null none)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (if (result anyref)
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:    (then
  ;; CHECK-BIN-NEXT:     (ref.i31
  ;; CHECK-BIN-NEXT:      (i32.const 0)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (else
  ;; CHECK-BIN-NEXT:     (ref.null none)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (try $label$40 (result eqref)
  ;; CHECK-BIN-NEXT:    (do
  ;; CHECK-BIN-NEXT:     (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (catch $e-i32
  ;; CHECK-BIN-NEXT:     (drop
  ;; CHECK-BIN-NEXT:      (pop i32)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (ref.null none)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (try $label$43 (result funcref)
  ;; CHECK-BIN-NEXT:    (do
  ;; CHECK-BIN-NEXT:     (ref.func $foo)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (catch $e-i32
  ;; CHECK-BIN-NEXT:     (drop
  ;; CHECK-BIN-NEXT:      (pop i32)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (ref.null nofunc)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (try $label$46 (result anyref)
  ;; CHECK-BIN-NEXT:    (do
  ;; CHECK-BIN-NEXT:     (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (catch $e-i32
  ;; CHECK-BIN-NEXT:     (drop
  ;; CHECK-BIN-NEXT:      (pop i32)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (ref.null none)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (try $label$49 (result anyref)
  ;; CHECK-BIN-NEXT:    (do
  ;; CHECK-BIN-NEXT:     (ref.null none)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (catch $e-i32
  ;; CHECK-BIN-NEXT:     (drop
  ;; CHECK-BIN-NEXT:      (pop i32)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$50 (result eqref)
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (block $label$51 (result i32)
  ;; CHECK-BIN-NEXT:      (br $label$50
  ;; CHECK-BIN-NEXT:       (try_table (result eqref) (catch $e-i32 $label$51)
  ;; CHECK-BIN-NEXT:        (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (ref.null none)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$53 (result funcref)
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (block $label$54 (result i32)
  ;; CHECK-BIN-NEXT:      (br $label$53
  ;; CHECK-BIN-NEXT:       (try_table (result funcref) (catch $e-i32 $label$54)
  ;; CHECK-BIN-NEXT:        (ref.func $foo)
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (ref.null nofunc)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$56 (result anyref)
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (block $label$57 (result i32)
  ;; CHECK-BIN-NEXT:      (br $label$56
  ;; CHECK-BIN-NEXT:       (try_table (result anyref) (catch $e-i32 $label$57)
  ;; CHECK-BIN-NEXT:        (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (ref.null none)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (block $label$59 (result anyref)
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (block $label$60 (result i32)
  ;; CHECK-BIN-NEXT:      (br $label$59
  ;; CHECK-BIN-NEXT:       (try_table (result anyref) (catch $e-i32 $label$60)
  ;; CHECK-BIN-NEXT:        (ref.null none)
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (select (result eqref)
  ;; CHECK-BIN-NEXT:    (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:    (ref.null none)
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (select (result funcref)
  ;; CHECK-BIN-NEXT:    (local.get $local_funcref)
  ;; CHECK-BIN-NEXT:    (ref.null nofunc)
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (select
  ;; CHECK-BIN-NEXT:    (i32.const 0)
  ;; CHECK-BIN-NEXT:    (i32.const 2)
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (select (result anyref)
  ;; CHECK-BIN-NEXT:    (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:    (ref.i31
  ;; CHECK-BIN-NEXT:     (i32.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (ref.is_null
  ;; CHECK-BIN-NEXT:    (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (ref.is_null
  ;; CHECK-BIN-NEXT:    (global.get $global_eqref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (ref.is_null
  ;; CHECK-BIN-NEXT:    (ref.null none)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (ref.is_null
  ;; CHECK-BIN-NEXT:    (local.get $local_funcref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (ref.is_null
  ;; CHECK-BIN-NEXT:    (global.get $global_funcref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (ref.is_null
  ;; CHECK-BIN-NEXT:    (ref.null nofunc)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (ref.is_null
  ;; CHECK-BIN-NEXT:    (ref.func $foo)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (ref.is_null
  ;; CHECK-BIN-NEXT:    (local.get $local_anyref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (ref.is_null
  ;; CHECK-BIN-NEXT:    (global.get $global_anyref)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (ref.is_null
  ;; CHECK-BIN-NEXT:    (ref.null none)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $test
    (local $local_eqref eqref)
    (local $local_funcref funcref)
    (local $local_anyref anyref)

    ;; Test types for local.get/set
    (local.set $local_eqref (local.get $local_eqref))
    (local.set $local_eqref (global.get $global_eqref))
    (local.set $local_eqref (ref.null eq))
    (local.set $local_funcref (local.get $local_funcref))
    (local.set $local_funcref (global.get $global_funcref))
    (local.set $local_funcref (ref.null func))
    (local.set $local_funcref (ref.func $foo))
    (local.set $local_anyref (local.get $local_anyref))
    (local.set $local_anyref (global.get $global_anyref))
    (local.set $local_anyref (ref.null any))

    ;; Test subtype relationship for local.set
    (local.set $local_anyref (local.get $local_eqref))
    (local.set $local_anyref (global.get $global_eqref))
    (local.set $local_anyref (ref.null eq))

    ;; Test types for global.get/set
    (global.set $global_eqref (global.get $global_eqref))
    (global.set $global_eqref (local.get $local_eqref))
    (global.set $global_eqref (ref.null eq))
    (global.set $global_funcref (global.get $global_funcref))
    (global.set $global_funcref (local.get $local_funcref))
    (global.set $global_funcref (ref.null func))
    (global.set $global_funcref (ref.func $foo))
    (global.set $global_anyref (global.get $global_anyref))
    (global.set $global_anyref (local.get $local_anyref))
    (global.set $global_anyref (ref.null any))

    ;; Test subtype relationship for global.set
    (global.set $global_anyref (global.get $global_eqref))
    (global.set $global_anyref (local.get $local_eqref))
    (global.set $global_anyref (ref.null eq))

    ;; Test function call params
    (call $take_eqref (local.get $local_eqref))
    (call $take_eqref (global.get $global_eqref))
    (call $take_eqref (ref.null eq))
    (call $take_funcref (local.get $local_funcref))
    (call $take_funcref (global.get $global_funcref))
    (call $take_funcref (ref.null func))
    (call $take_funcref (ref.func $foo))
    (call $take_anyref (local.get $local_anyref))
    (call $take_anyref (global.get $global_anyref))
    (call $take_anyref (ref.null any))

    ;; Test subtype relationship for function call params
    (call $take_anyref (local.get $local_eqref))
    (call $take_anyref (global.get $global_eqref))
    (call $take_anyref (ref.null eq))

    ;; Test call_indirect params
    (call_indirect (type $sig_eqref) (local.get $local_eqref) (i32.const 0))
    (call_indirect (type $sig_eqref) (global.get $global_eqref) (i32.const 0))
    (call_indirect (type $sig_eqref) (ref.null eq) (i32.const 0))
    (call_indirect (type $sig_funcref) (local.get $local_funcref) (i32.const 1))
    (call_indirect (type $sig_funcref) (global.get $global_funcref) (i32.const 1))
    (call_indirect (type $sig_funcref) (ref.null func) (i32.const 1))
    (call_indirect (type $sig_funcref) (ref.func $foo) (i32.const 1))
    (call_indirect (type $sig_anyref) (local.get $local_anyref) (i32.const 3))
    (call_indirect (type $sig_anyref) (global.get $global_anyref) (i32.const 3))
    (call_indirect (type $sig_anyref) (ref.null any) (i32.const 3))

    ;; Test subtype relationship for call_indirect params
    (call_indirect (type $sig_anyref) (local.get $local_eqref) (i32.const 3))
    (call_indirect (type $sig_anyref) (global.get $global_eqref) (i32.const 3))
    (call_indirect (type $sig_anyref) (ref.null eq) (i32.const 3))

    ;; Test block return type
    (drop
      (block (result eqref)
        (br_if 0 (local.get $local_eqref) (i32.const 1))
      )
    )
    (drop
      (block (result eqref)
        (br_if 0 (global.get $global_eqref) (i32.const 1))
      )
    )
    (drop
      (block (result eqref)
        ;; Note that we will end up emitting a cast here, and in several cases
        ;; below, because the br_if value is more refined than the target block.
        (br_if 0 (ref.null eq) (i32.const 1))
      )
    )
    (drop
      (block (result funcref)
        (br_if 0 (local.get $local_funcref) (i32.const 1))
      )
    )
    (drop
      (block (result funcref)
        (br_if 0 (global.get $global_funcref) (i32.const 1))
      )
    )
    (drop
      (block (result funcref)
        (br_if 0 (ref.null func) (i32.const 1))
      )
    )
    (drop
      (block (result funcref)
        (br_if 0 (ref.func $foo) (i32.const 1))
      )
    )
    (drop
      (block (result anyref)
        (br_if 0 (local.get $local_anyref) (i32.const 1))
      )
    )
    (drop
      (block (result anyref)
        (br_if 0 (global.get $global_anyref) (i32.const 1))
      )
    )
    (drop
      (block (result anyref)
        (br_if 0 (ref.null any) (i32.const 1))
      )
    )

    ;; Test subtype relationship for block return type
    (drop
      (block (result anyref)
        (br_if 0 (local.get $local_eqref) (i32.const 1))
      )
    )
    (drop
      (block (result anyref)
        (br_if 0 (ref.null eq) (i32.const 1))
      )
    )

    ;; Test loop return type
    (drop
      (loop (result eqref)
        (local.get $local_eqref)
      )
    )
    (drop
      (loop (result eqref)
        (global.get $global_eqref)
      )
    )
    (drop
      (loop (result eqref)
        (ref.null eq)
      )
    )
    (drop
      (loop (result funcref)
        (local.get $local_funcref)
      )
    )
    (drop
      (loop (result funcref)
        (global.get $global_funcref)
      )
    )
    (drop
      (loop (result funcref)
        (ref.null func)
      )
    )
    (drop
      (loop (result funcref)
        (ref.func $foo)
      )
    )
    (drop
      (loop (result anyref)
        (local.get $local_anyref)
      )
    )
    (drop
      (loop (result anyref)
        (global.get $global_anyref)
      )
    )
    (drop
      (loop (result anyref)
        (ref.null any)
      )
    )

    ;; Test subtype relationship for loop return type
    (drop
      (loop (result anyref)
        (local.get $local_eqref)
      )
    )
    (drop
      (loop (result anyref)
        (global.get $global_eqref)
      )
    )
    (drop
      (loop (result anyref)
        (ref.null eq)
      )
    )

    ;; Test if return type
    (drop
      (if (result eqref)
        (i32.const 1)
        (then
          (local.get $local_eqref)
        )
        (else
          (ref.null eq)
        )
      )
    )
    (drop
      (if (result funcref)
        (i32.const 1)
        (then
          (local.get $local_funcref)
        )
        (else
          (ref.null func)
        )
      )
    )
    (drop
      (if (result anyref)
        (i32.const 1)
        (then
          (local.get $local_anyref)
        )
        (else
          (ref.null any)
        )
      )
    )

    ;; Test subtype relationship for if return type
    (drop
      (if (result anyref)
        (i32.const 1)
        (then
          (local.get $local_eqref)
        )
        (else
          (local.get $local_eqref)
        )
      )
    )
    (drop
      (if (result anyref)
        (i32.const 1)
        (then
          (ref.null eq)
        )
        (else
          (ref.null i31)
        )
      )
    )
    (drop
      (if (result anyref)
        (i32.const 1)
        (then
          (ref.i31
            (i32.const 0)
          )
        )
        (else
          (ref.null eq)
        )
      )
    )

    ;; Test try return type
    (drop
      (try (result eqref)
        (do
          (local.get $local_eqref)
        )
        (catch $e-i32
          (drop (pop i32))
          (ref.null eq)
        )
      )
    )
    (drop
      (try (result funcref)
        (do
          (ref.func $foo)
        )
        (catch $e-i32
          (drop (pop i32))
          (ref.null func)
        )
      )
    )

    ;; Test subtype relationship for try return type
    (drop
      (try (result anyref)
        (do
          (local.get $local_eqref)
        )
        (catch $e-i32
          (drop (pop i32))
          (ref.null any)
        )
      )
    )
    (drop
      (try (result anyref)
        (do
          (ref.null eq)
        )
        (catch $e-i32
          (drop (pop i32))
          (local.get $local_eqref)
        )
      )
    )

    ;; Test try_table return type
    (drop
      (block $tryend (result eqref)
        (drop
          (block $catch (result i32)
            (br $tryend
              (try_table (result eqref) (catch $e-i32 $catch)
                (local.get $local_eqref)
              )
            )
          )
        )
        (ref.null eq)
      )
    )
    (drop
      (block $tryend (result funcref)
        (drop
          (block $catch (result i32)
            (br $tryend
              (try_table (result funcref) (catch $e-i32 $catch)
                (ref.func $foo)
              )
            )
          )
        )
        (ref.null func)
      )
    )

    ;; Test subtype relationship for try_table return type
    (drop
      (block $tryend (result anyref)
        (drop
          (block $catch (result i32)
            (br $tryend
              (try_table (result anyref) (catch $e-i32 $catch)
                (local.get $local_eqref)
              )
            )
          )
        )
        (ref.null any)
      )
    )
    (drop
      (block $tryend (result anyref)
        (drop
          (block $catch (result i32)
            (br $tryend
              (try_table (result anyref) (catch $e-i32 $catch)
                (ref.null eq)
              )
            )
          )
        )
        (local.get $local_eqref)
      )
    )

    ;; Test typed select
    (drop
      (select (result eqref)
        (local.get $local_eqref)
        (ref.null eq)
        (i32.const 1)
      )
    )
    (drop
      (select (result funcref)
        (local.get $local_funcref)
        (ref.null func)
        (i32.const 1)
      )
    )
    (drop
      (select (result i32)
        (i32.const 0)
        (i32.const 2)
        (i32.const 1)
      )
    )

    ;; Test subtype relationship for typed select
    (drop
      (select (result anyref)
        (local.get $local_eqref)
        (ref.i31
          (i32.const 0)
        )
        (i32.const 1)
      )
    )

    ;; ref.is_null takes any reference types
    (drop (ref.is_null (local.get $local_eqref)))
    (drop (ref.is_null (global.get $global_eqref)))
    (drop (ref.is_null (ref.null eq)))
    (drop (ref.is_null (local.get $local_funcref)))
    (drop (ref.is_null (global.get $global_funcref)))
    (drop (ref.is_null (ref.null func)))
    (drop (ref.is_null (ref.func $foo)))
    (drop (ref.is_null (local.get $local_anyref)))
    (drop (ref.is_null (global.get $global_anyref)))
    (drop (ref.is_null (ref.null any)))
  )

  ;; Test function return type

  ;; CHECK-TEXT:      (func $return_eqref_local (type $6) (result eqref)
  ;; CHECK-TEXT-NEXT:  (local $local_eqref eqref)
  ;; CHECK-TEXT-NEXT:  (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $return_eqref_local (type $6) (result eqref)
  ;; CHECK-BIN-NEXT:  (local $local_eqref eqref)
  ;; CHECK-BIN-NEXT:  (local.get $local_eqref)
  ;; CHECK-BIN-NEXT: )
  (func $return_eqref_local (result eqref)
    (local $local_eqref eqref)
    (local.get $local_eqref)
  )

  ;; CHECK-TEXT:      (func $return_eqref_global (type $6) (result eqref)
  ;; CHECK-TEXT-NEXT:  (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $return_eqref_global (type $6) (result eqref)
  ;; CHECK-BIN-NEXT:  (global.get $global_eqref)
  ;; CHECK-BIN-NEXT: )
  (func $return_eqref_global (result eqref)
    (global.get $global_eqref)
  )

  ;; CHECK-TEXT:      (func $return_eqref_null (type $6) (result eqref)
  ;; CHECK-TEXT-NEXT:  (ref.null none)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $return_eqref_null (type $6) (result eqref)
  ;; CHECK-BIN-NEXT:  (ref.null none)
  ;; CHECK-BIN-NEXT: )
  (func $return_eqref_null (result eqref)
    (ref.null eq)
  )

  ;; CHECK-TEXT:      (func $return_funcref_local (type $3) (result funcref)
  ;; CHECK-TEXT-NEXT:  (local $local_funcref funcref)
  ;; CHECK-TEXT-NEXT:  (local.get $local_funcref)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $return_funcref_local (type $4) (result funcref)
  ;; CHECK-BIN-NEXT:  (local $local_funcref funcref)
  ;; CHECK-BIN-NEXT:  (local.get $local_funcref)
  ;; CHECK-BIN-NEXT: )
  (func $return_funcref_local (result funcref)
    (local $local_funcref funcref)
    (local.get $local_funcref)
  )

  ;; CHECK-TEXT:      (func $return_funcref_global (type $3) (result funcref)
  ;; CHECK-TEXT-NEXT:  (global.get $global_funcref)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $return_funcref_global (type $4) (result funcref)
  ;; CHECK-BIN-NEXT:  (global.get $global_funcref)
  ;; CHECK-BIN-NEXT: )
  (func $return_funcref_global (result funcref)
    (global.get $global_funcref)
  )

  ;; CHECK-TEXT:      (func $return_funcref_null (type $3) (result funcref)
  ;; CHECK-TEXT-NEXT:  (ref.null nofunc)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $return_funcref_null (type $4) (result funcref)
  ;; CHECK-BIN-NEXT:  (ref.null nofunc)
  ;; CHECK-BIN-NEXT: )
  (func $return_funcref_null (result funcref)
    (ref.null func)
  )

  ;; CHECK-TEXT:      (func $return_funcref_func (type $3) (result funcref)
  ;; CHECK-TEXT-NEXT:  (ref.func $foo)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $return_funcref_func (type $4) (result funcref)
  ;; CHECK-BIN-NEXT:  (ref.func $foo)
  ;; CHECK-BIN-NEXT: )
  (func $return_funcref_func (result funcref)
    (ref.func $foo)
  )

  ;; CHECK-TEXT:      (func $return_anyref_local (type $0) (result anyref)
  ;; CHECK-TEXT-NEXT:  (local $local_anyref anyref)
  ;; CHECK-TEXT-NEXT:  (local.get $local_anyref)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $return_anyref_local (type $0) (result anyref)
  ;; CHECK-BIN-NEXT:  (local $local_anyref anyref)
  ;; CHECK-BIN-NEXT:  (local.get $local_anyref)
  ;; CHECK-BIN-NEXT: )
  (func $return_anyref_local (result anyref)
    (local $local_anyref anyref)
    (local.get $local_anyref)
  )

  ;; CHECK-TEXT:      (func $return_anyref_global (type $0) (result anyref)
  ;; CHECK-TEXT-NEXT:  (global.get $global_anyref)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $return_anyref_global (type $0) (result anyref)
  ;; CHECK-BIN-NEXT:  (global.get $global_anyref)
  ;; CHECK-BIN-NEXT: )
  (func $return_anyref_global (result anyref)
    (global.get $global_anyref)
  )

  ;; CHECK-TEXT:      (func $return_anyref_null (type $0) (result anyref)
  ;; CHECK-TEXT-NEXT:  (ref.null none)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $return_anyref_null (type $0) (result anyref)
  ;; CHECK-BIN-NEXT:  (ref.null none)
  ;; CHECK-BIN-NEXT: )
  (func $return_anyref_null (result anyref)
    (ref.null any)
  )

  ;; Test subtype relationship in function return type

  ;; CHECK-TEXT:      (func $return_anyref2 (type $0) (result anyref)
  ;; CHECK-TEXT-NEXT:  (local $local_eqref eqref)
  ;; CHECK-TEXT-NEXT:  (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $return_anyref2 (type $0) (result anyref)
  ;; CHECK-BIN-NEXT:  (local $local_eqref eqref)
  ;; CHECK-BIN-NEXT:  (local.get $local_eqref)
  ;; CHECK-BIN-NEXT: )
  (func $return_anyref2 (result anyref)
    (local $local_eqref eqref)
    (local.get $local_eqref)
  )

  ;; CHECK-TEXT:      (func $return_anyref3 (type $0) (result anyref)
  ;; CHECK-TEXT-NEXT:  (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $return_anyref3 (type $0) (result anyref)
  ;; CHECK-BIN-NEXT:  (global.get $global_eqref)
  ;; CHECK-BIN-NEXT: )
  (func $return_anyref3 (result anyref)
    (global.get $global_eqref)
  )

  ;; CHECK-TEXT:      (func $return_anyref4 (type $0) (result anyref)
  ;; CHECK-TEXT-NEXT:  (ref.null none)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $return_anyref4 (type $0) (result anyref)
  ;; CHECK-BIN-NEXT:  (ref.null none)
  ;; CHECK-BIN-NEXT: )
  (func $return_anyref4 (result anyref)
    (ref.null eq)
  )

  ;; Test returns

  ;; CHECK-TEXT:      (func $returns_eqref (type $6) (result eqref)
  ;; CHECK-TEXT-NEXT:  (local $local_eqref eqref)
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $returns_eqref (type $6) (result eqref)
  ;; CHECK-BIN-NEXT:  (local $local_eqref eqref)
  ;; CHECK-BIN-NEXT:  (return
  ;; CHECK-BIN-NEXT:   (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $returns_eqref (result eqref)
    (local $local_eqref eqref)
    (return (local.get $local_eqref))
    (return (global.get $global_eqref))
    (return (ref.null eq))
  )

  ;; CHECK-TEXT:      (func $returns_funcref (type $3) (result funcref)
  ;; CHECK-TEXT-NEXT:  (local $local_funcref funcref)
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (local.get $local_funcref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (global.get $global_funcref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (ref.func $foo)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (ref.null nofunc)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $returns_funcref (type $4) (result funcref)
  ;; CHECK-BIN-NEXT:  (local $local_funcref funcref)
  ;; CHECK-BIN-NEXT:  (return
  ;; CHECK-BIN-NEXT:   (local.get $local_funcref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $returns_funcref (result funcref)
    (local $local_funcref funcref)
    (return (local.get $local_funcref))
    (return (global.get $global_funcref))
    (return (ref.func $foo))
    (return (ref.null func))
  )

  ;; CHECK-TEXT:      (func $returns_anyref (type $0) (result anyref)
  ;; CHECK-TEXT-NEXT:  (local $local_anyref anyref)
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (local.get $local_anyref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (global.get $global_anyref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $returns_anyref (type $0) (result anyref)
  ;; CHECK-BIN-NEXT:  (local $local_anyref anyref)
  ;; CHECK-BIN-NEXT:  (return
  ;; CHECK-BIN-NEXT:   (local.get $local_anyref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $returns_anyref (result anyref)
    (local $local_anyref anyref)
    (return (local.get $local_anyref))
    (return (global.get $global_anyref))
    (return (ref.null any))
  )

  ;; Test subtype relationship in returns

  ;; CHECK-TEXT:      (func $returns_anyref2 (type $0) (result anyref)
  ;; CHECK-TEXT-NEXT:  (local $local_eqref eqref)
  ;; CHECK-TEXT-NEXT:  (local $local_funcref funcref)
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (local.get $local_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (global.get $global_eqref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (ref.null none)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $returns_anyref2 (type $0) (result anyref)
  ;; CHECK-BIN-NEXT:  (local $local_eqref eqref)
  ;; CHECK-BIN-NEXT:  (local $local_funcref funcref)
  ;; CHECK-BIN-NEXT:  (return
  ;; CHECK-BIN-NEXT:   (local.get $local_eqref)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $returns_anyref2 (result anyref)
    (local $local_eqref eqref)
    (local $local_funcref funcref)
    (return (local.get $local_eqref))
    (return (global.get $global_eqref))
    (return (ref.null eq))
  )

  ;; CHECK-TEXT:      (func $ref-user (type $5)
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (ref.func $ref-taken-but-not-in-table)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $ref-user (type $3)
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (ref.func $ref-taken-but-not-in-table)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $ref-user
    (drop
      ;; an "elem declare func" must be emitted for this ref.func which is not
      ;; in the table
      (ref.func $ref-taken-but-not-in-table)
    )
  )

  ;; CHECK-TEXT:      (func $ref-taken-but-not-in-table (type $5)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $ref-taken-but-not-in-table (type $3)
  ;; CHECK-BIN-NEXT: )
  (func $ref-taken-but-not-in-table)
)
;; CHECK-BIN-NODEBUG:      (tag $tag$0 (param i32))

;; CHECK-BIN-NODEBUG:      (export "export_func" (func $fimport$0))

;; CHECK-BIN-NODEBUG:      (export "export_global" (global $gimport$0))

;; CHECK-BIN-NODEBUG:      (func $0 (type $5) (param $0 eqref)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $1 (type $2) (param $0 funcref)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $2 (type $1) (param $0 anyref)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $3 (type $3)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $4 (type $3)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 eqref)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 funcref)
;; CHECK-BIN-NODEBUG-NEXT:  (local $2 anyref)
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $1
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $1
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null nofunc)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $1
;; CHECK-BIN-NODEBUG-NEXT:   (ref.func $3)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $2
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $2
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$3)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $2
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $2
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $2
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $2
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (global.set $global$0
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (global.set $global$0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (global.set $global$0
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (global.set $global$1
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (global.set $global$1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (global.set $global$1
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null nofunc)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (global.set $global$1
;; CHECK-BIN-NODEBUG-NEXT:   (ref.func $3)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (global.set $global$3
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$3)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (global.set $global$3
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (global.set $global$3
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (global.set $global$3
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (global.set $global$3
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (global.set $global$3
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call $0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call $0
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call $0
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call $1
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call $1
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null nofunc)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call $1
;; CHECK-BIN-NODEBUG-NEXT:   (ref.func $3)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call $2
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call $2
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$3)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call $2
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call $2
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call $2
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call $2
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $5)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $5)
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$0)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $5)
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $2)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $2)
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$1)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $2)
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null nofunc)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $2)
;; CHECK-BIN-NODEBUG-NEXT:   (ref.func $3)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 3)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$3)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 3)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 3)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 3)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:   (global.get $global$0)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 3)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 3)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$1 (result eqref)
;; CHECK-BIN-NODEBUG-NEXT:    (br_if $label$1
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$2 (result eqref)
;; CHECK-BIN-NODEBUG-NEXT:    (br_if $label$2
;; CHECK-BIN-NODEBUG-NEXT:     (global.get $global$0)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$3 (result eqref)
;; CHECK-BIN-NODEBUG-NEXT:    (ref.cast nullref
;; CHECK-BIN-NODEBUG-NEXT:     (br_if $label$3
;; CHECK-BIN-NODEBUG-NEXT:      (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:      (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$4 (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:    (br_if $label$4
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$5 (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:    (br_if $label$5
;; CHECK-BIN-NODEBUG-NEXT:     (global.get $global$1)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$6 (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:    (ref.cast nullfuncref
;; CHECK-BIN-NODEBUG-NEXT:     (br_if $label$6
;; CHECK-BIN-NODEBUG-NEXT:      (ref.null nofunc)
;; CHECK-BIN-NODEBUG-NEXT:      (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$7 (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:    (ref.cast (ref $3)
;; CHECK-BIN-NODEBUG-NEXT:     (br_if $label$7
;; CHECK-BIN-NODEBUG-NEXT:      (ref.func $3)
;; CHECK-BIN-NODEBUG-NEXT:      (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$8 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (br_if $label$8
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$9 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (br_if $label$9
;; CHECK-BIN-NODEBUG-NEXT:     (global.get $global$3)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$10 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (ref.cast nullref
;; CHECK-BIN-NODEBUG-NEXT:     (br_if $label$10
;; CHECK-BIN-NODEBUG-NEXT:      (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:      (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$11 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (ref.cast eqref
;; CHECK-BIN-NODEBUG-NEXT:     (br_if $label$11
;; CHECK-BIN-NODEBUG-NEXT:      (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:      (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$12 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (ref.cast nullref
;; CHECK-BIN-NODEBUG-NEXT:     (br_if $label$12
;; CHECK-BIN-NODEBUG-NEXT:      (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:      (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (loop $label$13 (result eqref)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (loop $label$14 (result eqref)
;; CHECK-BIN-NODEBUG-NEXT:    (global.get $global$0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (loop $label$15 (result eqref)
;; CHECK-BIN-NODEBUG-NEXT:    (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (loop $label$16 (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (loop $label$17 (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:    (global.get $global$1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (loop $label$18 (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:    (ref.null nofunc)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (loop $label$19 (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:    (ref.func $3)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (loop $label$20 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (loop $label$21 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (global.get $global$3)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (loop $label$22 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (loop $label$23 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (loop $label$24 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (global.get $global$0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (loop $label$25 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (if (result eqref)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    (then
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (else
;; CHECK-BIN-NODEBUG-NEXT:     (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (if (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    (then
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (else
;; CHECK-BIN-NODEBUG-NEXT:     (ref.null nofunc)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (if (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    (then
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (else
;; CHECK-BIN-NODEBUG-NEXT:     (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (if (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    (then
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (else
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (if (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    (then
;; CHECK-BIN-NODEBUG-NEXT:     (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (else
;; CHECK-BIN-NODEBUG-NEXT:     (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (if (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    (then
;; CHECK-BIN-NODEBUG-NEXT:     (ref.i31
;; CHECK-BIN-NODEBUG-NEXT:      (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (else
;; CHECK-BIN-NODEBUG-NEXT:     (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (try $label$40 (result eqref)
;; CHECK-BIN-NODEBUG-NEXT:    (do
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:     (drop
;; CHECK-BIN-NODEBUG-NEXT:      (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (try $label$43 (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:    (do
;; CHECK-BIN-NODEBUG-NEXT:     (ref.func $3)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:     (drop
;; CHECK-BIN-NODEBUG-NEXT:      (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (ref.null nofunc)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (try $label$46 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (do
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:     (drop
;; CHECK-BIN-NODEBUG-NEXT:      (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (try $label$49 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (do
;; CHECK-BIN-NODEBUG-NEXT:     (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:     (drop
;; CHECK-BIN-NODEBUG-NEXT:      (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$50 (result eqref)
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (block $label$51 (result i32)
;; CHECK-BIN-NODEBUG-NEXT:      (br $label$50
;; CHECK-BIN-NODEBUG-NEXT:       (try_table (result eqref) (catch $tag$0 $label$51)
;; CHECK-BIN-NODEBUG-NEXT:        (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$53 (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (block $label$54 (result i32)
;; CHECK-BIN-NODEBUG-NEXT:      (br $label$53
;; CHECK-BIN-NODEBUG-NEXT:       (try_table (result funcref) (catch $tag$0 $label$54)
;; CHECK-BIN-NODEBUG-NEXT:        (ref.func $3)
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (ref.null nofunc)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$56 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (block $label$57 (result i32)
;; CHECK-BIN-NODEBUG-NEXT:      (br $label$56
;; CHECK-BIN-NODEBUG-NEXT:       (try_table (result anyref) (catch $tag$0 $label$57)
;; CHECK-BIN-NODEBUG-NEXT:        (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (block $label$59 (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (block $label$60 (result i32)
;; CHECK-BIN-NODEBUG-NEXT:      (br $label$59
;; CHECK-BIN-NODEBUG-NEXT:       (try_table (result anyref) (catch $tag$0 $label$60)
;; CHECK-BIN-NODEBUG-NEXT:        (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (select (result eqref)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (select (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    (ref.null nofunc)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (select
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 2)
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (select (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (ref.i31
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (ref.is_null
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (ref.is_null
;; CHECK-BIN-NODEBUG-NEXT:    (global.get $global$0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (ref.is_null
;; CHECK-BIN-NODEBUG-NEXT:    (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (ref.is_null
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (ref.is_null
;; CHECK-BIN-NODEBUG-NEXT:    (global.get $global$1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (ref.is_null
;; CHECK-BIN-NODEBUG-NEXT:    (ref.null nofunc)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (ref.is_null
;; CHECK-BIN-NODEBUG-NEXT:    (ref.func $3)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (ref.is_null
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (ref.is_null
;; CHECK-BIN-NODEBUG-NEXT:    (global.get $global$3)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (ref.is_null
;; CHECK-BIN-NODEBUG-NEXT:    (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $5 (type $6) (result eqref)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 eqref)
;; CHECK-BIN-NODEBUG-NEXT:  (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $6 (type $6) (result eqref)
;; CHECK-BIN-NODEBUG-NEXT:  (global.get $global$0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $7 (type $6) (result eqref)
;; CHECK-BIN-NODEBUG-NEXT:  (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $8 (type $4) (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 funcref)
;; CHECK-BIN-NODEBUG-NEXT:  (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $9 (type $4) (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:  (global.get $global$1)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $10 (type $4) (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:  (ref.null nofunc)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $11 (type $4) (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:  (ref.func $3)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $12 (type $0) (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 anyref)
;; CHECK-BIN-NODEBUG-NEXT:  (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $13 (type $0) (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:  (global.get $global$3)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $14 (type $0) (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:  (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $15 (type $0) (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 eqref)
;; CHECK-BIN-NODEBUG-NEXT:  (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $16 (type $0) (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:  (global.get $global$0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $17 (type $0) (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:  (ref.null none)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $18 (type $6) (result eqref)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 eqref)
;; CHECK-BIN-NODEBUG-NEXT:  (return
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $19 (type $4) (result funcref)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 funcref)
;; CHECK-BIN-NODEBUG-NEXT:  (return
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $20 (type $0) (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 anyref)
;; CHECK-BIN-NODEBUG-NEXT:  (return
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $21 (type $0) (result anyref)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 eqref)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 funcref)
;; CHECK-BIN-NODEBUG-NEXT:  (return
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $22 (type $3)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (ref.func $23)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $23 (type $3)
;; CHECK-BIN-NODEBUG-NEXT: )
