// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 -triple s390x-linux-gnu -target-cpu z13 -fzvector \
// RUN: -emit-llvm -o - -W -Wall -Werror \
// RUN: %s | opt -S -passes=mem2reg | FileCheck %s

volatile vector signed char sc, sc2;
volatile vector unsigned char uc, uc2;
volatile vector bool char bc, bc2;

volatile vector signed short ss, ss2;
volatile vector unsigned short us, us2;
volatile vector bool short bs, bs2;

volatile vector signed int si, si2;
volatile vector unsigned int ui, ui2;
volatile vector bool int bi, bi2;

volatile vector signed long long sl, sl2;
volatile vector unsigned long long ul, ul2;
volatile vector bool long long bl, bl2;

volatile vector double fd, fd2;

volatile int cnt;

// CHECK-LABEL: define dso_local void @test_assign(
// CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    store volatile <16 x i8> [[TMP0]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    store volatile <16 x i8> [[TMP1]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    store volatile <8 x i16> [[TMP2]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    store volatile <8 x i16> [[TMP3]], ptr @us, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    store volatile <4 x i32> [[TMP4]], ptr @si, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    store volatile <4 x i32> [[TMP5]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    store volatile <2 x i64> [[TMP6]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    store volatile <2 x i64> [[TMP7]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    store volatile <2 x double> [[TMP8]], ptr @fd, align 8
// CHECK-NEXT:    ret void
//
void test_assign(void) {

  sc = sc2;
  uc = uc2;

  ss = ss2;
  us = us2;

  si = si2;
  ui = ui2;

  sl = sl2;
  ul = ul2;

  fd = fd2;
}

// CHECK-LABEL: define dso_local void @test_pos(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    store volatile <16 x i8> [[TMP0]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    store volatile <16 x i8> [[TMP1]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    store volatile <8 x i16> [[TMP2]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    store volatile <8 x i16> [[TMP3]], ptr @us, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    store volatile <4 x i32> [[TMP4]], ptr @si, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    store volatile <4 x i32> [[TMP5]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    store volatile <2 x i64> [[TMP6]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    store volatile <2 x i64> [[TMP7]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    store volatile <2 x double> [[TMP8]], ptr @fd, align 8
// CHECK-NEXT:    ret void
//
void test_pos(void) {

  sc = +sc2;
  uc = +uc2;

  ss = +ss2;
  us = +us2;

  si = +si2;
  ui = +ui2;

  sl = +sl2;
  ul = +ul2;

  fd = +fd2;
}

// CHECK-LABEL: define dso_local void @test_neg(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[SUB:%.*]] = sub <16 x i8> zeroinitializer, [[TMP0]]
// CHECK-NEXT:    store volatile <16 x i8> [[SUB]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[SUB1:%.*]] = sub <8 x i16> zeroinitializer, [[TMP1]]
// CHECK-NEXT:    store volatile <8 x i16> [[SUB1]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[SUB2:%.*]] = sub <4 x i32> zeroinitializer, [[TMP2]]
// CHECK-NEXT:    store volatile <4 x i32> [[SUB2]], ptr @si, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[SUB3:%.*]] = sub <2 x i64> zeroinitializer, [[TMP3]]
// CHECK-NEXT:    store volatile <2 x i64> [[SUB3]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[FNEG:%.*]] = fneg <2 x double> [[TMP4]]
// CHECK-NEXT:    store volatile <2 x double> [[FNEG]], ptr @fd, align 8
// CHECK-NEXT:    ret void
//
void test_neg(void) {

  sc = -sc2;
  ss = -ss2;
  si = -si2;
  sl = -sl2;
  fd = -fd2;
}

// CHECK-LABEL: define dso_local void @test_preinc(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[INC:%.*]] = add <16 x i8> [[TMP0]], splat (i8 1)
// CHECK-NEXT:    store volatile <16 x i8> [[INC]], ptr @sc2, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[INC1:%.*]] = add <16 x i8> [[TMP1]], splat (i8 1)
// CHECK-NEXT:    store volatile <16 x i8> [[INC1]], ptr @uc2, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[INC2:%.*]] = add <8 x i16> [[TMP2]], splat (i16 1)
// CHECK-NEXT:    store volatile <8 x i16> [[INC2]], ptr @ss2, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[INC3:%.*]] = add <8 x i16> [[TMP3]], splat (i16 1)
// CHECK-NEXT:    store volatile <8 x i16> [[INC3]], ptr @us2, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[INC4:%.*]] = add <4 x i32> [[TMP4]], splat (i32 1)
// CHECK-NEXT:    store volatile <4 x i32> [[INC4]], ptr @si2, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[INC5:%.*]] = add <4 x i32> [[TMP5]], splat (i32 1)
// CHECK-NEXT:    store volatile <4 x i32> [[INC5]], ptr @ui2, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[INC6:%.*]] = add <2 x i64> [[TMP6]], splat (i64 1)
// CHECK-NEXT:    store volatile <2 x i64> [[INC6]], ptr @sl2, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[INC7:%.*]] = add <2 x i64> [[TMP7]], splat (i64 1)
// CHECK-NEXT:    store volatile <2 x i64> [[INC7]], ptr @ul2, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[INC8:%.*]] = fadd <2 x double> [[TMP8]], splat (double 1.000000e+00)
// CHECK-NEXT:    store volatile <2 x double> [[INC8]], ptr @fd2, align 8
// CHECK-NEXT:    ret void
//
void test_preinc(void) {

  ++sc2;
  ++uc2;

  ++ss2;
  ++us2;

  ++si2;
  ++ui2;

  ++sl2;
  ++ul2;

  ++fd2;
}

// CHECK-LABEL: define dso_local void @test_postinc(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[INC:%.*]] = add <16 x i8> [[TMP0]], splat (i8 1)
// CHECK-NEXT:    store volatile <16 x i8> [[INC]], ptr @sc2, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[INC1:%.*]] = add <16 x i8> [[TMP1]], splat (i8 1)
// CHECK-NEXT:    store volatile <16 x i8> [[INC1]], ptr @uc2, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[INC2:%.*]] = add <8 x i16> [[TMP2]], splat (i16 1)
// CHECK-NEXT:    store volatile <8 x i16> [[INC2]], ptr @ss2, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[INC3:%.*]] = add <8 x i16> [[TMP3]], splat (i16 1)
// CHECK-NEXT:    store volatile <8 x i16> [[INC3]], ptr @us2, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[INC4:%.*]] = add <4 x i32> [[TMP4]], splat (i32 1)
// CHECK-NEXT:    store volatile <4 x i32> [[INC4]], ptr @si2, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[INC5:%.*]] = add <4 x i32> [[TMP5]], splat (i32 1)
// CHECK-NEXT:    store volatile <4 x i32> [[INC5]], ptr @ui2, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[INC6:%.*]] = add <2 x i64> [[TMP6]], splat (i64 1)
// CHECK-NEXT:    store volatile <2 x i64> [[INC6]], ptr @sl2, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[INC7:%.*]] = add <2 x i64> [[TMP7]], splat (i64 1)
// CHECK-NEXT:    store volatile <2 x i64> [[INC7]], ptr @ul2, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[INC8:%.*]] = fadd <2 x double> [[TMP8]], splat (double 1.000000e+00)
// CHECK-NEXT:    store volatile <2 x double> [[INC8]], ptr @fd2, align 8
// CHECK-NEXT:    ret void
//
void test_postinc(void) {

  sc2++;
  uc2++;

  ss2++;
  us2++;

  si2++;
  ui2++;

  sl2++;
  ul2++;

  fd2++;
}

// CHECK-LABEL: define dso_local void @test_predec(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[DEC:%.*]] = add <16 x i8> [[TMP0]], splat (i8 -1)
// CHECK-NEXT:    store volatile <16 x i8> [[DEC]], ptr @sc2, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[DEC1:%.*]] = add <16 x i8> [[TMP1]], splat (i8 -1)
// CHECK-NEXT:    store volatile <16 x i8> [[DEC1]], ptr @uc2, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[DEC2:%.*]] = add <8 x i16> [[TMP2]], splat (i16 -1)
// CHECK-NEXT:    store volatile <8 x i16> [[DEC2]], ptr @ss2, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[DEC3:%.*]] = add <8 x i16> [[TMP3]], splat (i16 -1)
// CHECK-NEXT:    store volatile <8 x i16> [[DEC3]], ptr @us2, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[DEC4:%.*]] = add <4 x i32> [[TMP4]], splat (i32 -1)
// CHECK-NEXT:    store volatile <4 x i32> [[DEC4]], ptr @si2, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[DEC5:%.*]] = add <4 x i32> [[TMP5]], splat (i32 -1)
// CHECK-NEXT:    store volatile <4 x i32> [[DEC5]], ptr @ui2, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[DEC6:%.*]] = add <2 x i64> [[TMP6]], splat (i64 -1)
// CHECK-NEXT:    store volatile <2 x i64> [[DEC6]], ptr @sl2, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[DEC7:%.*]] = add <2 x i64> [[TMP7]], splat (i64 -1)
// CHECK-NEXT:    store volatile <2 x i64> [[DEC7]], ptr @ul2, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[DEC8:%.*]] = fadd <2 x double> [[TMP8]], splat (double -1.000000e+00)
// CHECK-NEXT:    store volatile <2 x double> [[DEC8]], ptr @fd2, align 8
// CHECK-NEXT:    ret void
//
void test_predec(void) {

  --sc2;
  --uc2;

  --ss2;
  --us2;

  --si2;
  --ui2;

  --sl2;
  --ul2;

  --fd2;
}

// CHECK-LABEL: define dso_local void @test_postdec(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[DEC:%.*]] = add <16 x i8> [[TMP0]], splat (i8 -1)
// CHECK-NEXT:    store volatile <16 x i8> [[DEC]], ptr @sc2, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[DEC1:%.*]] = add <16 x i8> [[TMP1]], splat (i8 -1)
// CHECK-NEXT:    store volatile <16 x i8> [[DEC1]], ptr @uc2, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[DEC2:%.*]] = add <8 x i16> [[TMP2]], splat (i16 -1)
// CHECK-NEXT:    store volatile <8 x i16> [[DEC2]], ptr @ss2, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[DEC3:%.*]] = add <8 x i16> [[TMP3]], splat (i16 -1)
// CHECK-NEXT:    store volatile <8 x i16> [[DEC3]], ptr @us2, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[DEC4:%.*]] = add <4 x i32> [[TMP4]], splat (i32 -1)
// CHECK-NEXT:    store volatile <4 x i32> [[DEC4]], ptr @si2, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[DEC5:%.*]] = add <4 x i32> [[TMP5]], splat (i32 -1)
// CHECK-NEXT:    store volatile <4 x i32> [[DEC5]], ptr @ui2, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[DEC6:%.*]] = add <2 x i64> [[TMP6]], splat (i64 -1)
// CHECK-NEXT:    store volatile <2 x i64> [[DEC6]], ptr @sl2, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[DEC7:%.*]] = add <2 x i64> [[TMP7]], splat (i64 -1)
// CHECK-NEXT:    store volatile <2 x i64> [[DEC7]], ptr @ul2, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[DEC8:%.*]] = fadd <2 x double> [[TMP8]], splat (double -1.000000e+00)
// CHECK-NEXT:    store volatile <2 x double> [[DEC8]], ptr @fd2, align 8
// CHECK-NEXT:    ret void
//
void test_postdec(void) {

  sc2--;
  uc2--;

  ss2--;
  us2--;

  si2--;
  ui2--;

  sl2--;
  ul2--;

  fd2--;
}

// CHECK-LABEL: define dso_local void @test_add(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[ADD:%.*]] = add <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    store volatile <16 x i8> [[ADD]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[ADD1:%.*]] = add <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    store volatile <16 x i8> [[ADD1]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[ADD2:%.*]] = add <16 x i8> [[TMP4]], [[TMP5]]
// CHECK-NEXT:    store volatile <16 x i8> [[ADD2]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[ADD3:%.*]] = add <16 x i8> [[TMP6]], [[TMP7]]
// CHECK-NEXT:    store volatile <16 x i8> [[ADD3]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[ADD4:%.*]] = add <16 x i8> [[TMP8]], [[TMP9]]
// CHECK-NEXT:    store volatile <16 x i8> [[ADD4]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[ADD5:%.*]] = add <16 x i8> [[TMP10]], [[TMP11]]
// CHECK-NEXT:    store volatile <16 x i8> [[ADD5]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[ADD6:%.*]] = add <8 x i16> [[TMP12]], [[TMP13]]
// CHECK-NEXT:    store volatile <8 x i16> [[ADD6]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[ADD7:%.*]] = add <8 x i16> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    store volatile <8 x i16> [[ADD7]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[ADD8:%.*]] = add <8 x i16> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    store volatile <8 x i16> [[ADD8]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[ADD9:%.*]] = add <8 x i16> [[TMP18]], [[TMP19]]
// CHECK-NEXT:    store volatile <8 x i16> [[ADD9]], ptr @us, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[ADD10:%.*]] = add <8 x i16> [[TMP20]], [[TMP21]]
// CHECK-NEXT:    store volatile <8 x i16> [[ADD10]], ptr @us, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[ADD11:%.*]] = add <8 x i16> [[TMP22]], [[TMP23]]
// CHECK-NEXT:    store volatile <8 x i16> [[ADD11]], ptr @us, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[ADD12:%.*]] = add <4 x i32> [[TMP24]], [[TMP25]]
// CHECK-NEXT:    store volatile <4 x i32> [[ADD12]], ptr @si, align 8
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[ADD13:%.*]] = add <4 x i32> [[TMP26]], [[TMP27]]
// CHECK-NEXT:    store volatile <4 x i32> [[ADD13]], ptr @si, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[ADD14:%.*]] = add <4 x i32> [[TMP28]], [[TMP29]]
// CHECK-NEXT:    store volatile <4 x i32> [[ADD14]], ptr @si, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[ADD15:%.*]] = add <4 x i32> [[TMP30]], [[TMP31]]
// CHECK-NEXT:    store volatile <4 x i32> [[ADD15]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[ADD16:%.*]] = add <4 x i32> [[TMP32]], [[TMP33]]
// CHECK-NEXT:    store volatile <4 x i32> [[ADD16]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[ADD17:%.*]] = add <4 x i32> [[TMP34]], [[TMP35]]
// CHECK-NEXT:    store volatile <4 x i32> [[ADD17]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[ADD18:%.*]] = add <2 x i64> [[TMP36]], [[TMP37]]
// CHECK-NEXT:    store volatile <2 x i64> [[ADD18]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[ADD19:%.*]] = add <2 x i64> [[TMP38]], [[TMP39]]
// CHECK-NEXT:    store volatile <2 x i64> [[ADD19]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP40:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP41:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[ADD20:%.*]] = add <2 x i64> [[TMP40]], [[TMP41]]
// CHECK-NEXT:    store volatile <2 x i64> [[ADD20]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP42:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[ADD21:%.*]] = add <2 x i64> [[TMP42]], [[TMP43]]
// CHECK-NEXT:    store volatile <2 x i64> [[ADD21]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP44:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[ADD22:%.*]] = add <2 x i64> [[TMP44]], [[TMP45]]
// CHECK-NEXT:    store volatile <2 x i64> [[ADD22]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP47:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[ADD23:%.*]] = add <2 x i64> [[TMP46]], [[TMP47]]
// CHECK-NEXT:    store volatile <2 x i64> [[ADD23]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP48:%.*]] = load volatile <2 x double>, ptr @fd, align 8
// CHECK-NEXT:    [[TMP49:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[ADD24:%.*]] = fadd <2 x double> [[TMP48]], [[TMP49]]
// CHECK-NEXT:    store volatile <2 x double> [[ADD24]], ptr @fd, align 8
// CHECK-NEXT:    ret void
//
void test_add(void) {

  sc = sc + sc2;
  sc = sc + bc2;
  sc = bc + sc2;
  uc = uc + uc2;
  uc = uc + bc2;
  uc = bc + uc2;

  ss = ss + ss2;
  ss = ss + bs2;
  ss = bs + ss2;
  us = us + us2;
  us = us + bs2;
  us = bs + us2;

  si = si + si2;
  si = si + bi2;
  si = bi + si2;
  ui = ui + ui2;
  ui = ui + bi2;
  ui = bi + ui2;

  sl = sl + sl2;
  sl = sl + bl2;
  sl = bl + sl2;
  ul = ul + ul2;
  ul = ul + bl2;
  ul = bl + ul2;

  fd = fd + fd2;
}

// CHECK-LABEL: define dso_local void @test_add_assign(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[ADD:%.*]] = add <16 x i8> [[TMP1]], [[TMP0]]
// CHECK-NEXT:    store volatile <16 x i8> [[ADD]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[ADD1:%.*]] = add <16 x i8> [[TMP3]], [[TMP2]]
// CHECK-NEXT:    store volatile <16 x i8> [[ADD1]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[ADD2:%.*]] = add <16 x i8> [[TMP5]], [[TMP4]]
// CHECK-NEXT:    store volatile <16 x i8> [[ADD2]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[ADD3:%.*]] = add <16 x i8> [[TMP7]], [[TMP6]]
// CHECK-NEXT:    store volatile <16 x i8> [[ADD3]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[ADD4:%.*]] = add <8 x i16> [[TMP9]], [[TMP8]]
// CHECK-NEXT:    store volatile <8 x i16> [[ADD4]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[ADD5:%.*]] = add <8 x i16> [[TMP11]], [[TMP10]]
// CHECK-NEXT:    store volatile <8 x i16> [[ADD5]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[ADD6:%.*]] = add <8 x i16> [[TMP13]], [[TMP12]]
// CHECK-NEXT:    store volatile <8 x i16> [[ADD6]], ptr @us, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[ADD7:%.*]] = add <8 x i16> [[TMP15]], [[TMP14]]
// CHECK-NEXT:    store volatile <8 x i16> [[ADD7]], ptr @us, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[ADD8:%.*]] = add <4 x i32> [[TMP17]], [[TMP16]]
// CHECK-NEXT:    store volatile <4 x i32> [[ADD8]], ptr @si, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[ADD9:%.*]] = add <4 x i32> [[TMP19]], [[TMP18]]
// CHECK-NEXT:    store volatile <4 x i32> [[ADD9]], ptr @si, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[ADD10:%.*]] = add <4 x i32> [[TMP21]], [[TMP20]]
// CHECK-NEXT:    store volatile <4 x i32> [[ADD10]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[ADD11:%.*]] = add <4 x i32> [[TMP23]], [[TMP22]]
// CHECK-NEXT:    store volatile <4 x i32> [[ADD11]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[ADD12:%.*]] = add <2 x i64> [[TMP25]], [[TMP24]]
// CHECK-NEXT:    store volatile <2 x i64> [[ADD12]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[ADD13:%.*]] = add <2 x i64> [[TMP27]], [[TMP26]]
// CHECK-NEXT:    store volatile <2 x i64> [[ADD13]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[ADD14:%.*]] = add <2 x i64> [[TMP29]], [[TMP28]]
// CHECK-NEXT:    store volatile <2 x i64> [[ADD14]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[ADD15:%.*]] = add <2 x i64> [[TMP31]], [[TMP30]]
// CHECK-NEXT:    store volatile <2 x i64> [[ADD15]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile <2 x double>, ptr @fd, align 8
// CHECK-NEXT:    [[ADD16:%.*]] = fadd <2 x double> [[TMP33]], [[TMP32]]
// CHECK-NEXT:    store volatile <2 x double> [[ADD16]], ptr @fd, align 8
// CHECK-NEXT:    ret void
//
void test_add_assign(void) {

  sc += sc2;
  sc += bc2;
  uc += uc2;
  uc += bc2;

  ss += ss2;
  ss += bs2;
  us += us2;
  us += bs2;

  si += si2;
  si += bi2;
  ui += ui2;
  ui += bi2;

  sl += sl2;
  sl += bl2;
  ul += ul2;
  ul += bl2;

  fd += fd2;
}

// CHECK-LABEL: define dso_local void @test_sub(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[SUB:%.*]] = sub <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    store volatile <16 x i8> [[SUB]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[SUB1:%.*]] = sub <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    store volatile <16 x i8> [[SUB1]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[SUB2:%.*]] = sub <16 x i8> [[TMP4]], [[TMP5]]
// CHECK-NEXT:    store volatile <16 x i8> [[SUB2]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[SUB3:%.*]] = sub <16 x i8> [[TMP6]], [[TMP7]]
// CHECK-NEXT:    store volatile <16 x i8> [[SUB3]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[SUB4:%.*]] = sub <16 x i8> [[TMP8]], [[TMP9]]
// CHECK-NEXT:    store volatile <16 x i8> [[SUB4]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[SUB5:%.*]] = sub <16 x i8> [[TMP10]], [[TMP11]]
// CHECK-NEXT:    store volatile <16 x i8> [[SUB5]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[SUB6:%.*]] = sub <8 x i16> [[TMP12]], [[TMP13]]
// CHECK-NEXT:    store volatile <8 x i16> [[SUB6]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[SUB7:%.*]] = sub <8 x i16> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    store volatile <8 x i16> [[SUB7]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[SUB8:%.*]] = sub <8 x i16> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    store volatile <8 x i16> [[SUB8]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[SUB9:%.*]] = sub <8 x i16> [[TMP18]], [[TMP19]]
// CHECK-NEXT:    store volatile <8 x i16> [[SUB9]], ptr @us, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[SUB10:%.*]] = sub <8 x i16> [[TMP20]], [[TMP21]]
// CHECK-NEXT:    store volatile <8 x i16> [[SUB10]], ptr @us, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[SUB11:%.*]] = sub <8 x i16> [[TMP22]], [[TMP23]]
// CHECK-NEXT:    store volatile <8 x i16> [[SUB11]], ptr @us, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[SUB12:%.*]] = sub <4 x i32> [[TMP24]], [[TMP25]]
// CHECK-NEXT:    store volatile <4 x i32> [[SUB12]], ptr @si, align 8
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[SUB13:%.*]] = sub <4 x i32> [[TMP26]], [[TMP27]]
// CHECK-NEXT:    store volatile <4 x i32> [[SUB13]], ptr @si, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[SUB14:%.*]] = sub <4 x i32> [[TMP28]], [[TMP29]]
// CHECK-NEXT:    store volatile <4 x i32> [[SUB14]], ptr @si, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[SUB15:%.*]] = sub <4 x i32> [[TMP30]], [[TMP31]]
// CHECK-NEXT:    store volatile <4 x i32> [[SUB15]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[SUB16:%.*]] = sub <4 x i32> [[TMP32]], [[TMP33]]
// CHECK-NEXT:    store volatile <4 x i32> [[SUB16]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[SUB17:%.*]] = sub <4 x i32> [[TMP34]], [[TMP35]]
// CHECK-NEXT:    store volatile <4 x i32> [[SUB17]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[SUB18:%.*]] = sub <2 x i64> [[TMP36]], [[TMP37]]
// CHECK-NEXT:    store volatile <2 x i64> [[SUB18]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[SUB19:%.*]] = sub <2 x i64> [[TMP38]], [[TMP39]]
// CHECK-NEXT:    store volatile <2 x i64> [[SUB19]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP40:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP41:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[SUB20:%.*]] = sub <2 x i64> [[TMP40]], [[TMP41]]
// CHECK-NEXT:    store volatile <2 x i64> [[SUB20]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP42:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[SUB21:%.*]] = sub <2 x i64> [[TMP42]], [[TMP43]]
// CHECK-NEXT:    store volatile <2 x i64> [[SUB21]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP44:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[SUB22:%.*]] = sub <2 x i64> [[TMP44]], [[TMP45]]
// CHECK-NEXT:    store volatile <2 x i64> [[SUB22]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP47:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[SUB23:%.*]] = sub <2 x i64> [[TMP46]], [[TMP47]]
// CHECK-NEXT:    store volatile <2 x i64> [[SUB23]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP48:%.*]] = load volatile <2 x double>, ptr @fd, align 8
// CHECK-NEXT:    [[TMP49:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[SUB24:%.*]] = fsub <2 x double> [[TMP48]], [[TMP49]]
// CHECK-NEXT:    store volatile <2 x double> [[SUB24]], ptr @fd, align 8
// CHECK-NEXT:    ret void
//
void test_sub(void) {

  sc = sc - sc2;
  sc = sc - bc2;
  sc = bc - sc2;
  uc = uc - uc2;
  uc = uc - bc2;
  uc = bc - uc2;

  ss = ss - ss2;
  ss = ss - bs2;
  ss = bs - ss2;
  us = us - us2;
  us = us - bs2;
  us = bs - us2;

  si = si - si2;
  si = si - bi2;
  si = bi - si2;
  ui = ui - ui2;
  ui = ui - bi2;
  ui = bi - ui2;

  sl = sl - sl2;
  sl = sl - bl2;
  sl = bl - sl2;
  ul = ul - ul2;
  ul = ul - bl2;
  ul = bl - ul2;

  fd = fd - fd2;
}

// CHECK-LABEL: define dso_local void @test_sub_assign(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[SUB:%.*]] = sub <16 x i8> [[TMP1]], [[TMP0]]
// CHECK-NEXT:    store volatile <16 x i8> [[SUB]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[SUB1:%.*]] = sub <16 x i8> [[TMP3]], [[TMP2]]
// CHECK-NEXT:    store volatile <16 x i8> [[SUB1]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[SUB2:%.*]] = sub <16 x i8> [[TMP5]], [[TMP4]]
// CHECK-NEXT:    store volatile <16 x i8> [[SUB2]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[SUB3:%.*]] = sub <16 x i8> [[TMP7]], [[TMP6]]
// CHECK-NEXT:    store volatile <16 x i8> [[SUB3]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[SUB4:%.*]] = sub <8 x i16> [[TMP9]], [[TMP8]]
// CHECK-NEXT:    store volatile <8 x i16> [[SUB4]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[SUB5:%.*]] = sub <8 x i16> [[TMP11]], [[TMP10]]
// CHECK-NEXT:    store volatile <8 x i16> [[SUB5]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[SUB6:%.*]] = sub <8 x i16> [[TMP13]], [[TMP12]]
// CHECK-NEXT:    store volatile <8 x i16> [[SUB6]], ptr @us, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[SUB7:%.*]] = sub <8 x i16> [[TMP15]], [[TMP14]]
// CHECK-NEXT:    store volatile <8 x i16> [[SUB7]], ptr @us, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[SUB8:%.*]] = sub <4 x i32> [[TMP17]], [[TMP16]]
// CHECK-NEXT:    store volatile <4 x i32> [[SUB8]], ptr @si, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[SUB9:%.*]] = sub <4 x i32> [[TMP19]], [[TMP18]]
// CHECK-NEXT:    store volatile <4 x i32> [[SUB9]], ptr @si, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[SUB10:%.*]] = sub <4 x i32> [[TMP21]], [[TMP20]]
// CHECK-NEXT:    store volatile <4 x i32> [[SUB10]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[SUB11:%.*]] = sub <4 x i32> [[TMP23]], [[TMP22]]
// CHECK-NEXT:    store volatile <4 x i32> [[SUB11]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[SUB12:%.*]] = sub <2 x i64> [[TMP25]], [[TMP24]]
// CHECK-NEXT:    store volatile <2 x i64> [[SUB12]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[SUB13:%.*]] = sub <2 x i64> [[TMP27]], [[TMP26]]
// CHECK-NEXT:    store volatile <2 x i64> [[SUB13]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[SUB14:%.*]] = sub <2 x i64> [[TMP29]], [[TMP28]]
// CHECK-NEXT:    store volatile <2 x i64> [[SUB14]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[SUB15:%.*]] = sub <2 x i64> [[TMP31]], [[TMP30]]
// CHECK-NEXT:    store volatile <2 x i64> [[SUB15]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile <2 x double>, ptr @fd, align 8
// CHECK-NEXT:    [[SUB16:%.*]] = fsub <2 x double> [[TMP33]], [[TMP32]]
// CHECK-NEXT:    store volatile <2 x double> [[SUB16]], ptr @fd, align 8
// CHECK-NEXT:    ret void
//
void test_sub_assign(void) {

  sc -= sc2;
  sc -= bc2;
  uc -= uc2;
  uc -= bc2;

  ss -= ss2;
  ss -= bs2;
  us -= us2;
  us -= bs2;

  si -= si2;
  si -= bi2;
  ui -= ui2;
  ui -= bi2;

  sl -= sl2;
  sl -= bl2;
  ul -= ul2;
  ul -= bl2;

  fd -= fd2;
}

// CHECK-LABEL: define dso_local void @test_mul(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[MUL:%.*]] = mul <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    store volatile <16 x i8> [[MUL]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[MUL1:%.*]] = mul <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    store volatile <16 x i8> [[MUL1]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[MUL2:%.*]] = mul <8 x i16> [[TMP4]], [[TMP5]]
// CHECK-NEXT:    store volatile <8 x i16> [[MUL2]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[MUL3:%.*]] = mul <8 x i16> [[TMP6]], [[TMP7]]
// CHECK-NEXT:    store volatile <8 x i16> [[MUL3]], ptr @us, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[MUL4:%.*]] = mul <4 x i32> [[TMP8]], [[TMP9]]
// CHECK-NEXT:    store volatile <4 x i32> [[MUL4]], ptr @si, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[MUL5:%.*]] = mul <4 x i32> [[TMP10]], [[TMP11]]
// CHECK-NEXT:    store volatile <4 x i32> [[MUL5]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[MUL6:%.*]] = mul <2 x i64> [[TMP12]], [[TMP13]]
// CHECK-NEXT:    store volatile <2 x i64> [[MUL6]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[MUL7:%.*]] = mul <2 x i64> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    store volatile <2 x i64> [[MUL7]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <2 x double>, ptr @fd, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[MUL8:%.*]] = fmul <2 x double> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    store volatile <2 x double> [[MUL8]], ptr @fd, align 8
// CHECK-NEXT:    ret void
//
void test_mul(void) {

  sc = sc * sc2;
  uc = uc * uc2;

  ss = ss * ss2;
  us = us * us2;

  si = si * si2;
  ui = ui * ui2;

  sl = sl * sl2;
  ul = ul * ul2;

  fd = fd * fd2;
}

// CHECK-LABEL: define dso_local void @test_mul_assign(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[MUL:%.*]] = mul <16 x i8> [[TMP1]], [[TMP0]]
// CHECK-NEXT:    store volatile <16 x i8> [[MUL]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[MUL1:%.*]] = mul <16 x i8> [[TMP3]], [[TMP2]]
// CHECK-NEXT:    store volatile <16 x i8> [[MUL1]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[MUL2:%.*]] = mul <8 x i16> [[TMP5]], [[TMP4]]
// CHECK-NEXT:    store volatile <8 x i16> [[MUL2]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[MUL3:%.*]] = mul <8 x i16> [[TMP7]], [[TMP6]]
// CHECK-NEXT:    store volatile <8 x i16> [[MUL3]], ptr @us, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[MUL4:%.*]] = mul <4 x i32> [[TMP9]], [[TMP8]]
// CHECK-NEXT:    store volatile <4 x i32> [[MUL4]], ptr @si, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[MUL5:%.*]] = mul <4 x i32> [[TMP11]], [[TMP10]]
// CHECK-NEXT:    store volatile <4 x i32> [[MUL5]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[MUL6:%.*]] = mul <2 x i64> [[TMP13]], [[TMP12]]
// CHECK-NEXT:    store volatile <2 x i64> [[MUL6]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[MUL7:%.*]] = mul <2 x i64> [[TMP15]], [[TMP14]]
// CHECK-NEXT:    store volatile <2 x i64> [[MUL7]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <2 x double>, ptr @fd, align 8
// CHECK-NEXT:    [[MUL8:%.*]] = fmul <2 x double> [[TMP17]], [[TMP16]]
// CHECK-NEXT:    store volatile <2 x double> [[MUL8]], ptr @fd, align 8
// CHECK-NEXT:    ret void
//
void test_mul_assign(void) {

  sc *= sc2;
  uc *= uc2;

  ss *= ss2;
  us *= us2;

  si *= si2;
  ui *= ui2;

  sl *= sl2;
  ul *= ul2;

  fd *= fd2;
}

// CHECK-LABEL: define dso_local void @test_div(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[DIV:%.*]] = sdiv <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    store volatile <16 x i8> [[DIV]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[DIV1:%.*]] = udiv <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    store volatile <16 x i8> [[DIV1]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[DIV2:%.*]] = sdiv <8 x i16> [[TMP4]], [[TMP5]]
// CHECK-NEXT:    store volatile <8 x i16> [[DIV2]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[DIV3:%.*]] = udiv <8 x i16> [[TMP6]], [[TMP7]]
// CHECK-NEXT:    store volatile <8 x i16> [[DIV3]], ptr @us, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[DIV4:%.*]] = sdiv <4 x i32> [[TMP8]], [[TMP9]]
// CHECK-NEXT:    store volatile <4 x i32> [[DIV4]], ptr @si, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[DIV5:%.*]] = udiv <4 x i32> [[TMP10]], [[TMP11]]
// CHECK-NEXT:    store volatile <4 x i32> [[DIV5]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[DIV6:%.*]] = sdiv <2 x i64> [[TMP12]], [[TMP13]]
// CHECK-NEXT:    store volatile <2 x i64> [[DIV6]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[DIV7:%.*]] = udiv <2 x i64> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    store volatile <2 x i64> [[DIV7]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <2 x double>, ptr @fd, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[DIV8:%.*]] = fdiv <2 x double> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    store volatile <2 x double> [[DIV8]], ptr @fd, align 8
// CHECK-NEXT:    ret void
//
void test_div(void) {

  sc = sc / sc2;
  uc = uc / uc2;

  ss = ss / ss2;
  us = us / us2;

  si = si / si2;
  ui = ui / ui2;

  sl = sl / sl2;
  ul = ul / ul2;

  fd = fd / fd2;
}

// CHECK-LABEL: define dso_local void @test_div_assign(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[DIV:%.*]] = sdiv <16 x i8> [[TMP1]], [[TMP0]]
// CHECK-NEXT:    store volatile <16 x i8> [[DIV]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[DIV1:%.*]] = udiv <16 x i8> [[TMP3]], [[TMP2]]
// CHECK-NEXT:    store volatile <16 x i8> [[DIV1]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[DIV2:%.*]] = sdiv <8 x i16> [[TMP5]], [[TMP4]]
// CHECK-NEXT:    store volatile <8 x i16> [[DIV2]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[DIV3:%.*]] = udiv <8 x i16> [[TMP7]], [[TMP6]]
// CHECK-NEXT:    store volatile <8 x i16> [[DIV3]], ptr @us, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[DIV4:%.*]] = sdiv <4 x i32> [[TMP9]], [[TMP8]]
// CHECK-NEXT:    store volatile <4 x i32> [[DIV4]], ptr @si, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[DIV5:%.*]] = udiv <4 x i32> [[TMP11]], [[TMP10]]
// CHECK-NEXT:    store volatile <4 x i32> [[DIV5]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[DIV6:%.*]] = sdiv <2 x i64> [[TMP13]], [[TMP12]]
// CHECK-NEXT:    store volatile <2 x i64> [[DIV6]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[DIV7:%.*]] = udiv <2 x i64> [[TMP15]], [[TMP14]]
// CHECK-NEXT:    store volatile <2 x i64> [[DIV7]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <2 x double>, ptr @fd, align 8
// CHECK-NEXT:    [[DIV8:%.*]] = fdiv <2 x double> [[TMP17]], [[TMP16]]
// CHECK-NEXT:    store volatile <2 x double> [[DIV8]], ptr @fd, align 8
// CHECK-NEXT:    ret void
//
void test_div_assign(void) {

  sc /= sc2;
  uc /= uc2;

  ss /= ss2;
  us /= us2;

  si /= si2;
  ui /= ui2;

  sl /= sl2;
  ul /= ul2;

  fd /= fd2;
}

// CHECK-LABEL: define dso_local void @test_rem(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[REM:%.*]] = srem <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    store volatile <16 x i8> [[REM]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[REM1:%.*]] = urem <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    store volatile <16 x i8> [[REM1]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[REM2:%.*]] = srem <8 x i16> [[TMP4]], [[TMP5]]
// CHECK-NEXT:    store volatile <8 x i16> [[REM2]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[REM3:%.*]] = urem <8 x i16> [[TMP6]], [[TMP7]]
// CHECK-NEXT:    store volatile <8 x i16> [[REM3]], ptr @us, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[REM4:%.*]] = srem <4 x i32> [[TMP8]], [[TMP9]]
// CHECK-NEXT:    store volatile <4 x i32> [[REM4]], ptr @si, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[REM5:%.*]] = urem <4 x i32> [[TMP10]], [[TMP11]]
// CHECK-NEXT:    store volatile <4 x i32> [[REM5]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[REM6:%.*]] = srem <2 x i64> [[TMP12]], [[TMP13]]
// CHECK-NEXT:    store volatile <2 x i64> [[REM6]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[REM7:%.*]] = urem <2 x i64> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    store volatile <2 x i64> [[REM7]], ptr @ul, align 8
// CHECK-NEXT:    ret void
//
void test_rem(void) {

  sc = sc % sc2;
  uc = uc % uc2;

  ss = ss % ss2;
  us = us % us2;

  si = si % si2;
  ui = ui % ui2;

  sl = sl % sl2;
  ul = ul % ul2;
}

// CHECK-LABEL: define dso_local void @test_rem_assign(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[REM:%.*]] = srem <16 x i8> [[TMP1]], [[TMP0]]
// CHECK-NEXT:    store volatile <16 x i8> [[REM]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[REM1:%.*]] = urem <16 x i8> [[TMP3]], [[TMP2]]
// CHECK-NEXT:    store volatile <16 x i8> [[REM1]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[REM2:%.*]] = srem <8 x i16> [[TMP5]], [[TMP4]]
// CHECK-NEXT:    store volatile <8 x i16> [[REM2]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[REM3:%.*]] = urem <8 x i16> [[TMP7]], [[TMP6]]
// CHECK-NEXT:    store volatile <8 x i16> [[REM3]], ptr @us, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[REM4:%.*]] = srem <4 x i32> [[TMP9]], [[TMP8]]
// CHECK-NEXT:    store volatile <4 x i32> [[REM4]], ptr @si, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[REM5:%.*]] = urem <4 x i32> [[TMP11]], [[TMP10]]
// CHECK-NEXT:    store volatile <4 x i32> [[REM5]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[REM6:%.*]] = srem <2 x i64> [[TMP13]], [[TMP12]]
// CHECK-NEXT:    store volatile <2 x i64> [[REM6]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[REM7:%.*]] = urem <2 x i64> [[TMP15]], [[TMP14]]
// CHECK-NEXT:    store volatile <2 x i64> [[REM7]], ptr @ul, align 8
// CHECK-NEXT:    ret void
//
void test_rem_assign(void) {

  sc %= sc2;
  uc %= uc2;

  ss %= ss2;
  us %= us2;

  si %= si2;
  ui %= ui2;

  sl %= sl2;
  ul %= ul2;
}

// CHECK-LABEL: define dso_local void @test_not(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[NOT:%.*]] = xor <16 x i8> [[TMP0]], splat (i8 -1)
// CHECK-NEXT:    store volatile <16 x i8> [[NOT]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[NOT1:%.*]] = xor <16 x i8> [[TMP1]], splat (i8 -1)
// CHECK-NEXT:    store volatile <16 x i8> [[NOT1]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[NOT2:%.*]] = xor <16 x i8> [[TMP2]], splat (i8 -1)
// CHECK-NEXT:    store volatile <16 x i8> [[NOT2]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[NOT3:%.*]] = xor <8 x i16> [[TMP3]], splat (i16 -1)
// CHECK-NEXT:    store volatile <8 x i16> [[NOT3]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[NOT4:%.*]] = xor <8 x i16> [[TMP4]], splat (i16 -1)
// CHECK-NEXT:    store volatile <8 x i16> [[NOT4]], ptr @us, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[NOT5:%.*]] = xor <8 x i16> [[TMP5]], splat (i16 -1)
// CHECK-NEXT:    store volatile <8 x i16> [[NOT5]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[NOT6:%.*]] = xor <4 x i32> [[TMP6]], splat (i32 -1)
// CHECK-NEXT:    store volatile <4 x i32> [[NOT6]], ptr @si, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[NOT7:%.*]] = xor <4 x i32> [[TMP7]], splat (i32 -1)
// CHECK-NEXT:    store volatile <4 x i32> [[NOT7]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[NOT8:%.*]] = xor <4 x i32> [[TMP8]], splat (i32 -1)
// CHECK-NEXT:    store volatile <4 x i32> [[NOT8]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[NOT9:%.*]] = xor <2 x i64> [[TMP9]], splat (i64 -1)
// CHECK-NEXT:    store volatile <2 x i64> [[NOT9]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[NOT10:%.*]] = xor <2 x i64> [[TMP10]], splat (i64 -1)
// CHECK-NEXT:    store volatile <2 x i64> [[NOT10]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[NOT11:%.*]] = xor <2 x i64> [[TMP11]], splat (i64 -1)
// CHECK-NEXT:    store volatile <2 x i64> [[NOT11]], ptr @bl, align 8
// CHECK-NEXT:    ret void
//
void test_not(void) {

  sc = ~sc2;
  uc = ~uc2;
  bc = ~bc2;

  ss = ~ss2;
  us = ~us2;
  bs = ~bs2;

  si = ~si2;
  ui = ~ui2;
  bi = ~bi2;

  sl = ~sl2;
  ul = ~ul2;
  bl = ~bl2;
}

// CHECK-LABEL: define dso_local void @test_and(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[AND:%.*]] = and <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    store volatile <16 x i8> [[AND]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[AND1:%.*]] = and <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    store volatile <16 x i8> [[AND1]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[AND2:%.*]] = and <16 x i8> [[TMP4]], [[TMP5]]
// CHECK-NEXT:    store volatile <16 x i8> [[AND2]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[AND3:%.*]] = and <16 x i8> [[TMP6]], [[TMP7]]
// CHECK-NEXT:    store volatile <16 x i8> [[AND3]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[AND4:%.*]] = and <16 x i8> [[TMP8]], [[TMP9]]
// CHECK-NEXT:    store volatile <16 x i8> [[AND4]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[AND5:%.*]] = and <16 x i8> [[TMP10]], [[TMP11]]
// CHECK-NEXT:    store volatile <16 x i8> [[AND5]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[AND6:%.*]] = and <16 x i8> [[TMP12]], [[TMP13]]
// CHECK-NEXT:    store volatile <16 x i8> [[AND6]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[AND7:%.*]] = and <8 x i16> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    store volatile <8 x i16> [[AND7]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[AND8:%.*]] = and <8 x i16> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    store volatile <8 x i16> [[AND8]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[AND9:%.*]] = and <8 x i16> [[TMP18]], [[TMP19]]
// CHECK-NEXT:    store volatile <8 x i16> [[AND9]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[AND10:%.*]] = and <8 x i16> [[TMP20]], [[TMP21]]
// CHECK-NEXT:    store volatile <8 x i16> [[AND10]], ptr @us, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[AND11:%.*]] = and <8 x i16> [[TMP22]], [[TMP23]]
// CHECK-NEXT:    store volatile <8 x i16> [[AND11]], ptr @us, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[AND12:%.*]] = and <8 x i16> [[TMP24]], [[TMP25]]
// CHECK-NEXT:    store volatile <8 x i16> [[AND12]], ptr @us, align 8
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[AND13:%.*]] = and <8 x i16> [[TMP26]], [[TMP27]]
// CHECK-NEXT:    store volatile <8 x i16> [[AND13]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[AND14:%.*]] = and <4 x i32> [[TMP28]], [[TMP29]]
// CHECK-NEXT:    store volatile <4 x i32> [[AND14]], ptr @si, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[AND15:%.*]] = and <4 x i32> [[TMP30]], [[TMP31]]
// CHECK-NEXT:    store volatile <4 x i32> [[AND15]], ptr @si, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[AND16:%.*]] = and <4 x i32> [[TMP32]], [[TMP33]]
// CHECK-NEXT:    store volatile <4 x i32> [[AND16]], ptr @si, align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[AND17:%.*]] = and <4 x i32> [[TMP34]], [[TMP35]]
// CHECK-NEXT:    store volatile <4 x i32> [[AND17]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[AND18:%.*]] = and <4 x i32> [[TMP36]], [[TMP37]]
// CHECK-NEXT:    store volatile <4 x i32> [[AND18]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[AND19:%.*]] = and <4 x i32> [[TMP38]], [[TMP39]]
// CHECK-NEXT:    store volatile <4 x i32> [[AND19]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP40:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP41:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[AND20:%.*]] = and <4 x i32> [[TMP40]], [[TMP41]]
// CHECK-NEXT:    store volatile <4 x i32> [[AND20]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP42:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[AND21:%.*]] = and <2 x i64> [[TMP42]], [[TMP43]]
// CHECK-NEXT:    store volatile <2 x i64> [[AND21]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP44:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[AND22:%.*]] = and <2 x i64> [[TMP44]], [[TMP45]]
// CHECK-NEXT:    store volatile <2 x i64> [[AND22]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP47:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[AND23:%.*]] = and <2 x i64> [[TMP46]], [[TMP47]]
// CHECK-NEXT:    store volatile <2 x i64> [[AND23]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP48:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP49:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[AND24:%.*]] = and <2 x i64> [[TMP48]], [[TMP49]]
// CHECK-NEXT:    store volatile <2 x i64> [[AND24]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP50:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP51:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[AND25:%.*]] = and <2 x i64> [[TMP50]], [[TMP51]]
// CHECK-NEXT:    store volatile <2 x i64> [[AND25]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP52:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[AND26:%.*]] = and <2 x i64> [[TMP52]], [[TMP53]]
// CHECK-NEXT:    store volatile <2 x i64> [[AND26]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[AND27:%.*]] = and <2 x i64> [[TMP54]], [[TMP55]]
// CHECK-NEXT:    store volatile <2 x i64> [[AND27]], ptr @bl, align 8
// CHECK-NEXT:    ret void
//
void test_and(void) {

  sc = sc & sc2;
  sc = sc & bc2;
  sc = bc & sc2;
  uc = uc & uc2;
  uc = uc & bc2;
  uc = bc & uc2;
  bc = bc & bc2;

  ss = ss & ss2;
  ss = ss & bs2;
  ss = bs & ss2;
  us = us & us2;
  us = us & bs2;
  us = bs & us2;
  bs = bs & bs2;

  si = si & si2;
  si = si & bi2;
  si = bi & si2;
  ui = ui & ui2;
  ui = ui & bi2;
  ui = bi & ui2;
  bi = bi & bi2;

  sl = sl & sl2;
  sl = sl & bl2;
  sl = bl & sl2;
  ul = ul & ul2;
  ul = ul & bl2;
  ul = bl & ul2;
  bl = bl & bl2;
}

// CHECK-LABEL: define dso_local void @test_and_assign(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[AND:%.*]] = and <16 x i8> [[TMP1]], [[TMP0]]
// CHECK-NEXT:    store volatile <16 x i8> [[AND]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[AND1:%.*]] = and <16 x i8> [[TMP3]], [[TMP2]]
// CHECK-NEXT:    store volatile <16 x i8> [[AND1]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[AND2:%.*]] = and <16 x i8> [[TMP5]], [[TMP4]]
// CHECK-NEXT:    store volatile <16 x i8> [[AND2]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[AND3:%.*]] = and <16 x i8> [[TMP7]], [[TMP6]]
// CHECK-NEXT:    store volatile <16 x i8> [[AND3]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[AND4:%.*]] = and <16 x i8> [[TMP9]], [[TMP8]]
// CHECK-NEXT:    store volatile <16 x i8> [[AND4]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[AND5:%.*]] = and <8 x i16> [[TMP11]], [[TMP10]]
// CHECK-NEXT:    store volatile <8 x i16> [[AND5]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[AND6:%.*]] = and <8 x i16> [[TMP13]], [[TMP12]]
// CHECK-NEXT:    store volatile <8 x i16> [[AND6]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[AND7:%.*]] = and <8 x i16> [[TMP15]], [[TMP14]]
// CHECK-NEXT:    store volatile <8 x i16> [[AND7]], ptr @us, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[AND8:%.*]] = and <8 x i16> [[TMP17]], [[TMP16]]
// CHECK-NEXT:    store volatile <8 x i16> [[AND8]], ptr @us, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[AND9:%.*]] = and <8 x i16> [[TMP19]], [[TMP18]]
// CHECK-NEXT:    store volatile <8 x i16> [[AND9]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[AND10:%.*]] = and <4 x i32> [[TMP21]], [[TMP20]]
// CHECK-NEXT:    store volatile <4 x i32> [[AND10]], ptr @si, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[AND11:%.*]] = and <4 x i32> [[TMP23]], [[TMP22]]
// CHECK-NEXT:    store volatile <4 x i32> [[AND11]], ptr @si, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[AND12:%.*]] = and <4 x i32> [[TMP25]], [[TMP24]]
// CHECK-NEXT:    store volatile <4 x i32> [[AND12]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[AND13:%.*]] = and <4 x i32> [[TMP27]], [[TMP26]]
// CHECK-NEXT:    store volatile <4 x i32> [[AND13]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[AND14:%.*]] = and <4 x i32> [[TMP29]], [[TMP28]]
// CHECK-NEXT:    store volatile <4 x i32> [[AND14]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[AND15:%.*]] = and <2 x i64> [[TMP31]], [[TMP30]]
// CHECK-NEXT:    store volatile <2 x i64> [[AND15]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[AND16:%.*]] = and <2 x i64> [[TMP33]], [[TMP32]]
// CHECK-NEXT:    store volatile <2 x i64> [[AND16]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[AND17:%.*]] = and <2 x i64> [[TMP35]], [[TMP34]]
// CHECK-NEXT:    store volatile <2 x i64> [[AND17]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[AND18:%.*]] = and <2 x i64> [[TMP37]], [[TMP36]]
// CHECK-NEXT:    store volatile <2 x i64> [[AND18]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[AND19:%.*]] = and <2 x i64> [[TMP39]], [[TMP38]]
// CHECK-NEXT:    store volatile <2 x i64> [[AND19]], ptr @bl, align 8
// CHECK-NEXT:    ret void
//
void test_and_assign(void) {

  sc &= sc2;
  sc &= bc2;
  uc &= uc2;
  uc &= bc2;
  bc &= bc2;

  ss &= ss2;
  ss &= bs2;
  us &= us2;
  us &= bs2;
  bs &= bs2;

  si &= si2;
  si &= bi2;
  ui &= ui2;
  ui &= bi2;
  bi &= bi2;

  sl &= sl2;
  sl &= bl2;
  ul &= ul2;
  ul &= bl2;
  bl &= bl2;
}

// CHECK-LABEL: define dso_local void @test_or(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[OR:%.*]] = or <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    store volatile <16 x i8> [[OR]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[OR1:%.*]] = or <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    store volatile <16 x i8> [[OR1]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[OR2:%.*]] = or <16 x i8> [[TMP4]], [[TMP5]]
// CHECK-NEXT:    store volatile <16 x i8> [[OR2]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[OR3:%.*]] = or <16 x i8> [[TMP6]], [[TMP7]]
// CHECK-NEXT:    store volatile <16 x i8> [[OR3]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[OR4:%.*]] = or <16 x i8> [[TMP8]], [[TMP9]]
// CHECK-NEXT:    store volatile <16 x i8> [[OR4]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[OR5:%.*]] = or <16 x i8> [[TMP10]], [[TMP11]]
// CHECK-NEXT:    store volatile <16 x i8> [[OR5]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[OR6:%.*]] = or <16 x i8> [[TMP12]], [[TMP13]]
// CHECK-NEXT:    store volatile <16 x i8> [[OR6]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[OR7:%.*]] = or <8 x i16> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    store volatile <8 x i16> [[OR7]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[OR8:%.*]] = or <8 x i16> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    store volatile <8 x i16> [[OR8]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[OR9:%.*]] = or <8 x i16> [[TMP18]], [[TMP19]]
// CHECK-NEXT:    store volatile <8 x i16> [[OR9]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[OR10:%.*]] = or <8 x i16> [[TMP20]], [[TMP21]]
// CHECK-NEXT:    store volatile <8 x i16> [[OR10]], ptr @us, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[OR11:%.*]] = or <8 x i16> [[TMP22]], [[TMP23]]
// CHECK-NEXT:    store volatile <8 x i16> [[OR11]], ptr @us, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[OR12:%.*]] = or <8 x i16> [[TMP24]], [[TMP25]]
// CHECK-NEXT:    store volatile <8 x i16> [[OR12]], ptr @us, align 8
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[OR13:%.*]] = or <8 x i16> [[TMP26]], [[TMP27]]
// CHECK-NEXT:    store volatile <8 x i16> [[OR13]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[OR14:%.*]] = or <4 x i32> [[TMP28]], [[TMP29]]
// CHECK-NEXT:    store volatile <4 x i32> [[OR14]], ptr @si, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[OR15:%.*]] = or <4 x i32> [[TMP30]], [[TMP31]]
// CHECK-NEXT:    store volatile <4 x i32> [[OR15]], ptr @si, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[OR16:%.*]] = or <4 x i32> [[TMP32]], [[TMP33]]
// CHECK-NEXT:    store volatile <4 x i32> [[OR16]], ptr @si, align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[OR17:%.*]] = or <4 x i32> [[TMP34]], [[TMP35]]
// CHECK-NEXT:    store volatile <4 x i32> [[OR17]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[OR18:%.*]] = or <4 x i32> [[TMP36]], [[TMP37]]
// CHECK-NEXT:    store volatile <4 x i32> [[OR18]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[OR19:%.*]] = or <4 x i32> [[TMP38]], [[TMP39]]
// CHECK-NEXT:    store volatile <4 x i32> [[OR19]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP40:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP41:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[OR20:%.*]] = or <4 x i32> [[TMP40]], [[TMP41]]
// CHECK-NEXT:    store volatile <4 x i32> [[OR20]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP42:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[OR21:%.*]] = or <2 x i64> [[TMP42]], [[TMP43]]
// CHECK-NEXT:    store volatile <2 x i64> [[OR21]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP44:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[OR22:%.*]] = or <2 x i64> [[TMP44]], [[TMP45]]
// CHECK-NEXT:    store volatile <2 x i64> [[OR22]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP47:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[OR23:%.*]] = or <2 x i64> [[TMP46]], [[TMP47]]
// CHECK-NEXT:    store volatile <2 x i64> [[OR23]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP48:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP49:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[OR24:%.*]] = or <2 x i64> [[TMP48]], [[TMP49]]
// CHECK-NEXT:    store volatile <2 x i64> [[OR24]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP50:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP51:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[OR25:%.*]] = or <2 x i64> [[TMP50]], [[TMP51]]
// CHECK-NEXT:    store volatile <2 x i64> [[OR25]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP52:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[OR26:%.*]] = or <2 x i64> [[TMP52]], [[TMP53]]
// CHECK-NEXT:    store volatile <2 x i64> [[OR26]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[OR27:%.*]] = or <2 x i64> [[TMP54]], [[TMP55]]
// CHECK-NEXT:    store volatile <2 x i64> [[OR27]], ptr @bl, align 8
// CHECK-NEXT:    ret void
//
void test_or(void) {

  sc = sc | sc2;
  sc = sc | bc2;
  sc = bc | sc2;
  uc = uc | uc2;
  uc = uc | bc2;
  uc = bc | uc2;
  bc = bc | bc2;

  ss = ss | ss2;
  ss = ss | bs2;
  ss = bs | ss2;
  us = us | us2;
  us = us | bs2;
  us = bs | us2;
  bs = bs | bs2;

  si = si | si2;
  si = si | bi2;
  si = bi | si2;
  ui = ui | ui2;
  ui = ui | bi2;
  ui = bi | ui2;
  bi = bi | bi2;

  sl = sl | sl2;
  sl = sl | bl2;
  sl = bl | sl2;
  ul = ul | ul2;
  ul = ul | bl2;
  ul = bl | ul2;
  bl = bl | bl2;
}

// CHECK-LABEL: define dso_local void @test_or_assign(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[OR:%.*]] = or <16 x i8> [[TMP1]], [[TMP0]]
// CHECK-NEXT:    store volatile <16 x i8> [[OR]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[OR1:%.*]] = or <16 x i8> [[TMP3]], [[TMP2]]
// CHECK-NEXT:    store volatile <16 x i8> [[OR1]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[OR2:%.*]] = or <16 x i8> [[TMP5]], [[TMP4]]
// CHECK-NEXT:    store volatile <16 x i8> [[OR2]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[OR3:%.*]] = or <16 x i8> [[TMP7]], [[TMP6]]
// CHECK-NEXT:    store volatile <16 x i8> [[OR3]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[OR4:%.*]] = or <16 x i8> [[TMP9]], [[TMP8]]
// CHECK-NEXT:    store volatile <16 x i8> [[OR4]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[OR5:%.*]] = or <8 x i16> [[TMP11]], [[TMP10]]
// CHECK-NEXT:    store volatile <8 x i16> [[OR5]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[OR6:%.*]] = or <8 x i16> [[TMP13]], [[TMP12]]
// CHECK-NEXT:    store volatile <8 x i16> [[OR6]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[OR7:%.*]] = or <8 x i16> [[TMP15]], [[TMP14]]
// CHECK-NEXT:    store volatile <8 x i16> [[OR7]], ptr @us, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[OR8:%.*]] = or <8 x i16> [[TMP17]], [[TMP16]]
// CHECK-NEXT:    store volatile <8 x i16> [[OR8]], ptr @us, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[OR9:%.*]] = or <8 x i16> [[TMP19]], [[TMP18]]
// CHECK-NEXT:    store volatile <8 x i16> [[OR9]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[OR10:%.*]] = or <4 x i32> [[TMP21]], [[TMP20]]
// CHECK-NEXT:    store volatile <4 x i32> [[OR10]], ptr @si, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[OR11:%.*]] = or <4 x i32> [[TMP23]], [[TMP22]]
// CHECK-NEXT:    store volatile <4 x i32> [[OR11]], ptr @si, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[OR12:%.*]] = or <4 x i32> [[TMP25]], [[TMP24]]
// CHECK-NEXT:    store volatile <4 x i32> [[OR12]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[OR13:%.*]] = or <4 x i32> [[TMP27]], [[TMP26]]
// CHECK-NEXT:    store volatile <4 x i32> [[OR13]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[OR14:%.*]] = or <4 x i32> [[TMP29]], [[TMP28]]
// CHECK-NEXT:    store volatile <4 x i32> [[OR14]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[OR15:%.*]] = or <2 x i64> [[TMP31]], [[TMP30]]
// CHECK-NEXT:    store volatile <2 x i64> [[OR15]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[OR16:%.*]] = or <2 x i64> [[TMP33]], [[TMP32]]
// CHECK-NEXT:    store volatile <2 x i64> [[OR16]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[OR17:%.*]] = or <2 x i64> [[TMP35]], [[TMP34]]
// CHECK-NEXT:    store volatile <2 x i64> [[OR17]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[OR18:%.*]] = or <2 x i64> [[TMP37]], [[TMP36]]
// CHECK-NEXT:    store volatile <2 x i64> [[OR18]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[OR19:%.*]] = or <2 x i64> [[TMP39]], [[TMP38]]
// CHECK-NEXT:    store volatile <2 x i64> [[OR19]], ptr @bl, align 8
// CHECK-NEXT:    ret void
//
void test_or_assign(void) {

  sc |= sc2;
  sc |= bc2;
  uc |= uc2;
  uc |= bc2;
  bc |= bc2;

  ss |= ss2;
  ss |= bs2;
  us |= us2;
  us |= bs2;
  bs |= bs2;

  si |= si2;
  si |= bi2;
  ui |= ui2;
  ui |= bi2;
  bi |= bi2;

  sl |= sl2;
  sl |= bl2;
  ul |= ul2;
  ul |= bl2;
  bl |= bl2;
}

// CHECK-LABEL: define dso_local void @test_xor(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[XOR:%.*]] = xor <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    store volatile <16 x i8> [[XOR]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[XOR1:%.*]] = xor <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    store volatile <16 x i8> [[XOR1]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[XOR2:%.*]] = xor <16 x i8> [[TMP4]], [[TMP5]]
// CHECK-NEXT:    store volatile <16 x i8> [[XOR2]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[XOR3:%.*]] = xor <16 x i8> [[TMP6]], [[TMP7]]
// CHECK-NEXT:    store volatile <16 x i8> [[XOR3]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[XOR4:%.*]] = xor <16 x i8> [[TMP8]], [[TMP9]]
// CHECK-NEXT:    store volatile <16 x i8> [[XOR4]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[XOR5:%.*]] = xor <16 x i8> [[TMP10]], [[TMP11]]
// CHECK-NEXT:    store volatile <16 x i8> [[XOR5]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[XOR6:%.*]] = xor <16 x i8> [[TMP12]], [[TMP13]]
// CHECK-NEXT:    store volatile <16 x i8> [[XOR6]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[XOR7:%.*]] = xor <8 x i16> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    store volatile <8 x i16> [[XOR7]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[XOR8:%.*]] = xor <8 x i16> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    store volatile <8 x i16> [[XOR8]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[XOR9:%.*]] = xor <8 x i16> [[TMP18]], [[TMP19]]
// CHECK-NEXT:    store volatile <8 x i16> [[XOR9]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[XOR10:%.*]] = xor <8 x i16> [[TMP20]], [[TMP21]]
// CHECK-NEXT:    store volatile <8 x i16> [[XOR10]], ptr @us, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[XOR11:%.*]] = xor <8 x i16> [[TMP22]], [[TMP23]]
// CHECK-NEXT:    store volatile <8 x i16> [[XOR11]], ptr @us, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[XOR12:%.*]] = xor <8 x i16> [[TMP24]], [[TMP25]]
// CHECK-NEXT:    store volatile <8 x i16> [[XOR12]], ptr @us, align 8
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[XOR13:%.*]] = xor <8 x i16> [[TMP26]], [[TMP27]]
// CHECK-NEXT:    store volatile <8 x i16> [[XOR13]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[XOR14:%.*]] = xor <4 x i32> [[TMP28]], [[TMP29]]
// CHECK-NEXT:    store volatile <4 x i32> [[XOR14]], ptr @si, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[XOR15:%.*]] = xor <4 x i32> [[TMP30]], [[TMP31]]
// CHECK-NEXT:    store volatile <4 x i32> [[XOR15]], ptr @si, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[XOR16:%.*]] = xor <4 x i32> [[TMP32]], [[TMP33]]
// CHECK-NEXT:    store volatile <4 x i32> [[XOR16]], ptr @si, align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[XOR17:%.*]] = xor <4 x i32> [[TMP34]], [[TMP35]]
// CHECK-NEXT:    store volatile <4 x i32> [[XOR17]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[XOR18:%.*]] = xor <4 x i32> [[TMP36]], [[TMP37]]
// CHECK-NEXT:    store volatile <4 x i32> [[XOR18]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[XOR19:%.*]] = xor <4 x i32> [[TMP38]], [[TMP39]]
// CHECK-NEXT:    store volatile <4 x i32> [[XOR19]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP40:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP41:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[XOR20:%.*]] = xor <4 x i32> [[TMP40]], [[TMP41]]
// CHECK-NEXT:    store volatile <4 x i32> [[XOR20]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP42:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[XOR21:%.*]] = xor <2 x i64> [[TMP42]], [[TMP43]]
// CHECK-NEXT:    store volatile <2 x i64> [[XOR21]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP44:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[XOR22:%.*]] = xor <2 x i64> [[TMP44]], [[TMP45]]
// CHECK-NEXT:    store volatile <2 x i64> [[XOR22]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP47:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[XOR23:%.*]] = xor <2 x i64> [[TMP46]], [[TMP47]]
// CHECK-NEXT:    store volatile <2 x i64> [[XOR23]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP48:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP49:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[XOR24:%.*]] = xor <2 x i64> [[TMP48]], [[TMP49]]
// CHECK-NEXT:    store volatile <2 x i64> [[XOR24]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP50:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP51:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[XOR25:%.*]] = xor <2 x i64> [[TMP50]], [[TMP51]]
// CHECK-NEXT:    store volatile <2 x i64> [[XOR25]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP52:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[XOR26:%.*]] = xor <2 x i64> [[TMP52]], [[TMP53]]
// CHECK-NEXT:    store volatile <2 x i64> [[XOR26]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[XOR27:%.*]] = xor <2 x i64> [[TMP54]], [[TMP55]]
// CHECK-NEXT:    store volatile <2 x i64> [[XOR27]], ptr @bl, align 8
// CHECK-NEXT:    ret void
//
void test_xor(void) {

  sc = sc ^ sc2;
  sc = sc ^ bc2;
  sc = bc ^ sc2;
  uc = uc ^ uc2;
  uc = uc ^ bc2;
  uc = bc ^ uc2;
  bc = bc ^ bc2;

  ss = ss ^ ss2;
  ss = ss ^ bs2;
  ss = bs ^ ss2;
  us = us ^ us2;
  us = us ^ bs2;
  us = bs ^ us2;
  bs = bs ^ bs2;

  si = si ^ si2;
  si = si ^ bi2;
  si = bi ^ si2;
  ui = ui ^ ui2;
  ui = ui ^ bi2;
  ui = bi ^ ui2;
  bi = bi ^ bi2;

  sl = sl ^ sl2;
  sl = sl ^ bl2;
  sl = bl ^ sl2;
  ul = ul ^ ul2;
  ul = ul ^ bl2;
  ul = bl ^ ul2;
  bl = bl ^ bl2;
}

// CHECK-LABEL: define dso_local void @test_xor_assign(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[XOR:%.*]] = xor <16 x i8> [[TMP1]], [[TMP0]]
// CHECK-NEXT:    store volatile <16 x i8> [[XOR]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[XOR1:%.*]] = xor <16 x i8> [[TMP3]], [[TMP2]]
// CHECK-NEXT:    store volatile <16 x i8> [[XOR1]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[XOR2:%.*]] = xor <16 x i8> [[TMP5]], [[TMP4]]
// CHECK-NEXT:    store volatile <16 x i8> [[XOR2]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[XOR3:%.*]] = xor <16 x i8> [[TMP7]], [[TMP6]]
// CHECK-NEXT:    store volatile <16 x i8> [[XOR3]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[XOR4:%.*]] = xor <16 x i8> [[TMP9]], [[TMP8]]
// CHECK-NEXT:    store volatile <16 x i8> [[XOR4]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[XOR5:%.*]] = xor <8 x i16> [[TMP11]], [[TMP10]]
// CHECK-NEXT:    store volatile <8 x i16> [[XOR5]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[XOR6:%.*]] = xor <8 x i16> [[TMP13]], [[TMP12]]
// CHECK-NEXT:    store volatile <8 x i16> [[XOR6]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[XOR7:%.*]] = xor <8 x i16> [[TMP15]], [[TMP14]]
// CHECK-NEXT:    store volatile <8 x i16> [[XOR7]], ptr @us, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[XOR8:%.*]] = xor <8 x i16> [[TMP17]], [[TMP16]]
// CHECK-NEXT:    store volatile <8 x i16> [[XOR8]], ptr @us, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[XOR9:%.*]] = xor <8 x i16> [[TMP19]], [[TMP18]]
// CHECK-NEXT:    store volatile <8 x i16> [[XOR9]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[XOR10:%.*]] = xor <4 x i32> [[TMP21]], [[TMP20]]
// CHECK-NEXT:    store volatile <4 x i32> [[XOR10]], ptr @si, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[XOR11:%.*]] = xor <4 x i32> [[TMP23]], [[TMP22]]
// CHECK-NEXT:    store volatile <4 x i32> [[XOR11]], ptr @si, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[XOR12:%.*]] = xor <4 x i32> [[TMP25]], [[TMP24]]
// CHECK-NEXT:    store volatile <4 x i32> [[XOR12]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[XOR13:%.*]] = xor <4 x i32> [[TMP27]], [[TMP26]]
// CHECK-NEXT:    store volatile <4 x i32> [[XOR13]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[XOR14:%.*]] = xor <4 x i32> [[TMP29]], [[TMP28]]
// CHECK-NEXT:    store volatile <4 x i32> [[XOR14]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[XOR15:%.*]] = xor <2 x i64> [[TMP31]], [[TMP30]]
// CHECK-NEXT:    store volatile <2 x i64> [[XOR15]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[XOR16:%.*]] = xor <2 x i64> [[TMP33]], [[TMP32]]
// CHECK-NEXT:    store volatile <2 x i64> [[XOR16]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[XOR17:%.*]] = xor <2 x i64> [[TMP35]], [[TMP34]]
// CHECK-NEXT:    store volatile <2 x i64> [[XOR17]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[XOR18:%.*]] = xor <2 x i64> [[TMP37]], [[TMP36]]
// CHECK-NEXT:    store volatile <2 x i64> [[XOR18]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[XOR19:%.*]] = xor <2 x i64> [[TMP39]], [[TMP38]]
// CHECK-NEXT:    store volatile <2 x i64> [[XOR19]], ptr @bl, align 8
// CHECK-NEXT:    ret void
//
void test_xor_assign(void) {

  sc ^= sc2;
  sc ^= bc2;
  uc ^= uc2;
  uc ^= bc2;
  bc ^= bc2;

  ss ^= ss2;
  ss ^= bs2;
  us ^= us2;
  us ^= bs2;
  bs ^= bs2;

  si ^= si2;
  si ^= bi2;
  ui ^= ui2;
  ui ^= bi2;
  bi ^= bi2;

  sl ^= sl2;
  sl ^= bl2;
  ul ^= ul2;
  ul ^= bl2;
  bl ^= bl2;
}

// CHECK-LABEL: define dso_local void @test_sl(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[SHL:%.*]] = shl <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHL]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[SHL1:%.*]] = shl <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHL1]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <16 x i32> poison, i32 [[TMP5]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <16 x i32> [[SPLAT_SPLATINSERT]], <16 x i32> poison, <16 x i32> zeroinitializer
// CHECK-NEXT:    [[SH_PROM:%.*]] = trunc <16 x i32> [[SPLAT_SPLAT]] to <16 x i8>
// CHECK-NEXT:    [[SHL2:%.*]] = shl <16 x i8> [[TMP4]], [[SH_PROM]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHL2]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[SHL3:%.*]] = shl <16 x i8> [[TMP6]], splat (i8 5)
// CHECK-NEXT:    store volatile <16 x i8> [[SHL3]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[SHL4:%.*]] = shl <16 x i8> [[TMP7]], [[TMP8]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHL4]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[SHL5:%.*]] = shl <16 x i8> [[TMP9]], [[TMP10]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHL5]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT6:%.*]] = insertelement <16 x i32> poison, i32 [[TMP12]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT7:%.*]] = shufflevector <16 x i32> [[SPLAT_SPLATINSERT6]], <16 x i32> poison, <16 x i32> zeroinitializer
// CHECK-NEXT:    [[SH_PROM8:%.*]] = trunc <16 x i32> [[SPLAT_SPLAT7]] to <16 x i8>
// CHECK-NEXT:    [[SHL9:%.*]] = shl <16 x i8> [[TMP11]], [[SH_PROM8]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHL9]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[SHL10:%.*]] = shl <16 x i8> [[TMP13]], splat (i8 5)
// CHECK-NEXT:    store volatile <16 x i8> [[SHL10]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[SHL11:%.*]] = shl <8 x i16> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHL11]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[SHL12:%.*]] = shl <8 x i16> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHL12]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT13:%.*]] = insertelement <8 x i32> poison, i32 [[TMP19]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT14:%.*]] = shufflevector <8 x i32> [[SPLAT_SPLATINSERT13]], <8 x i32> poison, <8 x i32> zeroinitializer
// CHECK-NEXT:    [[SH_PROM15:%.*]] = trunc <8 x i32> [[SPLAT_SPLAT14]] to <8 x i16>
// CHECK-NEXT:    [[SHL16:%.*]] = shl <8 x i16> [[TMP18]], [[SH_PROM15]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHL16]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[SHL17:%.*]] = shl <8 x i16> [[TMP20]], splat (i16 5)
// CHECK-NEXT:    store volatile <8 x i16> [[SHL17]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[SHL18:%.*]] = shl <8 x i16> [[TMP21]], [[TMP22]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHL18]], ptr @us, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[SHL19:%.*]] = shl <8 x i16> [[TMP23]], [[TMP24]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHL19]], ptr @us, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT20:%.*]] = insertelement <8 x i32> poison, i32 [[TMP26]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT21:%.*]] = shufflevector <8 x i32> [[SPLAT_SPLATINSERT20]], <8 x i32> poison, <8 x i32> zeroinitializer
// CHECK-NEXT:    [[SH_PROM22:%.*]] = trunc <8 x i32> [[SPLAT_SPLAT21]] to <8 x i16>
// CHECK-NEXT:    [[SHL23:%.*]] = shl <8 x i16> [[TMP25]], [[SH_PROM22]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHL23]], ptr @us, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[SHL24:%.*]] = shl <8 x i16> [[TMP27]], splat (i16 5)
// CHECK-NEXT:    store volatile <8 x i16> [[SHL24]], ptr @us, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[SHL25:%.*]] = shl <4 x i32> [[TMP28]], [[TMP29]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHL25]], ptr @si, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[SHL26:%.*]] = shl <4 x i32> [[TMP30]], [[TMP31]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHL26]], ptr @si, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT27:%.*]] = insertelement <4 x i32> poison, i32 [[TMP33]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT28:%.*]] = shufflevector <4 x i32> [[SPLAT_SPLATINSERT27]], <4 x i32> poison, <4 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL29:%.*]] = shl <4 x i32> [[TMP32]], [[SPLAT_SPLAT28]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHL29]], ptr @si, align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[SHL30:%.*]] = shl <4 x i32> [[TMP34]], splat (i32 5)
// CHECK-NEXT:    store volatile <4 x i32> [[SHL30]], ptr @si, align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[SHL31:%.*]] = shl <4 x i32> [[TMP35]], [[TMP36]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHL31]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[SHL32:%.*]] = shl <4 x i32> [[TMP37]], [[TMP38]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHL32]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP40:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT33:%.*]] = insertelement <4 x i32> poison, i32 [[TMP40]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT34:%.*]] = shufflevector <4 x i32> [[SPLAT_SPLATINSERT33]], <4 x i32> poison, <4 x i32> zeroinitializer
// CHECK-NEXT:    [[SHL35:%.*]] = shl <4 x i32> [[TMP39]], [[SPLAT_SPLAT34]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHL35]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP41:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[SHL36:%.*]] = shl <4 x i32> [[TMP41]], splat (i32 5)
// CHECK-NEXT:    store volatile <4 x i32> [[SHL36]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP42:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[SHL37:%.*]] = shl <2 x i64> [[TMP42]], [[TMP43]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHL37]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP44:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[SHL38:%.*]] = shl <2 x i64> [[TMP44]], [[TMP45]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHL38]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP47:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT39:%.*]] = insertelement <2 x i32> poison, i32 [[TMP47]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT40:%.*]] = shufflevector <2 x i32> [[SPLAT_SPLATINSERT39]], <2 x i32> poison, <2 x i32> zeroinitializer
// CHECK-NEXT:    [[SH_PROM41:%.*]] = zext <2 x i32> [[SPLAT_SPLAT40]] to <2 x i64>
// CHECK-NEXT:    [[SHL42:%.*]] = shl <2 x i64> [[TMP46]], [[SH_PROM41]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHL42]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP48:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[SHL43:%.*]] = shl <2 x i64> [[TMP48]], splat (i64 5)
// CHECK-NEXT:    store volatile <2 x i64> [[SHL43]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP49:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP50:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[SHL44:%.*]] = shl <2 x i64> [[TMP49]], [[TMP50]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHL44]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP51:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP52:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[SHL45:%.*]] = shl <2 x i64> [[TMP51]], [[TMP52]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHL45]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT46:%.*]] = insertelement <2 x i32> poison, i32 [[TMP54]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT47:%.*]] = shufflevector <2 x i32> [[SPLAT_SPLATINSERT46]], <2 x i32> poison, <2 x i32> zeroinitializer
// CHECK-NEXT:    [[SH_PROM48:%.*]] = zext <2 x i32> [[SPLAT_SPLAT47]] to <2 x i64>
// CHECK-NEXT:    [[SHL49:%.*]] = shl <2 x i64> [[TMP53]], [[SH_PROM48]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHL49]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[SHL50:%.*]] = shl <2 x i64> [[TMP55]], splat (i64 5)
// CHECK-NEXT:    store volatile <2 x i64> [[SHL50]], ptr @ul, align 8
// CHECK-NEXT:    ret void
//
void test_sl(void) {

  sc = sc << sc2;
  sc = sc << uc2;
  sc = sc << cnt;
  sc = sc << 5;
  uc = uc << sc2;
  uc = uc << uc2;
  uc = uc << cnt;
  uc = uc << 5;

  ss = ss << ss2;
  ss = ss << us2;
  ss = ss << cnt;
  ss = ss << 5;
  us = us << ss2;
  us = us << us2;
  us = us << cnt;
  us = us << 5;

  si = si << si2;
  si = si << ui2;
  si = si << cnt;
  si = si << 5;
  ui = ui << si2;
  ui = ui << ui2;
  ui = ui << cnt;
  ui = ui << 5;

  sl = sl << sl2;
  sl = sl << ul2;
  sl = sl << cnt;
  sl = sl << 5;
  ul = ul << sl2;
  ul = ul << ul2;
  ul = ul << cnt;
  ul = ul << 5;
}

// CHECK-LABEL: define dso_local void @test_sl_assign(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[SHL:%.*]] = shl <16 x i8> [[TMP1]], [[TMP0]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHL]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[SHL1:%.*]] = shl <16 x i8> [[TMP3]], [[TMP2]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHL1]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <16 x i32> poison, i32 [[TMP4]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <16 x i32> [[SPLAT_SPLATINSERT]], <16 x i32> poison, <16 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[SH_PROM:%.*]] = trunc <16 x i32> [[SPLAT_SPLAT]] to <16 x i8>
// CHECK-NEXT:    [[SHL2:%.*]] = shl <16 x i8> [[TMP5]], [[SH_PROM]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHL2]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[SHL3:%.*]] = shl <16 x i8> [[TMP6]], splat (i8 5)
// CHECK-NEXT:    store volatile <16 x i8> [[SHL3]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[SHL4:%.*]] = shl <16 x i8> [[TMP8]], [[TMP7]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHL4]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[SHL5:%.*]] = shl <16 x i8> [[TMP10]], [[TMP9]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHL5]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT6:%.*]] = insertelement <16 x i32> poison, i32 [[TMP11]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT7:%.*]] = shufflevector <16 x i32> [[SPLAT_SPLATINSERT6]], <16 x i32> poison, <16 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[SH_PROM8:%.*]] = trunc <16 x i32> [[SPLAT_SPLAT7]] to <16 x i8>
// CHECK-NEXT:    [[SHL9:%.*]] = shl <16 x i8> [[TMP12]], [[SH_PROM8]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHL9]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[SHL10:%.*]] = shl <16 x i8> [[TMP13]], splat (i8 5)
// CHECK-NEXT:    store volatile <16 x i8> [[SHL10]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[SHL11:%.*]] = shl <8 x i16> [[TMP15]], [[TMP14]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHL11]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[SHL12:%.*]] = shl <8 x i16> [[TMP17]], [[TMP16]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHL12]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT13:%.*]] = insertelement <8 x i32> poison, i32 [[TMP18]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT14:%.*]] = shufflevector <8 x i32> [[SPLAT_SPLATINSERT13]], <8 x i32> poison, <8 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[SH_PROM15:%.*]] = trunc <8 x i32> [[SPLAT_SPLAT14]] to <8 x i16>
// CHECK-NEXT:    [[SHL16:%.*]] = shl <8 x i16> [[TMP19]], [[SH_PROM15]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHL16]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[SHL17:%.*]] = shl <8 x i16> [[TMP20]], splat (i16 5)
// CHECK-NEXT:    store volatile <8 x i16> [[SHL17]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[SHL18:%.*]] = shl <8 x i16> [[TMP22]], [[TMP21]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHL18]], ptr @us, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[SHL19:%.*]] = shl <8 x i16> [[TMP24]], [[TMP23]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHL19]], ptr @us, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT20:%.*]] = insertelement <8 x i32> poison, i32 [[TMP25]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT21:%.*]] = shufflevector <8 x i32> [[SPLAT_SPLATINSERT20]], <8 x i32> poison, <8 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[SH_PROM22:%.*]] = trunc <8 x i32> [[SPLAT_SPLAT21]] to <8 x i16>
// CHECK-NEXT:    [[SHL23:%.*]] = shl <8 x i16> [[TMP26]], [[SH_PROM22]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHL23]], ptr @us, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[SHL24:%.*]] = shl <8 x i16> [[TMP27]], splat (i16 5)
// CHECK-NEXT:    store volatile <8 x i16> [[SHL24]], ptr @us, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[SHL25:%.*]] = shl <4 x i32> [[TMP29]], [[TMP28]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHL25]], ptr @si, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[SHL26:%.*]] = shl <4 x i32> [[TMP31]], [[TMP30]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHL26]], ptr @si, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT27:%.*]] = insertelement <4 x i32> poison, i32 [[TMP32]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT28:%.*]] = shufflevector <4 x i32> [[SPLAT_SPLATINSERT27]], <4 x i32> poison, <4 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[SHL29:%.*]] = shl <4 x i32> [[TMP33]], [[SPLAT_SPLAT28]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHL29]], ptr @si, align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[SHL30:%.*]] = shl <4 x i32> [[TMP34]], splat (i32 5)
// CHECK-NEXT:    store volatile <4 x i32> [[SHL30]], ptr @si, align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[SHL31:%.*]] = shl <4 x i32> [[TMP36]], [[TMP35]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHL31]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[SHL32:%.*]] = shl <4 x i32> [[TMP38]], [[TMP37]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHL32]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT33:%.*]] = insertelement <4 x i32> poison, i32 [[TMP39]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT34:%.*]] = shufflevector <4 x i32> [[SPLAT_SPLATINSERT33]], <4 x i32> poison, <4 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP40:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[SHL35:%.*]] = shl <4 x i32> [[TMP40]], [[SPLAT_SPLAT34]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHL35]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP41:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[SHL36:%.*]] = shl <4 x i32> [[TMP41]], splat (i32 5)
// CHECK-NEXT:    store volatile <4 x i32> [[SHL36]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP42:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[SHL37:%.*]] = shl <2 x i64> [[TMP43]], [[TMP42]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHL37]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP44:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[SHL38:%.*]] = shl <2 x i64> [[TMP45]], [[TMP44]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHL38]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT39:%.*]] = insertelement <2 x i32> poison, i32 [[TMP46]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT40:%.*]] = shufflevector <2 x i32> [[SPLAT_SPLATINSERT39]], <2 x i32> poison, <2 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP47:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[SH_PROM41:%.*]] = zext <2 x i32> [[SPLAT_SPLAT40]] to <2 x i64>
// CHECK-NEXT:    [[SHL42:%.*]] = shl <2 x i64> [[TMP47]], [[SH_PROM41]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHL42]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP48:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[SHL43:%.*]] = shl <2 x i64> [[TMP48]], splat (i64 5)
// CHECK-NEXT:    store volatile <2 x i64> [[SHL43]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP49:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[TMP50:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[SHL44:%.*]] = shl <2 x i64> [[TMP50]], [[TMP49]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHL44]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP51:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[TMP52:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[SHL45:%.*]] = shl <2 x i64> [[TMP52]], [[TMP51]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHL45]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT46:%.*]] = insertelement <2 x i32> poison, i32 [[TMP53]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT47:%.*]] = shufflevector <2 x i32> [[SPLAT_SPLATINSERT46]], <2 x i32> poison, <2 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP54:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[SH_PROM48:%.*]] = zext <2 x i32> [[SPLAT_SPLAT47]] to <2 x i64>
// CHECK-NEXT:    [[SHL49:%.*]] = shl <2 x i64> [[TMP54]], [[SH_PROM48]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHL49]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[SHL50:%.*]] = shl <2 x i64> [[TMP55]], splat (i64 5)
// CHECK-NEXT:    store volatile <2 x i64> [[SHL50]], ptr @ul, align 8
// CHECK-NEXT:    ret void
//
void test_sl_assign(void) {

  sc <<= sc2;
  sc <<= uc2;
  sc <<= cnt;
  sc <<= 5;
  uc <<= sc2;
  uc <<= uc2;
  uc <<= cnt;
  uc <<= 5;

  ss <<= ss2;
  ss <<= us2;
  ss <<= cnt;
  ss <<= 5;
  us <<= ss2;
  us <<= us2;
  us <<= cnt;
  us <<= 5;

  si <<= si2;
  si <<= ui2;
  si <<= cnt;
  si <<= 5;
  ui <<= si2;
  ui <<= ui2;
  ui <<= cnt;
  ui <<= 5;

  sl <<= sl2;
  sl <<= ul2;
  sl <<= cnt;
  sl <<= 5;
  ul <<= sl2;
  ul <<= ul2;
  ul <<= cnt;
  ul <<= 5;
}

// CHECK-LABEL: define dso_local void @test_sr(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[SHR:%.*]] = ashr <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHR]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[SHR1:%.*]] = ashr <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHR1]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <16 x i32> poison, i32 [[TMP5]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <16 x i32> [[SPLAT_SPLATINSERT]], <16 x i32> poison, <16 x i32> zeroinitializer
// CHECK-NEXT:    [[SH_PROM:%.*]] = trunc <16 x i32> [[SPLAT_SPLAT]] to <16 x i8>
// CHECK-NEXT:    [[SHR2:%.*]] = ashr <16 x i8> [[TMP4]], [[SH_PROM]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHR2]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[SHR3:%.*]] = ashr <16 x i8> [[TMP6]], splat (i8 5)
// CHECK-NEXT:    store volatile <16 x i8> [[SHR3]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[SHR4:%.*]] = lshr <16 x i8> [[TMP7]], [[TMP8]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHR4]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[SHR5:%.*]] = lshr <16 x i8> [[TMP9]], [[TMP10]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHR5]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT6:%.*]] = insertelement <16 x i32> poison, i32 [[TMP12]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT7:%.*]] = shufflevector <16 x i32> [[SPLAT_SPLATINSERT6]], <16 x i32> poison, <16 x i32> zeroinitializer
// CHECK-NEXT:    [[SH_PROM8:%.*]] = trunc <16 x i32> [[SPLAT_SPLAT7]] to <16 x i8>
// CHECK-NEXT:    [[SHR9:%.*]] = lshr <16 x i8> [[TMP11]], [[SH_PROM8]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHR9]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[SHR10:%.*]] = lshr <16 x i8> [[TMP13]], splat (i8 5)
// CHECK-NEXT:    store volatile <16 x i8> [[SHR10]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[SHR11:%.*]] = ashr <8 x i16> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHR11]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[SHR12:%.*]] = ashr <8 x i16> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHR12]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT13:%.*]] = insertelement <8 x i32> poison, i32 [[TMP19]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT14:%.*]] = shufflevector <8 x i32> [[SPLAT_SPLATINSERT13]], <8 x i32> poison, <8 x i32> zeroinitializer
// CHECK-NEXT:    [[SH_PROM15:%.*]] = trunc <8 x i32> [[SPLAT_SPLAT14]] to <8 x i16>
// CHECK-NEXT:    [[SHR16:%.*]] = ashr <8 x i16> [[TMP18]], [[SH_PROM15]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHR16]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[SHR17:%.*]] = ashr <8 x i16> [[TMP20]], splat (i16 5)
// CHECK-NEXT:    store volatile <8 x i16> [[SHR17]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[SHR18:%.*]] = lshr <8 x i16> [[TMP21]], [[TMP22]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHR18]], ptr @us, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[SHR19:%.*]] = lshr <8 x i16> [[TMP23]], [[TMP24]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHR19]], ptr @us, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT20:%.*]] = insertelement <8 x i32> poison, i32 [[TMP26]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT21:%.*]] = shufflevector <8 x i32> [[SPLAT_SPLATINSERT20]], <8 x i32> poison, <8 x i32> zeroinitializer
// CHECK-NEXT:    [[SH_PROM22:%.*]] = trunc <8 x i32> [[SPLAT_SPLAT21]] to <8 x i16>
// CHECK-NEXT:    [[SHR23:%.*]] = lshr <8 x i16> [[TMP25]], [[SH_PROM22]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHR23]], ptr @us, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[SHR24:%.*]] = lshr <8 x i16> [[TMP27]], splat (i16 5)
// CHECK-NEXT:    store volatile <8 x i16> [[SHR24]], ptr @us, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[SHR25:%.*]] = ashr <4 x i32> [[TMP28]], [[TMP29]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHR25]], ptr @si, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[SHR26:%.*]] = ashr <4 x i32> [[TMP30]], [[TMP31]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHR26]], ptr @si, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT27:%.*]] = insertelement <4 x i32> poison, i32 [[TMP33]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT28:%.*]] = shufflevector <4 x i32> [[SPLAT_SPLATINSERT27]], <4 x i32> poison, <4 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR29:%.*]] = ashr <4 x i32> [[TMP32]], [[SPLAT_SPLAT28]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHR29]], ptr @si, align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[SHR30:%.*]] = ashr <4 x i32> [[TMP34]], splat (i32 5)
// CHECK-NEXT:    store volatile <4 x i32> [[SHR30]], ptr @si, align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[SHR31:%.*]] = lshr <4 x i32> [[TMP35]], [[TMP36]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHR31]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[SHR32:%.*]] = lshr <4 x i32> [[TMP37]], [[TMP38]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHR32]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP40:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT33:%.*]] = insertelement <4 x i32> poison, i32 [[TMP40]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT34:%.*]] = shufflevector <4 x i32> [[SPLAT_SPLATINSERT33]], <4 x i32> poison, <4 x i32> zeroinitializer
// CHECK-NEXT:    [[SHR35:%.*]] = lshr <4 x i32> [[TMP39]], [[SPLAT_SPLAT34]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHR35]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP41:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[SHR36:%.*]] = lshr <4 x i32> [[TMP41]], splat (i32 5)
// CHECK-NEXT:    store volatile <4 x i32> [[SHR36]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP42:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[SHR37:%.*]] = ashr <2 x i64> [[TMP42]], [[TMP43]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHR37]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP44:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[SHR38:%.*]] = ashr <2 x i64> [[TMP44]], [[TMP45]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHR38]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP47:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT39:%.*]] = insertelement <2 x i32> poison, i32 [[TMP47]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT40:%.*]] = shufflevector <2 x i32> [[SPLAT_SPLATINSERT39]], <2 x i32> poison, <2 x i32> zeroinitializer
// CHECK-NEXT:    [[SH_PROM41:%.*]] = zext <2 x i32> [[SPLAT_SPLAT40]] to <2 x i64>
// CHECK-NEXT:    [[SHR42:%.*]] = ashr <2 x i64> [[TMP46]], [[SH_PROM41]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHR42]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP48:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[SHR43:%.*]] = ashr <2 x i64> [[TMP48]], splat (i64 5)
// CHECK-NEXT:    store volatile <2 x i64> [[SHR43]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP49:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP50:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[SHR44:%.*]] = lshr <2 x i64> [[TMP49]], [[TMP50]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHR44]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP51:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP52:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[SHR45:%.*]] = lshr <2 x i64> [[TMP51]], [[TMP52]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHR45]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT46:%.*]] = insertelement <2 x i32> poison, i32 [[TMP54]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT47:%.*]] = shufflevector <2 x i32> [[SPLAT_SPLATINSERT46]], <2 x i32> poison, <2 x i32> zeroinitializer
// CHECK-NEXT:    [[SH_PROM48:%.*]] = zext <2 x i32> [[SPLAT_SPLAT47]] to <2 x i64>
// CHECK-NEXT:    [[SHR49:%.*]] = lshr <2 x i64> [[TMP53]], [[SH_PROM48]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHR49]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[SHR50:%.*]] = lshr <2 x i64> [[TMP55]], splat (i64 5)
// CHECK-NEXT:    store volatile <2 x i64> [[SHR50]], ptr @ul, align 8
// CHECK-NEXT:    ret void
//
void test_sr(void) {

  sc = sc >> sc2;
  sc = sc >> uc2;
  sc = sc >> cnt;
  sc = sc >> 5;
  uc = uc >> sc2;
  uc = uc >> uc2;
  uc = uc >> cnt;
  uc = uc >> 5;

  ss = ss >> ss2;
  ss = ss >> us2;
  ss = ss >> cnt;
  ss = ss >> 5;
  us = us >> ss2;
  us = us >> us2;
  us = us >> cnt;
  us = us >> 5;

  si = si >> si2;
  si = si >> ui2;
  si = si >> cnt;
  si = si >> 5;
  ui = ui >> si2;
  ui = ui >> ui2;
  ui = ui >> cnt;
  ui = ui >> 5;

  sl = sl >> sl2;
  sl = sl >> ul2;
  sl = sl >> cnt;
  sl = sl >> 5;
  ul = ul >> sl2;
  ul = ul >> ul2;
  ul = ul >> cnt;
  ul = ul >> 5;
}

// CHECK-LABEL: define dso_local void @test_sr_assign(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[SHR:%.*]] = ashr <16 x i8> [[TMP1]], [[TMP0]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHR]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[SHR1:%.*]] = ashr <16 x i8> [[TMP3]], [[TMP2]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHR1]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <16 x i32> poison, i32 [[TMP4]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <16 x i32> [[SPLAT_SPLATINSERT]], <16 x i32> poison, <16 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[SH_PROM:%.*]] = trunc <16 x i32> [[SPLAT_SPLAT]] to <16 x i8>
// CHECK-NEXT:    [[SHR2:%.*]] = ashr <16 x i8> [[TMP5]], [[SH_PROM]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHR2]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[SHR3:%.*]] = ashr <16 x i8> [[TMP6]], splat (i8 5)
// CHECK-NEXT:    store volatile <16 x i8> [[SHR3]], ptr @sc, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[SHR4:%.*]] = lshr <16 x i8> [[TMP8]], [[TMP7]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHR4]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[SHR5:%.*]] = lshr <16 x i8> [[TMP10]], [[TMP9]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHR5]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT6:%.*]] = insertelement <16 x i32> poison, i32 [[TMP11]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT7:%.*]] = shufflevector <16 x i32> [[SPLAT_SPLATINSERT6]], <16 x i32> poison, <16 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[SH_PROM8:%.*]] = trunc <16 x i32> [[SPLAT_SPLAT7]] to <16 x i8>
// CHECK-NEXT:    [[SHR9:%.*]] = lshr <16 x i8> [[TMP12]], [[SH_PROM8]]
// CHECK-NEXT:    store volatile <16 x i8> [[SHR9]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[SHR10:%.*]] = lshr <16 x i8> [[TMP13]], splat (i8 5)
// CHECK-NEXT:    store volatile <16 x i8> [[SHR10]], ptr @uc, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[SHR11:%.*]] = ashr <8 x i16> [[TMP15]], [[TMP14]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHR11]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[SHR12:%.*]] = ashr <8 x i16> [[TMP17]], [[TMP16]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHR12]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT13:%.*]] = insertelement <8 x i32> poison, i32 [[TMP18]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT14:%.*]] = shufflevector <8 x i32> [[SPLAT_SPLATINSERT13]], <8 x i32> poison, <8 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[SH_PROM15:%.*]] = trunc <8 x i32> [[SPLAT_SPLAT14]] to <8 x i16>
// CHECK-NEXT:    [[SHR16:%.*]] = ashr <8 x i16> [[TMP19]], [[SH_PROM15]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHR16]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[SHR17:%.*]] = ashr <8 x i16> [[TMP20]], splat (i16 5)
// CHECK-NEXT:    store volatile <8 x i16> [[SHR17]], ptr @ss, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[SHR18:%.*]] = lshr <8 x i16> [[TMP22]], [[TMP21]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHR18]], ptr @us, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[SHR19:%.*]] = lshr <8 x i16> [[TMP24]], [[TMP23]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHR19]], ptr @us, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT20:%.*]] = insertelement <8 x i32> poison, i32 [[TMP25]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT21:%.*]] = shufflevector <8 x i32> [[SPLAT_SPLATINSERT20]], <8 x i32> poison, <8 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[SH_PROM22:%.*]] = trunc <8 x i32> [[SPLAT_SPLAT21]] to <8 x i16>
// CHECK-NEXT:    [[SHR23:%.*]] = lshr <8 x i16> [[TMP26]], [[SH_PROM22]]
// CHECK-NEXT:    store volatile <8 x i16> [[SHR23]], ptr @us, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[SHR24:%.*]] = lshr <8 x i16> [[TMP27]], splat (i16 5)
// CHECK-NEXT:    store volatile <8 x i16> [[SHR24]], ptr @us, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[SHR25:%.*]] = ashr <4 x i32> [[TMP29]], [[TMP28]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHR25]], ptr @si, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[SHR26:%.*]] = ashr <4 x i32> [[TMP31]], [[TMP30]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHR26]], ptr @si, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT27:%.*]] = insertelement <4 x i32> poison, i32 [[TMP32]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT28:%.*]] = shufflevector <4 x i32> [[SPLAT_SPLATINSERT27]], <4 x i32> poison, <4 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[SHR29:%.*]] = ashr <4 x i32> [[TMP33]], [[SPLAT_SPLAT28]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHR29]], ptr @si, align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[SHR30:%.*]] = ashr <4 x i32> [[TMP34]], splat (i32 5)
// CHECK-NEXT:    store volatile <4 x i32> [[SHR30]], ptr @si, align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[SHR31:%.*]] = lshr <4 x i32> [[TMP36]], [[TMP35]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHR31]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[SHR32:%.*]] = lshr <4 x i32> [[TMP38]], [[TMP37]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHR32]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT33:%.*]] = insertelement <4 x i32> poison, i32 [[TMP39]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT34:%.*]] = shufflevector <4 x i32> [[SPLAT_SPLATINSERT33]], <4 x i32> poison, <4 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP40:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[SHR35:%.*]] = lshr <4 x i32> [[TMP40]], [[SPLAT_SPLAT34]]
// CHECK-NEXT:    store volatile <4 x i32> [[SHR35]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP41:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[SHR36:%.*]] = lshr <4 x i32> [[TMP41]], splat (i32 5)
// CHECK-NEXT:    store volatile <4 x i32> [[SHR36]], ptr @ui, align 8
// CHECK-NEXT:    [[TMP42:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[SHR37:%.*]] = ashr <2 x i64> [[TMP43]], [[TMP42]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHR37]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP44:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[SHR38:%.*]] = ashr <2 x i64> [[TMP45]], [[TMP44]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHR38]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT39:%.*]] = insertelement <2 x i32> poison, i32 [[TMP46]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT40:%.*]] = shufflevector <2 x i32> [[SPLAT_SPLATINSERT39]], <2 x i32> poison, <2 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP47:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[SH_PROM41:%.*]] = zext <2 x i32> [[SPLAT_SPLAT40]] to <2 x i64>
// CHECK-NEXT:    [[SHR42:%.*]] = ashr <2 x i64> [[TMP47]], [[SH_PROM41]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHR42]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP48:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[SHR43:%.*]] = ashr <2 x i64> [[TMP48]], splat (i64 5)
// CHECK-NEXT:    store volatile <2 x i64> [[SHR43]], ptr @sl, align 8
// CHECK-NEXT:    [[TMP49:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[TMP50:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[SHR44:%.*]] = lshr <2 x i64> [[TMP50]], [[TMP49]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHR44]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP51:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[TMP52:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[SHR45:%.*]] = lshr <2 x i64> [[TMP52]], [[TMP51]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHR45]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load volatile i32, ptr @cnt, align 4
// CHECK-NEXT:    [[SPLAT_SPLATINSERT46:%.*]] = insertelement <2 x i32> poison, i32 [[TMP53]], i64 0
// CHECK-NEXT:    [[SPLAT_SPLAT47:%.*]] = shufflevector <2 x i32> [[SPLAT_SPLATINSERT46]], <2 x i32> poison, <2 x i32> zeroinitializer
// CHECK-NEXT:    [[TMP54:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[SH_PROM48:%.*]] = zext <2 x i32> [[SPLAT_SPLAT47]] to <2 x i64>
// CHECK-NEXT:    [[SHR49:%.*]] = lshr <2 x i64> [[TMP54]], [[SH_PROM48]]
// CHECK-NEXT:    store volatile <2 x i64> [[SHR49]], ptr @ul, align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[SHR50:%.*]] = lshr <2 x i64> [[TMP55]], splat (i64 5)
// CHECK-NEXT:    store volatile <2 x i64> [[SHR50]], ptr @ul, align 8
// CHECK-NEXT:    ret void
//
void test_sr_assign(void) {

  sc >>= sc2;
  sc >>= uc2;
  sc >>= cnt;
  sc >>= 5;
  uc >>= sc2;
  uc >>= uc2;
  uc >>= cnt;
  uc >>= 5;

  ss >>= ss2;
  ss >>= us2;
  ss >>= cnt;
  ss >>= 5;
  us >>= ss2;
  us >>= us2;
  us >>= cnt;
  us >>= 5;

  si >>= si2;
  si >>= ui2;
  si >>= cnt;
  si >>= 5;
  ui >>= si2;
  ui >>= ui2;
  ui >>= cnt;
  ui >>= 5;

  sl >>= sl2;
  sl >>= ul2;
  sl >>= cnt;
  sl >>= 5;
  ul >>= sl2;
  ul >>= ul2;
  ul >>= cnt;
  ul >>= 5;
}


// CHECK-LABEL: define dso_local void @test_cmpeq(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[CMP:%.*]] = icmp eq <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    [[SEXT:%.*]] = sext <16 x i1> [[CMP]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[CMP1:%.*]] = icmp eq <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    [[SEXT2:%.*]] = sext <16 x i1> [[CMP1]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT2]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[CMP3:%.*]] = icmp eq <16 x i8> [[TMP4]], [[TMP5]]
// CHECK-NEXT:    [[SEXT4:%.*]] = sext <16 x i1> [[CMP3]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT4]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[CMP5:%.*]] = icmp eq <16 x i8> [[TMP6]], [[TMP7]]
// CHECK-NEXT:    [[SEXT6:%.*]] = sext <16 x i1> [[CMP5]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT6]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[CMP7:%.*]] = icmp eq <16 x i8> [[TMP8]], [[TMP9]]
// CHECK-NEXT:    [[SEXT8:%.*]] = sext <16 x i1> [[CMP7]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT8]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[CMP9:%.*]] = icmp eq <16 x i8> [[TMP10]], [[TMP11]]
// CHECK-NEXT:    [[SEXT10:%.*]] = sext <16 x i1> [[CMP9]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT10]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[CMP11:%.*]] = icmp eq <16 x i8> [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[SEXT12:%.*]] = sext <16 x i1> [[CMP11]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT12]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[CMP13:%.*]] = icmp eq <8 x i16> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    [[SEXT14:%.*]] = sext <8 x i1> [[CMP13]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT14]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[CMP15:%.*]] = icmp eq <8 x i16> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    [[SEXT16:%.*]] = sext <8 x i1> [[CMP15]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT16]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[CMP17:%.*]] = icmp eq <8 x i16> [[TMP18]], [[TMP19]]
// CHECK-NEXT:    [[SEXT18:%.*]] = sext <8 x i1> [[CMP17]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT18]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[CMP19:%.*]] = icmp eq <8 x i16> [[TMP20]], [[TMP21]]
// CHECK-NEXT:    [[SEXT20:%.*]] = sext <8 x i1> [[CMP19]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT20]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[CMP21:%.*]] = icmp eq <8 x i16> [[TMP22]], [[TMP23]]
// CHECK-NEXT:    [[SEXT22:%.*]] = sext <8 x i1> [[CMP21]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT22]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[CMP23:%.*]] = icmp eq <8 x i16> [[TMP24]], [[TMP25]]
// CHECK-NEXT:    [[SEXT24:%.*]] = sext <8 x i1> [[CMP23]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT24]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[CMP25:%.*]] = icmp eq <8 x i16> [[TMP26]], [[TMP27]]
// CHECK-NEXT:    [[SEXT26:%.*]] = sext <8 x i1> [[CMP25]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT26]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[CMP27:%.*]] = icmp eq <4 x i32> [[TMP28]], [[TMP29]]
// CHECK-NEXT:    [[SEXT28:%.*]] = sext <4 x i1> [[CMP27]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT28]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[CMP29:%.*]] = icmp eq <4 x i32> [[TMP30]], [[TMP31]]
// CHECK-NEXT:    [[SEXT30:%.*]] = sext <4 x i1> [[CMP29]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT30]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[CMP31:%.*]] = icmp eq <4 x i32> [[TMP32]], [[TMP33]]
// CHECK-NEXT:    [[SEXT32:%.*]] = sext <4 x i1> [[CMP31]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT32]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[CMP33:%.*]] = icmp eq <4 x i32> [[TMP34]], [[TMP35]]
// CHECK-NEXT:    [[SEXT34:%.*]] = sext <4 x i1> [[CMP33]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT34]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[CMP35:%.*]] = icmp eq <4 x i32> [[TMP36]], [[TMP37]]
// CHECK-NEXT:    [[SEXT36:%.*]] = sext <4 x i1> [[CMP35]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT36]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[CMP37:%.*]] = icmp eq <4 x i32> [[TMP38]], [[TMP39]]
// CHECK-NEXT:    [[SEXT38:%.*]] = sext <4 x i1> [[CMP37]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT38]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP40:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP41:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[CMP39:%.*]] = icmp eq <4 x i32> [[TMP40]], [[TMP41]]
// CHECK-NEXT:    [[SEXT40:%.*]] = sext <4 x i1> [[CMP39]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT40]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP42:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[CMP41:%.*]] = icmp eq <2 x i64> [[TMP42]], [[TMP43]]
// CHECK-NEXT:    [[SEXT42:%.*]] = sext <2 x i1> [[CMP41]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT42]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP44:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[CMP43:%.*]] = icmp eq <2 x i64> [[TMP44]], [[TMP45]]
// CHECK-NEXT:    [[SEXT44:%.*]] = sext <2 x i1> [[CMP43]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT44]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP47:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[CMP45:%.*]] = icmp eq <2 x i64> [[TMP46]], [[TMP47]]
// CHECK-NEXT:    [[SEXT46:%.*]] = sext <2 x i1> [[CMP45]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT46]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP48:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP49:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[CMP47:%.*]] = icmp eq <2 x i64> [[TMP48]], [[TMP49]]
// CHECK-NEXT:    [[SEXT48:%.*]] = sext <2 x i1> [[CMP47]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT48]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP50:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP51:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[CMP49:%.*]] = icmp eq <2 x i64> [[TMP50]], [[TMP51]]
// CHECK-NEXT:    [[SEXT50:%.*]] = sext <2 x i1> [[CMP49]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT50]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP52:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[CMP51:%.*]] = icmp eq <2 x i64> [[TMP52]], [[TMP53]]
// CHECK-NEXT:    [[SEXT52:%.*]] = sext <2 x i1> [[CMP51]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT52]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[CMP53:%.*]] = icmp eq <2 x i64> [[TMP54]], [[TMP55]]
// CHECK-NEXT:    [[SEXT54:%.*]] = sext <2 x i1> [[CMP53]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT54]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP56:%.*]] = load volatile <2 x double>, ptr @fd, align 8
// CHECK-NEXT:    [[TMP57:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[CMP55:%.*]] = fcmp oeq <2 x double> [[TMP56]], [[TMP57]]
// CHECK-NEXT:    [[SEXT56:%.*]] = sext <2 x i1> [[CMP55]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT56]], ptr @bl, align 8
// CHECK-NEXT:    ret void
//
void test_cmpeq(void) {

  bc = sc == sc2;
  bc = sc == bc2;
  bc = bc == sc2;
  bc = uc == uc2;
  bc = uc == bc2;
  bc = bc == uc2;
  bc = bc == bc2;

  bs = ss == ss2;
  bs = ss == bs2;
  bs = bs == ss2;
  bs = us == us2;
  bs = us == bs2;
  bs = bs == us2;
  bs = bs == bs2;

  bi = si == si2;
  bi = si == bi2;
  bi = bi == si2;
  bi = ui == ui2;
  bi = ui == bi2;
  bi = bi == ui2;
  bi = bi == bi2;

  bl = sl == sl2;
  bl = sl == bl2;
  bl = bl == sl2;
  bl = ul == ul2;
  bl = ul == bl2;
  bl = bl == ul2;
  bl = bl == bl2;

  bl = fd == fd2;
}

// CHECK-LABEL: define dso_local void @test_cmpne(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[CMP:%.*]] = icmp ne <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    [[SEXT:%.*]] = sext <16 x i1> [[CMP]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[CMP1:%.*]] = icmp ne <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    [[SEXT2:%.*]] = sext <16 x i1> [[CMP1]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT2]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[CMP3:%.*]] = icmp ne <16 x i8> [[TMP4]], [[TMP5]]
// CHECK-NEXT:    [[SEXT4:%.*]] = sext <16 x i1> [[CMP3]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT4]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[CMP5:%.*]] = icmp ne <16 x i8> [[TMP6]], [[TMP7]]
// CHECK-NEXT:    [[SEXT6:%.*]] = sext <16 x i1> [[CMP5]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT6]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[CMP7:%.*]] = icmp ne <16 x i8> [[TMP8]], [[TMP9]]
// CHECK-NEXT:    [[SEXT8:%.*]] = sext <16 x i1> [[CMP7]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT8]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[CMP9:%.*]] = icmp ne <16 x i8> [[TMP10]], [[TMP11]]
// CHECK-NEXT:    [[SEXT10:%.*]] = sext <16 x i1> [[CMP9]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT10]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[CMP11:%.*]] = icmp ne <16 x i8> [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[SEXT12:%.*]] = sext <16 x i1> [[CMP11]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT12]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[CMP13:%.*]] = icmp ne <8 x i16> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    [[SEXT14:%.*]] = sext <8 x i1> [[CMP13]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT14]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[CMP15:%.*]] = icmp ne <8 x i16> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    [[SEXT16:%.*]] = sext <8 x i1> [[CMP15]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT16]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[CMP17:%.*]] = icmp ne <8 x i16> [[TMP18]], [[TMP19]]
// CHECK-NEXT:    [[SEXT18:%.*]] = sext <8 x i1> [[CMP17]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT18]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[CMP19:%.*]] = icmp ne <8 x i16> [[TMP20]], [[TMP21]]
// CHECK-NEXT:    [[SEXT20:%.*]] = sext <8 x i1> [[CMP19]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT20]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[CMP21:%.*]] = icmp ne <8 x i16> [[TMP22]], [[TMP23]]
// CHECK-NEXT:    [[SEXT22:%.*]] = sext <8 x i1> [[CMP21]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT22]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[CMP23:%.*]] = icmp ne <8 x i16> [[TMP24]], [[TMP25]]
// CHECK-NEXT:    [[SEXT24:%.*]] = sext <8 x i1> [[CMP23]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT24]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP26:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP27:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[CMP25:%.*]] = icmp ne <8 x i16> [[TMP26]], [[TMP27]]
// CHECK-NEXT:    [[SEXT26:%.*]] = sext <8 x i1> [[CMP25]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT26]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[CMP27:%.*]] = icmp ne <4 x i32> [[TMP28]], [[TMP29]]
// CHECK-NEXT:    [[SEXT28:%.*]] = sext <4 x i1> [[CMP27]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT28]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[CMP29:%.*]] = icmp ne <4 x i32> [[TMP30]], [[TMP31]]
// CHECK-NEXT:    [[SEXT30:%.*]] = sext <4 x i1> [[CMP29]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT30]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP32:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[CMP31:%.*]] = icmp ne <4 x i32> [[TMP32]], [[TMP33]]
// CHECK-NEXT:    [[SEXT32:%.*]] = sext <4 x i1> [[CMP31]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT32]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP34:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP35:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[CMP33:%.*]] = icmp ne <4 x i32> [[TMP34]], [[TMP35]]
// CHECK-NEXT:    [[SEXT34:%.*]] = sext <4 x i1> [[CMP33]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT34]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP36:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[CMP35:%.*]] = icmp ne <4 x i32> [[TMP36]], [[TMP37]]
// CHECK-NEXT:    [[SEXT36:%.*]] = sext <4 x i1> [[CMP35]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT36]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[CMP37:%.*]] = icmp ne <4 x i32> [[TMP38]], [[TMP39]]
// CHECK-NEXT:    [[SEXT38:%.*]] = sext <4 x i1> [[CMP37]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT38]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP40:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP41:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[CMP39:%.*]] = icmp ne <4 x i32> [[TMP40]], [[TMP41]]
// CHECK-NEXT:    [[SEXT40:%.*]] = sext <4 x i1> [[CMP39]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT40]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP42:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[CMP41:%.*]] = icmp ne <2 x i64> [[TMP42]], [[TMP43]]
// CHECK-NEXT:    [[SEXT42:%.*]] = sext <2 x i1> [[CMP41]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT42]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP44:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[CMP43:%.*]] = icmp ne <2 x i64> [[TMP44]], [[TMP45]]
// CHECK-NEXT:    [[SEXT44:%.*]] = sext <2 x i1> [[CMP43]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT44]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP47:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[CMP45:%.*]] = icmp ne <2 x i64> [[TMP46]], [[TMP47]]
// CHECK-NEXT:    [[SEXT46:%.*]] = sext <2 x i1> [[CMP45]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT46]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP48:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP49:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[CMP47:%.*]] = icmp ne <2 x i64> [[TMP48]], [[TMP49]]
// CHECK-NEXT:    [[SEXT48:%.*]] = sext <2 x i1> [[CMP47]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT48]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP50:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP51:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[CMP49:%.*]] = icmp ne <2 x i64> [[TMP50]], [[TMP51]]
// CHECK-NEXT:    [[SEXT50:%.*]] = sext <2 x i1> [[CMP49]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT50]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP52:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[CMP51:%.*]] = icmp ne <2 x i64> [[TMP52]], [[TMP53]]
// CHECK-NEXT:    [[SEXT52:%.*]] = sext <2 x i1> [[CMP51]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT52]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[CMP53:%.*]] = icmp ne <2 x i64> [[TMP54]], [[TMP55]]
// CHECK-NEXT:    [[SEXT54:%.*]] = sext <2 x i1> [[CMP53]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT54]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP56:%.*]] = load volatile <2 x double>, ptr @fd, align 8
// CHECK-NEXT:    [[TMP57:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[CMP55:%.*]] = fcmp une <2 x double> [[TMP56]], [[TMP57]]
// CHECK-NEXT:    [[SEXT56:%.*]] = sext <2 x i1> [[CMP55]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT56]], ptr @bl, align 8
// CHECK-NEXT:    ret void
//
void test_cmpne(void) {

  bc = sc != sc2;
  bc = sc != bc2;
  bc = bc != sc2;
  bc = uc != uc2;
  bc = uc != bc2;
  bc = bc != uc2;
  bc = bc != bc2;

  bs = ss != ss2;
  bs = ss != bs2;
  bs = bs != ss2;
  bs = us != us2;
  bs = us != bs2;
  bs = bs != us2;
  bs = bs != bs2;

  bi = si != si2;
  bi = si != bi2;
  bi = bi != si2;
  bi = ui != ui2;
  bi = ui != bi2;
  bi = bi != ui2;
  bi = bi != bi2;

  bl = sl != sl2;
  bl = sl != bl2;
  bl = bl != sl2;
  bl = ul != ul2;
  bl = ul != bl2;
  bl = bl != ul2;
  bl = bl != bl2;

  bl = fd != fd2;
}

// CHECK-LABEL: define dso_local void @test_cmpge(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[CMP:%.*]] = icmp sge <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    [[SEXT:%.*]] = sext <16 x i1> [[CMP]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[CMP1:%.*]] = icmp uge <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    [[SEXT2:%.*]] = sext <16 x i1> [[CMP1]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT2]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[CMP3:%.*]] = icmp uge <16 x i8> [[TMP4]], [[TMP5]]
// CHECK-NEXT:    [[SEXT4:%.*]] = sext <16 x i1> [[CMP3]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT4]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[CMP5:%.*]] = icmp sge <8 x i16> [[TMP6]], [[TMP7]]
// CHECK-NEXT:    [[SEXT6:%.*]] = sext <8 x i1> [[CMP5]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT6]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[CMP7:%.*]] = icmp uge <8 x i16> [[TMP8]], [[TMP9]]
// CHECK-NEXT:    [[SEXT8:%.*]] = sext <8 x i1> [[CMP7]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT8]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[CMP9:%.*]] = icmp uge <8 x i16> [[TMP10]], [[TMP11]]
// CHECK-NEXT:    [[SEXT10:%.*]] = sext <8 x i1> [[CMP9]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT10]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[CMP11:%.*]] = icmp sge <4 x i32> [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[SEXT12:%.*]] = sext <4 x i1> [[CMP11]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT12]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[CMP13:%.*]] = icmp uge <4 x i32> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    [[SEXT14:%.*]] = sext <4 x i1> [[CMP13]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT14]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[CMP15:%.*]] = icmp uge <4 x i32> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    [[SEXT16:%.*]] = sext <4 x i1> [[CMP15]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT16]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[CMP17:%.*]] = icmp sge <2 x i64> [[TMP18]], [[TMP19]]
// CHECK-NEXT:    [[SEXT18:%.*]] = sext <2 x i1> [[CMP17]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT18]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[CMP19:%.*]] = icmp uge <2 x i64> [[TMP20]], [[TMP21]]
// CHECK-NEXT:    [[SEXT20:%.*]] = sext <2 x i1> [[CMP19]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT20]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[CMP21:%.*]] = icmp uge <2 x i64> [[TMP22]], [[TMP23]]
// CHECK-NEXT:    [[SEXT22:%.*]] = sext <2 x i1> [[CMP21]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT22]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <2 x double>, ptr @fd, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[CMP23:%.*]] = fcmp oge <2 x double> [[TMP24]], [[TMP25]]
// CHECK-NEXT:    [[SEXT24:%.*]] = sext <2 x i1> [[CMP23]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT24]], ptr @bl, align 8
// CHECK-NEXT:    ret void
//
void test_cmpge(void) {

  bc = sc >= sc2;
  bc = uc >= uc2;
  bc = bc >= bc2;

  bs = ss >= ss2;
  bs = us >= us2;
  bs = bs >= bs2;

  bi = si >= si2;
  bi = ui >= ui2;
  bi = bi >= bi2;

  bl = sl >= sl2;
  bl = ul >= ul2;
  bl = bl >= bl2;

  bl = fd >= fd2;
}

// CHECK-LABEL: define dso_local void @test_cmpgt(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[CMP:%.*]] = icmp sgt <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    [[SEXT:%.*]] = sext <16 x i1> [[CMP]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    [[SEXT2:%.*]] = sext <16 x i1> [[CMP1]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT2]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[CMP3:%.*]] = icmp ugt <16 x i8> [[TMP4]], [[TMP5]]
// CHECK-NEXT:    [[SEXT4:%.*]] = sext <16 x i1> [[CMP3]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT4]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[CMP5:%.*]] = icmp sgt <8 x i16> [[TMP6]], [[TMP7]]
// CHECK-NEXT:    [[SEXT6:%.*]] = sext <8 x i1> [[CMP5]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT6]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[CMP7:%.*]] = icmp ugt <8 x i16> [[TMP8]], [[TMP9]]
// CHECK-NEXT:    [[SEXT8:%.*]] = sext <8 x i1> [[CMP7]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT8]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[CMP9:%.*]] = icmp ugt <8 x i16> [[TMP10]], [[TMP11]]
// CHECK-NEXT:    [[SEXT10:%.*]] = sext <8 x i1> [[CMP9]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT10]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[CMP11:%.*]] = icmp sgt <4 x i32> [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[SEXT12:%.*]] = sext <4 x i1> [[CMP11]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT12]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[CMP13:%.*]] = icmp ugt <4 x i32> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    [[SEXT14:%.*]] = sext <4 x i1> [[CMP13]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT14]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[CMP15:%.*]] = icmp ugt <4 x i32> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    [[SEXT16:%.*]] = sext <4 x i1> [[CMP15]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT16]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[CMP17:%.*]] = icmp sgt <2 x i64> [[TMP18]], [[TMP19]]
// CHECK-NEXT:    [[SEXT18:%.*]] = sext <2 x i1> [[CMP17]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT18]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[CMP19:%.*]] = icmp ugt <2 x i64> [[TMP20]], [[TMP21]]
// CHECK-NEXT:    [[SEXT20:%.*]] = sext <2 x i1> [[CMP19]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT20]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[CMP21:%.*]] = icmp ugt <2 x i64> [[TMP22]], [[TMP23]]
// CHECK-NEXT:    [[SEXT22:%.*]] = sext <2 x i1> [[CMP21]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT22]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <2 x double>, ptr @fd, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[CMP23:%.*]] = fcmp ogt <2 x double> [[TMP24]], [[TMP25]]
// CHECK-NEXT:    [[SEXT24:%.*]] = sext <2 x i1> [[CMP23]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT24]], ptr @bl, align 8
// CHECK-NEXT:    ret void
//
void test_cmpgt(void) {

  bc = sc > sc2;
  bc = uc > uc2;
  bc = bc > bc2;

  bs = ss > ss2;
  bs = us > us2;
  bs = bs > bs2;

  bi = si > si2;
  bi = ui > ui2;
  bi = bi > bi2;

  bl = sl > sl2;
  bl = ul > ul2;
  bl = bl > bl2;

  bl = fd > fd2;
}

// CHECK-LABEL: define dso_local void @test_cmple(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[CMP:%.*]] = icmp sle <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    [[SEXT:%.*]] = sext <16 x i1> [[CMP]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[CMP1:%.*]] = icmp ule <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    [[SEXT2:%.*]] = sext <16 x i1> [[CMP1]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT2]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[CMP3:%.*]] = icmp ule <16 x i8> [[TMP4]], [[TMP5]]
// CHECK-NEXT:    [[SEXT4:%.*]] = sext <16 x i1> [[CMP3]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT4]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[CMP5:%.*]] = icmp sle <8 x i16> [[TMP6]], [[TMP7]]
// CHECK-NEXT:    [[SEXT6:%.*]] = sext <8 x i1> [[CMP5]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT6]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[CMP7:%.*]] = icmp ule <8 x i16> [[TMP8]], [[TMP9]]
// CHECK-NEXT:    [[SEXT8:%.*]] = sext <8 x i1> [[CMP7]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT8]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[CMP9:%.*]] = icmp ule <8 x i16> [[TMP10]], [[TMP11]]
// CHECK-NEXT:    [[SEXT10:%.*]] = sext <8 x i1> [[CMP9]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT10]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[CMP11:%.*]] = icmp sle <4 x i32> [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[SEXT12:%.*]] = sext <4 x i1> [[CMP11]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT12]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[CMP13:%.*]] = icmp ule <4 x i32> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    [[SEXT14:%.*]] = sext <4 x i1> [[CMP13]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT14]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[CMP15:%.*]] = icmp ule <4 x i32> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    [[SEXT16:%.*]] = sext <4 x i1> [[CMP15]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT16]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[CMP17:%.*]] = icmp sle <2 x i64> [[TMP18]], [[TMP19]]
// CHECK-NEXT:    [[SEXT18:%.*]] = sext <2 x i1> [[CMP17]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT18]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[CMP19:%.*]] = icmp ule <2 x i64> [[TMP20]], [[TMP21]]
// CHECK-NEXT:    [[SEXT20:%.*]] = sext <2 x i1> [[CMP19]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT20]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[CMP21:%.*]] = icmp ule <2 x i64> [[TMP22]], [[TMP23]]
// CHECK-NEXT:    [[SEXT22:%.*]] = sext <2 x i1> [[CMP21]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT22]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <2 x double>, ptr @fd, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[CMP23:%.*]] = fcmp ole <2 x double> [[TMP24]], [[TMP25]]
// CHECK-NEXT:    [[SEXT24:%.*]] = sext <2 x i1> [[CMP23]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT24]], ptr @bl, align 8
// CHECK-NEXT:    ret void
//
void test_cmple(void) {

  bc = sc <= sc2;
  bc = uc <= uc2;
  bc = bc <= bc2;

  bs = ss <= ss2;
  bs = us <= us2;
  bs = bs <= bs2;

  bi = si <= si2;
  bi = ui <= ui2;
  bi = bi <= bi2;

  bl = sl <= sl2;
  bl = ul <= ul2;
  bl = bl <= bl2;

  bl = fd <= fd2;
}

// CHECK-LABEL: define dso_local void @test_cmplt(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = load volatile <16 x i8>, ptr @sc, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, ptr @sc2, align 8
// CHECK-NEXT:    [[CMP:%.*]] = icmp slt <16 x i8> [[TMP0]], [[TMP1]]
// CHECK-NEXT:    [[SEXT:%.*]] = sext <16 x i1> [[CMP]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load volatile <16 x i8>, ptr @uc, align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load volatile <16 x i8>, ptr @uc2, align 8
// CHECK-NEXT:    [[CMP1:%.*]] = icmp ult <16 x i8> [[TMP2]], [[TMP3]]
// CHECK-NEXT:    [[SEXT2:%.*]] = sext <16 x i1> [[CMP1]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT2]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load volatile <16 x i8>, ptr @bc, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load volatile <16 x i8>, ptr @bc2, align 8
// CHECK-NEXT:    [[CMP3:%.*]] = icmp ult <16 x i8> [[TMP4]], [[TMP5]]
// CHECK-NEXT:    [[SEXT4:%.*]] = sext <16 x i1> [[CMP3]] to <16 x i8>
// CHECK-NEXT:    store volatile <16 x i8> [[SEXT4]], ptr @bc, align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load volatile <8 x i16>, ptr @ss, align 8
// CHECK-NEXT:    [[TMP7:%.*]] = load volatile <8 x i16>, ptr @ss2, align 8
// CHECK-NEXT:    [[CMP5:%.*]] = icmp slt <8 x i16> [[TMP6]], [[TMP7]]
// CHECK-NEXT:    [[SEXT6:%.*]] = sext <8 x i1> [[CMP5]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT6]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load volatile <8 x i16>, ptr @us, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load volatile <8 x i16>, ptr @us2, align 8
// CHECK-NEXT:    [[CMP7:%.*]] = icmp ult <8 x i16> [[TMP8]], [[TMP9]]
// CHECK-NEXT:    [[SEXT8:%.*]] = sext <8 x i1> [[CMP7]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT8]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP10:%.*]] = load volatile <8 x i16>, ptr @bs, align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load volatile <8 x i16>, ptr @bs2, align 8
// CHECK-NEXT:    [[CMP9:%.*]] = icmp ult <8 x i16> [[TMP10]], [[TMP11]]
// CHECK-NEXT:    [[SEXT10:%.*]] = sext <8 x i1> [[CMP9]] to <8 x i16>
// CHECK-NEXT:    store volatile <8 x i16> [[SEXT10]], ptr @bs, align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load volatile <4 x i32>, ptr @si, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = load volatile <4 x i32>, ptr @si2, align 8
// CHECK-NEXT:    [[CMP11:%.*]] = icmp slt <4 x i32> [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[SEXT12:%.*]] = sext <4 x i1> [[CMP11]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT12]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP14:%.*]] = load volatile <4 x i32>, ptr @ui, align 8
// CHECK-NEXT:    [[TMP15:%.*]] = load volatile <4 x i32>, ptr @ui2, align 8
// CHECK-NEXT:    [[CMP13:%.*]] = icmp ult <4 x i32> [[TMP14]], [[TMP15]]
// CHECK-NEXT:    [[SEXT14:%.*]] = sext <4 x i1> [[CMP13]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT14]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP16:%.*]] = load volatile <4 x i32>, ptr @bi, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = load volatile <4 x i32>, ptr @bi2, align 8
// CHECK-NEXT:    [[CMP15:%.*]] = icmp ult <4 x i32> [[TMP16]], [[TMP17]]
// CHECK-NEXT:    [[SEXT16:%.*]] = sext <4 x i1> [[CMP15]] to <4 x i32>
// CHECK-NEXT:    store volatile <4 x i32> [[SEXT16]], ptr @bi, align 8
// CHECK-NEXT:    [[TMP18:%.*]] = load volatile <2 x i64>, ptr @sl, align 8
// CHECK-NEXT:    [[TMP19:%.*]] = load volatile <2 x i64>, ptr @sl2, align 8
// CHECK-NEXT:    [[CMP17:%.*]] = icmp slt <2 x i64> [[TMP18]], [[TMP19]]
// CHECK-NEXT:    [[SEXT18:%.*]] = sext <2 x i1> [[CMP17]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT18]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load volatile <2 x i64>, ptr @ul, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load volatile <2 x i64>, ptr @ul2, align 8
// CHECK-NEXT:    [[CMP19:%.*]] = icmp ult <2 x i64> [[TMP20]], [[TMP21]]
// CHECK-NEXT:    [[SEXT20:%.*]] = sext <2 x i1> [[CMP19]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT20]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP22:%.*]] = load volatile <2 x i64>, ptr @bl, align 8
// CHECK-NEXT:    [[TMP23:%.*]] = load volatile <2 x i64>, ptr @bl2, align 8
// CHECK-NEXT:    [[CMP21:%.*]] = icmp ult <2 x i64> [[TMP22]], [[TMP23]]
// CHECK-NEXT:    [[SEXT22:%.*]] = sext <2 x i1> [[CMP21]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT22]], ptr @bl, align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load volatile <2 x double>, ptr @fd, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load volatile <2 x double>, ptr @fd2, align 8
// CHECK-NEXT:    [[CMP23:%.*]] = fcmp olt <2 x double> [[TMP24]], [[TMP25]]
// CHECK-NEXT:    [[SEXT24:%.*]] = sext <2 x i1> [[CMP23]] to <2 x i64>
// CHECK-NEXT:    store volatile <2 x i64> [[SEXT24]], ptr @bl, align 8
// CHECK-NEXT:    ret void
//
void test_cmplt(void) {

  bc = sc < sc2;
  bc = uc < uc2;
  bc = bc < bc2;

  bs = ss < ss2;
  bs = us < us2;
  bs = bs < bs2;

  bi = si < si2;
  bi = ui < ui2;
  bi = bi < bi2;

  bl = sl < sl2;
  bl = ul < ul2;
  bl = bl < bl2;

  bl = fd < fd2;
}

