;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt -all %s -S -o - | filecheck %s

(module $parse
 ;; types

 ;; CHECK:      (type $0 (func))

 ;; CHECK:      (type $1 (func (result i32)))

 ;; CHECK:      (type $ret2 (func (result i32 i32)))
 (type $ret2 (func (result i32 i32)))

 (rec
  ;; CHECK:      (type $pair (struct (field $first (mut i32)) (field $second (mut i64))))

  ;; CHECK:      (type $4 (func (result i32 i64)))

  ;; CHECK:      (type $void (sub (func)))

  ;; CHECK:      (type $6 (func (param i32 i64)))

  ;; CHECK:      (type $a2 (array (mut f32)))

  ;; CHECK:      (type $a1 (array i64))

  ;; CHECK:      (type $9 (func (param anyref)))

  ;; CHECK:      (type $simple (func (param i32 i64) (result f32)))

  ;; CHECK:      (type $simple-cont (cont $simple))

  ;; CHECK:      (type $12 (func (param i32 i64 v128)))

  ;; CHECK:      (rec
  ;; CHECK-NEXT:  (type $s0 (struct))
  (type $s0 (struct))
  ;; CHECK:       (type $s1 (struct))
  (type $s1 (struct (field)))
 )

 (rec)

 ;; CHECK:      (type $packed-i8 (array (mut i8)))

 ;; CHECK:      (type $many (sub (func (param i32 i64 f32 f64) (result anyref (ref func)))))

 ;; CHECK:      (type $17 (func (param i32)))

 ;; CHECK:      (type $a0 (array i32))

 ;; CHECK:      (type $19 (func (param i32 i64) (result i32 i64)))

 ;; CHECK:      (type $20 (func (result exnref)))

 ;; CHECK:      (type $21 (func (result i64)))

 ;; CHECK:      (type $22 (func (result i64 f32)))

 ;; CHECK:      (type $23 (func (param i32 i32 i32)))

 ;; CHECK:      (type $24 (func (param v128 i32) (result v128)))

 ;; CHECK:      (type $25 (func (param i32) (result i32)))

 ;; CHECK:      (type $26 (func (param i32) (result i32 i64)))

 ;; CHECK:      (type $packed-i16 (array (mut i16)))

 ;; CHECK:      (type $any-array (array (mut anyref)))

 ;; CHECK:      (type $29 (func (param stringref stringref) (result i32)))

 ;; CHECK:      (type $30 (func (param i64 v128) (result v128)))

 ;; CHECK:      (type $31 (func (param i64 v128)))

 ;; CHECK:      (type $cont-bind-before-func (func (param i32 i64 i32 i64) (result f32)))

 ;; CHECK:      (type $cont-bind-before (cont $cont-bind-before-func))

 ;; CHECK:      (type $34 (func (result structref arrayref)))

 ;; CHECK:      (type $35 (func (result arrayref structref)))

 ;; CHECK:      (type $36 (func (result i32 i64 (ref null $simple-cont))))

 ;; CHECK:      (type $37 (func (param i32 i32)))

 ;; CHECK:      (type $38 (func (param exnref)))

 ;; CHECK:      (type $39 (func (result anyref anyref)))

 ;; CHECK:      (type $40 (func (param i32 i32 f64 f64)))

 ;; CHECK:      (type $41 (func (param i64)))

 ;; CHECK:      (type $42 (func (param v128) (result i32)))

 ;; CHECK:      (type $43 (func (param v128 v128) (result v128)))

 ;; CHECK:      (type $44 (func (param v128 v128 v128) (result v128)))

 ;; CHECK:      (type $45 (func (param i32 i32 i64 i64)))

 ;; CHECK:      (type $46 (func (param i64) (result i32 i64)))

 ;; CHECK:      (type $47 (func (param anyref) (result i32)))

 ;; CHECK:      (type $48 (func (param eqref eqref) (result i32)))

 ;; CHECK:      (type $49 (func (param i32) (result i31ref)))

 ;; CHECK:      (type $50 (func (param i31ref)))

 ;; CHECK:      (type $51 (func (param i32 i64) (result (ref $pair))))

 ;; CHECK:      (type $52 (func (result (ref $pair))))

 ;; CHECK:      (type $53 (func (param (ref $pair)) (result i32)))

 ;; CHECK:      (type $54 (func (param (ref $pair)) (result i64)))

 ;; CHECK:      (type $55 (func (param (ref null $pair)) (result i32)))

 ;; CHECK:      (type $56 (func (param (ref $pair) i32)))

 ;; CHECK:      (type $57 (func (param (ref $pair) i64)))

 ;; CHECK:      (type $58 (func (param (ref null $pair) i64)))

 ;; CHECK:      (type $59 (func (param i64 i32) (result (ref $a1))))

 ;; CHECK:      (type $60 (func (param i32) (result (ref $a1))))

 ;; CHECK:      (type $61 (func (param i32 i32) (result (ref $a1))))

 ;; CHECK:      (type $62 (func (param (ref $a1) i32) (result i64)))

 ;; CHECK:      (type $63 (func (param (ref $packed-i8) i32) (result i32)))

 ;; CHECK:      (type $64 (func (param (ref $packed-i16) i32) (result i32)))

 ;; CHECK:      (type $65 (func (param (ref $a2) i32 f32)))

 ;; CHECK:      (type $66 (func (param arrayref) (result i32)))

 ;; CHECK:      (type $67 (func (param (ref $a2) i32 (ref $a2) i32 i32)))

 ;; CHECK:      (type $68 (func (param (ref $a2) i32 f32 i32)))

 ;; CHECK:      (type $69 (func (param (ref $a2) i32 i32 i32)))

 ;; CHECK:      (type $70 (func (param (ref $any-array) i32 i32 i32)))

 ;; CHECK:      (type $71 (func (param externref)))

 ;; CHECK:      (type $72 (func (param (ref $packed-i8) i32 i32) (result stringref)))

 ;; CHECK:      (type $73 (func (param i32) (result stringref)))

 ;; CHECK:      (type $74 (func (result (ref string))))

 ;; CHECK:      (type $75 (func (param stringref)))

 ;; CHECK:      (type $76 (func (param stringref (ref $packed-i8) i32) (result i32)))

 ;; CHECK:      (type $77 (func (param stringref stringref) (result (ref string))))

 ;; CHECK:      (type $78 (func (param stringref i32) (result i32)))

 ;; CHECK:      (type $79 (func (param stringref i32 i32) (result (ref string))))

 ;; CHECK:      (type $80 (func (param (ref $simple-cont))))

 ;; CHECK:      (type $to-f32 (func (result f32)))

 ;; CHECK:      (type $to-f32-cont (cont $to-f32))

 ;; CHECK:      (type $83 (func (param (ref $simple)) (result (ref $simple-cont))))

 ;; CHECK:      (type $84 (func (param (ref $cont-bind-before)) (result (ref $simple-cont))))

 ;; CHECK:      (type $s2 (struct (field i32)))
 (type $s2 (struct i32))
 ;; CHECK:      (type $s3 (struct (field i64)))
 (type $s3 (struct (field i64)))
 ;; CHECK:      (type $s4 (struct (field $x f32)))
 (type $s4 (struct (field $x f32)))
 ;; CHECK:      (type $s5 (struct (field i32) (field i64)))
 (type $s5 (struct i32 i64))
 ;; CHECK:      (type $s6 (struct (field i64) (field f32)))
 (type $s6 (struct (field i64 f32)))
 ;; CHECK:      (type $s7 (struct (field $x f32) (field $y f64)))
 (type $s7 (struct (field $x f32) (field $y f64)))
 ;; CHECK:      (type $s8 (struct (field i32) (field i64) (field $z f32) (field f64) (field (mut i32))))
 (type $s8 (struct i32 (field) i64 (field $z f32) (field f64 (mut i32))))

 (type $a0 (array i32))
 (type $a1 (array (field i64)))
 (type $a2 (array (mut f32)))
 ;; CHECK:      (type $a3 (array (mut f64)))
 (type $a3 (array (field $x (mut f64))))

 (type $pair (struct (field $first (mut i32)) (field $second (mut i64))))

 (type $packed-i8 (array (mut i8)))

 (type $packed-i16 (array (mut i16)))

 (type $any-array (array (mut anyref)))

 (rec
   (type $void (sub (func)))
 )

 ;; CHECK:      (type $subvoid (sub final $void (func)))
 (type $subvoid (sub final $void (func)))

 (type $simple (func (param $x i32) (param $y i64) (result f32)))
 (type $to-f32 (func (result f32)))

 (type $many (sub (func (param $x i32) (param i64 f32) (param) (param $y f64)
                             (result anyref (ref func)))))

 ;; CHECK:      (type $submany (sub final $many (func (param i32 i64 f32 f64) (result anyref (ref func)))))
 (type $submany (sub final $many (func (param i32 i64 f32 f64) (result anyref (ref func)))))

 (type $simple-cont (cont $simple))
 (type $to-f32-cont (cont $to-f32))


 (type $cont-bind-before-func (func (param i32) (param i64) (param i32) (param i64) (result f32)))
 (type $cont-bind-before (cont $cont-bind-before-func))

 ;; CHECK:      (type $all-types (struct (field externref) (field (ref extern)) (field (ref null (shared extern))) (field (ref (shared extern))) (field funcref) (field (ref func)) (field (ref null (shared func))) (field (ref (shared func))) (field anyref) (field (ref any)) (field (ref null (shared any))) (field (ref (shared any))) (field eqref) (field (ref eq)) (field (ref null (shared eq))) (field (ref (shared eq))) (field i31ref) (field (ref i31)) (field (ref null (shared i31))) (field (ref (shared i31))) (field structref) (field (ref struct)) (field (ref null (shared struct))) (field (ref (shared struct))) (field arrayref) (field (ref array)) (field (ref null (shared array))) (field (ref (shared array))) (field exnref) (field (ref exn)) (field (ref null (shared exn))) (field (ref (shared exn))) (field stringref) (field (ref string)) (field (ref null (shared string))) (field (ref (shared string))) (field contref) (field (ref cont)) (field (ref null (shared cont))) (field (ref (shared cont))) (field nullref) (field (ref none)) (field (ref null (shared none))) (field (ref (shared none))) (field nullexternref) (field (ref noextern)) (field (ref null (shared noextern))) (field (ref (shared noextern))) (field nullfuncref) (field (ref nofunc)) (field (ref null (shared nofunc))) (field (ref (shared nofunc))) (field nullexnref) (field (ref noexn)) (field (ref null (shared noexn))) (field (ref (shared noexn))) (field nullcontref) (field (ref nocont)) (field (ref null (shared nocont))) (field (ref (shared nocont)))))
 (type $all-types (struct externref (ref extern) (ref null (shared extern)) (ref (shared extern))
                          funcref (ref func) (ref null (shared func)) (ref (shared func))
                          anyref (ref any) (ref null (shared any)) (ref (shared any))
                          eqref (ref eq) (ref null (shared eq)) (ref (shared eq))
                          i31ref (ref i31) (ref null (shared i31)) (ref (shared i31))
                          structref (ref struct) (ref null (shared struct)) (ref (shared struct))
                          arrayref (ref array) (ref null (shared array)) (ref (shared array))
                          exnref (ref exn) (ref null (shared exn)) (ref (shared exn))
                          stringref (ref string) (ref null (shared string)) (ref (shared string))
                          contref (ref cont) (ref null (shared cont)) (ref (shared cont))
                          nullref (ref none) (ref null (shared none)) (ref (shared none))
                          nullexternref (ref noextern) (ref null (shared noextern)) (ref (shared noextern))
                          nullfuncref (ref nofunc) (ref null (shared nofunc)) (ref (shared nofunc))
                          nullexnref (ref noexn) (ref null (shared noexn)) (ref (shared noexn))
                          nullcontref (ref nocont) (ref null (shared nocont)) (ref (shared nocont))))

 ;; imported memories
 (memory (export "mem") (export "mem2") (import "" "mem") 0)
 ;; CHECK:      (type $96 (func (param (ref $s0) (ref $s1) (ref $s2) (ref $s3) (ref $s4) (ref $s5) (ref $s6) (ref $s7) (ref $s8) (ref $a0) (ref $a1) (ref $a2) (ref $a3) (ref $subvoid) (ref $submany) (ref $all-types))))

 ;; CHECK:      (import "" "mem" (memory $mimport$0 0))

 ;; CHECK:      (import "mod" "imported-m" (memory $m-imported 1 2 shared))
 (import "mod" "imported-m" (memory $m-imported 1 2 shared))

 ;; imported tables
 (table (export "tab") (export "tab2") (import "" "tab") 0 funcref)
 (import "mod" "imported-tab" (table 2 3 externref))

 ;; imported globals
 (global $g1 (export "g1") (export "g1.1") (import "mod" "g1") i32)
 (global $g2 (import "mod" "g2") (mut i64))
 (global (import "" "g3") (ref 0))
 (global (import "mod" "") (ref null $many))
 ;; CHECK:      (import "" "tab" (table $timport$0 0 funcref))

 ;; CHECK:      (import "mod" "imported-tab" (table $timport$1 2 3 externref))

 ;; CHECK:      (import "mod" "g1" (global $g1 i32))

 ;; CHECK:      (import "mod" "g2" (global $g2 (mut i64)))

 ;; CHECK:      (import "" "g3" (global $gimport$0 (ref $ret2)))

 ;; CHECK:      (import "mod" "" (global $gimport$1 (ref null $many)))

 ;; CHECK:      (import "mod" "imported-g" (global $g-imported (mut i32)))
 (import "mod" "imported-g" (global $g-imported (mut i32)))

 ;; imported functions
 (func (export "f5.0") (export "f5.1") (import "mod" "f5"))
 (import "mod" "imported-f" (func (param) (result i32 i64)))

 ;; imported tags
 (tag $imported (export "t0.0") (export "t0.1") (import "mod" "t0") (param i32 i64))
 (tag (import "mod" "t1"))
 (import "mod" "imported-tag" (tag (param) (result)))

 ;; globals
 (global (mut i32) i32.const 0)

 ;; CHECK:      (import "mod" "f5" (func $fimport$0 (type $0)))

 ;; CHECK:      (import "mod" "imported-f" (func $fimport$1 (type $4) (result i32 i64)))

 ;; CHECK:      (import "mod" "t0" (tag $imported (param i32 i64)))

 ;; CHECK:      (import "mod" "t1" (tag $eimport$0))

 ;; CHECK:      (import "mod" "imported-tag" (tag $eimport$1))

 ;; CHECK:      (global $global$2 (mut i32) (i32.const 0))

 ;; CHECK:      (global $i32 i32 (i32.const 42))
 (global $i32 i32 i32.const 42)

 ;; CHECK:      (global $pair (mut (tuple i32 i64)) (tuple.make 2
 ;; CHECK-NEXT:  (i32.const 0)
 ;; CHECK-NEXT:  (i64.const 1)
 ;; CHECK-NEXT: ))
 (global $pair (mut (tuple i32 i64)) (tuple.make 2 (i32.const 0) (i64.const 1)))

 ;; memories
 ;; CHECK:      (memory $mem 1 1 shared)
 (memory $mem 1 1 shared)
 (memory 0 1 shared)
 ;; CHECK:      (memory $1 0 1 shared)

 ;; CHECK:      (memory $mem-i32 0 1)
 (memory $mem-i32 i32 0 1)

 ;; CHECK:      (memory $mem-i64 i64 2)
 (memory $mem-i64 i64 2)

 ;; CHECK:      (memory $mem-init 1 1)
 (memory $mem-init (data "hello inline data"))

 ;; CHECK:      (memory $mem-init-32 1 1)
 (memory $mem-init-32 i32 (data "hello i32 inline data"))

 ;; CHECK:      (memory $mem-init-64 i64 1 1)
 (memory $mem-init-64 i64 (data "hello i64 inline data"))

 ;; data segments
 (data "hello world")
 ;; CHECK:      (data $implicit-data (memory $mem-init) (i32.const 0) "hello inline data")

 ;; CHECK:      (data $implicit-data_1 (memory $mem-init-32) (i32.const 0) "hello i32 inline data")

 ;; CHECK:      (data $implicit-data_2 (memory $mem-init-64) (i64.const 0) "hello i64 inline data")

 ;; CHECK:      (data $0 "hello world")

 ;; CHECK:      (data $passive "hello again")
 (data $passive "hello" " " "again")

 ;; CHECK:      (data $active (i32.const 0) "active hello")
 (data $active (offset i32.const 0) "active hello" "" "")

 ;; CHECK:      (data $active2 (i32.const 1) "active again!")
 (data $active2 (offset (i32.const 1)) "" "active again" "!")

 ;; CHECK:      (data $active3 (memory $mem) (i32.const 42) "active abbreviated")
 (data $active3 (memory $mem) (i32.const 42) "" "active abbreviated" "")

 ;; CHECK:      (data $active4 (memory $mem-i32) (i32.const 16) "")
 (data $active4 (memory $mem-i32) (i32.const 16) "")

 (data (memory 5) (offset i64.const 0) "64-bit")

 ;; tables
 ;; CHECK:      (data $1 (memory $mem-i64) (i64.const 0) "64-bit")

 ;; CHECK:      (table $funcs 1 2 funcref)
 (table $funcs 1 2 (ref null func))

 ;; CHECK:      (table $table-any 3 3 anyref)
 (table $table-any anyref (elem (item i32.const 0 ref.i31) (ref.null any) (item (ref.i31 (i32.const 0)))))

 ;; elems
 ;; CHECK:      (elem $implicit-elem (table $table-any) (i32.const 0) anyref (item (ref.i31
 ;; CHECK-NEXT:  (i32.const 0)
 ;; CHECK-NEXT: )) (item (ref.null none)) (item (ref.i31
 ;; CHECK-NEXT:  (i32.const 0)
 ;; CHECK-NEXT: )))

 ;; CHECK:      (elem $implicit-table (table $timport$0) (i32.const 0) funcref (item (ref.null nofunc)) (item (ref.null nofunc)) (item (ref.null nofunc)))
 (elem $implicit-table (offset i32.const 0) funcref (ref.null func) (item ref.null func) (item (ref.null func)))

 ;; CHECK:      (elem $implicit-table-2 (table $timport$0) (i32.const 1) func)
 (elem $implicit-table-2 (i32.const 1) funcref)

 ;; CHECK:      (elem $implicit-table-indices (table $timport$0) (i32.const 2) func $fimport$0 $fimport$1 $2)
 (elem $implicit-table-indices (offset (i32.const 2)) func 0 1 2)

 ;; CHECK:      (elem $implicit-table-legacy-indices (table $timport$0) (i32.const 3) func $fimport$0 $fimport$1 $2 $f1)
 (elem $implicit-table-legacy-indices (i32.const 3) 0 1 2 3)

 ;; CHECK:      (elem $explicit-table (table $timport$0) (i32.const 0) funcref (item (ref.null nofunc)))
 (elem $explicit-table (table 0) (offset (i32.const 0)) funcref (item ref.null func))

 ;; CHECK:      (elem $explicit-table-named (table $table-any) (i32.const 1) anyref)
 (elem $explicit-table-named (table $table-any) (i32.const 1) anyref)

 ;; CHECK:      (elem $passive (ref null $s0) (item (struct.new_default $s0)) (item (struct.new_default $s0)))
 (elem $passive (ref null $s0) (item struct.new $s0) (struct.new $s0))

 ;; CHECK:      (elem $passive-2 anyref (item (struct.new_default $s0)) (item (struct.new_default $s0)))
 (elem $passive-2 anyref (item struct.new $s0) (struct.new $s0))

 ;; CHECK:      (elem declare func $ref-func $table-fill $table-grow $table-set)
 (elem declare func 0 1 2 3)

 (elem $declare-2 declare funcref (item ref.func 0) (ref.func 1) (item (ref.func 2)))

 ;; tags
 (tag)

 ;; CHECK:      (tag $tag$2)

 ;; CHECK:      (tag $empty)
 (tag $empty)

 ;; CHECK:      (tag $tag-i32 (param i32))
 (tag $tag-i32 (param $x i32))

 ;; CHECK:      (tag $tag-pair (param i32 i64))
 (tag $tag-pair (param i32 i64))

 ;; CHECK:      (tag $tag-pair-to-pair (param i32 i64) (result i32 i64))
 (tag $tag-pair-to-pair (param i32 i64) (result i32 i64))

 ;; explicit exports
 (export "exported-func" (func 0))
 ;; CHECK:      (export "mem" (memory $mimport$0))

 ;; CHECK:      (export "mem2" (memory $mimport$0))

 ;; CHECK:      (export "tab" (table $timport$0))

 ;; CHECK:      (export "tab2" (table $timport$0))

 ;; CHECK:      (export "g1" (global $g1))

 ;; CHECK:      (export "g1.1" (global $g1))

 ;; CHECK:      (export "f5.0" (func $fimport$0))

 ;; CHECK:      (export "f5.1" (func $fimport$0))

 ;; CHECK:      (export "t0.0" (tag $imported))

 ;; CHECK:      (export "t0.1" (tag $imported))

 ;; CHECK:      (export "exported-func" (func $fimport$0))

 ;; CHECK:      (export "exported-table" (table $funcs))
 (export "exported-table" (table $funcs))
 (export "exported-memory" (memory 0))
 ;; CHECK:      (export "exported-memory" (memory $mimport$0))

 ;; CHECK:      (export "exported-global" (global $g1))
 (export "exported-global" (global $g1))
 (export "exported-tag" (tag 0))

 ;; start function
 ;; CHECK:      (export "exported-tag" (tag $imported))

 ;; CHECK:      (start $return-none)
 (start $return-none)

 ;; Annotations
 (@annotation this is a meaningless (@annotation ) ;; This is still a comment ))
   it spans multiple lines just fine and can include $ids 0x42 numbers and "strings"
 )

 ;; functions
 (func)

 ;; CHECK:      (func $2 (type $0)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT: )

 ;; CHECK:      (func $f1 (type $17) (param $0 i32)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT: )
 (func $f1 (param i32))
 ;; CHECK:      (func $f2 (type $17) (param $x i32)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT: )
 (func $f2 (param $x i32))
 ;; CHECK:      (func $f3 (type $1) (result i32)
 ;; CHECK-NEXT:  (i32.const 0)
 ;; CHECK-NEXT: )
 (func $f3 (result i32)
  i32.const 0
 )
 ;; CHECK:      (func $f4 (type $void)
 ;; CHECK-NEXT:  (local $0 i32)
 ;; CHECK-NEXT:  (local $1 i64)
 ;; CHECK-NEXT:  (local $l f32)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT: )
 (func $f4 (type 18) (local i32 i64) (local $l f32))

 ;; CHECK:      (func $"[quoted_name]" (type $0)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT: )
 (func $"[quoted_name]")

 ;; CHECK:      (func $nop-skate (type $0)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT: )
 (func $nop-skate
  nop
  nop
  unreachable
  nop
  nop
 )

 ;; CHECK:      (func $nop-ski (type $0)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT: )
 (func $nop-ski
  (unreachable
   (nop
    (nop)
    (nop)
    (nop
     (nop)
    )
   )
   (nop)
  )
  (nop)
 )

 ;; CHECK:      (func $nop-sled (type $0)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT: )
 (func $nop-sled
  nop
  (nop
   (nop
    (unreachable)
   )
  )
  nop
  (unreachable)
  nop
 )

 ;; CHECK:      (func $add (type $1) (result i32)
 ;; CHECK-NEXT:  (i32.add
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $add (result i32)
  i32.const 1
  i32.const 2
  i32.add
 )

 ;; CHECK:      (func $add-folded (type $1) (result i32)
 ;; CHECK-NEXT:  (i32.add
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $add-folded (result i32)
  (i32.add
   (i32.const 1)
   (i32.const 2)
  )
 )

 ;; CHECK:      (func $add-stacky (type $1) (result i32)
 ;; CHECK-NEXT:  (local $scratch i32)
 ;; CHECK-NEXT:  (i32.add
 ;; CHECK-NEXT:   (block (result i32)
 ;; CHECK-NEXT:    (local.set $scratch
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (local.get $scratch)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $add-stacky (result i32)
  i32.const 1
  nop
  i32.const 2
  i32.add
 )

 ;; CHECK:      (func $add-stacky-2 (type $1) (result i32)
 ;; CHECK-NEXT:  (local $scratch i32)
 ;; CHECK-NEXT:  (i32.add
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (block (result i32)
 ;; CHECK-NEXT:    (local.set $scratch
 ;; CHECK-NEXT:     (i32.const 2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (local.get $scratch)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $add-stacky-2 (result i32)
  i32.const 1
  i32.const 2
  nop
  i32.add
 )

 ;; CHECK:      (func $add-stacky-3 (type $1) (result i32)
 ;; CHECK-NEXT:  (local $scratch i32)
 ;; CHECK-NEXT:  (local.set $scratch
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (local.get $scratch)
 ;; CHECK-NEXT: )
 (func $add-stacky-3 (result i32)
  i32.const 1
  i32.const 2
  i32.add
  nop
 )

 ;; CHECK:      (func $add-stacky-4 (type $1) (result i32)
 ;; CHECK-NEXT:  (local $scratch i32)
 ;; CHECK-NEXT:  (local $scratch_1 i32)
 ;; CHECK-NEXT:  (local $scratch_2 i32)
 ;; CHECK-NEXT:  (local.set $scratch_2
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (block (result i32)
 ;; CHECK-NEXT:     (local.set $scratch_1
 ;; CHECK-NEXT:      (i32.const 1)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (nop)
 ;; CHECK-NEXT:     (local.get $scratch_1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (block (result i32)
 ;; CHECK-NEXT:     (local.set $scratch
 ;; CHECK-NEXT:      (i32.const 2)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (nop)
 ;; CHECK-NEXT:     (local.get $scratch)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (local.get $scratch_2)
 ;; CHECK-NEXT: )
 (func $add-stacky-4 (result i32)
  i32.const 1
  nop
  i32.const 2
  nop
  i32.add
  nop
 )

 ;; CHECK:      (func $add-unreachable (type $1) (result i32)
 ;; CHECK-NEXT:  (i32.add
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $add-unreachable (result i32)
  unreachable
  i32.const 1
  i32.add
 )

 ;; CHECK:      (func $add-unreachable-2 (type $1) (result i32)
 ;; CHECK-NEXT:  (i32.add
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $add-unreachable-2 (result i32)
  i32.const 1
  unreachable
  i32.add
 )

 ;; CHECK:      (func $add-unreachable-3 (type $1) (result i32)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $add-unreachable-3 (result i32)
  i32.const 1
  i32.const 2
  unreachable
 )

 ;; CHECK:      (func $add-twice (type $ret2) (result i32 i32)
 ;; CHECK-NEXT:  (tuple.make 2
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 3)
 ;; CHECK-NEXT:    (i32.const 4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $add-twice (type $ret2)
  i32.const 1
  i32.const 2
  i32.add
  i32.const 3
  i32.const 4
  i32.add
 )

 ;; CHECK:      (func $add-twice-stacky (type $ret2) (result i32 i32)
 ;; CHECK-NEXT:  (local $scratch i32)
 ;; CHECK-NEXT:  (tuple.make 2
 ;; CHECK-NEXT:   (block (result i32)
 ;; CHECK-NEXT:    (local.set $scratch
 ;; CHECK-NEXT:     (i32.add
 ;; CHECK-NEXT:      (i32.const 1)
 ;; CHECK-NEXT:      (i32.const 2)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (local.get $scratch)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 3)
 ;; CHECK-NEXT:    (i32.const 4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $add-twice-stacky (type $ret2)
  i32.const 1
  i32.const 2
  i32.add
  nop
  i32.const 3
  i32.const 4
  i32.add
 )

 ;; CHECK:      (func $add-twice-stacky-2 (type $ret2) (result i32 i32)
 ;; CHECK-NEXT:  (local $scratch i32)
 ;; CHECK-NEXT:  (tuple.make 2
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (block (result i32)
 ;; CHECK-NEXT:    (local.set $scratch
 ;; CHECK-NEXT:     (i32.add
 ;; CHECK-NEXT:      (i32.const 3)
 ;; CHECK-NEXT:      (i32.const 4)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (local.get $scratch)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $add-twice-stacky-2 (type $ret2)
  i32.const 1
  i32.const 2
  i32.add
  i32.const 3
  i32.const 4
  i32.add
  nop
 )

 ;; CHECK:      (func $add-twice-unreachable (type $ret2) (result i32 i32)
 ;; CHECK-NEXT:  (tuple.make 2
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 3)
 ;; CHECK-NEXT:    (i32.const 4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $add-twice-unreachable (type $ret2)
  unreachable
  i32.const 2
  i32.add
  i32.const 3
  i32.const 4
  i32.add
 )

 ;; CHECK:      (func $add-twice-unreachable-2 (type $ret2) (result i32 i32)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (tuple.make 2
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 3)
 ;; CHECK-NEXT:    (i32.const 4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $add-twice-unreachable-2 (type $ret2)
  i32.const 1
  i32.const 2
  i32.add
  unreachable
  i32.const 3
  i32.const 4
  i32.add
 )

 ;; CHECK:      (func $add-twice-unreachable-3 (type $ret2) (result i32 i32)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 3)
 ;; CHECK-NEXT:    (i32.const 4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $add-twice-unreachable-3 (type $ret2)
  i32.const 1
  i32.const 2
  i32.add
  i32.const 3
  i32.const 4
  i32.add
  unreachable
 )

 ;; CHECK:      (func $big-stack (type $0)
 ;; CHECK-NEXT:  (local $scratch f64)
 ;; CHECK-NEXT:  (local $scratch_1 i64)
 ;; CHECK-NEXT:  (local $scratch_2 f32)
 ;; CHECK-NEXT:  (local $scratch_3 i32)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (block (result i32)
 ;; CHECK-NEXT:    (local.set $scratch_3
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (block (result f32)
 ;; CHECK-NEXT:      (local.set $scratch_2
 ;; CHECK-NEXT:       (f32.const 1)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (drop
 ;; CHECK-NEXT:       (block (result i64)
 ;; CHECK-NEXT:        (local.set $scratch_1
 ;; CHECK-NEXT:         (i64.const 2)
 ;; CHECK-NEXT:        )
 ;; CHECK-NEXT:        (drop
 ;; CHECK-NEXT:         (block (result f64)
 ;; CHECK-NEXT:          (local.set $scratch
 ;; CHECK-NEXT:           (f64.const 3)
 ;; CHECK-NEXT:          )
 ;; CHECK-NEXT:          (drop
 ;; CHECK-NEXT:           (ref.null none)
 ;; CHECK-NEXT:          )
 ;; CHECK-NEXT:          (local.get $scratch)
 ;; CHECK-NEXT:         )
 ;; CHECK-NEXT:        )
 ;; CHECK-NEXT:        (local.get $scratch_1)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (local.get $scratch_2)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.get $scratch_3)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $big-stack
  i32.const 0
  f32.const 1
  i64.const 2
  f64.const 3
  ref.null any
  drop
  drop
  drop
  drop
  drop
 )

 ;; CHECK:      (func $locals (type $37) (param $0 i32) (param $x i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $y i32)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (local.get $x)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (local.get $y)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $x
 ;; CHECK-NEXT:   (local.get $x)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (local.tee $y
 ;; CHECK-NEXT:    (local.get $y)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $locals (param i32) (param $x i32)
  (local i32)
  (local $y i32)
  local.get 0
  drop
  local.get 1
  drop
  local.get 2
  drop
  local.get 3
  drop
  local.get $x
  local.set 1
  local.get $y
  local.tee 3
  drop
 )

 ;; CHECK:      (func $tuple-locals (type $0)
 ;; CHECK-NEXT:  (local $0 (tuple i32 i64))
 ;; CHECK-NEXT:  (local.set $0
 ;; CHECK-NEXT:   (local.tee $0
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $0
 ;; CHECK-NEXT:   (tuple.make 2
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (i64.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $tuple-locals
  (local (tuple i32 i64))
  local.get 0
  local.tee 0
  local.set 0
  i32.const 1
  i64.const 2
  local.set 0
 )

 ;; CHECK:      (func $block (type $0)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (block $l
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $block
  nop
  block $l (type $void)
   nop
   nop
   nop
  end $l
 )

 ;; CHECK:      (func $block-folded (type $0)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (tuple.drop 2
 ;; CHECK-NEXT:   (block $l (type $ret2) (result i32 i32)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $block-folded
  nop
  (block $l (result i32) (result) (result i32)
   nop
   nop
   unreachable
  )
  unreachable
 )

 ;; CHECK:      (func $block-mix (type $0)
 ;; CHECK-NEXT:  (local $scratch i32)
 ;; CHECK-NEXT:  (local $scratch_1 (tuple i32 i32))
 ;; CHECK-NEXT:  (local $scratch_2 i32)
 ;; CHECK-NEXT:  (block $0
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (block (result i32)
 ;; CHECK-NEXT:     (local.set $scratch_2
 ;; CHECK-NEXT:      (tuple.extract 2 0
 ;; CHECK-NEXT:       (local.tee $scratch_1
 ;; CHECK-NEXT:        (block $1 (type $ret2) (result i32 i32)
 ;; CHECK-NEXT:         (tuple.make 2
 ;; CHECK-NEXT:          (block $2 (result i32)
 ;; CHECK-NEXT:           (local.set $scratch
 ;; CHECK-NEXT:            (block $3 (result i32)
 ;; CHECK-NEXT:             (i32.const 0)
 ;; CHECK-NEXT:            )
 ;; CHECK-NEXT:           )
 ;; CHECK-NEXT:           (nop)
 ;; CHECK-NEXT:           (local.get $scratch)
 ;; CHECK-NEXT:          )
 ;; CHECK-NEXT:          (i32.const 1)
 ;; CHECK-NEXT:         )
 ;; CHECK-NEXT:        )
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (drop
 ;; CHECK-NEXT:      (tuple.extract 2 1
 ;; CHECK-NEXT:       (local.get $scratch_1)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (local.get $scratch_2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT: )
 (func $block-mix
  (block $0
   block $1 (type $ret2)
    (block $2 (result i32)
     block $3 (result i32)
      i32.const 0
     end
     nop
    )
    i32.const 1
   end $1
   drop
   drop
  )
  nop
 )


 ;; CHECK:      (func $multivalue-nested (type $ret2) (result i32 i32)
 ;; CHECK-NEXT:  (local $scratch (tuple i32 i32))
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (local.set $scratch
 ;; CHECK-NEXT:   (block (type $ret2) (result i32 i32)
 ;; CHECK-NEXT:    (block (type $ret2) (result i32 i32)
 ;; CHECK-NEXT:     (tuple.make 2
 ;; CHECK-NEXT:      (i32.const 0)
 ;; CHECK-NEXT:      (i32.const 1)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (local.get $scratch)
 ;; CHECK-NEXT: )
 (func $multivalue-nested (type $ret2)
  block (type $ret2)
   nop
   block (type $ret2)
    block (type $ret2)
     i32.const 0
     i32.const 1
    end
   end
   nop
  end
 )

 ;; CHECK:      (func $if-else (type $0)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (else
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else
  i32.const 0
  if
   nop
  else
   nop
  end
 )

 ;; CHECK:      (func $if-else-empty (type $0)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (else
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-empty
  i32.const 0
  if
  else
  end
 )

 ;; CHECK:      (func $if-else-many (type $0)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (else
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-many
  i32.const 0
  if
   nop
   nop
  else
   nop
   nop
  end
 )

 ;; CHECK:      (func $if-else-single-nested (type $0)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (f32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (else
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (f64.const 2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-single-nested
  i32.const 0
  if
   f32.const 1
   drop
  else
   f64.const 2
   drop
  end
 )

 ;; CHECK:      (func $if-else-folded-body (type $0)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (f32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (else
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (f32.const 2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-folded-body
  i32.const 0
  if
   (drop
    (f32.const 1)
   )
  else
   (drop
    (f32.const 2)
   )
  end
 )

 ;; CHECK:      (func $if-else-labeled (type $0)
 ;; CHECK-NEXT:  (block $l
 ;; CHECK-NEXT:   (if
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (then
 ;; CHECK-NEXT:     (nop)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (else
 ;; CHECK-NEXT:     (nop)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-labeled
  i32.const 0
  if $l
   nop
  else $l
   nop
  end $l
 )

 ;; CHECK:      (func $if-no-else (type $0)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-no-else
  i32.const 0
  if
   nop
  end
 )

 ;; CHECK:      (func $if-else-result (type $1) (result i32)
 ;; CHECK-NEXT:  (if (result i32)
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (else
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-result (result i32)
  i32.const 0
  if (result i32)
   i32.const 1
  else
   i32.const 2
  end
 )

 ;; CHECK:      (func $if-else-labeled-result (type $1) (result i32)
 ;; CHECK-NEXT:  (block $l (result i32)
 ;; CHECK-NEXT:   (if (result i32)
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (then
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (else
 ;; CHECK-NEXT:     (i32.const 2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-labeled-result (result i32)
  i32.const 0
  if $l (result i32)
   i32.const 1
  else
   i32.const 2
  end
 )

 ;; CHECK:      (func $if-else-folded (type $0)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (else
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-folded
  (if
   (i32.const 0)
   (then
    nop
   )
   (else
    nop
   )
  )
 )

 ;; CHECK:      (func $if-else-folded-empty (type $0)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (else
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-folded-empty
  (if
   (i32.const 0)
   (then)
   (else)
  )
 )

 ;; CHECK:      (func $if-else-folded-many (type $0)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (else
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-folded-many
  (if
   (i32.const 0)
   (then
    nop
    nop
   )
   (else
    nop
    nop
   )
  )
 )

 ;; CHECK:      (func $if-else-folded-single-nested (type $0)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.eqz
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (else
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (i32.const 2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-folded-single-nested
  (if
   (i32.eqz
    (i32.const 0)
   )
   (then
    (drop
     (i32.const 1)
    )
   )
   (else
    (drop
     (i32.const 2)
    )
   )
  )
 )

 ;; CHECK:      (func $if-else-folded-labeled (type $0)
 ;; CHECK-NEXT:  (block $l
 ;; CHECK-NEXT:   (if
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (then
 ;; CHECK-NEXT:     (nop)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (else
 ;; CHECK-NEXT:     (nop)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-folded-labeled
  (if $l
   (i32.const 0)
   (then
    nop
   )
   (else
    nop
   )
  )
 )

 ;; CHECK:      (func $if-no-else-folded (type $0)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-no-else-folded
  (if
   (i32.const 0)
   (then
    nop
   )
  )
 )

 ;; CHECK:      (func $if-else-folded-result (type $1) (result i32)
 ;; CHECK-NEXT:  (if (result i32)
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (else
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-folded-result (result i32)
  (if (result i32)
   (i32.const 0)
   (then
    i32.const 1
   )
   (else
    i32.const 2
   )
  )
 )

 ;; CHECK:      (func $if-else-folded-labeled-result (type $1) (result i32)
 ;; CHECK-NEXT:  (block $l (result i32)
 ;; CHECK-NEXT:   (if (result i32)
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (then
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (else
 ;; CHECK-NEXT:     (i32.const 2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-folded-labeled-result (result i32)
  (if $l (result i32)
   (i32.const 0)
   (then
    i32.const 1
   )
   (else
    i32.const 2
   )
  )
 )

;; CHECK:      (func $if-else-atypical-condition (type $0)
;; CHECK-NEXT:  (if
;; CHECK-NEXT:   (i32.const 0)
;; CHECK-NEXT:   (then
;; CHECK-NEXT:    (nop)
;; CHECK-NEXT:   )
;; CHECK-NEXT:   (else
;; CHECK-NEXT:    (nop)
;; CHECK-NEXT:   )
;; CHECK-NEXT:  )
;; CHECK-NEXT:  (if
;; CHECK-NEXT:   (i32.eqz
;; CHECK-NEXT:    (i32.const 0)
;; CHECK-NEXT:   )
;; CHECK-NEXT:   (then
;; CHECK-NEXT:    (nop)
;; CHECK-NEXT:   )
;; CHECK-NEXT:   (else
;; CHECK-NEXT:    (nop)
;; CHECK-NEXT:   )
;; CHECK-NEXT:  )
;; CHECK-NEXT: )
(func $if-else-atypical-condition
 i32.const 0
 (if (then) (else))
 (if (i32.const 0) (i32.eqz) (then) (else))
)

 ;; CHECK:      (func $if-else-mixed (type $0)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (if (result i32)
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (then
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (else
 ;; CHECK-NEXT:     (i32.const 2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (if
 ;; CHECK-NEXT:     (if (result i32)
 ;; CHECK-NEXT:      (i32.const 3)
 ;; CHECK-NEXT:      (then
 ;; CHECK-NEXT:       (i32.const 4)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (else
 ;; CHECK-NEXT:       (i32.const 5)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (then
 ;; CHECK-NEXT:      (if
 ;; CHECK-NEXT:       (i32.const 6)
 ;; CHECK-NEXT:       (then
 ;; CHECK-NEXT:        (drop
 ;; CHECK-NEXT:         (i32.const 7)
 ;; CHECK-NEXT:        )
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-mixed
  i32.const 0
  if (result i32)
   i32.const 1
  else
   i32.const 2
  end
  if
   (if
    (if (result i32)
     (i32.const 3)
     (then
      (i32.const 4)
     )
     (else
      (i32.const 5)
     )
    )
    (then
     i32.const 6
     if
      i32.const 7
      drop
     end
    )
   )
  end
 )

 ;; CHECK:      (func $if-else-brs (type $0)
 ;; CHECK-NEXT:  (block $label
 ;; CHECK-NEXT:   (if
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (then
 ;; CHECK-NEXT:     (br $label)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (else
 ;; CHECK-NEXT:     (br $label)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-brs
  i32.const 0
  if
   br 0
  else
   br 0
  end
 )

 ;; CHECK:      (func $if-else-brs-i32 (type $1) (result i32)
 ;; CHECK-NEXT:  (block $label (result i32)
 ;; CHECK-NEXT:   (if (result i32)
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (then
 ;; CHECK-NEXT:     (br $label
 ;; CHECK-NEXT:      (i32.const 1)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (else
 ;; CHECK-NEXT:     (br $label
 ;; CHECK-NEXT:      (i32.const 2)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $if-else-brs-i32 (result i32)
  i32.const 0
  if (result i32)
   i32.const 1
   br 0
  else
   i32.const 2
   br 0
  end
 )

 ;; CHECK:      (func $loop (type $0)
 ;; CHECK-NEXT:  (loop
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop
  loop
   nop
  end
 )

 ;; CHECK:      (func $loop-empty (type $0)
 ;; CHECK-NEXT:  (loop
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop-empty
  loop
  end
 )

 ;; CHECK:      (func $loop-many (type $0)
 ;; CHECK-NEXT:  (loop
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop-many
  loop
   nop
   nop
  end
 )

 ;; CHECK:      (func $loop-nested (type $0)
 ;; CHECK-NEXT:  (loop
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop-nested
  loop
   i32.const 0
   drop
  end
 )

 ;; CHECK:      (func $loop-folded-body (type $0)
 ;; CHECK-NEXT:  (loop
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop-folded-body
  loop
   (drop
    (i32.const 0)
   )
  end
 )

 ;; CHECK:      (func $loop-labeled (type $0)
 ;; CHECK-NEXT:  (loop $l
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop-labeled
  loop $l
   nop
  end $l
 )

 ;; CHECK:      (func $loop-result (type $1) (result i32)
 ;; CHECK-NEXT:  (loop (result i32)
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop-result (result i32)
  loop (result i32)
   i32.const 0
  end
 )

 ;; CHECK:      (func $loop-labeled-result (type $1) (result i32)
 ;; CHECK-NEXT:  (loop $l (result i32)
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop-labeled-result (result i32)
  loop $l (result i32)
   i32.const 0
  end $l
 )

 ;; CHECK:      (func $loop-folded (type $0)
 ;; CHECK-NEXT:  (loop
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop-folded
  (loop
   (nop)
  )
 )

 ;; CHECK:      (func $loop-folded-empty (type $0)
 ;; CHECK-NEXT:  (loop
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop-folded-empty
  (loop)
 )

 ;; CHECK:      (func $loop-folded-many (type $0)
 ;; CHECK-NEXT:  (loop
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop-folded-many
  (loop
   nop
   nop
  )
 )

 ;; CHECK:      (func $loop-folded-nested (type $0)
 ;; CHECK-NEXT:  (loop
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (f32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop-folded-nested
  (loop
   (drop
    (f32.const 0)
   )
  )
 )

 ;; CHECK:      (func $loop-folded-labeled (type $0)
 ;; CHECK-NEXT:  (loop $l
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop-folded-labeled
  (loop $l
   nop
  )
 )

 ;; CHECK:      (func $loop-folded-result (type $1) (result i32)
 ;; CHECK-NEXT:  (loop (result i32)
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop-folded-result (result i32)
  (loop (result i32)
   i32.const 0
  )
 )

 ;; CHECK:      (func $loop-folded-labeled-result (type $1) (result i32)
 ;; CHECK-NEXT:  (loop $l (result i32)
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $loop-folded-labeled-result (result i32)
  (loop $l (result i32)
   i32.const 0
  )
 )

 ;; CHECK:      (func $try (type $0)
 ;; CHECK-NEXT:  (try
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try
  try
   nop
  end
 )

 ;; CHECK:      (func $try-catch (type $0)
 ;; CHECK-NEXT:  (try
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch $empty
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-catch
  try
  catch $empty
  end
 )

 ;; CHECK:      (func $try-catch-params (type $4) (result i32 i64)
 ;; CHECK-NEXT:  (try (type $4) (result i32 i64)
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (tuple.make 2
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:     (i64.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch $tag-pair
 ;; CHECK-NEXT:    (pop (tuple i32 i64))
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-catch-params (result i32 i64)
  try (result i32 i64)
   i32.const 0
   i64.const 1
  catch $tag-pair
  end
 )

 ;; CHECK:      (func $try-catch-pop (type $4) (result i32 i64)
 ;; CHECK-NEXT:  (try (type $4) (result i32 i64)
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (tuple.make 2
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:     (i64.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch $tag-pair
 ;; CHECK-NEXT:    (pop (tuple i32 i64))
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-catch-pop (result i32 i64)
  try (result i32 i64)
   i32.const 0
   i64.const 1
  catch $tag-pair
   pop (tuple i32 i64)
  end
 )

 ;; CHECK:      (func $try-catch_all (type $0)
 ;; CHECK-NEXT:  (try
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch_all
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-catch_all
  try
  catch_all
  end
 )

 ;; CHECK:      (func $try-catch-catch_all (type $0)
 ;; CHECK-NEXT:  (try
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch $empty
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch $eimport$0
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch_all
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-catch-catch_all
  try
  catch $empty
  catch 1
  catch_all
  end
 )

 ;; CHECK:      (func $try-delegate (type $0)
 ;; CHECK-NEXT:  (try
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (delegate 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-delegate
  try
  delegate 0
 )

 ;; CHECK:      (func $try-delegate-nested-func-direct (type $0)
 ;; CHECK-NEXT:  (block $l
 ;; CHECK-NEXT:   (try
 ;; CHECK-NEXT:    (do
 ;; CHECK-NEXT:     (nop)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (delegate 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-delegate-nested-func-direct
  block $l
   try
   delegate 1
  end
 )

 ;; CHECK:      (func $try-delegate-nested-func-indirect-index (type $0)
 ;; CHECK-NEXT:  (block $l
 ;; CHECK-NEXT:   (try
 ;; CHECK-NEXT:    (do
 ;; CHECK-NEXT:     (nop)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (delegate 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-delegate-nested-func-indirect-index
  block $l
   try
   delegate 0
  end
 )

 ;; CHECK:      (func $try-delegate-nested-func-indirect-name (type $0)
 ;; CHECK-NEXT:  (block $l
 ;; CHECK-NEXT:   (try
 ;; CHECK-NEXT:    (do
 ;; CHECK-NEXT:     (nop)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (delegate 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-delegate-nested-func-indirect-name
  block $l
   try
   delegate $l
  end
 )

 ;; CHECK:      (func $try-delegate-nested-try-direct-index (type $0)
 ;; CHECK-NEXT:  (try $label
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (try
 ;; CHECK-NEXT:     (do
 ;; CHECK-NEXT:      (nop)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (delegate $label)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-delegate-nested-try-direct-index
  try
   block
    try
    delegate 1
   end
  end
 )

 ;; CHECK:      (func $try-delegate-nested-try-direct-name (type $0)
 ;; CHECK-NEXT:  (try $l
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (try
 ;; CHECK-NEXT:     (do
 ;; CHECK-NEXT:      (nop)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (delegate $l)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-delegate-nested-try-direct-name
  try $l
   block
    try
    delegate $l
   end
  end
 )

 ;; CHECK:      (func $try-delegate-nested-try-indirect-index (type $0)
 ;; CHECK-NEXT:  (try $label
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (try
 ;; CHECK-NEXT:     (do
 ;; CHECK-NEXT:      (nop)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (delegate $label)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-delegate-nested-try-indirect-index
  try
   block
    try
    delegate 0
   end
  end
 )

 ;; CHECK:      (func $try-delegate-nested-try-indirect-name (type $0)
 ;; CHECK-NEXT:  (try $label
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (block $l
 ;; CHECK-NEXT:     (try
 ;; CHECK-NEXT:      (do
 ;; CHECK-NEXT:       (nop)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (delegate $label)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-delegate-nested-try-indirect-name
  try
   block $l
    try
    delegate $l
   end
  end
 )

 ;; CHECK:      (func $try-delegate-nested-try-shadowing (type $0)
 ;; CHECK-NEXT:  (try $l
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (block $l0
 ;; CHECK-NEXT:     (try $l1
 ;; CHECK-NEXT:      (do
 ;; CHECK-NEXT:       (nop)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (delegate $l)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-delegate-nested-try-shadowing
  try $l
   block $l
    try $l
    delegate $l
   end
  end $l
 )

 ;; CHECK:      (func $try-delegate-nested-catch-shadowing (type $0)
 ;; CHECK-NEXT:  (try $l
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (try $l0
 ;; CHECK-NEXT:     (do
 ;; CHECK-NEXT:      (nop)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (catch $empty
 ;; CHECK-NEXT:      (try $l1
 ;; CHECK-NEXT:       (do
 ;; CHECK-NEXT:        (nop)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:       (delegate $l)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-delegate-nested-catch-shadowing
  try $l
   try $l
   catch $empty
    try $l
    ;; goes to the outermost try, not the middle one
    delegate $l
   end
  end
 )

 ;; CHECK:      (func $try-delegate-nested-catch_all-shadowing (type $0)
 ;; CHECK-NEXT:  (try $l
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (try $l0
 ;; CHECK-NEXT:     (do
 ;; CHECK-NEXT:      (nop)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (catch_all
 ;; CHECK-NEXT:      (try $l1
 ;; CHECK-NEXT:       (do
 ;; CHECK-NEXT:        (nop)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:       (delegate $l)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-delegate-nested-catch_all-shadowing
  try $l
   try $l
   catch_all
    try $l
    ;; goes to the outermost try, not the middle one
    delegate $l
   end
  end
 )

 ;; CHECK:      (func $try-br-index (type $0)
 ;; CHECK-NEXT:  (block $label
 ;; CHECK-NEXT:   (try
 ;; CHECK-NEXT:    (do
 ;; CHECK-NEXT:     (br $label)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (catch $empty
 ;; CHECK-NEXT:     (br $label)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (catch_all
 ;; CHECK-NEXT:     (br $label)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-br-index
  try
   br 0
  catch $empty
   br 0
  catch_all
   br 0
  end
 )

 ;; CHECK:      (func $try-br-name (type $0)
 ;; CHECK-NEXT:  (block $label
 ;; CHECK-NEXT:   (try $l
 ;; CHECK-NEXT:    (do
 ;; CHECK-NEXT:     (br $label)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (catch $empty
 ;; CHECK-NEXT:     (br $label)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (catch_all
 ;; CHECK-NEXT:     (br $label)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-br-name
  try $l
   br $l
  catch $l $empty
   br $l
  catch_all $l
   br $l
  end $l
 )

 ;; CHECK:      (func $try-folded (type $0)
 ;; CHECK-NEXT:  (try
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch $empty
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch $eimport$0
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch_all
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-folded
  (try
   (do
    nop
    (nop)
   )
   (catch $empty
    (nop)
    nop
   )
   (catch 1
    nop
    (nop)
   )
   (catch_all
    (nop)
    nop
   )
  )
 )

 ;; CHECK:      (func $try-delegate-folded (type $0)
 ;; CHECK-NEXT:  (try
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (delegate 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-delegate-folded
  (try
   (do)
   (delegate 0)
  )
 )

 ;; CHECK:      (func $rethrow (type $0)
 ;; CHECK-NEXT:  (try $label
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch $empty
 ;; CHECK-NEXT:    (rethrow $label)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $rethrow
  try
  catch $empty
   rethrow 0
  end
 )

 ;; CHECK:      (func $rethrow-named (type $0)
 ;; CHECK-NEXT:  (try $l
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch $empty
 ;; CHECK-NEXT:    (rethrow $l)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $rethrow-named
  try $l
  catch $empty
   rethrow $l
  end
 )

 ;; CHECK:      (func $rethrow-nested (type $0)
 ;; CHECK-NEXT:  (try $label
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch $empty
 ;; CHECK-NEXT:    (try
 ;; CHECK-NEXT:     (do
 ;; CHECK-NEXT:      (nop)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (catch $empty
 ;; CHECK-NEXT:      (rethrow $label)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $rethrow-nested
  try
  catch $empty
   block
    try
    catch $empty
     rethrow 2
    end
   end
  end
 )

 ;; CHECK:      (func $rethrow-nested-named (type $0)
 ;; CHECK-NEXT:  (try $l
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch $empty
 ;; CHECK-NEXT:    (try
 ;; CHECK-NEXT:     (do
 ;; CHECK-NEXT:      (nop)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (catch $empty
 ;; CHECK-NEXT:      (rethrow $l)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $rethrow-nested-named
  try $l
  catch $empty
   block
    try
    catch $empty
     rethrow $l
    end
   end
  end
 )

 ;; CHECK:      (func $rethrow-try-nested (type $0)
 ;; CHECK-NEXT:  (try $label
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch $empty
 ;; CHECK-NEXT:    (try
 ;; CHECK-NEXT:     (do
 ;; CHECK-NEXT:      (rethrow $label)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $rethrow-try-nested
  try
  catch $empty
   block
    try
     ;; Same as before, but now the rethrow is in the inner try instead of the
     ;; inner catch.
     rethrow 2
    end
   end
  end
 )

 ;; CHECK:      (func $rethrow-try-nested-named (type $0)
 ;; CHECK-NEXT:  (try $l
 ;; CHECK-NEXT:   (do
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (catch $empty
 ;; CHECK-NEXT:    (try
 ;; CHECK-NEXT:     (do
 ;; CHECK-NEXT:      (rethrow $l)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $rethrow-try-nested-named
  try $l
  catch $empty
   block
    try
     rethrow $l
    end
   end
  end
 )

 ;; CHECK:      (func $try-table (type $0)
 ;; CHECK-NEXT:  (try_table
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-table
  try_table
   nop
  end
 )

 ;; CHECK:      (func $try-table-catch (type $0)
 ;; CHECK-NEXT:  (block $label
 ;; CHECK-NEXT:   (try_table (catch $empty $label)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-table-catch
  try_table (catch $empty 0)
   nop
  end
 )

 ;; CHECK:      (func $try-table-catch-ref (type $20) (result exnref)
 ;; CHECK-NEXT:  (block $label (result exnref)
 ;; CHECK-NEXT:   (try_table (result exnref) (catch_ref $empty $label)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-table-catch-ref (result exnref)
  try_table (result exnref) (catch_ref $empty 0)
   unreachable
  end
 )

 ;; CHECK:      (func $try-table-catch-all (type $0)
 ;; CHECK-NEXT:  (block $label
 ;; CHECK-NEXT:   (try_table (catch_all $label)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-table-catch-all
  try_table (catch_all 0)
   nop
  end
 )

 ;; CHECK:      (func $try-table-catch-all-ref (type $20) (result exnref)
 ;; CHECK-NEXT:  (block $label (result exnref)
 ;; CHECK-NEXT:   (try_table (result exnref) (catch_all_ref $label)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-table-catch-all-ref (result exnref)
  try_table (result exnref) (catch_all_ref 0)
   unreachable
  end
 )

 ;; CHECK:      (func $try-table-all (type $0)
 ;; CHECK-NEXT:  (block $catch
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (block $catch_ref (result exnref)
 ;; CHECK-NEXT:     (block $catch_all
 ;; CHECK-NEXT:      (drop
 ;; CHECK-NEXT:       (block $catch_all_ref (result exnref)
 ;; CHECK-NEXT:        (block $try
 ;; CHECK-NEXT:         (try_table (catch $empty $catch) (catch_ref $empty $catch_ref) (catch_all $catch_all) (catch_all_ref $catch_all_ref)
 ;; CHECK-NEXT:          (br $try)
 ;; CHECK-NEXT:         )
 ;; CHECK-NEXT:        )
 ;; CHECK-NEXT:        (unreachable)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-table-all
  block $catch
   block $catch_ref (result exnref)
    block $catch_all
     block $catch_all_ref (result exnref)
      try_table $try (catch $empty $catch)
                     (catch_ref $empty $catch_ref)
                     (catch_all $catch_all)
                     (catch_all_ref $catch_all_ref)
       br $try
      end $try
      unreachable
     end $catch_all_ref
     drop
    end $catch_all
    unreachable
   end $catch_ref
   drop
  end $catch
 )

 ;; CHECK:      (func $try-table-folded (type $0)
 ;; CHECK-NEXT:  (block $label
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (block $try (result i32)
 ;; CHECK-NEXT:     (try_table (result i32) (catch $empty $label)
 ;; CHECK-NEXT:      (i32.const 0)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-table-folded
  (drop
   (try_table $try (result i32) (catch $empty 0)
    (i32.const 0)
   )
  )
 )

 ;; CHECK:      (func $try-table-throw-ref (type $38) (param $0 exnref)
 ;; CHECK-NEXT:  (throw_ref
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-table-throw-ref (param exnref)
  local.get 0
  throw_ref
 )

 ;; CHECK:      (func $label-siblings (type $0)
 ;; CHECK-NEXT:  (block $l
 ;; CHECK-NEXT:   (br $l)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (loop $l0
 ;; CHECK-NEXT:   (br $l0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (block $l1
 ;; CHECK-NEXT:   (if
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (then
 ;; CHECK-NEXT:     (br $l1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $label-siblings
  block $l
   br $l
  end
  loop $l
   br $l
  end
  i32.const 0
  if $l
   br $l
  end
 )

 ;; CHECK:      (func $label-shadowed (type $0)
 ;; CHECK-NEXT:  (block $l
 ;; CHECK-NEXT:   (br $l)
 ;; CHECK-NEXT:   (loop $l0
 ;; CHECK-NEXT:    (br $l0)
 ;; CHECK-NEXT:    (block $l1
 ;; CHECK-NEXT:     (if
 ;; CHECK-NEXT:      (i32.const 0)
 ;; CHECK-NEXT:      (then
 ;; CHECK-NEXT:       (br $l1)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (br $l0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br $l)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $label-shadowed
  block $l
   br $l
   loop $l
    br $l
    i32.const 0
    if $l
     br $l
    end
    br $l
   end
   br $l
  end
 )

 ;; CHECK:      (func $label-index (type $0)
 ;; CHECK-NEXT:  (block $block1
 ;; CHECK-NEXT:   (block $block
 ;; CHECK-NEXT:    (block $block0
 ;; CHECK-NEXT:     (block $l
 ;; CHECK-NEXT:      (br $block)
 ;; CHECK-NEXT:      (br $block0)
 ;; CHECK-NEXT:      (br $l)
 ;; CHECK-NEXT:      (br $block1)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $label-index
  block
   block
    block
     block $l
      br 2
      br 1
      br 0
      br 3
     end
    end
   end
  end
 )

 ;; CHECK:      (func $label-func (type $0)
 ;; CHECK-NEXT:  (block $label
 ;; CHECK-NEXT:   (br $label)
 ;; CHECK-NEXT:   (block $a
 ;; CHECK-NEXT:    (br $label)
 ;; CHECK-NEXT:    (block $b
 ;; CHECK-NEXT:     (br $label)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $label-func
  br 0
  block $a
   br 1
   block $b
    br 2
   end
  end
 )

 ;; CHECK:      (func $br-value (type $1) (result i32)
 ;; CHECK-NEXT:  (block $label (result i32)
 ;; CHECK-NEXT:   (br $label
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-value (result i32)
  i32.const 0
  br 0
 )

 ;; CHECK:      (func $br-value-drop (type $1) (result i32)
 ;; CHECK-NEXT:  (block $label (result i32)
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (f32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br $label
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-value-drop (result i32)
  f32.const 0
  i32.const 1
  br 0
 )

 ;; CHECK:      (func $br-multivalue (type $4) (result i32 i64)
 ;; CHECK-NEXT:  (block $label (type $4) (result i32 i64)
 ;; CHECK-NEXT:   (br $label
 ;; CHECK-NEXT:    (tuple.make 2
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:     (i64.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-multivalue (result i32 i64)
  i32.const 0
  i64.const 1
  br 0
 )

 ;; CHECK:      (func $br-multivalue-drop (type $4) (result i32 i64)
 ;; CHECK-NEXT:  (block $label (type $4) (result i32 i64)
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (f32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br $label
 ;; CHECK-NEXT:    (tuple.make 2
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:     (i64.const 2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-multivalue-drop (result i32 i64)
  f32.const 0
  i32.const 1
  i64.const 2
  br 0
 )

 ;; CHECK:      (func $br-mismatch-after (type $1) (result i32)
 ;; CHECK-NEXT:  (block $label (result i32)
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (br $label
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-mismatch-after (result i32)
  i32.const 1
  br 0
  i32.add
 )

 ;; CHECK:      (func $br-mismatch-after-extra (type $1) (result i32)
 ;; CHECK-NEXT:  (block $label (result i32)
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (i64.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (br $label
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-mismatch-after-extra (result i32)
  i64.const 0
  i32.const 1
  br 0
  i32.add
 )

 ;; CHECK:      (func $br_if (type $0)
 ;; CHECK-NEXT:  (block $l
 ;; CHECK-NEXT:   (br_if $l
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br_if
  block $l
   i32.const 0
   br_if $l
  end
 )

 ;; CHECK:      (func $br_if-index (type $0)
 ;; CHECK-NEXT:  (block $block
 ;; CHECK-NEXT:   (br_if $block
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br_if-index
  block
   i32.const 0
   br_if 0
  end
 )

 ;; CHECK:      (func $br_if-return (type $0)
 ;; CHECK-NEXT:  (block $label
 ;; CHECK-NEXT:   (br_if $label
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br_if-return
  i32.const 0
  br_if 0
 )

 ;; CHECK:      (func $br_if-value (type $21) (result i64)
 ;; CHECK-NEXT:  (block $l (result i64)
 ;; CHECK-NEXT:   (br_if $l
 ;; CHECK-NEXT:    (i64.const 0)
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br_if-value (result i64)
  block $l (result i64)
   i64.const 0
   i32.const 1
   br_if $l
  end
 )

 ;; CHECK:      (func $br_if-multivalue (type $22) (result i64 f32)
 ;; CHECK-NEXT:  (block $l (type $22) (result i64 f32)
 ;; CHECK-NEXT:   (br_if $l
 ;; CHECK-NEXT:    (tuple.make 2
 ;; CHECK-NEXT:     (i64.const 0)
 ;; CHECK-NEXT:     (f32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br_if-multivalue (result i64 f32)
  block $l (result i64 f32)
   i64.const 0
   f32.const 1
   i32.const 2
   br_if $l
  end
 )

 ;; CHECK:      (func $br_if-loop (type $21) (result i64)
 ;; CHECK-NEXT:  (local $scratch i64)
 ;; CHECK-NEXT:  (loop $l (result i64)
 ;; CHECK-NEXT:   (local.set $scratch
 ;; CHECK-NEXT:    (i64.const 42)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_if $l
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.get $scratch)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br_if-loop (result i64)
  loop $l (result i64)
   i64.const 42
   i32.const 0
   br_if $l
  end
 )

 ;; CHECK:      (func $br-table (type $0)
 ;; CHECK-NEXT:  (block $a
 ;; CHECK-NEXT:   (block $b
 ;; CHECK-NEXT:    (block $c
 ;; CHECK-NEXT:     (block $d
 ;; CHECK-NEXT:      (br_table $a $b $d $c
 ;; CHECK-NEXT:       (i32.const 0)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-table
  block $a
   block $b
    block $c
     block $d
      i32.const 0
      br_table $a $b $d $c
     end
    end
   end
  end
 )

 ;; CHECK:      (func $br-table-index (type $0)
 ;; CHECK-NEXT:  (block $block
 ;; CHECK-NEXT:   (block $l
 ;; CHECK-NEXT:    (block $block1
 ;; CHECK-NEXT:     (block $block0
 ;; CHECK-NEXT:      (br_table $block $l $block0 $block1
 ;; CHECK-NEXT:       (i32.const 0)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-table-index
  block
   block $l
    block
     block
      i32.const 0
      br_table 3 2 0 1
     end
    end
   end
  end
 )

 ;; CHECK:      (func $br-table-return (type $0)
 ;; CHECK-NEXT:  (block $label
 ;; CHECK-NEXT:   (br_table $label $label $label $label $label $label $label $label
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-table-return
  i32.const 0
  br_table 0 0 0 0 0 0 0 0
 )

 ;; CHECK:      (func $br-table-value (type $1) (result i32)
 ;; CHECK-NEXT:  (block $a (result i32)
 ;; CHECK-NEXT:   (block $b (result i32)
 ;; CHECK-NEXT:    (br_table $a $b
 ;; CHECK-NEXT:     (i32.const 42)
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-table-value (result i32)
  block $a (result i32)
   block $b (result i32)
    i32.const 42
    i32.const 0
    br_table $a $b
   end
  end
 )

 ;; CHECK:      (func $br-table-multivalue (type $4) (result i32 i64)
 ;; CHECK-NEXT:  (block $a (type $4) (result i32 i64)
 ;; CHECK-NEXT:   (block $b (type $4) (result i32 i64)
 ;; CHECK-NEXT:    (br_table $a $b
 ;; CHECK-NEXT:     (tuple.make 2
 ;; CHECK-NEXT:      (i32.const 42)
 ;; CHECK-NEXT:      (i64.const 42)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-table-multivalue (result i32 i64)
  block $a (result i32 i64)
   block $b (result i32 i64)
    i32.const 42
    i64.const 42
    i32.const 0
    br_table $a $b
   end
  end
 )

 ;; CHECK:      (func $br-table-multivalue-glb (type $39) (result anyref anyref)
 ;; CHECK-NEXT:  (block $a (type $35) (result arrayref structref)
 ;; CHECK-NEXT:   (return
 ;; CHECK-NEXT:    (block $b (type $34) (result structref arrayref)
 ;; CHECK-NEXT:     (br_table $a $b
 ;; CHECK-NEXT:      (tuple.make 2
 ;; CHECK-NEXT:       (ref.null none)
 ;; CHECK-NEXT:       (ref.null none)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-table-multivalue-glb (result anyref anyref)
  block $a (result arrayref structref)
   block $b (result structref arrayref)
    ref.null none
    ref.null none
    tuple.make 2
    unreachable
    br_table $a $b
   end
   return
  end
 )

 ;; CHECK:      (func $br-table-loop (type $1) (result i32)
 ;; CHECK-NEXT:  (loop $a (result i32)
 ;; CHECK-NEXT:   (loop $b (result i32)
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (i32.const 42)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (br_table $a $b
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-table-loop (result i32)
  loop $a (result i32)
   loop $b (result i32)
    i32.const 42
    i32.const 0
    br_table $a $b
   end
  end
 )

 ;; CHECK:      (func $binary (type $40) (param $0 i32) (param $1 i32) (param $2 f64) (param $3 f64)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (f64.mul
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:    (local.get $3)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $binary (param i32 i32 f64 f64)
  local.get 0
  local.get 1
  i32.add
  drop
  local.get 2
  local.get 3
  f64.mul
  drop
 )

 ;; CHECK:      (func $unary (type $41) (param $0 i64)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i64.eqz
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $unary (param i64)
  local.get 0
  i64.eqz
  drop
 )

 ;; CHECK:      (func $select (type $23) (param $0 i32) (param $1 i32) (param $2 i32)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (select
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (select
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (select
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (select
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $select (param i32 i32 i32)
  local.get 0
  local.get 1
  local.get 2
  select
  drop
  local.get 0
  local.get 1
  local.get 2
  select (result)
  drop
  local.get 0
  local.get 1
  local.get 2
  select (result i32)
  drop
  local.get 0
  local.get 1
  local.get 2
  select (result) (result i32) (result)
  drop
 )

 ;; CHECK:      (func $memory-size (type $0)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (memory.size $mimport$0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (memory.size $m-imported)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (memory.size $mem-i64)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $memory-size
  memory.size
  drop
  memory.size 1
  drop
  memory.size $mem-i64
  drop
 )

 ;; CHECK:      (func $memory-grow (type $6) (param $0 i32) (param $1 i64)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (memory.grow $mimport$0
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (memory.grow $m-imported
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (memory.grow $mem-i64
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $memory-grow (param i32 i64)
  local.get 0
  memory.grow
  drop
  local.get 0
  memory.grow 1
  drop
  local.get 1
  memory.grow $mem-i64
  drop
 )

 ;; CHECK:      (func $globals (type $0)
 ;; CHECK-NEXT:  (global.set $g-imported
 ;; CHECK-NEXT:   (global.get $i32)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $globals
  global.get $i32
  global.set 4
 )

 ;; CHECK:      (func $tuple-globals (type $0)
 ;; CHECK-NEXT:  (global.set $pair
 ;; CHECK-NEXT:   (global.get $pair)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (global.set $pair
 ;; CHECK-NEXT:   (tuple.make 2
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (i64.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $tuple-globals
  global.get $pair
  global.set $pair
  i32.const 1
  i64.const 2
  global.set $pair
 )

 ;; CHECK:      (func $load (type $6) (param $0 i32) (param $1 i64)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.load $mimport$0 offset=42
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i64.load8_s $m-imported
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.atomic.load16_u $mem-i64 offset=42
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $load (param i32 i64)
  local.get 0
  i32.load offset=42
  drop
  local.get 0
  i64.load8_s 1 align=1
  drop
  local.get 1
  i32.atomic.load16_u $mem-i64 offset=42 align=2
  drop
 )

 ;; CHECK:      (func $store (type $6) (param $0 i32) (param $1 i64)
 ;; CHECK-NEXT:  (i32.store $mimport$0 offset=42 align=1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (i64.atomic.store8 $m-imported
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (i64.const 1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (f32.store $mem-i64
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (f32.const 2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $store (param i32 i64)
  local.get 0
  i32.const 0
  i32.store offset=42 align=1
  local.get 0
  i64.const 1
  i64.atomic.store8 1
  local.get 1
  f32.const 2
  f32.store $mem-i64
 )

 ;; CHECK:      (func $atomic-rmw (type $6) (param $0 i32) (param $1 i64)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.atomic.rmw16.add_u $mimport$0
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i64.atomic.rmw.xor $mem-i64 offset=8
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:    (i64.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $atomic-rmw (param i32 i64)
  local.get 0
  i32.const 1
  i32.atomic.rmw16.add_u
  drop
  local.get 1
  i64.const 2
  i64.atomic.rmw.xor $mem-i64 offset=8 align=8
  drop
 )

 ;; CHECK:      (func $atomic-cmpxchg (type $6) (param $0 i32) (param $1 i64)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.atomic.rmw8.cmpxchg_u $mem
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i64.atomic.rmw32.cmpxchg_u $mem-i64 offset=16
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:    (i64.const 3)
 ;; CHECK-NEXT:    (i64.const 4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $atomic-cmpxchg (param i32 i64)
  local.get 0
  i32.const 1
  i32.const 2
  i32.atomic.rmw8.cmpxchg_u 2 align=1
  drop
  local.get 1
  i64.const 3
  i64.const 4
  i64.atomic.rmw32.cmpxchg_u 5 offset=16
  drop
 )

 ;; CHECK:      (func $atomic-wait (type $6) (param $0 i32) (param $1 i64)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (memory.atomic.wait32 $mimport$0
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (i64.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (memory.atomic.wait64 $mem-i64 offset=8
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:    (i64.const 3)
 ;; CHECK-NEXT:    (i64.const 4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $atomic-wait (param i32 i64)
  local.get 0
  i32.const 1
  i64.const 2
  memory.atomic.wait32
  drop
  local.get 1
  i64.const 3
  i64.const 4
  memory.atomic.wait64 $mem-i64 offset=8 align=8
  drop
 )

 ;; CHECK:      (func $atomic-notify (type $6) (param $0 i32) (param $1 i64)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (memory.atomic.notify $mimport$0 offset=8
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (memory.atomic.notify $mem-i64
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $atomic-notify (param i32 i64)
  local.get 0
  i32.const 0
  memory.atomic.notify offset=8 align=4
  drop
  local.get 1
  i32.const 1
  memory.atomic.notify $mem-i64
  drop
 )

 ;; CHECK:      (func $atomic-fence (type $0)
 ;; CHECK-NEXT:  (atomic.fence)
 ;; CHECK-NEXT: )
 (func $atomic-fence
  atomic.fence
 )

 ;; CHECK:      (func $simd-const (type $0)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (v128.const i32x4 0x03020100 0x07060504 0x0b0a0908 0x0f0e0d0c)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (v128.const i32x4 0x00010000 0x00030002 0x00050004 0x00070006)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (v128.const i32x4 0x00000000 0x00000001 0x00000002 0x00000003)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (v128.const i32x4 0x00000000 0x00000000 0x00000001 0x00000000)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (v128.const i32x4 0x00000000 0x3f800000 0x40000000 0x40400000)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (v128.const i32x4 0x00000000 0x00000000 0x00000000 0x3ff00000)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $simd-const
  v128.const i8x16 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
  drop
  v128.const i16x8 0 1 2 3 4 5 6 7
  drop
  v128.const i32x4 0 1 2 3
  drop
  v128.const i64x2 0 1
  drop
  v128.const f32x4 0.0 1.0 2.0 3.0
  drop
  v128.const f64x2 0.0 1.0
  drop
 )

 ;; CHECK:      (func $simd-extract (type $42) (param $0 v128) (result i32)
 ;; CHECK-NEXT:  (i32x4.extract_lane 3
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $simd-extract (param v128) (result i32)
  local.get 0
  i32x4.extract_lane 3
 )

 ;; CHECK:      (func $simd-replace (type $24) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-NEXT:  (i32x4.replace_lane 2
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $simd-replace (param v128 i32) (result v128)
  local.get 0
  local.get 1
  i32x4.replace_lane 2
 )

 ;; CHECK:      (func $simd-shuffle (type $43) (param $0 v128) (param $1 v128) (result v128)
 ;; CHECK-NEXT:  (i8x16.shuffle 0 1 2 3 4 5 6 7 16 17 18 19 20 21 22 23
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $simd-shuffle (param v128 v128) (result v128)
  local.get 0
  local.get 1
  i8x16.shuffle 0 1 2 3 4 5 6 7 16 17 18 19 20 21 22 23
 )

 ;; CHECK:      (func $simd-ternary (type $44) (param $0 v128) (param $1 v128) (param $2 v128) (result v128)
 ;; CHECK-NEXT:  (v128.bitselect
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $simd-ternary (param v128 v128 v128) (result v128)
  local.get 0
  local.get 1
  local.get 2
  v128.bitselect
 )

 ;; CHECK:      (func $simd-shift (type $24) (param $0 v128) (param $1 i32) (result v128)
 ;; CHECK-NEXT:  (i8x16.shl
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $simd-shift (param v128 i32) (result v128)
  local.get 0
  local.get 1
  i8x16.shl
 )

 ;; CHECK:      (func $simd-load (type $6) (param $0 i32) (param $1 i64)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (v128.load8x8_s $mimport$0 offset=8
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (v128.load16_splat $mem-i64 offset=2 align=1
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $simd-load (param i32 i64)
  local.get 0
  v128.load8x8_s offset=8 align=8
  drop
  local.get 1
  v128.load16_splat $mem-i64 offset=2 align=1
  drop
 )

 ;; CHECK:      (func $simd-load-store-lane (type $12) (param $0 i32) (param $1 i64) (param $2 v128)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (v128.load16_lane $mimport$0 7
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (v128.store64_lane $mem-i64 align=4 0
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $simd-load-store-lane (param i32 i64 v128)
  local.get 0
  local.get 2
  v128.load16_lane 7
  drop
  local.get 1
  local.get 2
  v128.store64_lane 5 align=4 0
 )

 ;; CHECK:      (func $memory-init (type $23) (param $0 i32) (param $1 i32) (param $2 i32)
 ;; CHECK-NEXT:  (memory.init $mem-i32 $passive
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (memory.init $mem-i64 $0
 ;; CHECK-NEXT:   (i64.const 0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (memory.init $mimport$0 $implicit-data
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $memory-init (param i32 i32 i32)
  local.get 0
  local.get 1
  local.get 2
  memory.init $mem-i32 $passive
  i64.const 0
  local.get 1
  local.get 2
  memory.init 5 3
  local.get 0
  local.get 1
  local.get 2
  memory.init 0
 )

 ;; CHECK:      (func $data-drop (type $0)
 ;; CHECK-NEXT:  (data.drop $implicit-data)
 ;; CHECK-NEXT:  (data.drop $passive)
 ;; CHECK-NEXT: )
 (func $data-drop
  data.drop 0
  data.drop $passive
 )

 ;; CHECK:      (func $memory-copy (type $45) (param $0 i32) (param $1 i32) (param $2 i64) (param $3 i64)
 ;; CHECK-NEXT:  (memory.copy $mimport$0 $mimport$0
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (memory.copy $mem $mem-i32
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (i32.const 3)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (memory.copy $mem-i64 $mem-i64
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:   (local.get $3)
 ;; CHECK-NEXT:   (i64.const 4)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $memory-copy (param i32 i32 i64 i64)
  local.get 0
  local.get 1
  i32.const 2
  memory.copy
  local.get 0
  local.get 1
  i32.const 3
  memory.copy 2 $mem-i32
  local.get 2
  local.get 3
  i64.const 4
  memory.copy $mem-i64 5
 )

 ;; CHECK:      (func $memory-fill (type $6) (param $0 i32) (param $1 i64)
 ;; CHECK-NEXT:  (memory.fill $mimport$0
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (memory.fill $mimport$0
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (i32.const 3)
 ;; CHECK-NEXT:   (i32.const 4)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (memory.fill $mem-i64
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (i32.const 5)
 ;; CHECK-NEXT:   (i64.const 6)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $memory-fill (param i32 i64)
  local.get 0
  i32.const 1
  i32.const 2
  memory.fill
  local.get 0
  i32.const 3
  i32.const 4
  memory.fill 0
  local.get 1
  i32.const 5
  i64.const 6
  memory.fill $mem-i64
 )

 ;; CHECK:      (func $return-none (type $0)
 ;; CHECK-NEXT:  (return)
 ;; CHECK-NEXT: )
 (func $return-none
  return
 )

 ;; CHECK:      (func $return-one (type $25) (param $0 i32) (result i32)
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $return-one (param i32) (result i32)
  local.get 0
  return
 )

 ;; CHECK:      (func $return-two (type $19) (param $0 i32) (param $1 i64) (result i32 i64)
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (tuple.make 2
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $return-two (param i32 i64) (result i32 i64)
  local.get 0
  local.get 1
  return
 )

 ;; CHECK:      (func $return-two-first-unreachable (type $46) (param $0 i64) (result i32 i64)
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (tuple.make 2
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $return-two-first-unreachable (param i64) (result i32 i64)
  unreachable
  local.get 0
  return
 )

 ;; CHECK:      (func $return-two-second-unreachable (type $26) (param $0 i32) (result i32 i64)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $return-two-second-unreachable (param i32) (result i32 i64)
  local.get 0
  unreachable
  return
 )

 ;; CHECK:      (func $return-two-second-unreachable-tuple (type $26) (param $0 i32) (result i32 i64)
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (tuple.make 2
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $return-two-second-unreachable-tuple (param i32) (result i32 i64)
  local.get 0
  unreachable
  tuple.make 2
  return
 )

 ;; CHECK:      (func $return-multivalue (type $4) (result i32 i64)
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (call $return-multivalue)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $return-multivalue (result i32 i64)
  call $return-multivalue
  return
 )

 ;; CHECK:      (func $ref-is-null (type $47) (param $0 anyref) (result i32)
 ;; CHECK-NEXT:  (ref.is_null
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $ref-is-null (param anyref) (result i32)
  local.get 0
  ref.is_null
 )

 ;; CHECK:      (func $ref-func (type $0)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (ref.func $ref-func)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (ref.func $ref-func)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $ref-func
  ref.func $ref-func
  drop
  ref.func 161
  drop
 )

 ;; CHECK:      (func $throw (type $0)
 ;; CHECK-NEXT:  (throw $eimport$1)
 ;; CHECK-NEXT:  (throw $tag-i32
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (throw $tag-pair
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (i64.const 2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $throw
  throw 2
  i32.const 0
  throw $tag-i32
  i32.const 1
  i64.const 2
  throw $tag-pair
 )

 ;; CHECK:      (func $ref-eq (type $48) (param $0 eqref) (param $1 eqref) (result i32)
 ;; CHECK-NEXT:  (ref.eq
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $ref-eq (param eqref eqref) (result i32)
  local.get 0
  local.get 1
  ref.eq
 )

 ;; CHECK:      (func $table-get (type $0)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (table.get $timport$0
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (table.get $timport$1
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (table.get $table-any
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $table-get
  i32.const 0
  table.get
  drop
  i32.const 1
  table.get 1
  drop
  i32.const 2
  table.get $table-any
  drop
 )

 ;; CHECK:      (func $table-set (type $0)
 ;; CHECK-NEXT:  (table.set $timport$0
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (ref.null nofunc)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (table.set $funcs
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (ref.func $table-set)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (table.set $table-any
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:   (ref.null none)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $table-set
  i32.const 0
  ref.null func
  table.set
  i32.const 1
  ref.func $table-set
  table.set 2
  i32.const 2
  ref.null any
  table.set $table-any
 )

 ;; CHECK:      (func $table-size (type $0)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (table.size $timport$0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (table.size $timport$1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (table.size $table-any)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $table-size
  table.size
  drop
  table.size 1
  drop
  table.size $table-any
  drop
 )

 ;; CHECK:      (func $table-grow (type $0)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (table.grow $timport$0
 ;; CHECK-NEXT:    (ref.null nofunc)
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (table.grow $funcs
 ;; CHECK-NEXT:    (ref.func $table-grow)
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (table.grow $table-any
 ;; CHECK-NEXT:    (ref.null none)
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $table-grow
  ref.null func
  i32.const 0
  table.grow
  drop
  ref.func $table-grow
  i32.const 1
  table.grow 2
  drop
  ref.null any
  i32.const 2
  table.grow $table-any
  drop
 )

 ;; CHECK:      (func $table-fill (type $0)
 ;; CHECK-NEXT:  (table.fill $timport$0
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (ref.null nofunc)
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (table.fill $funcs
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:   (ref.func $table-fill)
 ;; CHECK-NEXT:   (i32.const 3)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (table.fill $table-any
 ;; CHECK-NEXT:   (i32.const 4)
 ;; CHECK-NEXT:   (ref.null none)
 ;; CHECK-NEXT:   (i32.const 5)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $table-fill
  i32.const 0
  ref.null func
  i32.const 1
  table.fill
  i32.const 2
  ref.func $table-fill
  i32.const 3
  table.fill 2
  i32.const 4
  ref.null any
  i32.const 5
  table.fill $table-any
 )

 ;; CHECK:      (func $table-copy (type $0)
 ;; CHECK-NEXT:  (table.copy $timport$0 $timport$0
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (table.copy $funcs $funcs
 ;; CHECK-NEXT:   (i32.const 3)
 ;; CHECK-NEXT:   (i32.const 4)
 ;; CHECK-NEXT:   (i32.const 5)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $table-copy
  i32.const 0
  i32.const 1
  i32.const 2
  table.copy
  i32.const 3
  i32.const 4
  i32.const 5
  table.copy 2 $funcs
 )

 ;; CHECK:      (func $i31-new (type $49) (param $0 i32) (result i31ref)
 ;; CHECK-NEXT:  (ref.i31
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $i31-new (param i32) (result i31ref)
  local.get 0
  ref.i31
 )

 ;; CHECK:      (func $i31-get (type $50) (param $0 i31ref)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i31.get_s
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i31.get_u
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $i31-get (param i31ref)
  local.get 0
  i31.get_s
  drop
  local.get 0
  i31.get_u
  drop
 )

 ;; CHECK:      (func $call-ref (type $0)
 ;; CHECK-NEXT:  (local $0 (ref null $void))
 ;; CHECK-NEXT:  (local $1 (ref null $ret2))
 ;; CHECK-NEXT:  (local $2 (ref null $many))
 ;; CHECK-NEXT:  (local $scratch (tuple i32 i32))
 ;; CHECK-NEXT:  (local $scratch_4 i32)
 ;; CHECK-NEXT:  (local $scratch_5 (tuple anyref (ref func)))
 ;; CHECK-NEXT:  (local $scratch_6 anyref)
 ;; CHECK-NEXT:  (call_ref $void
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (block (result i32)
 ;; CHECK-NEXT:    (local.set $scratch_4
 ;; CHECK-NEXT:     (tuple.extract 2 0
 ;; CHECK-NEXT:      (local.tee $scratch
 ;; CHECK-NEXT:       (call_ref $ret2
 ;; CHECK-NEXT:        (local.get $1)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (tuple.extract 2 1
 ;; CHECK-NEXT:      (local.get $scratch)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.get $scratch_4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (block (result anyref)
 ;; CHECK-NEXT:    (local.set $scratch_6
 ;; CHECK-NEXT:     (tuple.extract 2 0
 ;; CHECK-NEXT:      (local.tee $scratch_5
 ;; CHECK-NEXT:       (call_ref $many
 ;; CHECK-NEXT:        (i32.const 0)
 ;; CHECK-NEXT:        (i64.const 1)
 ;; CHECK-NEXT:        (f32.const 2)
 ;; CHECK-NEXT:        (f64.const 3)
 ;; CHECK-NEXT:        (local.get $2)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (tuple.extract 2 1
 ;; CHECK-NEXT:      (local.get $scratch_5)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.get $scratch_6)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $call-ref
  (local (ref null $void) (ref null $ret2) (ref null $many))
  local.get 0
  call_ref $void
  local.get 1
  call_ref $ret2
  drop
  drop
  i32.const 0
  i64.const 1
  f32.const 2
  f64.const 3
  local.get 2
  call_ref $many
  drop
  drop
 )

 ;; CHECK:      (func $ref-test (type $9) (param $0 anyref)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (ref.test i31ref
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (ref.test (ref $s0)
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $ref-test (param anyref)
  local.get 0
  ref.test i31ref
  drop
  local.get 0
  ref.test (ref $s0)
  drop
 )

 ;; CHECK:      (func $ref-cast (type $9) (param $0 anyref)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (ref.cast i31ref
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (ref.cast (ref $s0)
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $ref-cast (param anyref)
  local.get 0
  ref.cast i31ref
  drop
  local.get 0
  ref.cast (ref $s0)
  drop
 )

 ;; CHECK:      (func $br-on-null (type $9) (param $0 anyref)
 ;; CHECK-NEXT:  (block $label
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (br_on_null $label
 ;; CHECK-NEXT:     (local.get $0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-on-null (param anyref)
  local.get 0
  br_on_null 0
  drop
 )

 ;; CHECK:      (func $br-on-non-null (type $9) (param $0 anyref)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (block $block (result (ref any))
 ;; CHECK-NEXT:    (br_on_non_null $block
 ;; CHECK-NEXT:     (local.get $0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-on-non-null (param anyref)
  block (result (ref any))
   local.get 0
   br_on_non_null 0
   unreachable
  end
  drop
 )

 ;; CHECK:      (func $br-on-cast (type $9) (param $0 anyref)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (block $block (result i31ref)
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (block (result (ref any))
 ;; CHECK-NEXT:      (br_on_cast $block anyref i31ref
 ;; CHECK-NEXT:       (local.get $0)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-on-cast (param anyref)
  block (result i31ref)
   block (result (ref any))
    local.get 0
    br_on_cast 1 anyref i31ref
   end
   unreachable
  end
  drop
 )

 ;; CHECK:      (func $br-on-cast-fail (type $9) (param $0 anyref)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (block $block (result (ref any))
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (block (result i31ref)
 ;; CHECK-NEXT:      (br_on_cast_fail $block anyref i31ref
 ;; CHECK-NEXT:       (local.get $0)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $br-on-cast-fail (param anyref)
  block (result (ref any))
   block (result i31ref)
    local.get 0
    br_on_cast_fail 1 anyref i31ref
   end
   unreachable
  end
  drop
 )

 ;; CHECK:      (func $struct-new (type $51) (param $0 i32) (param $1 i64) (result (ref $pair))
 ;; CHECK-NEXT:  (struct.new $pair
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $struct-new (param i32 i64) (result (ref $pair))
  local.get 0
  local.get 1
  struct.new $pair
 )

 ;; CHECK:      (func $struct-new-default (type $52) (result (ref $pair))
 ;; CHECK-NEXT:  (struct.new_default $pair)
 ;; CHECK-NEXT: )
 (func $struct-new-default (result (ref $pair))
  struct.new_default 14
 )

 ;; CHECK:      (func $struct-get-0 (type $53) (param $0 (ref $pair)) (result i32)
 ;; CHECK-NEXT:  (struct.get $pair $first
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $struct-get-0 (param (ref $pair)) (result i32)
  local.get 0
  struct.get 14 0
 )

 ;; CHECK:      (func $struct-get-1 (type $54) (param $0 (ref $pair)) (result i64)
 ;; CHECK-NEXT:  (struct.get $pair $second
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $struct-get-1 (param (ref $pair)) (result i64)
  local.get 0
  struct.get $pair 1
 )

 ;; CHECK:      (func $struct-get-named (type $55) (param $0 (ref null $pair)) (result i32)
 ;; CHECK-NEXT:  (struct.get $pair $first
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $struct-get-named (param (ref null $pair)) (result i32)
  local.get 0
  struct.get $pair $first
 )

 ;; CHECK:      (func $struct-set-0 (type $56) (param $0 (ref $pair)) (param $1 i32)
 ;; CHECK-NEXT:  (struct.set $pair $first
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $struct-set-0 (param (ref $pair) i32)
  local.get 0
  local.get 1
  struct.set $pair 0
 )

 ;; CHECK:      (func $struct-set-1 (type $57) (param $0 (ref $pair)) (param $1 i64)
 ;; CHECK-NEXT:  (struct.set $pair $second
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $struct-set-1 (param (ref $pair) i64)
  local.get 0
  local.get 1
  struct.set 14 1
 )

 ;; CHECK:      (func $struct-set-named (type $58) (param $0 (ref null $pair)) (param $1 i64)
 ;; CHECK-NEXT:  (struct.set $pair $second
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $struct-set-named (param (ref null $pair) i64)
  local.get 0
  local.get 1
  struct.set 14 $second
 )

 ;; CHECK:      (func $array-new (type $59) (param $0 i64) (param $1 i32) (result (ref $a1))
 ;; CHECK-NEXT:  (array.new $a1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $array-new (param i64 i32) (result (ref 11))
  local.get 0
  local.get 1
  array.new $a1
 )

 ;; CHECK:      (func $array-new-default (type $60) (param $0 i32) (result (ref $a1))
 ;; CHECK-NEXT:  (array.new_default $a1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $array-new-default (param i32) (result (ref $a1))
  local.get 0
  array.new_default 11
 )

 ;; CHECK:      (func $array-new-data (type $61) (param $0 i32) (param $1 i32) (result (ref $a1))
 ;; CHECK-NEXT:  (array.new_data $a1 $implicit-data
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $array-new-data (param i32 i32) (result (ref $a1))
  local.get 0
  local.get 1
  array.new_data $a1 0
 )

 ;; CHECK:      (func $array-new-fixed (type $0)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (array.new_fixed $a0 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (array.new_fixed $a0 3
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $array-new-fixed
  array.new_fixed $a0 0
  drop
  i32.const 0
  i32.const 1
  i32.const 2
  array.new_fixed $a0 3
  drop
 )

 ;; CHECK:      (func $array-get (type $62) (param $0 (ref $a1)) (param $1 i32) (result i64)
 ;; CHECK-NEXT:  (array.get $a1
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $array-get (param (ref 11) i32) (result i64)
  local.get 0
  local.get 1
  array.get $a1
 )

 ;; CHECK:      (func $array-get-s (type $63) (param $0 (ref $packed-i8)) (param $1 i32) (result i32)
 ;; CHECK-NEXT:  (array.get_s $packed-i8
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $array-get-s (param (ref $packed-i8) i32) (result i32)
  local.get 0
  local.get 1
  array.get_s 15
 )

 ;; CHECK:      (func $array-get-u (type $64) (param $0 (ref $packed-i16)) (param $1 i32) (result i32)
 ;; CHECK-NEXT:  (array.get_u $packed-i16
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $array-get-u (param (ref 16) i32) (result i32)
  local.get 0
  local.get 1
  array.get_u $packed-i16
 )

 ;; CHECK:      (func $array-set (type $65) (param $0 (ref $a2)) (param $1 i32) (param $2 f32)
 ;; CHECK-NEXT:  (array.set $a2
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $array-set (param (ref $a2) i32 f32)
  local.get 0
  local.get 1
  local.get 2
  array.set $a2
 )

 ;; CHECK:      (func $array-len (type $66) (param $0 arrayref) (result i32)
 ;; CHECK-NEXT:  (array.len
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $array-len (param (ref null array)) (result i32)
  local.get 0
  array.len
 )

 ;; CHECK:      (func $array-copy (type $67) (param $0 (ref $a2)) (param $1 i32) (param $2 (ref $a2)) (param $3 i32) (param $4 i32)
 ;; CHECK-NEXT:  (array.copy $a2 $a2
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:   (local.get $3)
 ;; CHECK-NEXT:   (local.get $4)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $array-copy (param (ref $a2) i32 (ref $a2) i32 i32)
  local.get 0
  local.get 1
  local.get 2
  local.get 3
  local.get 4
  array.copy $a2 $a2
 )

 ;; CHECK:      (func $array-fill (type $68) (param $0 (ref $a2)) (param $1 i32) (param $2 f32) (param $3 i32)
 ;; CHECK-NEXT:  (array.fill $a2
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:   (local.get $3)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $array-fill (param (ref $a2) i32 f32 i32)
  local.get 0
  local.get 1
  local.get 2
  local.get 3
  array.fill $a2
 )

 ;; CHECK:      (func $array-init-data (type $69) (param $0 (ref $a2)) (param $1 i32) (param $2 i32) (param $3 i32)
 ;; CHECK-NEXT:  (array.init_data $a2 $implicit-data
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:   (local.get $3)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $array-init-data (param (ref $a2) i32 i32 i32)
  local.get 0
  local.get 1
  local.get 2
  local.get 3
  array.init_data $a2 0
 )

 ;; CHECK:      (func $array-init-elem (type $70) (param $0 (ref $any-array)) (param $1 i32) (param $2 i32) (param $3 i32)
 ;; CHECK-NEXT:  (array.init_elem $any-array $passive-2
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:   (local.get $3)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $array-init-elem (param (ref $any-array) i32 i32 i32)
  local.get 0
  local.get 1
  local.get 2
  local.get 3
  array.init_elem $any-array $passive-2
 )

 ;; CHECK:      (func $ref-as-non-null (type $9) (param $0 anyref)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (ref.as_non_null
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $ref-as-non-null (param anyref)
  local.get 0
  ref.as_non_null
  drop
 )

 ;; CHECK:      (func $any-convert-extern (type $71) (param $0 externref)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (any.convert_extern
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $any-convert-extern (param externref)
  local.get 0
  any.convert_extern
  drop
 )

 ;; CHECK:      (func $extern-convert-any (type $9) (param $0 anyref)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (extern.convert_any
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $extern-convert-any (param anyref)
  local.get 0
  extern.convert_any
  drop
 )

 ;; CHECK:      (func $string-new-gc (type $72) (param $0 (ref $packed-i8)) (param $1 i32) (param $2 i32) (result stringref)
 ;; CHECK-NEXT:  (string.new_lossy_utf8_array
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $string-new-gc (param (ref $packed-i8) i32 i32) (result stringref)
  local.get 0
  local.get 1
  local.get 2
  string.new_lossy_utf8_array
 )

 ;; CHECK:      (func $string-new-code-point (type $73) (param $0 i32) (result stringref)
 ;; CHECK-NEXT:  (string.from_code_point
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $string-new-code-point (param i32) (result stringref)
  local.get 0
  string.from_code_point
 )

 ;; CHECK:      (func $string-const (type $74) (result (ref string))
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (string.const "foobar")
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (string.const "\00\00\00")
 ;; CHECK-NEXT: )
 (func $string-const (result (ref string))
  string.const "foobar"
  drop
  string.const "\00\00\00"
 )

 ;; CHECK:      (func $string-measure (type $75) (param $0 stringref)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (string.measure_utf8
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (string.measure_wtf16
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $string-measure (param stringref)
  local.get 0
  string.measure_utf8
  drop
  local.get 0
  string.measure_wtf16
  drop
 )

 ;; CHECK:      (func $string-encode-gc (type $76) (param $0 stringref) (param $1 (ref $packed-i8)) (param $2 i32) (result i32)
 ;; CHECK-NEXT:  (string.encode_wtf16_array
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $string-encode-gc (param stringref (ref $packed-i8) i32) (result i32)
  local.get 0
  local.get 1
  local.get 2
  string.encode_wtf16_array
 )

 ;; CHECK:      (func $string-concat (type $77) (param $0 stringref) (param $1 stringref) (result (ref string))
 ;; CHECK-NEXT:  (string.concat
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $string-concat (param stringref stringref) (result (ref string))
  local.get 0
  local.get 1
  string.concat
 )

 ;; CHECK:      (func $string-eq (type $29) (param $0 stringref) (param $1 stringref) (result i32)
 ;; CHECK-NEXT:  (string.eq
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $string-eq (param stringref stringref) (result i32)
  local.get 0
  local.get 1
  string.eq
 )

 ;; CHECK:      (func $string-compare (type $29) (param $0 stringref) (param $1 stringref) (result i32)
 ;; CHECK-NEXT:  (string.compare
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $string-compare (param stringref stringref) (result i32)
  local.get 0
  local.get 1
  string.compare
 )

 ;; CHECK:      (func $string-get (type $78) (param $0 stringref) (param $1 i32) (result i32)
 ;; CHECK-NEXT:  (stringview_wtf16.get_codeunit
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $string-get (param stringref i32) (result i32)
  local.get 0
  local.get 1
  stringview_wtf16.get_codeunit
 )

 ;; CHECK:      (func $string-slice (type $79) (param $0 stringref) (param $1 i32) (param $2 i32) (result (ref string))
 ;; CHECK-NEXT:  (stringview_wtf16.slice
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $string-slice (param stringref i32 i32) (result (ref string))
  local.get 0
  local.get 1
  local.get 2
  stringview_wtf16.slice
 )

 ;; CHECK:      (func $call (type $simple) (param $0 i32) (param $1 i64) (result f32)
 ;; CHECK-NEXT:  (call $call
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $call (param i32 i64) (result f32)
  local.get 0
  local.get 1
  call $call
 )

 ;; CHECK:      (func $return_call (type $simple) (param $0 i32) (param $1 i64) (result f32)
 ;; CHECK-NEXT:  (return_call $return_call
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $return_call (param i32 i64) (result f32)
  local.get 0
  local.get 1
  return_call $return_call
 )

 ;; CHECK:      (func $call-indirect (type $12) (param $0 i32) (param $1 i64) (param $2 v128)
 ;; CHECK-NEXT:  (call_indirect $timport$0 (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $timport$0 (type $void)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $funcs (type $void)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $funcs (type $void)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $timport$0 (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (call_indirect $timport$0 (type $30)
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $call-indirect (param i32 i64 v128)
  local.get 0
  call_indirect
  local.get 0
  call_indirect 2
  local.get 0
  call_indirect $funcs
  local.get 0
  call_indirect (type $void)
  local.get 0
  call_indirect 2 (type $void) (param) (result)
  local.get 0
  call_indirect $funcs (type $void)
  local.get 0
  call_indirect (param) (result)
  local.get 0
  call_indirect 2 (param) (result)
  local.get 0
  call_indirect $funcs (param) (result)
  local.get 1
  local.get 2
  local.get 0
  call_indirect (param i64 v128) (result v128)
  drop
 )

 ;; CHECK:      (func $call-indirect-folded (type $12) (param $0 i32) (param $1 i64) (param $2 v128)
 ;; CHECK-NEXT:  (call_indirect $timport$0 (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $timport$0 (type $void)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $funcs (type $void)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $funcs (type $void)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $timport$0 (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (call_indirect $timport$0 (type $30)
 ;; CHECK-NEXT:    (local.get $1)
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $call-indirect-folded (param i32 i64 v128)
  (call_indirect
   (local.get 0)
  )
  (call_indirect 2
   (local.get 0)
  )
  (call_indirect $funcs
   (local.get 0)
  )
  (call_indirect (type $void)
   (local.get 0)
  )
  (call_indirect 2 (type $void) (param) (result)
   (local.get 0)
  )
  (call_indirect $funcs (type $void)
   (local.get 0)
  )
  (call_indirect (param) (result)
   (local.get 0)
  )
  (call_indirect 2 (param) (result)
   (local.get 0)
  )
  (call_indirect $funcs (param) (result)
   (local.get 0)
  )
  (drop
   (call_indirect (param i64 v128) (result v128)
    (local.get 1)
    (local.get 2)
    (local.get 0)
   )
  )
 )

 ;; CHECK:      (func $return-call-indirect (type $12) (param $0 i32) (param $1 i64) (param $2 v128)
 ;; CHECK-NEXT:  (return_call_indirect $timport$0 (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $timport$0 (type $void)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $funcs (type $void)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $funcs (type $void)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $timport$0 (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $timport$0 (type $31)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $return-call-indirect (param i32 i64 v128)
  local.get 0
  return_call_indirect
  local.get 0
  return_call_indirect 2
  local.get 0
  return_call_indirect $funcs
  local.get 0
  return_call_indirect (type $void)
  local.get 0
  return_call_indirect 2 (type $void) (param) (result)
  local.get 0
  return_call_indirect $funcs (type $void)
  local.get 0
  return_call_indirect (param) (result)
  local.get 0
  return_call_indirect 2 (param) (result)
  local.get 0
  return_call_indirect $funcs (param) (result)
  local.get 1
  local.get 2
  local.get 0
  return_call_indirect (param i64 v128)
 )

 ;; CHECK:      (func $return-call-indirect-folded (type $12) (param $0 i32) (param $1 i64) (param $2 v128)
 ;; CHECK-NEXT:  (return_call_indirect $timport$0 (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $timport$0 (type $void)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $funcs (type $void)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $funcs (type $void)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $timport$0 (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $funcs (type $0)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return_call_indirect $timport$0 (type $31)
 ;; CHECK-NEXT:   (local.get $1)
 ;; CHECK-NEXT:   (local.get $2)
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $return-call-indirect-folded (param i32 i64 v128)
  (return_call_indirect
   (local.get 0)
  )
  (return_call_indirect 2
   (local.get 0)
  )
  (return_call_indirect $funcs
   (local.get 0)
  )
  (return_call_indirect (type $void)
   (local.get 0)
  )
  (return_call_indirect 2 (type $void) (param) (result)
   (local.get 0)
  )
  (return_call_indirect $funcs (type $void)
   (local.get 0)
  )
  (return_call_indirect (param) (result)
   (local.get 0)
  )
  (return_call_indirect 2 (param) (result)
   (local.get 0)
  )
  (return_call_indirect $funcs (param) (result)
   (local.get 0)
  )
  (return_call_indirect (param i64 v128)
   (local.get 1)
   (local.get 2)
   (local.get 0)
  )
 )

 ;; CHECK:      (func $resume (type $80) (param $ct (ref $simple-cont))
 ;; CHECK-NEXT:  (local $f f32)
 ;; CHECK-NEXT:  (block $label
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (block $block (result (ref $to-f32-cont))
 ;; CHECK-NEXT:     (tuple.drop 3
 ;; CHECK-NEXT:      (block $block0 (type $36) (result i32 i64 (ref null $simple-cont))
 ;; CHECK-NEXT:       (local.set $f
 ;; CHECK-NEXT:        (resume $simple-cont (on $empty $block) (on $tag-pair-to-pair $block0)
 ;; CHECK-NEXT:         (i32.const 0)
 ;; CHECK-NEXT:         (i64.const 1)
 ;; CHECK-NEXT:         (local.get $ct)
 ;; CHECK-NEXT:        )
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:       (unreachable)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br $label)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $resume (param $ct (ref $simple-cont))
  (local $f f32)
  block (result (ref $to-f32-cont))
   block (result i32 i64 (ref null $simple-cont))
    i32.const 0
    i64.const 1
    local.get $ct
    resume $simple-cont (on $empty 1) (on $tag-pair-to-pair 0)
    local.set $f
    unreachable
   end
   unreachable
  end
  br 0
 )

 ;; CHECK:      (func $contnew (type $83) (param $f (ref $simple)) (result (ref $simple-cont))
 ;; CHECK-NEXT:  (cont.new $simple-cont
 ;; CHECK-NEXT:   (local.get $f)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $contnew (param $f (ref $simple)) (result (ref $simple-cont))
   local.get $f
   cont.new $simple-cont
 )

 ;; CHECK:      (func $contbind (type $84) (param $c (ref $cont-bind-before)) (result (ref $simple-cont))
 ;; CHECK-NEXT:  (cont.bind $cont-bind-before $simple-cont
 ;; CHECK-NEXT:   (i32.const 123)
 ;; CHECK-NEXT:   (i64.const 123)
 ;; CHECK-NEXT:   (local.get $c)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $contbind (param $c (ref $cont-bind-before)) (result (ref $simple-cont))
   i32.const 123
   i64.const 123
   local.get $c
   cont.bind $cont-bind-before $simple-cont
 )

 ;; CHECK:      (func $suspend (type $4) (result i32 i64)
 ;; CHECK-NEXT:  (suspend $tag-pair-to-pair
 ;; CHECK-NEXT:   (i32.const 123)
 ;; CHECK-NEXT:   (i64.const 456)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $suspend (result i32 i64)
   i32.const 123
   i64.const 456
   suspend $tag-pair-to-pair
 )

 ;; CHECK:      (func $source-maps (type $0)
 ;; CHECK-NEXT:  ;;@ src.cpp:40:1
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   ;;@ src.cpp:30:1
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    ;;@ src.cpp:10:1
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    ;;@ src.cpp:20:1
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  ;;@ src.cpp:90:1
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   ;;@ src.cpp:70:1
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    ;;@ src.cpp:50:1
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:    ;;@ src.cpp:60:1
 ;; CHECK-NEXT:    (block (result i32)
 ;; CHECK-NEXT:     ;;@ src.cpp:70:1
 ;; CHECK-NEXT:     (loop (result i32)
 ;; CHECK-NEXT:      ;;@ src.cpp:80:1
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  ;;@ src.cpp:100:1
 ;; CHECK-NEXT:  (block
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $source-maps
  ;;@ src.cpp:10:1
  i32.const 0
  ;;@ src.cpp:20:1
  i32.const 1
  (@src src.cpp:30:1)
  i32.add
  (@src src.cpp:40:1)
  drop
  ;;@ src.cpp:90:1
  (drop
   (@src src.cpp:70:1)
   (i32.add
    ;;@ src.cpp:50:1
    (i32.const 2)
    (@src src.cpp:60:1)
    (block (result i32)
     ;;@ src.cpp:70:1
     (loop (result i32)
       ;;@ src.cpp:80:1
       (unreachable)
     )
    )
   )
  )
  ;;@ src.cpp:100:1
  block
  end
 )

 ;; CHECK:      (func $source-map-propagation (type $0)
 ;; CHECK-NEXT:  ;;@ src.cpp:20:1
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    ;;@ src.cpp:10:1
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    ;;@ src.cpp:10:1
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  ;;@ src.cpp:20:1
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  ;;@ src.cpp:30:1
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (i32.const 100)
 ;; CHECK-NEXT:    (i32.const 200)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $source-map-propagation
  ;;@ src.cpp:10:1
  i32.const 0
  i32.const 1
  i32.add
  ;;@ src.cpp:20:1
  drop
  i32.const 2
  drop
  i32.const 100
  i32.const 200
  i32.add
  ;;@ src.cpp:30:1
  drop
 )

 ;; CHECK:      (func $use-types (type $96) (param $0 (ref $s0)) (param $1 (ref $s1)) (param $2 (ref $s2)) (param $3 (ref $s3)) (param $4 (ref $s4)) (param $5 (ref $s5)) (param $6 (ref $s6)) (param $7 (ref $s7)) (param $8 (ref $s8)) (param $9 (ref $a0)) (param $10 (ref $a1)) (param $11 (ref $a2)) (param $12 (ref $a3)) (param $13 (ref $subvoid)) (param $14 (ref $submany)) (param $15 (ref $all-types))
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT: )
 (func $use-types
  (param (ref $s0))
  (param (ref $s1))
  (param (ref $s2))
  (param (ref $s3))
  (param (ref $s4))
  (param (ref $s5))
  (param (ref $s6))
  (param (ref $s7))
  (param (ref $s8))
  (param (ref $a0))
  (param (ref $a1))
  (param (ref $a2))
  (param (ref $a3))
  (param (ref $subvoid))
  (param (ref $submany))
  (param (ref $all-types))
 )

 ;; The if is unreachable except through the break; make sure this is
 ;; parse correctly
 ;; CHECK:      (func $if-else-br-return (type $25) (param $a i32) (result i32)
 ;; CHECK-NEXT:  (block $label
 ;; CHECK-NEXT:   (if
 ;; CHECK-NEXT:    (local.get $a)
 ;; CHECK-NEXT:    (then
 ;; CHECK-NEXT:     (br $label)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (else
 ;; CHECK-NEXT:     (return
 ;; CHECK-NEXT:      (i32.const 0)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (i32.const 1)
 ;; CHECK-NEXT: )
 (func $if-else-br-return (param $a i32) (result i32)
  (if (local.get $a)
   (then
    (br 0)
   )
   (else
    (return (i32.const 0))
   )
  )
  (i32.const 1)
 )

 ;; CHECK:      (func $try-br-catch-all-return (type $0)
 ;; CHECK-NEXT:  (block $label
 ;; CHECK-NEXT:   (try
 ;; CHECK-NEXT:    (do
 ;; CHECK-NEXT:     (br $label)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (catch_all
 ;; CHECK-NEXT:     (return)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-br-catch-all-return
  (try
   (do
    (br 0)
   )
   (catch_all
     (return)
   )
  )
 )

 ;; CHECK:      (func $try-br-catch-return (type $0)
 ;; CHECK-NEXT:  (block $label
 ;; CHECK-NEXT:   (try
 ;; CHECK-NEXT:    (do
 ;; CHECK-NEXT:     (br $label)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (catch $empty
 ;; CHECK-NEXT:     (return)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $try-br-catch-return
  (try
   (do
    (br 0)
   )
   (catch $empty
     (return)
   )
  )
 )
)
