//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_serialization.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#include "duckdb/common/serializer/serializer.hpp"
#include "duckdb/common/serializer/deserializer.hpp"
#include "buffered_json_reader.hpp"
#include "json_transform.hpp"
#include "json_scan.hpp"

namespace duckdb {

void BufferedJSONReaderOptions::Serialize(Serializer &serializer) const {
	serializer.WriteProperty<JSONFormat>(100, "format", format);
	serializer.WriteProperty<JSONRecordType>(101, "record_type", record_type);
	serializer.WriteProperty<FileCompressionType>(102, "compression", compression);
	serializer.WriteProperty<MultiFileReaderOptions>(103, "file_options", file_options);
}

BufferedJSONReaderOptions BufferedJSONReaderOptions::Deserialize(Deserializer &deserializer) {
	BufferedJSONReaderOptions result;
	deserializer.ReadProperty<JSONFormat>(100, "format", result.format);
	deserializer.ReadProperty<JSONRecordType>(101, "record_type", result.record_type);
	deserializer.ReadProperty<FileCompressionType>(102, "compression", result.compression);
	deserializer.ReadProperty<MultiFileReaderOptions>(103, "file_options", result.file_options);
	return result;
}

void JSONScanData::Serialize(Serializer &serializer) const {
	serializer.WriteProperty<JSONScanType>(100, "json_type", type);
	serializer.WriteProperty<BufferedJSONReaderOptions>(101, "options", options);
	serializer.WriteProperty<MultiFileReaderBindData>(102, "reader_bind", reader_bind);
	serializer.WritePropertyWithDefault<vector<string>>(103, "files", files);
	serializer.WritePropertyWithDefault<bool>(104, "ignore_errors", ignore_errors);
	serializer.WritePropertyWithDefault<idx_t>(105, "maximum_object_size", maximum_object_size);
	serializer.WritePropertyWithDefault<bool>(106, "auto_detect", auto_detect);
	serializer.WritePropertyWithDefault<idx_t>(107, "sample_size", sample_size);
	serializer.WritePropertyWithDefault<idx_t>(108, "max_depth", max_depth);
	serializer.WriteProperty<JSONTransformOptions>(109, "transform_options", transform_options);
	serializer.WritePropertyWithDefault<vector<string>>(110, "names", names);
	serializer.WritePropertyWithDefault<string>(111, "date_format", GetDateFormat());
	serializer.WritePropertyWithDefault<string>(112, "timestamp_format", GetTimestampFormat());
	serializer.WritePropertyWithDefault<double>(113, "field_appearance_threshold", field_appearance_threshold, 0.1);
	serializer.WritePropertyWithDefault<idx_t>(114, "maximum_sample_files", maximum_sample_files, 32);
	serializer.WritePropertyWithDefault<bool>(115, "convert_strings_to_integers", convert_strings_to_integers, false);
}

unique_ptr<JSONScanData> JSONScanData::Deserialize(Deserializer &deserializer) {
	auto type = deserializer.ReadProperty<JSONScanType>(100, "json_type");
	auto options = deserializer.ReadProperty<BufferedJSONReaderOptions>(101, "options");
	auto reader_bind = deserializer.ReadProperty<MultiFileReaderBindData>(102, "reader_bind");
	auto files = deserializer.ReadPropertyWithDefault<vector<string>>(103, "files");
	auto ignore_errors = deserializer.ReadPropertyWithDefault<bool>(104, "ignore_errors");
	auto maximum_object_size = deserializer.ReadPropertyWithDefault<idx_t>(105, "maximum_object_size");
	auto auto_detect = deserializer.ReadPropertyWithDefault<bool>(106, "auto_detect");
	auto sample_size = deserializer.ReadPropertyWithDefault<idx_t>(107, "sample_size");
	auto max_depth = deserializer.ReadPropertyWithDefault<idx_t>(108, "max_depth");
	auto transform_options = deserializer.ReadProperty<JSONTransformOptions>(109, "transform_options");
	auto names = deserializer.ReadPropertyWithDefault<vector<string>>(110, "names");
	auto date_format = deserializer.ReadPropertyWithDefault<string>(111, "date_format");
	auto timestamp_format = deserializer.ReadPropertyWithDefault<string>(112, "timestamp_format");
	auto result = duckdb::unique_ptr<JSONScanData>(new JSONScanData(deserializer.Get<ClientContext &>(), std::move(files), std::move(date_format), std::move(timestamp_format)));
	result->type = type;
	result->options = options;
	result->reader_bind = reader_bind;
	result->ignore_errors = ignore_errors;
	result->maximum_object_size = maximum_object_size;
	result->auto_detect = auto_detect;
	result->sample_size = sample_size;
	result->max_depth = max_depth;
	result->transform_options = transform_options;
	result->names = std::move(names);
	deserializer.ReadPropertyWithDefault<double>(113, "field_appearance_threshold", result->field_appearance_threshold, 0.1);
	deserializer.ReadPropertyWithDefault<idx_t>(114, "maximum_sample_files", result->maximum_sample_files, 32);
	deserializer.ReadPropertyWithDefault<bool>(115, "convert_strings_to_integers", result->convert_strings_to_integers, false);
	return result;
}

void JSONTransformOptions::Serialize(Serializer &serializer) const {
	serializer.WritePropertyWithDefault<bool>(100, "strict_cast", strict_cast);
	serializer.WritePropertyWithDefault<bool>(101, "error_duplicate_key", error_duplicate_key);
	serializer.WritePropertyWithDefault<bool>(102, "error_missing_key", error_missing_key);
	serializer.WritePropertyWithDefault<bool>(103, "error_unknown_key", error_unknown_key);
	serializer.WritePropertyWithDefault<bool>(104, "delay_error", delay_error);
}

JSONTransformOptions JSONTransformOptions::Deserialize(Deserializer &deserializer) {
	JSONTransformOptions result;
	deserializer.ReadPropertyWithDefault<bool>(100, "strict_cast", result.strict_cast);
	deserializer.ReadPropertyWithDefault<bool>(101, "error_duplicate_key", result.error_duplicate_key);
	deserializer.ReadPropertyWithDefault<bool>(102, "error_missing_key", result.error_missing_key);
	deserializer.ReadPropertyWithDefault<bool>(103, "error_unknown_key", result.error_unknown_key);
	deserializer.ReadPropertyWithDefault<bool>(104, "delay_error", result.delay_error);
	return result;
}

} // namespace duckdb
