import datetime
import glob
import os
import re
import requests


def print_checkers(glob_pattern:str):
    checkers = {}
    for filename in glob.glob(glob_pattern):
        for line in open(filename,'rt'):
            res = re.match(r'[ \t]*logChecker\(\s*"([^"]+)"\s*\);.*', line)
            if res is None:
                continue
            if line.find('//') > 0:
                req = line[line.find('//')+2:].strip()
            else:
                req = ''
            checkers[res.group(1)] = req
    for c,req in dict(sorted(checkers.items())).items():
        print('        {"%s","%s"},' % (c, req))


print("""/*
 * Cppcheck - A tool for static C/C++ code analysis
 * Copyright (C) 2007-%i Cppcheck team.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// This file is auto-generated by tools/get_checkers.py:
// python3 tools/get_checkers.py > lib/checkers.cpp

#include "checkers.h"

namespace checkers {
    const std::map<std::string, std::string> allCheckers{""" % (datetime.date.today().year,))
print_checkers(os.path.expanduser('~/cppchecksolutions/cppcheck/lib/*.cpp'))
print("    };\n")

print('    const std::map<std::string, std::string> premiumCheckers{')
print_checkers(os.path.expanduser('~/cppchecksolutions/addon/src/*.cpp'))
print('    };')


print("""
    const char Req[] = "Required";
    const char Adv[] = "Advisory";
    const char Man[] = "Mandatory";
    const char Doc[] = "Document";
    const char Dis[] = "Disapplied";""")

for version in (2012, 2023, 2025):
    with open(os.path.expanduser('~/cppchecksolutions/addon/coverage/misra-c-%i.txt' % version), 'rt') as f:
        all_guidelines = f.read()

    if version == 2012:
        amd = {'4.6':3,'4.9':3,'4.11':3,'4.14':2,'4.15':3,'5.1':4,'5.2':4,'5.3':4}
    else:
        amd = {}

    print('    const std::vector<MisraInfo> misraC%iDirectives{' % version)
    for line in all_guidelines.split('\n'):
        res = re.match(r'Dir\s+(\d+)[.](\d+)\s+(\w+).*', line)
        if res:
            a = amd.get('%s.%s' % (res.group(1), res.group(2)), 0)
            print('        {%s,%s,%s,%i},' % (res.group(1), res.group(2), res.group(3)[:3], a))
    print('    };')

    if version == 2012:
        amd = {'1.4':2,
               '1.5':3,
               '12.5':1,
               '12.6':4,
               '21.13':1,
               '21.14':1,
               '21.15':1,
               '21.16':1,
               '21.17':1,
               '21.18':1,
               '21.19':1,
               '21.20':1,
               '21.21':3,
               '21.22':3,
               '21.23':3,
               '21.24':3,
               '21.25':4,
               '21.26':4,
               '22.7':1,
               '22.8':1,
               '22.9':1,
               '22.10':1,
               '22.11':4,
               '22.12':4,
               '22.13':4,
               '22.14':4,
               '22.15':4,
               '22.16':4,
               '22.17':4,
               '22.18':4,
               '22.19':4,
               '22.20':4,
               '23.1':3,
               '23.2':3,
               '23.3':3,
               '23.4':3,
               '23.5':3,
               '23.6':3,
               '23.7':3,
               '23.8':3 }
    else:
        amd = {}

    print('    const std::vector<MisraInfo> misraC%iRules{' % version)
    for line in all_guidelines.split('\n'):
        res = re.match(r'Rule\s+(\d+)[.](\d+)\s+(\w+).*', line)
        if res:
            a = amd.get('%s.%s' % (res.group(1), res.group(2)), 0)
            comment = '' if a == 0 else ' // Amendment %i' % a
            print('        {%s,%s,%s,%i},%s' % (res.group(1), res.group(2), res.group(3)[:3], a, comment))
    print('    };')

print("""
    const std::vector<MisraCppInfo> misraCpp2008Rules =
    {
        {0,1,1,Req},
        {0,1,2,Req},
        {0,1,3,Req},
        {0,1,4,Req},
        {0,1,5,Req},
        {0,1,6,Req},
        {0,1,7,Req},
        {0,1,8,Req},
        {0,1,9,Req},
        {0,1,10,Req},
        {0,1,11,Req},
        {0,1,12,Req},
        {0,2,1,Req},
        {0,3,1,Doc},
        {0,3,2,Req},
        {0,4,1,Doc},
        {0,4,2,Doc},
        {0,4,3,Doc},
        {1,0,1,Req},
        {1,0,2,Doc},
        {1,0,3,Doc},
        {2,2,1,Doc},
        {2,3,1,Req},
        {2,5,1,Adv},
        {2,7,1,Req},
        {2,7,2,Req},
        {2,7,3,Adv},
        {2,10,1,Req},
        {2,10,2,Req},
        {2,10,3,Req},
        {2,10,4,Req},
        {2,10,5,Adv},
        {2,10,6,Req},
        {2,13,1,Req},
        {2,13,2,Req},
        {2,13,3,Req},
        {2,13,4,Req},
        {2,13,5,Req},
        {3,1,1,Req},
        {3,1,2,Req},
        {3,1,3,Req},
        {3,2,1,Req},
        {3,2,2,Req},
        {3,2,3,Req},
        {3,2,4,Req},
        {3,3,1,Req},
        {3,3,2,Req},
        {3,4,1,Req},
        {3,9,1,Req},
        {3,9,2,Adv},
        {3,9,3,Req},
        {4,5,1,Req},
        {4,5,2,Req},
        {4,5,3,Req},
        {4,10,1,Req},
        {4,10,2,Req},
        {5,0,1,Req},
        {5,0,2,Adv},
        {5,0,3,Req},
        {5,0,4,Req},
        {5,0,5,Req},
        {5,0,6,Req},
        {5,0,7,Req},
        {5,0,8,Req},
        {5,0,9,Req},
        {5,0,10,Req},
        {5,0,11,Req},
        {5,0,12,Req},
        {5,0,13,Req},
        {5,0,14,Req},
        {5,0,15,Req},
        {5,0,16,Req},
        {5,0,17,Req},
        {5,0,18,Req},
        {5,0,19,Req},
        {5,0,20,Req},
        {5,0,21,Req},
        {5,2,1,Req},
        {5,2,2,Req},
        {5,2,3,Adv},
        {5,2,4,Req},
        {5,2,5,Req},
        {5,2,6,Req},
        {5,2,7,Req},
        {5,2,8,Req},
        {5,2,9,Adv},
        {5,2,10,Adv},
        {5,2,11,Req},
        {5,2,12,Req},
        {5,3,1,Req},
        {5,3,2,Req},
        {5,3,3,Req},
        {5,3,4,Req},
        {5,8,1,Req},
        {5,14,1,Req},
        {5,17,1,Req},
        {5,18,1,Req},
        {5,19,1,Adv},
        {6,2,1,Req},
        {6,2,2,Req},
        {6,2,3,Req},
        {6,3,1,Req},
        {6,4,1,Req},
        {6,4,2,Req},
        {6,4,3,Req},
        {6,4,4,Req},
        {6,4,5,Req},
        {6,4,6,Req},
        {6,4,7,Req},
        {6,4,8,Req},
        {6,5,1,Req},
        {6,5,2,Req},
        {6,5,3,Req},
        {6,5,4,Req},
        {6,5,5,Req},
        {6,5,6,Req},
        {6,6,1,Req},
        {6,6,2,Req},
        {6,6,3,Req},
        {6,6,4,Req},
        {6,6,5,Req},
        {7,1,1,Req},
        {7,1,2,Req},
        {7,2,1,Req},
        {7,3,1,Req},
        {7,3,2,Req},
        {7,3,3,Req},
        {7,3,4,Req},
        {7,3,5,Req},
        {7,3,6,Req},
        {7,4,1,Doc},
        {7,4,2,Req},
        {7,4,3,Req},
        {7,5,1,Req},
        {7,5,2,Req},
        {7,5,3,Req},
        {7,5,4,Adv},
        {8,4,1,Req},
        {8,4,2,Req},
        {8,4,3,Req},
        {8,4,4,Req},
        {8,5,1,Req},
        {8,5,2,Req},
        {8,5,3,Req},
        {9,3,1,Req},
        {9,3,2,Req},
        {9,3,3,Req},
        {9,5,1,Req},
        {9,6,1,Doc},
        {9,6,2,Req},
        {9,6,3,Req},
        {9,6,4,Req},
        {10,1,1,Adv},
        {10,1,2,Req},
        {10,1,3,Req},
        {10,2,1,Adv},
        {10,3,1,Req},
        {10,3,2,Req},
        {10,3,3,Req},
        {11,0,1,Req},
        {12,1,1,Req},
        {12,1,2,Adv},
        {12,1,3,Req},
        {12,8,1,Req},
        {12,8,2,Req},
        {14,5,1,Req},
        {14,5,2,Req},
        {14,5,3,Req},
        {14,6,1,Req},
        {14,6,2,Req},
        {14,7,1,Req},
        {14,7,2,Req},
        {14,7,3,Req},
        {14,8,1,Req},
        {14,8,2,Req},
        {15,0,1,Req},
        {15,0,2,Req},
        {15,0,3,Req},
        {15,1,1,Req},
        {15,1,2,Req},
        {15,1,3,Req},
        {15,3,1,Req},
        {15,3,2,Adv},
        {15,3,3,Req},
        {15,3,4,Req},
        {15,3,5,Req},
        {15,3,6,Req},
        {15,3,7,Req},
        {15,4,1,Req},
        {15,5,1,Req},
        {15,5,2,Req},
        {15,5,3,Req},
        {16,0,1,Req},
        {16,0,2,Req},
        {16,0,3,Req},
        {16,0,4,Req},
        {16,0,5,Req},
        {16,0,6,Req},
        {16,0,7,Req},
        {16,0,8,Req},
        {16,1,1,Req},
        {16,1,2,Req},
        {16,2,1,Req},
        {16,2,2,Req},
        {16,2,3,Req},
        {16,2,4,Req},
        {16,2,5,Adv},
        {16,2,6,Req},
        {16,3,1,Req},
        {16,3,2,Adv},
        {16,6,1,Doc},
        {17,0,1,Req},
        {17,0,2,Req},
        {17,0,3,Req},
        {17,0,4,Doc},
        {17,0,5,Req},
        {18,0,1,Req},
        {18,0,2,Req},
        {18,0,3,Req},
        {18,0,4,Req},
        {18,0,5,Req},
        {18,2,1,Req},
        {18,4,1,Req},
        {18,7,1,Req},
        {19,3,1,Req},
        {27,0,1,Req}
    };

    const std::vector<MisraCppInfo> misraCpp2023Directives =
    {
        {0,3,1,Adv},
        {0,3,2,Req},
        {5,7,2,Adv},
        {15,8,1,Req},
    };

    const std::vector<MisraCppInfo> misraCpp2023Rules =
    {
        {0,0,1,Req},
        {0,0,2,Adv},
        {0,1,1,Adv},
        {0,1,2,Req},
        {0,2,1,Adv},
        {0,2,2,Req},
        {0,2,3,Adv},
        {0,2,4,Adv},
        {4,1,1,Req},
        {4,1,2,Adv},
        {4,1,3,Req},
        {4,6,1,Req},
        {5,0,1,Adv},
        {5,7,1,Req},
        {5,7,3,Req},
        {5,10,1,Req},
        {5,13,1,Req},
        {5,13,2,Req},
        {5,13,3,Req},
        {5,13,4,Req},
        {5,13,5,Req},
        {5,13,6,Req},
        {5,13,7,Req},
        {6,0,1,Req},
        {6,0,2,Adv},
        {6,0,3,Adv},
        {6,0,4,Req},
        {6,2,1,Req},
        {6,2,2,Req},
        {6,2,3,Req},
        {6,2,4,Req},
        {6,4,1,Req},
        {6,4,2,Req},
        {6,4,3,Req},
        {6,5,1,Adv},
        {6,5,2,Adv},
        {6,7,1,Req},
        {6,7,2,Req},
        {6,8,1,Req},
        {6,8,2,Man},
        {6,8,3,Req},
        {6,8,4,Adv},
        {6,9,1,Req},
        {6,9,2,Adv},
        {7,0,1,Req},
        {7,0,2,Req},
        {7,0,3,Req},
        {7,0,4,Req},
        {7,0,5,Req},
        {7,0,6,Req},
        {7,11,1,Req},
        {7,11,2,Req},
        {7,11,3,Req},
        {8,0,1,Adv},
        {8,1,1,Req},
        {8,1,2,Adv},
        {8,2,1,Req},
        {8,2,2,Req},
        {8,2,3,Req},
        {8,2,4,Req},
        {8,2,5,Req},
        {8,2,6,Req},
        {8,2,7,Adv},
        {8,2,8,Req},
        {8,2,9,Req},
        {8,2,10,Req},
        {8,2,11,Req},
        {8,3,1,Adv},
        {8,3,2,Adv},
        {8,7,1,Req},
        {8,7,2,Req},
        {8,9,1,Req},
        {8,14,1,Adv},
        {8,18,1,Man},
        {8,18,2,Adv},
        {8,19,1,Adv},
        {8,20,1,Adv},
        {9,2,1,Req},
        {9,3,1,Req},
        {9,4,1,Req},
        {9,4,2,Req},
        {9,5,2,Adv},
        {9,5,3,Req},
        {9,6,1,Adv},
        {9,6,2,Req},
        {9,6,3,Req},
        {9,6,4,Req},
        {9,6,5,Req},
        {10,0,1,Adv},
        {10,1,1,Adv},
        {10,1,2,Req},
        {10,2,1,Req},
        {10,2,2,Adv},
        {10,2,3,Req},
        {10,3,1,Adv},
        {10,4,1,Req},
        {11,3,1,Adv},
        {11,3,2,Adv},
        {11,6,1,Adv},
        {11,6,2,Man},
        {11,6,3,Req},
        {12,2,1,Adv},
        {12,2,2,Req},
        {12,2,3,Req},
        {12,3,1,Req},
        {13,1,1,Adv},
        {13,1,2,Req},
        {13,3,1,Req},
        {13,3,2,Req},
        {13,3,3,Req},
        {13,3,4,Req},
        {14,1,1,Adv},
        {15,0,1,Req},
        {15,0,2,Adv},
        {15,1,1,Req},
        {15,1,2,Adv},
        {15,1,3,Req},
        {15,1,4,Adv},
        {15,1,5,Req},
        {16,5,2,Req},
        {16,6,1,Adv},
        {17,8,1,Req},
        {18,1,1,Req},
        {18,1,2,Req},
        {18,3,1,Adv},
        {18,3,2,Req},
        {18,3,3,Req},
        {18,4,1,Req},
        {18,5,1,Adv},
        {18,5,2,Adv},
        {19,0,1,Req},
        {19,0,2,Req},
        {19,0,3,Adv},
        {19,0,4,Adv},
        {19,1,1,Req},
        {19,1,2,Req},
        {19,1,3,Req},
        {19,2,1,Req},
        {19,2,2,Req},
        {19,2,3,Req},
        {19,3,1,Adv},
        {19,3,2,Req},
        {19,3,3,Req},
        {19,3,4,Req},
        {19,3,5,Req},
        {19,6,1,Adv},
        {21,2,1,Req},
        {21,2,2,Req},
        {21,2,3,Req},
        {21,2,4,Req},
        {21,6,1,Adv},
        {21,6,2,Req},
        {21,6,3,Req},
        {21,6,4,Req},
        {21,6,5,Req},
        {21,10,1,Req},
        {21,10,2,Req},
        {21,10,3,Req},
        {22,3,1,Req},
        {22,4,1,Req},
        {23,11,1,Adv},
        {24,5,1,Req},
        {24,5,2,Req},
        {25,5,1,Req},
        {25,5,2,Man},
        {25,5,3,Man},
        {26,3,1,Adv},
        {28,3,1,Req},
        {28,6,1,Req},
        {28,6,2,Req},
        {28,6,3,Req},
        {28,6,4,Req},
        {30,0,1,Req},
        {30,0,2,Req}
    };
}

std::vector<checkers::Info> checkers::autosarInfo{
    {"m0-1-1", checkers::Req},
    {"m0-1-2", checkers::Req},
    {"m0-1-3", checkers::Req},
    {"m0-1-4", checkers::Req},
    {"a0-1-1", checkers::Req},
    {"a0-1-2", checkers::Req},
    {"m0-1-8", checkers::Req},
    {"m0-1-9", checkers::Req},
    {"m0-1-10", checkers::Adv},
    {"a0-1-3", checkers::Req},
    {"a0-1-4", checkers::Req},
    {"a0-1-5", checkers::Req},
    {"a0-1-6", checkers::Adv},
    {"m0-2-1", checkers::Req},
    {"a0-4-2", checkers::Req},
    {"a0-4-3", checkers::Req},
    {"a0-4-4", checkers::Req},
    {"a1-1-1", checkers::Req},
    {"a1-4-3", checkers::Adv},
    {"a2-3-1", checkers::Req},
    {"a2-5-1", checkers::Req},
    {"a2-5-2", checkers::Req},
    {"m2-7-1", checkers::Req},
    {"a2-7-1", checkers::Req},
    {"a2-7-3", checkers::Req},
    {"a2-8-2", checkers::Adv},
    {"m2-10-1", checkers::Req},
    {"a2-10-1", checkers::Req},
    {"a2-10-6", checkers::Req},
    {"a2-10-4", checkers::Req},
    {"a2-10-5", checkers::Adv},
    {"a2-11-1", checkers::Req},
    {"a2-13-1", checkers::Req},
    {"a2-13-6", checkers::Req},
    {"a2-13-5", checkers::Adv},
    {"m2-13-2", checkers::Req},
    {"m2-13-3", checkers::Req},
    {"m2-13-4", checkers::Req},
    {"a2-13-2", checkers::Req},
    {"a2-13-3", checkers::Req},
    {"a2-13-4", checkers::Req},
    {"a3-1-1", checkers::Req},
    {"a3-1-2", checkers::Req},
    {"a3-1-3", checkers::Adv},
    {"m3-1-2", checkers::Req},
    {"a3-1-4", checkers::Req},
    {"a3-1-6", checkers::Adv},
    {"m3-2-1", checkers::Req},
    {"m3-2-2", checkers::Req},
    {"m3-2-3", checkers::Req},
    {"m3-2-4", checkers::Req},
    {"a3-3-1", checkers::Req},
    {"a3-3-2", checkers::Req},
    {"m3-3-2", checkers::Req},
    {"m3-4-1", checkers::Req},
    {"m3-9-1", checkers::Req},
    {"a3-9-1", checkers::Req},
    {"m3-9-3", checkers::Req},
    {"m4-5-1", checkers::Req},
    {"a4-5-1", checkers::Req},
    {"m4-5-3", checkers::Req},
    {"a4-7-1", checkers::Req},
    {"m4-10-1", checkers::Req},
    {"a4-10-1", checkers::Req},
    {"m4-10-2", checkers::Req},
    {"a5-0-1", checkers::Req},
    {"m5-0-2", checkers::Adv},
    {"m5-0-3", checkers::Req},
    {"m5-0-4", checkers::Req},
    {"m5-0-5", checkers::Req},
    {"m5-0-6", checkers::Req},
    {"m5-0-7", checkers::Req},
    {"m5-0-8", checkers::Req},
    {"m5-0-9", checkers::Req},
    {"m5-0-10", checkers::Req},
    {"m5-0-11", checkers::Req},
    {"m5-0-12", checkers::Req},
    {"a5-0-2", checkers::Req},
    {"m5-0-14", checkers::Req},
    {"m5-0-15", checkers::Req},
    {"m5-0-16", checkers::Req},
    {"m5-0-17", checkers::Req},
    {"a5-0-4", checkers::Req},
    {"m5-0-18", checkers::Req},
    {"a5-0-3", checkers::Req},
    {"m5-0-20", checkers::Req},
    {"m5-0-21", checkers::Req},
    {"a5-1-1", checkers::Req},
    {"a5-1-2", checkers::Req},
    {"a5-1-3", checkers::Req},
    {"a5-1-4", checkers::Req},
    {"a5-1-6", checkers::Adv},
    {"a5-1-7", checkers::Req},
    {"a5-1-8", checkers::Adv},
    {"a5-1-9", checkers::Adv},
    {"m5-2-2", checkers::Req},
    {"m5-2-3", checkers::Adv},
    {"a5-2-1", checkers::Adv},
    {"a5-2-2", checkers::Req},
    {"a5-2-3", checkers::Req},
    {"m5-2-6", checkers::Req},
    {"a5-2-4", checkers::Req},
    {"a5-2-6", checkers::Req},
    {"m5-2-8", checkers::Req},
    {"m5-2-9", checkers::Req},
    {"m5-2-10", checkers::Req},
    {"m5-2-11", checkers::Req},
    {"a5-2-5", checkers::Req},
    {"m5-2-12", checkers::Req},
    {"m5-3-1", checkers::Req},
    {"m5-3-2", checkers::Req},
    {"m5-3-3", checkers::Req},
    {"m5-3-4", checkers::Req},
    {"a5-3-1", checkers::Req},
    {"a5-3-2", checkers::Req},
    {"a5-3-3", checkers::Req},
    {"a5-5-1", checkers::Req},
    {"a5-6-1", checkers::Req},
    {"m5-8-1", checkers::Req},
    {"a5-10-1", checkers::Req},
    {"m5-14-1", checkers::Req},
    {"a5-16-1", checkers::Req},
    {"m5-18-1", checkers::Req},
    {"m5-19-1", checkers::Req},
    {"m6-2-1", checkers::Req},
    {"a6-2-1", checkers::Req},
    {"a6-2-2", checkers::Req},
    {"m6-2-2", checkers::Req},
    {"m6-2-3", checkers::Req},
    {"m6-3-1", checkers::Req},
    {"m6-4-1", checkers::Req},
    {"m6-4-2", checkers::Req},
    {"m6-4-3", checkers::Req},
    {"m6-4-4", checkers::Req},
    {"m6-4-5", checkers::Req},
    {"m6-4-6", checkers::Req},
    {"m6-4-7", checkers::Req},
    {"a6-4-1", checkers::Req},
    {"a6-5-1", checkers::Req},
    {"a6-5-2", checkers::Req},
    {"m6-5-2", checkers::Req},
    {"m6-5-3", checkers::Req},
    {"m6-5-4", checkers::Req},
    {"m6-5-5", checkers::Req},
    {"m6-5-6", checkers::Req},
    {"a6-5-3", checkers::Adv},
    {"a6-5-4", checkers::Adv},
    {"a6-6-1", checkers::Req},
    {"m6-6-1", checkers::Req},
    {"m6-6-2", checkers::Req},
    {"m6-6-3", checkers::Req},
    {"a7-1-1", checkers::Req},
    {"a7-1-2", checkers::Req},
    {"m7-1-2", checkers::Req},
    {"a7-1-3", checkers::Req},
    {"a7-1-4", checkers::Req},
    {"a7-1-5", checkers::Req},
    {"a7-1-6", checkers::Req},
    {"a7-1-7", checkers::Req},
    {"a7-1-8", checkers::Req},
    {"a7-1-9", checkers::Req},
    {"a7-2-1", checkers::Req},
    {"a7-2-2", checkers::Req},
    {"a7-2-3", checkers::Req},
    {"a7-2-4", checkers::Req},
    {"m7-3-1", checkers::Req},
    {"m7-3-2", checkers::Req},
    {"m7-3-3", checkers::Req},
    {"m7-3-4", checkers::Req},
    {"a7-3-1", checkers::Req},
    {"m7-3-6", checkers::Req},
    {"a7-4-1", checkers::Req},
    {"m7-4-2", checkers::Req},
    {"m7-4-3", checkers::Req},
    {"a7-5-1", checkers::Req},
    {"a7-5-2", checkers::Req},
    {"a7-6-1", checkers::Req},
    {"m8-0-1", checkers::Req},
    {"a8-2-1", checkers::Req},
    {"m8-3-1", checkers::Req},
    {"a8-4-1", checkers::Req},
    {"m8-4-2", checkers::Req},
    {"a8-4-2", checkers::Req},
    {"m8-4-4", checkers::Req},
    {"a8-4-4", checkers::Adv},
    {"a8-4-5", checkers::Req},
    {"a8-4-6", checkers::Req},
    {"a8-4-7", checkers::Req},
    {"a8-4-8", checkers::Req},
    {"a8-4-9", checkers::Req},
    {"a8-4-10", checkers::Req},
    {"a8-4-11", checkers::Req},
    {"a8-4-12", checkers::Req},
    {"a8-4-13", checkers::Req},
    {"a8-4-14", checkers::Req},
    {"a8-5-0", checkers::Req},
    {"a8-5-1", checkers::Req},
    {"m8-5-2", checkers::Req},
    {"a8-5-2", checkers::Req},
    {"a8-5-3", checkers::Req},
    {"a8-5-4", checkers::Adv},
    {"m9-3-1", checkers::Req},
    {"a9-3-1", checkers::Req},
    {"m9-3-3", checkers::Req},
    {"a9-5-1", checkers::Req},
    {"a9-6-1", checkers::Req},
    {"m9-6-4", checkers::Req},
    {"a10-1-1", checkers::Req},
    {"m10-1-1", checkers::Adv},
    {"m10-1-2", checkers::Req},
    {"m10-1-3", checkers::Req},
    {"m10-2-1", checkers::Adv},
    {"a10-2-1", checkers::Req},
    {"a10-3-1", checkers::Req},
    {"a10-3-2", checkers::Req},
    {"a10-3-3", checkers::Req},
    {"a10-3-5", checkers::Req},
    {"m10-3-3", checkers::Req},
    {"a10-4-1", checkers::Req},
    {"m11-0-1", checkers::Req},
    {"a11-0-1", checkers::Adv},
    {"a11-0-2", checkers::Req},
    {"a11-3-1", checkers::Req},
    {"a12-0-1", checkers::Req},
    {"a12-0-2", checkers::Req},
    {"a12-1-1", checkers::Req},
    {"m12-1-1", checkers::Req},
    {"a12-1-2", checkers::Req},
    {"a12-1-3", checkers::Req},
    {"a12-1-4", checkers::Req},
    {"a12-1-5", checkers::Req},
    {"a12-1-6", checkers::Req},
    {"a12-4-1", checkers::Req},
    {"a12-4-2", checkers::Adv},
    {"a12-6-1", checkers::Req},
    {"a12-7-1", checkers::Req},
    {"a12-8-1", checkers::Req},
    {"a12-8-2", checkers::Adv},
    {"a12-8-3", checkers::Req},
    {"a12-8-4", checkers::Req},
    {"a12-8-5", checkers::Req},
    {"a12-8-6", checkers::Req},
    {"a12-8-7", checkers::Adv},
    {"a13-1-2", checkers::Req},
    {"a13-1-3", checkers::Req},
    {"a13-2-1", checkers::Req},
    {"a13-2-2", checkers::Req},
    {"a13-2-3", checkers::Req},
    {"a13-3-1", checkers::Req},
    {"a13-5-1", checkers::Req},
    {"a13-5-2", checkers::Req},
    {"a13-5-3", checkers::Adv},
    {"a13-5-4", checkers::Req},
    {"a13-5-5", checkers::Req},
    {"a13-6-1", checkers::Req},
    {"a14-1-1", checkers::Adv},
    {"a14-5-1", checkers::Req},
    {"a14-5-2", checkers::Req},
    {"a14-5-3", checkers::Req},
    {"m14-5-3", checkers::Req},
    {"m14-6-1", checkers::Req},
    {"a14-7-1", checkers::Req},
    {"a14-7-2", checkers::Req},
    {"a14-8-2", checkers::Req},
    {"a15-0-2", checkers::Req},
    {"a15-1-2", checkers::Req},
    {"m15-0-3", checkers::Req},
    {"m15-1-1", checkers::Req},
    {"m15-1-2", checkers::Req},
    {"m15-1-3", checkers::Req},
    {"a15-1-3", checkers::Adv},
    {"a15-1-4", checkers::Req},
    {"a15-2-1", checkers::Req},
    {"a15-2-2", checkers::Req},
    {"m15-3-1", checkers::Req},
    {"a15-3-2", checkers::Req},
    {"a15-3-3", checkers::Req},
    {"m15-3-3", checkers::Req},
    {"m15-3-4", checkers::Req},
    {"a15-3-5", checkers::Req},
    {"m15-3-6", checkers::Req},
    {"m15-3-7", checkers::Req},
    {"a15-4-1", checkers::Req},
    {"a15-4-2", checkers::Req},
    {"a15-4-3", checkers::Req},
    {"a15-4-4", checkers::Req},
    {"a15-4-5", checkers::Req},
    {"a15-5-1", checkers::Req},
    {"a15-5-2", checkers::Req},
    {"a15-5-3", checkers::Req},
    {"a16-0-1", checkers::Req},
    {"m16-0-1", checkers::Req},
    {"m16-0-2", checkers::Req},
    {"m16-0-5", checkers::Req},
    {"m16-0-6", checkers::Req},
    {"m16-0-7", checkers::Req},
    {"m16-0-8", checkers::Req},
    {"m16-1-1", checkers::Req},
    {"m16-1-2", checkers::Req},
    {"m16-2-3", checkers::Req},
    {"a16-2-1", checkers::Req},
    {"a16-2-2", checkers::Req},
    {"a16-2-3", checkers::Req},
    {"m16-3-1", checkers::Req},
    {"m16-3-2", checkers::Adv},
    {"a16-6-1", checkers::Req},
    {"a16-7-1", checkers::Req},
    {"a17-0-1", checkers::Req},
    {"m17-0-2", checkers::Req},
    {"m17-0-3", checkers::Req},
    {"m17-0-5", checkers::Req},
    {"a17-1-1", checkers::Req},
    {"a17-6-1", checkers::Req},
    {"a18-0-1", checkers::Req},
    {"a18-0-2", checkers::Req},
    {"m18-0-3", checkers::Req},
    {"m18-0-4", checkers::Req},
    {"m18-0-5", checkers::Req},
    {"a18-0-3", checkers::Req},
    {"a18-1-1", checkers::Req},
    {"a18-1-2", checkers::Req},
    {"a18-1-3", checkers::Req},
    {"a18-1-4", checkers::Req},
    {"a18-1-6", checkers::Req},
    {"m18-2-1", checkers::Req},
    {"a18-5-1", checkers::Req},
    {"a18-5-2", checkers::Req},
    {"a18-5-3", checkers::Req},
    {"a18-5-4", checkers::Req},
    {"a18-5-5", checkers::Req},
    {"a18-5-6", checkers::Req},
    {"a18-5-7", checkers::Req},
    {"a18-5-8", checkers::Req},
    {"a18-5-9", checkers::Req},
    {"a18-5-10", checkers::Req},
    {"a18-5-11", checkers::Req},
    {"m18-7-1", checkers::Req},
    {"a18-9-1", checkers::Req},
    {"a18-9-2", checkers::Req},
    {"a18-9-3", checkers::Req},
    {"a18-9-4", checkers::Req},
    {"m19-3-1", checkers::Req},
    {"a20-8-1", checkers::Req},
    {"a20-8-2", checkers::Req},
    {"a20-8-3", checkers::Req},
    {"a20-8-4", checkers::Req},
    {"a20-8-5", checkers::Req},
    {"a20-8-6", checkers::Req},
    {"a20-8-7", checkers::Req},
    {"a21-8-1", checkers::Req},
    {"a23-0-1", checkers::Req},
    {"a23-0-2", checkers::Req},
    {"a25-1-1", checkers::Req},
    {"a25-4-1", checkers::Req},
    {"a26-5-1", checkers::Req},
    {"a26-5-2", checkers::Req},
    {"m27-0-1", checkers::Req},
    {"a27-0-1", checkers::Req},
    {"a27-0-4", checkers::Req},
    {"a27-0-2", checkers::Adv},
    {"a27-0-3", checkers::Req},
};
""")


def getCertCInfo(main_url:str):
    """Fetches CERT C rules information."""
    # Fetching the CERT C rules page
    r = requests.get(main_url, timeout=30)
    mainpage = r.text
    for line in mainpage.split('\n'):
        res = re.search(r'<a href="(/confluence/[^"]+)">(Rule|Rec.) \d\d[.] [A-Za-z ]+ [(][A-Z][A-Z][A-Z][)]', line)
        if res is None:
            continue
        r = requests.get('https://wiki.sei.cmu.edu' + res.group(1), timeout=30)
        text = r.text.replace('\n', '').replace('<tr>', '\n').replace('</tr>', '\n')
        rules = []
        for line in text.split('\n'):
            if not line.startswith('<td'):
                continue
            #print(line)
            res = re.match(r'[^>]+>([A-Z][A-Z][A-Z][0-9][0-9]-CP*)<.*>(L[1-3])<.+', line)
            if res:
                if res.group(1) == 'EXP40-C' and 'EXP39-C' not in rules:
                    print('    {"EXP39-C", "L2"},')
                print('    {"%s", "%s"},' % (res.group(1), res.group(2)))
                rules.append(res.group(1))
        if 'EXP45-C' in rules:
            if 'EXP46-C' not in rules:
                print('    {"EXP46-C", "L2"},')
            if 'EXP47-C' not in rules:
                print('    {"EXP47-C", "L2"},')


print('std::vector<checkers::Info> checkers::certCInfo{')
getCertCInfo('https://wiki.sei.cmu.edu/confluence/display/c/2+Rules')
print('    // Recommendations')
getCertCInfo('https://wiki.sei.cmu.edu/confluence/display/c/3+Recommendations')
print('};')
print('')
print('std::vector<checkers::Info> checkers::certCppInfo{')
getCertCInfo('https://wiki.sei.cmu.edu/confluence/pages/viewpage.action?pageId=88046682')
print('};')
print('')


