#include <CGAL/Exact_predicates_inexact_constructions_kernel.h>

#include <CGAL/Mesh_triangulation_3.h>
#include <CGAL/Mesh_complex_3_in_triangulation_3.h>
#include <CGAL/Mesh_criteria_3.h>

#include <CGAL/Polyhedral_mesh_domain_with_features_3.h>
#include <CGAL/make_mesh_3.h>

// Domain
typedef CGAL::Exact_predicates_inexact_constructions_kernel K;
typedef CGAL::Mesh_polyhedron_3<K>::type Polyhedron;
typedef CGAL::Polyhedral_mesh_domain_with_features_3<K> Mesh_domain;


#ifdef CGAL_CONCURRENT_MESH_3
typedef CGAL::Parallel_tag Concurrency_tag;
#else
typedef CGAL::Sequential_tag Concurrency_tag;
#endif

// Triangulation
typedef CGAL::Mesh_triangulation_3<Mesh_domain,CGAL::Default,Concurrency_tag>::type Tr;

typedef CGAL::Mesh_complex_3_in_triangulation_3<
    Tr,Mesh_domain::Corner_index,Mesh_domain::Curve_index> C3t3;

// Criteria
typedef CGAL::Mesh_criteria_3<Tr> Mesh_criteria;

namespace params = CGAL::parameters;

int main(int argc, char*argv[])
{
    const std::string fname = (argc>1)?argv[1]:CGAL::data_file_path("meshes/u_arch.off");
    std::ifstream input(fname);
    Polyhedron polyhedron;
    input >> polyhedron;
    if(input.fail()){
        std::cerr << "Error: Cannot read file " <<  fname << std::endl;
        return EXIT_FAILURE;
    }

    if (!CGAL::is_triangle_mesh(polyhedron)){
        std::cerr << "Input geometry is not triangulated." << std::endl;
        return EXIT_FAILURE;
    }

    // Create domain
    Mesh_domain domain(polyhedron);

    // Get sharp features
    domain.detect_features();

    // Mesh criteria
    Mesh_criteria criteria(params::edge_size(4).edge_distance(0.01).
                           facet_angle(25).facet_size(4).facet_distance(0.01).
                           cell_radius_edge_ratio(3).cell_size(4));

    // Mesh generation
    C3t3 c3t3 = CGAL::make_mesh_3<C3t3>(domain, criteria);

    // Output
    //CGAL::dump_c3t3(c3t3, "out");

    return EXIT_SUCCESS;
}
