﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/deadline/model/AcceleratorSelection.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace deadline
{
namespace Model
{

AcceleratorSelection::AcceleratorSelection() : 
    m_name(AcceleratorName::NOT_SET),
    m_nameHasBeenSet(false),
    m_runtimeHasBeenSet(false)
{
}

AcceleratorSelection::AcceleratorSelection(JsonView jsonValue)
  : AcceleratorSelection()
{
  *this = jsonValue;
}

AcceleratorSelection& AcceleratorSelection::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("name"))
  {
    m_name = AcceleratorNameMapper::GetAcceleratorNameForName(jsonValue.GetString("name"));

    m_nameHasBeenSet = true;
  }

  if(jsonValue.ValueExists("runtime"))
  {
    m_runtime = jsonValue.GetString("runtime");

    m_runtimeHasBeenSet = true;
  }

  return *this;
}

JsonValue AcceleratorSelection::Jsonize() const
{
  JsonValue payload;

  if(m_nameHasBeenSet)
  {
   payload.WithString("name", AcceleratorNameMapper::GetNameForAcceleratorName(m_name));
  }

  if(m_runtimeHasBeenSet)
  {
   payload.WithString("runtime", m_runtime);

  }

  return payload;
}

} // namespace Model
} // namespace deadline
} // namespace Aws
