﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/datazone/model/SortFieldProject.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace DataZone
  {
    namespace Model
    {
      namespace SortFieldProjectMapper
      {

        static const int NAME_HASH = HashingUtils::HashString("NAME");


        SortFieldProject GetSortFieldProjectForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == NAME_HASH)
          {
            return SortFieldProject::NAME;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<SortFieldProject>(hashCode);
          }

          return SortFieldProject::NOT_SET;
        }

        Aws::String GetNameForSortFieldProject(SortFieldProject enumValue)
        {
          switch(enumValue)
          {
          case SortFieldProject::NOT_SET:
            return {};
          case SortFieldProject::NAME:
            return "NAME";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace SortFieldProjectMapper
    } // namespace Model
  } // namespace DataZone
} // namespace Aws
