﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/datasync/model/CreateTaskRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::DataSync::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

CreateTaskRequest::CreateTaskRequest() : 
    m_sourceLocationArnHasBeenSet(false),
    m_destinationLocationArnHasBeenSet(false),
    m_cloudWatchLogGroupArnHasBeenSet(false),
    m_nameHasBeenSet(false),
    m_optionsHasBeenSet(false),
    m_excludesHasBeenSet(false),
    m_scheduleHasBeenSet(false),
    m_tagsHasBeenSet(false),
    m_includesHasBeenSet(false),
    m_manifestConfigHasBeenSet(false),
    m_taskReportConfigHasBeenSet(false),
    m_taskMode(TaskMode::NOT_SET),
    m_taskModeHasBeenSet(false)
{
}

Aws::String CreateTaskRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_sourceLocationArnHasBeenSet)
  {
   payload.WithString("SourceLocationArn", m_sourceLocationArn);

  }

  if(m_destinationLocationArnHasBeenSet)
  {
   payload.WithString("DestinationLocationArn", m_destinationLocationArn);

  }

  if(m_cloudWatchLogGroupArnHasBeenSet)
  {
   payload.WithString("CloudWatchLogGroupArn", m_cloudWatchLogGroupArn);

  }

  if(m_nameHasBeenSet)
  {
   payload.WithString("Name", m_name);

  }

  if(m_optionsHasBeenSet)
  {
   payload.WithObject("Options", m_options.Jsonize());

  }

  if(m_excludesHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> excludesJsonList(m_excludes.size());
   for(unsigned excludesIndex = 0; excludesIndex < excludesJsonList.GetLength(); ++excludesIndex)
   {
     excludesJsonList[excludesIndex].AsObject(m_excludes[excludesIndex].Jsonize());
   }
   payload.WithArray("Excludes", std::move(excludesJsonList));

  }

  if(m_scheduleHasBeenSet)
  {
   payload.WithObject("Schedule", m_schedule.Jsonize());

  }

  if(m_tagsHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> tagsJsonList(m_tags.size());
   for(unsigned tagsIndex = 0; tagsIndex < tagsJsonList.GetLength(); ++tagsIndex)
   {
     tagsJsonList[tagsIndex].AsObject(m_tags[tagsIndex].Jsonize());
   }
   payload.WithArray("Tags", std::move(tagsJsonList));

  }

  if(m_includesHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> includesJsonList(m_includes.size());
   for(unsigned includesIndex = 0; includesIndex < includesJsonList.GetLength(); ++includesIndex)
   {
     includesJsonList[includesIndex].AsObject(m_includes[includesIndex].Jsonize());
   }
   payload.WithArray("Includes", std::move(includesJsonList));

  }

  if(m_manifestConfigHasBeenSet)
  {
   payload.WithObject("ManifestConfig", m_manifestConfig.Jsonize());

  }

  if(m_taskReportConfigHasBeenSet)
  {
   payload.WithObject("TaskReportConfig", m_taskReportConfig.Jsonize());

  }

  if(m_taskModeHasBeenSet)
  {
   payload.WithString("TaskMode", TaskModeMapper::GetNameForTaskMode(m_taskMode));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateTaskRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "FmrsService.CreateTask"));
  return headers;

}




