﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connectcampaignsv2/model/FailedProfileOutboundRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace ConnectCampaignsV2
{
namespace Model
{

FailedProfileOutboundRequest::FailedProfileOutboundRequest() : 
    m_clientTokenHasBeenSet(false),
    m_idHasBeenSet(false),
    m_failureCode(ProfileOutboundRequestFailureCode::NOT_SET),
    m_failureCodeHasBeenSet(false)
{
}

FailedProfileOutboundRequest::FailedProfileOutboundRequest(JsonView jsonValue)
  : FailedProfileOutboundRequest()
{
  *this = jsonValue;
}

FailedProfileOutboundRequest& FailedProfileOutboundRequest::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("clientToken"))
  {
    m_clientToken = jsonValue.GetString("clientToken");

    m_clientTokenHasBeenSet = true;
  }

  if(jsonValue.ValueExists("id"))
  {
    m_id = jsonValue.GetString("id");

    m_idHasBeenSet = true;
  }

  if(jsonValue.ValueExists("failureCode"))
  {
    m_failureCode = ProfileOutboundRequestFailureCodeMapper::GetProfileOutboundRequestFailureCodeForName(jsonValue.GetString("failureCode"));

    m_failureCodeHasBeenSet = true;
  }

  return *this;
}

JsonValue FailedProfileOutboundRequest::Jsonize() const
{
  JsonValue payload;

  if(m_clientTokenHasBeenSet)
  {
   payload.WithString("clientToken", m_clientToken);

  }

  if(m_idHasBeenSet)
  {
   payload.WithString("id", m_id);

  }

  if(m_failureCodeHasBeenSet)
  {
   payload.WithString("failureCode", ProfileOutboundRequestFailureCodeMapper::GetNameForProfileOutboundRequestFailureCode(m_failureCode));
  }

  return payload;
}

} // namespace Model
} // namespace ConnectCampaignsV2
} // namespace Aws
