﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudtrail/CloudTrail_EXPORTS.h>
#include <aws/cloudtrail/CloudTrailRequest.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/DateTime.h>
#include <aws/cloudtrail/model/EventCategory.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/cloudtrail/model/LookupAttribute.h>
#include <utility>

namespace Aws
{
namespace CloudTrail
{
namespace Model
{

  /**
   * <p>Contains a request for LookupEvents.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEventsRequest">AWS
   * API Reference</a></p>
   */
  class LookupEventsRequest : public CloudTrailRequest
  {
  public:
    AWS_CLOUDTRAIL_API LookupEventsRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "LookupEvents"; }

    AWS_CLOUDTRAIL_API Aws::String SerializePayload() const override;

    AWS_CLOUDTRAIL_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    ///@{
    /**
     * <p>Contains a list of lookup attributes. Currently the list can contain only one
     * item.</p>
     */
    inline const Aws::Vector<LookupAttribute>& GetLookupAttributes() const{ return m_lookupAttributes; }
    inline bool LookupAttributesHasBeenSet() const { return m_lookupAttributesHasBeenSet; }
    inline void SetLookupAttributes(const Aws::Vector<LookupAttribute>& value) { m_lookupAttributesHasBeenSet = true; m_lookupAttributes = value; }
    inline void SetLookupAttributes(Aws::Vector<LookupAttribute>&& value) { m_lookupAttributesHasBeenSet = true; m_lookupAttributes = std::move(value); }
    inline LookupEventsRequest& WithLookupAttributes(const Aws::Vector<LookupAttribute>& value) { SetLookupAttributes(value); return *this;}
    inline LookupEventsRequest& WithLookupAttributes(Aws::Vector<LookupAttribute>&& value) { SetLookupAttributes(std::move(value)); return *this;}
    inline LookupEventsRequest& AddLookupAttributes(const LookupAttribute& value) { m_lookupAttributesHasBeenSet = true; m_lookupAttributes.push_back(value); return *this; }
    inline LookupEventsRequest& AddLookupAttributes(LookupAttribute&& value) { m_lookupAttributesHasBeenSet = true; m_lookupAttributes.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>Specifies that only events that occur after or at the specified time are
     * returned. If the specified start time is after the specified end time, an error
     * is returned.</p>
     */
    inline const Aws::Utils::DateTime& GetStartTime() const{ return m_startTime; }
    inline bool StartTimeHasBeenSet() const { return m_startTimeHasBeenSet; }
    inline void SetStartTime(const Aws::Utils::DateTime& value) { m_startTimeHasBeenSet = true; m_startTime = value; }
    inline void SetStartTime(Aws::Utils::DateTime&& value) { m_startTimeHasBeenSet = true; m_startTime = std::move(value); }
    inline LookupEventsRequest& WithStartTime(const Aws::Utils::DateTime& value) { SetStartTime(value); return *this;}
    inline LookupEventsRequest& WithStartTime(Aws::Utils::DateTime&& value) { SetStartTime(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Specifies that only events that occur before or at the specified time are
     * returned. If the specified end time is before the specified start time, an error
     * is returned.</p>
     */
    inline const Aws::Utils::DateTime& GetEndTime() const{ return m_endTime; }
    inline bool EndTimeHasBeenSet() const { return m_endTimeHasBeenSet; }
    inline void SetEndTime(const Aws::Utils::DateTime& value) { m_endTimeHasBeenSet = true; m_endTime = value; }
    inline void SetEndTime(Aws::Utils::DateTime&& value) { m_endTimeHasBeenSet = true; m_endTime = std::move(value); }
    inline LookupEventsRequest& WithEndTime(const Aws::Utils::DateTime& value) { SetEndTime(value); return *this;}
    inline LookupEventsRequest& WithEndTime(Aws::Utils::DateTime&& value) { SetEndTime(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Specifies the event category. If you do not specify an event category, events
     * of the category are not returned in the response. For example, if you do not
     * specify <code>insight</code> as the value of <code>EventCategory</code>, no
     * Insights events are returned.</p>
     */
    inline const EventCategory& GetEventCategory() const{ return m_eventCategory; }
    inline bool EventCategoryHasBeenSet() const { return m_eventCategoryHasBeenSet; }
    inline void SetEventCategory(const EventCategory& value) { m_eventCategoryHasBeenSet = true; m_eventCategory = value; }
    inline void SetEventCategory(EventCategory&& value) { m_eventCategoryHasBeenSet = true; m_eventCategory = std::move(value); }
    inline LookupEventsRequest& WithEventCategory(const EventCategory& value) { SetEventCategory(value); return *this;}
    inline LookupEventsRequest& WithEventCategory(EventCategory&& value) { SetEventCategory(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The number of events to return. Possible values are 1 through 50. The default
     * is 50.</p>
     */
    inline int GetMaxResults() const{ return m_maxResults; }
    inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
    inline void SetMaxResults(int value) { m_maxResultsHasBeenSet = true; m_maxResults = value; }
    inline LookupEventsRequest& WithMaxResults(int value) { SetMaxResults(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The token to use to get the next page of results after a previous API call.
     * This token must be passed in with the same parameters that were specified in the
     * original call. For example, if the original call specified an AttributeKey of
     * 'Username' with a value of 'root', the call with NextToken should include those
     * same parameters.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
    inline void SetNextToken(const Aws::String& value) { m_nextTokenHasBeenSet = true; m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextTokenHasBeenSet = true; m_nextToken.assign(value); }
    inline LookupEventsRequest& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline LookupEventsRequest& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline LookupEventsRequest& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}
  private:

    Aws::Vector<LookupAttribute> m_lookupAttributes;
    bool m_lookupAttributesHasBeenSet = false;

    Aws::Utils::DateTime m_startTime;
    bool m_startTimeHasBeenSet = false;

    Aws::Utils::DateTime m_endTime;
    bool m_endTimeHasBeenSet = false;

    EventCategory m_eventCategory;
    bool m_eventCategoryHasBeenSet = false;

    int m_maxResults;
    bool m_maxResultsHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;
  };

} // namespace Model
} // namespace CloudTrail
} // namespace Aws
