﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime/Chime_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/chime/model/MemberError.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Chime
{
namespace Model
{
  class BatchCreateRoomMembershipResult
  {
  public:
    AWS_CHIME_API BatchCreateRoomMembershipResult();
    AWS_CHIME_API BatchCreateRoomMembershipResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_CHIME_API BatchCreateRoomMembershipResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>If the action fails for one or more of the member IDs in the request, a list
     * of the member IDs is returned, along with error codes and error messages.</p>
     */
    inline const Aws::Vector<MemberError>& GetErrors() const{ return m_errors; }
    inline void SetErrors(const Aws::Vector<MemberError>& value) { m_errors = value; }
    inline void SetErrors(Aws::Vector<MemberError>&& value) { m_errors = std::move(value); }
    inline BatchCreateRoomMembershipResult& WithErrors(const Aws::Vector<MemberError>& value) { SetErrors(value); return *this;}
    inline BatchCreateRoomMembershipResult& WithErrors(Aws::Vector<MemberError>&& value) { SetErrors(std::move(value)); return *this;}
    inline BatchCreateRoomMembershipResult& AddErrors(const MemberError& value) { m_errors.push_back(value); return *this; }
    inline BatchCreateRoomMembershipResult& AddErrors(MemberError&& value) { m_errors.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline BatchCreateRoomMembershipResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline BatchCreateRoomMembershipResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline BatchCreateRoomMembershipResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<MemberError> m_errors;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Chime
} // namespace Aws
