﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock/model/InferenceProfileModel.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace Bedrock
{
namespace Model
{

InferenceProfileModel::InferenceProfileModel() : 
    m_modelArnHasBeenSet(false)
{
}

InferenceProfileModel::InferenceProfileModel(JsonView jsonValue)
  : InferenceProfileModel()
{
  *this = jsonValue;
}

InferenceProfileModel& InferenceProfileModel::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("modelArn"))
  {
    m_modelArn = jsonValue.GetString("modelArn");

    m_modelArnHasBeenSet = true;
  }

  return *this;
}

JsonValue InferenceProfileModel::Jsonize() const
{
  JsonValue payload;

  if(m_modelArnHasBeenSet)
  {
   payload.WithString("modelArn", m_modelArn);

  }

  return payload;
}

} // namespace Model
} // namespace Bedrock
} // namespace Aws
