﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent-runtime/BedrockAgentRuntime_EXPORTS.h>
#include <aws/bedrock-agent-runtime/model/GuadrailAction.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace BedrockAgentRuntime
{
namespace Model
{

  /**
   * <p>A guardrail event.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GuardrailEvent">AWS
   * API Reference</a></p>
   */
  class GuardrailEvent
  {
  public:
    AWS_BEDROCKAGENTRUNTIME_API GuardrailEvent();
    AWS_BEDROCKAGENTRUNTIME_API GuardrailEvent(Aws::Utils::Json::JsonView jsonValue);
    AWS_BEDROCKAGENTRUNTIME_API GuardrailEvent& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_BEDROCKAGENTRUNTIME_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The guardrail action.</p>
     */
    inline const GuadrailAction& GetAction() const{ return m_action; }
    inline bool ActionHasBeenSet() const { return m_actionHasBeenSet; }
    inline void SetAction(const GuadrailAction& value) { m_actionHasBeenSet = true; m_action = value; }
    inline void SetAction(GuadrailAction&& value) { m_actionHasBeenSet = true; m_action = std::move(value); }
    inline GuardrailEvent& WithAction(const GuadrailAction& value) { SetAction(value); return *this;}
    inline GuardrailEvent& WithAction(GuadrailAction&& value) { SetAction(std::move(value)); return *this;}
    ///@}
  private:

    GuadrailAction m_action;
    bool m_actionHasBeenSet = false;
  };

} // namespace Model
} // namespace BedrockAgentRuntime
} // namespace Aws
