﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/athena/model/NotebookMetadata.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Athena
{
namespace Model
{
  class ListNotebookMetadataResult
  {
  public:
    AWS_ATHENA_API ListNotebookMetadataResult();
    AWS_ATHENA_API ListNotebookMetadataResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_ATHENA_API ListNotebookMetadataResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the <code>NextToken</code> from the response object of the previous page
     * call.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListNotebookMetadataResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListNotebookMetadataResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListNotebookMetadataResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The list of notebook metadata for the specified workgroup.</p>
     */
    inline const Aws::Vector<NotebookMetadata>& GetNotebookMetadataList() const{ return m_notebookMetadataList; }
    inline void SetNotebookMetadataList(const Aws::Vector<NotebookMetadata>& value) { m_notebookMetadataList = value; }
    inline void SetNotebookMetadataList(Aws::Vector<NotebookMetadata>&& value) { m_notebookMetadataList = std::move(value); }
    inline ListNotebookMetadataResult& WithNotebookMetadataList(const Aws::Vector<NotebookMetadata>& value) { SetNotebookMetadataList(value); return *this;}
    inline ListNotebookMetadataResult& WithNotebookMetadataList(Aws::Vector<NotebookMetadata>&& value) { SetNotebookMetadataList(std::move(value)); return *this;}
    inline ListNotebookMetadataResult& AddNotebookMetadataList(const NotebookMetadata& value) { m_notebookMetadataList.push_back(value); return *this; }
    inline ListNotebookMetadataResult& AddNotebookMetadataList(NotebookMetadata&& value) { m_notebookMetadataList.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListNotebookMetadataResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListNotebookMetadataResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListNotebookMetadataResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_nextToken;

    Aws::Vector<NotebookMetadata> m_notebookMetadataList;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Athena
} // namespace Aws
