﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/athena/model/ApplicationDPUSizes.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Athena
{
namespace Model
{
  class ListApplicationDPUSizesResult
  {
  public:
    AWS_ATHENA_API ListApplicationDPUSizesResult();
    AWS_ATHENA_API ListApplicationDPUSizesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_ATHENA_API ListApplicationDPUSizesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list of the supported DPU sizes that the application runtime supports.</p>
     */
    inline const Aws::Vector<ApplicationDPUSizes>& GetApplicationDPUSizes() const{ return m_applicationDPUSizes; }
    inline void SetApplicationDPUSizes(const Aws::Vector<ApplicationDPUSizes>& value) { m_applicationDPUSizes = value; }
    inline void SetApplicationDPUSizes(Aws::Vector<ApplicationDPUSizes>&& value) { m_applicationDPUSizes = std::move(value); }
    inline ListApplicationDPUSizesResult& WithApplicationDPUSizes(const Aws::Vector<ApplicationDPUSizes>& value) { SetApplicationDPUSizes(value); return *this;}
    inline ListApplicationDPUSizesResult& WithApplicationDPUSizes(Aws::Vector<ApplicationDPUSizes>&& value) { SetApplicationDPUSizes(std::move(value)); return *this;}
    inline ListApplicationDPUSizesResult& AddApplicationDPUSizes(const ApplicationDPUSizes& value) { m_applicationDPUSizes.push_back(value); return *this; }
    inline ListApplicationDPUSizesResult& AddApplicationDPUSizes(ApplicationDPUSizes&& value) { m_applicationDPUSizes.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the <code>NextToken</code> from the response object of the previous page
     * call.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListApplicationDPUSizesResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListApplicationDPUSizesResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListApplicationDPUSizesResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListApplicationDPUSizesResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListApplicationDPUSizesResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListApplicationDPUSizesResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<ApplicationDPUSizes> m_applicationDPUSizes;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Athena
} // namespace Aws
