﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ds/model/DisableDirectoryDataAccessRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::DirectoryService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

DisableDirectoryDataAccessRequest::DisableDirectoryDataAccessRequest() : 
    m_directoryIdHasBeenSet(false)
{
}

Aws::String DisableDirectoryDataAccessRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_directoryIdHasBeenSet)
  {
   payload.WithString("DirectoryId", m_directoryId);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DisableDirectoryDataAccessRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "DirectoryService_20150416.DisableDirectoryDataAccess"));
  return headers;

}




