﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/deadline/Deadline_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/deadline/model/WorkerSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace deadline
{
namespace Model
{
  class ListWorkersResult
  {
  public:
    AWS_DEADLINE_API ListWorkersResult();
    AWS_DEADLINE_API ListWorkersResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_DEADLINE_API ListWorkersResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>If Deadline Cloud returns <code>nextToken</code>, then there are more results
     * available. The value of <code>nextToken</code> is a unique pagination token for
     * each page. To retrieve the next page, call the operation again using the
     * returned token. Keep all other arguments unchanged. If no results remain, then
     * <code>nextToken</code> is set to <code>null</code>. Each pagination token
     * expires after 24 hours. If you provide a token that isn't valid, then you
     * receive an HTTP 400 <code>ValidationException</code> error.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListWorkersResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListWorkersResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListWorkersResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The workers on the list.</p>
     */
    inline const Aws::Vector<WorkerSummary>& GetWorkers() const{ return m_workers; }
    inline void SetWorkers(const Aws::Vector<WorkerSummary>& value) { m_workers = value; }
    inline void SetWorkers(Aws::Vector<WorkerSummary>&& value) { m_workers = std::move(value); }
    inline ListWorkersResult& WithWorkers(const Aws::Vector<WorkerSummary>& value) { SetWorkers(value); return *this;}
    inline ListWorkersResult& WithWorkers(Aws::Vector<WorkerSummary>&& value) { SetWorkers(std::move(value)); return *this;}
    inline ListWorkersResult& AddWorkers(const WorkerSummary& value) { m_workers.push_back(value); return *this; }
    inline ListWorkersResult& AddWorkers(WorkerSummary&& value) { m_workers.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListWorkersResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListWorkersResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListWorkersResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_nextToken;

    Aws::Vector<WorkerSummary> m_workers;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace deadline
} // namespace Aws
