﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/datazone/model/ListMetadataGenerationRunsRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::DataZone::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

ListMetadataGenerationRunsRequest::ListMetadataGenerationRunsRequest() : 
    m_domainIdentifierHasBeenSet(false),
    m_maxResults(0),
    m_maxResultsHasBeenSet(false),
    m_nextTokenHasBeenSet(false),
    m_status(MetadataGenerationRunStatus::NOT_SET),
    m_statusHasBeenSet(false),
    m_type(MetadataGenerationRunType::NOT_SET),
    m_typeHasBeenSet(false)
{
}

Aws::String ListMetadataGenerationRunsRequest::SerializePayload() const
{
  return {};
}

void ListMetadataGenerationRunsRequest::AddQueryStringParameters(URI& uri) const
{
    Aws::StringStream ss;
    if(m_maxResultsHasBeenSet)
    {
      ss << m_maxResults;
      uri.AddQueryStringParameter("maxResults", ss.str());
      ss.str("");
    }

    if(m_nextTokenHasBeenSet)
    {
      ss << m_nextToken;
      uri.AddQueryStringParameter("nextToken", ss.str());
      ss.str("");
    }

    if(m_statusHasBeenSet)
    {
      ss << MetadataGenerationRunStatusMapper::GetNameForMetadataGenerationRunStatus(m_status);
      uri.AddQueryStringParameter("status", ss.str());
      ss.str("");
    }

    if(m_typeHasBeenSet)
    {
      ss << MetadataGenerationRunTypeMapper::GetNameForMetadataGenerationRunType(m_type);
      uri.AddQueryStringParameter("type", ss.str());
      ss.str("");
    }

}



