﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codepipeline/CodePipeline_EXPORTS.h>
#include <aws/codepipeline/model/ActionTypeId.h>
#include <aws/codepipeline/model/ActionConfiguration.h>
#include <aws/codepipeline/model/PipelineContext.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/codepipeline/model/AWSSessionCredentials.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/codepipeline/model/EncryptionKey.h>
#include <aws/codepipeline/model/Artifact.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace CodePipeline
{
namespace Model
{

  /**
   * <p>Represents other information about a job required for a job worker to
   * complete the job.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/JobData">AWS
   * API Reference</a></p>
   */
  class JobData
  {
  public:
    AWS_CODEPIPELINE_API JobData();
    AWS_CODEPIPELINE_API JobData(Aws::Utils::Json::JsonView jsonValue);
    AWS_CODEPIPELINE_API JobData& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_CODEPIPELINE_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>Represents information about an action type.</p>
     */
    inline const ActionTypeId& GetActionTypeId() const{ return m_actionTypeId; }
    inline bool ActionTypeIdHasBeenSet() const { return m_actionTypeIdHasBeenSet; }
    inline void SetActionTypeId(const ActionTypeId& value) { m_actionTypeIdHasBeenSet = true; m_actionTypeId = value; }
    inline void SetActionTypeId(ActionTypeId&& value) { m_actionTypeIdHasBeenSet = true; m_actionTypeId = std::move(value); }
    inline JobData& WithActionTypeId(const ActionTypeId& value) { SetActionTypeId(value); return *this;}
    inline JobData& WithActionTypeId(ActionTypeId&& value) { SetActionTypeId(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Represents information about an action configuration.</p>
     */
    inline const ActionConfiguration& GetActionConfiguration() const{ return m_actionConfiguration; }
    inline bool ActionConfigurationHasBeenSet() const { return m_actionConfigurationHasBeenSet; }
    inline void SetActionConfiguration(const ActionConfiguration& value) { m_actionConfigurationHasBeenSet = true; m_actionConfiguration = value; }
    inline void SetActionConfiguration(ActionConfiguration&& value) { m_actionConfigurationHasBeenSet = true; m_actionConfiguration = std::move(value); }
    inline JobData& WithActionConfiguration(const ActionConfiguration& value) { SetActionConfiguration(value); return *this;}
    inline JobData& WithActionConfiguration(ActionConfiguration&& value) { SetActionConfiguration(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Represents information about a pipeline to a job worker.</p> 
     * <p>Includes <code>pipelineArn</code> and <code>pipelineExecutionId</code> for
     * custom jobs.</p> 
     */
    inline const PipelineContext& GetPipelineContext() const{ return m_pipelineContext; }
    inline bool PipelineContextHasBeenSet() const { return m_pipelineContextHasBeenSet; }
    inline void SetPipelineContext(const PipelineContext& value) { m_pipelineContextHasBeenSet = true; m_pipelineContext = value; }
    inline void SetPipelineContext(PipelineContext&& value) { m_pipelineContextHasBeenSet = true; m_pipelineContext = std::move(value); }
    inline JobData& WithPipelineContext(const PipelineContext& value) { SetPipelineContext(value); return *this;}
    inline JobData& WithPipelineContext(PipelineContext&& value) { SetPipelineContext(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The artifact supplied to the job.</p>
     */
    inline const Aws::Vector<Artifact>& GetInputArtifacts() const{ return m_inputArtifacts; }
    inline bool InputArtifactsHasBeenSet() const { return m_inputArtifactsHasBeenSet; }
    inline void SetInputArtifacts(const Aws::Vector<Artifact>& value) { m_inputArtifactsHasBeenSet = true; m_inputArtifacts = value; }
    inline void SetInputArtifacts(Aws::Vector<Artifact>&& value) { m_inputArtifactsHasBeenSet = true; m_inputArtifacts = std::move(value); }
    inline JobData& WithInputArtifacts(const Aws::Vector<Artifact>& value) { SetInputArtifacts(value); return *this;}
    inline JobData& WithInputArtifacts(Aws::Vector<Artifact>&& value) { SetInputArtifacts(std::move(value)); return *this;}
    inline JobData& AddInputArtifacts(const Artifact& value) { m_inputArtifactsHasBeenSet = true; m_inputArtifacts.push_back(value); return *this; }
    inline JobData& AddInputArtifacts(Artifact&& value) { m_inputArtifactsHasBeenSet = true; m_inputArtifacts.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The output of the job.</p>
     */
    inline const Aws::Vector<Artifact>& GetOutputArtifacts() const{ return m_outputArtifacts; }
    inline bool OutputArtifactsHasBeenSet() const { return m_outputArtifactsHasBeenSet; }
    inline void SetOutputArtifacts(const Aws::Vector<Artifact>& value) { m_outputArtifactsHasBeenSet = true; m_outputArtifacts = value; }
    inline void SetOutputArtifacts(Aws::Vector<Artifact>&& value) { m_outputArtifactsHasBeenSet = true; m_outputArtifacts = std::move(value); }
    inline JobData& WithOutputArtifacts(const Aws::Vector<Artifact>& value) { SetOutputArtifacts(value); return *this;}
    inline JobData& WithOutputArtifacts(Aws::Vector<Artifact>&& value) { SetOutputArtifacts(std::move(value)); return *this;}
    inline JobData& AddOutputArtifacts(const Artifact& value) { m_outputArtifactsHasBeenSet = true; m_outputArtifacts.push_back(value); return *this; }
    inline JobData& AddOutputArtifacts(Artifact&& value) { m_outputArtifactsHasBeenSet = true; m_outputArtifacts.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>Represents an Amazon Web Services session credentials object. These
     * credentials are temporary credentials that are issued by Amazon Web Services
     * Secure Token Service (STS). They can be used to access input and output
     * artifacts in the S3 bucket used to store artifacts for the pipeline in
     * CodePipeline.</p>
     */
    inline const AWSSessionCredentials& GetArtifactCredentials() const{ return m_artifactCredentials; }
    inline bool ArtifactCredentialsHasBeenSet() const { return m_artifactCredentialsHasBeenSet; }
    inline void SetArtifactCredentials(const AWSSessionCredentials& value) { m_artifactCredentialsHasBeenSet = true; m_artifactCredentials = value; }
    inline void SetArtifactCredentials(AWSSessionCredentials&& value) { m_artifactCredentialsHasBeenSet = true; m_artifactCredentials = std::move(value); }
    inline JobData& WithArtifactCredentials(const AWSSessionCredentials& value) { SetArtifactCredentials(value); return *this;}
    inline JobData& WithArtifactCredentials(AWSSessionCredentials&& value) { SetArtifactCredentials(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A system-generated token, such as a deployment ID, required by a job to
     * continue the job asynchronously.</p>
     */
    inline const Aws::String& GetContinuationToken() const{ return m_continuationToken; }
    inline bool ContinuationTokenHasBeenSet() const { return m_continuationTokenHasBeenSet; }
    inline void SetContinuationToken(const Aws::String& value) { m_continuationTokenHasBeenSet = true; m_continuationToken = value; }
    inline void SetContinuationToken(Aws::String&& value) { m_continuationTokenHasBeenSet = true; m_continuationToken = std::move(value); }
    inline void SetContinuationToken(const char* value) { m_continuationTokenHasBeenSet = true; m_continuationToken.assign(value); }
    inline JobData& WithContinuationToken(const Aws::String& value) { SetContinuationToken(value); return *this;}
    inline JobData& WithContinuationToken(Aws::String&& value) { SetContinuationToken(std::move(value)); return *this;}
    inline JobData& WithContinuationToken(const char* value) { SetContinuationToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Represents information about the key used to encrypt data in the artifact
     * store, such as an KMS key. </p>
     */
    inline const EncryptionKey& GetEncryptionKey() const{ return m_encryptionKey; }
    inline bool EncryptionKeyHasBeenSet() const { return m_encryptionKeyHasBeenSet; }
    inline void SetEncryptionKey(const EncryptionKey& value) { m_encryptionKeyHasBeenSet = true; m_encryptionKey = value; }
    inline void SetEncryptionKey(EncryptionKey&& value) { m_encryptionKeyHasBeenSet = true; m_encryptionKey = std::move(value); }
    inline JobData& WithEncryptionKey(const EncryptionKey& value) { SetEncryptionKey(value); return *this;}
    inline JobData& WithEncryptionKey(EncryptionKey&& value) { SetEncryptionKey(std::move(value)); return *this;}
    ///@}
  private:

    ActionTypeId m_actionTypeId;
    bool m_actionTypeIdHasBeenSet = false;

    ActionConfiguration m_actionConfiguration;
    bool m_actionConfigurationHasBeenSet = false;

    PipelineContext m_pipelineContext;
    bool m_pipelineContextHasBeenSet = false;

    Aws::Vector<Artifact> m_inputArtifacts;
    bool m_inputArtifactsHasBeenSet = false;

    Aws::Vector<Artifact> m_outputArtifacts;
    bool m_outputArtifactsHasBeenSet = false;

    AWSSessionCredentials m_artifactCredentials;
    bool m_artifactCredentialsHasBeenSet = false;

    Aws::String m_continuationToken;
    bool m_continuationTokenHasBeenSet = false;

    EncryptionKey m_encryptionKey;
    bool m_encryptionKeyHasBeenSet = false;
  };

} // namespace Model
} // namespace CodePipeline
} // namespace Aws
