﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codecatalyst/CodeCatalyst_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/codecatalyst/model/SpaceSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace CodeCatalyst
{
namespace Model
{
  class ListSpacesResult
  {
  public:
    AWS_CODECATALYST_API ListSpacesResult();
    AWS_CODECATALYST_API ListSpacesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_CODECATALYST_API ListSpacesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A token returned from a call to this API to indicate the next batch of
     * results to return, if any.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListSpacesResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListSpacesResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListSpacesResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about the spaces. </p>
     */
    inline const Aws::Vector<SpaceSummary>& GetItems() const{ return m_items; }
    inline void SetItems(const Aws::Vector<SpaceSummary>& value) { m_items = value; }
    inline void SetItems(Aws::Vector<SpaceSummary>&& value) { m_items = std::move(value); }
    inline ListSpacesResult& WithItems(const Aws::Vector<SpaceSummary>& value) { SetItems(value); return *this;}
    inline ListSpacesResult& WithItems(Aws::Vector<SpaceSummary>&& value) { SetItems(std::move(value)); return *this;}
    inline ListSpacesResult& AddItems(const SpaceSummary& value) { m_items.push_back(value); return *this; }
    inline ListSpacesResult& AddItems(SpaceSummary&& value) { m_items.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListSpacesResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListSpacesResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListSpacesResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_nextToken;

    Aws::Vector<SpaceSummary> m_items;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace CodeCatalyst
} // namespace Aws
