﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudsearchdomain/CloudSearchDomain_EXPORTS.h>
#include <aws/cloudsearchdomain/model/SearchStatus.h>
#include <aws/cloudsearchdomain/model/Hits.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/cloudsearchdomain/model/BucketInfo.h>
#include <aws/cloudsearchdomain/model/FieldStats.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace CloudSearchDomain
{
namespace Model
{
  /**
   * <p>The result of a <code>Search</code> request. Contains the documents that
   * match the specified search criteria and any requested fields, highlights, and
   * facet information.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/cloudsearchdomain-2013-01-01/SearchResponse">AWS
   * API Reference</a></p>
   */
  class SearchResult
  {
  public:
    AWS_CLOUDSEARCHDOMAIN_API SearchResult();
    AWS_CLOUDSEARCHDOMAIN_API SearchResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_CLOUDSEARCHDOMAIN_API SearchResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The status information returned for the search request.</p>
     */
    inline const SearchStatus& GetStatus() const{ return m_status; }
    inline void SetStatus(const SearchStatus& value) { m_status = value; }
    inline void SetStatus(SearchStatus&& value) { m_status = std::move(value); }
    inline SearchResult& WithStatus(const SearchStatus& value) { SetStatus(value); return *this;}
    inline SearchResult& WithStatus(SearchStatus&& value) { SetStatus(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The documents that match the search criteria.</p>
     */
    inline const Hits& GetHits() const{ return m_hits; }
    inline void SetHits(const Hits& value) { m_hits = value; }
    inline void SetHits(Hits&& value) { m_hits = std::move(value); }
    inline SearchResult& WithHits(const Hits& value) { SetHits(value); return *this;}
    inline SearchResult& WithHits(Hits&& value) { SetHits(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The requested facet information.</p>
     */
    inline const Aws::Map<Aws::String, BucketInfo>& GetFacets() const{ return m_facets; }
    inline void SetFacets(const Aws::Map<Aws::String, BucketInfo>& value) { m_facets = value; }
    inline void SetFacets(Aws::Map<Aws::String, BucketInfo>&& value) { m_facets = std::move(value); }
    inline SearchResult& WithFacets(const Aws::Map<Aws::String, BucketInfo>& value) { SetFacets(value); return *this;}
    inline SearchResult& WithFacets(Aws::Map<Aws::String, BucketInfo>&& value) { SetFacets(std::move(value)); return *this;}
    inline SearchResult& AddFacets(const Aws::String& key, const BucketInfo& value) { m_facets.emplace(key, value); return *this; }
    inline SearchResult& AddFacets(Aws::String&& key, const BucketInfo& value) { m_facets.emplace(std::move(key), value); return *this; }
    inline SearchResult& AddFacets(const Aws::String& key, BucketInfo&& value) { m_facets.emplace(key, std::move(value)); return *this; }
    inline SearchResult& AddFacets(Aws::String&& key, BucketInfo&& value) { m_facets.emplace(std::move(key), std::move(value)); return *this; }
    inline SearchResult& AddFacets(const char* key, BucketInfo&& value) { m_facets.emplace(key, std::move(value)); return *this; }
    inline SearchResult& AddFacets(const char* key, const BucketInfo& value) { m_facets.emplace(key, value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The requested field statistics information.</p>
     */
    inline const Aws::Map<Aws::String, FieldStats>& GetStats() const{ return m_stats; }
    inline void SetStats(const Aws::Map<Aws::String, FieldStats>& value) { m_stats = value; }
    inline void SetStats(Aws::Map<Aws::String, FieldStats>&& value) { m_stats = std::move(value); }
    inline SearchResult& WithStats(const Aws::Map<Aws::String, FieldStats>& value) { SetStats(value); return *this;}
    inline SearchResult& WithStats(Aws::Map<Aws::String, FieldStats>&& value) { SetStats(std::move(value)); return *this;}
    inline SearchResult& AddStats(const Aws::String& key, const FieldStats& value) { m_stats.emplace(key, value); return *this; }
    inline SearchResult& AddStats(Aws::String&& key, const FieldStats& value) { m_stats.emplace(std::move(key), value); return *this; }
    inline SearchResult& AddStats(const Aws::String& key, FieldStats&& value) { m_stats.emplace(key, std::move(value)); return *this; }
    inline SearchResult& AddStats(Aws::String&& key, FieldStats&& value) { m_stats.emplace(std::move(key), std::move(value)); return *this; }
    inline SearchResult& AddStats(const char* key, FieldStats&& value) { m_stats.emplace(key, std::move(value)); return *this; }
    inline SearchResult& AddStats(const char* key, const FieldStats& value) { m_stats.emplace(key, value); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline SearchResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline SearchResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline SearchResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    SearchStatus m_status;

    Hits m_hits;

    Aws::Map<Aws::String, BucketInfo> m_facets;

    Aws::Map<Aws::String, FieldStats> m_stats;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace CloudSearchDomain
} // namespace Aws
