﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cleanrooms/model/UpdateIdNamespaceAssociationRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::CleanRooms::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

UpdateIdNamespaceAssociationRequest::UpdateIdNamespaceAssociationRequest() : 
    m_idNamespaceAssociationIdentifierHasBeenSet(false),
    m_membershipIdentifierHasBeenSet(false),
    m_nameHasBeenSet(false),
    m_descriptionHasBeenSet(false),
    m_idMappingConfigHasBeenSet(false)
{
}

Aws::String UpdateIdNamespaceAssociationRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_nameHasBeenSet)
  {
   payload.WithString("name", m_name);

  }

  if(m_descriptionHasBeenSet)
  {
   payload.WithString("description", m_description);

  }

  if(m_idMappingConfigHasBeenSet)
  {
   payload.WithObject("idMappingConfig", m_idMappingConfig.Jsonize());

  }

  return payload.View().WriteReadable();
}




