﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cleanrooms/model/CreateIdNamespaceAssociationRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::CleanRooms::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

CreateIdNamespaceAssociationRequest::CreateIdNamespaceAssociationRequest() : 
    m_membershipIdentifierHasBeenSet(false),
    m_inputReferenceConfigHasBeenSet(false),
    m_tagsHasBeenSet(false),
    m_nameHasBeenSet(false),
    m_descriptionHasBeenSet(false),
    m_idMappingConfigHasBeenSet(false)
{
}

Aws::String CreateIdNamespaceAssociationRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_inputReferenceConfigHasBeenSet)
  {
   payload.WithObject("inputReferenceConfig", m_inputReferenceConfig.Jsonize());

  }

  if(m_tagsHasBeenSet)
  {
   JsonValue tagsJsonMap;
   for(auto& tagsItem : m_tags)
   {
     tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
   }
   payload.WithObject("tags", std::move(tagsJsonMap));

  }

  if(m_nameHasBeenSet)
  {
   payload.WithString("name", m_name);

  }

  if(m_descriptionHasBeenSet)
  {
   payload.WithString("description", m_description);

  }

  if(m_idMappingConfigHasBeenSet)
  {
   payload.WithObject("idMappingConfig", m_idMappingConfig.Jsonize());

  }

  return payload.View().WriteReadable();
}




