﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/arc-zonal-shift/model/UpdateAutoshiftObserverNotificationStatusResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::ARCZonalShift::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

UpdateAutoshiftObserverNotificationStatusResult::UpdateAutoshiftObserverNotificationStatusResult() : 
    m_status(AutoshiftObserverNotificationStatus::NOT_SET)
{
}

UpdateAutoshiftObserverNotificationStatusResult::UpdateAutoshiftObserverNotificationStatusResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
  : UpdateAutoshiftObserverNotificationStatusResult()
{
  *this = result;
}

UpdateAutoshiftObserverNotificationStatusResult& UpdateAutoshiftObserverNotificationStatusResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("status"))
  {
    m_status = AutoshiftObserverNotificationStatusMapper::GetAutoshiftObserverNotificationStatusForName(jsonValue.GetString("status"));

  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
