﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent-runtime/model/GuardrailCustomWord.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace BedrockAgentRuntime
{
namespace Model
{

GuardrailCustomWord::GuardrailCustomWord() : 
    m_action(GuardrailWordPolicyAction::NOT_SET),
    m_actionHasBeenSet(false),
    m_matchHasBeenSet(false)
{
}

GuardrailCustomWord::GuardrailCustomWord(JsonView jsonValue)
  : GuardrailCustomWord()
{
  *this = jsonValue;
}

GuardrailCustomWord& GuardrailCustomWord::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("action"))
  {
    m_action = GuardrailWordPolicyActionMapper::GetGuardrailWordPolicyActionForName(jsonValue.GetString("action"));

    m_actionHasBeenSet = true;
  }

  if(jsonValue.ValueExists("match"))
  {
    m_match = jsonValue.GetString("match");

    m_matchHasBeenSet = true;
  }

  return *this;
}

JsonValue GuardrailCustomWord::Jsonize() const
{
  JsonValue payload;

  if(m_actionHasBeenSet)
  {
   payload.WithString("action", GuardrailWordPolicyActionMapper::GetNameForGuardrailWordPolicyAction(m_action));
  }

  if(m_matchHasBeenSet)
  {
   payload.WithString("match", m_match);

  }

  return payload;
}

} // namespace Model
} // namespace BedrockAgentRuntime
} // namespace Aws
