﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/backup-gateway/BackupGateway_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/backup-gateway/model/VmwareToAwsTagMapping.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace BackupGateway
{
namespace Model
{
  class GetHypervisorPropertyMappingsResult
  {
  public:
    AWS_BACKUPGATEWAY_API GetHypervisorPropertyMappingsResult();
    AWS_BACKUPGATEWAY_API GetHypervisorPropertyMappingsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_BACKUPGATEWAY_API GetHypervisorPropertyMappingsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) of the hypervisor.</p>
     */
    inline const Aws::String& GetHypervisorArn() const{ return m_hypervisorArn; }
    inline void SetHypervisorArn(const Aws::String& value) { m_hypervisorArn = value; }
    inline void SetHypervisorArn(Aws::String&& value) { m_hypervisorArn = std::move(value); }
    inline void SetHypervisorArn(const char* value) { m_hypervisorArn.assign(value); }
    inline GetHypervisorPropertyMappingsResult& WithHypervisorArn(const Aws::String& value) { SetHypervisorArn(value); return *this;}
    inline GetHypervisorPropertyMappingsResult& WithHypervisorArn(Aws::String&& value) { SetHypervisorArn(std::move(value)); return *this;}
    inline GetHypervisorPropertyMappingsResult& WithHypervisorArn(const char* value) { SetHypervisorArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) of the IAM role.</p>
     */
    inline const Aws::String& GetIamRoleArn() const{ return m_iamRoleArn; }
    inline void SetIamRoleArn(const Aws::String& value) { m_iamRoleArn = value; }
    inline void SetIamRoleArn(Aws::String&& value) { m_iamRoleArn = std::move(value); }
    inline void SetIamRoleArn(const char* value) { m_iamRoleArn.assign(value); }
    inline GetHypervisorPropertyMappingsResult& WithIamRoleArn(const Aws::String& value) { SetIamRoleArn(value); return *this;}
    inline GetHypervisorPropertyMappingsResult& WithIamRoleArn(Aws::String&& value) { SetIamRoleArn(std::move(value)); return *this;}
    inline GetHypervisorPropertyMappingsResult& WithIamRoleArn(const char* value) { SetIamRoleArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>This is a display of the mappings of on-premises VMware tags to the Amazon
     * Web Services tags.</p>
     */
    inline const Aws::Vector<VmwareToAwsTagMapping>& GetVmwareToAwsTagMappings() const{ return m_vmwareToAwsTagMappings; }
    inline void SetVmwareToAwsTagMappings(const Aws::Vector<VmwareToAwsTagMapping>& value) { m_vmwareToAwsTagMappings = value; }
    inline void SetVmwareToAwsTagMappings(Aws::Vector<VmwareToAwsTagMapping>&& value) { m_vmwareToAwsTagMappings = std::move(value); }
    inline GetHypervisorPropertyMappingsResult& WithVmwareToAwsTagMappings(const Aws::Vector<VmwareToAwsTagMapping>& value) { SetVmwareToAwsTagMappings(value); return *this;}
    inline GetHypervisorPropertyMappingsResult& WithVmwareToAwsTagMappings(Aws::Vector<VmwareToAwsTagMapping>&& value) { SetVmwareToAwsTagMappings(std::move(value)); return *this;}
    inline GetHypervisorPropertyMappingsResult& AddVmwareToAwsTagMappings(const VmwareToAwsTagMapping& value) { m_vmwareToAwsTagMappings.push_back(value); return *this; }
    inline GetHypervisorPropertyMappingsResult& AddVmwareToAwsTagMappings(VmwareToAwsTagMapping&& value) { m_vmwareToAwsTagMappings.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline GetHypervisorPropertyMappingsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline GetHypervisorPropertyMappingsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline GetHypervisorPropertyMappingsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_hypervisorArn;

    Aws::String m_iamRoleArn;

    Aws::Vector<VmwareToAwsTagMapping> m_vmwareToAwsTagMappings;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace BackupGateway
} // namespace Aws
