/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.arrow.dataset;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;

public class TextBasedWriteSupport {
  private final URI uri;
  private final Random random = new Random();

  public TextBasedWriteSupport(File outputFolder, String fileExtension) throws URISyntaxException {
    uri = new URI("file", outputFolder.getPath() + File.separator +
        "generated-" + random.nextLong() + fileExtension, null);
  }

  public static TextBasedWriteSupport writeTempFile(File outputFolder, String fileExtension, String... values)
      throws URISyntaxException, IOException {
    TextBasedWriteSupport writer = new TextBasedWriteSupport(outputFolder, fileExtension);
    try (FileWriter addValues = new FileWriter(new File(writer.uri), true)) {
      for (Object value : values) {
        addValues.write(value + "\n");
      }
    }
    return writer;
  }

  public String getOutputURI() {
    return uri.toString();
  }
}
