

AC_DEFUN([ABI_CC_OPTFLAGS],[
  dnl Init
  abi_cc_vendor_opt="none"
  abi_cc_version_opt="none"
  abi_cpu_spec_opt="none"

  dnl Look for optimizations
  AC_MSG_CHECKING([which cc optimizations to apply])

  dnl Case built from config/optim/cc_*.conf
  case "${abi_cc_vendor}" in
    arm)
      abi_cc_vendor_opt="arm"
      abi_cc_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          CFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          CFLAGS_OPTIM="-O2 -mtune=native -mcpu=native"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          CFLAGS_OPTIM="-O3 -mtune=native -mcpu=native -ffp-contract=fast"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    gnu)
      abi_cc_vendor_opt="gnu"
      abi_cc_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          CFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          CFLAGS_OPTIM="-O2 -mtune=native -march=native"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          CFLAGS_OPTIM="-O3 -mtune=native -march=native"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    ibm)
      abi_cc_vendor_opt="ibm"
      abi_cc_version_opt="default"
      case "${abi_cpu_spec}" in
        ibm_powerpc)
          abi_cpu_spec_opt="ibm_powerpc"
          case "${abi_optim_flavor}" in
            safe)
              abi_optim_flavor_opt="safe"
              CFLAGS_OPTIM="-O2 -qarch=auto -qtune=auto -qstrict -qspill=2000"
              ;;
            standard)
              abi_optim_flavor_opt="standard"
              CFLAGS_OPTIM="-O3 -qarch=auto -qtune=auto -qstrict -qspill=2000"
              ;;
            aggressive)
              abi_optim_flavor_opt="aggressive"
              CFLAGS_OPTIM="-O4 -qarch=auto -qtune=auto -qstrict -qspill=2000"
              ;;
          esac   # [case: abi_optim_flavor, indent: 4, item: True]
          ;;
        ibm_powerpc64)
          abi_cpu_spec_opt="ibm_powerpc64"
          case "${abi_optim_flavor}" in
            safe)
              abi_optim_flavor_opt="safe"
              CFLAGS_OPTIM="-O2 -qarch=auto -qtune=auto -qstrict -qspill=2000"
              ;;
            standard)
              abi_optim_flavor_opt="standard"
              CFLAGS_OPTIM="-O3 -qarch=auto -qtune=auto -qstrict -qspill=2000"
              ;;
            aggressive)
              abi_optim_flavor_opt="aggressive"
              CFLAGS_OPTIM="-O4 -qarch=auto -qtune=auto -qstrict -qspill=2000"
              ;;
          esac   # [case: abi_optim_flavor, indent: 4, item: True]
          ;;
        *)
          abi_cpu_spec_opt="default"
          case "${abi_optim_flavor}" in
            safe)
              abi_optim_flavor_opt="safe"
              CFLAGS_OPTIM="-O2"
              ;;
            standard)
              abi_optim_flavor_opt="standard"
              CFLAGS_OPTIM="-O2"
              ;;
            aggressive)
              abi_optim_flavor_opt="aggressive"
              CFLAGS_OPTIM="-O3"
              ;;
          esac   # [case: abi_optim_flavor, indent: 4, item: True]
          ;;
      esac   # [case: abi_cpu_spec, indent: 2, item: True]
      ;;
    intel)
      abi_cc_vendor_opt="intel"
      abi_cc_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          CFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          CFLAGS_OPTIM="-O2"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          CFLAGS_OPTIM="-O3"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    llvm)
      abi_cc_vendor_opt="llvm"
      abi_cc_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          CFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          CFLAGS_OPTIM="-O2 -mtune=native -mcpu=native"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          CFLAGS_OPTIM="-O3 -mtune=native -mcpu=native -ffp-contract=fast"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    nvhpc)
      abi_cc_vendor_opt="nvhpc"
      abi_cc_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          CFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          CFLAGS_OPTIM="-fast"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          CFLAGS_OPTIM="-O3"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    cray)
      abi_cc_vendor_opt="cray"
      abi_cc_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          CFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          CFLAGS_OPTIM="-O2"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          CFLAGS_OPTIM="-O3"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
  esac   # [case: abi_cc_vendor, indent: 0, item: True]

  dnl Display settings
  AC_MSG_RESULT([${abi_cc_vendor_opt}/${abi_cc_version_opt}/${abi_cpu_spec_opt}])

]) #ABI_CC_OPTFLAGS


AC_DEFUN([ABI_CXX_OPTFLAGS],[
  dnl Init
  abi_cxx_vendor_opt="none"
  abi_cxx_version_opt="none"
  abi_cpu_spec_opt="none"

  dnl Look for optimizations
  AC_MSG_CHECKING([which cxx optimizations to apply])

  dnl Case built from config/optim/cxx_*.conf
  case "${abi_cxx_vendor}" in
    arm)
      abi_cxx_vendor_opt="arm"
      abi_cxx_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          CXXFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          CXXFLAGS_OPTIM="-O2 -mtune=native -mcpu=native"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          CXXFLAGS_OPTIM="-O3 -mtune=native -mcpu=native -ffp-contract=fast"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    gnu)
      abi_cxx_vendor_opt="gnu"
      abi_cxx_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          CXXFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          CXXFLAGS_OPTIM="-O2 -mtune=native -march=native"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          CXXFLAGS_OPTIM="-O3 -mtune=native -march=native"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    ibm)
      abi_cxx_vendor_opt="ibm"
      abi_cxx_version_opt="default"
      case "${abi_cpu_spec}" in
        ibm_powerpc)
          abi_cpu_spec_opt="ibm_powerpc"
          case "${abi_optim_flavor}" in
            safe)
              abi_optim_flavor_opt="safe"
              CXXFLAGS_OPTIM="-O2 -qarch=auto -qtune=auto -qstrict -qspill=2000 -qessl"
              ;;
            standard)
              abi_optim_flavor_opt="standard"
              CXXFLAGS_OPTIM="-O3 -qarch=auto -qtune=auto -qstrict -qspill=2000 -qessl"
              ;;
            aggressive)
              abi_optim_flavor_opt="aggressive"
              CXXFLAGS_OPTIM="-O4 -qarch=auto -qtune=auto -qstrict -qspill=2000 -qessl"
              ;;
          esac   # [case: abi_optim_flavor, indent: 4, item: True]
          ;;
        ibm_powerpc64)
          abi_cpu_spec_opt="ibm_powerpc64"
          case "${abi_optim_flavor}" in
            safe)
              abi_optim_flavor_opt="safe"
              CXXFLAGS_OPTIM="-O2 -qarch=auto -qtune=auto -qstrict -qspill=2000 -qessl"
              ;;
            standard)
              abi_optim_flavor_opt="standard"
              CXXFLAGS_OPTIM="-O3 -qarch=auto -qtune=auto -qstrict -qspill=2000 -qessl"
              ;;
            aggressive)
              abi_optim_flavor_opt="aggressive"
              CXXFLAGS_OPTIM="-O4 -qarch=auto -qtune=auto -qstrict -qspill=2000 -qessl"
              ;;
          esac   # [case: abi_optim_flavor, indent: 4, item: True]
          ;;
        *)
          abi_cpu_spec_opt="default"
          case "${abi_optim_flavor}" in
            safe)
              abi_optim_flavor_opt="safe"
              CXXFLAGS_OPTIM="-O2"
              ;;
            standard)
              abi_optim_flavor_opt="standard"
              CXXFLAGS_OPTIM="-O2"
              ;;
            aggressive)
              abi_optim_flavor_opt="aggressive"
              CXXFLAGS_OPTIM="-O3"
              ;;
          esac   # [case: abi_optim_flavor, indent: 4, item: True]
          ;;
      esac   # [case: abi_cpu_spec, indent: 2, item: True]
      ;;
    intel)
      abi_cxx_vendor_opt="intel"
      abi_cxx_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          CXXFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          CXXFLAGS_OPTIM="-O2"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          CXXFLAGS_OPTIM="-O3"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    llvm)
      abi_cxx_vendor_opt="llvm"
      abi_cxx_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          CXXFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          CXXFLAGS_OPTIM="-O2 -mtune=native -mcpu=native"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          CXXFLAGS_OPTIM="-O3 -mtune=native -mcpu=native -ffp-contract=fast"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    nvhpc)
      abi_cxx_vendor_opt="nvhpc"
      abi_cxx_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          CXXFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          CXXFLAGS_OPTIM="-fast"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          CXXFLAGS_OPTIM="-O3"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    cray)
      abi_cxx_vendor_opt="cray"
      abi_cxx_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          CXXFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          CXXFLAGS_OPTIM="-O2"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          CXXFLAGS_OPTIM="-O3"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
  esac   # [case: abi_cxx_vendor, indent: 0, item: True]

  dnl Display settings
  AC_MSG_RESULT([${abi_cxx_vendor_opt}/${abi_cxx_version_opt}/${abi_cpu_spec_opt}])

]) #ABI_CXX_OPTFLAGS


AC_DEFUN([ABI_FC_OPTFLAGS],[
  dnl Init
  abi_fc_vendor_opt="none"
  abi_fc_version_opt="none"
  abi_cpu_spec_opt="none"

  dnl Look for optimizations
  AC_MSG_CHECKING([which fc optimizations to apply])

  dnl Case built from config/optim/fc_*.conf
  case "${abi_fc_vendor}" in
    arm)
      abi_fc_vendor_opt="arm"
      abi_fc_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          FCFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          FCFLAGS_OPTIM="-O2 -mtune=native -mcpu=native"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          FCFLAGS_OPTIM="-O3 -mtune=native -mcpu=native"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    gnu)
      abi_fc_vendor_opt="gnu"
      abi_fc_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          FCFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          FCFLAGS_OPTIM="-O2 -mtune=native -march=native"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          FCFLAGS_OPTIM="-O3 -mtune=native -march=native -funroll-loops -faggressive-function-elimination"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    ibm)
      abi_fc_vendor_opt="ibm"
      abi_fc_version_opt="default"
      case "${abi_cpu_spec}" in
        ibm_powerpc)
          abi_cpu_spec_opt="ibm_powerpc"
          case "${abi_optim_flavor}" in
            safe)
              abi_optim_flavor_opt="safe"
              FCFLAGS_OPTIM="-O2 -qarch=auto -qtune=auto -qcache=auto"
              FC_LDFLAGS_OPTIM=""
              ;;
            standard)
              abi_optim_flavor_opt="standard"
              FCFLAGS_OPTIM="-O2 -qarch=auto -qtune=auto -qcache=auto"
              FC_LDFLAGS_OPTIM="-lxlopt"
              ;;
            aggressive)
              abi_optim_flavor_opt="aggressive"
              FCFLAGS_OPTIM="-O4 -qarch=auto -qtune=auto -qcache=auto"
              FC_LDFLAGS_OPTIM="-lxlopt"
              ;;
          esac   # [case: abi_optim_flavor, indent: 4, item: True]
          ;;
        ibm_powerpc64)
          abi_cpu_spec_opt="ibm_powerpc64"
          case "${abi_optim_flavor}" in
            safe)
              abi_optim_flavor_opt="safe"
              FCFLAGS_OPTIM="-O2 -qarch=auto -qtune=auto -qcache=auto"
              FC_LDFLAGS_OPTIM=""
              ;;
            standard)
              abi_optim_flavor_opt="standard"
              FCFLAGS_OPTIM="-O2 -qarch=auto -qtune=auto -qcache=auto"
              FC_LDFLAGS_OPTIM="-lxlopt"
              ;;
            aggressive)
              abi_optim_flavor_opt="aggressive"
              FCFLAGS_OPTIM="-O4 -qarch=auto -qtune=auto -qcache=auto"
              FC_LDFLAGS_OPTIM="-lxlopt"
              ;;
          esac   # [case: abi_optim_flavor, indent: 4, item: True]
          ;;
        *)
          abi_cpu_spec_opt="default"
          case "${abi_optim_flavor}" in
            safe)
              abi_optim_flavor_opt="safe"
              FCFLAGS_OPTIM="-O2"
              ;;
            standard)
              abi_optim_flavor_opt="standard"
              FCFLAGS_OPTIM="-O2"
              ;;
            aggressive)
              abi_optim_flavor_opt="aggressive"
              FCFLAGS_OPTIM="-O3"
              ;;
          esac   # [case: abi_optim_flavor, indent: 4, item: True]
          ;;
      esac   # [case: abi_cpu_spec, indent: 2, item: True]
      ;;
    intel)
      abi_fc_vendor_opt="intel"
      abi_fc_version_opt="default"
      case "${abi_cpu_spec}" in
        amd_opteron)
          abi_cpu_spec_opt="amd_opteron"
          case "${abi_optim_flavor}" in
            safe)
              abi_optim_flavor_opt="safe"
              FCFLAGS_OPTIM="-O1"
              ;;
            standard)
              abi_optim_flavor_opt="standard"
              FCFLAGS_OPTIM="-O2"
              ;;
            aggressive)
              abi_optim_flavor_opt="aggressive"
              FCFLAGS_OPTIM="-O3"
              ;;
          esac   # [case: abi_optim_flavor, indent: 4, item: True]
          ;;
        intel_itanium1)
          abi_cpu_spec_opt="intel_itanium1"
          case "${abi_optim_flavor}" in
            safe)
              abi_optim_flavor_opt="safe"
              FCFLAGS_OPTIM="-O2 -fp-model precise -fp-speculation=safe"
              ;;
            standard)
              abi_optim_flavor_opt="standard"
              FCFLAGS_OPTIM="-O2"
              ;;
            aggressive)
              abi_optim_flavor_opt="aggressive"
              FCFLAGS_OPTIM="-O3 -fp-model fast=1 -fp-relaxed -ip"
              ;;
          esac   # [case: abi_optim_flavor, indent: 4, item: True]
          ;;
        intel_itanium2)
          abi_cpu_spec_opt="intel_itanium2"
          case "${abi_optim_flavor}" in
            safe)
              abi_optim_flavor_opt="safe"
              FCFLAGS_OPTIM="-O2 -fp-model precise -fp-speculation=safe"
              ;;
            standard)
              abi_optim_flavor_opt="standard"
              FCFLAGS_OPTIM="-O2"
              ;;
            aggressive)
              abi_optim_flavor_opt="aggressive"
              FCFLAGS_OPTIM="-O3 -fp-model fast=1 -fp-relaxed -ip"
              ;;
          esac   # [case: abi_optim_flavor, indent: 4, item: True]
          ;;
        *)
          abi_cpu_spec_opt="default"
          case "${abi_optim_flavor}" in
            safe)
              abi_optim_flavor_opt="safe"
              FCFLAGS_OPTIM="-O2 -fltconsistency -fp-model precise -fp-speculation=safe -prec-div -prec-sqrt"
              ;;
            standard)
              abi_optim_flavor_opt="standard"
              FCFLAGS_OPTIM="-O3"
              ;;
            aggressive)
              abi_optim_flavor_opt="aggressive"
              FCFLAGS_OPTIM="-O3 -xHOST"
              ;;
          esac   # [case: abi_optim_flavor, indent: 4, item: True]
          ;;
      esac   # [case: abi_cpu_spec, indent: 2, item: True]
      ;;
    llvm)
      abi_fc_vendor_opt="llvm"
      abi_fc_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          FCFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          FCFLAGS_OPTIM="-O2 -mtune=native -mcpu=native"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          FCFLAGS_OPTIM="-O3 -mtune=native -mcpu=native"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    nag)
      abi_fc_vendor_opt="nag"
      abi_fc_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          FCFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          FCFLAGS_OPTIM="-O3"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          FCFLAGS_OPTIM="-O4"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    nvhpc)
      abi_fc_vendor_opt="nvhpc"
      abi_fc_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          FCFLAGS_OPTIM="-O2"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          FCFLAGS_OPTIM="-fast"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          FCFLAGS_OPTIM="-O3"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    pgi)
      abi_fc_vendor_opt="pgi"
      abi_fc_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          FCFLAGS_OPTIM="-O2 -tp=x64"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          FCFLAGS_OPTIM="-O2 -tp=x64"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          FCFLAGS_OPTIM="-O3 -tp=x64"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
    cray)
      abi_fc_vendor_opt="cray"
      abi_fc_version_opt="default"
      abi_cpu_spec_opt="default"
      case "${abi_optim_flavor}" in
        safe)
          abi_optim_flavor_opt="safe"
          FCFLAGS_OPTIM="-O1"
          ;;
        standard)
          abi_optim_flavor_opt="standard"
          FCFLAGS_OPTIM="-O2"
          ;;
        aggressive)
          abi_optim_flavor_opt="aggressive"
          FCFLAGS_OPTIM="-O3"
          ;;
      esac   # [case: abi_optim_flavor, indent: 2, item: True]
      ;;
  esac   # [case: abi_fc_vendor, indent: 0, item: True]

  dnl Display settings
  AC_MSG_RESULT([${abi_fc_vendor_opt}/${abi_fc_version_opt}/${abi_cpu_spec_opt}])

]) #ABI_FC_OPTFLAGS
