# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.9

import enum
import datetime
import sys
import types
import typing

import winsdk.system
import winsdk.windows.applicationmodel.appservice
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.graphics.directx.direct3d11
import winsdk.windows.graphics.imaging
import winsdk.windows.media.capture
import winsdk.windows.media.capture.frames
import winsdk.windows.media.devices
import winsdk.windows.media.devices.core
import winsdk.windows.media.faceanalysis
import winsdk.windows.media.mediaproperties
import winsdk.windows.media.playback
import winsdk.windows.media.protection
import winsdk.windows.media.streaming.adaptive
import winsdk.windows.networking.backgroundtransfer
import winsdk.windows.storage
import winsdk.windows.storage.fileproperties
import winsdk.windows.storage.streams
import winsdk.windows.ui

class AudioDecoderDegradation(enum.IntEnum):
    NONE = 0
    DOWNMIX_TO2_CHANNELS = 1
    DOWNMIX_TO6_CHANNELS = 2
    DOWNMIX_TO8_CHANNELS = 3

class AudioDecoderDegradationReason(enum.IntEnum):
    NONE = 0
    LICENSING_REQUIREMENT = 1
    SPATIAL_AUDIO_NOT_SUPPORTED = 2

class CodecCategory(enum.IntEnum):
    ENCODER = 0
    DECODER = 1

class CodecKind(enum.IntEnum):
    AUDIO = 0
    VIDEO = 1

class FaceDetectionMode(enum.IntEnum):
    HIGH_PERFORMANCE = 0
    BALANCED = 1
    HIGH_QUALITY = 2

class MediaDecoderStatus(enum.IntEnum):
    FULLY_SUPPORTED = 0
    UNSUPPORTED_SUBTYPE = 1
    UNSUPPORTED_ENCODER_PROPERTIES = 2
    DEGRADED = 3

class MediaSourceState(enum.IntEnum):
    INITIAL = 0
    OPENING = 1
    OPENED = 2
    FAILED = 3
    CLOSED = 4

class MediaSourceStatus(enum.IntEnum):
    FULLY_SUPPORTED = 0
    UNKNOWN = 1

class MediaStreamSourceClosedReason(enum.IntEnum):
    DONE = 0
    UNKNOWN_ERROR = 1
    APP_REPORTED_ERROR = 2
    UNSUPPORTED_PROTECTION_SYSTEM = 3
    PROTECTION_SYSTEM_FAILURE = 4
    UNSUPPORTED_ENCODING_FORMAT = 5
    MISSING_SAMPLE_REQUESTED_EVENT_HANDLER = 6

class MediaStreamSourceErrorStatus(enum.IntEnum):
    OTHER = 0
    OUT_OF_MEMORY = 1
    FAILED_TO_OPEN_FILE = 2
    FAILED_TO_CONNECT_TO_SERVER = 3
    CONNECTION_TO_SERVER_LOST = 4
    UNSPECIFIED_NETWORK_ERROR = 5
    DECODE_ERROR = 6
    UNSUPPORTED_MEDIA_FORMAT = 7

class MediaTrackKind(enum.IntEnum):
    AUDIO = 0
    VIDEO = 1
    TIMED_METADATA = 2

class MseAppendMode(enum.IntEnum):
    SEGMENTS = 0
    SEQUENCE = 1

class MseEndOfStreamStatus(enum.IntEnum):
    SUCCESS = 0
    NETWORK_ERROR = 1
    DECODE_ERROR = 2
    UNKNOWN_ERROR = 3

class MseReadyState(enum.IntEnum):
    CLOSED = 0
    OPEN = 1
    ENDED = 2

class SceneAnalysisRecommendation(enum.IntEnum):
    STANDARD = 0
    HDR = 1
    LOW_LIGHT = 2

class TimedMetadataKind(enum.IntEnum):
    CAPTION = 0
    CHAPTER = 1
    CUSTOM = 2
    DATA = 3
    DESCRIPTION = 4
    SUBTITLE = 5
    IMAGE_SUBTITLE = 6
    SPEECH = 7

class TimedMetadataTrackErrorCode(enum.IntEnum):
    NONE = 0
    DATA_FORMAT_ERROR = 1
    NETWORK_ERROR = 2
    INTERNAL_ERROR = 3

class TimedTextBoutenPosition(enum.IntEnum):
    BEFORE = 0
    AFTER = 1
    OUTSIDE = 2

class TimedTextBoutenType(enum.IntEnum):
    NONE = 0
    AUTO = 1
    FILLED_CIRCLE = 2
    OPEN_CIRCLE = 3
    FILLED_DOT = 4
    OPEN_DOT = 5
    FILLED_SESAME = 6
    OPEN_SESAME = 7

class TimedTextDisplayAlignment(enum.IntEnum):
    BEFORE = 0
    AFTER = 1
    CENTER = 2

class TimedTextFlowDirection(enum.IntEnum):
    LEFT_TO_RIGHT = 0
    RIGHT_TO_LEFT = 1

class TimedTextFontStyle(enum.IntEnum):
    NORMAL = 0
    OBLIQUE = 1
    ITALIC = 2

class TimedTextLineAlignment(enum.IntEnum):
    START = 0
    END = 1
    CENTER = 2

class TimedTextRubyAlign(enum.IntEnum):
    CENTER = 0
    START = 1
    END = 2
    SPACE_AROUND = 3
    SPACE_BETWEEN = 4
    WITH_BASE = 5

class TimedTextRubyPosition(enum.IntEnum):
    BEFORE = 0
    AFTER = 1
    OUTSIDE = 2

class TimedTextRubyReserve(enum.IntEnum):
    NONE = 0
    BEFORE = 1
    AFTER = 2
    BOTH = 3
    OUTSIDE = 4

class TimedTextScrollMode(enum.IntEnum):
    POPON = 0
    ROLLUP = 1

class TimedTextUnit(enum.IntEnum):
    PIXELS = 0
    PERCENTAGE = 1

class TimedTextWeight(enum.IntEnum):
    NORMAL = 400
    BOLD = 700

class TimedTextWrapping(enum.IntEnum):
    NO_WRAP = 0
    WRAP = 1

class TimedTextWritingMode(enum.IntEnum):
    LEFT_RIGHT_TOP_BOTTOM = 0
    RIGHT_LEFT_TOP_BOTTOM = 1
    TOP_BOTTOM_RIGHT_LEFT = 2
    TOP_BOTTOM_LEFT_RIGHT = 3
    LEFT_RIGHT = 4
    RIGHT_LEFT = 5
    TOP_BOTTOM = 6

class VideoStabilizationEffectEnabledChangedReason(enum.IntEnum):
    PROGRAMMATIC = 0
    PIXEL_RATE_TOO_HIGH = 1
    RUNNING_SLOWLY = 2

Self = typing.TypeVar('Self')

class MseTimeRange:
    start: datetime.timedelta
    end: datetime.timedelta
    def __new__(cls: typing.Type[MseTimeRange], start: datetime.timedelta, end: datetime.timedelta) -> MseTimeRange: ...

class TimedTextDouble:
    value: winsdk.system.Double
    unit: TimedTextUnit
    def __new__(cls: typing.Type[TimedTextDouble], value: winsdk.system.Double, unit: TimedTextUnit) -> TimedTextDouble: ...

class TimedTextPadding:
    before: winsdk.system.Double
    after: winsdk.system.Double
    start: winsdk.system.Double
    end: winsdk.system.Double
    unit: TimedTextUnit
    def __new__(cls: typing.Type[TimedTextPadding], before: winsdk.system.Double, after: winsdk.system.Double, start: winsdk.system.Double, end: winsdk.system.Double, unit: TimedTextUnit) -> TimedTextPadding: ...

class TimedTextPoint:
    x: winsdk.system.Double
    y: winsdk.system.Double
    unit: TimedTextUnit
    def __new__(cls: typing.Type[TimedTextPoint], x: winsdk.system.Double, y: winsdk.system.Double, unit: TimedTextUnit) -> TimedTextPoint: ...

class TimedTextSize:
    height: winsdk.system.Double
    width: winsdk.system.Double
    unit: TimedTextUnit
    def __new__(cls: typing.Type[TimedTextSize], height: winsdk.system.Double, width: winsdk.system.Double, unit: TimedTextUnit) -> TimedTextSize: ...

class AudioStreamDescriptor(winsdk.system.Object):
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    trailing_encoder_padding: typing.Optional[typing.Optional[winsdk.system.UInt32]]
    leading_encoder_padding: typing.Optional[typing.Optional[winsdk.system.UInt32]]
    name: str
    language: str
    is_selected: winsdk.system.Boolean
    label: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioStreamDescriptor: ...
    def __new__(cls: typing.Type[AudioStreamDescriptor], encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]) -> AudioStreamDescriptor:...
    def copy(self) -> typing.Optional[AudioStreamDescriptor]: ...

class AudioTrack(winsdk.system.Object):
    name: str
    playback_item: typing.Optional[winsdk.windows.media.playback.MediaPlaybackItem]
    support_info: typing.Optional[AudioTrackSupportInfo]
    label: str
    id: str
    language: str
    track_kind: MediaTrackKind
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioTrack: ...
    def get_encoding_properties(self) -> typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]: ...
    def add_open_failed(self, handler: winsdk.windows.foundation.TypedEventHandler[AudioTrack, AudioTrackOpenFailedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_open_failed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class AudioTrackOpenFailedEventArgs(winsdk.system.Object):
    extended_error: winsdk.windows.foundation.HResult
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioTrackOpenFailedEventArgs: ...

class AudioTrackSupportInfo(winsdk.system.Object):
    decoder_status: MediaDecoderStatus
    degradation: AudioDecoderDegradation
    degradation_reason: AudioDecoderDegradationReason
    media_source_status: MediaSourceStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> AudioTrackSupportInfo: ...

class ChapterCue(winsdk.system.Object):
    title: str
    start_time: datetime.timedelta
    id: str
    duration: datetime.timedelta
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ChapterCue: ...
    def __new__(cls: typing.Type[ChapterCue]) -> ChapterCue:...

class CodecInfo(winsdk.system.Object):
    category: CodecCategory
    display_name: str
    is_trusted: winsdk.system.Boolean
    kind: CodecKind
    subtypes: typing.Optional[winsdk.windows.foundation.collections.IVectorView[str]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CodecInfo: ...

class CodecQuery(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CodecQuery: ...
    def __new__(cls: typing.Type[CodecQuery]) -> CodecQuery:...
    def find_all_async(self, kind: CodecKind, category: CodecCategory, sub_type: str) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[CodecInfo]]: ...

class CodecSubtypes(winsdk.system.Object):
    audio_format_aac: typing.ClassVar[str]
    audio_format_adts: typing.ClassVar[str]
    audio_format_alac: typing.ClassVar[str]
    audio_format_amr_n_b: typing.ClassVar[str]
    audio_format_amr_w_b: typing.ClassVar[str]
    audio_format_amr_w_p: typing.ClassVar[str]
    audio_format_dolby_a_c3: typing.ClassVar[str]
    audio_format_dolby_a_c3_spdif: typing.ClassVar[str]
    audio_format_dolby_d_d_plus: typing.ClassVar[str]
    audio_format_drm: typing.ClassVar[str]
    audio_format_dts: typing.ClassVar[str]
    audio_format_flac: typing.ClassVar[str]
    audio_format_float: typing.ClassVar[str]
    audio_format_m_p3: typing.ClassVar[str]
    audio_format_m_peg: typing.ClassVar[str]
    audio_format_msp1: typing.ClassVar[str]
    audio_format_opus: typing.ClassVar[str]
    audio_format_pcm: typing.ClassVar[str]
    audio_format_w_m_audio_lossless: typing.ClassVar[str]
    audio_format_w_m_audio_v8: typing.ClassVar[str]
    audio_format_w_m_audio_v9: typing.ClassVar[str]
    audio_format_wma_spdif: typing.ClassVar[str]
    video_format420_o: typing.ClassVar[str]
    video_format_d_v25: typing.ClassVar[str]
    video_format_d_v50: typing.ClassVar[str]
    video_format_dvc: typing.ClassVar[str]
    video_format_dvh1: typing.ClassVar[str]
    video_format_dvh_d: typing.ClassVar[str]
    video_format_dvsd: typing.ClassVar[str]
    video_format_dvsl: typing.ClassVar[str]
    video_format_h263: typing.ClassVar[str]
    video_format_h264: typing.ClassVar[str]
    video_format_h264_e_s: typing.ClassVar[str]
    video_format_h265: typing.ClassVar[str]
    video_format_hevc: typing.ClassVar[str]
    video_format_hevc_e_s: typing.ClassVar[str]
    video_format_m4_s2: typing.ClassVar[str]
    video_format_m_p43: typing.ClassVar[str]
    video_format_m_p4_s: typing.ClassVar[str]
    video_format_m_p4_v: typing.ClassVar[str]
    video_format_mjpg: typing.ClassVar[str]
    video_format_mpeg2: typing.ClassVar[str]
    video_format_mpg1: typing.ClassVar[str]
    video_format_mss1: typing.ClassVar[str]
    video_format_mss2: typing.ClassVar[str]
    video_format_v_p80: typing.ClassVar[str]
    video_format_v_p90: typing.ClassVar[str]
    video_format_wmv1: typing.ClassVar[str]
    video_format_wmv2: typing.ClassVar[str]
    video_format_wmv3: typing.ClassVar[str]
    video_format_wvc1: typing.ClassVar[str]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> CodecSubtypes: ...

class DataCue(winsdk.system.Object):
    data: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    properties: typing.Optional[winsdk.windows.foundation.collections.PropertySet]
    start_time: datetime.timedelta
    id: str
    duration: datetime.timedelta
    @staticmethod
    def _from(obj: winsdk.system.Object) -> DataCue: ...
    def __new__(cls: typing.Type[DataCue]) -> DataCue:...

class FaceDetectedEventArgs(winsdk.system.Object):
    result_frame: typing.Optional[FaceDetectionEffectFrame]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> FaceDetectedEventArgs: ...

class FaceDetectionEffect(winsdk.system.Object):
    enabled: winsdk.system.Boolean
    desired_detection_interval: datetime.timedelta
    @staticmethod
    def _from(obj: winsdk.system.Object) -> FaceDetectionEffect: ...
    def set_properties(self, configuration: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]) -> None: ...
    def add_face_detected(self, handler: winsdk.windows.foundation.TypedEventHandler[FaceDetectionEffect, FaceDetectedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_face_detected(self, cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class FaceDetectionEffectDefinition(winsdk.system.Object):
    synchronous_detection_enabled: winsdk.system.Boolean
    detection_mode: FaceDetectionMode
    activatable_class_id: str
    properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> FaceDetectionEffectDefinition: ...
    def __new__(cls: typing.Type[FaceDetectionEffectDefinition]) -> FaceDetectionEffectDefinition:...

class FaceDetectionEffectFrame(winsdk.system.Object):
    detected_faces: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.media.faceanalysis.DetectedFace]]
    system_relative_time: typing.Optional[typing.Optional[datetime.timedelta]]
    relative_time: typing.Optional[typing.Optional[datetime.timedelta]]
    is_discontinuous: winsdk.system.Boolean
    duration: typing.Optional[typing.Optional[datetime.timedelta]]
    extended_properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    is_read_only: winsdk.system.Boolean
    type: str
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> FaceDetectionEffectFrame: ...
    def close(self) -> None: ...

class HighDynamicRangeControl(winsdk.system.Object):
    enabled: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> HighDynamicRangeControl: ...

class HighDynamicRangeOutput(winsdk.system.Object):
    certainty: winsdk.system.Double
    frame_controllers: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.media.devices.core.FrameController]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> HighDynamicRangeOutput: ...

class ImageCue(winsdk.system.Object):
    software_bitmap: typing.Optional[winsdk.windows.graphics.imaging.SoftwareBitmap]
    position: TimedTextPoint
    extent: TimedTextSize
    start_time: datetime.timedelta
    id: str
    duration: datetime.timedelta
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ImageCue: ...
    def __new__(cls: typing.Type[ImageCue]) -> ImageCue:...

class InitializeMediaStreamSourceRequestedEventArgs(winsdk.system.Object):
    random_access_stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream]
    source: typing.Optional[MediaStreamSource]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> InitializeMediaStreamSourceRequestedEventArgs: ...
    def get_deferral(self) -> typing.Optional[winsdk.windows.foundation.Deferral]: ...

class LowLightFusion(winsdk.system.Object):
    max_supported_frame_count: typing.ClassVar[winsdk.system.Int32]
    supported_bitmap_pixel_formats: typing.ClassVar[typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.graphics.imaging.BitmapPixelFormat]]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> LowLightFusion: ...
    @staticmethod
    def fuse_async(frame_set: typing.Iterable[winsdk.windows.graphics.imaging.SoftwareBitmap]) -> winsdk.windows.foundation.IAsyncOperationWithProgress[LowLightFusionResult, winsdk.system.Double]: ...

class LowLightFusionResult(winsdk.system.Object):
    frame: typing.Optional[winsdk.windows.graphics.imaging.SoftwareBitmap]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> LowLightFusionResult: ...
    def close(self) -> None: ...

class MediaBinder(winsdk.system.Object):
    token: str
    source: typing.Optional[MediaSource]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaBinder: ...
    def __new__(cls: typing.Type[MediaBinder]) -> MediaBinder:...
    def add_binding(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaBinder, MediaBindingEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_binding(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MediaBindingEventArgs(winsdk.system.Object):
    media_binder: typing.Optional[MediaBinder]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaBindingEventArgs: ...
    def get_deferral(self) -> typing.Optional[winsdk.windows.foundation.Deferral]: ...
    def set_adaptive_media_source(self, media_source: typing.Optional[winsdk.windows.media.streaming.adaptive.AdaptiveMediaSource]) -> None: ...
    def set_download_operation(self, download_operation: typing.Optional[winsdk.windows.networking.backgroundtransfer.DownloadOperation]) -> None: ...
    def set_storage_file(self, file: typing.Optional[winsdk.windows.storage.IStorageFile]) -> None: ...
    def set_stream(self, stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream], content_type: str) -> None: ...
    def set_stream_reference(self, stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference], content_type: str) -> None: ...
    def set_uri(self, uri: typing.Optional[winsdk.windows.foundation.Uri]) -> None: ...
    def add_canceled(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaBindingEventArgs, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_canceled(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MediaCueEventArgs(winsdk.system.Object):
    cue: typing.Optional[IMediaCue]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaCueEventArgs: ...

class MediaSource(winsdk.system.Object):
    custom_properties: typing.Optional[winsdk.windows.foundation.collections.ValueSet]
    duration: typing.Optional[typing.Optional[datetime.timedelta]]
    external_timed_metadata_tracks: typing.Optional[winsdk.windows.foundation.collections.IObservableVector[TimedMetadataTrack]]
    external_timed_text_sources: typing.Optional[winsdk.windows.foundation.collections.IObservableVector[TimedTextSource]]
    is_open: winsdk.system.Boolean
    state: MediaSourceState
    adaptive_media_source: typing.Optional[winsdk.windows.media.streaming.adaptive.AdaptiveMediaSource]
    media_stream_source: typing.Optional[MediaStreamSource]
    mse_stream_source: typing.Optional[MseStreamSource]
    uri: typing.Optional[winsdk.windows.foundation.Uri]
    download_operation: typing.Optional[winsdk.windows.networking.backgroundtransfer.DownloadOperation]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaSource: ...
    def close(self) -> None: ...
    @staticmethod
    def create_from_adaptive_media_source(media_source: typing.Optional[winsdk.windows.media.streaming.adaptive.AdaptiveMediaSource]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_download_operation(download_operation: typing.Optional[winsdk.windows.networking.backgroundtransfer.DownloadOperation]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_i_media_source(media_source: typing.Optional[IMediaSource]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_media_binder(binder: typing.Optional[MediaBinder]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_media_frame_source(frame_source: typing.Optional[winsdk.windows.media.capture.frames.MediaFrameSource]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_media_stream_source(media_source: typing.Optional[MediaStreamSource]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_mse_stream_source(media_source: typing.Optional[MseStreamSource]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_storage_file(file: typing.Optional[winsdk.windows.storage.IStorageFile]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_stream(stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream], content_type: str) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_stream_reference(stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference], content_type: str) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_uri(uri: typing.Optional[winsdk.windows.foundation.Uri]) -> typing.Optional[MediaSource]: ...
    def open_async(self) -> winsdk.windows.foundation.IAsyncAction: ...
    def reset(self) -> None: ...
    def add_open_operation_completed(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaSource, MediaSourceOpenOperationCompletedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_open_operation_completed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_state_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaSource, MediaSourceStateChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_state_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MediaSourceAppServiceConnection(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaSourceAppServiceConnection: ...
    def __new__(cls: typing.Type[MediaSourceAppServiceConnection], app_service_connection: typing.Optional[winsdk.windows.applicationmodel.appservice.AppServiceConnection]) -> MediaSourceAppServiceConnection:...
    def start(self) -> None: ...
    def add_initialize_media_stream_source_requested(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaSourceAppServiceConnection, InitializeMediaStreamSourceRequestedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_initialize_media_stream_source_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MediaSourceError(winsdk.system.Object):
    extended_error: winsdk.windows.foundation.HResult
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaSourceError: ...

class MediaSourceOpenOperationCompletedEventArgs(winsdk.system.Object):
    error: typing.Optional[MediaSourceError]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaSourceOpenOperationCompletedEventArgs: ...

class MediaSourceStateChangedEventArgs(winsdk.system.Object):
    new_state: MediaSourceState
    old_state: MediaSourceState
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaSourceStateChangedEventArgs: ...

class MediaStreamSample(winsdk.system.Object):
    key_frame: winsdk.system.Boolean
    duration: datetime.timedelta
    discontinuous: winsdk.system.Boolean
    decode_timestamp: datetime.timedelta
    buffer: typing.Optional[winsdk.windows.storage.streams.Buffer]
    extended_properties: typing.Optional[MediaStreamSamplePropertySet]
    protection: typing.Optional[MediaStreamSampleProtectionProperties]
    timestamp: datetime.timedelta
    direct3_d11_surface: typing.Optional[winsdk.windows.graphics.directx.direct3d11.IDirect3DSurface]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSample: ...
    @staticmethod
    def create_from_buffer(buffer: typing.Optional[winsdk.windows.storage.streams.IBuffer], timestamp: datetime.timedelta) -> typing.Optional[MediaStreamSample]: ...
    @staticmethod
    def create_from_direct3_d11_surface(surface: typing.Optional[winsdk.windows.graphics.directx.direct3d11.IDirect3DSurface], timestamp: datetime.timedelta) -> typing.Optional[MediaStreamSample]: ...
    @staticmethod
    def create_from_stream_async(stream: typing.Optional[winsdk.windows.storage.streams.IInputStream], count: winsdk.system.UInt32, timestamp: datetime.timedelta) -> winsdk.windows.foundation.IAsyncOperation[MediaStreamSample]: ...
    def add_processed(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaStreamSample, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_processed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MediaStreamSamplePropertySet(winsdk.system.Object, typing.MutableMapping[winsdk.system.Guid, winsdk.system.Object]):
    size: winsdk.system.UInt32
    def __len__(self) -> int: ...
    def __iter__(self) -> typing.Iterator[winsdk.system.Guid]: ...
    def __contains__(self, key: object) -> bool:...
    def __setitem__(self, key: winsdk.system.Guid, value: winsdk.system.Object) -> None: ...
    def __getitem__(self, key: winsdk.system.Guid) -> winsdk.system.Object: ...
    def __delitem__(self, key: winsdk.system.Guid) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSamplePropertySet: ...
    def clear(self) -> None: ...
    def first(self) -> typing.Optional[winsdk.windows.foundation.collections.IIterator[winsdk.windows.foundation.collections.IKeyValuePair[winsdk.system.Guid, winsdk.system.Object]]]: ...
    def get_view(self) -> typing.Optional[winsdk.windows.foundation.collections.IMapView[winsdk.system.Guid, winsdk.system.Object]]: ...
    def has_key(self, key: winsdk.system.Guid) -> winsdk.system.Boolean: ...
    def insert(self, key: winsdk.system.Guid, value: typing.Optional[winsdk.system.Object]) -> winsdk.system.Boolean: ...
    def lookup(self, key: winsdk.system.Guid) -> typing.Optional[winsdk.system.Object]: ...
    def remove(self, key: winsdk.system.Guid) -> None: ...

class MediaStreamSampleProtectionProperties(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSampleProtectionProperties: ...
    def get_initialization_vector(self) -> winsdk.system.Array[winsdk.system.UInt8]: ...
    def get_key_identifier(self) -> winsdk.system.Array[winsdk.system.UInt8]: ...
    def get_sub_sample_mapping(self) -> winsdk.system.Array[winsdk.system.UInt8]: ...
    def set_initialization_vector(self, value: winsdk.system.Array[winsdk.system.UInt8]) -> None: ...
    def set_key_identifier(self, value: winsdk.system.Array[winsdk.system.UInt8]) -> None: ...
    def set_sub_sample_mapping(self, value: winsdk.system.Array[winsdk.system.UInt8]) -> None: ...

class MediaStreamSource(winsdk.system.Object):
    thumbnail: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference]
    media_protection_manager: typing.Optional[winsdk.windows.media.protection.MediaProtectionManager]
    duration: datetime.timedelta
    can_seek: winsdk.system.Boolean
    buffer_time: datetime.timedelta
    music_properties: typing.Optional[winsdk.windows.storage.fileproperties.MusicProperties]
    video_properties: typing.Optional[winsdk.windows.storage.fileproperties.VideoProperties]
    max_supported_playback_rate: typing.Optional[typing.Optional[winsdk.system.Double]]
    is_live: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSource: ...
    @typing.overload
    def __new__(cls: typing.Type[MediaStreamSource], descriptor: typing.Optional[IMediaStreamDescriptor]) -> MediaStreamSource:...
    @typing.overload
    def __new__(cls: typing.Type[MediaStreamSource], descriptor: typing.Optional[IMediaStreamDescriptor], descriptor2: typing.Optional[IMediaStreamDescriptor]) -> MediaStreamSource:...
    def add_protection_key(self, stream_descriptor: typing.Optional[IMediaStreamDescriptor], key_identifier: winsdk.system.Array[winsdk.system.UInt8], license_data: winsdk.system.Array[winsdk.system.UInt8]) -> None: ...
    def add_stream_descriptor(self, descriptor: typing.Optional[IMediaStreamDescriptor]) -> None: ...
    def notify_error(self, error_status: MediaStreamSourceErrorStatus) -> None: ...
    def set_buffered_range(self, start_offset: datetime.timedelta, end_offset: datetime.timedelta) -> None: ...
    def add_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaStreamSource, MediaStreamSourceClosedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_paused(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaStreamSource, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_paused(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_sample_requested(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaStreamSource, MediaStreamSourceSampleRequestedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_sample_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_starting(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaStreamSource, MediaStreamSourceStartingEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_starting(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_switch_streams_requested(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaStreamSource, MediaStreamSourceSwitchStreamsRequestedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_switch_streams_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_sample_rendered(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaStreamSource, MediaStreamSourceSampleRenderedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_sample_rendered(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MediaStreamSourceClosedEventArgs(winsdk.system.Object):
    request: typing.Optional[MediaStreamSourceClosedRequest]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSourceClosedEventArgs: ...

class MediaStreamSourceClosedRequest(winsdk.system.Object):
    reason: MediaStreamSourceClosedReason
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSourceClosedRequest: ...

class MediaStreamSourceSampleRenderedEventArgs(winsdk.system.Object):
    sample_lag: datetime.timedelta
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSourceSampleRenderedEventArgs: ...

class MediaStreamSourceSampleRequest(winsdk.system.Object):
    sample: typing.Optional[MediaStreamSample]
    stream_descriptor: typing.Optional[IMediaStreamDescriptor]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSourceSampleRequest: ...
    def get_deferral(self) -> typing.Optional[MediaStreamSourceSampleRequestDeferral]: ...
    def report_sample_progress(self, progress: winsdk.system.UInt32) -> None: ...

class MediaStreamSourceSampleRequestDeferral(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSourceSampleRequestDeferral: ...
    def complete(self) -> None: ...

class MediaStreamSourceSampleRequestedEventArgs(winsdk.system.Object):
    request: typing.Optional[MediaStreamSourceSampleRequest]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSourceSampleRequestedEventArgs: ...

class MediaStreamSourceStartingEventArgs(winsdk.system.Object):
    request: typing.Optional[MediaStreamSourceStartingRequest]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSourceStartingEventArgs: ...

class MediaStreamSourceStartingRequest(winsdk.system.Object):
    start_position: typing.Optional[typing.Optional[datetime.timedelta]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSourceStartingRequest: ...
    def get_deferral(self) -> typing.Optional[MediaStreamSourceStartingRequestDeferral]: ...
    def set_actual_start_position(self, position: datetime.timedelta) -> None: ...

class MediaStreamSourceStartingRequestDeferral(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSourceStartingRequestDeferral: ...
    def complete(self) -> None: ...

class MediaStreamSourceSwitchStreamsRequest(winsdk.system.Object):
    new_stream_descriptor: typing.Optional[IMediaStreamDescriptor]
    old_stream_descriptor: typing.Optional[IMediaStreamDescriptor]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSourceSwitchStreamsRequest: ...
    def get_deferral(self) -> typing.Optional[MediaStreamSourceSwitchStreamsRequestDeferral]: ...

class MediaStreamSourceSwitchStreamsRequestDeferral(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSourceSwitchStreamsRequestDeferral: ...
    def complete(self) -> None: ...

class MediaStreamSourceSwitchStreamsRequestedEventArgs(winsdk.system.Object):
    request: typing.Optional[MediaStreamSourceSwitchStreamsRequest]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MediaStreamSourceSwitchStreamsRequestedEventArgs: ...

class MseSourceBuffer(winsdk.system.Object):
    timestamp_offset: datetime.timedelta
    mode: MseAppendMode
    append_window_start: datetime.timedelta
    append_window_end: typing.Optional[typing.Optional[datetime.timedelta]]
    buffered: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MseTimeRange]]
    is_updating: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MseSourceBuffer: ...
    def abort(self) -> None: ...
    def append_buffer(self, buffer: typing.Optional[winsdk.windows.storage.streams.IBuffer]) -> None: ...
    @typing.overload
    def append_stream(self, stream: typing.Optional[winsdk.windows.storage.streams.IInputStream]) -> None: ...
    @typing.overload
    def append_stream(self, stream: typing.Optional[winsdk.windows.storage.streams.IInputStream], max_size: winsdk.system.UInt64) -> None: ...
    def remove(self, start: datetime.timedelta, end: typing.Optional[datetime.timedelta]) -> None: ...
    def add_aborted(self, handler: winsdk.windows.foundation.TypedEventHandler[MseSourceBuffer, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_aborted(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_error_occurred(self, handler: winsdk.windows.foundation.TypedEventHandler[MseSourceBuffer, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_error_occurred(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_update_ended(self, handler: winsdk.windows.foundation.TypedEventHandler[MseSourceBuffer, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_update_ended(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_update_starting(self, handler: winsdk.windows.foundation.TypedEventHandler[MseSourceBuffer, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_update_starting(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[MseSourceBuffer, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MseSourceBufferList(winsdk.system.Object):
    buffers: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MseSourceBuffer]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MseSourceBufferList: ...
    def add_source_buffer_added(self, handler: winsdk.windows.foundation.TypedEventHandler[MseSourceBufferList, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_source_buffer_added(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_source_buffer_removed(self, handler: winsdk.windows.foundation.TypedEventHandler[MseSourceBufferList, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_source_buffer_removed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MseStreamSource(winsdk.system.Object):
    duration: typing.Optional[typing.Optional[datetime.timedelta]]
    active_source_buffers: typing.Optional[MseSourceBufferList]
    ready_state: MseReadyState
    source_buffers: typing.Optional[MseSourceBufferList]
    live_seekable_range: typing.Optional[typing.Optional[MseTimeRange]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> MseStreamSource: ...
    def __new__(cls: typing.Type[MseStreamSource]) -> MseStreamSource:...
    def add_source_buffer(self, mime_type: str) -> typing.Optional[MseSourceBuffer]: ...
    def end_of_stream(self, status: MseEndOfStreamStatus) -> None: ...
    @staticmethod
    def is_content_type_supported(content_type: str) -> winsdk.system.Boolean: ...
    def remove_source_buffer(self, buffer: typing.Optional[MseSourceBuffer]) -> None: ...
    def add_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[MseStreamSource, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_ended(self, handler: winsdk.windows.foundation.TypedEventHandler[MseStreamSource, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_ended(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_opened(self, handler: winsdk.windows.foundation.TypedEventHandler[MseStreamSource, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_opened(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class SceneAnalysisEffect(winsdk.system.Object):
    desired_analysis_interval: datetime.timedelta
    high_dynamic_range_analyzer: typing.Optional[HighDynamicRangeControl]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> SceneAnalysisEffect: ...
    def set_properties(self, configuration: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]) -> None: ...
    def add_scene_analyzed(self, handler: winsdk.windows.foundation.TypedEventHandler[SceneAnalysisEffect, SceneAnalyzedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_scene_analyzed(self, cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class SceneAnalysisEffectDefinition(winsdk.system.Object):
    activatable_class_id: str
    properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> SceneAnalysisEffectDefinition: ...
    def __new__(cls: typing.Type[SceneAnalysisEffectDefinition]) -> SceneAnalysisEffectDefinition:...

class SceneAnalysisEffectFrame(winsdk.system.Object):
    frame_control_values: typing.Optional[winsdk.windows.media.capture.CapturedFrameControlValues]
    high_dynamic_range: typing.Optional[HighDynamicRangeOutput]
    analysis_recommendation: SceneAnalysisRecommendation
    system_relative_time: typing.Optional[typing.Optional[datetime.timedelta]]
    relative_time: typing.Optional[typing.Optional[datetime.timedelta]]
    is_discontinuous: winsdk.system.Boolean
    duration: typing.Optional[typing.Optional[datetime.timedelta]]
    extended_properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    is_read_only: winsdk.system.Boolean
    type: str
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object) -> SceneAnalysisEffectFrame: ...
    def close(self) -> None: ...

class SceneAnalyzedEventArgs(winsdk.system.Object):
    result_frame: typing.Optional[SceneAnalysisEffectFrame]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> SceneAnalyzedEventArgs: ...

class SpeechCue(winsdk.system.Object):
    start_time: datetime.timedelta
    id: str
    duration: datetime.timedelta
    text: str
    start_position_in_input: typing.Optional[typing.Optional[winsdk.system.Int32]]
    end_position_in_input: typing.Optional[typing.Optional[winsdk.system.Int32]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> SpeechCue: ...
    def __new__(cls: typing.Type[SpeechCue]) -> SpeechCue:...

class TimedMetadataStreamDescriptor(winsdk.system.Object):
    name: str
    language: str
    is_selected: winsdk.system.Boolean
    label: str
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.TimedMetadataEncodingProperties]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TimedMetadataStreamDescriptor: ...
    def __new__(cls: typing.Type[TimedMetadataStreamDescriptor], encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.TimedMetadataEncodingProperties]) -> TimedMetadataStreamDescriptor:...
    def copy(self) -> typing.Optional[TimedMetadataStreamDescriptor]: ...

class TimedMetadataTrack(winsdk.system.Object):
    label: str
    id: str
    language: str
    track_kind: MediaTrackKind
    active_cues: typing.Optional[winsdk.windows.foundation.collections.IVectorView[IMediaCue]]
    cues: typing.Optional[winsdk.windows.foundation.collections.IVectorView[IMediaCue]]
    dispatch_type: str
    timed_metadata_kind: TimedMetadataKind
    name: str
    playback_item: typing.Optional[winsdk.windows.media.playback.MediaPlaybackItem]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TimedMetadataTrack: ...
    def __new__(cls: typing.Type[TimedMetadataTrack], id: str, language: str, kind: TimedMetadataKind) -> TimedMetadataTrack:...
    def add_cue(self, cue: typing.Optional[IMediaCue]) -> None: ...
    def remove_cue(self, cue: typing.Optional[IMediaCue]) -> None: ...
    def add_cue_entered(self, handler: winsdk.windows.foundation.TypedEventHandler[TimedMetadataTrack, MediaCueEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_cue_entered(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_cue_exited(self, handler: winsdk.windows.foundation.TypedEventHandler[TimedMetadataTrack, MediaCueEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_cue_exited(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_track_failed(self, handler: winsdk.windows.foundation.TypedEventHandler[TimedMetadataTrack, TimedMetadataTrackFailedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_track_failed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class TimedMetadataTrackError(winsdk.system.Object):
    error_code: TimedMetadataTrackErrorCode
    extended_error: winsdk.windows.foundation.HResult
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TimedMetadataTrackError: ...

class TimedMetadataTrackFailedEventArgs(winsdk.system.Object):
    error: typing.Optional[TimedMetadataTrackError]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TimedMetadataTrackFailedEventArgs: ...

class TimedTextBouten(winsdk.system.Object):
    type: TimedTextBoutenType
    position: TimedTextBoutenPosition
    color: winsdk.windows.ui.Color
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TimedTextBouten: ...

class TimedTextCue(winsdk.system.Object):
    start_time: datetime.timedelta
    id: str
    duration: datetime.timedelta
    cue_style: typing.Optional[TimedTextStyle]
    cue_region: typing.Optional[TimedTextRegion]
    lines: typing.Optional[winsdk.windows.foundation.collections.IVector[TimedTextLine]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TimedTextCue: ...
    def __new__(cls: typing.Type[TimedTextCue]) -> TimedTextCue:...

class TimedTextLine(winsdk.system.Object):
    text: str
    subformats: typing.Optional[winsdk.windows.foundation.collections.IVector[TimedTextSubformat]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TimedTextLine: ...
    def __new__(cls: typing.Type[TimedTextLine]) -> TimedTextLine:...

class TimedTextRegion(winsdk.system.Object):
    name: str
    line_height: TimedTextDouble
    is_overflow_clipped: winsdk.system.Boolean
    extent: TimedTextSize
    display_alignment: TimedTextDisplayAlignment
    padding: TimedTextPadding
    background: winsdk.windows.ui.Color
    z_index: winsdk.system.Int32
    writing_mode: TimedTextWritingMode
    text_wrapping: TimedTextWrapping
    scroll_mode: TimedTextScrollMode
    position: TimedTextPoint
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TimedTextRegion: ...
    def __new__(cls: typing.Type[TimedTextRegion]) -> TimedTextRegion:...

class TimedTextRuby(winsdk.system.Object):
    text: str
    reserve: TimedTextRubyReserve
    position: TimedTextRubyPosition
    align: TimedTextRubyAlign
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TimedTextRuby: ...

class TimedTextSource(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TimedTextSource: ...
    @typing.overload
    @staticmethod
    def create_from_stream(stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream]) -> typing.Optional[TimedTextSource]: ...
    @typing.overload
    @staticmethod
    def create_from_stream(stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream], default_language: str) -> typing.Optional[TimedTextSource]: ...
    @typing.overload
    @staticmethod
    def create_from_stream_with_index(stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream], index_stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream]) -> typing.Optional[TimedTextSource]: ...
    @typing.overload
    @staticmethod
    def create_from_stream_with_index(stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream], index_stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream], default_language: str) -> typing.Optional[TimedTextSource]: ...
    @typing.overload
    @staticmethod
    def create_from_uri(uri: typing.Optional[winsdk.windows.foundation.Uri]) -> typing.Optional[TimedTextSource]: ...
    @typing.overload
    @staticmethod
    def create_from_uri(uri: typing.Optional[winsdk.windows.foundation.Uri], default_language: str) -> typing.Optional[TimedTextSource]: ...
    @typing.overload
    @staticmethod
    def create_from_uri_with_index(uri: typing.Optional[winsdk.windows.foundation.Uri], index_uri: typing.Optional[winsdk.windows.foundation.Uri]) -> typing.Optional[TimedTextSource]: ...
    @typing.overload
    @staticmethod
    def create_from_uri_with_index(uri: typing.Optional[winsdk.windows.foundation.Uri], index_uri: typing.Optional[winsdk.windows.foundation.Uri], default_language: str) -> typing.Optional[TimedTextSource]: ...
    def add_resolved(self, handler: winsdk.windows.foundation.TypedEventHandler[TimedTextSource, TimedTextSourceResolveResultEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_resolved(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class TimedTextSourceResolveResultEventArgs(winsdk.system.Object):
    error: typing.Optional[TimedMetadataTrackError]
    tracks: typing.Optional[winsdk.windows.foundation.collections.IVectorView[TimedMetadataTrack]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TimedTextSourceResolveResultEventArgs: ...

class TimedTextStyle(winsdk.system.Object):
    line_alignment: TimedTextLineAlignment
    is_background_always_shown: winsdk.system.Boolean
    outline_color: winsdk.windows.ui.Color
    foreground: winsdk.windows.ui.Color
    font_weight: TimedTextWeight
    background: winsdk.windows.ui.Color
    font_size: TimedTextDouble
    font_family: str
    flow_direction: TimedTextFlowDirection
    outline_thickness: TimedTextDouble
    outline_radius: TimedTextDouble
    name: str
    is_underline_enabled: winsdk.system.Boolean
    is_overline_enabled: winsdk.system.Boolean
    is_line_through_enabled: winsdk.system.Boolean
    font_style: TimedTextFontStyle
    is_text_combined: winsdk.system.Boolean
    font_angle_in_degrees: winsdk.system.Double
    bouten: typing.Optional[TimedTextBouten]
    ruby: typing.Optional[TimedTextRuby]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TimedTextStyle: ...
    def __new__(cls: typing.Type[TimedTextStyle]) -> TimedTextStyle:...

class TimedTextSubformat(winsdk.system.Object):
    subformat_style: typing.Optional[TimedTextStyle]
    start_index: winsdk.system.Int32
    length: winsdk.system.Int32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> TimedTextSubformat: ...
    def __new__(cls: typing.Type[TimedTextSubformat]) -> TimedTextSubformat:...

class VideoStabilizationEffect(winsdk.system.Object):
    enabled: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object) -> VideoStabilizationEffect: ...
    def get_recommended_stream_configuration(self, controller: typing.Optional[winsdk.windows.media.devices.VideoDeviceController], desired_properties: typing.Optional[winsdk.windows.media.mediaproperties.VideoEncodingProperties]) -> typing.Optional[winsdk.windows.media.capture.VideoStreamConfiguration]: ...
    def set_properties(self, configuration: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]) -> None: ...
    def add_enabled_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[VideoStabilizationEffect, VideoStabilizationEffectEnabledChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_enabled_changed(self, cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class VideoStabilizationEffectDefinition(winsdk.system.Object):
    activatable_class_id: str
    properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> VideoStabilizationEffectDefinition: ...
    def __new__(cls: typing.Type[VideoStabilizationEffectDefinition]) -> VideoStabilizationEffectDefinition:...

class VideoStabilizationEffectEnabledChangedEventArgs(winsdk.system.Object):
    reason: VideoStabilizationEffectEnabledChangedReason
    @staticmethod
    def _from(obj: winsdk.system.Object) -> VideoStabilizationEffectEnabledChangedEventArgs: ...

class VideoStreamDescriptor(winsdk.system.Object):
    name: str
    language: str
    is_selected: winsdk.system.Boolean
    label: str
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.VideoEncodingProperties]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> VideoStreamDescriptor: ...
    def __new__(cls: typing.Type[VideoStreamDescriptor], encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.VideoEncodingProperties]) -> VideoStreamDescriptor:...
    def copy(self) -> typing.Optional[VideoStreamDescriptor]: ...

class VideoTrack(winsdk.system.Object):
    label: str
    id: str
    language: str
    track_kind: MediaTrackKind
    name: str
    playback_item: typing.Optional[winsdk.windows.media.playback.MediaPlaybackItem]
    support_info: typing.Optional[VideoTrackSupportInfo]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> VideoTrack: ...
    def get_encoding_properties(self) -> typing.Optional[winsdk.windows.media.mediaproperties.VideoEncodingProperties]: ...
    def add_open_failed(self, handler: winsdk.windows.foundation.TypedEventHandler[VideoTrack, VideoTrackOpenFailedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_open_failed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class VideoTrackOpenFailedEventArgs(winsdk.system.Object):
    extended_error: winsdk.windows.foundation.HResult
    @staticmethod
    def _from(obj: winsdk.system.Object) -> VideoTrackOpenFailedEventArgs: ...

class VideoTrackSupportInfo(winsdk.system.Object):
    decoder_status: MediaDecoderStatus
    media_source_status: MediaSourceStatus
    @staticmethod
    def _from(obj: winsdk.system.Object) -> VideoTrackSupportInfo: ...

class IMediaCue(winsdk.system.Object):
    duration: datetime.timedelta
    id: str
    start_time: datetime.timedelta
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IMediaCue: ...

class IMediaSource(winsdk.system.Object):
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IMediaSource: ...

class IMediaStreamDescriptor(winsdk.system.Object):
    is_selected: winsdk.system.Boolean
    language: str
    name: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IMediaStreamDescriptor: ...

class IMediaStreamDescriptor2(winsdk.system.Object):
    label: str
    is_selected: winsdk.system.Boolean
    language: str
    name: str
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IMediaStreamDescriptor2: ...

class IMediaTrack(winsdk.system.Object):
    id: str
    label: str
    language: str
    track_kind: MediaTrackKind
    @staticmethod
    def _from(obj: winsdk.system.Object) -> IMediaTrack: ...

class ISingleSelectMediaTrackList(winsdk.system.Object):
    selected_index: winsdk.system.Int32
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ISingleSelectMediaTrackList: ...
    def add_selected_index_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[ISingleSelectMediaTrackList, winsdk.system.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_selected_index_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ITimedMetadataTrackProvider(winsdk.system.Object):
    timed_metadata_tracks: typing.Optional[winsdk.windows.foundation.collections.IVectorView[TimedMetadataTrack]]
    @staticmethod
    def _from(obj: winsdk.system.Object) -> ITimedMetadataTrackProvider: ...

