
# -*- python; coding: utf-8 -*-
#
# gtk-doc - GTK DocBook documentation generator.
# Copyright (C) 1998 Owen Taylor
#               2001-2005 Damon Chaplin
#               2009-2017  Stefan Sauer
#               2017  Jussi Pakkanen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#

import argparse
import sys

try:
  import gtkdoc_uninstalled
except ModuleNotFoundError:
  sys.path.append(sys.prefix + '/share/gtk-doc/python')

from gtkdoc import common, config, mkhtml

if __name__ == '__main__':
    parser = argparse.ArgumentParser(
        description='gtkdoc-mkhtml version %s - generate documentation in html format' % config.version)
    parser.add_argument('--version', action='version', version=config.version)
    parser.add_argument('--verbose', default=False, action='store_true',
                        help='Print extra output while processing')
    parser.add_argument('--path', default=[], action='append',
                        help='Extra source directories')
    parser.add_argument('args', nargs='*',
                        help='MODULE DRIVER_FILE')
    # TODO: only for testing, replace with env-var
    parser.add_argument('--uninstalled', action='store_true', default=False,
                        help='???')

    options = parser.parse_args()
    if len(options.args) < 2:
        sys.exit('Too few arguments')

    common.setup_logging()

    sys.exit(mkhtml.run(options))
