The `@Behaviour` keyword declares the behaviour used for the
test.

This keyword may be followed by two options:

- the name of the interface to be used.
- a behaviour wrapper.

Two strings are then expected:

- the library in which the behaviour is implemented;
- the name of the function.

Sometimes, additional parameters must be given, in particular for
interfaces to behaviours not generated by `MFront`.

## Available interfaces

The following interfaces are supported for `MFront`
generated behaviours:

- `castem` (`umat`)
- `cyrano`
- `aster`
- `generic`
- `dianafea`
- `europlexus` (`epx`)
- `abaqus` (`abaqus_standard` or `abaqus_umat`)
- `abaqus_explicit` (`abaqus_vumat`)

Some interfaces are also available for behaviours not generated by
`MFront`:

- `mistral`
- `castem_umat_small_strain`
- `castem_umat_finite_strain`

## Available behaviour wrappers

Currently, two behaviours wrappers are available:

- `LogarithmicStrain1D`: which turns a small strain behaviour in
  axisymmetrical generalised plane strain into a finite strain behaviour
  in the logarithmic strain framework following the ETO-PK1 kinematic
  assumption used by the `MTest` for the simulation of pipe in finite
  strain.
- `SmallStrainTridimensionalBehaviourWrapper` which allows to use a
  small strain tridimensional behaviour under the following modelling
  hypotheses: axisymmetrical generalised plane strain, plane strain,
  axisymmetry.

## Example

~~~~ {.cpp}
@Behaviour<castem> 'libMFrontCastemBehaviours.so' 'umatnorton';
~~~~~~~~

~~~~ {.cpp}
@Behaviour<mistral> 'SOURCES/libumat.so' 'umat_' {
 'mistral_parameters_file' : 'M5CC_par.txt',
 'SENSIP1':1,
 'SENSIP2':3,
 'ICBASE' :0};
~~~~~~~~

~~~~ {.cpp}
@Behaviour<castem_umat_small_strain> './libumat.so' 'umat_'{
 'NUME_LOI'   : 10,
 'SYMETRIE'   : 'ISOTROPE',
 'C_MATERIAU' : {'YOUNG','NU'}
};
~~~~~~~~
